##Importa Datat----------------------------
library(RVAideMemoire);
library(ggplot2);
library(ggpubr);
library(multcompView);
library(tidyverse);
library(rcompanion);

Data <- read.csv(file = "behaviur.csv", header=TRUE)
row.names(Data) <- Data$Thesis
#NOF non oriented flights
#OF oriented flights
#TNF Tested without oriented flight
#LS landigs

#split the data in to the figure panel
DataA <- subset(Data, Data$Panel=="A") #PanelA
DataB <- subset(Data, Data$Panel=="B") #PanelB
DataC <- subset(Data, Data$Panel=="C") #PanelC
DataD <- subset(Data, Data$Panel=="D") #PanelD
DataFH <- subset(Data, Data$Panel=="E") #PanelF Hydroponic
DataFS <- subset(Data, Data$Panel=="F") #PanelF Soil

#PanelA------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataA[,c(3,4)]))
comparisonAO <- pairwise.G.test(as.matrix(DataA[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonAO$p.value),
                          compare="<",
                          threshold=0.05,
                          Letters=letters,
                          reversed = FALSE)
DataA$labeloriented <- group$Letters

#landend on source TNF vc LS
G.test(as.matrix(DataA[,c(5,6)]))
comparisonAL <- pairwise.G.test(as.matrix(DataA[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonAL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataA$labellandings <- group$Letters


#PanelB------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataB[,c(3,4)]))
comparisonBO <- pairwise.G.test(as.matrix(DataB[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonBO$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataB$labeloriented <- group$Letters

#landend on source TNF vc LS
G.test(as.matrix(DataB[,c(5,6)]))
comparisonBL <- pairwise.G.test(as.matrix(DataB[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonBL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataB$labellandings <- group$Letters

#PanelC------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataC[,c(3,4)]))
comparisonCO <- pairwise.G.test(as.matrix(DataC[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonCO$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataC$labeloriented <- group$Letters

#landend on source TNF vc LS
G.test(as.matrix(DataC[,c(5,6)]))
comparisonCL <- pairwise.G.test(as.matrix(DataC[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonCL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataC$labellandings <- group$Letters

#PanelD------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataD[,c(3,4)]))
comparisonDO <- pairwise.G.test(as.matrix(DataD[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonDO$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataD$labeloriented <- group$Letters



#landend on source TNF vc LS
G.test(as.matrix(DataD[,c(5,6)]))
comparisonDL <- pairwise.G.test(as.matrix(DataD[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonDL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataD$labellandings <- group$Letters





#PanelFH Hydroponic------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataFH[,c(3,4)]))
comparisonFHO <- pairwise.G.test(as.matrix(DataFH[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonFHO$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataFH$labeloriented <- group$Letters

#landend on source TNF vc LS
G.test(as.matrix(DataFH[,c(5,6)]))
comparisonFHL <- pairwise.G.test(as.matrix(DataFH[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonFHL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataFH$labellandings <- group$Letters

#PanelFS Soil------------------------------
#oriented flight NOF vc OF
G.test(as.matrix(DataFS[,c(3,4)]))
comparisonFSO <- pairwise.G.test(as.matrix(DataFS[,c(3,4)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonFSO$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataFS$labeloriented <- group$Letters

#landend on source TNF vc LS
G.test(as.matrix(DataFS[,c(5,6)]))
comparisonFSL <- pairwise.G.test(as.matrix(DataFS[,c(5,6)]), p.method = "none")
group <- multcompLetters(fullPTable(comparisonFSL$p.value),
                         compare="<",
                         threshold=0.05,
                         Letters=letters,
                         reversed = FALSE)
DataFS$labellandings <- group$Letters


##make datatabase---------------
datasetgraph<- rbind(DataA,DataB,DataC,DataD,DataFH,DataFS)
datasetgraph$Oriented <- datasetgraph$OF/datasetgraph$TNF
datasetgraph$Landings <- datasetgraph$LS/datasetgraph$TNF

ggplot(data = datasetgraph, aes(x=as.factor(Thesis),y=Oriented*100,label=labeloriented))+ 
  geom_segment(size = 10,aes(x=as.factor(Thesis), y=Oriented*100, xend = as.factor(Thesis), yend = 0))+
  facet_grid(~Panel,scales = "free_x", space='free')+
  geom_text(stat="identity", vjust=-0.5, aes(y=Oriented*100),size=7)+
  scale_y_continuous(breaks = c(0,25,50,75), limits = c(0,80), expand = c(0,0), label = c("", "25%","50%","75%"))+
  theme_bw()+
  theme(axis.text = element_text(face="bold"),
        axis.text.x = element_text(angle = 45, vjust = 0.5),
        panel.grid = element_blank(),
        strip.background = element_blank(),
        strip.text.x = element_blank(),
        text = element_text(size = 30))

ggsave("Oriented.svg", device="svg", last_plot(), width = 400, height=130, units="mm", dpi = 600)

ggplot(data = datasetgraph, aes(x=as.factor(Thesis),y=Landings*100,label=labellandings))+ 
  geom_segment(size = 10,aes(x=as.factor(Thesis), y=Landings*100, xend = as.factor(Thesis), yend = 0))+
  facet_grid(~Panel,scales = "free_x", space='free')+
  geom_text(stat="identity", vjust=-0.5, aes(y=Landings*100), size=7)+
  scale_y_continuous(breaks = c(0,25,50), limits = c(0,60), expand = c(0,0), label = c("", "25%","50%"))+
  theme_bw()+
  theme(axis.text = element_text(face="bold"),
        axis.text.x = element_text(angle = 45, vjust = 0.5),
        panel.grid = element_blank(),
        strip.background = element_blank(),
        strip.text.x = element_blank(),
        text = element_text(size = 30))

ggsave("Landed.svg", device="svg",last_plot(), width = 400, height=130, units="mm", dpi = 600)

#svg image were post-edited in inkscape to obain the Figure 1
##Information to cite in the manuscript-------------------------------
#line2016
comparisonBO
comparisonBO$p.value[1,1] #to cite in the text p-value
qchisq((1-comparisonBO$p.value[1,1]), df=1) #to cite in the text chi-value

#line216
comparisonBL
comparisonBL$p.value[1,1] #to cite in the text p-value
qchisq((1-comparisonBL$p.value[1,1]), df=1) #to cite in the text chi-value

#line221
comparisonCO
comparisonCO$p.value[1,1] #to cite in the text p-value P vs F1
qchisq((1-comparisonCO$p.value[1,1]), df=1) #to cite in the text chi-value

comparisonCL
comparisonCL$p.value[1,1] #to cite in the text p-value P vs F1
qchisq((1-comparisonCL$p.value[1,1]), df=1) #to cite in the text chi-value


#line223 synergistic effect
comparisonCO
comparisonCO$p.value[5,2] #to cite in the text p-value F1 vs F1+2+3
qchisq((1-comparisonCO$p.value[5,2]), df=1) #to cite in the text chi-value

#line223 synergistic effect
comparisonCL
comparisonCL$p.value[5,2] #to cite in the text p-value F1 vs F1+2+3
qchisq((1-comparisonCL$p.value[5,2]), df=1) #to cite in the text chi-value

#line226
comparisonDO
comparisonDO$p.value[1,1] #to cite in the text p-value P vs F1a
qchisq((1-comparisonDO$p.value[1,1]), df=1) #to cite in the text chi-value

comparisonDO
comparisonDO$p.value[4,1] #to cite in the text p-value P vs F1d
qchisq((1-comparisonDO$p.value[4,1]), df=1) #to cite in the text chi-value

#line227
comparisonDL
comparisonDL$p.value[1,1] #to cite in the text p-value P vs F1a
qchisq((1-comparisonDL$p.value[1,1]), df=1) #to cite in the text chi-value

comparisonDL
comparisonDL$p.value[4,1] #to cite in the text p-value P vs F1d
qchisq((1-comparisonDL$p.value[4,1]), df=1) #to cite in the text chi-value

#line231
comparisonFHO
comparisonFHO$p.value[4,1] #to cite in the text p-value Ethanolo vs (L) 0.1ppm
qchisq((1-comparisonFHO$p.value[4,1]), df=1) #to cite in the text chi-value

comparisonFHL
comparisonFHL$p.value[4,1] #to cite in the text p-value Ethanolo vs (L) 0.1ppm
qchisq((1-comparisonFHL$p.value[4,1]), df=1) #to cite in the text chi-value

#line234
comparisonFHO
comparisonFHO$p.value[4,3] #to cite in the text p-value (L) 0.01ppm vs (L) 0.1ppm
qchisq((1-comparisonFHO$p.value[4,3]), df=1) #to cite in the text chi-value

#line235
comparisonFHL
comparisonFHL$p.value[4,3] #to cite in the text p-value (L) 0.01ppm vs (L) 0.1ppm
qchisq((1-comparisonFHL$p.value[4,3]), df=1) #to cite in the text chi-value

#line238
comparisonFSO
comparisonFHO$p.value[2,1] #to cite in the text p-value Ethanol vs (L) 
qchisq((1-comparisonFHO$p.value[2,1]), df=1) #to cite in the text chi-value

comparisonFSL
comparisonFHL$p.value[2,1] #to cite in the text p-value Ethanol vs (L) 
qchisq((1-comparisonFHL$p.value[2,1]), df=1) #to cite in the text chi-value
