#import VOCs
library(vegan)
tab<-read.csv(file="data.csv", sep=",", na.strings = "NA", stringsAsFactors=FALSE)
names(tab)
tab$Treatment<- as.factor(tab$Treatment)


###remane VOCs
names(tab)[2:10] <- c("(Z)-3-hexenyl acetate", 
                      "6-methyl-5-hepten-2-one", 
                      "(Z)-3-hexen-1-ol", 
                      "(E)-ocimene",
                      "linalool",
                      "(E)-DMNT",
                      "methylsalicilate",
                      "(E)-β-caryophyllene",
                      "(E)-β-farnesene")


###stats
rankindex(tab$Treatment,log(tab[,c(2:10)]+0.1), indices = c("euc", "man", "gow", "bra", "kul"),stepacross= FALSE, method = "spearman")
dbRDA=capscale(log(tab[,c(2:10)]+0.1) ~ Treatment,tab, dist="gow")
anova(dbRDA) #reported at line 237 (Fig. 2; ANOVA based on 999 permutations, F2,24 = 2.08, p = 0.034). 

fit<-glm(log(Amount+1)~Treatment*VOCs, data = mvocs, family = poisson())
Anova(fit) #reported at line 239 (Fig. 3; Analysis of Deviance on Type II errors, VOCs effect; LR 8 = 156.763, p< 0.001
