#!/usr/bin/perl -w 
use strict ;
use FileHandle ;
use Getopt::Long;
use Cwd ;
use MyUtils;
use ConfigPDB;
use MyGeom;

use POSIX qw(floor);
my $commandline = util_get_cmdline("",\@ARGV) ;
my ($reverse,$infile,$outfile,$which_tech,$listfile);
my (@expressions);
my $idx = 0;
GetOptions(
            "which_tech=s"=>\$which_tech ,
            "infile=s"=>\$infile ,
            "reverse"=>\$reverse ,
            "listfile=s"=>\$listfile ,
            "outfile=s"=>\$outfile ,
            "expr=s"=>\@expressions,
            "idx=i"=>\$idx ,
           );
die "Dont recognize command line arg @ARGV " if(@ARGV);
usage( "Need to give a output file name => option -outfile ") if(!defined $outfile);
my $ofh = util_write($outfile);
usage( "Need to give a input file name => option -infile ") if(!defined $infile);
my $ifh = util_read($infile);
my $ofh = util_write($outfile);
my $CNT = 0 ; 
my ($RESULTDIR,$PDBDIR,$FASTADIR) = util_SetEnvVars();


my $numbers  = {};
while(<$ifh>){
     next if(/^\s*$/);
	 my (@l) = split ;
	  $numbers->{$l[$idx]} = [] if(!defined  $numbers->{$l[$idx]});
	 push @{$numbers->{$l[$idx]}}, $_ ;
}
close($ifh);


if(!defined $reverse){
    foreach my $i (sort {$a <=> $b} keys %{$numbers}){
        print $ofh @{$numbers->{$i}};
    }
}
else{
    foreach my $i (sort {$b <=> $a} keys %{$numbers}){
        print $ofh @{$numbers->{$i}};
    }
}
print STDERR "Output written in $outfile\n";

chmod 0777, $outfile ;
sub usage{
    my ($msg) = @_ ;
    print $msg , "\n" ; 
print << "ENDOFUSAGE" ; 
ENDOFUSAGE
    die ;
}
