import pickle

import scipy.sparse.linalg
import time
from common.transfer_operator import transfer_operator_arbitrary
import matplotlib.pyplot as plt


test_problem = 'SPE10'

# Load test problem, necessary FE data and high-fidelity solution:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
FE_solution = FE_results['FE_solution']
mass_bc = FE_results['mass']
stiff_bc = FE_results['stiff']
stiffs_coeff_in_time_bc = FE_results['stiffs_coeff_in_time']
rhs_matrix = FE_results['rhs_matrix']
grid_t = FE_results['grid_t']
ht = grid_t[1]-grid_t[0]
T_start = grid_t[0]
T_finish = grid_t[-1]
nt = len(grid_t) - 1
u_0 = FE_results['u0_discrete']

#Precomputations:
lhs_solves = []
for t in range(*(1,nt+1)):
   stiffness_temp = stiffs_coeff_in_time_bc[t]
   matrix_left_temp = mass_bc + ht * stiffness_temp
   lhs_solve_temp = scipy.sparse.linalg.factorized(matrix_left_temp.tocsc())
   lhs_solves.append(lhs_solve_temp)

start_int_list = [100,140,450]
end_int_list = [115,155,465]

plt.figure()
for aux in range(3):
   start_int = start_int_list[aux]
   end_int = end_int_list[aux]
   # Choose tolerance for approximation error and resulting reduced dimension:
   tol_trans = 1e-08
   # Run transfer eigenvalue problem:
   tic = time.time()
   singular_vals, _ = transfer_operator_arbitrary(mass_bc,lhs_solves,rhs_matrix,grid_t,start_int,end_int,tol_trans)
   toc = time.time()
   print(f'Transfer operator computed in {(toc-tic)/60} minutes.')
   start_time = start_int*ht
   end_time = end_int*ht
   plt.semilogy(singular_vals[:40],label=f'singular values {start_time:.1f} --> {end_time:.1f}')

plt.legend()
plt.show()