import pickle
import numpy as np
import matplotlib.pyplot as plt


test_problem = 'SPE10'
model = 'leverage'

# Parameters:
iterations = 25000
n_rand_rhs = 10
n_rand_coeff = 10
nt_rand = 15
k = 13
tol = 1e-08

# Load data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
grid_t = FE_results['grid_t']

# Load results:
rel_L2_errors_POD = np.load('results/POD_SPE10_on_315_of_500_rel_L2_error_over_time.npy')

dirname = 'results_problem='+test_problem +'_model='+model
results = pickle.load(open(dirname+f'/iterations={iterations}_nrand_rhs={n_rand_rhs}_n_rand_coeff={n_rand_coeff}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))
rel_L2_errors_over_time = results['rel_L2_errors_over_time']

plt.figure(figsize=plt.figaspect(0.7))
plt.semilogy(grid_t, rel_L2_errors_POD, label='POD',linewidth=1)
plt.semilogy(grid_t,rel_L2_errors_over_time[14246,:],label = 'random',linewidth = 1)
plt.legend()
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.show()


### Comment: Unfortunately, it was not able to reproduce exactly the same plot and realization as in Figure 14 right,
### but the result shown here is very similar.