import pickle
import numpy as np
import matplotlib.pyplot as plt


test_problem = 'SPE10'
model = 'leverage'

# directory for loading results:
dirname = 'results_problem='+test_problem +'_model='+model

# tested parameters:
n_rand_rhs = 10
n_rand_coeff = 10
tol = 10**(-8)
iterations = 25000
nt_rand_list = [10,15,20,25]
k_list = [8,13,18,23]

# choose error for plot:
#which_error_plot = 'red_bases_sizes'
#error_title = 'number of chosen basis functions'
#which_error_plot = 'rel_C0_L2_errors'
#error_title = 'relative C0(L2)-error'
which_error_plot = 'rel_L2_H1_errors'
error_title = 'relative L2(H1)-error'
#which_error_plot = 'rel_L2_errors_max_time'
#error_title = 'max(t) relative L2(t)-error'


quantiles = np.zeros((10,len(k_list)))
aux = 0
for k in k_list:
    nt_rand = nt_rand_list[aux]
    results = pickle.load(open(dirname+f'/iterations={iterations}_nrand_rhs={n_rand_rhs}_n_rand_coeff={n_rand_coeff}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))

    errors = np.sort(results[which_error_plot])

    quantiles[0,aux] = errors[-1]
    if nt_rand == 25:
        quantiles[0,aux] = errors[-2]
    quantiles[1,aux] = errors[int(9700*2.5-1)]
    quantiles[2,aux] = errors[int(8800*2.5-1)]
    quantiles[3,aux] = errors[int(7500*2.5-1)]
    quantiles[4,aux] = errors[int(6000*2.5-1)]
    quantiles[5,aux] = errors[int(5000*2.5-1)]
    quantiles[6,aux] = errors[int(4000*2.5-1)]
    quantiles[7,aux] = errors[int(2500*2.5-1)]
    quantiles[8,aux] = errors[int(500*2.5-1)]
    quantiles[9,aux] = errors[0]

    aux += 1


plt.figure(figsize=plt.figaspect(0.9))
plt.semilogy(quantiles[0,:], marker =11,label = 'max',linestyle = 'None',color='tab:blue')
plt.semilogy(quantiles[1,:],marker = '*',label = '97',linestyle = 'None',color='tab:purple')
plt.semilogy(quantiles[2,:],marker = 'P',label = '88',linestyle = 'None',color='tab:orange')
plt.semilogy(quantiles[3,:],marker = 'p',label = '75',linestyle = 'None',color='tab:cyan')
plt.semilogy(quantiles[4,:],marker = 'd',label = '60',linestyle = 'None',color='tab:red')
plt.semilogy(quantiles[5,:],marker = '*',label = '50',linestyle = 'None',color='b')
plt.semilogy(quantiles[6,:],marker = 'p',label = '40',linestyle = 'None',color='tab:green')
plt.semilogy(quantiles[7,:],marker = 'x',label = '25',linestyle = 'None',color='tab:brown')
plt.semilogy(quantiles[8,:],marker = 'P',label = '5',linestyle = 'None',color='tab:pink')
plt.semilogy(quantiles[9,:],marker = 10,label = 'min',linestyle = 'None',color='tab:blue')

aux_x = np.arange(len(k_list))
plt.xticks(aux_x,nt_rand_list)
plt.xlim(-0.5,len(k_list)+0.5)
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.title(error_title)
plt.legend()

plt.show()