import pickle
from common.compute_probabilities import compute_leverage_scores
import matplotlib.pyplot as plt


### This file computes and plots the leverage scores of the coefficient and the right hand side matrix for Experiment 4.


test_problem = 'SPE10'

# Load test problem and necessary data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
rhs_matrix = FE_results['rhs_matrix']
alpha_matrix = FE_results['alpha_matrix']
grid_t = FE_results['grid_t']

# Compute and plot leverage scores:
k_rhs = 1
leverage_scores_rhs = compute_leverage_scores(rhs_matrix,k_rhs)
k_alpha = 3
leverage_scores_alpha = compute_leverage_scores(alpha_matrix,k_alpha)

# Draw random points from the leverage scores as probability distribution:
plt.figure(figsize=plt.figaspect(0.6))
plt.plot(grid_t,leverage_scores_rhs,label='LS rhs')
plt.plot(grid_t,leverage_scores_alpha,label='LS coefficient')
plt.legend()
plt.xlabel('time')
plt.show()
