import pickle
import scipy.io
import numpy as np
import matplotlib.pyplot as plt


### This file visualizes the SPE10 permeability coefficient and the high fidelity FE solution.

test_problem = 'SPE10'

# Load necessary FE data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
FE_solution = FE_results['FE_solution']
grid_x = FE_results['grid_x']
grid_y = FE_results['grid_y']

# Plot SPE10 permeability coefficient:
SPE10_coeff_matrix = scipy.io.loadmat('perm_40.mat')['perm']
plt.matshow(np.log10(SPE10_coeff_matrix)[::-1])
plt.set_cmap('turbo')
cbar = plt.colorbar(fraction=0.026, pad=0.005,aspect=10)
for t in cbar.ax.get_yticklabels():
    t.set_fontsize(25)
plt.axis('off')
plt.show()

# Plot FE solution at certain time points:
time_points = [5,100,200,380,475]
X,Y = np.meshgrid(grid_x,grid_y)

for j in time_points:
    FE_solution_temp = FE_solution[:,j].reshape(len(grid_y)-1,len(grid_x))
    # Add homogeneous Dirichlet boundary conditions:
    aux_1 = np.zeros((1,len(grid_x)))
    FE_solution_temp = np.vstack((aux_1,FE_solution_temp))

    plt.matshow(np.log10(FE_solution_temp)[::-1])
    plt.set_cmap('turbo')
    cbar = plt.colorbar(fraction=0.026, pad=0.005,aspect=10)
    if j == 380:
        plt.clim(2,-21)
    for t in cbar.ax.get_yticklabels():
        t.set_fontsize(25)
    plt.axis('off')
    plt.show()



