import pickle
import numpy as np
import matplotlib.pyplot as plt


advec_x = 0.3
diff=0.01
nt=500

test_problem = f'advec_x={advec_x}_diff={diff}_nt={nt}'

# directory for loading results:
dirname = 'results_problem='+test_problem

# tested parameters:
n_rand_rhs = 10
n_rand_coeff_list = [20]
tol = 10**(-8)
iterations = 10000
nt_rand_list = [30]
k_list = [20,22,24,26,28,30]


# choose error for plot:
#which_error_plot = 'red_bases_sizes'
#error_title = 'number of chosen basis functions'
#which_error_plot = 'rel_C0_L2_errors'
#error_title = 'relative C0(L2)-error'
which_error_plot = 'rel_L2_H1_errors'
#error_title = 'relative L2(H1)-error'
#which_error_plot = 'rel_L2_errors_max_time'
#error_title = 'max(t) relative L2(t)-error'

quantiles = np.zeros((8,len(k_list)))
aux = 0
identify_list = []
for n_rand_coeff in n_rand_coeff_list:
    for nt_rand in nt_rand_list:
        for k in k_list:
            identify_list.append(f'k={k}')
            results = pickle.load(open(dirname+f'/iterations={iterations}_nrand_rhs={n_rand_rhs}_n_rand_coeff={n_rand_coeff}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))

            errors = np.sort(results[which_error_plot])

            quantiles[0, aux] = errors[-1]
            quantiles[1, aux] = errors[9899]
            quantiles[2, aux] = errors[9499]
            quantiles[3, aux] = errors[7499]
            quantiles[4, aux] = errors[4999]
            quantiles[5, aux] = errors[2499]
            quantiles[6, aux] = errors[499]
            quantiles[7, aux] = errors[0]

            aux += 1


# Load data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
grid_t = FE_results['grid_t']

plt.figure(figsize=plt.figaspect(0.5))
plt.semilogy(quantiles[0,:], marker =11,label = 'max',linestyle = 'None',color='tab:blue')
plt.semilogy(quantiles[1,:],marker = '*',label = '99',linestyle = 'None',color='tab:purple')
plt.semilogy(quantiles[2,:],marker = 'P',label = '95',linestyle = 'None',color='tab:orange')
plt.semilogy(quantiles[3,:],marker = '*',label = '75',linestyle = 'None',color='b')
plt.semilogy(quantiles[4,:],marker = 'p',label = '50',linestyle = 'None',color='tab:green')
plt.semilogy(quantiles[5,:],marker = 'x',label = '25',linestyle = 'None',color='tab:brown')
plt.semilogy(quantiles[6,:],marker = 'P',label = '5',linestyle = 'None',color='tab:pink')
plt.semilogy(quantiles[7,:],marker = 10,label = 'min',linestyle = 'None',color='tab:blue')

plt.legend()
aux_x = np.arange(len(k_list))
plt.xticks(aux_x,identify_list)
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.show()