import pickle
from compute_probabilities import compute_leverage_scores, compute_frob_prob
import numpy as np
import matplotlib.pyplot as plt


### This file computes and plots data-dependent probability distributions.



test_problem = f'advec_x=0.3_diff=0.01_nt=500'

# Load necessary FE data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
rhs_matrix = FE_results['rhs_matrix']
grid_t = FE_results['grid_t']


# Compute and plot leverage scores:
k_rhs = 1
leverage_scores_rhs = compute_leverage_scores(rhs_matrix,k_rhs)
squared_norms_rhs = compute_frob_prob(rhs_matrix)

leverage_scores_rhs = np.load('results/rhs_leverage_scores.npy')
squared_norms_rhs = np.load('results/rhs_squared_norms.npy')


# Plot probability distributions:
plt.figure(figsize=plt.figaspect(0.6))
plt.plot(grid_t,leverage_scores_rhs,label='LS rhs')
plt.plot(grid_t,squared_norms_rhs,label='SN rhs')
plt.legend()
plt.xlabel('time')
plt.show()
