import pickle
import numpy as np
import matplotlib.pyplot as plt

### This file visualizes the high fidelity FE solution

advec_x = 0.3
diff=0.01
nt= 500

test_problem = f'advec_x={advec_x}_diff={diff}_nt={nt}'

# Load necessary FE data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
FE_solution = FE_results['FE_solution']

for j in [50,180,300,500]:
    function_to_plot = FE_solution[:, j]

    grid_x = FE_results['grid_x']
    grid_y = FE_results['grid_y']
    X, Y = np.meshgrid(grid_x, grid_y)

    function_temp = function_to_plot.reshape(len(grid_y) - 2, len(grid_x) - 2)
    low = min(np.min(function_temp), 0)
    up = max(np.max(function_temp), 0)
    print(up)
    # Add homogeneous Dirichlet boundary conditions:
    aux_1 = np.zeros((1, len(grid_x) - 2))
    aux_2 = np.zeros((len(grid_y), 1))
    function_temp = np.vstack((aux_1, function_temp, aux_1))
    function_temp = np.hstack((aux_2, function_temp, aux_2))

    # Visualize:

    plt.matshow(function_temp[::-1])
    plt.set_cmap('turbo')
    cbar = plt.colorbar(fraction=0.026, pad=0.005, aspect=10)
    for t in cbar.ax.get_yticklabels():
        t.set_fontsize(25)
    plt.title(f'time {j/100}')
    plt.axis('off')

    plt.show()
