import numpy as np
import matplotlib.pyplot as plt


plt.figure(figsize=(8,9))

problem = f'advec_x=0.3_diff=0.01'
for nt in [15,30,45]:
    singular_vals = np.load(f'results/svd_transfer_singular_vals_nt={nt}_{problem}.npy')
    plt.semilogy(singular_vals[:36],linewidth=1,label=f'nt = {nt}')
plt.legend()
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.title(f'singular values of transfer operator\n advection: 0.3, diffusion: 0.01')
plt.show()