import numpy as np
import matplotlib.pyplot as plt

for nt in [15]:
   plt.figure(figsize=(8,9))

   for i in [0,10,25,50,100]:
      problem = f'advec_x={i}'
      singular_vals = np.load(f'results/svd_transfer_singular_vals_nt={nt}_{problem}.npy')
      plt.semilogy(singular_vals[:26], label = f'advection = {i}',linewidth=1)

   plt.grid(True,which='major',linestyle='--',linewidth=0.45)
   plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
   plt.title(f'singular values of transfer operator\n diffusion = 1; {nt} time steps')
   plt.legend()
   plt.show()
