import pickle
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from mpl_toolkits.mplot3d import Axes3D

### This file visualizes the high fidelity FE solution

for advec_x in [0,100]:
    for example_no in [1,2]:
        test_problem = f'initial_example_{example_no}_advec_x={advec_x}'

        # Load necessary FE data:
        FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
        FE_solution = FE_results['FE_solution']

        for j in [0,10]:
            function_to_plot = FE_solution[:, j]

            grid_x = FE_results['grid_x']
            grid_y = FE_results['grid_y']
            X,Y = np.meshgrid(grid_x,grid_y)

            function_temp = function_to_plot.reshape(len(grid_y) - 2, len(grid_x) - 2)
            low = min(np.min(function_temp), 0)
            up = max(np.max(function_temp), 0)
            print(up)
            # Add homogeneous Dirichlet boundary conditions:
            aux_1 = np.zeros((1, len(grid_x) - 2))
            aux_2 = np.zeros((len(grid_y), 1))
            function_temp = np.vstack((aux_1, function_temp, aux_1))
            function_temp = np.hstack((aux_2, function_temp, aux_2))

            # Visualize:
            plt.matshow(function_temp[::-1])
            plt.set_cmap('turbo')
            cbar = plt.colorbar(fraction=0.026, pad=0.005, aspect=10)
            for t in cbar.ax.get_yticklabels():
                t.set_fontsize(25)
            plt.axis('off')
            plt.title(f'FE solution for example {example_no} and advection = {advec_x} at time step {j}')

            plt.show()
