import pickle
import numpy as np
import matplotlib.pyplot as plt


test_problem = 'stove'
model = 'leverage'

# directory for loading results:
dirname = 'results_problem='+test_problem +'_model='+model

# tested parameters:
n_rand = 10
tol = 10**(-8)
iterations = 10**5
nt_rand_list = [10,15,20,25]
k_list = [8,13,18,23]

# choose error for plot:
which_error_plot = 'red_bases_sizes'
error_title = 'number of chosen basis functions'
#which_error_plot = 'rel_C0_L2_errors'
#error_title = 'relative C0(L2)-error'
#which_error_plot = 'rel_L2_H1_errors'
#error_title = 'relative L2(H1)-error'
#which_error_plot = 'rel_L2_errors_max_time'
#error_title = 'max(t) relative L2(t)-error'


quantiles = np.zeros((8,len(k_list)))
aux = 0
for k in k_list:
    nt_rand = nt_rand_list[aux]
    results = pickle.load(open(dirname+f'/iterations={iterations}_nrand={n_rand}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))

    errors = np.sort(results[which_error_plot])

    quantiles[0,aux] = errors[-1]
    quantiles[1,aux] = errors[98999]
    quantiles[2,aux] = errors[94999]
    quantiles[3,aux] = errors[74999]
    quantiles[4,aux] = errors[49999]
    quantiles[5,aux] = errors[24999]
    quantiles[6,aux] = errors[4999]
    quantiles[7,aux] = errors[0]

    aux += 1


plt.figure(figsize=plt.figaspect(0.9))
plt.plot(quantiles[0,:], marker =11,label = 'max',linestyle = 'None',color='tab:blue')
plt.plot(quantiles[1,:],marker = '*',label = '99',linestyle = 'None',color='tab:purple')
plt.plot(quantiles[2,:],marker = 'd',label = '95',linestyle = 'None',color='tab:red')
plt.plot(quantiles[3,:],marker = '*',label = '75',linestyle = 'None',color='b')
plt.plot(quantiles[4,:],marker = 'p',label = '50',linestyle = 'None',color='tab:green')
plt.plot(quantiles[5,:],marker = 'x',label = '25',linestyle = 'None',color='tab:brown')
plt.plot(quantiles[6,:],marker = 'P',label = '5',linestyle = 'None',color='tab:pink')
plt.plot(quantiles[7,:],marker = 10,label = 'min',linestyle = 'None',color='tab:blue')

aux_x = np.arange(len(k_list))
plt.xticks(aux_x,nt_rand_list)
plt.xlim(-0.5,len(k_list)+0.5)
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.title(error_title)
plt.legend()

plt.show()