import numpy as np
import matplotlib.pyplot as plt

svd_svals = np.load('results/svd_singular_vals_nt=15.npy')

proj_errors = np.empty((2000,16))

for i in range(2000):
    proj_errors = np.vstack((proj_errors,np.load(f'results/proj_errors_{i}.npy')))

size = proj_errors.shape[0]

proj_errors = np.sort(proj_errors,axis = 0)

plt.semilogy(svd_svals[:16])
plt.semilogy(proj_errors[0], label = 'min')
plt.semilogy(proj_errors[int(size*0.25)-1], label = '25')
plt.semilogy(proj_errors[int(size*0.5)-1], label = '50')
plt.semilogy(proj_errors[int(size*0.75)-1], label = '75')
plt.semilogy(proj_errors[int(size*0.95)-1], label = '95')
plt.semilogy(proj_errors[-1], label = 'max')
plt.legend()
plt.show()
