import pickle
import numpy as np
import matplotlib.pyplot as plt


test_problem = 'stove'
model = 'leverage'

# directory for loading results:
dirname = 'results_problem='+test_problem +'_model='+model

# tested parameters:
n_rand_list = [3,5,8,10,12,15,20,25]
tol = 10**(-8)
iterations = 10**5
nt_rand = 15
k = 13

# choose error for plot:
#which_error_plot = 'red_bases_sizes'
#error_title = 'number of chosen basis functions'
#which_error_plot = 'rel_C0_L2_errors'
#error_title = 'relative C0(L2)-error'
which_error_plot = 'rel_L2_H1_errors'
error_title = 'relative L2(H1)-error'
#which_error_plot = 'rel_L2_errors_max_time'
#error_title = 'max(t) relative L2(t)-error'


quantiles = np.zeros((10,len(n_rand_list)))
aux = 0
for n_rand in n_rand_list:
    results = pickle.load(open(dirname+f'/iterations={iterations}_nrand={n_rand}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))

    errors = np.sort(results[which_error_plot])

    quantiles[0,aux] = errors[-1]
    quantiles[1,aux] = errors[98999]
    quantiles[2,aux] = errors[97999]
    quantiles[3,aux] = errors[96999]
    quantiles[4,aux] = errors[89999]
    quantiles[5,aux] = errors[74999]
    quantiles[6,aux] = errors[49999]
    quantiles[7,aux] = errors[24999]
    quantiles[8,aux] = errors[4999]
    quantiles[9,aux] = errors[0]

    aux += 1


plt.figure(figsize=plt.figaspect(0.9))
plt.semilogy(quantiles[0,:], marker =11,label = 'max',linestyle = 'None',color='tab:blue')
plt.semilogy(quantiles[1,:],marker = '*',label = '99',linestyle = 'None',color='tab:purple')
plt.semilogy(quantiles[2,:],marker = 'P',label = '98',linestyle = 'None',color='tab:orange')
plt.semilogy(quantiles[3,:],marker = 'p',label = '97',linestyle = 'None',color='tab:cyan')
plt.semilogy(quantiles[4,:],marker = 'd',label = '90',linestyle = 'None',color='tab:red')
plt.semilogy(quantiles[5,:],marker = '*',label = '75',linestyle = 'None',color='b')
plt.semilogy(quantiles[6,:],marker = 'p',label = '50',linestyle = 'None',color='tab:green')
plt.semilogy(quantiles[7,:],marker = 'x',label = '25',linestyle = 'None',color='tab:brown')
plt.semilogy(quantiles[8,:],marker = 'P',label = '5',linestyle = 'None',color='tab:pink')
plt.semilogy(quantiles[9,:],marker = 10,label = 'min',linestyle = 'None',color='tab:blue')

aux_x = np.arange(len(n_rand_list))
plt.xticks(aux_x,n_rand_list)
plt.xlim(-0.5,len(n_rand_list)+1.5)
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.title(error_title)
plt.legend()

plt.show()