import pickle
import numpy as np
import matplotlib.pyplot as plt


test_problem = 'stove'

# Parameters:
iterations = 100000
n_rand = 10
nt_rand = 15
k = 13
tol = 1e-08

# Load data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
grid_t = FE_results['grid_t']

rel_L2_errors_POD = np.load('results/POD_stove_on_165_of 300_rel_L2_error_over_time.npy')

plt.figure(figsize=plt.figaspect(0.7))
plt.semilogy(grid_t, rel_L2_errors_POD, label='POD',linewidth=1)

for model in ['leverage','uniform']:
    dirname = 'results_problem='+test_problem +'_model='+model
    random_results = pickle.load(open(dirname+f'/iterations={iterations}_nrand={n_rand}_ninit=ntrand={nt_rand}_k={k}_tol={tol}.pickle','rb'))
    rel_L2_errors_over_time = np.sort(random_results['rel_L2_errors_over_time'],axis=0)

    plt.semilogy(grid_t, rel_L2_errors_over_time[4999, :], label=f'random {model} 5', linewidth=1)
    plt.semilogy(grid_t, rel_L2_errors_over_time[49999, :], label=f'random {model} 50', linewidth=1)
    plt.semilogy(grid_t, rel_L2_errors_over_time[94999, :], label=f'random {model} 95', linewidth=1)

plt.legend()
plt.grid(True,which='major',linestyle='--',linewidth=0.45)
plt.grid(True,which='minor',linestyle='--',linewidth=0.35)
plt.show()
