import pickle
from common.compute_probabilities import compute_leverage_scores
import matplotlib.pyplot as plt


### This file computes and plots the leverage scores of the right hand side data matrix for Experiment 1.


test_problem = 'stove'

# Load test problem and necessary data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
rhs_matrix = FE_results['rhs_matrix']
grid_t = FE_results['grid_t']

# Compute and plot leverage scores:
k = 3
leverage_scores = compute_leverage_scores(rhs_matrix,k)

plt.plot(grid_t,leverage_scores)
plt.xlabel('time')
plt.title(f'probability distribution: leverage scores for k={k}')
plt.show()

