import pickle, dill
from common.compute_probabilities import compute_frob_prob, compute_leverage_scores
import matplotlib.pyplot as plt
import numpy as np


test_problem = 'space_frequencies'

# Load test problem and necessary data:
FE_results = pickle.load(open('results/FE_data_problem='+test_problem+'.pickle','rb'))
rhs_matrix = FE_results['rhs_matrix']
grid_t = FE_results['grid_t']
rhs_t = dill.load(open('results/rhs_t_problem='+test_problem+'.dill','rb'))

# Compute probabilities:
frob_prob = compute_frob_prob(rhs_matrix)
k = 2
leverage_scores = compute_leverage_scores(rhs_matrix,k)

# Plot:
plt.plot(grid_t[:150],rhs_t[0](grid_t[:150]),color='black')
plt.plot(grid_t[150:],rhs_t[1](grid_t[150:]),color='black', label='data in time')
plt.plot(grid_t,400*frob_prob,label='squared norms',linestyle = '--')
plt.plot(grid_t,400*leverage_scores,label='leverage scores',linestyle = '--')
plt.legend()
plt.show()