import numpy as np

### This function computes the squared norm probability distribution of the input matrix (based on the frobenius norm):

def compute_frob_prob(matrix):
    frob_prob = np.zeros(matrix.shape[1])
    for i in range(matrix.shape[1]):
        frob_prob[i] = np.linalg.norm(matrix[:, i]) ** 2
    frob_prob = frob_prob / np.linalg.norm(matrix) ** 2
    return frob_prob


### This function computes the leverage scores probability distribution of the input matrix (based in its SVD):

def compute_leverage_scores(matrix, rank):
    # Compute right singular vectors:
    _, _, V = np.linalg.svd(matrix)
    # Compute leverage scores following equation (3) in
    # ``CUR matrix decompositions for improved data analysis'' by Mahoney and Drineas
    leverage_scores = np.zeros(matrix.shape[1])
    for i in range(matrix.shape[1]):
        leverage_scores[i] = 1 / rank * V[:rank, i].dot(V[:rank, i])
    return leverage_scores