import json
import numpy as np
import scipy.sparse as sps
import matplotlib.pyplot as plt
# from tikzplotlib import save

plt.style.use('fivethirtyeight')
plt.style.use('Solarize_Light2')

prvw_plotplease = True
prvw_plotplease = False


def load_nsevel_data(dtfile, velfile_path_correction=''):
    with open(dtfile) as f:
        dtdct = json.load(f)

    vstrdct = dtdct['velstrs']
    invinds = dtdct['invinds']

    strnge = list(vstrdct.keys())
    tranga = np.array([np.float(x) for x in strnge])

    if not np.all(tranga[:-1] <= tranga[1:]):
        raise UserWarning('trange is not sorted')

    vpc = velfile_path_correction
    vellist = [np.load(vpc+vstrdct[ct]+'.npy')[invinds] for ct in strnge]
    vella = np.hstack(vellist)
    cmd = dtdct['cmat']
    if prvw_plotplease:
        import dolfin
        from dolfin_navier_scipy.data_output_utils import output_paraview
        mesh = dolfin.Mesh(vpc+dtdct['meshfile'])
        V = dolfin.VectorFunctionSpace(mesh, 'CG', 2)
        vtp = np.load(vpc+vstrdct[strnge[-1]]+'.npy')
        output_paraview(V=V, vc=vtp, fstring=f'Re{Re}t{strnge[-1]}')
        import ipdb
        ipdb.set_trace()

    if cmd['format'] == 'csr':
        cmatdata = (cmd['data'], cmd['indices'], cmd['indptr'])
        cmat = sps.csr_matrix(cmatdata, shape=tuple(cmd['shape']))
        cmat = cmat[:, invinds]
    else:
        raise NotImplementedError('expected a CSR matrix to reconstruct')
    M = sps.load_npz(vpc+dtdct['mmat']['matfile'])
    return vella, tranga, cmat, M


if __name__ == '__main__':
    Re = 20
    Re = 60
    Re = 25
    Re = 30
    Re = 40
    tE = 12
    dtpnts = 2000
    dtfile = f'sc_{Re}_0-{tE}_{dtpnts}.json'
    print(dtfile)
    vella, tranga, cmat, M = load_nsevel_data(dtfile)
    plt.figure(figsize=(6, 2))
    # for kkk in cmat.shape[0]:
    plt.plot(tranga, (cmat @ vella).T)
    plt.xlabel('$t$')
    plt.ylabel('$y(t) = Cv(t)$')
    plt.tight_layout()
    # save(f'sc_{Re}_0-{tE}_{dtpnts}.tex')
    plt.show()
