### This directory contains the non-sequence data used/generated by our GBS analysis

Alphabetically:

-   The admixture subdirectory contains the files generated by the admixture analysis. Each species/site has its own subdirectory containing a .csv of the Cross Validation calculations for each of the K groups (CV.csv), the .P and .Q files for each of the K groups, and the log files for each of the K groups

-   The barcodes_set1.txt and barcodes_set2.txt files are text files containing the sample-specific barcodes. These files are used in the demultiplexing step (see scripts/other_scripts/demultiplexing_script.txt)

-   The eximius_coordinates.csv files contains location information for each colony. The data dictionary is as follows:

    | Column Name | Definition                                                                        |
    |-------------|-----------------------------------------------------------------------------------|
    | locale      | region in which the nest was found (jatun sacha, sumaco == via loreto, archidona) |
    | Species     | the host species, *Anelosimus eximius*                                            |
    | Nest        | unique nest ID code                                                               |
    | latitude    | latitude of the nest                                                              |
    | longitude   | longitude of the nest                                                             |
    | elevation   | elevation of the nest                                                             |
    | Trail       | for nests at Jatun Sacha only, the trail on which it was found                    |

-   The filtered_vcfs subdirectory contains the filtered vcf files generated using the scripts/other_scripts/vcf_filtering.txt script

-   The output_files subdirectory contains cleaned population data, generated in the scripts/Rscripts/GBS_master.R script.

    -   The data dictionary for the cleaned population data for *Anelosimus eximius* in the file eximius.pop.data.cleaned.csv is as follows:

        | Column name | Definition         |
        |-------------|--------------------|
        | V1          | Individual ID code |
        | V2          | nest region        |
        | V3          | nest cluster       |
        | V4          | nest ID            |

    -   The data dictionary for the cleaned population data for *Faiditus sp.1* in the file N1.pop.data.cleaned.csv is as follows:

        | Column name | Definition         |
        |-------------|--------------------|
        | V1          | Individual ID code |
        | V2          | nest ID            |
        | V3          | nest cluster       |
        | V4          | nest region        |

    -   The data dictionary for the cleaned population data for *Faiditus sp.2* in the file F2.pop.data.cleaned.csv is as follows:

        | Column name | Definition         |
        |-------------|--------------------|
        | V1          | Individual ID code |
        | V2          | nest ID            |
        | V3          | nest region        |

-   The pop_maps subdirectory contains the population maps required to run the scripts/other_scripts/stacks_populations_script.txt and to set the strata for the genlight objects in the scripts/Rscripts/GBS_Master.R script
