library(dplyr)
library(ggplot2)
library(RColorBrewer)
library(forcats)
library(wesanderson)
#----------------------------------------------------
# directory 
setwd('/Users/mi/Desktop/FDI Russia/ver 3')
getwd()
#----------------------------------------------------
# Loading data

data <-
  read.table('fdi_group.csv',
             sep = ",",
             dec = ".",
             header = TRUE)


#---------------------------------------------------
# Graph
my_colors <- RColorBrewer::brewer.pal(4, "Grays")[1:4]

ggplot(data, aes(x=year)) + 
  geom_line(aes(y = TOTAL, color = "TOTAL"), linetype = 'dashed', size = 1) + 
  geom_line(aes(y = OECD, color ="OECD"), size = 1) +
  geom_line(aes(y = EU, color = "EU"), size = 1) +
  geom_line(aes(y = OFFSHORE, color ="OFFSHORE"), size = 1) +
  geom_vline(xintercept = 2014 , color = "red", linetype = "dashed") +
  labs (x ="year", y = "Total inward FDI in $US billion", color = 'Partner group') +
  theme_classic() + 
  scale_x_continuous(breaks = scales::pretty_breaks(10)) + scale_color_brewer(palette="Spectral")


  
