function bilinear_jp,x1,x2,y1,y2,func11,func12,func21,func22,x,y 
; func11,func12,func21,func22 - function defined at (x1,y1),(x1,y2),(x2,y1),(x2,y2) 
; x1,x2 - x-coordinates 
; y1,y2 - y-coordinates 
; x,y - coordinates where function should be computed 

; check that dimensions are the same 
;nx1=N_elements(x1) 
;nx2=N_elements(x2) 

delx1=x-x1 
delx2=x2-x 
delx=x2-x1 
dely1=y-y1 
dely2=y2-y 
dely=y2-y1 
 
return,(delx2*(func11*dely2+func12*dely1)+delx1*(func21*dely2+func22*dely1))/delx/dely
end

; bilinear interpolation 
function interp2d_jp,z,x,y,x1,y1
; z_ij  - matrix defined for x_i ,y_j  
; x     - monotonic vector of x_i values 
; y     - monotonic vector of y_j values 
; x1,y1 - coordinates where function z should be computed; vectors should have the same dimension

nx=N_elements(x) 
ny=N_elements(y) 

; Check that z is a 2d array
sz = size(z)
if sz(0) ne 2 then begin
  message,'z must be a 2-d array  in interp2d_jp',/cont
  return,-1
endif

; Check that the dimensions of x and y match z
if (sz(1) ne nx) or 	$
   (sz(2) ne ny) then begin
  message,'Dimensions of z, x, y are not consistent in interp2d_jp',/cont
  return,-1
endif

; Check that dimensions of x1 and y1 are the same 
nx1=N_elements(x1) 
ny1=N_elements(y1)
if(nx1 ne ny1) then begin 
  message,' dimensions of x1 and y1 differ in interp2d_jp',/cont
  return,-1 
endif 

; locate indices where x1 are located in vector x 
loc_x = VALUE_LOCATE(x, x1)
; locate indices where y1 are located in vector y 
loc_y = VALUE_LOCATE(y, y1)

; correct index if x1 is outside of the range of x 
index_x0=where(loc_x eq -1,ncount_x0)
if(ncount_x0 ne 0) then loc_x(index_x0)=loc_x(index_x0)+1
index_x1=where(loc_x eq nx-1,ncount_x1)
if(ncount_x1 ne 0) then loc_x(index_x1)=loc_x(index_x1)-1

; correct index if y1 is outside of the range of y 
index_y0=where(loc_y eq -1,ncount_y0)
if(ncount_y0 ne 0) then loc_y(index_y0)=loc_y(index_y0)+1
index_y1=where(loc_y eq ny-1,ncount_y1)
if(ncount_y1 ne 0) then loc_y(index_y1)=loc_y(index_y1)-1

z11=z(loc_x,loc_y) 
z12=z(loc_x,loc_y+1) 
z21=z(loc_x+1,loc_y) 
z22=z(loc_x+1,loc_y+1)  
result=bilinear_jp(x(loc_x),x(loc_x+1),y(loc_y),y(loc_y+1),z11,z12,z21,z22,x1,y1)

return, result
end

