pro read_sandwich,namefread,nx,xx,pol,pa
openr,1,namefread 

aa=dblarr(3)
xx=dblarr(nx)
pol=dblarr(nx,4)  
pa=dblarr(nx,4)  

for i=0,3 do begin
  for k=0,nx-1  do begin  
    readf,1,aa 
    xx(k)=aa(0)
    pol(k,i) = aa(1)
    pa(k,i)=aa(2)
  endfor
  SKIP_LUN, 1, 1, /LINES
endfor 
  
    close,1

return
end


; #########################################################
pro plot_image_disc,namefile,scalepol,y_scale,incl_plot,nphi,nrad,x_image_sky_all,y_image_sky_all,x_image_sky_app,y_image_sky_app,inten_all,pol_all,pol_app,chitot_all,chitot_app

pxwidth=0.89
pxmax=0.99
pymax=0.99

xplotsize=12.
 
case incl_plot of 
0: begin 
yshift=0. 
pymin=0.005 
end 
1: begin
yshift=0.0 
pymin=0.005
end
2: begin 
yshift=1.7
pymin=0.14 
pymin=0.40
end
endcase 

px=[pxmax-pxwidth,pymin,pxmax,pymax]   
pyheight=pymax-pymin 
yplotsize=xplotsize*pxwidth/pyheight*y_scale

if(incl_plot eq 2) then yplotsize= yplotsize+1.

print,'yplotsize=',yplotsize

device,/COLOR,  bits_per_pixel=8
device,filename=namefile,xsize=xplotsize,ysize=yplotsize,XOFF=2.,YOFF=4., /portrait,/COLOR,/CMYK  
!P.CHARSIZE=1.2 

chars1=1.2 
chars2=0.7
nth=4 

xmax=17. 
ymin=-xmax*y_scale+yshift
ymax=xmax*y_scale+yshift

if(incl_plot eq 2) then begin 

plot,[1d0,1d0],[1d0,1d0], $
xthick=nth,ythick=nth, position=px, $
;xrange=[-20,20.],xstyle=1 , yrange=[-20,20.],ystyle=1 , $
;xticks=4,xtickv=[-20.,-10,0.,10.,20], xtickname=['!17 ','-10','0','10',' '],xminor=5, $
yticks=2,ytickv=[-5.,0.,5.], ytickname=['!17-5','0','5'],yminor=5,$ ; /isotropic ,
xrange=[-xmax,xmax],xstyle=1 , yrange=[-6.,9.0],ystyle=1 ,   $ 
xticklen=0.1, $ 
;xtickname=replicate(' ',10), ytickname=replicate(' ',10), $ 
/nodata ,/noerase

endif else begin 

plot,[1d0,1d0],[1d0,1d0], $
xthick=nth,ythick=nth, position=px, $
xrange=[-xmax,xmax],xstyle=1 , yrange=[ymin,ymax],ystyle=1 ,/isotropic, $
xtickname=replicate(' ',10), $ 
/nodata ,/noerase
endelse 


 
x_image_sky=dblarr(nphi,nrad)
y_image_sky=dblarr(nphi,nrad)
image=dblarr(nphi,nrad)
x_image_sky_a=dblarr(nphi,nrad)
y_image_sky_a=dblarr(nphi,nrad)

xpol_coor=dblarr(2,nphi,nrad)
ypol_coor=dblarr(2,nphi,nrad)
xpol_coor_a=dblarr(2,nphi,nrad)
ypol_coor_a=dblarr(2,nphi,nrad)
 
incl=incl_plot
for irad=0,nrad-1 do begin 
x_image_sky(*,irad)= x_image_sky_all(*,irad,incl)
y_image_sky(*,irad)= y_image_sky_all(*,irad,incl)
x_image_sky_a(*,irad)= x_image_sky_app(*,irad,incl)
y_image_sky_a(*,irad)= y_image_sky_app(*,irad,incl)
image(*,irad)= inten_all(*,irad,incl)

ps=abs(pol_all(*,irad,incl))*scalepol/2.
psy=ps*cos(chitot_all(*,irad,incl)*!DPI/180d0+!DPI/2d0) 
psx=ps*sin(chitot_all(*,irad,incl)*!DPI/180d0+!DPI/2d0) 

xpol_coor(0,*,irad)= x_image_sky(*,irad)-psx 
ypol_coor(0,*,irad)= y_image_sky(*,irad)+psy 
xpol_coor(1,*,irad)= x_image_sky(*,irad)+psx 
ypol_coor(1,*,irad)= y_image_sky(*,irad)-psy 

ps=abs(pol_app(*,irad,incl))*scalepol/2.
psy=ps*cos(chitot_app(*,irad,incl)*!DPI/180d0+!DPI/2d0) 
psx=ps*sin(chitot_app(*,irad,incl)*!DPI/180d0+!DPI/2d0) 

xpol_coor_a(0,*,irad)= x_image_sky_a(*,irad)-psx 
ypol_coor_a(0,*,irad)= y_image_sky_a(*,irad)+psy 
xpol_coor_a(1,*,irad)= x_image_sky_a(*,irad)+psx 
ypol_coor_a(1,*,irad)= y_image_sky_a(*,irad)-psy 

endfor

logimage=alog10(image)

image_max=max(alog10(inten_all))
image_min=min(alog10(inten_all))
print,'image_min,image_max=',image_min,image_max 

 
nlevels=101
levels_inten=dindgen(nlevels)/(nlevels-1)*(image_max-image_min)+image_min 
;print,'levels_inten=',levels_inten 
;loadct, 39, NColors=nlevels , Bottom=1
loadct, 3, NColors=nlevels ; , Bottom=1


contour,logimage,x_image_sky,y_image_sky, $
C_THICK=nth, $
/Fill, $
c_charsize=chars1, XStyle=1, YStyle=1, levels=levels_inten, $
c_label=replicate([1],nlevels), c_linestyle=0, $ 
;c_label=[0], c_linestyle=0, $ 
 C_Colors=IndGen(nlevels)+1,   $  
/overplot 

nth=1 
nrad_step=30
col_circle=256
col_circle_a=0
; plot projections of the circles every 5 radii 
for irad=0,nrad-1,nrad_step do begin 
oplot,x_image_sky(*,irad),y_image_sky(*,irad),col=col_circle,thick=nth,line=0
oplot,x_image_sky_a(*,irad),y_image_sky_a(*,irad),col=col_circle_a,thick=nth,line=1 
endfor 

nphi_step=30
col_radial=256
col_radial_a=0
; plot projections of the radial lines every 15 (nphi_step) deg  
for iphi=0,nphi-1,nphi_step do begin 
oplot,x_image_sky(iphi,*),y_image_sky(iphi,*),col=col_radial,thick=nth,line=0
oplot,x_image_sky_a(iphi,*),y_image_sky_a(iphi,*),col=col_radial_a,thick=nth,line=1 
endfor 

colors 
; plot polarization vectors 
col_pol=3
col_pol_a=4; 256
nrad_step=30
nth=1 
for iphi=nphi_step/2,nphi-1,nphi_step do begin 
oplot,xpol_coor(*,iphi,0),ypol_coor(*,iphi,0),col=col_pol,thick=nth,line=0
oplot,xpol_coor_a(*,iphi,0),ypol_coor_a(*,iphi,0),col=col_pol_a,thick=nth,line=0
for irad=nrad_step/2,nrad-1,nrad_step do begin 
oplot,xpol_coor(*,iphi,irad),ypol_coor(*,iphi,irad),col=col_pol,thick=nth,line=0
oplot,xpol_coor_a(*,iphi,irad),ypol_coor_a(*,iphi,irad),col=col_pol_a,thick=nth,line=0
endfor 
endfor

for iphi=nphi/2,nphi/2 do begin 
oplot,xpol_coor(*,iphi,0),ypol_coor(*,iphi,0),col=col_pol,thick=nth,line=0
oplot,xpol_coor_a(*,iphi,0),ypol_coor_a(*,iphi,0),col=col_pol_a,thick=nth,line=0
for irad=nrad_step/2,nrad-1,nrad_step do begin 
oplot,xpol_coor(*,iphi,irad),ypol_coor(*,iphi,irad),col=col_pol,thick=nth,line=0
oplot,xpol_coor_a(*,iphi,irad),ypol_coor_a(*,iphi,irad),col=col_pol_a,thick=nth,line=0
endfor 
endfor

x1=-1.
y1=-15.*y_scale+yshift
x1shift=0.
if(incl eq 0) then x1shift=-1.5
oplot,[x1+x1shift,x1+x1shift+scalepol*0.05],[y1,y1] ,line=0,col=0 
xyouts,x1-0.5,y1+0.5,'!17 5%'  

xout1=-15.
yout1=-15.*y_scale+yshift
xout2=12.
yout2=-15*y_scale+yshift
labsize=1.7

case incl_plot of 
0: begin 
xyouts,xout1,yout1,'!8i!17=30!Uo!N' ,/data,size=labsize
xyouts,xout2,yout2,'!17(a)' ,/data,size=labsize
end 
1: begin 
xyouts,xout1,yout1,'!8i!17=60!Uo!N' ,/data,size=labsize
xyouts,xout2,yout2,'!17(b)' ,/data,size=labsize
end
2: begin
xyouts,xout1,yout1,'!8i!17=80!Uo!N' ,/data,size=labsize
xyouts,xout2,yout2,'!17(c)' ,/data,size=labsize
end
endcase 

; plot color bar 
if(incl_plot eq 2) then begin 


image_max=max(alog10(inten_all))
image_min=min(alog10(inten_all))
print,'image_min,image_max=',image_min,image_max 

 
nlevels=101
levels_inten=dindgen(nlevels)/(nlevels-1)*(image_max-image_min) + image_min  -image_max
;print,'levels_inten=',levels_inten 
;loadct, 39, NColors=nlevels , Bottom=1
;loadct, 3, NColors=nlevels ; , Bottom=1

nth=4 
xscale=[-2.7,0.] 
;xscale=[-5.5,-2.3]
yscale=[0.,1.]

ny=10 
bar_color=dblarr(nlevels,ny) 
yvariable=dindgen(ny)/(ny-1d0)

for iy=0,ny-1 do begin
bar_color(*,iy)=levels_inten(*)
endfor

px=[pxmax-pxwidth,0.18,pxmax,0.27]   



plot,[1d0,1d0],[1d0,1d0], $
xthick=nth,ythick=nth, position=px, $
xrange=xscale,xstyle=1, yrange=yscale,ystyle=1 , $ ; ,/isotropic
ytickname=replicate(' ',10), $
xtickname=replicate(' ',10), $ 
;xticklen=-0.2, $
;yticklen=-1, $
;xtickname=replicate(' ',10), $ 
/nodata ,/noerase



contour,bar_color,levels_inten,yvariable, $
C_THICK=nth, $
/Fill, $
c_charsize=chars1, XStyle=4, YStyle=4, levels=levels_inten, $
c_label=replicate([0],nlevels), c_linestyle=0, $ 
;c_label=[0], c_linestyle=0, $ 
 C_Colors=IndGen(nlevels)+1,   $  
/overplot 



 axis,  xticklen=-0.2 ,$
; xthick=nth,ythick=nth, $
 xrange=xscale,xstyle=1 , yrange=yscale,ystyle=1 , $
xtitle='!17log!D10!N(!8I/I!D!17max!N)' ,$ 
xticks=3, xtickv=[-3.,-2.,-1.,0.], xminor=10, $ 
/nodata ,/noerase


endif 

device,/close
print,' postscript plot saved to file ',namefile  


return
end 


;#######################################
; Comptonization function x*I_x a(mu) 
function compton_xIx,x,dmu,ene_index,beaming
;dmu here is a vector , x - scalar 
; I_x propto x^-ene_index 
angle_dist=angle_compton(beaming,dmu)
energy_dist=x*x^(-ene_index) ; xI_x 
compton= energy_dist*angle_dist 
return,compton
end


;#######################################
; angular distribution of Comptonized radiation as a function of cosine of zenith angle 
function angle_compton,beaming,dmu  ;dmu here is a vector  
; normalization to unit flux int_0^1 I(mu) mu dmu = 1 = 1/2 + beaming/3
angle_dist=(1d0 + beaming*dmu)/( 0.5d0 + beaming/3d0)
return,angle_dist
end


 ;#######################################
; modified Planck function x*B_x(T) a(mu) 
function bbody_xBx,x,temp,dmu 
;dmu here is a vector , x - scalar 
angle_dist=angle_esc(dmu)
ex=exp(-x/temp)
energy_dist=x^4*ex/(1d0-ex)
planck= energy_dist*angle_dist 
return,planck
end

;#######################################
; angular distribution of modified black body as a function of angle for e-sc dominating atmosphere
function angle_esc,dmu  ;dmu here is a vector  
angle_dist=0.421d0 + 0.868d0*dmu
return,angle_dist
end

;#######################################
; polarization as a function of angle for e-sc dominating atmosphere
function pol_esc,dmu  ;dmu here is a vector  
pol_esc=-0.1171*(1d0-dmu)/(1d0+3.5d0*dmu)
return,pol_esc
end

;#######################################
;radial dependence of the effective temperature as function of dimensionless compactness u=R_S/r 
function tempeff_rad,u ; radius  can be a vector  
temp_fac_u=(u^3*(1d0-sqrt(3d0*u)))^0.25d0
return,temp_fac_u
end

;#######################################
;radial dependence of the flux as function of dimensionless compactness u=R_S/r 
; Shakura & Sunyaev 1973 model 
function flux_rad_ss73,u ; radius  can be a vector  
flux_rad= u^3*(1d0-sqrt(3d0*u))
return,flux_rad
end


;#######################################
;radial dependence of the flux as function of dimensionless compactness u=R_S/r 
; ADAF model 
function flux_rad_adaf,u ; radius  can be a vector  
flux_rad= u^2.5*(1d0-sqrt(3d0*u))
return,flux_rad
end

;##############################################################################
; trajectory using AB formula r(psi) 
; output: radius in units of R_s 
; input: 
; radrg = R/R_s 
; cosalpha0 cosine of the emission angle 
; cospsi cosine of the angle between the direction to the position at the trajectory and observer 
pro radpsi,radius,cospsi,radrg,cosalpha0  

minus=1.-cospsi 
plus=1.+cospsi 
mp=minus/plus/2. 

radius=sqrt(mp^2+ radrg^2*(1.-cosalpha0^2)/(1.-1./radrg)/(minus*plus) ) - mp

return
end
;##############################################################################
 

;#########################################################

function schint2,x 
common sch_int,cosal,rrg  

eps=1d-8
cosal2=cosal^2
rinv=1d0/rrg
x2=x^2
px=(1d0-cosal2)*((2d0-x2)*(1d0-rinv)-rinv*(1d0-x2)^2)  

if(abs(cosal) lt eps) then $
func=1d0/sqrt(px) else $
func=x/sqrt(x2*px+cosal2*(1d0-rinv))

;print,'rinv,px=',rinv,px
;if(abs(cosal) lt eps) then begin
;func=1d0/sqrt(px)
;if(px lt eps) then print,'px,cosal=',px,cosal
;endif else begin
;ppp=x2*px+cosal2*(1d0-rinv)
;if(ppp lt eps) then print,'ppp,px,cosal=',ppp,px,cosal
;func=x/sqrt(x2*px+cosal2*(1d0-rinv))
;endelse
;if(px lt eps) then print,'px,cosal=',px,cosal

return,func
end

;##############################################################################
; psi(radrg,alpha)
function psi_exact,cosalpha,radrg
common sch_int,cosal,rrg

rrg=radrg
cosal=cosalpha
if(abs(cosal) lt 1d-5) then cosal=0d0 
eps=1d-4 ; 8
sinalpha=sqrt(1d0-cosalpha^2)

A=0d0
B=!DPI/2d0
;result=QSIMP('schint', A, B,eps=1e-4)*sinalpha
B=1d0   
result=QSIMP('schint2', A, B,eps=eps,/double)*sinalpha*2d0

return,result
end

;##############################################################################
function schdel,x
common sch_int,cosal,rrg
eps=1d-8
cosal2=cosal^2
rinv=1d0/rrg
x2=x^2
px=(1d0-cosal2)*((2d0-x2)-rinv*(1d0-x2)^2/(1d0-rinv))
if(abs(cosal) lt eps) then $
func=1d0/(sqrt(px)+x*px) else begin
sa=x2*px+cosal2
func=x/(sqrt(sa)+sa)
endelse
return,func
end
;##############################################################################
function del_exact,cosalpha,radrg
common sch_int,cosal,rrg
eps=1d-5
rrg=radrg
cosal=cosalpha
A=0d0
B=1d0
y=(1d0-cosal)/(1d0-1d0/rrg) ;JP
;result=QSIMP('schdel', A, B,eps=1d-8,/double)*(1d0-cosal^2)*2d0/(1d0-1d0/rrg)
result=QSIMP('schdel', A, B,eps=eps,/double)*(1d0+cosal)*2d0 *y  ;JP
return,result
end

 
 
;############################################################################## 
function reverse_grid,vector 
n=n_elements(vector)
vector1=vector 
for i=0,n-1 do begin
vector1(i)=vector(n-1-i)
endfor 

return,vector1 
end



;##############################################################################
; light bending, some derivatives and time delays in Schwarzschild metrics 
;##############################################################################
; light bending, some derivatives and time delays in Schwarzschild metrics 
pro psialpha,radrg,radref,cospsi,psi,cospsi_AB,cosalcr,alphaall,cosal,der,timedelay,nang  
; input: 
; radrg  - radius in units of Schwarzschild radii 
; radref - reference radius to compute time delay from 
; nang - number of points 
; output : 
; cosalcr - minimum cos alpha that gives trajectories not captured by the black hole 
; cosal - cos(alpha) vector of cosine of alpha in the interval [1,cosalpha_cr]
; alphaaall - alpha corresponding to cosal 
; der - derivative d cospsi /d cosal 
; timedelay - time delay  Delta t
 
common psi,xpsi,ycosal,spline_alppsi
common derivcom,yder,spline_der

;common psi,psi,cosal,y2
;common derivcom,der,yder2
;common lags,phalag,ylag
;common radius,rinv,redshift,betakepler,lorentz 

c3=sqrt(3d0)
bcr=1.5d0*c3
pi2=2d0*!DPI
 
 
rinv=1d0/radrg
;print,'radrg=',radrg,' rinv=',rinv 
rinv2=rinv^2
rinv3=rinv^3
redshift=sqrt(1d0-rinv)
;betakepler=sqrt(rinv/(2d0*(1d0-rinv)))
;lorentz=sqrt((1d0-rinv)/(1d0-1.5d0*rinv)) 
sinalcr=min([sqrt(1d0-rinv)*rinv*bcr,1d0])
cosalcr=sqrt(1d0-sinalcr^2)
if(radrg ge 1.5d0) then cosalcr=-cosalcr
;print,'sinalcr,cosalcr=',sinalcr,cosalcr

;hal=1d0/(nang-1d0) 
hal=1d0/float(nang)

;print,'nang=',nang,' hal=',hal
;print,'cosalcr=',cosalcr
grid=((1d0+dindgen(nang))*hal) ; [0,1]
;print,'grid=',grid 
grid=reverse_grid(grid) ; [1,0) 
;print,'grid=',grid 

cosal=dblarr(nang)
;sinal=sin(alphaall)
cospsi_AB=dblarr(nang)
cospsi=dblarr(nang)
psi=dblarr(nang)
der=dblarr(nang)
timedelay=dblarr(nang) 

;print,'cosal=',cosal
;print,'cosalcr=',cosalcr
;for i=0,nang-1 do begin 
;cosal(i)=cosalcr+grid(i)*(1d0-cosalcr) ; [1,cosalpha_cr]
;endfor 

cosal=cosalcr+grid*(1d0-cosalcr) ; [1,cosalpha_cr]

alphaall=acos(cosal)
index1=where(cosal ge 0d0,count1,COMPLEMENT=index2,NCOMPLEMENT=count2)
cospsi_AB=(cosal-rinv)/(1d0-rinv)

;xa=1d0-cosal 
;xau=xa/(1d0-rinv)
;psi_AB=sinal/sqrt(1d0-rinv)*(1.d0+xau*(1d0/3d0-rinv/4d0+xau*0.5d0*(4d0/15d0-5d0/12d0*rinv+5d0/28d0*rinv2+xau*(4d0/35d0-11d0/40d0*rinv+5d0/21d0*rinv2-rinv3/14d0))))
;cospsi_AB=cos(psi_AB) 


;print,'count1,index1 =',count1,index1
;print,'count2,index2 =',count2,index2

;stop 
;#########################################################################
; bending angle and time delay for outgoing trajectories
if(count1 ge 1) then begin 
for iang=0,count1-1 do begin
;print,'iang, index1(iang) =',iang, index1(iang) 
cosalpha=cosal(index1(iang))
;print,'cosalpha=',cosalpha 
psix=psi_exact(cosalpha,radrg)
;print,'psix=',psix 
psi(index1(iang))=psix
;jp
tlag=0.d0 ; del_exact(cosalpha,radrg)
timedelay(index1(iang))=tlag + radref - radrg  + alog((radref -1d0)/(radrg -1d0))
endfor
endif

;print,'index1, psi=',psi
;print,'index1, cosal(index1)=',cosal(index1)
;print,'index2, cosal(index2)=',cosal(index2)
 
;#########################################################################
; bending angle for trajectories going through the turning point  
if(count2 ge 1) then begin 
for iang=0,count2-1 do begin
cosalpha=cosal(index2(iang))
sinalpha=sqrt(1d0-cosalpha^2)
; b/r_S
brg=radrg/sqrt(1d0-rinv)*sinalpha
th=acos(bcr/brg)
; P/radrg
prg=-2d0/c3*brg*cos((th+pi2)/3d0)
;print,'cosalpha=',cosalpha
; check that p^3= b^2(p-1)
;print,'p=',prg,' p^3=',prg^3,' b^2(p-1)=',brg^2*(prg-1d0)
;stop 

; psi_max(P)
psimax_p=psi_exact(0.d0,prg)
psix=2d0*psimax_p-psi_exact(abs(cosalpha),radrg)
psi(index2(iang))=psix

tlag_prg=del_exact(0d0,prg)
;jp
tlag=0.d0 ; tlag=del_exact(abs(cosalpha),radrg) 
timedelay(index2(iang))=2d0*tlag_prg - tlag + 2d0*(radrg - prg + alog((radrg -1d0)/(prg -1d0))) $
                       + radref - radrg  + alog((radref -1d0)/(radrg -1d0))
endfor
endif

;stop 
;print,'index2, psi=',psi

cospsi=cos(psi)
sinpsi=sin(psi)

;#########################################################################
; derivative d cospsi /d cosal
for i=0,nang-1 do begin 
i0=i-1 & i2=i+1 
if(i eq 0) then begin 
i0=i & i1=i+1 & i2=i+2
der(i)=(-cospsi(i2)-3*cospsi(i0)+4*cospsi(i1))/(2.*hal) 
endif else if(i eq nang-1) then begin 
i0=i & i1=i-1 & i2=i-2 
der(i)=(-cospsi(i2)-3*cospsi(i0)+4*cospsi(i1))/(-2.*hal) 
endif else  der(i)=(cospsi(i2)-cospsi(i0))/(2.*hal)
;print,'i=',i,' der(i)=',der(i)
endfor 
; derivative computed with cosal=cosalcr+grid^2*(1d0-cosalcr)
;der=abs(der)/(2d0*grid*(1d0-cosalcr))
; derivative computed with cosal=cosalcr+grid*(1d0-cosalcr)
;der=(der)/(1d0-cosalcr)
; derivative d cosal/ d cospsi /(1-u)
;der=-1d0/der/(1d0-rinv)

for i=0,nang-1 do begin 
der(i)=-1d0/(1d0-rinv)/der(i)*(1d0-cosalcr)  
endfor 

 
xpsi=psi 
ycosal=cosal 
yder=der 
;print,'in psialpha xpsi=',xpsi
;print,'in psialpha ycosal=',ycosal
;print,'in psialpha der=',der
;print,'in psialpha yder=',yder

spline_alppsi=spl_init(xpsi,ycosal,/double) ; spline for function cosalpha(psi)
spline_der=spl_init(xpsi,yder,/double) ; spline for function der(psi) = abs(dcospsi/dcosalpha)/(1-u)

 
return
end 
 


;##############################################################################
; computes derivative d col(alpha)/d cospsi /(1-u) 
function der_exact,psi
common psi,xpsi,ycosal,spline_alppsi
common derivcom,yder,spline_der
derivat=spl_interp(xpsi,yder,spline_der,psi,/double)
return, derivat
end



;#######################################
; derivative for the approximation function  
function deriv_mynew,radrg,psi
cospsi=cos(psi)
y=1d0-cospsi 
u=1d0/radrg 
ncos=1 
const=1d2/exp(1d0) ; 37d0   
func= 1d0+y*u*(u*y*3d0/112d0-(2d0*alog(1d0-y/2d0)+y*(1d0-3d0*y/4d0)/(1d0-y/2d0))/const)  
return,func
end
;#########


;##############################################################################
function bend_exact,psi
common psi,xpsi,ycosal,spline_alppsi
cosalpha=spl_interp(xpsi,ycosal,spline_alppsi,psi)
;cosalpha=interpol(ycosal,xpsi,psi,/quadratic)
return, cosalpha
end

;#######################################
; approximation function  cosalpha(psi)
function bend_mynew,radrg,psi 
cospsi=cos(psi)
y=1d0-cospsi 
u=1d0/radrg 
ncos=1d0

; from Poutanen 2020 
const=exp(1d0)/1d2
func= 1d0-(1d0-u)*y*(1d0+u^2*y^2/112d0-u^ncos*y*(alog(1d0-y/2d0)+y/2d0)*const) 

return,func
end
;#########

  

;#######################################
; approximation function  Beloborodov 2002  
function B02_func,radrg,cospsi 
y=1d0-cospsi 
u=1d0/radrg 
func= 1d0-(1d0-u)*y
return,func
end
;#########


;##############################################################################
function derpsi,flag_bend,psi,radrg
if(flag_bend eq 'AB') then begin 
u=1d0/radrg 
y=1d0-cos(psi)
der=1d0 + y^2 * 0d0 ; u^2*3d0/112d0  ; 
endif

if(flag_bend eq 'mynew') then der=deriv_mynew(radrg,psi)
if(flag_bend eq 'exact') then der=der_exact(psi)
if(flag_bend eq 'no') then der=1d0 +0d0*psi
return,der
end


;##############################################################################
; bending of light in Schwarzschild metric
function func_bending,flag_bend,psi,radrg
;  using Andrei's formula

if(flag_bend eq 'AB') then begin 
u=1d0/radrg 
y=1d0-cos(psi)
cosalpha=1d0-y*(1d0-u)
endif
if(flag_bend eq 'mynew') then cosalpha=bend_mynew(radrg,psi)
if(flag_bend eq 'exact') then cosalpha=bend_exact(psi)
if(flag_bend eq 'no') then cosalpha=cos(psi)
return, cosalpha
end


 
 

;#########################################################
; angular distribution of the line intensity
function angline,mu
common param_line,sigma_line,flag_bend,line_diag
if(line_diag eq 'line') then inten=mu*alog(1d0+1d0/mu)
if(line_diag eq 'iso') then  inten=1d0+0d0*mu 
return,inten
end

;#######################################
; Gaussian line 
function gauss_line,x
common param_line,sigma_line,flag_bend,line_diag
func=exp(-(x-1d0)^2/2d0/sigma_line^2)/sigma_line 
return,func
end

; 
;
;#############################################  
; read local spectrum times energy xI_x 
pro read_local_spectum,filename,nang_local,nx,energy_local,cosangle_local,StokesI_local,StokesQ_local,poldeg_local,polang_local

openr,1,filename 

aa=' '
for i=0,6 do begin
readf,1,aa 
endfor

readf,1,nx,nang_local 
nang_local=nang_local/2

print,'nx=',nx,' nang_local=',nang_local

energy_local=fltarr(nx)
cosangle_local=fltarr(nang_local)
readf,1,aa 
readf,1,cosangle_local  
readf,1,aa 

stok_I= fltarr(nang_local) 
stok_Q= fltarr(nang_local) 

StokesI_local= fltarr(nx,nang_local) 
StokesQ_local= fltarr(nx,nang_local) 
poldeg_local = fltarr(nx,nang_local) 
polang_local= fltarr(nx,nang_local) 

b=0. 

for i=0,nx-1 do begin 
readf,1,b,stok_Q,stok_I 
energy_local(i)=b 
StokesQ_local(i,*)=stok_Q*b
StokesI_local(i,*)=stok_I*b 
poldeg_local(i,*)=stok_Q/stok_I 
polang_local(i,*)= 0. 
endfor 

close,1 


 
return
end
;############################################# 
;############################################# 
;############################################# 
;############################################# 
; program  computes Stokes parameters for an 
; accretion disc in Schwarzschild metric
;############################################# 

 !P.FONT = -1 ;  Hershey vector font system   
  set_plot,'PS'
  
 device,/COLOR,  bits_per_pixel=8
; DEVICE, /TIMES, /ITALIC, FONT_INDEX=4 ; ,  FONT_SIZE=12 
; DEVICE, /TIMES, FONT_INDEX=5
; DEVICE, /TIMES,/ITALIC,/BOLD, FONT_INDEX=6 
; DEVICE, /TIMES,/GOTHIC,/GERMAN,/BOLD, FONT_INDEX=7 
  
common parbend,radrg_vec,nrad,cospsi_all,cosal_all,index_psi
common param_line,sigma_line,flag_bend,line_diag

; DEVICE, XSIZE=17.5, SCALE_FACTOR=0.67
; DEVICE, YSIZE=12.5, SCALE_FACTOR=0.67
 
 
 
 nth=4

!P.THICK=nth
!P.CHARSIZE=1.0
!P.TICKLEN=0.04
; one plot
!P.MULTI=0

;common psi,x,y,y2
;common psi,psiall,cosap2,y2
;common deriv,der,yder2
;common radius,rinv,redshift,betakepler,lorentz 


colors           
 
 
 
;################ CONSTANTS #####################################
 pi=3.141592653589792384d0
 pi2=2d0*pi
 c=2.99792458d10     ; cm/s speed of light
 solarmass=1.98892d33    ; g 
 gravconstant=6.67384d-8 ; 
 Schwarzschild_radius_solar=2d0*gravconstant*solarmass/c^2 

Boltzmann_constant=1.380649d-16  ; Boltzmann constant  
sigmasb= 5.670374419d-5 ; Stefan-Boltzmann constant 

; const = (R_6/D_10kpc)^2 
cm_parsec =  3.2404d-23 ; 1cm/10kpc 

kparsec=  3.0857d21 ; kpc/cm 
; planckconstant=6.62607004d-27
ergkev=6.2415d8 ; erg/keV  6.241495962d8 ; 1 eV = 1.602176565D-12 
; 1 keV = 1000eV/ h  = 2.417989178D+17   Hz 
; constbb =hzkeV^4 * 2*h/c^2 for blackbody = 5.04036542d22 
keV_K= 1.6045250061598d6 ; from keV to K 
 
  
;######################################### 
;#########################################  
; compute Stokes vector from an accretion disc 
; polarization and angular distribution as from Comptonization in optically thin electron scattering atmosphere 
; here we assumed that this spectrum does not vary with radius, while its normalization varies as in standard disc 
;


;#########################################  
; read local spectrum 
read_local_spectum,'compton_intpol_trunc_ssc_IXPE.dat',nang_local,nx,energy_local,cosangle_local,StokesI_local,StokesQ_local,poldeg_local,polang_local
;#########################################  
 

print,'fig_compton' 
fig_compton=1
if(fig_compton eq 1)  then begin 

flag_read=0
;if(flag_read eq 0) then begin



;####################### 
; inclinations where Stokes vectors are computed 
;nincl=7
;incl_deg=[75.,70.,60.,50.,40.,30.,20.] 

nincl=4
incl_deg=[75.,60.,45.,30.] 
incl_rad=incl_deg*!DPI/180d0 
cosincl=cos(incl_rad)
sinincl=sin(incl_rad) 
;#######################
; alternatively one can take the same angles as in local models 
;nincl=nang_local
;cosincl=cosangle_local
;sinincl=sqrt(1.d0-cosincl^2)



;####################### 
; energies where  Stokes vectors are computed 
nene=51 ; number of energy bins 
energy=10^(dindgen(nene)/(nene-1d0)*5d0 -1.5d0) ; grid of energies in keV 
;#######################
; alternatively one can take the same energies as in local models 
nene=nx 
energy=energy_local

;#########################################  
; PARAMETERS 
;#########################################  
radmin=3d0  ; inner radius in R_S 
radmax=5d1  ; outer radius in R_S 

area=!DPI*(radmax^2-radmin^2)

; luminosity transformation 
;#########################################  
 

nphi=101 
step_phi=2d0*!DPI/float(nphi) 
phi=dindgen(nphi)*step_phi
cosphi=cos(phi) ; for the whole ring
sinphi=sin(phi) ; for the whole ring
;phi=[!DPI]
phideg=phi*180d0/!DPI


nang= 201 ; number of points for alpha(psi) light bending routine 

; vector of radii in log scale 
nrad=101
step_log_u=alog(radmax/radmin)/(nrad-1)
radrg_vec= exp(dindgen(nrad)*step_log_u+alog(radmin))
radinv_vec=1d0/radrg_vec

const_rad=step_log_u   







;#######################
stokes_vec=dblarr(2,nincl,nene,3) 
lum_vec=dblarr(nene,2,nincl) 
pd_vec=dblarr(nene,2,nincl) 
pa_vec=dblarr(nene,2,nincl) 
 
stokes_norel=dblarr(2,nincl,nene,3) 
lum_norel=dblarr(nene,2,nincl) 
pd_norel=dblarr(nene,2,nincl) 
pa_norel=dblarr(nene,2,nincl) 


ratsinalphapsi=dblarr(nphi)
chitot=dblarr(nphi)
chiGR=dblarr(nphi)
chiSR=dblarr(nphi)
chiSR_flat=dblarr(nphi)

;chitot_all_rad=dblarr(nphi,nrad,2,nincl)


;####################
for incl=0,nincl-1 do begin
;for incl=0,0 do begin 
sini=sinincl(incl)
cosi=cosincl(incl)

print,'sini=',sini,' cosi=',cosi 



;####################
for icase=1,1 do begin 
if(icase eq 0) then flag_bend='exact'
if(icase eq 1) then flag_bend='mynew'

print,flag_bend

 
sum_rad_I=dblarr(nene)
sum_rad_Q=dblarr(nene)
sum_rad_U=dblarr(nene)

sum_rad_I_norel=dblarr(nene)
sum_rad_Q_norel=dblarr(nene)
sum_rad_U_norel=dblarr(nene)


;####################
; integral over radius 
for irad=0,nrad-1 do begin 

sum_phi_sca=dblarr(nene)
sum_phi_I=dblarr(nene)
sum_phi_Q=dblarr(nene)
sum_phi_U=dblarr(nene)

sum_phi_I_norel=dblarr(nene)
sum_phi_Q_norel=dblarr(nene)
sum_phi_U_norel=dblarr(nene)

radrg=radrg_vec(irad)
radref=radrg 
radinv=1d0/radrg ; u 
redshift=sqrt(1d0-radinv)
beta_vel=sqrt(radinv/2d0/(1d0-radinv))
gamma_vel=sqrt((1d0-radinv)/(1d0-1.5d0*radinv))

;radial dependence of the flux as function of dimensionless compactness u=R_S/r 
; for standard disc in Schwarzschild metric 
flux_u= flux_rad_adaf(radinv)

;print,'radrg=',radrg,' flux_u=',flux_u

 
if(flag_bend eq 'exact') then psialpha,radrg,radrg,cospsi,psi,cospsi_AB,cosalcr,alphaall,cosal,der,timedelay,nang 

cospsi_element= sini*cosphi 
psi_element=acos(cospsi_element)
sinpsi_element=sqrt(1d0-cospsi_element^2)

cosalpha=func_bending(flag_bend,psi_element,radrg)
deriv_alpsi=derpsi(flag_bend,psi_element,radrg) ; derivative

sinalpha=sqrt(1d0-cosalpha^2) 
indexal_small=where(sinalpha  lt 1d-2,ncountal_small,COMPLEMENT=indexal_large,NCOMPLEMENT=ncountal_large)
if(ncountal_small gt 0) then ratsinalphapsi(indexal_small)=redshift_theta 
if(ncountal_large gt 0) then ratsinalphapsi(indexal_large)=sinalpha(indexal_large)/sinpsi_element(indexal_large) 

cosxi=-ratsinalphapsi*sini*sinphi 
coszeta=ratsinalphapsi*cosi
doppler=1d0/gamma_vel/(1d0-beta_vel*cosxi)
full_redshift=redshift*doppler  ; g 
coszetapr=coszeta*doppler  
zetapr=acos(coszetapr)
zetapr_deg=zetapr*180d0/!DPI

flux_fac4=full_redshift^4*coszeta*deriv_alpsi*flux_u ; normalization multiplied by the flux at given radius 
flux_fac4_norel=cosi*flux_u


b=(cosalpha-cospsi_element)/(1d0-cosalpha*cospsi_element)
tanchiGR= b*cosi*sinphi/(sini+b*cosphi)
chiGR=atan(tanchiGR)

tanchiSR=-beta_vel*cosalpha*coszeta/(1-coszeta^2-beta_vel*cosxi)
chiSR=atan(tanchiSR)
chitot=chiGR+chiSR 


cos2chitot=cos(2d0*chitot)
sin2chitot=sin(2d0*chitot)

flagprint=0
if(flagprint eq 1) then begin
print,'radrg=',radrg,' u=',radinv 
print,'temp_fac_u=',temp_fac_u
print,'cospsi_element=',cospsi_element
print,'cosalpha=',cosalpha
print,'lensing=',deriv_alpsi
print,'ratsinalphapsi=',ratsinalphapsi
print,'cosxi=',cosxi
print,'doppler=',doppler
print,'full_redshift=',full_redshift
print,'coszeta=',coszeta
print,'coszetapr=',coszetapr
print,'flux_fac4=',flux_fac4
print,'chitot=',chitot*180./!DPI
print,'cos2chitot=',cos2chitot
print,'sin2chitot=',sin2chitot
endif

; energy loop  
for iene=0,nene-1 do begin 
x=energy(iene) ; energy in keV
xpr= x/full_redshift; Vector of xprime energies for different phi but fixed radius 

; polarization degree as a function of local zenith angle and local energy 
;  ############ local model poldeg_local ############
poldeg= interp2d_jp(poldeg_local,energy_local,cosangle_local,xpr,coszetapr) ; this is a vector of dimension nphi 
poldeg_norel= interp2d_jp(poldeg_local,energy_local,cosangle_local,x,cosi) ; this is a scalar 

 
;interp2d_jp,z,x,y,x1,y1
; z_ij  - matrix defined for x_i ,y_j  
; x     - monotonic vector of x_i values 
; y     - monotonic vector of y_j values 
; x1,y1 - coordinates where function z should be computed; vectors should have the same dimension


; intensity xI_x as a function of local cosine zenith angle coszetapr and comoving energy xpr in keV
;  ############ local model xI_x = StokesI_local ############
compton_intensity= interp2d_jp(StokesI_local,energy_local,cosangle_local,xpr,coszetapr); this is a vector of dimension nphi 
compton_intensity_norel= interp2d_jp(StokesI_local,energy_local,cosangle_local,x,cosi); this is a scalar 


phi_int=total(compton_intensity*flux_fac4) ; integrating over phi Stokes I 
phi_q=total(compton_intensity*flux_fac4*poldeg*cos2chitot) ; integrating over phi Stokes Q 
phi_u=total(compton_intensity*flux_fac4*poldeg*sin2chitot) ; integrating over phi Stokes U 

phi_norel=nphi*(compton_intensity_norel*flux_fac4_norel)  ;  integrating over phi  


sum_phi_I_norel(iene)=  phi_norel
sum_phi_Q_norel(iene)=  phi_norel*poldeg_norel
sum_phi_U_norel(iene)=  0.

sum_phi_I(iene)=  phi_int
sum_phi_Q(iene)=  phi_q
sum_phi_U(iene)=  phi_u
endfor 
; end of energy loop  


sum_phi_I=sum_phi_I*step_phi ; these are vectors of dimension nene 
sum_phi_Q=sum_phi_Q*step_phi 
sum_phi_U=sum_phi_U*step_phi  

sum_phi_I_norel=sum_phi_I_norel*step_phi ; these are vectors of dimension nene 
sum_phi_Q_norel=sum_phi_Q_norel*step_phi 
sum_phi_U_norel=sum_phi_U_norel*step_phi 

; energy loop  
for iene=0,nene-1 do begin 
sum_rad_I(iene)=sum_rad_I(iene)+sum_phi_I(iene)*radrg^2/redshift  ; integrating over radius 
sum_rad_Q(iene)=sum_rad_Q(iene)+sum_phi_Q(iene)*radrg^2/redshift  ; integrating over radius 
sum_rad_U(iene)=sum_rad_U(iene)+sum_phi_U(iene)*radrg^2/redshift  ; integrating over radius 
endfor 

for iene=0,nene-1 do begin 
sum_rad_I_norel(iene)=sum_rad_I_norel(iene)+sum_phi_I_norel(iene)*radrg^2  ; integrating over radius 
sum_rad_Q_norel(iene)=sum_rad_Q_norel(iene)+sum_phi_Q_norel(iene)*radrg^2  ; integrating over radius 
sum_rad_U_norel(iene)=sum_rad_U_norel(iene)+sum_phi_U_norel(iene)*radrg^2  ; integrating over radius 
endfor 

; end of energy loop  
  
endfor ;  end of radius loop 

sum_rad_I=sum_rad_I*const_rad
sum_rad_Q=sum_rad_Q*const_rad
sum_rad_U=sum_rad_U*const_rad

sum_rad_I_norel=sum_rad_I_norel*const_rad
sum_rad_Q_norel=sum_rad_Q_norel*const_rad
sum_rad_U_norel=sum_rad_U_norel*const_rad
 
stokes_vec(icase,incl,*,0)=sum_rad_I
stokes_vec(icase,incl,*,1)=sum_rad_Q
stokes_vec(icase,incl,*,2)=sum_rad_U

stokes_norel(icase,incl,*,0)=sum_rad_I_norel
stokes_norel(icase,incl,*,1)=sum_rad_Q_norel
stokes_norel(icase,incl,*,2)=sum_rad_U_norel

lum_vec(*,icase,incl)=sum_rad_I /area; * dilution ; observed flux xF_x 
pd_vec(*,icase,incl)=sqrt(sum_rad_Q^2+sum_rad_U^2)/sum_rad_I*100. ; PD 
pa_vec(*,icase,incl)=0.5d0*atan(sum_rad_U,sum_rad_Q)*180d0/!DPI ; PA in degrees 
index_pa=where(pa_vec(*,icase,incl) gt 90.,ncount_pa)
if(ncount_pa gt 0) then pa_vec(index_pa,icase,incl)=pa_vec(index_pa,icase,incl)-180.d0 

lum_norel(*,icase,incl)=sum_rad_I_norel /area ; * dilution ; observed flux xF_x 
pd_norel(*,icase,incl)=sum_rad_Q_norel/sum_rad_I_norel*100. ; PD 
pa_norel(*,icase,incl)=0. ; PA in degrees 

endfor ; case 
endfor ; incl


flag_print=0
if(flag_print eq 1)  then begin  ;;; Printing into file
  openw,2,'stokes_truncated_disk.dat' 
  printf,2,nincl,nene,nrad,nphi
  printf,2,energy
  for icase=1,1 do begin 
    for incl=0,nincl-1 do begin 
      printf,2,lum_norel(*,icase,incl)
      printf,2,pd_norel(*,icase,incl)
      printf,2,pa_norel(*,icase,incl)
      printf,2,lum_vec(*,icase,incl)
      printf,2,pd_vec(*,icase,incl)
      printf,2,pa_vec(*,icase,incl)
    endfor 
  endfor
  close,2 
endif else begin  ;;; Printing into terminal
  print,nincl,nene,nrad,nphi
  print,energy
  for icase=1,1 do begin 
    for incl=0,nincl-1 do begin 
      print,lum_norel(*,icase,incl)
      print,pd_norel(*,icase,incl)
      print,pa_norel(*,icase,incl)
      print,lum_vec(*,icase,incl)
      print,pd_vec(*,icase,incl)
      print,pa_vec(*,icase,incl)
    endfor 
  endfor
endelse



;endif else begin  ; flag_read 

openr,1,'stokes_truncated_disk.dat' 
readf,1,nincl,nene,nrad,nphi

lum_vec_dc=dblarr(nene,2,nincl) 
pd_vec_dc=dblarr(nene,2,nincl) 
pa_vec_dc=dblarr(nene,2,nincl)
lum_norel_dc=dblarr(nene,2,nincl) 
pd_norel_dc=dblarr(nene,2,nincl) 
pa_norel_dc=dblarr(nene,2,nincl) 

vector_dc=dblarr(nene)
energy_dc=dblarr(nene)
vector_phi_dc=dblarr(nphi)

readf,1,energy	
for icase=1,1 do begin 
for incl=0,nincl-1 do begin 
readf,1,vector_dc
lum_norel_dc(*,icase,incl)=vector_dc
readf,1,vector_dc
pd_norel_dc(*,icase,incl)=vector_dc
readf,1,vector_dc
pa_norel_dc(*,icase,incl)=vector_dc
readf,1,vector_dc
lum_vec_dc(*,icase,incl)=vector_dc
readf,1,vector_dc
pd_vec_dc(*,icase,incl)=vector_dc
readf,1,vector_dc
pa_vec_dc(*,icase,incl)=vector_dc
endfor 
endfor

close,1 


;endelse 

endif   



!P.FONT = 0  
set_plot,'PS'

namefile='fig_pol_comp_slab.eps'
device,filename=namefile,xsize=12.,ysize=15.,XOFF=2.,YOFF=4., /portrait,/COLOR,/CMYK  
 DEVICE, /TIMES, /ITALIC, FONT_INDEX=4 ,  FONT_SIZE=12
 DEVICE, /TIMES, FONT_INDEX=5,  FONT_SIZE=12 
 DEVICE, /TIMES,/ITALIC,/BOLD, FONT_INDEX=6,  FONT_SIZE=12 



!P.CHARSIZE=1.3

px=[0.18,0.98]

pymin=0.10 &pymax=0.99 
pydel=0.01

;pyheight=(pymax-pymin-2*pydel)/3. 
pyheight=(pymax-pymin-pydel)/2. 
py=dblarr(6)
py(0)=pymin
py(1)=py(0)+pyheight
py(2)=py(1)+pydel
py(3)=py(2)+pyheight
py(4)=py(3)+pydel
py(5)=pymax 

nx_sand=17
xx_sand=dblarr(nx_sand)
pol_sand=dblarr(nx_sand,4)
pa_sand=dblarr(nx_sand,4)



linevec=[0,2,1,3,0,2,1,3]
colvec=[2,7,4,11,0,13,3,8,6]   
;#
;######################################
 ; luminosity 
 xmin=9e-1 
 xmax=5e1 
 
 ymin=3e-2 
 ymax=5e-0 

xout3=0.83 
yshift3=0.07
scai=1.7 

;###################################### 
  ; PD  

 ypdmin=0.0
 ypdmax=11.0

plot_oi,[1d0,1d0],[1d0,1d0], $
xthick=nth,ythick=nth,  position=[px(0),py(2),px(1),py(3)], $ 
ytitle='!5PD (%)', $
xrange=[xmin,xmax],xstyle=1 , $ 
yrange=[ypdmin,ypdmax], ystyle=1 ,$
yminor=2, $
xtickname=replicate(' ',10), $ 
/nodata  ,/noerase


for incl=0,nincl-1 do begin 
  oplot,energy,pd_vec(*,1,incl),line=1,col=colvec(incl)
  oplot,energy,pd_vec_dc(*,1,incl),line=2,col=colvec(incl)
endfor 


xx_ixpe_low=[2.0,2.0]
xx_ixpe_high=[8.0,8.0]
yyrange=[ypdmin,ypdmax]
oplot,xx_ixpe_low,yyrange,line=0,col=0,thick=0.8
oplot,xx_ixpe_high,yyrange,line=0,col=0,thick=0.8


xyouts,xout3,py(3)-yshift3,'!5A',size=scai ,/normal

;######################################
  ; PA 

  ypamin=-5.0
  ypamax=10.0
 
plot_oi,[1d0,1d0],[1d0,1d0], $
xthick=nth,ythick=nth,  position=[px(0),py(0),px(1),py(1)], $ 
ytitle='!5PA (deg)', $
xtitle='!4E!5 (keV)', $
xrange=[xmin,xmax],xstyle=1 , $ 
yrange=[ypamin,ypamax], ystyle=1 ,$
yminor=2, $
xtickname=['1','10'], $
/nodata  ,/noerase
xyouts,px(0)+0.23,py(0)-0.046,'!53',size=1.35 ,/normal


for incl=0,nincl-1 do begin 
  oplot,energy,-pa_vec(*,1,incl),line=1,col=colvec(incl)
  oplot,energy,-pa_vec_dc(*,1,incl),line=2,col=colvec(incl)
endfor 


yyrange=[ypamin,ypamax]
oplot,xx_ixpe_low,yyrange,line=0,col=0,thick=0.8
oplot,xx_ixpe_high,yyrange,line=0,col=0,thick=0.8


xyouts,xout3,py(1)-yshift3,'!5B',size=scai ,/normal
 

 device,/close
  print,' postscript plot saved to file ',namefile  


    
end 



