#!/bin/bash

#PBS -N multi_p_mon
#PBS -l nodes=1:ppn=1
#PBS -l mem=100gb
#PBS -l walltime=23:59:00
#PBS -M clare.stephens@unsw.edu.au
#PBS -m ae

# note v2 is the same as previous run, but soiln and PAR are output at the monthly patch scale
# note v3 has longer spinup for sub3

cd /srv/scratch/z5100106/EastForest/P9_CC_Spatial/coweeta_ws18_200615/ws18_nlcd_local

#### Drier ####

scen=sD-N-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

scen=sD-N-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

scen=sD-H-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

scen=sD-H-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

#### Wetter ####

scen=sW-N-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349


scen=sW-H-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

scen=sW-N-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349


scen=sW-H-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

#### No change in rainfall ####

scen=sN-N-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349


scen=sN-H-N

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349

scen=sN-N-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349


scen=sN-H-C

sed -r "s|XXXXXX|$scen|g" clim/cwt_template.base > clim/cwt.base

./../RHESSysEastCoast-master_200602/rhessysEC.7.2 -st 2000 1 1 1 -ed 2100 1 1 1 -g -p -dynRtZoff -BGC_flag -fracDirectNdep 0.5 -soilCNadaptation_flag -gwtoriparian -t tecfiles/tec_monthly.txt -w worldfiles_explicitsoil/worldfile_sN-N-N_4 -whdr worldfiles_explicitsoil/worldfile.hdr -r flows_explicitsoil/subflow.txt flows_explicitsoil/surfflow.txt -pre output/$scen/"$scen"_v4 -gw 0.070137985 0.182591017 0.020775085 -s 0.46018885 2.450695357 1.649059224 -snowEs 0.901410678 -snowTs 1.960512263 -sv 2.437420002 2.724601881 -svalt 0.653790501 1.289108349
