source('https://raw.githubusercontent.com/laurencelin/Date_analysis/master/LIB_dailytimeseries3.R')


rain = read.table('cwt.rain',skip=1)
rain.date = seq(as.Date('1937-1-1'),length.out=dim(rain)[1],by=1) # "1937-01-01" "2014-12-31"
tmin = read.table('cwt.tmin',skip=1)# 
tmax = read.table('cwt.tmax',skip=1)# 
temp.date = seq(as.Date('1937-1-1'),length.out=dim(tmin)[1],by=1) # "1937-01-01" "2015-12-31"
all.date = intersectDate(list(rain.date, temp.date)) # "1937-01-01" "2014-12-31"
rain.dtsm = match(all.date, rain.date)
temp.dtsm = match(all.date, temp.date)

extend_index = extendingTimeSeries(all.date)
header = gsub(' 0',' ',format(extend_index$extended_Dates[1],'%Y %m %d 1'))

write(header, 'cwt_ext.rain')
write.table(rain[rain.dtsm,1][extend_index$extended_Index],'cwt_ext.rain',row.names=F,col.names=F, append=T)

write(header, 'cwt_ext.tmin')
write.table(tmin[temp.dtsm,1][extend_index$extended_Index],'cwt_ext.tmin',row.names=F,col.names=F, append=T)

write(header, 'cwt_ext.tmax')
write.table(tmax[temp.dtsm,1][extend_index$extended_Index],'cwt_ext.tmax',row.names=F,col.names=F, append=T)





