from lightweaver.atomic_model import *
from lightweaver.collisional_rates import *
from lightweaver.broadening import *
from lightweaver.atomic_table import Element
Al_atom = lambda: \
AtomicModel(element=Element(Z=13),
	levels=[
		AtomicLevel(E=    74.693, g=6, label="AL I 3S2 3P 2PO", stage=0, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 25347.707, g=2, label="AL I 3S2 4S 2SE", stage=0, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E= 29096.996, g=12, label="AL I 3S 3P2 4PE", stage=0, J=Fraction(11, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E= 32436.309, g=10, label="AL I 3S2 3D 2DE", stage=0, J=Fraction(9, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 32960.414, g=6, label="AL I 3S2 4P 2PO", stage=0, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 37689.332, g=2, label="AL I 3S2 5S 2SE", stage=0, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E= 38932.105, g=10, label="AL I 3S2 4D 2DE", stage=0, J=Fraction(9, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 40275.949, g=6, label="AL I 3S2 5P 2PO", stage=0, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 41318.785, g=14, label="AL I 3S2 4F 2FO", stage=0, J=Fraction(13, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E= 48279.102, g=1, label="AL II 3S2 1SE", stage=1, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 85795.703, g=9, label="AL II 3S 3P 3PO", stage=1, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=108128.812, g=3, label="AL II 3S 3P 1PO", stage=1, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=133758.109, g=5, label="AL II 3P2: 1DE", stage=1, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E=139550.266, g=3, label="AL II 3S 4S 3SE", stage=1, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=142486.188, g=9, label="AL II 3P2 3PE", stage=1, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=143627.344, g=1, label="AL II 3S 4S 1SE", stage=1, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=143826.625, g=15, label="AL II 3S 3D 3DE", stage=1, J=Fraction(7, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=200139.281, g=1, label="AL III 3S 2SE", stage=2, J=Fraction(0, 1), L=0, S=Fraction(1, 2)),
	],
	lines=[
		VoigtLine(j=5, i=0, f=1.447e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.25e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=1, f=1.215e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.57e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=4, f=2.583e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.25e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=1, f=2.010e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.04e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=5, f=1.715e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.04e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=3, i=0, f=1.597e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.69e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=3, f=1.640e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.57e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=3, f=9.020e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.04e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=0, f=5.883e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.7e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=4, f=8.050e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.7e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=6, f=2.150e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.04e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=3, f=3.620e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=6, f=8.310e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=9, f=1.840e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.47e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=11, f=1.443e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.64e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=11, f=5.600e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=147000)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=10, f=1.300e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=10, f=6.122e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.31e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=10, f=9.000e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.21e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
	],
	continua=[
		ExplicitContinuum(j=9, i=0, wavelengthGrid=[13.813, 17.829, 21.846, 25.862, 29.879, 33.895, 37.911, 41.928, 45.944, 49.96, 53.977, 57.993, 62.01, 66.026, 70.042, 74.059, 78.075, 82.092, 86.108, 90.124, 94.141, 98.157, 102.174, 106.19, 110.206, 114.223, 118.239, 122.255, 126.272, 130.288, 134.305, 138.321, 142.337, 146.354, 150.37, 154.387, 158.403, 162.419, 166.436, 170.452, 174.469, 178.485, 182.501, 186.518, 190.534, 194.55, 198.567, 202.583, 206.6, 210.616], alphaGrid=[3.719e-25, 7.947e-25, 1.46e-24, 2.421e-24, 3.739e-24, 5.482e-24, 7.642e-24, 1.038e-23, 1.364e-23, 1.754e-23, 2.221e-23, 2.757e-23, 3.373e-23, 3.679e-23, 3.738e-23, 4.306e-23, 5.504e-23, 8.581e-23, 8.603e-23, 1.243e-22, 1.505e-22, 2.266e-22, 2.881e-22, 4.487e-22, 6.203e-22, 6.451e-22, 7.048e-22, 7.977e-22, 7.857e-22, 8.592e-22, 1.161e-21, 1.281e-21, 1.075e-21, 9.195e-22, 1.038e-21, 1.33e-21, 1.659e-21, 1.99e-21, 2.33e-21, 2.712e-21, 3.173e-21, 3.709e-21, 4.262e-21, 4.746e-21, 5.113e-21, 5.363e-21, 5.513e-21, 5.606e-21, 5.657e-21, 5.68e-21]),
		ExplicitContinuum(j=9, i=1, wavelengthGrid=[16.472, 25.322, 34.173, 43.023, 51.874, 60.724, 69.575, 78.425, 87.275, 96.126, 104.976, 113.827, 122.677, 131.528, 140.378, 149.228, 158.079, 166.929, 175.78, 184.63, 193.481, 202.331, 211.182, 220.032, 228.882, 237.733, 246.583, 255.434, 264.284, 273.135, 281.985, 290.835, 299.686, 308.536, 317.387, 326.237, 335.088, 343.938, 352.788, 361.639, 370.489, 379.34, 388.19, 397.041, 405.891, 414.741, 423.592, 432.442, 441.293, 450.143], alphaGrid=[9.28e-25, 5.01e-26, 3.07e-25, 5.924e-25, 3.416e-24, 3.73e-24, 1.632e-23, 2.666e-23, 1.679e-23, 9.558e-23, 1.277e-22, 2.906e-23, 5.566e-22, 1.99e-21, 3.825e-21, 5.395e-21, 6.321e-21, 6.549e-21, 6.223e-21, 5.549e-21, 4.71e-21, 3.843e-21, 3.031e-21, 2.321e-21, 1.726e-21, 1.246e-21, 8.701e-22, 5.845e-22, 3.732e-22, 2.217e-22, 1.172e-22, 4.872e-23, 7.123e-24, 1.43e-23, 2.168e-23, 1.933e-23, 1.059e-23, 2.035e-24, 1.66e-23, 3.183e-23, 4.673e-23, 6.066e-23, 7.32e-23, 8.412e-23, 9.328e-23, 1.007e-22, 1.064e-22, 1.104e-22, 1.128e-22, 1.139e-22]),
		ExplicitContinuum(j=9, i=2, wavelengthGrid=[15.174, 18.522, 21.871, 25.219, 28.568, 31.916, 35.264, 38.613, 41.961, 45.31, 48.658, 52.007, 55.355, 58.703, 62.052, 65.4, 68.749, 72.097, 75.445, 78.794, 82.142, 85.491, 88.839, 92.188, 95.536, 98.884, 102.233, 105.581, 108.93, 112.278, 115.626, 118.975, 122.323, 125.672, 129.02, 132.368, 135.717, 139.065, 142.414, 145.762, 149.111, 152.459, 155.807, 159.156, 162.504, 165.853, 169.201, 172.549, 175.898, 179.246, 521.319191959423], alphaGrid=[6.668e-25, 1.198e-24, 1.971e-24, 3.019e-24, 4.387e-24, 6.11e-24, 8.237e-24, 1.081e-23, 1.386e-23, 1.743e-23, 2.158e-23, 2.634e-23, 3.174e-23, 3.784e-23, 4.467e-23, 5.224e-23, 6.071e-23, 7.196e-23, 8.539e-23, 9.989e-23, 1.141e-22, 1.292e-22, 1.457e-22, 1.716e-22, 2.148e-22, 2.815e-22, 3.726e-22, 4.764e-22, 5.785e-22, 6.752e-22, 7.703e-22, 8.663e-22, 9.623e-22, 1.058e-21, 1.158e-21, 1.265e-21, 1.386e-21, 1.522e-21, 1.673e-21, 1.838e-21, 2.016e-21, 2.202e-21, 2.393e-21, 2.582e-21, 2.761e-21, 2.922e-21, 3.058e-21, 3.163e-21, 3.235e-21, 3.273e-21, 3.273e-21]),
		ExplicitContinuum(j=9, i=3, wavelengthGrid=[16.835, 29.986, 43.136, 56.287, 69.437, 82.588, 95.739, 108.889, 122.04, 135.191, 148.341, 161.492, 174.642, 187.793, 200.944, 214.094, 227.245, 240.395, 253.546, 266.697, 279.847, 292.998, 306.148, 319.299, 332.45, 345.6, 358.751, 371.902, 385.052, 398.203, 411.353, 424.504, 437.655, 450.805, 463.956, 477.106, 490.257, 503.408, 516.558, 529.709, 542.859, 556.01, 569.161, 582.311, 595.462, 608.613, 621.763, 634.914, 648.065, 661.215], alphaGrid=[7.159e-25, 2.652e-24, 7.91e-24, 1.964e-23, 4.449e-23, 8.421e-23, 1.71e-22, 2.88e-22, 6.876e-22, 2.391e-21, 4.708e-21, 6.353e-21, 6.86e-21, 6.46e-21, 5.589e-21, 4.594e-21, 3.674e-21, 2.916e-21, 2.334e-21, 1.912e-21, 1.619e-21, 1.425e-21, 1.305e-21, 1.238e-21, 1.207e-21, 1.2e-21, 1.209e-21, 1.228e-21, 1.253e-21, 1.28e-21, 1.308e-21, 1.336e-21, 1.362e-21, 1.387e-21, 1.409e-21, 1.429e-21, 1.448e-21, 1.464e-21, 1.478e-21, 1.49e-21, 1.501e-21, 1.51e-21, 1.517e-21, 1.523e-21, 1.528e-21, 1.532e-21, 1.535e-21, 1.537e-21, 1.538e-21, 1.539e-21]),
		ExplicitContinuum(j=9, i=4, wavelengthGrid=[18.664, 32.274, 45.885, 59.495, 73.106, 86.716, 100.327, 113.937, 127.547, 141.158, 154.768, 168.379, 181.989, 195.599, 209.21, 222.82, 236.431, 250.041, 263.651, 277.262, 290.872, 304.483, 318.093, 331.704, 345.314, 358.924, 372.535, 386.145, 399.756, 413.366, 426.976, 440.587, 454.197, 467.808, 481.418, 495.029, 508.639, 522.249, 535.86, 549.47, 563.081, 576.691, 590.301, 603.912, 617.522, 631.133, 644.743, 658.353, 671.964, 685.574], alphaGrid=[8.38e-25, 1.714e-24, 4.507e-24, 7.014e-25, 2.428e-23, 6.539e-23, 8.158e-23, 1.844e-23, 8.467e-22, 3.894e-21, 6.572e-21, 7.152e-21, 6.065e-21, 4.374e-21, 2.804e-21, 1.641e-21, 9.065e-22, 5.11e-22, 3.486e-22, 3.301e-22, 3.914e-22, 4.909e-22, 6.031e-22, 7.137e-22, 8.153e-22, 9.051e-22, 9.822e-22, 1.047e-21, 1.102e-21, 1.147e-21, 1.184e-21, 1.215e-21, 1.24e-21, 1.26e-21, 1.277e-21, 1.291e-21, 1.302e-21, 1.311e-21, 1.319e-21, 1.325e-21, 1.33e-21, 1.334e-21, 1.337e-21, 1.34e-21, 1.342e-21, 1.343e-21, 1.344e-21, 1.345e-21, 1.346e-21, 1.346e-21]),
		ExplicitContinuum(j=9, i=5, wavelengthGrid=[19.175, 39.466, 59.758, 80.049, 100.34, 120.632, 140.923, 161.214, 181.506, 201.797, 222.089, 242.38, 262.671, 282.963, 303.254, 323.545, 343.837, 364.128, 384.419, 404.711, 425.002, 445.293, 465.585, 485.876, 506.167, 526.459, 546.75, 567.041, 587.333, 607.624, 627.915, 648.207, 668.498, 688.789, 709.081, 729.372, 749.663, 769.955, 790.246, 810.537, 830.829, 851.12, 871.411, 891.703, 911.994, 932.285, 952.576, 972.868, 993.159, 1013.45], alphaGrid=[2.256e-25, 2.01e-25, 4.254e-24, 1.366e-23, 2.59e-23, 2.371e-23, 3.64e-21, 7.846e-21, 7.178e-21, 4.325e-21, 1.962e-21, 6.665e-22, 1.301e-22, 2.184e-23, 2.364e-23, 1.283e-23, 4.554e-23, 6.407e-23, 6.991e-23, 6.746e-23, 6.08e-23, 5.28e-23, 4.52e-23, 3.885e-23, 3.412e-23, 3.095e-23, 2.919e-23, 2.857e-23, 2.889e-23, 2.986e-23, 3.129e-23, 3.302e-23, 3.491e-23, 3.686e-23, 3.88e-23, 4.065e-23, 4.24e-23, 4.401e-23, 4.548e-23, 4.679e-23, 4.793e-23, 4.892e-23, 4.977e-23, 5.049e-23, 5.107e-23, 5.153e-23, 5.188e-23, 5.214e-23, 5.231e-23, 5.24e-23]),
		ExplicitContinuum(j=9, i=6, wavelengthGrid=[20.029, 43.303, 66.577, 89.851, 113.125, 136.399, 159.673, 182.947, 206.221, 229.495, 252.769, 276.043, 299.317, 322.59, 345.864, 369.138, 392.412, 415.686, 438.96, 462.234, 485.508, 508.782, 532.056, 555.33, 578.604, 601.878, 625.152, 648.426, 671.7, 694.974, 718.248, 741.522, 764.796, 788.07, 811.344, 834.618, 857.892, 881.166, 904.44, 927.714, 950.988, 974.262, 997.536, 1020.81, 1044.084, 1067.358, 1090.632, 1113.906, 1137.179, 1160.453], alphaGrid=[1.71e-24, 1.417e-24, 1.421e-23, 6.991e-23, 8.601e-22, 2.639e-21, 3.628e-21, 3.71e-21, 3.361e-21, 2.905e-21, 2.48e-21, 2.127e-21, 1.848e-21, 1.632e-21, 1.464e-21, 1.335e-21, 1.234e-21, 1.154e-21, 1.092e-21, 1.042e-21, 1.001e-21, 9.686e-22, 9.419e-22, 9.199e-22, 9.014e-22, 8.862e-22, 8.733e-22, 8.624e-22, 8.532e-22, 8.453e-22, 8.387e-22, 8.33e-22, 8.282e-22, 8.24e-22, 8.204e-22, 8.173e-22, 8.147e-22, 8.125e-22, 8.105e-22, 8.089e-22, 8.074e-22, 8.064e-22, 8.053e-22, 8.046e-22, 8.038e-22, 8.034e-22, 8.029e-22, 8.026e-22, 8.024e-22, 8.022e-22]),
		ExplicitContinuum(j=9, i=7, wavelengthGrid=[21.498, 49.157, 76.816, 104.476, 132.135, 159.794, 187.453, 215.112, 242.772, 270.431, 298.09, 325.749, 353.408, 381.068, 408.727, 436.386, 464.045, 491.705, 519.364, 547.023, 574.682, 602.341, 630.0, 657.66, 685.319, 712.978, 740.637, 768.296, 795.956, 823.615, 851.274, 878.933, 906.592, 934.251, 961.911, 989.57, 1017.229, 1044.888, 1072.547, 1100.207, 1127.866, 1155.525, 1183.184, 1210.843, 1238.502, 1266.162, 1293.821, 1321.48, 1349.139, 1376.798], alphaGrid=[8.744e-25, 2.24e-24, 1.557e-23, 1.524e-23, 7.956e-22, 7.284e-21, 5.625e-21, 1.775e-21, 2.286e-22, 8.987e-24, 1.209e-22, 2.411e-22, 3.268e-22, 3.948e-22, 4.6e-22, 5.282e-22, 5.993e-22, 6.713e-22, 7.418e-22, 8.091e-22, 8.719e-22, 9.296e-22, 9.819e-22, 1.029e-21, 1.071e-21, 1.109e-21, 1.142e-21, 1.171e-21, 1.197e-21, 1.22e-21, 1.24e-21, 1.258e-21, 1.273e-21, 1.286e-21, 1.298e-21, 1.308e-21, 1.317e-21, 1.324e-21, 1.331e-21, 1.336e-21, 1.341e-21, 1.345e-21, 1.348e-21, 1.351e-21, 1.353e-21, 1.355e-21, 1.356e-21, 1.357e-21, 1.358e-21, 1.358e-21]),
		ExplicitContinuum(j=9, i=8, wavelengthGrid=[27.077, 59.222, 91.366, 123.511, 155.656, 187.8, 219.945, 252.09, 284.234, 316.379, 348.524, 380.668, 412.813, 444.958, 477.102, 509.247, 541.392, 573.536, 605.681, 637.826, 669.97, 702.115, 734.26, 766.404, 798.549, 830.693, 862.838, 894.983, 927.127, 959.272, 991.417, 1023.561, 1055.706, 1087.851, 1119.995, 1152.14, 1184.285, 1216.429, 1248.574, 1280.719, 1312.863, 1345.008, 1377.153, 1409.297, 1441.442, 1473.587, 1505.731, 1537.876, 1570.021, 1602.165], alphaGrid=[6.058e-25, 4.208e-24, 4.173e-23, 2.579e-24, 5.437e-21, 4.068e-21, 2.045e-22, 2.825e-23, 4.069e-23, 1.399e-23, 3.331e-23, 5.768e-24, 3.549e-23, 7.327e-23, 1.06e-22, 1.374e-22, 1.708e-22, 2.078e-22, 2.484e-22, 2.917e-22, 3.363e-22, 3.811e-22, 4.249e-22, 4.67e-22, 5.067e-22, 5.439e-22, 5.781e-22, 6.095e-22, 6.379e-22, 6.636e-22, 6.867e-22, 7.073e-22, 7.256e-22, 7.418e-22, 7.561e-22, 7.686e-22, 7.796e-22, 7.891e-22, 7.974e-22, 8.044e-22, 8.104e-22, 8.155e-22, 8.197e-22, 8.232e-22, 8.261e-22, 8.283e-22, 8.3e-22, 8.312e-22, 8.32e-22, 8.324e-22]),
		ExplicitContinuum(j=17, i=9, wavelengthGrid=[12.065, 13.361, 14.657, 15.954, 17.25, 18.546, 19.843, 21.139, 22.435, 23.732, 25.028, 26.324, 27.621, 28.917, 30.213, 31.509, 32.806, 34.102, 35.398, 36.695, 37.991, 39.287, 40.584, 41.88, 43.176, 44.473, 45.769, 47.065, 48.361, 49.658, 50.954, 52.25, 53.547, 54.843, 56.139, 57.436, 58.732, 60.028, 61.324, 62.621, 63.917, 65.213, 66.51, 67.806], alphaGrid=[6.149e-24, 8.353e-24, 1.103e-23, 1.423e-23, 1.8e-23, 2.16e-23, 2.385e-23, 2.482e-23, 2.533e-23, 2.667e-23, 2.812e-23, 2.924e-23, 3.001e-23, 3.062e-23, 3.114e-23, 3.182e-23, 3.233e-23, 3.259e-23, 3.266e-23, 3.246e-23, 3.21e-23, 3.193e-23, 3.211e-23, 3.235e-23, 3.228e-23, 3.181e-23, 3.105e-23, 3.028e-23, 2.965e-23, 2.916e-23, 2.875e-23, 2.835e-23, 2.793e-23, 2.754e-23, 2.725e-23, 2.715e-23, 2.726e-23, 2.757e-23, 2.801e-23, 2.855e-23, 2.909e-23, 2.955e-23, 2.989e-23, 3.013e-23]),
		ExplicitContinuum(j=17, i=10, wavelengthGrid=[12.36, 14.146, 15.932, 17.718, 19.503, 21.289, 23.075, 24.861, 26.647, 28.432, 30.218, 32.004, 33.79, 35.576, 37.362, 39.147, 40.933, 42.719, 44.505, 46.291, 48.076, 49.862, 51.648, 53.434, 55.22, 57.006, 58.791, 60.577, 62.363, 64.149, 65.935, 67.72, 69.506, 71.292, 73.078, 74.864, 76.65, 78.435, 80.221, 82.007, 83.793, 85.579, 87.364, 89.15, 90.936], alphaGrid=[1.17e-23, 1.756e-23, 2.319e-23, 2.503e-23, 2.705e-23, 2.96e-23, 3.178e-23, 3.362e-23, 3.526e-23, 3.663e-23, 3.792e-23, 3.898e-23, 3.986e-23, 4.045e-23, 4.057e-23, 4.045e-23, 4.043e-23, 4.059e-23, 4.077e-23, 4.081e-23, 4.068e-23, 4.038e-23, 3.996e-23, 3.943e-23, 3.881e-23, 3.821e-23, 3.775e-23, 3.757e-23, 3.786e-23, 3.868e-23, 4.002e-23, 4.183e-23, 4.419e-23, 4.692e-23, 4.981e-23, 5.287e-23, 5.585e-23, 5.877e-23, 6.137e-23, 6.38e-23, 6.576e-23, 6.745e-23, 6.878e-23, 6.961e-23, 7.044e-23]),
		ExplicitContinuum(j=17, i=11, wavelengthGrid=[12.784, 15.036, 17.288, 19.54, 21.792, 24.044, 26.296, 28.548, 30.8, 33.052, 35.304, 37.556, 39.808, 42.06, 44.312, 46.564, 48.816, 51.068, 53.32, 55.572, 57.824, 60.076, 62.328, 64.58, 66.832, 69.084, 71.336, 73.588, 75.84, 78.092, 80.344, 82.596, 84.848, 87.1, 89.352, 91.604, 93.856, 96.108, 98.36, 100.612, 102.864, 105.116, 107.368, 109.62, 111.872, 114.124], alphaGrid=[1.136e-23, 1.849e-23, 2.155e-23, 2.433e-23, 2.676e-23, 2.894e-23, 3.071e-23, 3.181e-23, 3.278e-23, 3.36e-23, 3.429e-23, 3.488e-23, 3.521e-23, 3.489e-23, 3.444e-23, 3.557e-23, 3.54e-23, 3.167e-23, 3.088e-23, 3.162e-23, 3.016e-23, 2.822e-23, 2.834e-23, 3.079e-23, 3.365e-23, 3.481e-23, 3.369e-23, 3.195e-23, 3.246e-23, 3.692e-23, 4.556e-23, 5.667e-23, 6.847e-23, 7.995e-23, 9.131e-23, 1.036e-22, 1.18e-22, 1.352e-22, 1.553e-22, 1.774e-22, 2.003e-22, 2.225e-22, 2.416e-22, 2.568e-22, 2.679e-22, 2.749e-22]),
		ExplicitContinuum(j=17, i=12, wavelengthGrid=[13.419, 16.634, 19.848, 23.063, 26.278, 29.493, 32.708, 35.923, 39.138, 42.353, 45.568, 48.782, 51.997, 55.212, 58.427, 61.642, 64.857, 68.072, 71.287, 74.502, 77.716, 80.931, 84.146, 87.361, 90.576, 93.791, 97.006, 100.221, 103.436, 106.65, 109.865, 113.08, 116.295, 119.51, 122.725, 125.94, 129.155, 132.37, 135.584, 138.799, 142.014, 145.229, 148.444, 151.659, 154.874, 158.089, 161.304], alphaGrid=[1.116e-23, 2.016e-23, 2.386e-23, 2.782e-23, 3.108e-23, 3.369e-23, 3.57e-23, 3.748e-23, 3.893e-23, 4.011e-23, 4.129e-23, 4.241e-23, 4.413e-23, 4.998e-23, 5.398e-23, 5.475e-23, 5.564e-23, 6.28e-23, 7.181e-23, 7.715e-23, 8.268e-23, 9.361e-23, 1.114e-22, 1.359e-22, 1.684e-22, 2.092e-22, 2.548e-22, 2.992e-22, 3.358e-22, 3.625e-22, 3.81e-22, 3.966e-22, 4.168e-22, 4.482e-22, 4.953e-22, 5.594e-22, 6.421e-22, 7.401e-22, 8.446e-22, 9.532e-22, 1.058e-21, 1.156e-21, 1.245e-21, 1.314e-21, 1.377e-21, 1.409e-21, 1.441e-21]),
		ExplicitContinuum(j=17, i=13, wavelengthGrid=[14.93, 18.474, 22.018, 25.562, 29.107, 32.651, 36.195, 39.739, 43.283, 46.827, 50.371, 53.915, 57.459, 61.003, 64.547, 68.091, 71.635, 75.18, 78.724, 82.268, 85.812, 89.356, 92.9, 96.444, 99.988, 103.532, 107.076, 110.62, 114.164, 117.708, 121.253, 124.797, 128.341, 131.885, 135.429, 138.973, 142.517, 146.061, 149.605, 153.149, 156.693, 160.237, 163.782, 167.326, 170.87, 174.414, 177.958], alphaGrid=[1.178e-23, 1.777e-23, 1.991e-23, 2.32e-23, 2.55e-23, 2.856e-23, 3.023e-23, 3.149e-23, 3.245e-23, 3.325e-23, 3.447e-23, 2.817e-23, 1.743e-23, 1.473e-23, 1.475e-23, 1.559e-23, 1.992e-23, 2.634e-23, 2.989e-23, 2.708e-23, 2.101e-23, 1.62e-23, 1.405e-23, 1.316e-23, 1.276e-23, 1.344e-23, 1.591e-23, 1.966e-23, 2.316e-23, 2.479e-23, 2.366e-23, 2.074e-23, 1.782e-23, 1.704e-23, 2.025e-23, 2.953e-23, 4.517e-23, 6.571e-23, 8.986e-23, 1.169e-22, 1.444e-22, 1.708e-22, 1.95e-22, 2.147e-22, 2.322e-22, 2.419e-22, 2.508e-22]),
		ExplicitContinuum(j=17, i=14, wavelengthGrid=[15.314, 19.062, 22.809, 26.557, 30.305, 34.053, 37.801, 41.549, 45.297, 49.045, 52.793, 56.54, 60.288, 64.036, 67.784, 71.532, 75.28, 79.028, 82.776, 86.524, 90.272, 94.019, 97.767, 101.515, 105.263, 109.011, 112.759, 116.507, 120.255, 124.003, 127.75, 131.498, 135.246, 138.994, 142.742, 146.49, 150.238, 153.986, 157.734, 161.482, 165.229, 168.977, 172.725, 176.473, 180.221, 183.969, 187.717], alphaGrid=[2.143e-23, 2.976e-23, 3.652e-23, 4.149e-23, 4.434e-23, 4.65e-23, 4.811e-23, 4.942e-23, 4.978e-23, 4.653e-23, 4.702e-23, 4.47e-23, 4.576e-23, 4.656e-23, 5.027e-23, 5.428e-23, 6.155e-23, 7.63e-23, 8.95e-23, 9.173e-23, 8.178e-23, 6.352e-23, 4.254e-23, 2.471e-23, 1.397e-23, 1.095e-23, 1.274e-23, 1.582e-23, 1.713e-23, 1.638e-23, 1.556e-23, 1.808e-23, 2.744e-23, 4.612e-23, 7.808e-23, 1.221e-22, 1.745e-22, 2.336e-22, 2.985e-22, 3.626e-22, 4.261e-22, 4.816e-22, 5.347e-22, 5.73e-22, 6.092e-22, 6.284e-22, 6.475e-22]),
		ExplicitContinuum(j=17, i=15, wavelengthGrid=[15.813, 19.642, 23.47, 27.299, 31.128, 34.956, 38.785, 42.613, 46.442, 50.271, 54.099, 57.928, 61.757, 65.585, 69.414, 73.243, 77.071, 80.9, 84.729, 88.557, 92.386, 96.214, 100.043, 103.872, 107.7, 111.529, 115.358, 119.186, 123.015, 126.844, 130.672, 134.501, 138.33, 142.158, 145.987, 149.815, 153.644, 157.473, 161.301, 165.13, 168.959, 172.787, 176.616, 180.445, 184.273, 188.102, 191.931], alphaGrid=[1.267e-23, 1.602e-23, 2.016e-23, 2.062e-23, 2.263e-23, 3.033e-23, 2.497e-23, 2.348e-23, 3.727e-23, 3.127e-23, 1.758e-23, 1.778e-23, 2.846e-23, 3.415e-23, 2.63e-23, 8.561e-24, 7.654e-24, 9.315e-24, 1.278e-23, 6.461e-23, 1.458e-22, 2.54e-22, 3.842e-22, 5.305e-22, 6.884e-22, 8.509e-22, 1.014e-21, 1.175e-21, 1.329e-21, 1.476e-21, 1.613e-21, 1.739e-21, 1.854e-21, 1.958e-21, 2.051e-21, 2.134e-21, 2.208e-21, 2.271e-21, 2.325e-21, 2.372e-21, 2.41e-21, 2.442e-21, 2.469e-21, 2.487e-21, 2.504e-21, 2.511e-21, 2.519e-21]),
		ExplicitContinuum(j=17, i=16, wavelengthGrid=[16.432, 20.262, 24.093, 27.923, 31.753, 35.584, 39.414, 43.244, 47.075, 50.905, 54.736, 58.566, 62.396, 66.227, 70.057, 73.887, 77.718, 81.548, 85.378, 89.209, 93.039, 96.869, 100.7, 104.53, 108.36, 112.191, 116.021, 119.851, 123.682, 127.512, 131.342, 135.173, 139.003, 142.833, 146.664, 150.494, 154.325, 158.155, 161.985, 165.816, 169.646, 173.476, 177.307, 181.137, 184.967, 188.798, 192.628], alphaGrid=[9.646e-24, 1.447e-23, 1.716e-23, 1.969e-23, 2.315e-23, 2.609e-23, 2.912e-23, 3.253e-23, 3.656e-23, 3.98e-23, 4.366e-23, 4.624e-23, 5.25e-23, 5.529e-23, 6.322e-23, 7.647e-23, 9.883e-23, 1.194e-22, 1.346e-22, 1.484e-22, 1.663e-22, 1.942e-22, 2.314e-22, 2.696e-22, 3.016e-22, 3.27e-22, 3.535e-22, 3.885e-22, 4.347e-22, 4.945e-22, 5.646e-22, 6.451e-22, 7.376e-22, 8.447e-22, 9.688e-22, 1.11e-21, 1.267e-21, 1.435e-21, 1.611e-21, 1.784e-21, 1.948e-21, 2.104e-21, 2.232e-21, 2.34e-21, 2.429e-21, 2.482e-21, 2.525e-21]),
	],
	collisions=[
		CE(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[8.315e-15, 5.048e-15, 3.649e-15, 2.598e-15, 1.369e-15, 9.559e-16]),
		CE(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.716e-15, 1.03e-15, 7.356e-16, 5.149e-16, 2.574e-16, 1.716e-16]),
		CE(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.209e-15, 4.37e-15, 3.154e-15, 2.241e-15, 1.175e-15, 8.18e-16]),
		CE(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.515e-15, 9.088e-16, 6.491e-16, 4.544e-16, 2.272e-16, 1.515e-16]),
		CE(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.027e-16, 3.045e-16, 2.196e-16, 1.559e-16, 8.149e-17, 5.66e-17]),
		CE(j=6, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.93e-15, 1.169e-15, 8.425e-16, 5.979e-16, 3.124e-16, 2.169e-16]),
		CE(j=7, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.239e-15, 7.434e-16, 5.31e-16, 3.717e-16, 1.859e-16, 1.239e-16]),
		CE(j=8, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.208e-15, 7.246e-16, 5.176e-16, 3.623e-16, 1.812e-16, 1.208e-16]),
		CE(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.329e-14, 7.971e-15, 5.694e-15, 3.986e-15, 1.993e-15, 1.329e-15]),
		CE(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.027e-15, 4.216e-15, 3.012e-15, 2.108e-15, 1.054e-15, 7.027e-16]),
		CE(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.555e-14, 5.117e-14, 4.07e-14, 3.279e-14, 2.319e-14, 1.959e-14]),
		CE(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.036e-15, 2.422e-15, 1.73e-15, 1.211e-15, 6.054e-16, 4.036e-16]),
		CE(j=6, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.667e-15, 2.2e-15, 1.571e-15, 1.1e-15, 5.5e-16, 3.667e-16]),
		CE(j=7, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.286e-15, 7.937e-16, 5.825e-16, 4.238e-16, 2.37e-16, 1.73e-16]),
		CE(j=8, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.119e-15, 1.871e-15, 1.337e-15, 9.356e-16, 4.678e-16, 3.119e-16]),
		CE(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.492e-14, 8.95e-15, 6.393e-15, 4.475e-15, 2.237e-15, 1.492e-15]),
		CE(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.289e-14, 7.736e-15, 5.526e-15, 3.868e-15, 1.934e-15, 1.289e-15]),
		CE(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.797e-15, 3.478e-15, 2.484e-15, 1.739e-15, 8.696e-16, 5.797e-16]),
		CE(j=6, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.065e-15, 3.039e-15, 2.171e-15, 1.519e-15, 7.597e-16, 5.065e-16]),
		CE(j=7, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.456e-15, 2.673e-15, 1.91e-15, 1.337e-15, 6.684e-16, 4.456e-16]),
		CE(j=8, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.076e-15, 2.445e-15, 1.747e-15, 1.223e-15, 6.113e-16, 4.076e-16]),
		CE(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[9.254e-14, 6.942e-14, 5.705e-14, 4.547e-14, 2.854e-14, 2.091e-14]),
		CE(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[9.482e-15, 5.689e-15, 4.064e-15, 2.845e-15, 1.422e-15, 9.482e-16]),
		CE(j=6, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.668e-15, 4.601e-15, 3.286e-15, 2.3e-15, 1.15e-15, 7.668e-16]),
		CE(j=7, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.098e-16, 6.93e-17, 5.188e-17, 3.87e-17, 2.284e-17, 1.718e-17]),
		CE(j=8, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.436e-14, 2.164e-14, 1.618e-14, 1.205e-14, 7.107e-15, 5.356e-15]),
		CE(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.381e-14, 3.717e-14, 2.977e-14, 2.348e-14, 1.526e-14, 1.16e-14]),
		CE(j=6, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.453e-14, 5.153e-14, 4.16e-14, 3.399e-14, 2.42e-14, 1.99e-14]),
		CE(j=7, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[6.809e-15, 4.085e-15, 2.918e-15, 2.043e-15, 1.021e-15, 6.809e-16]),
		CE(j=8, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.959e-15, 3.576e-15, 2.554e-15, 1.788e-15, 8.939e-16, 5.959e-16]),
		CE(j=6, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.008e-14, 2.405e-14, 1.718e-14, 1.202e-14, 6.012e-15, 4.008e-15]),
		CE(j=7, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.776e-13, 1.405e-13, 1.247e-13, 1.126e-13, 9.573e-14, 8.701e-14]),
		CE(j=8, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.372e-14, 8.234e-15, 5.882e-15, 4.117e-15, 2.059e-15, 1.372e-15]),
		CE(j=7, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.416e-13, 1.137e-13, 9.964e-14, 8.632e-14, 6.275e-14, 5.088e-14]),
		CE(j=8, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.462e-13, 1.147e-13, 1.008e-13, 8.951e-14, 7.215e-14, 6.302e-14]),
		CE(j=8, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.776e-14, 2.866e-14, 2.047e-14, 1.433e-14, 7.165e-15, 4.776e-15]),
		Omega(j=10, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.1191, 0.1686, 0.212, 0.2701, 0.4328, 0.5702]),
		Omega(j=11, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.0, 1.416, 1.78, 2.268, 3.634, 4.787]),
		Omega(j=12, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.02987, 0.04227, 0.05314, 0.06773, 0.1085, 0.143]),
		Omega(j=13, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.02675, 0.03786, 0.0476, 0.06066, 0.09719, 0.128]),
		Omega(j=14, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.02537, 0.0359, 0.04513, 0.05752, 0.09216, 0.1214]),
		Omega(j=15, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.02486, 0.03518, 0.04423, 0.05637, 0.09031, 0.119]),
		Omega(j=16, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.02477, 0.03506, 0.04407, 0.05617, 0.09, 0.1186]),
		Omega(j=11, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.563, 3.627, 4.56, 5.812, 9.311, 12.27]),
		Omega(j=12, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.7097, 1.004, 1.263, 1.609, 2.578, 3.397]),
		Omega(j=13, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.7618, 1.078, 1.355, 1.727, 2.767, 3.646]),
		Omega(j=14, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.281, 4.643, 5.837, 7.439, 11.92, 15.7]),
		Omega(j=15, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.5183, 0.7335, 0.9221, 1.175, 1.883, 2.481]),
		Omega(j=16, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.637, 6.563, 8.251, 10.52, 16.85, 22.2]),
		Omega(j=12, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.003796, 0.005373, 0.006754, 0.008608, 0.01379, 0.01817]),
		Omega(j=13, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.4814, 0.6814, 0.8565, 1.092, 1.749, 2.304]),
		Omega(j=14, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.4143, 0.5864, 0.7372, 0.9395, 1.505, 1.983]),
		Omega(j=15, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.5659, 0.801, 1.007, 1.283, 2.056, 2.709]),
		Omega(j=16, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.3885, 0.5499, 0.6913, 0.881, 1.411, 1.86]),
		Omega(j=13, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[13.74, 19.45, 24.45, 31.17, 49.93, 65.79]),
		Omega(j=14, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[6.902, 9.768, 12.28, 15.65, 25.07, 33.03]),
		Omega(j=15, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.614, 7.946, 9.989, 12.73, 20.4, 26.87]),
		Omega(j=16, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.429, 7.684, 9.659, 12.31, 19.72, 25.99]),
		Omega(j=14, i=13, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[25.83, 36.55, 45.95, 58.56, 93.82, 123.6]),
		Omega(j=15, i=13, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[14.88, 21.05, 26.47, 33.73, 54.04, 71.2]),
		Omega(j=16, i=13, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[13.73, 19.43, 24.43, 31.13, 49.88, 65.71]),
		Omega(j=15, i=14, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[379.0, 536.4, 674.3, 859.4, 1377.0, 1814.0]),
		Omega(j=16, i=14, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[289.2, 409.3, 514.5, 655.8, 1051.0, 1384.0]),
		Omega(j=16, i=15, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[790.0, 1118.0, 1406.0, 1791.0, 2870.0, 3781.0]),
		CI(j=9, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.284e-15, 1.284e-15, 1.284e-15, 1.284e-15, 1.284e-15, 1.284e-15]),
		CI(j=9, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.42e-18, 4.42e-18, 4.42e-18, 4.42e-18, 4.42e-18, 4.42e-18]),
		CI(j=9, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.058e-15, 2.058e-15, 2.058e-15, 2.058e-15, 2.058e-15, 2.058e-15]),
		CI(j=9, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.838e-15, 1.838e-15, 1.838e-15, 1.838e-15, 1.838e-15, 1.838e-15]),
		CI(j=9, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.273e-15, 1.273e-15, 1.273e-15, 1.273e-15, 1.273e-15, 1.273e-15]),
		CI(j=9, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.159e-16, 1.159e-16, 1.159e-16, 1.159e-16, 1.159e-16, 1.159e-16]),
		CI(j=9, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.164e-15, 1.164e-15, 1.164e-15, 1.164e-15, 1.164e-15, 1.164e-15]),
		CI(j=9, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.488e-15, 2.488e-15, 2.488e-15, 2.488e-15, 2.488e-15, 2.488e-15]),
		CI(j=9, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.196e-15, 3.196e-15, 3.196e-15, 3.196e-15, 3.196e-15, 3.196e-15]),
		CI(j=17, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.892e-19, 4.892e-19, 4.892e-19, 4.892e-19, 4.892e-19, 4.892e-19]),
		CI(j=17, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.257e-17, 1.257e-17, 1.257e-17, 1.257e-17, 1.257e-17, 1.257e-17]),
		CI(j=17, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[6.049e-17, 6.049e-17, 6.049e-17, 6.049e-17, 6.049e-17, 6.049e-17]),
		CI(j=17, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.291e-16, 4.291e-16, 4.291e-16, 4.291e-16, 4.291e-16, 4.291e-16]),
		CI(j=17, i=13, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.709e-17, 3.709e-17, 3.709e-17, 3.709e-17, 3.709e-17, 3.709e-17]),
		CI(j=17, i=14, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[6.656e-17, 6.656e-17, 6.656e-17, 6.656e-17, 6.656e-17, 6.656e-17]),
		CI(j=17, i=15, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.606e-15, 1.606e-15, 1.606e-15, 1.606e-15, 1.606e-15, 1.606e-15]),
		CI(j=17, i=16, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[9.018e-16, 9.018e-16, 9.018e-16, 9.018e-16, 9.018e-16, 9.018e-16]),
])

BaII_CRD_atom = lambda: \
AtomicModel(element=Element(Z=56),
	levels=[
		AtomicLevel(E=     0.000, g=2, label="BA II 5P6 6S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=  4873.850, g=4, label="BA II 5P6 5D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=  5674.825, g=6, label="BA II 5P6 5D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 20261.562, g=2, label="BA II 5P6 6P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 21952.427, g=4, label="BA II 5P6 6P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 80686.867, g=1, label="BA III GROUND TERM", stage=2, J=None, L=None, S=None),
	],
	lines=[
		VoigtLine(j=3, i=0, f=3.490e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=30, Nlambda=80), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=0, f=7.280e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=30, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=1, f=1.050e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=1, f=2.500e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=5, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=2, f=1.390e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
	],
	continua=[
		HydrogenicContinuum(j=5, i=0, NlambdaGen=20, alpha0=2.2e-23, minWavelength=35),
		HydrogenicContinuum(j=5, i=1, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=2, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=3, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
		HydrogenicContinuum(j=5, i=4, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
	],
	collisions=[
		Omega(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.348, 10.4, 13.07, 16.66, 26.69, 35.17, 79.74]),
		Omega(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.69, 8.053, 10.12, 12.9, 20.67, 27.23, 61.76]),
		Omega(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.341, 3.313, 4.165, 5.308, 8.504, 11.2, 25.41]),
		Omega(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.268, 6.04, 7.593, 9.678, 15.5, 20.43, 46.32]),
		Omega(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[305.3, 432.1, 543.2, 692.3, 1109.0, 1461.0, 3313.0]),
		Omega(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.236, 3.165, 3.979, 5.071, 8.124, 10.7, 24.27]),
		Omega(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[0.4469, 0.6325, 0.7951, 1.013, 1.624, 2.139, 4.85]),
		Omega(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.495, 4.946, 6.218, 7.925, 12.7, 16.73, 37.93]),
		Omega(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.04, 5.719, 7.189, 9.162, 14.68, 19.34, 43.85]),
		Omega(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[43.51, 61.57, 77.4, 98.65, 158.1, 208.2, 472.2]),
		CI(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18]),
		CI(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18]),
		CI(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18]),
		CI(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17]),
		CI(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17]),
])

BaII_iso_atom = lambda: \
AtomicModel(element=Element(Z=56),
	levels=[
		AtomicLevel(E=     0.000, g=2, label="BA II 5P6 6S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=  4873.850, g=4, label="BA II 5P6 5D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=  5674.825, g=6, label="BA II 5P6 5D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 20261.562, g=2, label="BA II 5P6 6P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 21952.427, g=4, label="BA II 5P6 6P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 80686.867, g=1, label="BA III GROUND TERM", stage=2, J=None, L=None, S=None),
	],
	lines=[
		VoigtLine(j=3, i=0, f=3.490e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=30, Nlambda=80), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=0, f=7.280e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=30, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=1, f=1.050e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=1, f=2.500e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=5, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=2, f=1.390e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
	],
	continua=[
		HydrogenicContinuum(j=5, i=0, NlambdaGen=20, alpha0=2.2e-23, minWavelength=35),
		HydrogenicContinuum(j=5, i=1, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=2, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=3, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
		HydrogenicContinuum(j=5, i=4, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
	],
	collisions=[
		Omega(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.348, 10.4, 13.07, 16.66, 26.69, 35.17, 79.74]),
		Omega(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.69, 8.053, 10.12, 12.9, 20.67, 27.23, 61.76]),
		Omega(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.341, 3.313, 4.165, 5.308, 8.504, 11.2, 25.41]),
		Omega(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.268, 6.04, 7.593, 9.678, 15.5, 20.43, 46.32]),
		Omega(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[305.3, 432.1, 543.2, 692.3, 1109.0, 1461.0, 3313.0]),
		Omega(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.236, 3.165, 3.979, 5.071, 8.124, 10.7, 24.27]),
		Omega(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[0.4469, 0.6325, 0.7951, 1.013, 1.624, 2.139, 4.85]),
		Omega(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.495, 4.946, 6.218, 7.925, 12.7, 16.73, 37.93]),
		Omega(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.04, 5.719, 7.189, 9.162, 14.68, 19.34, 43.85]),
		Omega(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[43.51, 61.57, 77.4, 98.65, 158.1, 208.2, 472.2]),
		CI(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18]),
		CI(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18]),
		CI(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18]),
		CI(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17]),
		CI(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17]),
])

BaII_stokes_atom = lambda: \
AtomicModel(element=Element(Z=56),
	levels=[
		AtomicLevel(E=     0.000, g=2, label="BA II 5P6 6S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=  4873.850, g=4, label="BA II 5P6 5D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=  5674.825, g=6, label="BA II 5P6 5D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 20261.562, g=2, label="BA II 5P6 6P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 21952.422, g=4, label="BA II 5P6 6P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 80686.867, g=1, label="BA III GROUND TERM", stage=2, J=None, L=None, S=None),
	],
	lines=[
		VoigtLine(j=3, i=0, f=3.490e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=20, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=0, f=7.280e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=20, Nlambda=80), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[3.0, 3.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=1, f=1.050e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.29e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=1, f=2.500e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=5, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=2, f=1.390e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=7, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[5.0, 5.0]), QuadraticStarkBroadening(coeff=1)])),
	],
	continua=[
		HydrogenicContinuum(j=5, i=0, NlambdaGen=20, alpha0=2.2e-23, minWavelength=35),
		HydrogenicContinuum(j=5, i=1, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=2, NlambdaGen=20, alpha0=1.5e-23, minWavelength=30),
		HydrogenicContinuum(j=5, i=3, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
		HydrogenicContinuum(j=5, i=4, NlambdaGen=20, alpha0=6.2e-23, minWavelength=60),
	],
	collisions=[
		Omega(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.348, 10.4, 13.07, 16.66, 26.69, 35.17, 79.74]),
		Omega(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.69, 8.053, 10.12, 12.9, 20.67, 27.23, 61.76]),
		Omega(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.341, 3.313, 4.165, 5.308, 8.504, 11.2, 25.41]),
		Omega(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.268, 6.04, 7.593, 9.678, 15.5, 20.43, 46.32]),
		Omega(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[305.3, 432.1, 543.2, 692.3, 1109.0, 1461.0, 3313.0]),
		Omega(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.236, 3.165, 3.979, 5.071, 8.124, 10.7, 24.27]),
		Omega(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[0.4469, 0.6325, 0.7951, 1.013, 1.624, 2.139, 4.85]),
		Omega(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.495, 4.946, 6.218, 7.925, 12.7, 16.73, 37.93]),
		Omega(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.04, 5.719, 7.189, 9.162, 14.68, 19.34, 43.85]),
		Omega(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[43.51, 61.57, 77.4, 98.65, 158.1, 208.2, 472.2]),
		CI(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18, 5.875e-18]),
		CI(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18, 4.263e-18]),
		CI(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18, 4.308e-18]),
		CI(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17, 2.211e-17]),
		CI(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17, 2.274e-17]),
])

C_atom = lambda: \
AtomicModel(element=Element(Z=6),
	levels=[
		AtomicLevel(E=    29.578, g=9, label="C I 2S2 2P2 3PE", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 10192.635, g=5, label="C I 2S2 2P2 1DE", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 21648.018, g=1, label="C I 2S2 2P2 1SE", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 33735.160, g=5, label="C I 2S 2P3 5SO", stage=0, J=Fraction(2, 1), L=0, S=Fraction(2, 1)),
		AtomicLevel(E= 60373.047, g=9, label="C I 2S2 2P 3S 3PO", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 61981.797, g=3, label="C I 2S2 2P 3S 1PO", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 64088.539, g=15, label="C I 2S 2P3 3DO", stage=0, J=Fraction(7, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 68856.305, g=3, label="C I 2S2 2P 3P 1PE", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 69722.023, g=15, label="C I 2S2 2P 3P 3DE", stage=0, J=Fraction(7, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 70743.898, g=3, label="C I 2S2 2P 3P 3SE", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E= 71374.891, g=9, label="C I 2S2 2P 3P 3PE", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 72610.750, g=5, label="C I 2S2 2P 3P 1DE", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 73975.891, g=1, label="C I 2S2 2P 3P 1SE", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 75254.875, g=9, label="C I 2S 2P3 3PO", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 90862.710, g=6, label="C II 2S2 2P 2PO", stage=1, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
	],
	lines=[
		VoigtLine(j=5, i=2, f=8.540e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.91e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=5, f=1.213e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.49e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=5, f=2.520e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.94e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=1, f=1.208e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.91e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=5, f=6.367e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.88e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=4, f=1.071e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.31e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=9, f=1.237e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.33e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=0, f=1.478e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.59e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=4, f=3.600e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.95e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=0, f=6.156e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.33e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=10, f=5.767e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.33e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=4, f=4.967e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.74e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=8, f=1.240e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.33e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=0, f=7.144e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.17e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=6, f=7.333e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.95e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=6, f=1.787e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=45), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.74e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
	],
	continua=[
		ExplicitContinuum(j=14, i=0, wavelengthGrid=[8.071, 10.167, 12.263, 14.359, 16.455, 18.55, 20.646, 22.742, 24.838, 26.934, 29.03, 31.126, 33.222, 35.317, 37.413, 39.509, 41.605, 43.701, 45.797, 47.893, 49.989, 52.085, 54.18, 56.276, 58.372, 60.468, 62.564, 64.66, 66.756, 68.852, 70.948, 73.043, 75.139, 77.235, 79.331, 81.427, 83.523, 85.619, 87.715, 89.81, 91.906, 94.002, 96.098, 98.194, 100.29, 102.386, 104.482, 106.578, 108.673, 110.769], alphaGrid=[4.401e-24, 8.739e-24, 1.531e-23, 2.455e-23, 3.69e-23, 5.282e-23, 7.273e-23, 9.708e-23, 1.263e-22, 1.609e-22, 2.012e-22, 2.477e-22, 3.008e-22, 3.61e-22, 4.35e-22, 5e-22, 5.524e-22, 5.985e-22, 6.228e-22, 7.265e-22, 7.409e-22, 7.74e-22, 8.2e-22, 8.544e-22, 9.046e-22, 9.768e-22, 1.006e-21, 1.039e-21, 1.086e-21, 1.133e-21, 1.178e-21, 1.23e-21, 1.276e-21, 1.322e-21, 1.386e-21, 1.426e-21, 1.418e-21, 1.423e-21, 1.484e-21, 1.576e-21, 1.643e-21, 1.67e-21, 1.676e-21, 1.684e-21, 1.698e-21, 1.715e-21, 1.731e-21, 1.744e-21, 1.751e-21, 1.755e-21]),
		ExplicitContinuum(j=14, i=1, wavelengthGrid=[7.336, 9.733, 12.131, 14.528, 16.925, 19.323, 21.72, 24.118, 26.515, 28.912, 31.31, 33.707, 36.104, 38.502, 40.899, 43.297, 45.694, 48.091, 50.489, 52.886, 55.283, 57.681, 60.078, 62.475, 64.873, 67.27, 69.668, 72.065, 74.462, 76.86, 79.257, 81.654, 84.052, 86.449, 88.847, 91.244, 93.641, 96.039, 98.436, 100.833, 103.231, 105.628, 108.026, 110.423, 112.82, 115.218, 117.615, 120.012, 122.41, 124.807], alphaGrid=[3.948e-24, 9.161e-24, 1.773e-23, 3.042e-23, 4.806e-23, 7.14e-23, 1.013e-22, 1.386e-22, 1.84e-22, 2.384e-22, 3.185e-22, 3.645e-22, 3.944e-22, 4.417e-22, 5.103e-22, 5.55e-22, 5.995e-22, 6.143e-22, 6.611e-22, 6.847e-22, 7.069e-22, 7.586e-22, 8.066e-22, 8.251e-22, 8.838e-22, 1.045e-21, 1.143e-21, 1.213e-21, 1.265e-21, 1.223e-21, 1.216e-21, 1.274e-21, 1.384e-21, 1.737e-21, 2.407e-21, 3.132e-21, 3.564e-21, 3.642e-21, 3.573e-21, 3.565e-21, 3.63e-21, 3.641e-21, 3.489e-21, 3.138e-21, 2.683e-21, 2.222e-21, 1.838e-21, 1.575e-21, 1.416e-21, 1.343e-21]),
		ExplicitContinuum(j=14, i=2, wavelengthGrid=[8.126, 10.932, 13.737, 16.543, 19.349, 22.154, 24.96, 27.766, 30.571, 33.377, 36.183, 38.988, 41.794, 44.6, 47.405, 50.211, 53.017, 55.822, 58.628, 61.434, 64.239, 67.045, 69.851, 72.656, 75.462, 78.268, 81.073, 83.879, 86.685, 89.49, 92.296, 95.102, 97.907, 100.713, 103.519, 106.324, 109.13, 111.936, 114.741, 117.547, 120.353, 123.158, 125.964, 128.769, 131.575, 134.381, 137.186, 139.992, 142.798, 145.603], alphaGrid=[4.947e-24, 1.196e-23, 2.375e-23, 4.146e-23, 6.629e-23, 9.937e-23, 1.42e-22, 1.955e-22, 2.609e-22, 3.392e-22, 4.191e-22, 4.612e-22, 5.502e-22, 6.578e-22, 6.927e-22, 6.498e-22, 6.691e-22, 7.085e-22, 7.562e-22, 8.421e-22, 9.171e-22, 9.548e-22, 9.419e-22, 9.444e-22, 1.154e-21, 1.363e-21, 1.346e-21, 1.31e-21, 1.439e-21, 1.664e-21, 1.944e-21, 2.698e-21, 4.043e-21, 5.169e-21, 5.094e-21, 3.884e-21, 2.328e-21, 1.209e-21, 7.554e-22, 7.378e-22, 8.61e-22, 9.705e-22, 1.04e-21, 1.102e-21, 1.174e-21, 1.245e-21, 1.298e-21, 1.328e-21, 1.341e-21, 1.344e-21]),
		ExplicitContinuum(j=14, i=3, wavelengthGrid=[9.203, 11.106, 13.008, 14.911, 16.814, 18.717, 20.619, 22.522, 24.425, 26.328, 28.23, 30.133, 32.036, 33.938, 35.841, 37.744, 39.647, 41.549, 43.452, 45.355, 47.257, 49.16, 51.063, 52.966, 54.868, 56.771, 58.674, 60.576, 62.479, 64.382, 66.285, 68.187, 70.09, 71.993, 73.896, 75.798, 77.701, 79.604, 81.506, 83.409, 85.312, 87.215, 89.117, 91.02, 92.923, 94.826, 96.728, 98.631, 100.534, 102.436, 175.04689068584247], alphaGrid=[8.266e-24, 1.388e-23, 2.231e-23, 3.361e-23, 4.819e-23, 6.653e-23, 8.901e-23, 1.161e-22, 1.483e-22, 1.86e-22, 2.297e-22, 2.8e-22, 3.373e-22, 4.023e-22, 4.748e-22, 5.525e-22, 6.316e-22, 7.089e-22, 7.828e-22, 8.521e-22, 9.175e-22, 9.799e-22, 1.04e-21, 1.098e-21, 1.155e-21, 1.21e-21, 1.264e-21, 1.316e-21, 1.366e-21, 1.413e-21, 1.459e-21, 1.501e-21, 1.541e-21, 1.577e-21, 1.612e-21, 1.642e-21, 1.672e-21, 1.695e-21, 1.718e-21, 1.739e-21, 1.755e-21, 1.772e-21, 1.786e-21, 1.796e-21, 1.806e-21, 1.816e-21, 1.82e-21, 1.825e-21, 1.829e-21, 1.834e-21, 1.834e-21]),
		ExplicitContinuum(j=14, i=4, wavelengthGrid=[9.927, 16.543, 23.158, 29.774, 36.389, 43.005, 49.621, 56.236, 62.852, 69.467, 76.083, 82.699, 89.314, 95.93, 102.545, 109.161, 115.777, 122.392, 129.008, 135.623, 142.239, 148.855, 155.47, 162.086, 168.701, 175.317, 181.933, 188.548, 195.164, 201.779, 208.395, 215.011, 221.626, 228.242, 234.857, 241.473, 248.089, 254.704, 261.32, 267.935, 274.551, 281.167, 287.782, 294.398, 301.013, 307.629, 314.245, 320.86, 327.476, 334.091], alphaGrid=[3.632e-24, 1.639e-23, 4.497e-23, 9.494e-23, 1.735e-22, 2.857e-22, 3.811e-22, 6.783e-22, 6.364e-22, 7.174e-22, 9.21e-22, 8.437e-22, 2.652e-21, 1.738e-21, 6.529e-22, 3.654e-22, 1.926e-22, 4.394e-22, 8.597e-22, 1.01e-21, 8.47e-22, 5.675e-22, 3.321e-22, 1.914e-22, 1.281e-22, 1.099e-22, 1.12e-22, 1.204e-22, 1.293e-22, 1.37e-22, 1.431e-22, 1.475e-22, 1.501e-22, 1.508e-22, 1.494e-22, 1.461e-22, 1.409e-22, 1.341e-22, 1.263e-22, 1.178e-22, 1.09e-22, 1.004e-22, 9.228e-23, 8.499e-23, 7.86e-23, 7.336e-23, 6.918e-23, 6.625e-23, 6.434e-23, 6.342e-23]),
		ExplicitContinuum(j=14, i=5, wavelengthGrid=[10.123, 17.12, 24.117, 31.114, 38.111, 45.108, 52.105, 59.102, 66.099, 73.096, 80.093, 87.089, 94.086, 101.083, 108.08, 115.077, 122.074, 129.071, 136.068, 143.065, 150.062, 157.059, 164.056, 171.053, 178.05, 185.047, 192.044, 199.041, 206.038, 213.035, 220.031, 227.028, 234.025, 241.022, 248.019, 255.016, 262.013, 269.01, 276.007, 283.004, 290.001, 296.998, 303.995, 310.992, 317.989, 324.986, 331.983, 338.98, 345.977, 352.974], alphaGrid=[4.516e-24, 2.134e-23, 5.929e-23, 1.272e-22, 2.325e-22, 3.864e-22, 5.826e-22, 7.823e-22, 5.545e-22, 3.095e-22, 3.73e-22, 2.722e-21, 2.721e-21, 1.273e-21, 1.743e-21, 1.249e-21, 6.716e-22, 6.479e-22, 6.345e-22, 4.448e-22, 2.427e-22, 1.321e-22, 9.694e-23, 9.277e-23, 9.444e-23, 9.592e-23, 9.795e-23, 1.012e-22, 1.05e-22, 1.085e-22, 1.114e-22, 1.137e-22, 1.158e-22, 1.18e-22, 1.207e-22, 1.237e-22, 1.272e-22, 1.308e-22, 1.344e-22, 1.378e-22, 1.409e-22, 1.437e-22, 1.46e-22, 1.48e-22, 1.495e-22, 1.507e-22, 1.517e-22, 1.523e-22, 1.527e-22, 1.529e-22]),
		ExplicitContinuum(j=14, i=6, wavelengthGrid=[10.101, 17.673, 25.245, 32.818, 40.39, 47.962, 55.534, 63.106, 70.678, 78.251, 85.823, 93.395, 100.967, 108.539, 116.112, 123.684, 131.256, 138.828, 146.4, 153.972, 161.545, 169.117, 176.689, 184.261, 191.833, 199.406, 206.978, 214.55, 222.122, 229.694, 237.267, 244.839, 252.411, 259.983, 267.555, 275.127, 282.7, 290.272, 297.844, 305.416, 312.988, 320.561, 328.133, 335.705, 343.277, 350.849, 358.421, 365.994, 373.566, 381.138], alphaGrid=[7.994e-24, 4.217e-23, 1.224e-22, 2.678e-22, 4.974e-22, 7.998e-22, 9.591e-22, 1.114e-21, 1.268e-21, 1.408e-21, 1.582e-21, 1.747e-21, 1.678e-21, 1.754e-21, 1.48e-21, 1.179e-21, 1.246e-21, 1.317e-21, 1.129e-21, 7.987e-22, 5.113e-22, 3.338e-22, 2.464e-22, 2.123e-22, 2.121e-22, 2.378e-22, 2.843e-22, 3.436e-22, 4.061e-22, 4.615e-22, 5.04e-22, 5.284e-22, 5.365e-22, 5.293e-22, 5.085e-22, 4.794e-22, 4.449e-22, 4.081e-22, 3.709e-22, 3.352e-22, 3.02e-22, 2.727e-22, 2.47e-22, 2.245e-22, 2.056e-22, 1.914e-22, 1.796e-22, 1.709e-22, 1.657e-22, 1.616e-22]),
		ExplicitContinuum(j=14, i=7, wavelengthGrid=[9.998, 19.299, 28.599, 37.9, 47.2, 56.501, 65.801, 75.102, 84.402, 93.703, 103.003, 112.304, 121.604, 130.905, 140.206, 149.506, 158.807, 168.107, 177.408, 186.708, 196.009, 205.309, 214.61, 223.91, 233.211, 242.511, 251.812, 261.112, 270.413, 279.714, 289.014, 298.315, 307.615, 316.916, 326.216, 335.517, 344.817, 354.118, 363.418, 372.719, 382.019, 391.32, 400.621, 409.921, 419.222, 428.522, 437.823, 447.123, 456.424, 465.724], alphaGrid=[4.246e-24, 2.948e-23, 9.601e-23, 2.242e-22, 4.091e-22, 5.891e-22, 5.841e-22, 8.208e-22, 1.022e-21, 1.052e-21, 9.819e-22, 8.787e-22, 7.711e-22, 6.704e-22, 5.817e-22, 5.076e-22, 4.489e-22, 4.046e-22, 3.729e-22, 3.518e-22, 3.391e-22, 3.329e-22, 3.316e-22, 3.336e-22, 3.38e-22, 3.438e-22, 3.505e-22, 3.577e-22, 3.648e-22, 3.718e-22, 3.785e-22, 3.848e-22, 3.906e-22, 3.959e-22, 4.007e-22, 4.05e-22, 4.089e-22, 4.122e-22, 4.152e-22, 4.177e-22, 4.199e-22, 4.218e-22, 4.234e-22, 4.247e-22, 4.257e-22, 4.265e-22, 4.271e-22, 4.276e-22, 4.279e-22, 4.28e-22]),
		ExplicitContinuum(j=14, i=8, wavelengthGrid=[10.602, 20.307, 30.012, 39.717, 49.422, 59.127, 68.832, 78.537, 88.242, 97.947, 107.652, 117.358, 127.063, 136.768, 146.473, 156.178, 165.883, 175.588, 185.293, 194.998, 204.703, 214.408, 224.113, 233.818, 243.523, 253.228, 262.933, 272.638, 282.343, 292.048, 301.753, 311.458, 321.164, 330.869, 340.574, 350.279, 359.984, 369.689, 379.394, 389.099, 398.804, 408.509, 418.214, 427.919, 437.624, 447.329, 457.034, 466.739, 476.444, 486.149], alphaGrid=[3.789e-24, 2.593e-23, 8.376e-23, 1.95e-22, 3.87e-22, 5.158e-22, 5.651e-22, 9.53e-22, 1.213e-21, 1.133e-21, 8.894e-22, 6.505e-22, 4.769e-22, 3.674e-22, 3.034e-22, 2.675e-22, 2.475e-22, 2.364e-22, 2.299e-22, 2.26e-22, 2.235e-22, 2.218e-22, 2.206e-22, 2.197e-22, 2.191e-22, 2.186e-22, 2.182e-22, 2.179e-22, 2.177e-22, 2.176e-22, 2.175e-22, 2.174e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.173e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22, 2.174e-22]),
		ExplicitContinuum(j=14, i=9, wavelengthGrid=[10.764, 20.967, 31.169, 41.372, 51.574, 61.777, 71.98, 82.182, 92.385, 102.587, 112.79, 122.992, 133.195, 143.398, 153.6, 163.803, 174.005, 184.208, 194.411, 204.613, 214.816, 225.018, 235.221, 245.424, 255.626, 265.829, 276.031, 286.234, 296.436, 306.639, 316.842, 327.044, 337.247, 347.449, 357.652, 367.854, 378.057, 388.26, 398.462, 408.665, 418.867, 429.07, 439.272, 449.475, 459.678, 469.88, 480.083, 490.285, 500.488, 510.69], alphaGrid=[4.487e-24, 3.226e-23, 1.058e-22, 2.474e-22, 4.579e-22, 6.223e-22, 1.015e-21, 1.142e-21, 1.76e-21, 1.367e-21, 8.978e-22, 7.196e-22, 6.275e-22, 5.139e-22, 3.917e-22, 2.914e-22, 2.233e-22, 1.832e-22, 1.622e-22, 1.52e-22, 1.471e-22, 1.445e-22, 1.426e-22, 1.41e-22, 1.394e-22, 1.38e-22, 1.367e-22, 1.358e-22, 1.351e-22, 1.347e-22, 1.346e-22, 1.347e-22, 1.35e-22, 1.354e-22, 1.359e-22, 1.364e-22, 1.37e-22, 1.376e-22, 1.381e-22, 1.386e-22, 1.391e-22, 1.395e-22, 1.399e-22, 1.402e-22, 1.405e-22, 1.407e-22, 1.409e-22, 1.41e-22, 1.411e-22, 1.411e-22]),
		ExplicitContinuum(j=14, i=10, wavelengthGrid=[10.396, 20.949, 31.501, 42.054, 52.607, 63.159, 73.712, 84.265, 94.818, 105.37, 115.923, 126.476, 137.028, 147.581, 158.134, 168.686, 179.239, 189.792, 200.344, 210.897, 221.45, 232.003, 242.555, 253.108, 263.661, 274.213, 284.766, 295.319, 305.871, 316.424, 326.977, 337.53, 348.082, 358.635, 369.188, 379.74, 390.293, 400.846, 411.398, 421.951, 432.504, 443.057, 453.609, 464.162, 474.715, 485.267, 495.82, 506.373, 516.925, 527.478], alphaGrid=[4e-24, 3.184e-23, 1.088e-22, 2.443e-22, 4.466e-22, 5.69e-22, 8.13e-22, 1.454e-21, 1.596e-21, 1.302e-21, 9.527e-22, 7.098e-22, 5.732e-22, 5.029e-22, 4.661e-22, 4.44e-22, 4.281e-22, 4.149e-22, 4.035e-22, 3.934e-22, 3.848e-22, 3.775e-22, 3.716e-22, 3.668e-22, 3.63e-22, 3.601e-22, 3.578e-22, 3.562e-22, 3.549e-22, 3.54e-22, 3.534e-22, 3.53e-22, 3.527e-22, 3.526e-22, 3.525e-22, 3.524e-22, 3.524e-22, 3.525e-22, 3.525e-22, 3.526e-22, 3.526e-22, 3.527e-22, 3.527e-22, 3.528e-22, 3.528e-22, 3.529e-22, 3.529e-22, 3.529e-22, 3.529e-22, 3.529e-22]),
		ExplicitContinuum(j=14, i=11, wavelengthGrid=[10.612, 21.911, 33.209, 44.508, 55.806, 67.105, 78.403, 89.702, 101.0, 112.299, 123.597, 134.896, 146.194, 157.493, 168.791, 180.09, 191.388, 202.687, 213.985, 225.284, 236.582, 247.881, 259.179, 270.478, 281.776, 293.075, 304.373, 315.672, 326.97, 338.269, 349.567, 360.866, 372.164, 383.463, 394.761, 406.06, 417.359, 428.657, 439.956, 451.254, 462.553, 473.851, 485.15, 496.448, 507.747, 519.045, 530.344, 541.642, 552.941, 564.239], alphaGrid=[3.464e-24, 2.954e-23, 1.022e-22, 2.434e-22, 4.601e-22, 4.162e-22, 9.54e-22, 1.467e-21, 1.362e-21, 1.051e-21, 8.102e-22, 6.694e-22, 5.876e-22, 5.322e-22, 4.886e-22, 4.521e-22, 4.218e-22, 3.978e-22, 3.798e-22, 3.673e-22, 3.594e-22, 3.551e-22, 3.538e-22, 3.546e-22, 3.568e-22, 3.601e-22, 3.64e-22, 3.681e-22, 3.724e-22, 3.766e-22, 3.807e-22, 3.845e-22, 3.88e-22, 3.913e-22, 3.943e-22, 3.969e-22, 3.993e-22, 4.014e-22, 4.032e-22, 4.048e-22, 4.062e-22, 4.074e-22, 4.083e-22, 4.092e-22, 4.098e-22, 4.103e-22, 4.107e-22, 4.11e-22, 4.112e-22, 4.113e-22]),
		ExplicitContinuum(j=14, i=12, wavelengthGrid=[10.87, 23.125, 35.379, 47.634, 59.889, 72.144, 84.398, 96.653, 108.908, 121.162, 133.417, 145.672, 157.927, 170.181, 182.436, 194.691, 206.946, 219.2, 231.455, 243.71, 255.964, 268.219, 280.474, 292.729, 304.983, 317.238, 329.493, 341.747, 354.002, 366.257, 378.512, 390.766, 403.021, 415.276, 427.531, 439.785, 452.04, 464.295, 476.549, 488.804, 501.059, 513.314, 525.568, 537.823, 550.078, 562.332, 574.587, 586.842, 599.097, 611.351], alphaGrid=[2.857e-24, 2.719e-23, 9.745e-23, 2.352e-22, 4.506e-22, 2.308e-22, 1.333e-21, 1.517e-21, 8.209e-22, 4.902e-22, 3.71e-22, 2.967e-22, 2.479e-22, 2.258e-22, 2.249e-22, 2.37e-22, 2.563e-22, 2.79e-22, 3.03e-22, 3.27e-22, 3.503e-22, 3.724e-22, 3.931e-22, 4.122e-22, 4.296e-22, 4.455e-22, 4.598e-22, 4.726e-22, 4.84e-22, 4.942e-22, 5.033e-22, 5.113e-22, 5.183e-22, 5.246e-22, 5.301e-22, 5.348e-22, 5.389e-22, 5.426e-22, 5.457e-22, 5.483e-22, 5.507e-22, 5.525e-22, 5.543e-22, 5.555e-22, 5.567e-22, 5.575e-22, 5.583e-22, 5.588e-22, 5.591e-22, 5.594e-22]),
		ExplicitContinuum(j=14, i=13, wavelengthGrid=[10.697, 24.019, 37.341, 50.663, 63.985, 77.308, 90.63, 103.952, 117.274, 130.596, 143.918, 157.24, 170.562, 183.884, 197.207, 210.529, 223.851, 237.173, 250.495, 263.817, 277.139, 290.461, 303.783, 317.106, 330.428, 343.75, 357.072, 370.394, 383.716, 397.038, 410.36, 423.682, 437.005, 450.327, 463.649, 476.971, 490.293, 503.615, 516.937, 530.259, 543.581, 556.904, 570.226, 583.548, 596.87, 610.192, 623.514, 636.836, 650.158, 663.48], alphaGrid=[7.116e-24, 7.899e-23, 2.955e-22, 6.902e-22, 9.278e-22, 1.272e-21, 1.569e-21, 1.675e-21, 1.881e-21, 1.649e-21, 1.219e-21, 8.59e-22, 6.268e-22, 4.909e-22, 4.162e-22, 3.786e-22, 3.641e-22, 3.637e-22, 3.717e-22, 3.842e-22, 3.987e-22, 4.138e-22, 4.284e-22, 4.419e-22, 4.542e-22, 4.651e-22, 4.748e-22, 4.832e-22, 4.905e-22, 4.968e-22, 5.022e-22, 5.069e-22, 5.109e-22, 5.144e-22, 5.173e-22, 5.198e-22, 5.22e-22, 5.238e-22, 5.254e-22, 5.267e-22, 5.279e-22, 5.288e-22, 5.296e-22, 5.302e-22, 5.308e-22, 5.312e-22, 5.316e-22, 5.318e-22, 5.32e-22, 5.321e-22]),
	],
	collisions=[
		CE(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.669e-15, 1.418e-15, 1.273e-15, 1.136e-15, 9.097e-16, 7.99e-16, 5.435e-16]),
		CE(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.697e-16, 3.989e-16, 3.582e-16, 3.195e-16, 2.56e-16, 2.248e-16, 1.529e-16]),
		CE(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.227e-16, 1.891e-16, 1.698e-16, 1.515e-16, 1.214e-16, 1.066e-16, 7.252e-17]),
		CE(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.734e-15, 2.854e-15, 2.048e-15, 1.443e-15, 7.381e-16, 5.027e-16, 1.704e-16]),
		CE(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.011e-17, 6.803e-17, 6.108e-17, 5.45e-17, 4.365e-17, 3.834e-17, 2.608e-17]),
		CE(j=6, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.079e-15, 1.253e-15, 8.991e-16, 6.336e-16, 3.238e-16, 2.204e-16, 7.456e-17]),
		CE(j=7, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.713e-17, 5.7e-17, 5.119e-17, 4.566e-17, 3.658e-17, 3.213e-17, 2.186e-17]),
		CE(j=8, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.573e-17, 5.582e-17, 5.012e-17, 4.472e-17, 3.582e-17, 3.146e-17, 2.14e-17]),
		CE(j=9, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.414e-17, 5.447e-17, 4.891e-17, 4.364e-17, 3.496e-17, 3.07e-17, 2.089e-17]),
		CE(j=10, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.319e-17, 5.366e-17, 4.819e-17, 4.299e-17, 3.444e-17, 3.025e-17, 2.058e-17]),
		CE(j=11, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.14e-17, 5.214e-17, 4.682e-17, 4.177e-17, 3.346e-17, 2.939e-17, 1.999e-17]),
		CE(j=12, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.951e-17, 5.053e-17, 4.537e-17, 4.048e-17, 3.243e-17, 2.848e-17, 1.937e-17]),
		CE(j=13, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.379e-15, 8.309e-16, 5.959e-16, 4.197e-16, 2.141e-16, 1.455e-16, 4.895e-17]),
		CE(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.365e-15, 1.159e-15, 1.041e-15, 9.287e-16, 7.44e-16, 6.534e-16, 4.445e-16]),
		CE(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.07e-16, 3.456e-16, 3.104e-16, 2.769e-16, 2.218e-16, 1.948e-16, 1.325e-16]),
		CE(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.141e-16, 9.693e-17, 8.703e-17, 7.765e-17, 6.22e-17, 5.463e-17, 3.716e-17]),
		CE(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.405e-15, 2.658e-15, 1.909e-15, 1.347e-15, 6.915e-16, 4.727e-16, 1.626e-16]),
		CE(j=6, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.012e-16, 8.597e-17, 7.719e-17, 6.887e-17, 5.517e-17, 4.845e-17, 3.296e-17]),
		CE(j=7, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.78e-17, 7.456e-17, 6.695e-17, 5.972e-17, 4.784e-17, 4.202e-17, 2.859e-17]),
		CE(j=8, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.566e-17, 7.274e-17, 6.532e-17, 5.827e-17, 4.668e-17, 4.1e-17, 2.789e-17]),
		CE(j=9, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.325e-17, 7.069e-17, 6.348e-17, 5.663e-17, 4.536e-17, 3.984e-17, 2.71e-17]),
		CE(j=10, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.181e-17, 6.947e-17, 6.238e-17, 5.565e-17, 4.458e-17, 3.916e-17, 2.664e-17]),
		CE(j=11, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.911e-17, 6.718e-17, 6.032e-17, 5.381e-17, 4.311e-17, 3.786e-17, 2.576e-17]),
		CE(j=12, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.628e-17, 6.478e-17, 5.817e-17, 5.189e-17, 4.157e-17, 3.651e-17, 2.484e-17]),
		CE(j=13, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.378e-17, 6.265e-17, 5.626e-17, 5.019e-17, 4.021e-17, 3.531e-17, 2.402e-17]),
		CE(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.247e-15, 1.059e-15, 9.512e-16, 8.486e-16, 6.798e-16, 5.971e-16, 4.062e-16]),
		CE(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.764e-16, 1.498e-16, 1.345e-16, 1.2e-16, 9.613e-17, 8.443e-17, 5.744e-17]),
		CE(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.997e-15, 2.415e-15, 1.737e-15, 1.229e-15, 6.351e-16, 4.366e-16, 1.536e-16]),
		CE(j=6, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.512e-16, 1.284e-16, 1.153e-16, 1.029e-16, 8.242e-17, 7.239e-17, 4.924e-17]),
		CE(j=7, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.265e-16, 1.074e-16, 9.643e-17, 8.603e-17, 6.892e-17, 6.053e-17, 4.118e-17]),
		CE(j=8, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.227e-16, 1.042e-16, 9.353e-17, 8.345e-17, 6.685e-17, 5.871e-17, 3.994e-17]),
		CE(j=9, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.184e-16, 1.006e-16, 9.029e-17, 8.055e-17, 6.453e-17, 5.667e-17, 3.855e-17]),
		CE(j=10, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.159e-16, 9.842e-17, 8.837e-17, 7.884e-17, 6.316e-17, 5.547e-17, 3.773e-17]),
		CE(j=11, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.112e-16, 9.444e-17, 8.48e-17, 7.565e-17, 6.06e-17, 5.323e-17, 3.621e-17]),
		CE(j=12, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.064e-16, 9.034e-17, 8.112e-17, 7.237e-17, 5.797e-17, 5.092e-17, 3.464e-17]),
		CE(j=13, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.022e-16, 8.675e-17, 7.789e-17, 6.949e-17, 5.567e-17, 4.889e-17, 3.326e-17]),
		CE(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.307e-16, 2.809e-16, 2.522e-16, 2.25e-16, 1.802e-16, 1.583e-16, 1.077e-16]),
		CE(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.997e-16, 2.545e-16, 2.285e-16, 2.039e-16, 1.633e-16, 1.435e-16, 9.759e-17]),
		CE(j=6, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.656e-16, 2.255e-16, 2.025e-16, 1.807e-16, 1.447e-16, 1.271e-16, 8.648e-17]),
		CE(j=7, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.079e-16, 1.765e-16, 1.585e-16, 1.414e-16, 1.133e-16, 9.949e-17, 6.768e-17]),
		CE(j=8, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.995e-16, 1.694e-16, 1.521e-16, 1.357e-16, 1.087e-16, 9.55e-17, 6.497e-17]),
		CE(j=9, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.904e-16, 1.617e-16, 1.452e-16, 1.295e-16, 1.037e-16, 9.111e-17, 6.198e-17]),
		CE(j=10, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.85e-16, 1.571e-16, 1.411e-16, 1.259e-16, 1.008e-16, 8.856e-17, 6.025e-17]),
		CE(j=11, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.753e-16, 1.488e-16, 1.336e-16, 1.192e-16, 9.551e-17, 8.388e-17, 5.706e-17]),
		CE(j=12, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.654e-16, 1.404e-16, 1.261e-16, 1.125e-16, 9.013e-17, 7.916e-17, 5.385e-17]),
		CE(j=13, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.569e-16, 1.333e-16, 1.197e-16, 1.067e-16, 8.551e-17, 7.51e-17, 5.109e-17]),
		CE(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.693e-14, 3.136e-14, 2.816e-14, 2.513e-14, 2.013e-14, 1.768e-14, 1.203e-14]),
		CE(j=6, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[9.051e-15, 7.686e-15, 6.902e-15, 6.157e-15, 4.932e-15, 4.332e-15, 2.947e-15]),
		CE(j=7, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.261e-15, 1.92e-15, 1.724e-15, 1.538e-15, 1.232e-15, 1.082e-15, 7.363e-16]),
		CE(j=8, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.67e-14, 3.068e-14, 2.377e-14, 1.851e-14, 1.21e-14, 9.643e-15, 4.829e-15]),
		CE(j=9, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.917e-14, 1.181e-14, 8.652e-15, 6.27e-15, 3.447e-15, 2.472e-15, 9.765e-16]),
		CE(j=10, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.676e-14, 2.376e-14, 1.815e-14, 1.387e-14, 8.539e-15, 6.487e-15, 2.836e-15]),
		CE(j=11, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.222e-15, 1.038e-15, 9.316e-16, 8.311e-16, 6.658e-16, 5.848e-16, 3.978e-16]),
		CE(j=12, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.023e-15, 8.687e-16, 7.8e-16, 6.959e-16, 5.574e-16, 4.896e-16, 3.331e-16]),
		CE(j=13, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.796e-16, 7.469e-16, 6.707e-16, 5.983e-16, 4.793e-16, 4.21e-16, 2.864e-16]),
		CE(j=6, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.348e-14, 1.994e-14, 1.79e-14, 1.597e-14, 1.279e-14, 1.124e-14, 7.644e-15]),
		CE(j=7, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.148e-14, 2.772e-14, 2.172e-14, 1.71e-14, 1.119e-14, 8.737e-15, 3.977e-15]),
		CE(j=8, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.638e-15, 2.24e-15, 2.011e-15, 1.794e-15, 1.437e-15, 1.262e-15, 8.588e-16]),
		CE(j=9, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.142e-15, 1.819e-15, 1.633e-15, 1.457e-15, 1.167e-15, 1.025e-15, 6.973e-16]),
		CE(j=10, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.906e-15, 1.618e-15, 1.453e-15, 1.296e-15, 1.038e-15, 9.12e-16, 6.204e-16]),
		CE(j=11, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.832e-14, 3.151e-14, 2.427e-14, 1.879e-14, 1.216e-14, 9.674e-15, 4.853e-15]),
		CE(j=12, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.599e-14, 9.843e-15, 7.206e-15, 5.221e-15, 2.875e-15, 2.067e-15, 8.311e-16]),
		CE(j=13, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.066e-15, 9.052e-16, 8.128e-16, 7.251e-16, 5.809e-16, 5.102e-16, 3.471e-16]),
		CE(j=7, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.953e-15, 5.056e-15, 4.54e-15, 4.05e-15, 3.244e-15, 2.849e-15, 1.938e-15]),
		CE(j=8, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.473e-16, 4.657e-16, 3.44e-16, 2.517e-16, 1.406e-16, 1.013e-16, 3.96e-17]),
		CE(j=9, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.399e-15, 2.887e-15, 2.592e-15, 2.313e-15, 1.852e-15, 1.627e-15, 1.107e-15]),
		CE(j=10, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.034e-15, 1.263e-15, 9.307e-16, 6.793e-16, 3.788e-16, 2.735e-16, 1.085e-16]),
		CE(j=11, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.244e-15, 1.906e-15, 1.711e-15, 1.526e-15, 1.223e-15, 1.074e-15, 7.306e-16]),
		CE(j=12, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.748e-15, 1.485e-15, 1.333e-15, 1.189e-15, 9.527e-16, 8.368e-16, 5.692e-16]),
		CE(j=13, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.425e-15, 1.21e-15, 1.087e-15, 9.694e-16, 7.766e-16, 6.821e-16, 4.64e-16]),
		CE(j=8, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.046e-13, 8.883e-14, 7.976e-14, 7.116e-14, 5.7e-14, 5.007e-14, 3.406e-14]),
		CE(j=9, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.824e-14, 2.398e-14, 2.153e-14, 1.921e-14, 1.539e-14, 1.351e-14, 9.194e-15]),
		CE(j=10, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.739e-14, 1.477e-14, 1.326e-14, 1.183e-14, 9.479e-15, 8.325e-15, 5.663e-15]),
		CE(j=11, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[8.894e-15, 7.553e-15, 6.782e-15, 6.05e-15, 4.847e-15, 4.257e-15, 2.896e-15]),
		CE(j=12, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.282e-15, 4.486e-15, 4.028e-15, 3.593e-15, 2.879e-15, 2.528e-15, 1.72e-15]),
		CE(j=13, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.632e-15, 3.084e-15, 2.769e-15, 2.471e-15, 1.979e-15, 1.738e-15, 1.182e-15]),
		CE(j=9, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.917e-14, 6.723e-14, 6.037e-14, 5.385e-14, 4.314e-14, 3.789e-14, 2.578e-14]),
		CE(j=10, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.529e-14, 2.997e-14, 2.691e-14, 2.401e-14, 1.923e-14, 1.689e-14, 1.149e-14]),
		CE(j=11, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.381e-14, 1.173e-14, 1.053e-14, 9.398e-15, 7.528e-15, 6.612e-15, 4.498e-15]),
		CE(j=12, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[7.211e-15, 6.123e-15, 5.498e-15, 4.905e-15, 3.929e-15, 3.451e-15, 2.348e-15]),
		CE(j=13, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.198e-15, 2.636e-15, 1.96e-15, 1.446e-15, 8.244e-16, 6.023e-16, 2.45e-16]),
		CE(j=10, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.779e-13, 1.511e-13, 1.357e-13, 1.211e-13, 9.697e-14, 8.517e-14, 5.794e-14]),
		CE(j=11, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.877e-14, 2.443e-14, 2.193e-14, 1.957e-14, 1.568e-14, 1.377e-14, 9.366e-15]),
		CE(j=12, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.144e-14, 9.715e-15, 8.723e-15, 7.782e-15, 6.234e-15, 5.476e-15, 3.725e-15]),
		CE(j=13, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.57e-15, 3.515e-15, 2.623e-15, 1.942e-15, 1.111e-15, 8.121e-16, 3.278e-16]),
		CE(j=11, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.752e-14, 4.885e-14, 4.386e-14, 3.913e-14, 3.135e-14, 2.753e-14, 1.873e-14]),
		CE(j=12, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.648e-14, 1.399e-14, 1.256e-14, 1.121e-14, 8.979e-15, 7.887e-15, 5.365e-15]),
		CE(j=13, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.87e-14, 1.899e-14, 1.443e-14, 1.082e-14, 6.368e-15, 4.732e-15, 1.897e-15]),
		CE(j=12, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.867e-14, 4.133e-14, 3.711e-14, 3.311e-14, 2.652e-14, 2.329e-14, 1.585e-14]),
		CE(j=13, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.603e-14, 1.361e-14, 1.222e-14, 1.09e-14, 8.735e-15, 7.672e-15, 5.219e-15]),
		CE(j=13, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.43e-14, 4.611e-14, 4.14e-14, 3.694e-14, 2.959e-14, 2.599e-14, 1.768e-14]),
		CI(j=14, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.108e-16, 2.108e-16, 2.108e-16, 2.108e-16, 2.108e-16, 2.108e-16, 2.108e-16]),
		CI(j=14, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.651e-16, 1.651e-16, 1.651e-16, 1.651e-16, 1.651e-16, 1.651e-16, 1.651e-16]),
		CI(j=14, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.238e-16, 2.238e-16, 2.238e-16, 2.238e-16, 2.238e-16, 2.238e-16, 2.238e-16]),
		CI(j=14, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.683e-16, 3.683e-16, 3.683e-16, 3.683e-16, 3.683e-16, 3.683e-16, 3.683e-16]),
		CI(j=14, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.713e-17, 1.713e-17, 1.713e-17, 1.713e-17, 1.713e-17, 1.713e-17, 1.713e-17]),
		CI(j=14, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[6.759e-17, 6.759e-17, 6.759e-17, 6.759e-17, 6.759e-17, 6.759e-17, 6.759e-17]),
		CI(j=14, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[5.436e-17, 5.436e-17, 5.436e-17, 5.436e-17, 5.436e-17, 5.436e-17, 5.436e-17]),
		CI(j=14, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.454e-16, 2.454e-16, 2.454e-16, 2.454e-16, 2.454e-16, 2.454e-16, 2.454e-16]),
		CI(j=14, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.354e-16, 1.354e-16, 1.354e-16, 1.354e-16, 1.354e-16, 1.354e-16, 1.354e-16]),
		CI(j=14, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.319e-16, 1.319e-16, 1.319e-16, 1.319e-16, 1.319e-16, 1.319e-16, 1.319e-16]),
		CI(j=14, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[1.83e-16, 1.83e-16, 1.83e-16, 1.83e-16, 1.83e-16, 1.83e-16, 1.83e-16]),
		CI(j=14, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[2.982e-16, 2.982e-16, 2.982e-16, 2.982e-16, 2.982e-16, 2.982e-16, 2.982e-16]),
		CI(j=14, i=12, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[3.822e-16, 3.822e-16, 3.822e-16, 3.822e-16, 3.822e-16, 3.822e-16, 3.822e-16]),
		CI(j=14, i=13, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0, 100000.0], rates=[4.637e-16, 4.637e-16, 4.637e-16, 4.637e-16, 4.637e-16, 4.637e-16, 4.637e-16]),
])

CI_VI_Judge_atom = lambda: \
AtomicModel(element=Element(Z=6),
	levels=[
		AtomicLevel(E=     0.000, g=1, label="2S2 2P2 3PE 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=    16.400, g=3, label="2S2 2P2 3PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=    43.400, g=5, label="2S2 2P2 3PE 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 10192.630, g=5, label="2S2 2P2 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 21648.010, g=1, label="2S2 2P2 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 33735.200, g=5, label="2S 2P3 5SO 2", stage=0, J=Fraction(2, 1), L=0, S=Fraction(2, 1)),
		AtomicLevel(E= 60333.430, g=1, label="2S2 2P (2PO)3S 3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 60352.630, g=3, label="2S2 2P (2PO)3S 3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 60393.140, g=5, label="2S2 2P (2PO)3S 3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 61981.820, g=3, label="2S2 2P (2PO)3S 1PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 64086.920, g=7, label="2S 2P3 3DO 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 64089.850, g=3, label="2S 2P3 3DO 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 64090.950, g=5, label="2S 2P3 3DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 68856.330, g=3, label="2S2 2P (2PO)3P 1PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 69689.480, g=3, label="2S2 2P (2PO)3P 3DE 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 69710.660, g=5, label="2S2 2P (2PO)3P 3DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 69744.030, g=7, label="2S2 2P (2PO)3P 3DE 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 70743.950, g=3, label="2S2 2P (2PO)3P 3SE 1", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E= 71352.510, g=1, label="2S2 2P (2PO)3P 3PE 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 71364.900, g=3, label="2S2 2P (2PO)3P 3PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 71385.380, g=5, label="2S2 2P (2PO)3P 3PE 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 72610.720, g=5, label="2S2 2P (2PO)3P 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 73975.910, g=1, label="2S2 2P (2PO)3P 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 75253.970, g=3, label="2S 2P3 3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 75255.270, g=5, label="2S 2P3 3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 75256.120, g=1, label="2S 2P3 3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 77679.820, g=5, label="2S2 2P (2PO)3D 1DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 78199.070, g=5, label="2S2 2P (2PO)3D 3FO 2", stage=0, J=Fraction(2, 1), L=3, S=Fraction(1, 1)),
		AtomicLevel(E= 78215.510, g=7, label="2S2 2P (2PO)3D 3FO 3", stage=0, J=Fraction(3, 1), L=3, S=Fraction(1, 1)),
		AtomicLevel(E= 78249.940, g=9, label="2S2 2P (2PO)3D 3FO 4", stage=0, J=Fraction(4, 1), L=3, S=Fraction(1, 1)),
		AtomicLevel(E= 78293.490, g=3, label="2S2 2P (2PO)3D 3DO 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 78307.630, g=5, label="2S2 2P (2PO)3D 3DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 78318.250, g=7, label="2S2 2P (2PO)3D 3DO 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 78529.620, g=7, label="2S2 2P (2PO)3D 1FO 3", stage=0, J=Fraction(3, 1), L=3, S=Fraction(0, 1)),
		AtomicLevel(E= 78731.270, g=3, label="2S2 2P (2PO)3D 1PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 79310.850, g=5, label="2S2 2P (2PO)3D 3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 79318.780, g=3, label="2S2 2P (2PO)3D 3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 79323.160, g=1, label="2S2 2P (2PO)3D 3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 90817.275, g=2, label="2S2 2P 2PO 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 90880.695, g=4, label="2S2 2P 2PO 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=103541.800, g=3, label="2S 2P2 (4P)3S 5PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(2, 1)),
		AtomicLevel(E=103562.500, g=5, label="2S 2P2 (4P)3S 5PE 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(2, 1)),
		AtomicLevel(E=103587.300, g=7, label="2S 2P2 (4P)3S 5PE 3", stage=0, J=Fraction(3, 1), L=1, S=Fraction(2, 1)),
		AtomicLevel(E=105798.700, g=3, label="2S 2P3 3SO 1", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=133820.575, g=2, label="2S 2P2 4PE 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=133842.575, g=4, label="2S 2P2 4PE 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=133870.875, g=6, label="2S 2P2 4PE 5/2", stage=1, J=Fraction(5, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=165747.375, g=6, label="2S 2P2 2DE 5/2", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=165749.895, g=4, label="2S 2P2 2DE 3/2", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=187311.015, g=2, label="2S 2P2 2SE 1/2", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=201441.445, g=2, label="2S 2P2 2PE 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=201482.835, g=4, label="2S 2P2 2PE 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=207354.925, g=2, label="2S2 3S 2SE 1/2", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=222541.645, g=2, label="2S2 3P 2PO 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=222552.795, g=4, label="2S2 3P 2PO 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=232844.375, g=4, label="2P3 4SO 3/2", stage=1, J=Fraction(3, 2), L=0, S=Fraction(3, 2)),
		AtomicLevel(E=241278.855, g=6, label="2P3 2DO 5/2", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=241283.965, g=4, label="2P3 2DO 3/2", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=259546.805, g=2, label="2P3 2PO 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=259565.575, g=4, label="2P3 2PO 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=287477.809, g=1, label="2S2 1SE 0", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=339844.869, g=1, label="2S 2P 3PO 0", stage=2, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=339868.559, g=3, label="2S 2P 3PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=339924.919, g=5, label="2S 2P 3PO 2", stage=2, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=389829.849, g=3, label="2S 2P 1PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=424903.509, g=1, label="2P2 3PE 0", stage=2, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=424932.209, g=3, label="2P2 3PE 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=424979.819, g=5, label="2P2 3PE 2", stage=2, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=433353.939, g=5, label="2P2 1DE 2", stage=2, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E=469997.689, g=1, label="2P2 1SE 0", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=525690.809, g=3, label="2S 3S 3SE 1", stage=2, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=534648.069, g=1, label="2S 3S 1SE 0", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=546409.099, g=3, label="2S 3P 1PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=547183.359, g=1, label="2S 3P 3PO 0", stage=2, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=547189.029, g=3, label="2S 3P 3PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=547202.109, g=5, label="2S 3P 3PO 2", stage=2, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=557488.639, g=3, label="2S 3D 3DE 1", stage=2, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=557489.739, g=5, label="2S 3D 3DE 2", stage=2, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=557492.549, g=7, label="2S 3D 3DE 3", stage=2, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=563960.669, g=5, label="2S 3D 1DE 2", stage=2, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E=673709.323, g=2, label="1S2 2S 2SE 1/2", stage=3, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=738193.323, g=2, label="1S2 2P 2PO 1/2", stage=3, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=738301.023, g=4, label="1S2 2P 2PO 3/2", stage=3, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=976558.323, g=2, label="1S2 3S 2SE 1/2", stage=3, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=993759.423, g=2, label="1S2 3P 2PO 1/2", stage=3, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=993791.023, g=4, label="1S2 3P 2PO 3/2", stage=3, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=998589.123, g=4, label="1S2 3D 2DE 3/2", stage=3, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=998599.623, g=6, label="1S2 3D 2DE 5/2", stage=3, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=1193868.088, g=1, label="1S2 1SE 0", stage=4, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=3605130.088, g=3, label="1S 2S 3SE 1", stage=4, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=3648892.088, g=1, label="1S 2S 1SE 0", stage=4, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=3649018.318, g=3, label="1S 2P 3PO 1", stage=4, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=3649030.828, g=1, label="1S 2P 3PO 0", stage=4, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=3649154.100, g=5, label="1S 2P 3PO 2", stage=4, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=3677239.088, g=3, label="1S 2P 1PO 1", stage=4, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=4033430.088, g=3, label="1S 3S 3SE 1", stage=4, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=4045048.088, g=1, label="1S 3S 1SE 0", stage=4, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=4045286.088, g=3, label="1S 3P 3PO 1", stage=4, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=4045286.088, g=1, label="1S 3P 3PO 0", stage=4, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=4045286.088, g=5, label="1S 3P 3PO 2", stage=4, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=4051173.088, g=3, label="1S 3D 3DE 1", stage=4, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=4051173.088, g=5, label="1S 3D 3DE 2", stage=4, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=4051183.088, g=7, label="1S 3D 3DE 3", stage=4, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E=4051397.088, g=5, label="1S 3D 1DE 2", stage=4, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E=4053243.088, g=3, label="1S 3P 1PO 1", stage=4, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=4356156.249, g=2, label="1S 2SE 1/2", stage=5, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=7320034.289, g=2, label="2P 2PO 1/2", stage=5, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=7320060.429, g=2, label="2S 2SE 1/2", stage=5, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=7320509.259, g=4, label="2P 2PO 3/2", stage=5, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=7869077.869, g=2, label="3P 2PO 1/2", stage=5, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=7869085.679, g=2, label="3S 2SE 1/2", stage=5, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=7869218.369, g=4, label="3D 2DE 3/2", stage=5, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=7869218.599, g=4, label="3P 2PO 3/2", stage=5, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=7869265.239, g=6, label="3D 2DE 5/2", stage=5, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=8308086.904, g=1, label="S0 1SE 0", stage=6, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
	],
	lines=[
		VoigtLine(j=43, i=0, f=1.520e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=1, f=1.530e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=2, f=1.520e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=0, f=3.800e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=37, i=1, f=1.350e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.91e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=1, f=1.050e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=1, f=1.470e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=2, f=1.010e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=2, f=3.030e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=0, f=2.760e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=2, f=3.510e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.02e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=0, f=9.320e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=1, f=7.050e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=1, f=2.230e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=2, f=7.910e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=2, f=1.550e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=2, f=8.170e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=1, f=7.360e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=2, f=3.780e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=2, f=1.990e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=0, f=6.310e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=1, f=2.130e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.43e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=1, f=2.600e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=1, f=1.600e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=2, f=4.740e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=2, f=1.590e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=42, i=5, f=9.080e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.11e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=41, i=5, f=6.180e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.01e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=40, i=5, f=3.890e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.11e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=3, f=9.110e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=3, f=8.450e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.02e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=3, f=5.880e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=3, f=7.560e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=3, f=6.210e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=3, f=1.290e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.14e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=11, i=0, f=7.190e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=12, i=1, f=5.390e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=11, i=1, f=1.800e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=12, i=2, f=1.070e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=11, i=2, f=7.150e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=10, i=2, f=6.040e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.18e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=0, f=3.520e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.86e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=1, f=8.630e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.86e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=2, f=6.190e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.86e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=8, i=1, f=5.880e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.38e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=7, i=0, f=1.400e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=8, i=2, f=1.040e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.38e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=7, i=1, f=3.560e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=6, i=1, f=4.710e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.43e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=7, i=2, f=3.560e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=4, f=1.250e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=4, f=1.460e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=3, f=1.180e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.86e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=8, i=3, f=2.390e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.38e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=7, i=3, f=2.800e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=4, f=9.400e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.86e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=7, i=4, f=2.130e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=18, f=1.640e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=19, f=1.630e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=20, f=1.630e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.41e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=1, f=2.242e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.636)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=2, f=1.150e-14, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.636)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=22, i=7, f=8.000e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.51e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=21, i=7, f=2.150e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.91e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=21, i=8, f=8.240e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.91e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=22, i=9, f=1.220e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.51e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=4, i=3, f=1.448e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.636)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=7, f=1.500e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=6, f=3.500e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=7, f=8.740e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=18, i=7, f=1.240e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.04e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=8, f=2.830e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=8, f=1.010e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=21, i=9, f=6.440e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.91e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=17, i=6, f=1.270e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=17, i=7, f=1.200e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=17, i=8, f=1.050e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=0, f=6.219e-15, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.000242)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=1, f=1.460e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.000242)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=1, f=2.282e-15, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.000242)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=2, f=2.619e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.000242)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=3, i=2, f=1.499e-14, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.000242)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=13, f=3.110e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=14, f=1.070e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=15, f=1.090e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=15, f=1.210e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=16, f=2.480e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=13, f=1.360e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=13, f=1.220e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=9, f=1.180e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=9, f=5.860e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=18, i=9, f=7.110e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.04e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=15, i=7, f=3.990e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=6, f=5.340e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=16, i=8, f=4.420e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=7, f=1.290e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=15, i=8, f=7.600e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=8, f=4.950e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=14, f=1.310e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=13, f=6.520e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.14e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=15, f=4.100e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.02e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=17, i=9, f=1.250e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=14, f=1.800e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=15, f=1.450e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=14, f=8.890e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=15, f=1.100e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=15, f=1.930e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=37, i=17, f=5.680e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.91e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=17, f=1.760e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=16, f=1.530e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=17, f=3.110e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=16, f=2.290e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=13, i=6, f=1.360e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.57e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=14, f=7.900e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=29, i=16, f=7.010e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.63e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=15, f=6.960e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=13, i=7, f=5.180e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.57e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=15, f=6.030e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=16, f=2.630e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=13, i=8, f=3.300e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.57e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=16, f=4.400e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=14, f=1.060e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.14e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=17, f=2.070e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=15, f=4.560e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.14e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=18, f=2.720e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=37, i=19, f=1.000e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.91e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=19, f=8.410e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=19, f=9.700e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=20, f=7.220e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=20, f=2.240e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=9, f=3.710e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=17, f=2.560e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=17, f=2.540e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=18, f=5.740e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=19, f=8.260e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=20, f=6.380e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=10, f=6.750e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=11, f=1.810e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=20, i=12, f=1.650e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=11, f=2.810e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=19, i=12, f=5.130e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.05e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=18, i=11, f=3.820e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.04e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=20, f=1.760e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.02e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=19, f=5.130e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=18, f=6.420e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=20, f=5.370e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=19, f=1.510e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=20, f=8.700e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.56e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=20, f=5.240e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=13, i=9, f=2.710e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.57e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=19, f=1.130e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=20, f=2.180e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=20, f=1.420e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=21, f=1.470e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=21, f=7.430e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.02e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=21, f=1.490e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.52e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=21, f=1.630e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=16, i=10, f=1.520e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=16, i=12, f=2.950e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.85e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=15, i=10, f=2.120e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=15, i=11, f=4.460e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=15, i=12, f=1.130e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=21, f=4.390e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.82e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=11, f=1.220e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=14, i=12, f=2.690e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.84e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=21, f=2.070e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.87e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=14, f=8.290e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.43e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=14, f=3.230e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=14, f=5.760e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=15, f=3.160e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=15, f=1.110e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=16, f=1.400e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=22, f=5.720e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=21, f=1.100e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.14e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=22, f=4.000e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.61e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=17, f=8.910e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.43e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=17, f=8.160e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=17, f=3.320e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=22, f=6.660e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=18, f=7.000e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=19, f=2.330e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.43e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=19, f=2.820e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=19, f=1.780e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=20, f=5.180e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=20, f=1.700e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.41e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=2, i=0, f=7.202e-17, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e-07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=2, i=1, f=9.082e-10, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e-07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=2, i=1, f=1.302e-17, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e-07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=1, i=0, f=1.318e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.88e-08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=39, i=38, f=1.707e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.29e-06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=44, i=38, f=4.483e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=121)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=45, i=38, f=2.769e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.95)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=48, i=38, f=1.287e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=49, i=38, f=1.286e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=50, i=38, f=3.222e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.96e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=51, i=38, f=1.611e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.96e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=52, i=38, f=4.073e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=44, i=39, f=2.663e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=121)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=45, i=39, f=4.256e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.95)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=46, i=39, f=5.256e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=43.2)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=48, i=39, f=1.281e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=47, i=39, f=1.159e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.89e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=49, i=39, f=1.282e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.39e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=50, i=39, f=8.155e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.96e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=51, i=39, f=4.044e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.96e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=52, i=39, f=6.133e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.48e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=55, i=44, f=1.761e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.46e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=55, i=45, f=1.759e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.46e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=55, i=46, f=1.765e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.46e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=57, i=48, f=1.190e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.68e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=56, i=48, f=1.332e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.69e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=58, i=48, f=1.494e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.34e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=59, i=48, f=3.042e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=57, i=47, f=8.933e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.68e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=56, i=47, f=1.238e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.69e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=59, i=47, f=1.770e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=58, i=49, f=2.730e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.34e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=59, i=49, f=6.472e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=53, i=49, f=4.227e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.11e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=54, i=49, f=8.690e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=55, i=50, f=4.530e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.46e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=57, i=50, f=1.016e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.68e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=58, i=50, f=1.470e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.34e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=59, i=50, f=6.353e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=53, i=50, f=1.798e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.11e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=54, i=50, f=5.570e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=55, i=51, f=1.171e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.46e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=57, i=51, f=1.003e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.68e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=56, i=51, f=9.129e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.69e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=58, i=51, f=3.479e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.34e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=59, i=51, f=1.764e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=53, i=51, f=3.786e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.11e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=54, i=51, f=1.935e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=53, i=52, f=2.340e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.11e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=54, i=52, f=4.673e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=62, i=60, f=1.704e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=104)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=63, i=60, f=1.421e-11, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.00522)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=64, i=60, f=7.594e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.77e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=60, f=3.454e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=72, i=60, f=2.409e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.98e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=66, i=61, f=2.740e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=70, i=61, f=5.337e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.69e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=61, f=5.607e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=63, i=62, f=1.927e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.00522)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=65, i=62, f=9.128e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=66, i=62, f=6.847e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=67, i=62, f=1.142e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=68, i=62, f=1.419e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=70, i=62, f=5.340e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.69e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=62, f=1.402e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=77, i=62, f=4.206e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=66, i=63, f=6.843e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=67, i=63, f=2.054e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=68, i=63, f=5.442e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=70, i=63, f=5.346e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.69e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=63, f=5.609e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=77, i=63, f=8.414e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=78, i=63, f=4.713e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=68, i=64, f=1.833e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.39e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=69, i=64, f=1.632e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.1e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=71, i=64, f=2.035e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.54e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=79, i=64, f=5.151e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.29e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=65, f=2.107e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=73, i=66, f=6.964e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.4e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=66, f=5.249e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=75, i=66, f=8.874e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=67, f=5.212e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=75, i=67, f=1.591e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=68, f=4.350e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=72, i=68, f=2.526e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.98e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=69, f=2.441e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=72, i=69, f=1.653e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.98e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=73, i=70, f=7.779e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.4e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=70, f=2.334e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=75, i=70, f=3.893e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=74, i=71, f=5.501e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.46e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=72, i=71, f=3.306e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.98e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=73, f=1.860e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=74, f=4.646e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=77, i=74, f=1.394e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=76, i=75, f=1.856e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=77, i=75, f=2.785e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=78, i=75, f=1.561e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.06e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=79, i=72, f=3.469e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.29e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=81, i=80, f=9.481e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.63e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=82, i=80, f=1.904e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=84, i=80, f=6.659e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.55e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=85, i=80, f=1.337e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.57e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=83, i=81, f=3.773e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.28e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=86, i=81, f=6.544e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.78e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=83, i=82, f=3.763e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.28e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=86, i=82, f=6.549e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.78e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=87, i=82, f=5.874e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.77e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=89, i=88, f=3.757e-11, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=48.6)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=90, i=88, f=8.198e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=330000)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=91, i=88, f=2.164e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.69e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=93, i=88, f=3.295e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.85e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=94, i=88, f=6.467e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.87e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=104, i=88, f=1.402e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.68e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=92, i=89, f=1.501e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.79e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=91, i=89, f=4.506e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.69e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=93, i=89, f=7.541e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.85e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=98, i=89, f=3.515e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.36e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=97, i=89, f=1.055e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.36e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=99, i=89, f=1.756e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.36e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=94, i=90, f=9.223e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.87e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=104, i=90, f=3.515e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.68e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=95, i=92, f=1.507e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.74e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=92, f=6.554e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=95, i=91, f=4.523e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.74e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=91, f=1.649e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=101, i=91, f=4.926e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=95, i=93, f=7.553e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.74e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=93, f=6.695e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=101, i=93, f=9.822e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=102, i=93, f=5.516e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=96, i=94, f=1.358e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.68e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=103, i=94, f=7.065e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.96e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=98, f=5.416e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=97, f=1.359e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=101, i=97, f=4.067e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=100, i=99, f=5.416e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.26e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=101, i=99, f=8.123e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=102, i=99, f=4.537e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.25e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=107, i=105, f=6.547e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=384000)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=106, i=105, f=1.386e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.12e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=108, i=105, f=2.776e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.14e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=109, i=105, f=2.633e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.46e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=112, i=105, f=5.276e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.46e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=109, i=107, f=1.448e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.46e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=112, i=107, f=2.901e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.46e+11)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=110, i=106, f=1.359e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.19e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=111, i=106, f=6.958e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.4e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=110, i=108, f=1.359e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.19e+09)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=111, i=108, f=6.960e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.4e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=113, i=108, f=6.263e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.39e+10)], elastic=[VdwUnsold(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
	],
	continua=[
		ExplicitContinuum(j=38, i=0, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.11120956888435], alphaGrid=[8.43e-24, 7.72e-24, 1.82e-23, 2.96e-23, 4.04e-23, 5.44e-23, 6.9e-23, 8.26e-23, 9.54e-23, 1.08e-22, 1.19e-22, 1.3e-22, 1.46e-22, 1.65e-22, 1.8e-22, 1.9e-22, 2.02e-22, 2.15e-22, 2.29e-22, 2.43e-22, 2.49e-22, 2.58e-22, 2.7e-22, 2.87e-22, 2.84e-22, 2.94e-22, 3.04e-22, 3.36e-22, 3.28e-22, 3.36e-22, 3.46e-22, 3.54e-22, 3.62e-22, 3.76e-22, 3.83e-22, 3.89e-22, 3.98e-22, 4.1e-22, 4.21e-22, 4.32e-22, 4.26e-22, 4.35e-22, 4.53e-22, 4.36e-22, 4.58e-22, 4.97e-22, 4.75e-22, 4.63e-22, 4.5e-22, 4.19e-22, 3.46e-22, 6.58e-22, 5.98e-22, 5.63e-22, 5.55e-22, 5.5e-22, 5.48e-22, 5.5e-22, 5.53e-22, 5.55e-22, 5.58e-22, 5.61e-22, 5.63e-22, 5.66e-22, 5.68e-22, 5.71e-22, 5.73e-22, 5.76e-22, 5.78e-22, 5.8e-22, 5.83e-22, 5.85e-22, 5.88e-22, 5.9e-22, 5.92e-22, 5.92e-22]),
		ExplicitContinuum(j=39, i=0, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.03436978557437], alphaGrid=[1.69e-23, 1.54e-23, 3.65e-23, 5.92e-23, 8.07e-23, 1.09e-22, 1.38e-22, 1.65e-22, 1.91e-22, 2.15e-22, 2.39e-22, 2.61e-22, 2.92e-22, 3.3e-22, 3.6e-22, 3.8e-22, 4.04e-22, 4.3e-22, 4.58e-22, 4.86e-22, 4.98e-22, 5.16e-22, 5.39e-22, 5.74e-22, 5.69e-22, 5.88e-22, 6.07e-22, 6.71e-22, 6.57e-22, 6.72e-22, 6.92e-22, 7.08e-22, 7.25e-22, 7.52e-22, 7.65e-22, 7.79e-22, 7.96e-22, 8.19e-22, 8.42e-22, 8.64e-22, 8.52e-22, 8.71e-22, 9.06e-22, 8.72e-22, 9.16e-22, 9.94e-22, 9.49e-22, 9.26e-22, 9.01e-22, 8.38e-22, 6.92e-22, 1.32e-21, 1.2e-21, 1.13e-21, 1.11e-21, 1.1e-21, 1.1e-21, 1.1e-21, 1.11e-21, 1.11e-21, 1.12e-21, 1.12e-21, 1.13e-21, 1.13e-21, 1.14e-21, 1.14e-21, 1.15e-21, 1.15e-21, 1.16e-21, 1.16e-21, 1.17e-21, 1.17e-21, 1.18e-21, 1.18e-21, 1.18e-21, 1.18e-21]),
		ExplicitContinuum(j=38, i=1, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.1310973049544], alphaGrid=[8.43e-24, 7.72e-24, 1.82e-23, 2.96e-23, 4.04e-23, 5.44e-23, 6.9e-23, 8.26e-23, 9.54e-23, 1.08e-22, 1.19e-22, 1.3e-22, 1.46e-22, 1.65e-22, 1.8e-22, 1.9e-22, 2.02e-22, 2.15e-22, 2.29e-22, 2.43e-22, 2.49e-22, 2.58e-22, 2.7e-22, 2.87e-22, 2.84e-22, 2.94e-22, 3.04e-22, 3.36e-22, 3.28e-22, 3.36e-22, 3.46e-22, 3.54e-22, 3.62e-22, 3.76e-22, 3.83e-22, 3.89e-22, 3.98e-22, 4.1e-22, 4.21e-22, 4.32e-22, 4.26e-22, 4.35e-22, 4.53e-22, 4.36e-22, 4.58e-22, 4.97e-22, 4.75e-22, 4.63e-22, 4.5e-22, 4.19e-22, 3.46e-22, 6.58e-22, 5.98e-22, 5.63e-22, 5.55e-22, 5.5e-22, 5.48e-22, 5.5e-22, 5.53e-22, 5.55e-22, 5.58e-22, 5.61e-22, 5.63e-22, 5.66e-22, 5.68e-22, 5.71e-22, 5.73e-22, 5.76e-22, 5.78e-22, 5.8e-22, 5.83e-22, 5.85e-22, 5.88e-22, 5.9e-22, 5.92e-22, 5.92e-22]),
		ExplicitContinuum(j=39, i=1, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.0542297719913], alphaGrid=[1.69e-23, 1.54e-23, 3.65e-23, 5.92e-23, 8.07e-23, 1.09e-22, 1.38e-22, 1.65e-22, 1.91e-22, 2.15e-22, 2.39e-22, 2.61e-22, 2.92e-22, 3.3e-22, 3.6e-22, 3.8e-22, 4.04e-22, 4.3e-22, 4.58e-22, 4.86e-22, 4.98e-22, 5.16e-22, 5.39e-22, 5.74e-22, 5.69e-22, 5.88e-22, 6.07e-22, 6.71e-22, 6.57e-22, 6.72e-22, 6.92e-22, 7.08e-22, 7.25e-22, 7.52e-22, 7.65e-22, 7.79e-22, 7.96e-22, 8.19e-22, 8.42e-22, 8.64e-22, 8.52e-22, 8.71e-22, 9.06e-22, 8.72e-22, 9.16e-22, 9.94e-22, 9.49e-22, 9.26e-22, 9.01e-22, 8.38e-22, 6.92e-22, 1.32e-21, 1.2e-21, 1.13e-21, 1.11e-21, 1.1e-21, 1.1e-21, 1.1e-21, 1.11e-21, 1.11e-21, 1.12e-21, 1.12e-21, 1.13e-21, 1.13e-21, 1.14e-21, 1.14e-21, 1.15e-21, 1.15e-21, 1.16e-21, 1.16e-21, 1.17e-21, 1.17e-21, 1.18e-21, 1.18e-21, 1.18e-21, 1.18e-21]),
		ExplicitContinuum(j=38, i=2, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.16385496377674], alphaGrid=[8.43e-24, 7.72e-24, 1.82e-23, 2.96e-23, 4.04e-23, 5.44e-23, 6.9e-23, 8.26e-23, 9.54e-23, 1.08e-22, 1.19e-22, 1.3e-22, 1.46e-22, 1.65e-22, 1.8e-22, 1.9e-22, 2.02e-22, 2.15e-22, 2.29e-22, 2.43e-22, 2.49e-22, 2.58e-22, 2.7e-22, 2.87e-22, 2.84e-22, 2.94e-22, 3.04e-22, 3.36e-22, 3.28e-22, 3.36e-22, 3.46e-22, 3.54e-22, 3.62e-22, 3.76e-22, 3.83e-22, 3.89e-22, 3.98e-22, 4.1e-22, 4.21e-22, 4.32e-22, 4.26e-22, 4.35e-22, 4.53e-22, 4.36e-22, 4.58e-22, 4.97e-22, 4.75e-22, 4.63e-22, 4.5e-22, 4.19e-22, 3.46e-22, 6.58e-22, 5.98e-22, 5.63e-22, 5.55e-22, 5.5e-22, 5.48e-22, 5.5e-22, 5.53e-22, 5.55e-22, 5.58e-22, 5.61e-22, 5.63e-22, 5.66e-22, 5.68e-22, 5.71e-22, 5.73e-22, 5.76e-22, 5.78e-22, 5.8e-22, 5.83e-22, 5.85e-22, 5.88e-22, 5.9e-22, 5.92e-22, 5.92e-22]),
		ExplicitContinuum(j=39, i=2, wavelengthGrid=[0.912, 8.7, 13.001, 16.472, 19.491, 22.215, 24.722, 27.062, 29.27, 31.366, 33.369, 35.292, 37.144, 38.932, 40.666, 42.349, 43.988, 45.585, 47.143, 48.666, 50.157, 51.618, 53.049, 54.455, 55.835, 57.192, 58.528, 59.842, 61.136, 62.412, 63.669, 64.91, 66.135, 67.343, 68.536, 69.716, 70.881, 72.033, 73.173, 74.299, 75.415, 76.519, 77.611, 78.694, 79.766, 80.828, 81.881, 82.923, 83.957, 84.983, 85.999, 87.007, 88.007, 89.0, 89.986, 90.962, 91.931, 92.895, 93.85, 94.799, 95.742, 96.678, 97.609, 98.531, 99.449, 100.362, 101.267, 102.168, 103.063, 103.952, 104.837, 105.715, 106.59, 107.459, 108.323, 110.08694171265228], alphaGrid=[1.69e-23, 1.54e-23, 3.65e-23, 5.92e-23, 8.07e-23, 1.09e-22, 1.38e-22, 1.65e-22, 1.91e-22, 2.15e-22, 2.39e-22, 2.61e-22, 2.92e-22, 3.3e-22, 3.6e-22, 3.8e-22, 4.04e-22, 4.3e-22, 4.58e-22, 4.86e-22, 4.98e-22, 5.16e-22, 5.39e-22, 5.74e-22, 5.69e-22, 5.88e-22, 6.07e-22, 6.71e-22, 6.57e-22, 6.72e-22, 6.92e-22, 7.08e-22, 7.25e-22, 7.52e-22, 7.65e-22, 7.79e-22, 7.96e-22, 8.19e-22, 8.42e-22, 8.64e-22, 8.52e-22, 8.71e-22, 9.06e-22, 8.72e-22, 9.16e-22, 9.94e-22, 9.49e-22, 9.26e-22, 9.01e-22, 8.38e-22, 6.92e-22, 1.32e-21, 1.2e-21, 1.13e-21, 1.11e-21, 1.1e-21, 1.1e-21, 1.1e-21, 1.11e-21, 1.11e-21, 1.12e-21, 1.12e-21, 1.13e-21, 1.13e-21, 1.14e-21, 1.14e-21, 1.15e-21, 1.15e-21, 1.16e-21, 1.16e-21, 1.17e-21, 1.17e-21, 1.18e-21, 1.18e-21, 1.18e-21, 1.18e-21]),
		ExplicitContinuum(j=38, i=3, wavelengthGrid=[7.33, 12.449, 16.444, 19.885, 22.975, 25.815, 28.465, 30.963, 33.338, 35.606, 37.785, 39.884, 41.914, 43.882, 45.794, 47.655, 49.473, 51.246, 52.98, 54.678, 56.342, 57.976, 59.58, 61.156, 62.706, 64.231, 65.735, 67.215, 68.675, 70.116, 71.535, 72.939, 74.323, 75.694, 77.046, 78.383, 79.706, 81.015, 82.311, 83.594, 84.862, 86.12, 87.365, 88.6, 89.823, 91.035, 92.236, 93.429, 94.611, 95.782, 96.947, 98.101, 99.246, 100.382, 101.512, 102.632, 103.744, 104.849, 105.946, 107.037, 108.121, 109.196, 110.265, 111.328, 112.383, 113.433, 114.476, 115.512, 116.543, 117.569, 118.589, 119.602, 120.61, 121.613, 122.61, 124.031553875369], alphaGrid=[2.26e-24, 6.42e-24, 1.48e-23, 2.62e-23, 4.03e-23, 5.72e-23, 7.67e-23, 1.02e-22, 1.2e-22, 1.3e-22, 1.43e-22, 1.62e-22, 1.8e-22, 1.89e-22, 2.02e-22, 2.02e-22, 2.21e-22, 2.24e-22, 2.27e-22, 2.38e-22, 2.37e-22, 2.66e-22, 2.67e-22, 2.74e-22, 2.82e-22, 2.91e-22, 3.09e-22, 3.24e-22, 3.27e-22, 3.35e-22, 3.92e-22, 3.79e-22, 3.75e-22, 3.75e-22, 3.86e-22, 3.98e-22, 4.1e-22, 4.23e-22, 4.4e-22, 4.58e-22, 4.76e-22, 5.02e-22, 5.38e-22, 6.1e-22, 8.23e-22, 1.68e-21, 2.19e-21, 1.34e-21, 1.04e-21, 9.6e-22, 9.53e-22, 9.85e-22, 1.04e-21, 1.12e-21, 1.21e-21, 1.32e-21, 1.43e-21, 1.51e-21, 1.54e-21, 1.47e-21, 1.3e-21, 1.1e-21, 8.98e-22, 7.44e-22, 6.32e-22, 5.55e-22, 5.03e-22, 4.68e-22, 4.46e-22, 4.34e-22, 4.22e-22, 4.17e-22, 4.15e-22, 4.14e-22, 4.12e-22, 4.12e-22]),
		ExplicitContinuum(j=39, i=3, wavelengthGrid=[7.33, 12.449, 16.444, 19.885, 22.975, 25.815, 28.465, 30.963, 33.338, 35.606, 37.785, 39.884, 41.914, 43.882, 45.794, 47.655, 49.473, 51.246, 52.98, 54.678, 56.342, 57.976, 59.58, 61.156, 62.706, 64.231, 65.735, 67.215, 68.675, 70.116, 71.535, 72.939, 74.323, 75.694, 77.046, 78.383, 79.706, 81.015, 82.311, 83.594, 84.862, 86.12, 87.365, 88.6, 89.823, 91.035, 92.236, 93.429, 94.611, 95.782, 96.947, 98.101, 99.246, 100.382, 101.512, 102.632, 103.744, 104.849, 105.946, 107.037, 108.121, 109.196, 110.265, 111.328, 112.383, 113.433, 114.476, 115.512, 116.543, 117.569, 118.589, 119.602, 120.61, 121.613, 122.61, 123.93406633310637], alphaGrid=[4.52e-24, 1.28e-23, 2.96e-23, 5.23e-23, 8.07e-23, 1.14e-22, 1.53e-22, 2.04e-22, 2.39e-22, 2.59e-22, 2.87e-22, 3.23e-22, 3.6e-22, 3.79e-22, 4.04e-22, 4.04e-22, 4.42e-22, 4.48e-22, 4.54e-22, 4.76e-22, 4.75e-22, 5.33e-22, 5.35e-22, 5.49e-22, 5.64e-22, 5.81e-22, 6.18e-22, 6.48e-22, 6.54e-22, 6.7e-22, 7.85e-22, 7.58e-22, 7.51e-22, 7.5e-22, 7.72e-22, 7.97e-22, 8.21e-22, 8.46e-22, 8.79e-22, 9.15e-22, 9.51e-22, 1e-21, 1.08e-21, 1.22e-21, 1.65e-21, 3.37e-21, 4.37e-21, 2.69e-21, 2.08e-21, 1.92e-21, 1.91e-21, 1.97e-21, 2.08e-21, 2.23e-21, 2.41e-21, 2.63e-21, 2.85e-21, 3.03e-21, 3.09e-21, 2.93e-21, 2.6e-21, 2.19e-21, 1.8e-21, 1.49e-21, 1.26e-21, 1.11e-21, 1.01e-21, 9.37e-22, 8.93e-22, 8.68e-22, 8.45e-22, 8.34e-22, 8.31e-22, 8.27e-22, 8.25e-22, 8.25e-22]),
		ExplicitContinuum(j=38, i=4, wavelengthGrid=[8.125, 13.673, 18.115, 21.989, 25.496, 28.742, 31.786, 34.667, 37.415, 40.049, 42.585, 45.036, 47.41, 49.717, 51.964, 54.155, 56.293, 58.386, 60.437, 62.447, 64.419, 66.358, 68.264, 70.139, 71.984, 73.802, 75.596, 77.364, 79.109, 80.832, 82.534, 84.215, 85.875, 87.519, 89.143, 90.752, 92.343, 93.918, 95.478, 97.024, 98.555, 100.074, 101.576, 103.068, 104.547, 106.014, 107.468, 108.912, 110.343, 111.764, 113.175, 114.575, 115.967, 117.346, 118.719, 120.08, 121.434, 122.778, 124.114, 125.441, 126.76, 128.073, 129.375, 130.671, 131.961, 133.24, 134.516, 135.783, 137.041, 138.296, 139.542, 140.782, 142.016, 143.243, 144.464, 144.5728821897992], alphaGrid=[2.79e-24, 7.85e-24, 1.82e-23, 3.25e-23, 5.07e-23, 7.26e-23, 9.82e-23, 1.27e-22, 1.46e-22, 1.63e-22, 2.01e-22, 2.22e-22, 2.3e-22, 2.22e-22, 2.21e-22, 2.28e-22, 2.4e-22, 2.55e-22, 2.55e-22, 3.01e-22, 3.05e-22, 3.25e-22, 3.04e-22, 3.38e-22, 3.5e-22, 3.55e-22, 3.76e-22, 4.44e-22, 4.7e-22, 3.69e-22, 4.05e-22, 4.37e-22, 4.68e-22, 5e-22, 5.39e-22, 5.8e-22, 6.36e-22, 7.04e-22, 7.99e-22, 9.43e-22, 1.18e-21, 1.66e-21, 2.83e-21, 4.42e-21, 1.73e-21, 3.03e-22, 1.11e-22, 1.08e-22, 1.37e-22, 1.68e-22, 1.96e-22, 2.23e-22, 2.45e-22, 2.65e-22, 2.84e-22, 3.02e-22, 3.15e-22, 3.28e-22, 3.41e-22, 3.54e-22, 3.66e-22, 3.79e-22, 3.89e-22, 3.97e-22, 4.05e-22, 4.12e-22, 4.2e-22, 4.28e-22, 4.35e-22, 4.43e-22, 4.5e-22, 4.57e-22, 4.65e-22, 4.72e-22, 4.78e-22, 4.78e-22]),
		ExplicitContinuum(j=39, i=4, wavelengthGrid=[8.125, 13.673, 18.115, 21.989, 25.496, 28.742, 31.786, 34.667, 37.415, 40.049, 42.585, 45.036, 47.41, 49.717, 51.964, 54.155, 56.293, 58.386, 60.437, 62.447, 64.419, 66.358, 68.264, 70.139, 71.984, 73.802, 75.596, 77.364, 79.109, 80.832, 82.534, 84.215, 85.875, 87.519, 89.143, 90.752, 92.343, 93.918, 95.478, 97.024, 98.555, 100.074, 101.576, 103.068, 104.547, 106.014, 107.468, 108.912, 110.343, 111.764, 113.175, 114.575, 115.967, 117.346, 118.719, 120.08, 121.434, 122.778, 124.114, 125.441, 126.76, 128.073, 129.375, 130.671, 131.961, 133.24, 134.516, 135.783, 137.041, 138.296, 139.542, 140.782, 142.016, 143.243, 144.44044745628457], alphaGrid=[5.57e-24, 1.57e-23, 3.64e-23, 6.51e-23, 1.01e-22, 1.45e-22, 1.96e-22, 2.54e-22, 2.91e-22, 3.26e-22, 4.03e-22, 4.45e-22, 4.61e-22, 4.44e-22, 4.41e-22, 4.57e-22, 4.81e-22, 5.1e-22, 5.1e-22, 6.01e-22, 6.09e-22, 6.5e-22, 6.07e-22, 6.76e-22, 6.99e-22, 7.1e-22, 7.53e-22, 8.88e-22, 9.4e-22, 7.39e-22, 8.1e-22, 8.73e-22, 9.36e-22, 1e-21, 1.08e-21, 1.16e-21, 1.27e-21, 1.41e-21, 1.6e-21, 1.89e-21, 2.36e-21, 3.31e-21, 5.66e-21, 8.83e-21, 3.46e-21, 6.06e-22, 2.22e-22, 2.17e-22, 2.74e-22, 3.36e-22, 3.92e-22, 4.47e-22, 4.9e-22, 5.3e-22, 5.69e-22, 6.04e-22, 6.31e-22, 6.57e-22, 6.82e-22, 7.08e-22, 7.33e-22, 7.58e-22, 7.79e-22, 7.94e-22, 8.1e-22, 8.25e-22, 8.4e-22, 8.55e-22, 8.7e-22, 8.85e-22, 9e-22, 9.15e-22, 9.29e-22, 9.44e-22, 9.44e-22]),
		ExplicitContinuum(j=38, i=5, wavelengthGrid=[9.178, 12.972, 16.081, 18.799, 21.254, 23.518, 25.631, 27.624, 29.517, 31.325, 33.058, 34.729, 36.342, 37.904, 39.42, 40.894, 42.331, 43.733, 45.103, 46.442, 47.754, 49.041, 50.303, 51.543, 52.76, 53.957, 55.136, 56.296, 57.438, 58.565, 59.675, 60.772, 61.853, 62.921, 63.975, 65.017, 66.048, 67.066, 68.073, 69.069, 70.056, 71.032, 71.997, 72.953, 73.902, 74.841, 75.771, 76.692, 77.606, 78.512, 79.411, 80.302, 81.186, 82.063, 82.933, 83.797, 84.653, 85.504, 86.348, 87.187, 88.02, 88.846, 89.668, 90.484, 91.295, 92.099, 92.899, 93.694, 94.485, 95.27, 96.051, 96.826, 97.598, 98.365, 99.128, 175.18634352377694], alphaGrid=[3.64e-24, 7.41e-24, 1.41e-23, 2.26e-23, 3.26e-23, 4.42e-23, 5.73e-23, 7.17e-23, 8.74e-23, 1.05e-22, 1.23e-22, 1.42e-22, 1.63e-22, 1.85e-22, 2.08e-22, 2.33e-22, 2.58e-22, 2.76e-22, 2.89e-22, 3.02e-22, 3.15e-22, 3.26e-22, 3.66e-22, 3.54e-22, 3.69e-22, 3.83e-22, 3.85e-22, 3.93e-22, 4.04e-22, 4.15e-22, 4.26e-22, 4.37e-22, 4.47e-22, 4.58e-22, 4.68e-22, 4.78e-22, 4.88e-22, 4.98e-22, 5.08e-22, 5.17e-22, 5.27e-22, 5.36e-22, 5.43e-22, 5.48e-22, 5.54e-22, 5.6e-22, 5.65e-22, 5.71e-22, 5.77e-22, 5.82e-22, 5.88e-22, 5.93e-22, 5.98e-22, 6.04e-22, 6.09e-22, 6.14e-22, 6.19e-22, 6.24e-22, 6.27e-22, 6.28e-22, 6.3e-22, 6.32e-22, 6.33e-22, 6.35e-22, 6.36e-22, 6.38e-22, 6.39e-22, 6.41e-22, 6.42e-22, 6.44e-22, 6.45e-22, 6.47e-22, 6.48e-22, 6.5e-22, 6.51e-22, 6.51e-22]),
		ExplicitContinuum(j=39, i=5, wavelengthGrid=[9.178, 12.972, 16.081, 18.799, 21.254, 23.518, 25.631, 27.624, 29.517, 31.325, 33.058, 34.729, 36.342, 37.904, 39.42, 40.894, 42.331, 43.733, 45.103, 46.442, 47.754, 49.041, 50.303, 51.543, 52.76, 53.957, 55.136, 56.296, 57.438, 58.565, 59.675, 60.772, 61.853, 62.921, 63.975, 65.017, 66.048, 67.066, 68.073, 69.069, 70.056, 71.032, 71.997, 72.953, 73.902, 74.841, 75.771, 76.692, 77.606, 78.512, 79.411, 80.302, 81.186, 82.063, 82.933, 83.797, 84.653, 85.504, 86.348, 87.187, 88.02, 88.846, 89.668, 90.484, 91.295, 92.099, 92.899, 93.694, 94.485, 95.27, 96.051, 96.826, 97.598, 98.365, 99.128, 174.99192193540367], alphaGrid=[7.27e-24, 1.48e-23, 2.83e-23, 4.52e-23, 6.53e-23, 8.84e-23, 1.15e-22, 1.43e-22, 1.75e-22, 2.09e-22, 2.46e-22, 2.85e-22, 3.26e-22, 3.7e-22, 4.17e-22, 4.65e-22, 5.16e-22, 5.52e-22, 5.79e-22, 6.05e-22, 6.31e-22, 6.52e-22, 7.32e-22, 7.08e-22, 7.38e-22, 7.65e-22, 7.71e-22, 7.87e-22, 8.09e-22, 8.31e-22, 8.52e-22, 8.73e-22, 8.94e-22, 9.15e-22, 9.36e-22, 9.56e-22, 9.76e-22, 9.96e-22, 1.02e-21, 1.03e-21, 1.05e-21, 1.07e-21, 1.09e-21, 1.1e-21, 1.11e-21, 1.12e-21, 1.13e-21, 1.14e-21, 1.15e-21, 1.16e-21, 1.18e-21, 1.19e-21, 1.2e-21, 1.21e-21, 1.22e-21, 1.23e-21, 1.24e-21, 1.25e-21, 1.25e-21, 1.26e-21, 1.26e-21, 1.26e-21, 1.27e-21, 1.27e-21, 1.27e-21, 1.28e-21, 1.28e-21, 1.28e-21, 1.28e-21, 1.29e-21, 1.29e-21, 1.29e-21, 1.3e-21, 1.3e-21, 1.3e-21, 1.3e-21]),
		ExplicitContinuum(j=38, i=6, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 328.04260748603076], alphaGrid=[2.16e-24, 7.06e-24, 1.88e-23, 3.74e-23, 6.38e-23, 9.84e-23, 1.26e-22, 1.93e-22, 2.33e-22, 2.07e-22, 2.52e-22, 3.93e-22, 1.24e-22, 1.15e-22, 1.94e-21, 7.89e-23, 2.82e-22, 2.68e-22, 4.04e-23, 2.45e-23, 1.94e-23, 1.65e-23, 2.12e-23, 5.45e-22, 1.12e-21, 1.21e-22, 7.22e-23, 5.81e-23, 5.67e-23, 4.2e-23, 3.69e-23, 6.65e-23, 4.19e-23, 3.63e-23, 3.4e-23, 3.23e-23, 3.08e-23, 2.99e-23, 2.91e-23, 2.82e-23, 2.8e-23, 2.82e-23, 2.99e-23, 3.51e-23, 5.12e-23, 9.88e-23, 1.53e-22, 1.23e-22, 7.94e-23, 5.73e-23, 4.62e-23, 3.98e-23, 3.58e-23, 3.29e-23, 3.08e-23, 2.91e-23, 2.78e-23, 2.65e-23, 2.55e-23, 2.47e-23, 2.39e-23, 2.31e-23, 2.23e-23, 2.16e-23, 2.11e-23, 2.06e-23, 2.01e-23, 1.96e-23, 1.91e-23, 1.86e-23, 1.81e-23, 1.76e-23, 1.71e-23, 1.66e-23, 1.63e-23, 1.63e-23]),
		ExplicitContinuum(j=39, i=6, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 327.3615493891188], alphaGrid=[4.31e-24, 1.41e-23, 3.76e-23, 7.49e-23, 1.28e-22, 1.97e-22, 2.52e-22, 3.86e-22, 4.66e-22, 4.14e-22, 5.03e-22, 7.87e-22, 2.47e-22, 2.29e-22, 3.89e-21, 1.58e-22, 5.64e-22, 5.36e-22, 8.08e-23, 4.9e-23, 3.88e-23, 3.31e-23, 4.25e-23, 1.09e-21, 2.24e-21, 2.42e-22, 1.44e-22, 1.16e-22, 1.13e-22, 8.4e-23, 7.39e-23, 1.33e-22, 8.39e-23, 7.26e-23, 6.79e-23, 6.46e-23, 6.16e-23, 5.98e-23, 5.81e-23, 5.65e-23, 5.6e-23, 5.65e-23, 5.98e-23, 7.02e-23, 1.02e-22, 1.98e-22, 3.05e-22, 2.47e-22, 1.59e-22, 1.15e-22, 9.23e-23, 7.97e-23, 7.15e-23, 6.58e-23, 6.15e-23, 5.82e-23, 5.56e-23, 5.3e-23, 5.1e-23, 4.94e-23, 4.77e-23, 4.61e-23, 4.45e-23, 4.31e-23, 4.21e-23, 4.11e-23, 4.01e-23, 3.91e-23, 3.82e-23, 3.72e-23, 3.62e-23, 3.52e-23, 3.43e-23, 3.33e-23, 3.26e-23, 3.26e-23]),
		ExplicitContinuum(j=38, i=7, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 328.24935265124543], alphaGrid=[2.16e-24, 7.06e-24, 1.88e-23, 3.74e-23, 6.38e-23, 9.84e-23, 1.26e-22, 1.93e-22, 2.33e-22, 2.07e-22, 2.52e-22, 3.93e-22, 1.24e-22, 1.15e-22, 1.94e-21, 7.89e-23, 2.82e-22, 2.68e-22, 4.04e-23, 2.45e-23, 1.94e-23, 1.65e-23, 2.12e-23, 5.45e-22, 1.12e-21, 1.21e-22, 7.22e-23, 5.81e-23, 5.67e-23, 4.2e-23, 3.69e-23, 6.65e-23, 4.19e-23, 3.63e-23, 3.4e-23, 3.23e-23, 3.08e-23, 2.99e-23, 2.91e-23, 2.82e-23, 2.8e-23, 2.82e-23, 2.99e-23, 3.51e-23, 5.12e-23, 9.88e-23, 1.53e-22, 1.23e-22, 7.94e-23, 5.73e-23, 4.62e-23, 3.98e-23, 3.58e-23, 3.29e-23, 3.08e-23, 2.91e-23, 2.78e-23, 2.65e-23, 2.55e-23, 2.47e-23, 2.39e-23, 2.31e-23, 2.23e-23, 2.16e-23, 2.11e-23, 2.06e-23, 2.01e-23, 1.96e-23, 1.91e-23, 1.86e-23, 1.81e-23, 1.76e-23, 1.71e-23, 1.66e-23, 1.63e-23, 1.63e-23]),
		ExplicitContinuum(j=39, i=7, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 327.56743671765634], alphaGrid=[4.31e-24, 1.41e-23, 3.76e-23, 7.49e-23, 1.28e-22, 1.97e-22, 2.52e-22, 3.86e-22, 4.66e-22, 4.14e-22, 5.03e-22, 7.87e-22, 2.47e-22, 2.29e-22, 3.89e-21, 1.58e-22, 5.64e-22, 5.36e-22, 8.08e-23, 4.9e-23, 3.88e-23, 3.31e-23, 4.25e-23, 1.09e-21, 2.24e-21, 2.42e-22, 1.44e-22, 1.16e-22, 1.13e-22, 8.4e-23, 7.39e-23, 1.33e-22, 8.39e-23, 7.26e-23, 6.79e-23, 6.46e-23, 6.16e-23, 5.98e-23, 5.81e-23, 5.65e-23, 5.6e-23, 5.65e-23, 5.98e-23, 7.02e-23, 1.02e-22, 1.98e-22, 3.05e-22, 2.47e-22, 1.59e-22, 1.15e-22, 9.23e-23, 7.97e-23, 7.15e-23, 6.58e-23, 6.15e-23, 5.82e-23, 5.56e-23, 5.3e-23, 5.1e-23, 4.94e-23, 4.77e-23, 4.61e-23, 4.45e-23, 4.31e-23, 4.21e-23, 4.11e-23, 4.01e-23, 3.91e-23, 3.82e-23, 3.72e-23, 3.62e-23, 3.52e-23, 3.43e-23, 3.33e-23, 3.26e-23, 3.26e-23]),
		ExplicitContinuum(j=38, i=8, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 328.6864195152961], alphaGrid=[2.16e-24, 7.06e-24, 1.88e-23, 3.74e-23, 6.38e-23, 9.84e-23, 1.26e-22, 1.93e-22, 2.33e-22, 2.07e-22, 2.52e-22, 3.93e-22, 1.24e-22, 1.15e-22, 1.94e-21, 7.89e-23, 2.82e-22, 2.68e-22, 4.04e-23, 2.45e-23, 1.94e-23, 1.65e-23, 2.12e-23, 5.45e-22, 1.12e-21, 1.21e-22, 7.22e-23, 5.81e-23, 5.67e-23, 4.2e-23, 3.69e-23, 6.65e-23, 4.19e-23, 3.63e-23, 3.4e-23, 3.23e-23, 3.08e-23, 2.99e-23, 2.91e-23, 2.82e-23, 2.8e-23, 2.82e-23, 2.99e-23, 3.51e-23, 5.12e-23, 9.88e-23, 1.53e-22, 1.23e-22, 7.94e-23, 5.73e-23, 4.62e-23, 3.98e-23, 3.58e-23, 3.29e-23, 3.08e-23, 2.91e-23, 2.78e-23, 2.65e-23, 2.55e-23, 2.47e-23, 2.39e-23, 2.31e-23, 2.23e-23, 2.16e-23, 2.11e-23, 2.06e-23, 2.01e-23, 1.96e-23, 1.91e-23, 1.86e-23, 1.81e-23, 1.76e-23, 1.71e-23, 1.66e-23, 1.63e-23, 1.63e-23]),
		ExplicitContinuum(j=39, i=8, wavelengthGrid=[9.91, 17.807, 24.785, 31.241, 37.331, 43.154, 48.759, 54.189, 59.466, 64.614, 69.651, 74.581, 79.424, 84.184, 88.865, 93.481, 98.033, 102.525, 106.961, 111.346, 115.685, 119.974, 124.225, 128.43, 132.598, 136.73, 140.828, 144.89, 148.92, 152.922, 156.891, 160.833, 164.752, 168.638, 172.501, 176.341, 180.158, 183.947, 187.718, 191.47, 195.2, 198.906, 202.598, 206.267, 209.918, 213.55, 217.168, 220.768, 224.349, 227.917, 231.465, 235.001, 238.522, 242.029, 245.518, 248.998, 252.459, 255.911, 259.349, 262.773, 266.183, 269.58, 272.967, 276.345, 279.709, 283.059, 286.4, 289.727, 293.05, 296.359, 299.653, 302.944, 306.22, 309.487, 312.745, 328.0026883100335], alphaGrid=[4.31e-24, 1.41e-23, 3.76e-23, 7.49e-23, 1.28e-22, 1.97e-22, 2.52e-22, 3.86e-22, 4.66e-22, 4.14e-22, 5.03e-22, 7.87e-22, 2.47e-22, 2.29e-22, 3.89e-21, 1.58e-22, 5.64e-22, 5.36e-22, 8.08e-23, 4.9e-23, 3.88e-23, 3.31e-23, 4.25e-23, 1.09e-21, 2.24e-21, 2.42e-22, 1.44e-22, 1.16e-22, 1.13e-22, 8.4e-23, 7.39e-23, 1.33e-22, 8.39e-23, 7.26e-23, 6.79e-23, 6.46e-23, 6.16e-23, 5.98e-23, 5.81e-23, 5.65e-23, 5.6e-23, 5.65e-23, 5.98e-23, 7.02e-23, 1.02e-22, 1.98e-22, 3.05e-22, 2.47e-22, 1.59e-22, 1.15e-22, 9.23e-23, 7.97e-23, 7.15e-23, 6.58e-23, 6.15e-23, 5.82e-23, 5.56e-23, 5.3e-23, 5.1e-23, 4.94e-23, 4.77e-23, 4.61e-23, 4.45e-23, 4.31e-23, 4.21e-23, 4.11e-23, 4.01e-23, 3.91e-23, 3.82e-23, 3.72e-23, 3.62e-23, 3.52e-23, 3.43e-23, 3.33e-23, 3.26e-23, 3.26e-23]),
		ExplicitContinuum(j=38, i=9, wavelengthGrid=[10.107, 18.122, 25.266, 31.911, 38.213, 44.247, 50.074, 55.731, 61.24, 66.618, 71.888, 77.06, 82.139, 87.14, 92.067, 96.921, 101.717, 106.453, 111.136, 115.765, 120.35, 124.886, 129.383, 133.835, 138.249, 142.628, 146.974, 151.284, 155.561, 159.808, 164.031, 168.22, 172.384, 176.519, 180.634, 184.719, 188.781, 192.823, 196.845, 200.842, 204.816, 208.774, 212.713, 216.633, 220.533, 224.413, 228.278, 232.124, 235.956, 239.768, 243.57, 247.352, 251.12, 254.873, 258.611, 262.335, 266.049, 269.748, 273.428, 277.102, 280.762, 284.408, 288.039, 291.664, 295.271, 298.872, 302.459, 306.036, 309.603, 313.155, 316.703, 320.236, 323.759, 327.272, 330.775, 346.7952907280292], alphaGrid=[2.67e-24, 8.73e-24, 2.33e-23, 4.68e-23, 8.01e-23, 1.25e-22, 1.75e-22, 2.27e-22, 2.3e-22, 2.27e-22, 1.12e-22, 1.18e-22, 9.78e-23, 1.98e-21, 5.36e-22, 9.99e-23, 6.7e-23, 1.03e-21, 5.75e-23, 5.81e-23, 7.03e-23, 1.32e-22, 7.87e-22, 1.12e-22, 3.37e-23, 2.88e-23, 2.86e-23, 2.88e-23, 2.93e-23, 2.98e-23, 3.03e-23, 3.08e-23, 3.13e-23, 3.18e-23, 3.23e-23, 3.28e-23, 3.33e-23, 3.38e-23, 3.43e-23, 3.47e-23, 3.52e-23, 3.57e-23, 3.62e-23, 3.67e-23, 3.72e-23, 3.77e-23, 3.82e-23, 3.87e-23, 3.92e-23, 3.97e-23, 4.02e-23, 4.08e-23, 4.14e-23, 4.21e-23, 4.27e-23, 4.34e-23, 4.4e-23, 4.47e-23, 4.53e-23, 4.6e-23, 4.69e-23, 4.77e-23, 4.86e-23, 4.94e-23, 5.03e-23, 5.11e-23, 5.2e-23, 5.29e-23, 5.39e-23, 5.5e-23, 5.61e-23, 5.72e-23, 5.83e-23, 5.93e-23, 6.01e-23, 6.01e-23]),
		ExplicitContinuum(j=39, i=9, wavelengthGrid=[10.107, 18.122, 25.266, 31.911, 38.213, 44.247, 50.074, 55.731, 61.24, 66.618, 71.888, 77.06, 82.139, 87.14, 92.067, 96.921, 101.717, 106.453, 111.136, 115.765, 120.35, 124.886, 129.383, 133.835, 138.249, 142.628, 146.974, 151.284, 155.561, 159.808, 164.031, 168.22, 172.384, 176.519, 180.634, 184.719, 188.781, 192.823, 196.845, 200.842, 204.816, 208.774, 212.713, 216.633, 220.533, 224.413, 228.278, 232.124, 235.956, 239.768, 243.57, 247.352, 251.12, 254.873, 258.611, 262.335, 266.049, 269.748, 273.428, 277.102, 280.762, 284.408, 288.039, 291.664, 295.271, 298.872, 302.459, 306.036, 309.603, 313.155, 316.703, 320.236, 323.759, 327.272, 330.775, 346.0342314363449], alphaGrid=[5.33e-24, 1.75e-23, 4.67e-23, 9.36e-23, 1.6e-22, 2.49e-22, 3.5e-22, 4.53e-22, 4.6e-22, 4.54e-22, 2.25e-22, 2.36e-22, 1.96e-22, 3.97e-21, 1.07e-21, 2e-22, 1.34e-22, 2.05e-21, 1.15e-22, 1.16e-22, 1.41e-22, 2.64e-22, 1.57e-21, 2.24e-22, 6.73e-23, 5.77e-23, 5.72e-23, 5.76e-23, 5.86e-23, 5.96e-23, 6.06e-23, 6.16e-23, 6.26e-23, 6.36e-23, 6.46e-23, 6.56e-23, 6.66e-23, 6.76e-23, 6.85e-23, 6.95e-23, 7.04e-23, 7.14e-23, 7.24e-23, 7.35e-23, 7.45e-23, 7.55e-23, 7.64e-23, 7.74e-23, 7.84e-23, 7.94e-23, 8.04e-23, 8.15e-23, 8.29e-23, 8.42e-23, 8.55e-23, 8.67e-23, 8.8e-23, 8.93e-23, 9.06e-23, 9.21e-23, 9.38e-23, 9.55e-23, 9.72e-23, 9.89e-23, 1.01e-22, 1.02e-22, 1.04e-22, 1.06e-22, 1.08e-22, 1.1e-22, 1.12e-22, 1.14e-22, 1.17e-22, 1.19e-22, 1.2e-22, 1.2e-22]),
		ExplicitContinuum(j=38, i=10, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 374.1065167297629], alphaGrid=[4.81e-24, 1.61e-23, 4.38e-23, 8.9e-23, 1.54e-22, 2.39e-22, 2.92e-22, 3.37e-22, 3.75e-22, 4.15e-22, 4.49e-22, 5.01e-22, 5.35e-22, 6.21e-22, 6.14e-22, 1.32e-21, 5.76e-22, 1.04e-21, 3.02e-22, 3.02e-22, 3.12e-22, 3.4e-22, 8.85e-22, 5.55e-22, 3.59e-22, 1.03e-22, 4.59e-23, 9.58e-23, 3.23e-23, 6.81e-23, 3.97e-22, 4.44e-23, 3.52e-23, 3.32e-23, 3.25e-23, 3.27e-23, 3.35e-23, 3.53e-23, 3.87e-23, 4.47e-23, 5.62e-23, 8.05e-23, 1.39e-22, 3e-22, 6.24e-22, 6.76e-22, 4.13e-22, 2.42e-22, 1.64e-22, 1.24e-22, 1.02e-22, 8.82e-23, 7.89e-23, 7.24e-23, 6.76e-23, 6.39e-23, 6.14e-23, 5.9e-23, 5.67e-23, 5.55e-23, 5.44e-23, 5.33e-23, 5.22e-23, 5.11e-23, 5.01e-23, 4.95e-23, 4.9e-23, 4.85e-23, 4.8e-23, 4.75e-23, 4.7e-23, 4.65e-23, 4.6e-23, 4.55e-23, 4.52e-23, 4.52e-23]),
		ExplicitContinuum(j=39, i=10, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 373.2210186881095], alphaGrid=[9.63e-24, 3.22e-23, 8.76e-23, 1.78e-22, 3.08e-22, 4.78e-22, 5.85e-22, 6.73e-22, 7.51e-22, 8.3e-22, 8.98e-22, 1e-21, 1.07e-21, 1.24e-21, 1.23e-21, 2.65e-21, 1.15e-21, 2.07e-21, 6.03e-22, 6.03e-22, 6.25e-22, 6.79e-22, 1.77e-21, 1.11e-21, 7.19e-22, 2.06e-22, 9.18e-23, 1.92e-22, 6.47e-23, 1.36e-22, 7.94e-22, 8.88e-23, 7.05e-23, 6.64e-23, 6.49e-23, 6.55e-23, 6.7e-23, 7.07e-23, 7.74e-23, 8.94e-23, 1.12e-22, 1.61e-22, 2.77e-22, 5.99e-22, 1.25e-21, 1.35e-21, 8.27e-22, 4.83e-22, 3.27e-22, 2.49e-22, 2.04e-22, 1.76e-22, 1.58e-22, 1.45e-22, 1.35e-22, 1.28e-22, 1.23e-22, 1.18e-22, 1.13e-22, 1.11e-22, 1.09e-22, 1.07e-22, 1.04e-22, 1.02e-22, 1e-22, 9.89e-23, 9.79e-23, 9.69e-23, 9.59e-23, 9.5e-23, 9.4e-23, 9.3e-23, 9.2e-23, 9.1e-23, 9.03e-23, 9.03e-23]),
		ExplicitContinuum(j=38, i=11, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 374.1475282411231], alphaGrid=[4.81e-24, 1.61e-23, 4.38e-23, 8.9e-23, 1.54e-22, 2.39e-22, 2.92e-22, 3.37e-22, 3.75e-22, 4.15e-22, 4.49e-22, 5.01e-22, 5.35e-22, 6.21e-22, 6.14e-22, 1.32e-21, 5.76e-22, 1.04e-21, 3.02e-22, 3.02e-22, 3.12e-22, 3.4e-22, 8.85e-22, 5.55e-22, 3.59e-22, 1.03e-22, 4.59e-23, 9.58e-23, 3.23e-23, 6.81e-23, 3.97e-22, 4.44e-23, 3.52e-23, 3.32e-23, 3.25e-23, 3.27e-23, 3.35e-23, 3.53e-23, 3.87e-23, 4.47e-23, 5.62e-23, 8.05e-23, 1.39e-22, 3e-22, 6.24e-22, 6.76e-22, 4.13e-22, 2.42e-22, 1.64e-22, 1.24e-22, 1.02e-22, 8.82e-23, 7.89e-23, 7.24e-23, 6.76e-23, 6.39e-23, 6.14e-23, 5.9e-23, 5.67e-23, 5.55e-23, 5.44e-23, 5.33e-23, 5.22e-23, 5.11e-23, 5.01e-23, 4.95e-23, 4.9e-23, 4.85e-23, 4.8e-23, 4.75e-23, 4.7e-23, 4.65e-23, 4.6e-23, 4.55e-23, 4.52e-23, 4.52e-23]),
		ExplicitContinuum(j=39, i=11, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 373.2618362728013], alphaGrid=[9.63e-24, 3.22e-23, 8.76e-23, 1.78e-22, 3.08e-22, 4.78e-22, 5.85e-22, 6.73e-22, 7.51e-22, 8.3e-22, 8.98e-22, 1e-21, 1.07e-21, 1.24e-21, 1.23e-21, 2.65e-21, 1.15e-21, 2.07e-21, 6.03e-22, 6.03e-22, 6.25e-22, 6.79e-22, 1.77e-21, 1.11e-21, 7.19e-22, 2.06e-22, 9.18e-23, 1.92e-22, 6.47e-23, 1.36e-22, 7.94e-22, 8.88e-23, 7.05e-23, 6.64e-23, 6.49e-23, 6.55e-23, 6.7e-23, 7.07e-23, 7.74e-23, 8.94e-23, 1.12e-22, 1.61e-22, 2.77e-22, 5.99e-22, 1.25e-21, 1.35e-21, 8.27e-22, 4.83e-22, 3.27e-22, 2.49e-22, 2.04e-22, 1.76e-22, 1.58e-22, 1.45e-22, 1.35e-22, 1.28e-22, 1.23e-22, 1.18e-22, 1.13e-22, 1.11e-22, 1.09e-22, 1.07e-22, 1.04e-22, 1.02e-22, 1e-22, 9.89e-23, 9.79e-23, 9.69e-23, 9.59e-23, 9.5e-23, 9.4e-23, 9.3e-23, 9.2e-23, 9.1e-23, 9.03e-23, 9.03e-23]),
		ExplicitContinuum(j=38, i=12, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 374.16292737591124], alphaGrid=[4.81e-24, 1.61e-23, 4.38e-23, 8.9e-23, 1.54e-22, 2.39e-22, 2.92e-22, 3.37e-22, 3.75e-22, 4.15e-22, 4.49e-22, 5.01e-22, 5.35e-22, 6.21e-22, 6.14e-22, 1.32e-21, 5.76e-22, 1.04e-21, 3.02e-22, 3.02e-22, 3.12e-22, 3.4e-22, 8.85e-22, 5.55e-22, 3.59e-22, 1.03e-22, 4.59e-23, 9.58e-23, 3.23e-23, 6.81e-23, 3.97e-22, 4.44e-23, 3.52e-23, 3.32e-23, 3.25e-23, 3.27e-23, 3.35e-23, 3.53e-23, 3.87e-23, 4.47e-23, 5.62e-23, 8.05e-23, 1.39e-22, 3e-22, 6.24e-22, 6.76e-22, 4.13e-22, 2.42e-22, 1.64e-22, 1.24e-22, 1.02e-22, 8.82e-23, 7.89e-23, 7.24e-23, 6.76e-23, 6.39e-23, 6.14e-23, 5.9e-23, 5.67e-23, 5.55e-23, 5.44e-23, 5.33e-23, 5.22e-23, 5.11e-23, 5.01e-23, 4.95e-23, 4.9e-23, 4.85e-23, 4.8e-23, 4.75e-23, 4.7e-23, 4.65e-23, 4.6e-23, 4.55e-23, 4.52e-23, 4.52e-23]),
		ExplicitContinuum(j=39, i=12, wavelengthGrid=[10.083, 18.258, 25.625, 32.514, 39.073, 45.38, 51.488, 57.432, 63.23, 68.908, 74.475, 79.947, 85.336, 90.641, 95.872, 101.04, 106.151, 111.199, 116.194, 121.142, 126.037, 130.891, 135.702, 140.477, 145.21, 149.911, 154.576, 159.204, 163.805, 168.375, 172.914, 177.427, 181.913, 186.373, 190.807, 195.219, 199.606, 203.971, 208.311, 212.634, 216.937, 221.218, 225.479, 229.718, 233.942, 238.15, 242.343, 246.514, 250.67, 254.81, 258.929, 263.037, 267.135, 271.212, 275.273, 279.324, 283.364, 287.383, 291.392, 295.39, 299.373, 303.345, 307.306, 311.252, 315.187, 319.112, 323.026, 326.925, 330.818, 334.696, 338.568, 342.424, 346.276, 350.111, 353.942, 373.2771625859074], alphaGrid=[9.63e-24, 3.22e-23, 8.76e-23, 1.78e-22, 3.08e-22, 4.78e-22, 5.85e-22, 6.73e-22, 7.51e-22, 8.3e-22, 8.98e-22, 1e-21, 1.07e-21, 1.24e-21, 1.23e-21, 2.65e-21, 1.15e-21, 2.07e-21, 6.03e-22, 6.03e-22, 6.25e-22, 6.79e-22, 1.77e-21, 1.11e-21, 7.19e-22, 2.06e-22, 9.18e-23, 1.92e-22, 6.47e-23, 1.36e-22, 7.94e-22, 8.88e-23, 7.05e-23, 6.64e-23, 6.49e-23, 6.55e-23, 6.7e-23, 7.07e-23, 7.74e-23, 8.94e-23, 1.12e-22, 1.61e-22, 2.77e-22, 5.99e-22, 1.25e-21, 1.35e-21, 8.27e-22, 4.83e-22, 3.27e-22, 2.49e-22, 2.04e-22, 1.76e-22, 1.58e-22, 1.45e-22, 1.35e-22, 1.28e-22, 1.23e-22, 1.18e-22, 1.13e-22, 1.11e-22, 1.09e-22, 1.07e-22, 1.04e-22, 1.02e-22, 1e-22, 9.89e-23, 9.79e-23, 9.69e-23, 9.59e-23, 9.5e-23, 9.4e-23, 9.3e-23, 9.2e-23, 9.1e-23, 9.03e-23, 9.03e-23]),
		ExplicitContinuum(j=38, i=13, wavelengthGrid=[9.984, 18.517, 26.453, 34.022, 41.327, 48.433, 55.378, 62.188, 68.882, 75.48, 81.982, 88.406, 94.753, 101.036, 107.261, 113.421, 119.537, 125.601, 131.62, 137.595, 143.524, 149.421, 155.279, 161.105, 166.893, 172.655, 178.384, 184.082, 189.754, 195.4, 201.021, 206.615, 212.191, 217.734, 223.264, 228.769, 234.254, 239.714, 245.161, 250.582, 255.99, 261.379, 266.749, 272.106, 277.443, 282.761, 288.067, 293.359, 298.632, 303.893, 309.14, 314.375, 319.59, 324.792, 329.988, 335.165, 340.329, 345.486, 350.624, 355.756, 360.875, 365.981, 371.074, 376.161, 381.235, 386.296, 391.35, 396.392, 401.427, 406.449, 411.459, 416.462, 421.452, 426.436, 431.413, 455.3538110495704], alphaGrid=[2.56e-24, 9.06e-24, 2.59e-23, 5.46e-23, 9.76e-23, 1.33e-22, 2.36e-22, 1.7e-22, 1.06e-22, 3.12e-22, 2.16e-22, 6.82e-22, 6.98e-23, 7.73e-22, 5.42e-23, 6.43e-23, 3.54e-23, 1.08e-21, 1.65e-22, 9.97e-23, 8.43e-23, 7.74e-23, 7.36e-23, 7.11e-23, 6.86e-23, 6.61e-23, 6.35e-23, 6.07e-23, 5.78e-23, 5.59e-23, 5.61e-23, 5.36e-23, 5.04e-23, 4.73e-23, 4.46e-23, 4.18e-23, 3.93e-23, 3.82e-23, 3.88e-23, 4.21e-23, 4.95e-23, 6.22e-23, 8.16e-23, 1.08e-22, 1.4e-22, 1.72e-22, 2.03e-22, 2.29e-22, 2.45e-22, 2.54e-22, 2.56e-22, 2.54e-22, 2.48e-22, 2.42e-22, 2.35e-22, 2.28e-22, 2.21e-22, 2.15e-22, 2.1e-22, 2.05e-22, 1.99e-22, 1.94e-22, 1.89e-22, 1.84e-22, 1.81e-22, 1.79e-22, 1.76e-22, 1.74e-22, 1.71e-22, 1.69e-22, 1.69e-22, 1.68e-22, 1.68e-22, 1.68e-22, 1.67e-22, 1.67e-22]),
		ExplicitContinuum(j=39, i=13, wavelengthGrid=[9.984, 18.517, 26.453, 34.022, 41.327, 48.433, 55.378, 62.188, 68.882, 75.48, 81.982, 88.406, 94.753, 101.036, 107.261, 113.421, 119.537, 125.601, 131.62, 137.595, 143.524, 149.421, 155.279, 161.105, 166.893, 172.655, 178.384, 184.082, 189.754, 195.4, 201.021, 206.615, 212.191, 217.734, 223.264, 228.769, 234.254, 239.714, 245.161, 250.582, 255.99, 261.379, 266.749, 272.106, 277.443, 282.761, 288.067, 293.359, 298.632, 303.893, 309.14, 314.375, 319.59, 324.792, 329.988, 335.165, 340.329, 345.486, 350.624, 355.756, 360.875, 365.981, 371.074, 376.161, 381.235, 386.296, 391.35, 396.392, 401.427, 406.449, 411.459, 416.462, 421.452, 426.436, 431.413, 454.0426023633375], alphaGrid=[5.12e-24, 1.81e-23, 5.17e-23, 1.09e-22, 1.95e-22, 2.67e-22, 4.73e-22, 3.41e-22, 2.12e-22, 6.24e-22, 4.32e-22, 1.36e-21, 1.4e-22, 1.55e-21, 1.08e-22, 1.29e-22, 7.07e-23, 2.17e-21, 3.31e-22, 1.99e-22, 1.69e-22, 1.55e-22, 1.47e-22, 1.42e-22, 1.37e-22, 1.32e-22, 1.27e-22, 1.21e-22, 1.16e-22, 1.12e-22, 1.12e-22, 1.07e-22, 1.01e-22, 9.47e-23, 8.91e-23, 8.36e-23, 7.85e-23, 7.64e-23, 7.76e-23, 8.42e-23, 9.9e-23, 1.24e-22, 1.63e-22, 2.16e-22, 2.79e-22, 3.44e-22, 4.06e-22, 4.58e-22, 4.91e-22, 5.08e-22, 5.12e-22, 5.08e-22, 4.97e-22, 4.83e-22, 4.69e-22, 4.56e-22, 4.42e-22, 4.3e-22, 4.2e-22, 4.09e-22, 3.98e-22, 3.88e-22, 3.77e-22, 3.68e-22, 3.62e-22, 3.57e-22, 3.52e-22, 3.47e-22, 3.42e-22, 3.39e-22, 3.38e-22, 3.37e-22, 3.36e-22, 3.35e-22, 3.34e-22, 3.34e-22]),
		ExplicitContinuum(j=38, i=14, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 473.31015849027324], alphaGrid=[2.22e-24, 7.51e-24, 2.1e-23, 4.41e-23, 7.86e-23, 1.22e-22, 2.01e-22, 1.68e-22, 2.05e-22, 2.03e-22, 4.33e-23, 1.83e-21, 5.68e-23, 6.7e-22, 6.77e-23, 5.48e-23, 6.57e-23, 2.86e-22, 7.72e-23, 5.9e-23, 5.97e-23, 6.1e-23, 6.25e-23, 6.42e-23, 6.61e-23, 6.72e-23, 6.96e-23, 7.09e-23, 7.19e-23, 7.21e-23, 7.2e-23, 7.2e-23, 7.46e-23, 7.93e-23, 7.82e-23, 7.78e-23, 7.74e-23, 7.7e-23, 7.66e-23, 7.62e-23, 7.57e-23, 7.51e-23, 7.46e-23, 7.4e-23, 7.34e-23, 7.29e-23, 7.23e-23, 7.18e-23, 7.12e-23, 7.06e-23, 7.01e-23, 6.95e-23, 6.9e-23, 6.86e-23, 6.85e-23, 6.83e-23, 6.82e-23, 6.8e-23, 6.79e-23, 6.78e-23, 6.77e-23, 6.82e-23, 6.88e-23, 6.95e-23, 7.02e-23, 7.08e-23, 7.2e-23, 7.34e-23, 7.48e-23, 7.66e-23, 7.87e-23, 8.09e-23, 8.31e-23, 8.58e-23, 8.79e-23, 8.79e-23]),
		ExplicitContinuum(j=39, i=14, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 471.8936597075722], alphaGrid=[4.45e-24, 1.5e-23, 4.21e-23, 8.82e-23, 1.57e-22, 2.44e-22, 4.03e-22, 3.35e-22, 4.09e-22, 4.06e-22, 8.66e-23, 3.65e-21, 1.14e-22, 1.34e-21, 1.35e-22, 1.1e-22, 1.31e-22, 5.71e-22, 1.54e-22, 1.18e-22, 1.19e-22, 1.22e-22, 1.25e-22, 1.28e-22, 1.32e-22, 1.34e-22, 1.39e-22, 1.42e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.49e-22, 1.59e-22, 1.56e-22, 1.56e-22, 1.55e-22, 1.54e-22, 1.53e-22, 1.52e-22, 1.51e-22, 1.5e-22, 1.49e-22, 1.48e-22, 1.47e-22, 1.46e-22, 1.45e-22, 1.44e-22, 1.42e-22, 1.41e-22, 1.4e-22, 1.39e-22, 1.38e-22, 1.37e-22, 1.37e-22, 1.37e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.35e-22, 1.36e-22, 1.38e-22, 1.39e-22, 1.4e-22, 1.42e-22, 1.44e-22, 1.47e-22, 1.5e-22, 1.53e-22, 1.57e-22, 1.62e-22, 1.66e-22, 1.72e-22, 1.76e-22, 1.76e-22]),
		ExplicitContinuum(j=38, i=15, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 473.7851142876298], alphaGrid=[2.22e-24, 7.51e-24, 2.1e-23, 4.41e-23, 7.86e-23, 1.22e-22, 2.01e-22, 1.68e-22, 2.05e-22, 2.03e-22, 4.33e-23, 1.83e-21, 5.68e-23, 6.7e-22, 6.77e-23, 5.48e-23, 6.57e-23, 2.86e-22, 7.72e-23, 5.9e-23, 5.97e-23, 6.1e-23, 6.25e-23, 6.42e-23, 6.61e-23, 6.72e-23, 6.96e-23, 7.09e-23, 7.19e-23, 7.21e-23, 7.2e-23, 7.2e-23, 7.46e-23, 7.93e-23, 7.82e-23, 7.78e-23, 7.74e-23, 7.7e-23, 7.66e-23, 7.62e-23, 7.57e-23, 7.51e-23, 7.46e-23, 7.4e-23, 7.34e-23, 7.29e-23, 7.23e-23, 7.18e-23, 7.12e-23, 7.06e-23, 7.01e-23, 6.95e-23, 6.9e-23, 6.86e-23, 6.85e-23, 6.83e-23, 6.82e-23, 6.8e-23, 6.79e-23, 6.78e-23, 6.77e-23, 6.82e-23, 6.88e-23, 6.95e-23, 7.02e-23, 7.08e-23, 7.2e-23, 7.34e-23, 7.48e-23, 7.66e-23, 7.87e-23, 8.09e-23, 8.31e-23, 8.58e-23, 8.79e-23, 8.79e-23]),
		ExplicitContinuum(j=39, i=15, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 472.3657754935219], alphaGrid=[4.45e-24, 1.5e-23, 4.21e-23, 8.82e-23, 1.57e-22, 2.44e-22, 4.03e-22, 3.35e-22, 4.09e-22, 4.06e-22, 8.66e-23, 3.65e-21, 1.14e-22, 1.34e-21, 1.35e-22, 1.1e-22, 1.31e-22, 5.71e-22, 1.54e-22, 1.18e-22, 1.19e-22, 1.22e-22, 1.25e-22, 1.28e-22, 1.32e-22, 1.34e-22, 1.39e-22, 1.42e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.49e-22, 1.59e-22, 1.56e-22, 1.56e-22, 1.55e-22, 1.54e-22, 1.53e-22, 1.52e-22, 1.51e-22, 1.5e-22, 1.49e-22, 1.48e-22, 1.47e-22, 1.46e-22, 1.45e-22, 1.44e-22, 1.42e-22, 1.41e-22, 1.4e-22, 1.39e-22, 1.38e-22, 1.37e-22, 1.37e-22, 1.37e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.35e-22, 1.36e-22, 1.38e-22, 1.39e-22, 1.4e-22, 1.42e-22, 1.44e-22, 1.47e-22, 1.5e-22, 1.53e-22, 1.57e-22, 1.62e-22, 1.66e-22, 1.72e-22, 1.76e-22, 1.76e-22]),
		ExplicitContinuum(j=38, i=16, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 474.5353646294152], alphaGrid=[2.22e-24, 7.51e-24, 2.1e-23, 4.41e-23, 7.86e-23, 1.22e-22, 2.01e-22, 1.68e-22, 2.05e-22, 2.03e-22, 4.33e-23, 1.83e-21, 5.68e-23, 6.7e-22, 6.77e-23, 5.48e-23, 6.57e-23, 2.86e-22, 7.72e-23, 5.9e-23, 5.97e-23, 6.1e-23, 6.25e-23, 6.42e-23, 6.61e-23, 6.72e-23, 6.96e-23, 7.09e-23, 7.19e-23, 7.21e-23, 7.2e-23, 7.2e-23, 7.46e-23, 7.93e-23, 7.82e-23, 7.78e-23, 7.74e-23, 7.7e-23, 7.66e-23, 7.62e-23, 7.57e-23, 7.51e-23, 7.46e-23, 7.4e-23, 7.34e-23, 7.29e-23, 7.23e-23, 7.18e-23, 7.12e-23, 7.06e-23, 7.01e-23, 6.95e-23, 6.9e-23, 6.86e-23, 6.85e-23, 6.83e-23, 6.82e-23, 6.8e-23, 6.79e-23, 6.78e-23, 6.77e-23, 6.82e-23, 6.88e-23, 6.95e-23, 7.02e-23, 7.08e-23, 7.2e-23, 7.34e-23, 7.48e-23, 7.66e-23, 7.87e-23, 8.09e-23, 8.31e-23, 8.58e-23, 8.79e-23, 8.79e-23]),
		ExplicitContinuum(j=39, i=16, wavelengthGrid=[10.586, 19.115, 27.114, 34.785, 42.221, 49.477, 56.585, 63.565, 70.446, 77.226, 83.918, 90.544, 97.096, 103.588, 110.026, 116.404, 122.735, 129.026, 135.269, 141.466, 147.637, 153.76, 159.856, 165.913, 171.942, 177.945, 183.914, 189.856, 195.779, 201.667, 207.536, 213.378, 219.2, 225.001, 230.783, 236.538, 242.279, 247.994, 253.695, 259.376, 265.044, 270.692, 276.319, 281.94, 287.534, 293.121, 298.688, 304.242, 309.783, 315.303, 320.817, 326.317, 331.804, 337.277, 342.73, 348.184, 353.617, 359.044, 364.45, 369.85, 375.243, 380.622, 385.989, 391.348, 396.694, 402.027, 407.353, 412.672, 417.978, 423.278, 428.563, 433.843, 439.115, 444.374, 449.626, 473.11153391511857], alphaGrid=[4.45e-24, 1.5e-23, 4.21e-23, 8.82e-23, 1.57e-22, 2.44e-22, 4.03e-22, 3.35e-22, 4.09e-22, 4.06e-22, 8.66e-23, 3.65e-21, 1.14e-22, 1.34e-21, 1.35e-22, 1.1e-22, 1.31e-22, 5.71e-22, 1.54e-22, 1.18e-22, 1.19e-22, 1.22e-22, 1.25e-22, 1.28e-22, 1.32e-22, 1.34e-22, 1.39e-22, 1.42e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.44e-22, 1.49e-22, 1.59e-22, 1.56e-22, 1.56e-22, 1.55e-22, 1.54e-22, 1.53e-22, 1.52e-22, 1.51e-22, 1.5e-22, 1.49e-22, 1.48e-22, 1.47e-22, 1.46e-22, 1.45e-22, 1.44e-22, 1.42e-22, 1.41e-22, 1.4e-22, 1.39e-22, 1.38e-22, 1.37e-22, 1.37e-22, 1.37e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.36e-22, 1.35e-22, 1.36e-22, 1.38e-22, 1.39e-22, 1.4e-22, 1.42e-22, 1.44e-22, 1.47e-22, 1.5e-22, 1.53e-22, 1.57e-22, 1.62e-22, 1.66e-22, 1.72e-22, 1.76e-22, 1.76e-22]),
		ExplicitContinuum(j=38, i=17, wavelengthGrid=[10.75, 19.322, 27.439, 35.281, 42.909, 50.382, 57.72, 64.952, 72.084, 79.138, 86.108, 93.02, 99.862, 106.654, 113.396, 120.089, 126.732, 133.34, 139.905, 146.435, 152.929, 159.388, 165.818, 172.22, 178.594, 184.939, 191.256, 197.552, 203.82, 210.066, 216.291, 222.494, 228.676, 234.838, 240.977, 247.103, 253.214, 259.297, 265.373, 271.428, 277.461, 283.488, 289.493, 295.484, 301.467, 307.43, 313.378, 319.313, 325.24, 331.145, 337.044, 342.929, 348.806, 354.662, 360.511, 366.353, 372.181, 377.995, 383.801, 389.594, 395.379, 401.157, 406.921, 412.671, 418.421, 424.157, 429.878, 435.6, 441.307, 447.007, 452.693, 458.379, 464.051, 469.716, 475.373, 498.1735711447905], alphaGrid=[2.63e-24, 8.86e-24, 2.49e-23, 5.25e-23, 9.41e-23, 1.32e-22, 2.16e-22, 1.97e-22, 2.27e-22, 3.67e-23, 1.45e-21, 4.29e-22, 8.25e-23, 5.61e-22, 4.82e-23, 6.08e-23, 5.7e-22, 3.71e-22, 7.15e-23, 5.45e-23, 5e-23, 4.84e-23, 4.74e-23, 4.74e-23, 4.86e-23, 4.6e-23, 5.1e-23, 4.91e-23, 4.66e-23, 4.24e-23, 2.38e-23, 7.15e-23, 6.01e-23, 5.52e-23, 5.28e-23, 5.08e-23, 4.96e-23, 4.86e-23, 4.75e-23, 4.65e-23, 4.54e-23, 4.43e-23, 4.33e-23, 4.23e-23, 4.12e-23, 4.02e-23, 3.91e-23, 3.81e-23, 3.71e-23, 3.61e-23, 3.57e-23, 3.55e-23, 3.52e-23, 3.49e-23, 3.49e-23, 3.52e-23, 3.56e-23, 3.6e-23, 3.66e-23, 3.76e-23, 3.87e-23, 4.01e-23, 4.16e-23, 4.36e-23, 4.57e-23, 4.79e-23, 5.07e-23, 5.36e-23, 5.66e-23, 6.03e-23, 6.42e-23, 6.82e-23, 7.23e-23, 7.72e-23, 8.09e-23, 8.09e-23]),
		ExplicitContinuum(j=39, i=17, wavelengthGrid=[10.75, 19.322, 27.439, 35.281, 42.909, 50.382, 57.72, 64.952, 72.084, 79.138, 86.108, 93.02, 99.862, 106.654, 113.396, 120.089, 126.732, 133.34, 139.905, 146.435, 152.929, 159.388, 165.818, 172.22, 178.594, 184.939, 191.256, 197.552, 203.82, 210.066, 216.291, 222.494, 228.676, 234.838, 240.977, 247.103, 253.214, 259.297, 265.373, 271.428, 277.461, 283.488, 289.493, 295.484, 301.467, 307.43, 313.378, 319.313, 325.24, 331.145, 337.044, 342.929, 348.806, 354.662, 360.511, 366.353, 372.181, 377.995, 383.801, 389.594, 395.379, 401.157, 406.921, 412.671, 418.421, 424.157, 429.878, 435.6, 441.307, 447.007, 452.693, 458.379, 464.051, 469.716, 475.373, 496.60459026520925], alphaGrid=[5.27e-24, 1.77e-23, 4.98e-23, 1.05e-22, 1.88e-22, 2.63e-22, 4.32e-22, 3.93e-22, 4.54e-22, 7.33e-23, 2.9e-21, 8.58e-22, 1.65e-22, 1.12e-21, 9.65e-23, 1.22e-22, 1.14e-21, 7.42e-22, 1.43e-22, 1.09e-22, 1e-22, 9.67e-23, 9.48e-23, 9.48e-23, 9.73e-23, 9.21e-23, 1.02e-22, 9.82e-23, 9.32e-23, 8.48e-23, 4.75e-23, 1.43e-22, 1.2e-22, 1.1e-22, 1.06e-22, 1.02e-22, 9.93e-23, 9.71e-23, 9.5e-23, 9.29e-23, 9.08e-23, 8.87e-23, 8.66e-23, 8.45e-23, 8.24e-23, 8.03e-23, 7.83e-23, 7.62e-23, 7.41e-23, 7.22e-23, 7.15e-23, 7.09e-23, 7.04e-23, 6.98e-23, 6.98e-23, 7.05e-23, 7.12e-23, 7.2e-23, 7.33e-23, 7.52e-23, 7.74e-23, 8.03e-23, 8.33e-23, 8.72e-23, 9.14e-23, 9.58e-23, 1.01e-22, 1.07e-22, 1.13e-22, 1.21e-22, 1.28e-22, 1.36e-22, 1.45e-22, 1.54e-22, 1.62e-22, 1.62e-22]),
		ExplicitContinuum(j=38, i=18, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 513.748817414441], alphaGrid=[2.39e-24, 8.35e-24, 2.4e-23, 5.15e-23, 8.62e-23, 1.35e-22, 1.89e-22, 2.38e-22, 1.66e-22, 5.6e-23, 1.44e-21, 2.85e-22, 2.66e-22, 3.42e-22, 5.08e-23, 6.05e-23, 3.39e-22, 5.37e-22, 1.09e-22, 9.09e-23, 8.91e-23, 8.97e-23, 8.81e-23, 1e-22, 6.85e-23, 1.6e-22, 9.03e-23, 8.4e-23, 7.89e-23, 7.39e-23, 1.55e-22, 2.03e-22, 2.84e-22, 1.49e-22, 1.32e-22, 1.25e-22, 1.22e-22, 1.19e-22, 1.19e-22, 1.18e-22, 1.17e-22, 1.17e-22, 1.16e-22, 1.16e-22, 1.15e-22, 1.14e-22, 1.14e-22, 1.13e-22, 1.13e-22, 1.12e-22, 1.11e-22, 1.11e-22, 1.1e-22, 1.1e-22, 1.09e-22, 1.09e-22, 1.08e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.07e-22, 1.07e-22, 1.08e-22, 1.09e-22, 1.1e-22, 1.1e-22, 1.1e-22]),
		ExplicitContinuum(j=39, i=18, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 512.0803597466943], alphaGrid=[4.79e-24, 1.67e-23, 4.81e-23, 1.03e-22, 1.72e-22, 2.71e-22, 3.79e-22, 4.77e-22, 3.31e-22, 1.12e-22, 2.89e-21, 5.69e-22, 5.32e-22, 6.83e-22, 1.02e-22, 1.21e-22, 6.78e-22, 1.07e-21, 2.18e-22, 1.82e-22, 1.78e-22, 1.79e-22, 1.76e-22, 2.01e-22, 1.37e-22, 3.2e-22, 1.81e-22, 1.68e-22, 1.58e-22, 1.48e-22, 3.1e-22, 4.05e-22, 5.68e-22, 2.99e-22, 2.65e-22, 2.51e-22, 2.44e-22, 2.39e-22, 2.37e-22, 2.36e-22, 2.35e-22, 2.33e-22, 2.32e-22, 2.31e-22, 2.3e-22, 2.29e-22, 2.28e-22, 2.26e-22, 2.25e-22, 2.24e-22, 2.23e-22, 2.22e-22, 2.21e-22, 2.19e-22, 2.18e-22, 2.17e-22, 2.16e-22, 2.15e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.12e-22, 2.12e-22, 2.12e-22, 2.13e-22, 2.15e-22, 2.16e-22, 2.18e-22, 2.19e-22, 2.2e-22, 2.2e-22]),
		ExplicitContinuum(j=38, i=19, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 514.0760446989123], alphaGrid=[2.39e-24, 8.35e-24, 2.4e-23, 5.15e-23, 8.62e-23, 1.35e-22, 1.89e-22, 2.38e-22, 1.66e-22, 5.6e-23, 1.44e-21, 2.85e-22, 2.66e-22, 3.42e-22, 5.08e-23, 6.05e-23, 3.39e-22, 5.37e-22, 1.09e-22, 9.09e-23, 8.91e-23, 8.97e-23, 8.81e-23, 1e-22, 6.85e-23, 1.6e-22, 9.03e-23, 8.4e-23, 7.89e-23, 7.39e-23, 1.55e-22, 2.03e-22, 2.84e-22, 1.49e-22, 1.32e-22, 1.25e-22, 1.22e-22, 1.19e-22, 1.19e-22, 1.18e-22, 1.17e-22, 1.17e-22, 1.16e-22, 1.16e-22, 1.15e-22, 1.14e-22, 1.14e-22, 1.13e-22, 1.13e-22, 1.12e-22, 1.11e-22, 1.11e-22, 1.1e-22, 1.1e-22, 1.09e-22, 1.09e-22, 1.08e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.07e-22, 1.07e-22, 1.08e-22, 1.09e-22, 1.1e-22, 1.1e-22, 1.1e-22]),
		ExplicitContinuum(j=39, i=19, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 512.4054643943535], alphaGrid=[4.79e-24, 1.67e-23, 4.81e-23, 1.03e-22, 1.72e-22, 2.71e-22, 3.79e-22, 4.77e-22, 3.31e-22, 1.12e-22, 2.89e-21, 5.69e-22, 5.32e-22, 6.83e-22, 1.02e-22, 1.21e-22, 6.78e-22, 1.07e-21, 2.18e-22, 1.82e-22, 1.78e-22, 1.79e-22, 1.76e-22, 2.01e-22, 1.37e-22, 3.2e-22, 1.81e-22, 1.68e-22, 1.58e-22, 1.48e-22, 3.1e-22, 4.05e-22, 5.68e-22, 2.99e-22, 2.65e-22, 2.51e-22, 2.44e-22, 2.39e-22, 2.37e-22, 2.36e-22, 2.35e-22, 2.33e-22, 2.32e-22, 2.31e-22, 2.3e-22, 2.29e-22, 2.28e-22, 2.26e-22, 2.25e-22, 2.24e-22, 2.23e-22, 2.22e-22, 2.21e-22, 2.19e-22, 2.18e-22, 2.17e-22, 2.16e-22, 2.15e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.12e-22, 2.12e-22, 2.12e-22, 2.13e-22, 2.15e-22, 2.16e-22, 2.18e-22, 2.19e-22, 2.2e-22, 2.2e-22]),
		ExplicitContinuum(j=38, i=20, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 514.6178486452302], alphaGrid=[2.39e-24, 8.35e-24, 2.4e-23, 5.15e-23, 8.62e-23, 1.35e-22, 1.89e-22, 2.38e-22, 1.66e-22, 5.6e-23, 1.44e-21, 2.85e-22, 2.66e-22, 3.42e-22, 5.08e-23, 6.05e-23, 3.39e-22, 5.37e-22, 1.09e-22, 9.09e-23, 8.91e-23, 8.97e-23, 8.81e-23, 1e-22, 6.85e-23, 1.6e-22, 9.03e-23, 8.4e-23, 7.89e-23, 7.39e-23, 1.55e-22, 2.03e-22, 2.84e-22, 1.49e-22, 1.32e-22, 1.25e-22, 1.22e-22, 1.19e-22, 1.19e-22, 1.18e-22, 1.17e-22, 1.17e-22, 1.16e-22, 1.16e-22, 1.15e-22, 1.14e-22, 1.14e-22, 1.13e-22, 1.13e-22, 1.12e-22, 1.11e-22, 1.11e-22, 1.1e-22, 1.1e-22, 1.09e-22, 1.09e-22, 1.08e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.07e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.06e-22, 1.07e-22, 1.07e-22, 1.08e-22, 1.09e-22, 1.1e-22, 1.1e-22, 1.1e-22]),
		ExplicitContinuum(j=39, i=20, wavelengthGrid=[10.385, 19.011, 27.239, 35.201, 42.978, 50.615, 58.133, 65.541, 72.868, 80.121, 87.3, 94.427, 101.487, 108.504, 115.469, 122.389, 129.272, 136.119, 142.929, 149.701, 156.444, 163.151, 169.835, 176.489, 183.122, 189.724, 196.305, 202.864, 209.4, 215.914, 222.406, 228.876, 235.331, 241.771, 248.19, 254.586, 260.974, 267.341, 273.692, 280.029, 286.344, 292.651, 298.944, 305.222, 311.492, 317.741, 323.981, 330.208, 336.419, 342.623, 348.812, 354.994, 361.161, 367.321, 373.466, 379.603, 385.726, 391.841, 397.942, 404.042, 410.128, 416.199, 422.27, 428.327, 434.375, 440.417, 446.444, 452.47, 458.482, 464.487, 470.484, 476.474, 482.456, 488.431, 494.399, 512.9437508447544], alphaGrid=[4.79e-24, 1.67e-23, 4.81e-23, 1.03e-22, 1.72e-22, 2.71e-22, 3.79e-22, 4.77e-22, 3.31e-22, 1.12e-22, 2.89e-21, 5.69e-22, 5.32e-22, 6.83e-22, 1.02e-22, 1.21e-22, 6.78e-22, 1.07e-21, 2.18e-22, 1.82e-22, 1.78e-22, 1.79e-22, 1.76e-22, 2.01e-22, 1.37e-22, 3.2e-22, 1.81e-22, 1.68e-22, 1.58e-22, 1.48e-22, 3.1e-22, 4.05e-22, 5.68e-22, 2.99e-22, 2.65e-22, 2.51e-22, 2.44e-22, 2.39e-22, 2.37e-22, 2.36e-22, 2.35e-22, 2.33e-22, 2.32e-22, 2.31e-22, 2.3e-22, 2.29e-22, 2.28e-22, 2.26e-22, 2.25e-22, 2.24e-22, 2.23e-22, 2.22e-22, 2.21e-22, 2.19e-22, 2.18e-22, 2.17e-22, 2.16e-22, 2.15e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.14e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.13e-22, 2.12e-22, 2.12e-22, 2.12e-22, 2.13e-22, 2.15e-22, 2.16e-22, 2.18e-22, 2.19e-22, 2.2e-22, 2.2e-22]),
		ExplicitContinuum(j=38, i=21, wavelengthGrid=[10.604, 19.252, 27.612, 35.788, 43.82, 51.749, 59.589, 67.357, 75.053, 82.693, 90.277, 97.821, 105.318, 112.774, 120.198, 127.582, 134.942, 142.27, 149.566, 156.839, 164.087, 171.311, 178.519, 185.695, 192.855, 199.999, 207.12, 214.224, 221.312, 228.376, 235.432, 242.472, 249.488, 256.497, 263.497, 270.473, 277.441, 284.393, 291.337, 298.265, 305.186, 312.09, 318.986, 325.866, 332.738, 339.602, 346.45, 353.299, 360.131, 366.947, 373.763, 380.571, 387.363, 394.147, 400.923, 407.7, 414.46, 421.212, 427.956, 434.692, 441.42, 448.14, 454.853, 461.565, 468.261, 474.957, 481.637, 488.317, 494.989, 501.653, 508.318, 514.966, 521.614, 528.254, 534.886, 549.2527279323301], alphaGrid=[2e-24, 6.9e-24, 1.99e-23, 4.3e-23, 7.83e-23, 1.36e-22, 1.66e-22, 1.3e-22, 1.11e-22, 1.33e-22, 1.53e-21, 1.07e-22, 4.34e-22, 4.8e-23, 4.82e-23, 8e-23, 1.02e-21, 9.49e-23, 7.54e-23, 7.45e-23, 7.6e-23, 7.85e-23, 8.12e-23, 8.38e-23, 8.64e-23, 8.9e-23, 8.97e-23, 8.91e-23, 9.71e-23, 1.03e-22, 1.05e-22, 1.06e-22, 1.07e-22, 1.09e-22, 1.1e-22, 1.09e-22, 1.09e-22, 1.08e-22, 1.08e-22, 1.08e-22, 1.08e-22, 1.09e-22, 1.12e-22, 1.16e-22, 1.21e-22, 1.27e-22, 1.33e-22, 1.39e-22, 1.45e-22, 1.51e-22, 1.54e-22, 1.57e-22, 1.6e-22, 1.62e-22, 1.65e-22, 1.66e-22, 1.67e-22, 1.68e-22, 1.68e-22, 1.69e-22, 1.7e-22, 1.71e-22, 1.71e-22, 1.71e-22, 1.7e-22, 1.7e-22, 1.7e-22, 1.7e-22, 1.7e-22, 1.69e-22, 1.69e-22, 1.69e-22, 1.69e-22, 1.69e-22, 1.68e-22, 1.68e-22]),
		ExplicitContinuum(j=39, i=21, wavelengthGrid=[10.604, 19.252, 27.612, 35.788, 43.82, 51.749, 59.589, 67.357, 75.053, 82.693, 90.277, 97.821, 105.318, 112.774, 120.198, 127.582, 134.942, 142.27, 149.566, 156.839, 164.087, 171.311, 178.519, 185.695, 192.855, 199.999, 207.12, 214.224, 221.312, 228.376, 235.432, 242.472, 249.488, 256.497, 263.497, 270.473, 277.441, 284.393, 291.337, 298.265, 305.186, 312.09, 318.986, 325.866, 332.738, 339.602, 346.45, 353.299, 360.131, 366.947, 373.763, 380.571, 387.363, 394.147, 400.923, 407.7, 414.46, 421.212, 427.956, 434.692, 441.42, 448.14, 454.853, 461.565, 468.261, 474.957, 481.637, 488.317, 494.989, 501.653, 508.318, 514.966, 521.614, 528.254, 534.886, 547.3461239000054], alphaGrid=[4e-24, 1.38e-23, 3.98e-23, 8.6e-23, 1.57e-22, 2.71e-22, 3.32e-22, 2.6e-22, 2.21e-22, 2.65e-22, 3.07e-21, 2.14e-22, 8.69e-22, 9.6e-23, 9.64e-23, 1.6e-22, 2.05e-21, 1.9e-22, 1.51e-22, 1.49e-22, 1.52e-22, 1.57e-22, 1.62e-22, 1.68e-22, 1.73e-22, 1.78e-22, 1.79e-22, 1.78e-22, 1.94e-22, 2.06e-22, 2.09e-22, 2.12e-22, 2.15e-22, 2.18e-22, 2.2e-22, 2.19e-22, 2.18e-22, 2.17e-22, 2.16e-22, 2.15e-22, 2.16e-22, 2.18e-22, 2.23e-22, 2.31e-22, 2.42e-22, 2.54e-22, 2.66e-22, 2.78e-22, 2.9e-22, 3.02e-22, 3.09e-22, 3.14e-22, 3.19e-22, 3.24e-22, 3.29e-22, 3.32e-22, 3.34e-22, 3.35e-22, 3.37e-22, 3.38e-22, 3.4e-22, 3.41e-22, 3.42e-22, 3.41e-22, 3.41e-22, 3.41e-22, 3.4e-22, 3.4e-22, 3.39e-22, 3.39e-22, 3.38e-22, 3.38e-22, 3.38e-22, 3.37e-22, 3.37e-22, 3.37e-22]),
		ExplicitContinuum(j=38, i=22, wavelengthGrid=[10.867, 19.502, 28.005, 36.41, 44.754, 53.035, 61.281, 69.482, 77.657, 85.797, 93.91, 101.996, 110.065, 118.107, 126.132, 134.147, 142.136, 150.116, 158.079, 166.024, 173.959, 181.886, 189.796, 197.696, 205.579, 213.462, 221.327, 229.183, 237.03, 244.869, 252.707, 260.528, 268.34, 276.143, 283.946, 291.74, 299.516, 307.293, 315.069, 322.828, 330.587, 338.336, 346.077, 353.818, 361.551, 369.283, 376.997, 384.712, 392.426, 400.132, 407.828, 415.525, 423.213, 430.901, 438.58, 446.259, 453.929, 461.59, 469.252, 476.913, 484.565, 492.218, 499.862, 507.505, 515.14, 522.775, 530.4, 538.026, 545.643, 553.269, 560.877, 568.494, 576.094, 583.702, 591.301, 593.7760983150715], alphaGrid=[1.67e-24, 5.67e-24, 1.64e-23, 3.57e-23, 6.6e-23, 1.42e-22, 1.35e-22, 7.03e-23, 9.42e-23, 7.57e-22, 7.95e-22, 4.11e-22, 1.55e-22, 7.02e-23, 8.73e-23, 8.79e-22, 3.6e-23, 4.94e-23, 5.71e-23, 6.3e-23, 6.76e-23, 7.22e-23, 7.67e-23, 7.99e-23, 8e-23, 7.17e-23, 3.87e-23, 6.22e-23, 1.05e-22, 1.17e-22, 1.22e-22, 1.26e-22, 1.31e-22, 1.36e-22, 1.39e-22, 1.42e-22, 1.45e-22, 1.48e-22, 1.51e-22, 1.54e-22, 1.57e-22, 1.6e-22, 1.63e-22, 1.66e-22, 1.68e-22, 1.71e-22, 1.74e-22, 1.77e-22, 1.8e-22, 1.83e-22, 1.86e-22, 1.89e-22, 1.92e-22, 1.94e-22, 1.96e-22, 1.97e-22, 1.98e-22, 1.99e-22, 2e-22, 2.01e-22, 2.02e-22, 2.02e-22, 2.03e-22, 2.04e-22, 2.05e-22, 2.04e-22, 2.04e-22, 2.03e-22, 2.03e-22, 2.02e-22, 2.02e-22, 2.01e-22, 2.01e-22, 2e-22, 2e-22, 2e-22]),
		ExplicitContinuum(j=39, i=22, wavelengthGrid=[10.867, 19.502, 28.005, 36.41, 44.754, 53.035, 61.281, 69.482, 77.657, 85.797, 93.91, 101.996, 110.065, 118.107, 126.132, 134.147, 142.136, 150.116, 158.079, 166.024, 173.959, 181.886, 189.796, 197.696, 205.579, 213.462, 221.327, 229.183, 237.03, 244.869, 252.707, 260.528, 268.34, 276.143, 283.946, 291.74, 299.516, 307.293, 315.069, 322.828, 330.587, 338.336, 346.077, 353.818, 361.551, 369.283, 376.997, 384.712, 392.426, 400.132, 407.828, 415.525, 423.213, 430.901, 438.58, 446.259, 453.929, 461.59, 469.252, 476.913, 484.565, 492.218, 499.862, 507.505, 515.14, 522.775, 530.4, 538.026, 545.643, 553.269, 560.877, 568.494, 576.094, 583.702, 591.301, 591.5484876027705], alphaGrid=[3.33e-24, 1.13e-23, 3.28e-23, 7.14e-23, 1.32e-22, 2.84e-22, 2.71e-22, 1.41e-22, 1.88e-22, 1.51e-21, 1.59e-21, 8.21e-22, 3.1e-22, 1.4e-22, 1.75e-22, 1.76e-21, 7.21e-23, 9.88e-23, 1.14e-22, 1.26e-22, 1.35e-22, 1.44e-22, 1.53e-22, 1.6e-22, 1.6e-22, 1.43e-22, 7.74e-23, 1.24e-22, 2.11e-22, 2.33e-22, 2.43e-22, 2.53e-22, 2.63e-22, 2.72e-22, 2.79e-22, 2.84e-22, 2.9e-22, 2.96e-22, 3.02e-22, 3.08e-22, 3.14e-22, 3.19e-22, 3.25e-22, 3.31e-22, 3.37e-22, 3.43e-22, 3.48e-22, 3.54e-22, 3.6e-22, 3.66e-22, 3.72e-22, 3.77e-22, 3.83e-22, 3.89e-22, 3.93e-22, 3.95e-22, 3.96e-22, 3.98e-22, 4e-22, 4.01e-22, 4.03e-22, 4.05e-22, 4.06e-22, 4.08e-22, 4.09e-22, 4.09e-22, 4.08e-22, 4.07e-22, 4.06e-22, 4.05e-22, 4.04e-22, 4.03e-22, 4.01e-22, 4e-22, 4e-22, 4e-22]),
		ExplicitContinuum(j=38, i=23, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 642.5370446701393], alphaGrid=[4.16e-24, 1.44e-23, 4.21e-23, 9.28e-23, 1.73e-22, 2.5e-22, 2.98e-22, 3.42e-22, 3.91e-22, 6.03e-22, 4.21e-22, 4.72e-22, 5.53e-22, 6.57e-22, 5.44e-22, 1.75e-22, 2.02e-22, 2.4e-22, 3.77e-22, 3.13e-22, 1.3e-22, 6.23e-23, 1.06e-22, 4e-23, 8.11e-23, 3.24e-22, 4.46e-23, 4.78e-23, 5.24e-23, 5.76e-23, 6.37e-23, 7.12e-23, 8.08e-23, 9.4e-23, 1.13e-22, 1.47e-22, 2.12e-22, 3.59e-22, 6.06e-22, 5.82e-22, 3.29e-22, 1.9e-22, 1.37e-22, 1.15e-22, 1.06e-22, 1.02e-22, 1.02e-22, 1.03e-22, 1.05e-22, 1.08e-22, 1.11e-22, 1.14e-22, 1.18e-22, 1.22e-22, 1.25e-22, 1.29e-22, 1.34e-22, 1.38e-22, 1.43e-22, 1.47e-22, 1.52e-22, 1.56e-22, 1.61e-22, 1.66e-22, 1.71e-22, 1.76e-22, 1.81e-22, 1.86e-22, 1.92e-22, 1.97e-22, 2.02e-22, 2.08e-22, 2.13e-22, 2.19e-22, 2.23e-22, 2.23e-22]),
		ExplicitContinuum(j=39, i=23, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 639.9293517995613], alphaGrid=[8.32e-24, 2.88e-23, 8.43e-23, 1.86e-22, 3.46e-22, 4.99e-22, 5.96e-22, 6.84e-22, 7.82e-22, 1.21e-21, 8.41e-22, 9.43e-22, 1.11e-21, 1.31e-21, 1.09e-21, 3.5e-22, 4.04e-22, 4.8e-22, 7.55e-22, 6.26e-22, 2.6e-22, 1.25e-22, 2.12e-22, 8.01e-23, 1.62e-22, 6.48e-22, 8.92e-23, 9.56e-23, 1.05e-22, 1.15e-22, 1.27e-22, 1.42e-22, 1.62e-22, 1.88e-22, 2.27e-22, 2.93e-22, 4.23e-22, 7.19e-22, 1.21e-21, 1.16e-21, 6.59e-22, 3.81e-22, 2.74e-22, 2.3e-22, 2.12e-22, 2.05e-22, 2.04e-22, 2.05e-22, 2.09e-22, 2.15e-22, 2.21e-22, 2.28e-22, 2.35e-22, 2.43e-22, 2.51e-22, 2.59e-22, 2.67e-22, 2.76e-22, 2.85e-22, 2.94e-22, 3.03e-22, 3.13e-22, 3.23e-22, 3.33e-22, 3.43e-22, 3.53e-22, 3.63e-22, 3.73e-22, 3.83e-22, 3.94e-22, 4.05e-22, 4.15e-22, 4.26e-22, 4.37e-22, 4.45e-22, 4.45e-22]),
		ExplicitContinuum(j=38, i=24, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 642.5907201546337], alphaGrid=[4.16e-24, 1.44e-23, 4.21e-23, 9.28e-23, 1.73e-22, 2.5e-22, 2.98e-22, 3.42e-22, 3.91e-22, 6.03e-22, 4.21e-22, 4.72e-22, 5.53e-22, 6.57e-22, 5.44e-22, 1.75e-22, 2.02e-22, 2.4e-22, 3.77e-22, 3.13e-22, 1.3e-22, 6.23e-23, 1.06e-22, 4e-23, 8.11e-23, 3.24e-22, 4.46e-23, 4.78e-23, 5.24e-23, 5.76e-23, 6.37e-23, 7.12e-23, 8.08e-23, 9.4e-23, 1.13e-22, 1.47e-22, 2.12e-22, 3.59e-22, 6.06e-22, 5.82e-22, 3.29e-22, 1.9e-22, 1.37e-22, 1.15e-22, 1.06e-22, 1.02e-22, 1.02e-22, 1.03e-22, 1.05e-22, 1.08e-22, 1.11e-22, 1.14e-22, 1.18e-22, 1.22e-22, 1.25e-22, 1.29e-22, 1.34e-22, 1.38e-22, 1.43e-22, 1.47e-22, 1.52e-22, 1.56e-22, 1.61e-22, 1.66e-22, 1.71e-22, 1.76e-22, 1.81e-22, 1.86e-22, 1.92e-22, 1.97e-22, 2.02e-22, 2.08e-22, 2.13e-22, 2.19e-22, 2.23e-22, 2.23e-22]),
		ExplicitContinuum(j=39, i=24, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 639.9825924734852], alphaGrid=[8.32e-24, 2.88e-23, 8.43e-23, 1.86e-22, 3.46e-22, 4.99e-22, 5.96e-22, 6.84e-22, 7.82e-22, 1.21e-21, 8.41e-22, 9.43e-22, 1.11e-21, 1.31e-21, 1.09e-21, 3.5e-22, 4.04e-22, 4.8e-22, 7.55e-22, 6.26e-22, 2.6e-22, 1.25e-22, 2.12e-22, 8.01e-23, 1.62e-22, 6.48e-22, 8.92e-23, 9.56e-23, 1.05e-22, 1.15e-22, 1.27e-22, 1.42e-22, 1.62e-22, 1.88e-22, 2.27e-22, 2.93e-22, 4.23e-22, 7.19e-22, 1.21e-21, 1.16e-21, 6.59e-22, 3.81e-22, 2.74e-22, 2.3e-22, 2.12e-22, 2.05e-22, 2.04e-22, 2.05e-22, 2.09e-22, 2.15e-22, 2.21e-22, 2.28e-22, 2.35e-22, 2.43e-22, 2.51e-22, 2.59e-22, 2.67e-22, 2.76e-22, 2.85e-22, 2.94e-22, 3.03e-22, 3.13e-22, 3.23e-22, 3.33e-22, 3.43e-22, 3.53e-22, 3.63e-22, 3.73e-22, 3.83e-22, 3.94e-22, 4.05e-22, 4.15e-22, 4.26e-22, 4.37e-22, 4.45e-22, 4.45e-22]),
		ExplicitContinuum(j=38, i=25, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 642.6258205126804], alphaGrid=[4.16e-24, 1.44e-23, 4.21e-23, 9.28e-23, 1.73e-22, 2.5e-22, 2.98e-22, 3.42e-22, 3.91e-22, 6.03e-22, 4.21e-22, 4.72e-22, 5.53e-22, 6.57e-22, 5.44e-22, 1.75e-22, 2.02e-22, 2.4e-22, 3.77e-22, 3.13e-22, 1.3e-22, 6.23e-23, 1.06e-22, 4e-23, 8.11e-23, 3.24e-22, 4.46e-23, 4.78e-23, 5.24e-23, 5.76e-23, 6.37e-23, 7.12e-23, 8.08e-23, 9.4e-23, 1.13e-22, 1.47e-22, 2.12e-22, 3.59e-22, 6.06e-22, 5.82e-22, 3.29e-22, 1.9e-22, 1.37e-22, 1.15e-22, 1.06e-22, 1.02e-22, 1.02e-22, 1.03e-22, 1.05e-22, 1.08e-22, 1.11e-22, 1.14e-22, 1.18e-22, 1.22e-22, 1.25e-22, 1.29e-22, 1.34e-22, 1.38e-22, 1.43e-22, 1.47e-22, 1.52e-22, 1.56e-22, 1.61e-22, 1.66e-22, 1.71e-22, 1.76e-22, 1.81e-22, 1.86e-22, 1.92e-22, 1.97e-22, 2.02e-22, 2.08e-22, 2.13e-22, 2.19e-22, 2.23e-22, 2.23e-22]),
		ExplicitContinuum(j=39, i=25, wavelengthGrid=[10.687, 19.311, 27.862, 36.357, 44.814, 53.245, 61.656, 70.031, 78.397, 86.744, 95.082, 103.401, 111.702, 119.994, 128.276, 136.55, 144.814, 153.069, 161.314, 169.55, 177.787, 186.005, 194.223, 202.431, 210.64, 218.839, 227.029, 235.21, 243.391, 251.572, 259.744, 267.906, 276.069, 284.222, 292.375, 300.528, 308.672, 316.807, 324.942, 333.077, 341.202, 349.328, 357.444, 365.56, 373.677, 381.793, 389.9, 397.998, 406.105, 414.203, 422.291, 430.389, 438.478, 446.557, 454.645, 462.725, 470.804, 478.874, 486.954, 495.024, 503.094, 511.155, 519.216, 527.277, 535.338, 543.389, 551.45, 559.502, 567.544, 575.596, 583.638, 591.681, 599.723, 607.765, 615.799, 640.0174084735104], alphaGrid=[8.32e-24, 2.88e-23, 8.43e-23, 1.86e-22, 3.46e-22, 4.99e-22, 5.96e-22, 6.84e-22, 7.82e-22, 1.21e-21, 8.41e-22, 9.43e-22, 1.11e-21, 1.31e-21, 1.09e-21, 3.5e-22, 4.04e-22, 4.8e-22, 7.55e-22, 6.26e-22, 2.6e-22, 1.25e-22, 2.12e-22, 8.01e-23, 1.62e-22, 6.48e-22, 8.92e-23, 9.56e-23, 1.05e-22, 1.15e-22, 1.27e-22, 1.42e-22, 1.62e-22, 1.88e-22, 2.27e-22, 2.93e-22, 4.23e-22, 7.19e-22, 1.21e-21, 1.16e-21, 6.59e-22, 3.81e-22, 2.74e-22, 2.3e-22, 2.12e-22, 2.05e-22, 2.04e-22, 2.05e-22, 2.09e-22, 2.15e-22, 2.21e-22, 2.28e-22, 2.35e-22, 2.43e-22, 2.51e-22, 2.59e-22, 2.67e-22, 2.76e-22, 2.85e-22, 2.94e-22, 3.03e-22, 3.13e-22, 3.23e-22, 3.33e-22, 3.43e-22, 3.53e-22, 3.63e-22, 3.73e-22, 3.83e-22, 3.94e-22, 4.05e-22, 4.15e-22, 4.26e-22, 4.37e-22, 4.45e-22, 4.45e-22]),
		ExplicitContinuum(j=38, i=26, wavelengthGrid=[11.169, 19.535, 28.157, 36.989, 45.961, 55.072, 64.277, 73.587, 82.978, 92.451, 101.982, 111.583, 121.254, 130.959, 140.735, 150.546, 160.403, 170.307, 180.257, 190.231, 200.252, 210.307, 220.409, 230.522, 240.683, 250.866, 261.085, 271.326, 281.592, 291.892, 302.215, 312.562, 322.932, 333.336, 343.753, 354.193, 364.656, 375.142, 385.641, 396.174, 406.718, 417.286, 427.866, 438.469, 449.084, 459.733, 470.383, 481.056, 491.752, 502.448, 513.179, 523.91, 534.665, 545.443, 556.22, 567.021, 577.834, 588.659, 599.506, 610.366, 621.236, 632.119, 643.013, 653.919, 664.849, 675.778, 686.73, 697.694, 708.659, 719.646, 730.645, 741.656, 752.667, 761.1824360197622], alphaGrid=[3.91e-25, 1.29e-24, 3.76e-24, 8.44e-24, 1.61e-23, 1.85e-23, 1.5e-23, 1.93e-23, 1.29e-22, 1.47e-21, 4.32e-22, 1.83e-23, 2.41e-23, 1.72e-21, 3.03e-24, 6.11e-24, 1.14e-23, 2.17e-23, 1.35e-23, 1.64e-23, 1.97e-23, 2.34e-23, 2.73e-23, 3.15e-23, 3.62e-23, 4.11e-23, 4.65e-23, 5.22e-23, 5.84e-23, 6.5e-23, 7.21e-23, 7.97e-23, 8.77e-23, 9.65e-23, 1.05e-22, 1.15e-22, 1.26e-22, 1.36e-22, 1.48e-22, 1.6e-22, 1.72e-22, 1.86e-22, 2e-22, 2.14e-22, 2.3e-22, 2.46e-22, 2.62e-22, 2.81e-22, 2.99e-22, 3.18e-22, 3.38e-22, 3.59e-22, 3.81e-22, 4.02e-22, 4.25e-22, 4.49e-22, 4.74e-22, 5e-22, 5.27e-22, 5.54e-22, 5.83e-22, 6.13e-22, 6.43e-22, 6.75e-22, 7.08e-22, 7.42e-22, 7.75e-22, 8.11e-22, 8.49e-22, 8.87e-22, 9.25e-22, 9.63e-22, 1e-21, 1e-21]),
		ExplicitContinuum(j=39, i=26, wavelengthGrid=[11.169, 19.535, 28.157, 36.989, 45.961, 55.072, 64.277, 73.587, 82.978, 92.451, 101.982, 111.583, 121.254, 130.959, 140.735, 150.546, 160.403, 170.307, 180.257, 190.231, 200.252, 210.307, 220.409, 230.522, 240.683, 250.866, 261.085, 271.326, 281.592, 291.892, 302.215, 312.562, 322.932, 333.336, 343.753, 354.193, 364.656, 375.142, 385.641, 396.174, 406.718, 417.286, 427.866, 438.469, 449.084, 459.733, 470.383, 481.056, 491.752, 502.448, 513.179, 523.91, 534.665, 545.443, 556.22, 567.021, 577.834, 588.659, 599.506, 610.366, 621.236, 632.119, 643.013, 653.919, 664.849, 675.778, 686.73, 697.694, 708.659, 719.646, 730.645, 741.656, 752.667, 757.5255428143969], alphaGrid=[7.53e-24, 1.69e-23, 3.22e-23, 3.7e-23, 3e-23, 3.85e-23, 2.59e-22, 2.94e-21, 8.64e-22, 3.66e-23, 4.81e-23, 3.43e-21, 6.06e-24, 1.22e-23, 2.29e-23, 4.34e-23, 2.71e-23, 3.29e-23, 3.95e-23, 4.68e-23, 5.46e-23, 6.31e-23, 7.23e-23, 8.22e-23, 9.3e-23, 1.04e-22, 1.17e-22, 1.3e-22, 1.44e-22, 1.59e-22, 1.75e-22, 1.93e-22, 2.11e-22, 2.3e-22, 2.51e-22, 2.72e-22, 2.96e-22, 3.19e-22, 3.45e-22, 3.72e-22, 4e-22, 4.28e-22, 4.6e-22, 4.92e-22, 5.25e-22, 5.61e-22, 5.98e-22, 6.35e-22, 6.76e-22, 7.19e-22, 7.62e-22, 8.05e-22, 8.5e-22, 8.99e-22, 9.48e-22, 1e-21, 1.05e-21, 1.11e-21, 1.17e-21, 1.23e-21, 1.29e-21, 1.35e-21, 1.42e-21, 1.48e-21, 1.55e-21, 1.62e-21, 1.7e-21, 1.77e-21, 1.85e-21, 1.93e-21, 2.01e-21, 2.09e-21, 2.16e-21, 2.16e-21]),
		ExplicitContinuum(j=38, i=27, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 791.377, 792.5057486385748], alphaGrid=[5.62e-26, 1.8e-25, 5.17e-25, 1.16e-24, 2.21e-24, 2.91e-24, 3.59e-24, 6.14e-24, 8.08e-22, 4.29e-22, 3.93e-22, 6.66e-24, 1.64e-23, 5.79e-22, 1.61e-24, 2.81e-24, 4.56e-24, 6.42e-24, 7.51e-24, 9.72e-24, 1.2e-23, 1.44e-23, 1.71e-23, 2e-23, 2.31e-23, 2.66e-23, 3.04e-23, 3.45e-23, 3.9e-23, 4.38e-23, 4.9e-23, 5.46e-23, 6.07e-23, 6.71e-23, 7.42e-23, 8.14e-23, 8.95e-23, 9.78e-23, 1.07e-22, 1.17e-22, 1.26e-22, 1.37e-22, 1.48e-22, 1.6e-22, 1.73e-22, 1.86e-22, 2e-22, 2.15e-22, 2.3e-22, 2.46e-22, 2.63e-22, 2.81e-22, 2.99e-22, 3.18e-22, 3.39e-22, 3.6e-22, 3.81e-22, 4.05e-22, 4.28e-22, 4.53e-22, 4.79e-22, 5.06e-22, 5.33e-22, 5.62e-22, 5.92e-22, 6.23e-22, 6.53e-22, 6.87e-22, 7.22e-22, 7.57e-22, 7.92e-22, 8.28e-22, 8.67e-22, 8.67e-22]),
		ExplicitContinuum(j=39, i=27, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 788.5424777976014], alphaGrid=[1.03e-24, 2.31e-24, 4.42e-24, 5.81e-24, 7.18e-24, 1.23e-23, 1.62e-21, 8.58e-22, 7.86e-22, 1.33e-23, 3.28e-23, 1.16e-21, 3.21e-24, 5.63e-24, 9.11e-24, 1.28e-23, 1.5e-23, 1.94e-23, 2.39e-23, 2.87e-23, 3.42e-23, 4e-23, 4.63e-23, 5.32e-23, 6.09e-23, 6.9e-23, 7.8e-23, 8.76e-23, 9.8e-23, 1.09e-22, 1.21e-22, 1.34e-22, 1.48e-22, 1.63e-22, 1.79e-22, 1.96e-22, 2.14e-22, 2.33e-22, 2.53e-22, 2.74e-22, 2.97e-22, 3.21e-22, 3.46e-22, 3.72e-22, 4.01e-22, 4.31e-22, 4.61e-22, 4.92e-22, 5.26e-22, 5.61e-22, 5.99e-22, 6.37e-22, 6.78e-22, 7.2e-22, 7.63e-22, 8.09e-22, 8.56e-22, 9.05e-22, 9.58e-22, 1.01e-21, 1.07e-21, 1.12e-21, 1.18e-21, 1.25e-21, 1.31e-21, 1.37e-21, 1.44e-21, 1.51e-21, 1.58e-21, 1.66e-21, 1.73e-21, 1.81e-21, 1.81e-21]),
		ExplicitContinuum(j=38, i=28, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 791.377, 793.539635122541], alphaGrid=[5.62e-26, 1.8e-25, 5.17e-25, 1.16e-24, 2.21e-24, 2.91e-24, 3.59e-24, 6.14e-24, 8.08e-22, 4.29e-22, 3.93e-22, 6.66e-24, 1.64e-23, 5.79e-22, 1.61e-24, 2.81e-24, 4.56e-24, 6.42e-24, 7.51e-24, 9.72e-24, 1.2e-23, 1.44e-23, 1.71e-23, 2e-23, 2.31e-23, 2.66e-23, 3.04e-23, 3.45e-23, 3.9e-23, 4.38e-23, 4.9e-23, 5.46e-23, 6.07e-23, 6.71e-23, 7.42e-23, 8.14e-23, 8.95e-23, 9.78e-23, 1.07e-22, 1.17e-22, 1.26e-22, 1.37e-22, 1.48e-22, 1.6e-22, 1.73e-22, 1.86e-22, 2e-22, 2.15e-22, 2.3e-22, 2.46e-22, 2.63e-22, 2.81e-22, 2.99e-22, 3.18e-22, 3.39e-22, 3.6e-22, 3.81e-22, 4.05e-22, 4.28e-22, 4.53e-22, 4.79e-22, 5.06e-22, 5.33e-22, 5.62e-22, 5.92e-22, 6.23e-22, 6.53e-22, 6.87e-22, 7.22e-22, 7.57e-22, 7.92e-22, 8.28e-22, 8.67e-22, 8.67e-22]),
		ExplicitContinuum(j=39, i=28, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 789.566042659464], alphaGrid=[1.03e-24, 2.31e-24, 4.42e-24, 5.81e-24, 7.18e-24, 1.23e-23, 1.62e-21, 8.58e-22, 7.86e-22, 1.33e-23, 3.28e-23, 1.16e-21, 3.21e-24, 5.63e-24, 9.11e-24, 1.28e-23, 1.5e-23, 1.94e-23, 2.39e-23, 2.87e-23, 3.42e-23, 4e-23, 4.63e-23, 5.32e-23, 6.09e-23, 6.9e-23, 7.8e-23, 8.76e-23, 9.8e-23, 1.09e-22, 1.21e-22, 1.34e-22, 1.48e-22, 1.63e-22, 1.79e-22, 1.96e-22, 2.14e-22, 2.33e-22, 2.53e-22, 2.74e-22, 2.97e-22, 3.21e-22, 3.46e-22, 3.72e-22, 4.01e-22, 4.31e-22, 4.61e-22, 4.92e-22, 5.26e-22, 5.61e-22, 5.99e-22, 6.37e-22, 6.78e-22, 7.2e-22, 7.63e-22, 8.09e-22, 8.56e-22, 9.05e-22, 9.58e-22, 1.01e-21, 1.07e-21, 1.12e-21, 1.18e-21, 1.25e-21, 1.31e-21, 1.37e-21, 1.44e-21, 1.51e-21, 1.58e-21, 1.66e-21, 1.73e-21, 1.81e-21, 1.81e-21]),
		ExplicitContinuum(j=38, i=29, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 791.377, 795.7136497117333], alphaGrid=[5.62e-26, 1.8e-25, 5.17e-25, 1.16e-24, 2.21e-24, 2.91e-24, 3.59e-24, 6.14e-24, 8.08e-22, 4.29e-22, 3.93e-22, 6.66e-24, 1.64e-23, 5.79e-22, 1.61e-24, 2.81e-24, 4.56e-24, 6.42e-24, 7.51e-24, 9.72e-24, 1.2e-23, 1.44e-23, 1.71e-23, 2e-23, 2.31e-23, 2.66e-23, 3.04e-23, 3.45e-23, 3.9e-23, 4.38e-23, 4.9e-23, 5.46e-23, 6.07e-23, 6.71e-23, 7.42e-23, 8.14e-23, 8.95e-23, 9.78e-23, 1.07e-22, 1.17e-22, 1.26e-22, 1.37e-22, 1.48e-22, 1.6e-22, 1.73e-22, 1.86e-22, 2e-22, 2.15e-22, 2.3e-22, 2.46e-22, 2.63e-22, 2.81e-22, 2.99e-22, 3.18e-22, 3.39e-22, 3.6e-22, 3.81e-22, 4.05e-22, 4.28e-22, 4.53e-22, 4.79e-22, 5.06e-22, 5.33e-22, 5.62e-22, 5.92e-22, 6.23e-22, 6.53e-22, 6.87e-22, 7.22e-22, 7.57e-22, 7.92e-22, 8.28e-22, 8.67e-22, 8.67e-22]),
		ExplicitContinuum(j=39, i=29, wavelengthGrid=[11.527, 19.803, 28.423, 37.288, 46.337, 55.57, 64.925, 74.416, 84.016, 93.727, 103.512, 113.395, 123.351, 133.381, 143.484, 153.649, 163.875, 174.15, 184.499, 194.884, 205.331, 215.814, 226.359, 236.941, 247.559, 258.226, 268.931, 279.684, 290.462, 301.288, 312.14, 323.028, 333.953, 344.902, 355.889, 366.912, 377.959, 389.031, 400.14, 411.273, 422.431, 433.626, 444.833, 456.077, 467.345, 478.625, 489.943, 501.284, 512.638, 524.029, 535.432, 546.86, 558.312, 569.777, 581.265, 592.779, 604.317, 615.867, 627.442, 639.029, 650.641, 662.277, 673.925, 685.598, 697.271, 708.98, 720.702, 732.436, 744.195, 755.966, 767.749, 779.557, 791.377, 791.7183097922493], alphaGrid=[1.03e-24, 2.31e-24, 4.42e-24, 5.81e-24, 7.18e-24, 1.23e-23, 1.62e-21, 8.58e-22, 7.86e-22, 1.33e-23, 3.28e-23, 1.16e-21, 3.21e-24, 5.63e-24, 9.11e-24, 1.28e-23, 1.5e-23, 1.94e-23, 2.39e-23, 2.87e-23, 3.42e-23, 4e-23, 4.63e-23, 5.32e-23, 6.09e-23, 6.9e-23, 7.8e-23, 8.76e-23, 9.8e-23, 1.09e-22, 1.21e-22, 1.34e-22, 1.48e-22, 1.63e-22, 1.79e-22, 1.96e-22, 2.14e-22, 2.33e-22, 2.53e-22, 2.74e-22, 2.97e-22, 3.21e-22, 3.46e-22, 3.72e-22, 4.01e-22, 4.31e-22, 4.61e-22, 4.92e-22, 5.26e-22, 5.61e-22, 5.99e-22, 6.37e-22, 6.78e-22, 7.2e-22, 7.63e-22, 8.09e-22, 8.56e-22, 9.05e-22, 9.58e-22, 1.01e-21, 1.07e-21, 1.12e-21, 1.18e-21, 1.25e-21, 1.31e-21, 1.37e-21, 1.44e-21, 1.51e-21, 1.58e-21, 1.66e-21, 1.73e-21, 1.81e-21, 1.87e-21, 1.87e-21]),
		ExplicitContinuum(j=38, i=30, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 798.480651017245], alphaGrid=[8.23e-26, 2.63e-25, 7.57e-25, 1.69e-24, 3.24e-24, 4.53e-24, 5.82e-24, 8.02e-24, 9.89e-22, 2.73e-22, 3.87e-22, 5.99e-24, 1.56e-23, 6.67e-22, 2.22e-24, 3.27e-24, 4.52e-24, 7.77e-24, 7.28e-24, 7.33e-24, 5.45e-24, 6.36e-24, 7.03e-24, 1.89e-23, 1.14e-23, 1.32e-23, 1.54e-23, 1.78e-23, 2.05e-23, 2.36e-23, 2.68e-23, 3.04e-23, 3.41e-23, 3.81e-23, 4.22e-23, 4.79e-23, 5.97e-23, 7.07e-23, 7.74e-23, 8.41e-23, 9.1e-23, 9.91e-23, 1.08e-22, 1.17e-22, 1.27e-22, 1.38e-22, 1.49e-22, 1.61e-22, 1.74e-22, 1.88e-22, 2.02e-22, 2.17e-22, 2.33e-22, 2.5e-22, 2.68e-22, 2.86e-22, 3.05e-22, 3.26e-22, 3.46e-22, 3.68e-22, 3.92e-22, 4.16e-22, 4.4e-22, 4.67e-22, 4.94e-22, 5.22e-22, 5.5e-22, 5.81e-22, 6.14e-22, 6.46e-22, 6.79e-22, 7.12e-22, 7.12e-22]),
		ExplicitContinuum(j=39, i=30, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 794.4575463734805], alphaGrid=[3.38e-24, 6.48e-24, 9.06e-24, 1.16e-23, 1.6e-23, 1.98e-21, 5.47e-22, 7.74e-22, 1.2e-23, 3.13e-23, 1.33e-21, 4.44e-24, 6.54e-24, 9.04e-24, 1.55e-23, 1.46e-23, 1.47e-23, 1.09e-23, 1.27e-23, 1.41e-23, 3.77e-23, 2.28e-23, 2.63e-23, 3.07e-23, 3.57e-23, 4.11e-23, 4.72e-23, 5.37e-23, 6.08e-23, 6.82e-23, 7.62e-23, 8.44e-23, 9.58e-23, 1.19e-22, 1.41e-22, 1.55e-22, 1.68e-22, 1.82e-22, 1.98e-22, 2.15e-22, 2.34e-22, 2.55e-22, 2.76e-22, 2.98e-22, 3.22e-22, 3.48e-22, 3.75e-22, 4.04e-22, 4.34e-22, 4.66e-22, 4.99e-22, 5.35e-22, 5.72e-22, 6.1e-22, 6.51e-22, 6.93e-22, 7.36e-22, 7.84e-22, 8.32e-22, 8.8e-22, 9.33e-22, 9.89e-22, 1.04e-21, 1.1e-21, 1.16e-21, 1.23e-21, 1.29e-21, 1.36e-21, 1.42e-21, 1.5e-21, 1.57e-21, 1.63e-21, 1.63e-21]),
		ExplicitContinuum(j=38, i=31, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 799.3831959260244], alphaGrid=[8.23e-26, 2.63e-25, 7.57e-25, 1.69e-24, 3.24e-24, 4.53e-24, 5.82e-24, 8.02e-24, 9.89e-22, 2.73e-22, 3.87e-22, 5.99e-24, 1.56e-23, 6.67e-22, 2.22e-24, 3.27e-24, 4.52e-24, 7.77e-24, 7.28e-24, 7.33e-24, 5.45e-24, 6.36e-24, 7.03e-24, 1.89e-23, 1.14e-23, 1.32e-23, 1.54e-23, 1.78e-23, 2.05e-23, 2.36e-23, 2.68e-23, 3.04e-23, 3.41e-23, 3.81e-23, 4.22e-23, 4.79e-23, 5.97e-23, 7.07e-23, 7.74e-23, 8.41e-23, 9.1e-23, 9.91e-23, 1.08e-22, 1.17e-22, 1.27e-22, 1.38e-22, 1.49e-22, 1.61e-22, 1.74e-22, 1.88e-22, 2.02e-22, 2.17e-22, 2.33e-22, 2.5e-22, 2.68e-22, 2.86e-22, 3.05e-22, 3.26e-22, 3.46e-22, 3.68e-22, 3.92e-22, 4.16e-22, 4.4e-22, 4.67e-22, 4.94e-22, 5.22e-22, 5.5e-22, 5.81e-22, 6.14e-22, 6.46e-22, 6.79e-22, 7.12e-22, 7.12e-22]),
		ExplicitContinuum(j=39, i=31, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 795.3510142514978], alphaGrid=[3.38e-24, 6.48e-24, 9.06e-24, 1.16e-23, 1.6e-23, 1.98e-21, 5.47e-22, 7.74e-22, 1.2e-23, 3.13e-23, 1.33e-21, 4.44e-24, 6.54e-24, 9.04e-24, 1.55e-23, 1.46e-23, 1.47e-23, 1.09e-23, 1.27e-23, 1.41e-23, 3.77e-23, 2.28e-23, 2.63e-23, 3.07e-23, 3.57e-23, 4.11e-23, 4.72e-23, 5.37e-23, 6.08e-23, 6.82e-23, 7.62e-23, 8.44e-23, 9.58e-23, 1.19e-22, 1.41e-22, 1.55e-22, 1.68e-22, 1.82e-22, 1.98e-22, 2.15e-22, 2.34e-22, 2.55e-22, 2.76e-22, 2.98e-22, 3.22e-22, 3.48e-22, 3.75e-22, 4.04e-22, 4.34e-22, 4.66e-22, 4.99e-22, 5.35e-22, 5.72e-22, 6.1e-22, 6.51e-22, 6.93e-22, 7.36e-22, 7.84e-22, 8.32e-22, 8.8e-22, 9.33e-22, 9.89e-22, 1.04e-21, 1.1e-21, 1.16e-21, 1.23e-21, 1.29e-21, 1.36e-21, 1.42e-21, 1.5e-21, 1.57e-21, 1.63e-21, 1.63e-21]),
		ExplicitContinuum(j=38, i=32, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 799.888, 800.0624048675804], alphaGrid=[8.23e-26, 2.63e-25, 7.57e-25, 1.69e-24, 3.24e-24, 4.53e-24, 5.82e-24, 8.02e-24, 9.89e-22, 2.73e-22, 3.87e-22, 5.99e-24, 1.56e-23, 6.67e-22, 2.22e-24, 3.27e-24, 4.52e-24, 7.77e-24, 7.28e-24, 7.33e-24, 5.45e-24, 6.36e-24, 7.03e-24, 1.89e-23, 1.14e-23, 1.32e-23, 1.54e-23, 1.78e-23, 2.05e-23, 2.36e-23, 2.68e-23, 3.04e-23, 3.41e-23, 3.81e-23, 4.22e-23, 4.79e-23, 5.97e-23, 7.07e-23, 7.74e-23, 8.41e-23, 9.1e-23, 9.91e-23, 1.08e-22, 1.17e-22, 1.27e-22, 1.38e-22, 1.49e-22, 1.61e-22, 1.74e-22, 1.88e-22, 2.02e-22, 2.17e-22, 2.33e-22, 2.5e-22, 2.68e-22, 2.86e-22, 3.05e-22, 3.26e-22, 3.46e-22, 3.68e-22, 3.92e-22, 4.16e-22, 4.4e-22, 4.67e-22, 4.94e-22, 5.22e-22, 5.5e-22, 5.81e-22, 6.14e-22, 6.46e-22, 6.79e-22, 7.12e-22, 7.49e-22, 7.49e-22]),
		ExplicitContinuum(j=39, i=32, wavelengthGrid=[11.535, 19.791, 28.407, 37.27, 46.345, 55.593, 64.989, 74.51, 84.155, 93.911, 103.754, 113.696, 123.712, 133.816, 143.981, 154.22, 164.534, 174.898, 185.324, 195.799, 206.336, 216.923, 227.559, 238.245, 248.968, 259.741, 270.551, 281.41, 292.307, 303.241, 314.212, 325.22, 336.265, 347.348, 358.455, 369.6, 380.782, 391.988, 403.232, 414.5, 425.794, 437.124, 448.48, 459.86, 471.265, 482.694, 494.161, 505.641, 517.157, 528.686, 540.252, 551.831, 563.434, 575.062, 586.715, 598.392, 610.082, 621.797, 633.537, 645.289, 657.066, 668.867, 680.681, 692.52, 704.371, 716.247, 728.148, 740.049, 751.987, 763.937, 775.9, 787.888, 796.0233855750218], alphaGrid=[1.51e-24, 3.38e-24, 6.48e-24, 9.06e-24, 1.16e-23, 1.6e-23, 1.98e-21, 5.47e-22, 7.74e-22, 1.2e-23, 3.13e-23, 1.33e-21, 4.44e-24, 6.54e-24, 9.04e-24, 1.55e-23, 1.46e-23, 1.47e-23, 1.09e-23, 1.27e-23, 1.41e-23, 3.77e-23, 2.28e-23, 2.63e-23, 3.07e-23, 3.57e-23, 4.11e-23, 4.72e-23, 5.37e-23, 6.08e-23, 6.82e-23, 7.62e-23, 8.44e-23, 9.58e-23, 1.19e-22, 1.41e-22, 1.55e-22, 1.68e-22, 1.82e-22, 1.98e-22, 2.15e-22, 2.34e-22, 2.55e-22, 2.76e-22, 2.98e-22, 3.22e-22, 3.48e-22, 3.75e-22, 4.04e-22, 4.34e-22, 4.66e-22, 4.99e-22, 5.35e-22, 5.72e-22, 6.1e-22, 6.51e-22, 6.93e-22, 7.36e-22, 7.84e-22, 8.32e-22, 8.8e-22, 9.33e-22, 9.89e-22, 1.04e-21, 1.1e-21, 1.16e-21, 1.23e-21, 1.29e-21, 1.36e-21, 1.42e-21, 1.5e-21, 1.57e-21, 1.57e-21]),
		ExplicitContinuum(j=38, i=33, wavelengthGrid=[11.55, 19.774, 28.364, 37.246, 46.343, 55.629, 65.08, 74.683, 84.4, 94.243, 104.188, 114.233, 124.38, 134.603, 144.901, 155.289, 165.739, 176.266, 186.843, 197.496, 208.199, 218.966, 229.783, 240.651, 251.57, 262.552, 273.559, 284.629, 295.738, 306.884, 318.081, 329.316, 340.589, 351.9, 363.249, 374.635, 386.06, 397.51, 408.998, 420.524, 432.088, 443.664, 455.291, 466.944, 478.622, 490.325, 502.066, 513.832, 525.624, 537.453, 549.295, 561.163, 573.068, 584.999, 596.942, 608.924, 620.918, 632.937, 644.994, 657.064, 669.147, 681.268, 693.401, 705.559, 717.743, 729.952, 742.174, 754.421, 766.681, 778.966, 791.264, 803.599, 813.8249324220119], alphaGrid=[1.42e-25, 4.51e-25, 1.3e-24, 2.91e-24, 5.58e-24, 6.13e-24, 3.29e-24, 2.78e-24, 1.21e-21, 9.61e-23, 3.82e-22, 3.96e-24, 1.05e-23, 7.04e-22, 1.01e-24, 1.19e-24, 1.64e-24, 4.82e-24, 4.49e-24, 5.33e-24, 6.45e-24, 7.79e-24, 9.32e-24, 1.1e-23, 1.3e-23, 1.52e-23, 1.76e-23, 2.04e-23, 2.33e-23, 2.66e-23, 3.02e-23, 3.42e-23, 3.85e-23, 4.32e-23, 4.82e-23, 5.38e-23, 5.97e-23, 6.63e-23, 7.29e-23, 8.04e-23, 8.82e-23, 9.68e-23, 1.06e-22, 1.15e-22, 1.26e-22, 1.36e-22, 1.48e-22, 1.6e-22, 1.73e-22, 1.86e-22, 2e-22, 2.15e-22, 2.31e-22, 2.48e-22, 2.65e-22, 2.83e-22, 3.03e-22, 3.23e-22, 3.44e-22, 3.65e-22, 3.89e-22, 4.13e-22, 4.37e-22, 4.63e-22, 4.91e-22, 5.18e-22, 5.46e-22, 5.78e-22, 6.1e-22, 6.43e-22, 6.75e-22, 7.08e-22, 7.08e-22]),
		ExplicitContinuum(j=39, i=33, wavelengthGrid=[11.55, 19.774, 28.364, 37.246, 46.343, 55.629, 65.08, 74.683, 84.4, 94.243, 104.188, 114.233, 124.38, 134.603, 144.901, 155.289, 165.739, 176.266, 186.843, 197.496, 208.199, 218.966, 229.783, 240.651, 251.57, 262.552, 273.559, 284.629, 295.738, 306.884, 318.081, 329.316, 340.589, 351.9, 363.249, 374.635, 386.06, 397.51, 408.998, 420.524, 432.088, 443.664, 455.291, 466.944, 478.622, 490.325, 502.066, 513.832, 525.624, 537.453, 549.295, 561.163, 573.068, 584.999, 596.942, 608.924, 620.918, 632.937, 644.994, 657.064, 669.147, 681.268, 693.401, 705.559, 717.743, 729.952, 742.174, 754.421, 766.681, 778.966, 791.264, 803.599, 809.646123920387], alphaGrid=[5.83e-24, 1.12e-23, 1.23e-23, 6.59e-24, 5.56e-24, 2.43e-21, 1.92e-22, 7.64e-22, 7.91e-24, 2.09e-23, 1.41e-21, 2.02e-24, 2.37e-24, 3.27e-24, 9.63e-24, 8.97e-24, 1.07e-23, 1.29e-23, 1.56e-23, 1.86e-23, 2.21e-23, 2.6e-23, 3.04e-23, 3.52e-23, 4.07e-23, 4.66e-23, 5.33e-23, 6.05e-23, 6.85e-23, 7.7e-23, 8.65e-23, 9.65e-23, 1.08e-22, 1.19e-22, 1.33e-22, 1.46e-22, 1.61e-22, 1.76e-22, 1.94e-22, 2.11e-22, 2.31e-22, 2.51e-22, 2.72e-22, 2.95e-22, 3.19e-22, 3.45e-22, 3.72e-22, 4.01e-22, 4.31e-22, 4.63e-22, 4.95e-22, 5.31e-22, 5.67e-22, 6.05e-22, 6.46e-22, 6.87e-22, 7.31e-22, 7.78e-22, 8.25e-22, 8.73e-22, 9.27e-22, 9.82e-22, 1.04e-21, 1.09e-21, 1.16e-21, 1.22e-21, 1.29e-21, 1.35e-21, 1.42e-21, 1.49e-21, 1.56e-21, 1.62e-21, 1.62e-21]),
		ExplicitContinuum(j=38, i=34, wavelengthGrid=[11.566, 19.732, 28.313, 37.203, 46.327, 55.658, 65.17, 74.837, 84.646, 94.598, 104.654, 114.813, 125.088, 135.454, 145.898, 156.445, 167.057, 177.746, 188.514, 199.346, 210.242, 221.217, 232.23, 243.32, 254.463, 265.657, 276.903, 288.201, 299.538, 310.939, 322.379, 333.871, 345.402, 356.971, 368.593, 380.253, 391.952, 403.69, 415.466, 427.282, 439.123, 451.016, 462.935, 474.893, 486.877, 498.899, 510.948, 523.035, 535.148, 547.3, 559.478, 571.681, 583.924, 596.179, 608.474, 620.794, 633.14, 645.525, 657.923, 670.346, 682.809, 695.284, 707.786, 720.313, 732.866, 745.445, 758.05, 770.668, 783.312, 795.981, 808.677, 821.385, 827.4032651815061], alphaGrid=[6.15e-26, 1.94e-25, 5.59e-25, 1.26e-24, 2.41e-24, 3.35e-24, 5.65e-24, 4.75e-24, 1.39e-21, 5.06e-23, 4.8e-22, 1.39e-23, 5.63e-23, 1.87e-21, 1.33e-24, 1.45e-24, 4.13e-24, 5.24e-24, 3.55e-24, 3.94e-24, 4.56e-24, 5.35e-24, 6.28e-24, 7.34e-24, 8.58e-24, 9.98e-24, 1.15e-23, 1.33e-23, 1.53e-23, 1.75e-23, 1.99e-23, 2.25e-23, 2.55e-23, 2.87e-23, 3.21e-23, 3.59e-23, 4.01e-23, 4.47e-23, 4.94e-23, 5.47e-23, 6.03e-23, 6.65e-23, 7.29e-23, 8.01e-23, 8.76e-23, 9.52e-23, 1.04e-22, 1.13e-22, 1.22e-22, 1.32e-22, 1.43e-22, 1.54e-22, 1.67e-22, 1.79e-22, 1.93e-22, 2.06e-22, 2.21e-22, 2.37e-22, 2.53e-22, 2.7e-22, 2.88e-22, 3.07e-22, 3.26e-22, 3.47e-22, 3.68e-22, 3.9e-22, 4.12e-22, 4.37e-22, 4.63e-22, 4.89e-22, 5.15e-22, 5.42e-22, 5.42e-22]),
		ExplicitContinuum(j=39, i=34, wavelengthGrid=[11.566, 19.732, 28.313, 37.203, 46.327, 55.658, 65.17, 74.837, 84.646, 94.598, 104.654, 114.813, 125.088, 135.454, 145.898, 156.445, 167.057, 177.746, 188.514, 199.346, 210.242, 221.217, 232.23, 243.32, 254.463, 265.657, 276.903, 288.201, 299.538, 310.939, 322.379, 333.871, 345.402, 356.971, 368.593, 380.253, 391.952, 403.69, 415.466, 427.282, 439.123, 451.016, 462.935, 474.893, 486.877, 498.899, 510.948, 523.035, 535.148, 547.3, 559.478, 571.681, 583.924, 596.179, 608.474, 620.794, 633.14, 645.525, 657.923, 670.346, 682.809, 695.284, 707.786, 720.313, 732.866, 745.445, 758.05, 770.668, 783.312, 795.981, 808.677, 821.385, 823.084220035105], alphaGrid=[2.51e-24, 4.83e-24, 6.7e-24, 1.13e-23, 9.5e-24, 2.78e-21, 1.01e-22, 9.61e-22, 2.78e-23, 1.13e-22, 3.73e-21, 2.65e-24, 2.91e-24, 8.25e-24, 1.05e-23, 7.1e-24, 7.87e-24, 9.12e-24, 1.07e-23, 1.26e-23, 1.47e-23, 1.72e-23, 2e-23, 2.31e-23, 2.66e-23, 3.05e-23, 3.49e-23, 3.97e-23, 4.51e-23, 5.09e-23, 5.73e-23, 6.43e-23, 7.19e-23, 8.03e-23, 8.94e-23, 9.88e-23, 1.09e-22, 1.21e-22, 1.33e-22, 1.46e-22, 1.6e-22, 1.75e-22, 1.9e-22, 2.07e-22, 2.25e-22, 2.44e-22, 2.65e-22, 2.86e-22, 3.09e-22, 3.33e-22, 3.58e-22, 3.85e-22, 4.13e-22, 4.43e-22, 4.74e-22, 5.06e-22, 5.4e-22, 5.77e-22, 6.13e-22, 6.51e-22, 6.94e-22, 7.37e-22, 7.8e-22, 8.24e-22, 8.75e-22, 9.27e-22, 9.78e-22, 1.03e-21, 1.08e-21, 1.14e-21, 1.2e-21, 1.25e-21, 1.25e-21]),
		ExplicitContinuum(j=38, i=35, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.877, 869.0796663603177], alphaGrid=[5.3e-25, 1.73e-24, 5.13e-24, 1.17e-23, 2.28e-23, 3.47e-23, 4.4e-23, 5.48e-23, 5.19e-22, 6.3e-22, 4.77e-22, 7.09e-23, 1.25e-22, 5.27e-22, 2.98e-23, 3.31e-23, 4.14e-23, 5.98e-23, 3.25e-23, 8.55e-24, 1.12e-23, 3.99e-24, 7.9e-24, 4.54e-23, 5.23e-24, 5.86e-24, 6.67e-24, 7.6e-24, 8.72e-24, 1.01e-23, 1.18e-23, 1.4e-23, 1.71e-23, 2.26e-23, 3.44e-23, 5.44e-23, 5.44e-23, 3.96e-23, 3.31e-23, 3.22e-23, 3.35e-23, 3.6e-23, 3.91e-23, 4.28e-23, 4.69e-23, 5.14e-23, 5.63e-23, 6.17e-23, 6.74e-23, 7.37e-23, 8.03e-23, 8.76e-23, 9.51e-23, 1.03e-22, 1.12e-22, 1.21e-22, 1.31e-22, 1.42e-22, 1.52e-22, 1.64e-22, 1.77e-22, 1.89e-22, 2.03e-22, 2.18e-22, 2.33e-22, 2.48e-22, 2.64e-22, 2.83e-22, 3.01e-22, 3.2e-22, 3.39e-22, 3.59e-22, 3.81e-22, 3.81e-22]),
		ExplicitContinuum(j=39, i=35, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.3158140839411], alphaGrid=[1.03e-23, 2.34e-23, 4.57e-23, 6.94e-23, 8.81e-23, 1.1e-22, 1.04e-21, 1.26e-21, 9.55e-22, 1.42e-22, 2.49e-22, 1.05e-21, 5.96e-23, 6.62e-23, 8.29e-23, 1.2e-22, 6.49e-23, 1.71e-23, 2.24e-23, 7.98e-24, 1.58e-23, 9.08e-23, 1.05e-23, 1.17e-23, 1.33e-23, 1.52e-23, 1.74e-23, 2.02e-23, 2.35e-23, 2.79e-23, 3.42e-23, 4.52e-23, 6.89e-23, 1.09e-22, 1.09e-22, 7.92e-23, 6.62e-23, 6.44e-23, 6.71e-23, 7.2e-23, 7.82e-23, 8.55e-23, 9.37e-23, 1.03e-22, 1.13e-22, 1.23e-22, 1.35e-22, 1.47e-22, 1.61e-22, 1.75e-22, 1.9e-22, 2.07e-22, 2.24e-22, 2.42e-22, 2.62e-22, 2.83e-22, 3.04e-22, 3.28e-22, 3.53e-22, 3.78e-22, 4.05e-22, 4.35e-22, 4.66e-22, 4.96e-22, 5.28e-22, 5.65e-22, 6.03e-22, 6.41e-22, 6.79e-22, 7.18e-22, 7.62e-22, 8.07e-22, 8.07e-22]),
		ExplicitContinuum(j=38, i=36, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.877, 869.6790319080886], alphaGrid=[5.3e-25, 1.73e-24, 5.13e-24, 1.17e-23, 2.28e-23, 3.47e-23, 4.4e-23, 5.48e-23, 5.19e-22, 6.3e-22, 4.77e-22, 7.09e-23, 1.25e-22, 5.27e-22, 2.98e-23, 3.31e-23, 4.14e-23, 5.98e-23, 3.25e-23, 8.55e-24, 1.12e-23, 3.99e-24, 7.9e-24, 4.54e-23, 5.23e-24, 5.86e-24, 6.67e-24, 7.6e-24, 8.72e-24, 1.01e-23, 1.18e-23, 1.4e-23, 1.71e-23, 2.26e-23, 3.44e-23, 5.44e-23, 5.44e-23, 3.96e-23, 3.31e-23, 3.22e-23, 3.35e-23, 3.6e-23, 3.91e-23, 4.28e-23, 4.69e-23, 5.14e-23, 5.63e-23, 6.17e-23, 6.74e-23, 7.37e-23, 8.03e-23, 8.76e-23, 9.51e-23, 1.03e-22, 1.12e-22, 1.21e-22, 1.31e-22, 1.42e-22, 1.52e-22, 1.64e-22, 1.77e-22, 1.89e-22, 2.03e-22, 2.18e-22, 2.33e-22, 2.48e-22, 2.64e-22, 2.83e-22, 3.01e-22, 3.2e-22, 3.39e-22, 3.59e-22, 3.81e-22, 3.81e-22]),
		ExplicitContinuum(j=39, i=36, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.877, 864.9086245660857], alphaGrid=[1.03e-23, 2.34e-23, 4.57e-23, 6.94e-23, 8.81e-23, 1.1e-22, 1.04e-21, 1.26e-21, 9.55e-22, 1.42e-22, 2.49e-22, 1.05e-21, 5.96e-23, 6.62e-23, 8.29e-23, 1.2e-22, 6.49e-23, 1.71e-23, 2.24e-23, 7.98e-24, 1.58e-23, 9.08e-23, 1.05e-23, 1.17e-23, 1.33e-23, 1.52e-23, 1.74e-23, 2.02e-23, 2.35e-23, 2.79e-23, 3.42e-23, 4.52e-23, 6.89e-23, 1.09e-22, 1.09e-22, 7.92e-23, 6.62e-23, 6.44e-23, 6.71e-23, 7.2e-23, 7.82e-23, 8.55e-23, 9.37e-23, 1.03e-22, 1.13e-22, 1.23e-22, 1.35e-22, 1.47e-22, 1.61e-22, 1.75e-22, 1.9e-22, 2.07e-22, 2.24e-22, 2.42e-22, 2.62e-22, 2.83e-22, 3.04e-22, 3.28e-22, 3.53e-22, 3.78e-22, 4.05e-22, 4.35e-22, 4.66e-22, 4.96e-22, 5.28e-22, 5.65e-22, 6.03e-22, 6.41e-22, 6.79e-22, 7.18e-22, 7.62e-22, 8.07e-22, 8.41e-22, 8.41e-22]),
		ExplicitContinuum(j=38, i=37, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.877, 870.0104357751784], alphaGrid=[5.3e-25, 1.73e-24, 5.13e-24, 1.17e-23, 2.28e-23, 3.47e-23, 4.4e-23, 5.48e-23, 5.19e-22, 6.3e-22, 4.77e-22, 7.09e-23, 1.25e-22, 5.27e-22, 2.98e-23, 3.31e-23, 4.14e-23, 5.98e-23, 3.25e-23, 8.55e-24, 1.12e-23, 3.99e-24, 7.9e-24, 4.54e-23, 5.23e-24, 5.86e-24, 6.67e-24, 7.6e-24, 8.72e-24, 1.01e-23, 1.18e-23, 1.4e-23, 1.71e-23, 2.26e-23, 3.44e-23, 5.44e-23, 5.44e-23, 3.96e-23, 3.31e-23, 3.22e-23, 3.35e-23, 3.6e-23, 3.91e-23, 4.28e-23, 4.69e-23, 5.14e-23, 5.63e-23, 6.17e-23, 6.74e-23, 7.37e-23, 8.03e-23, 8.76e-23, 9.51e-23, 1.03e-22, 1.12e-22, 1.21e-22, 1.31e-22, 1.42e-22, 1.52e-22, 1.64e-22, 1.77e-22, 1.89e-22, 2.03e-22, 2.18e-22, 2.33e-22, 2.48e-22, 2.64e-22, 2.83e-22, 3.01e-22, 3.2e-22, 3.39e-22, 3.59e-22, 3.81e-22, 3.81e-22]),
		ExplicitContinuum(j=39, i=37, wavelengthGrid=[10.962, 19.013, 27.535, 36.406, 45.559, 54.955, 64.552, 74.337, 84.283, 94.391, 104.62, 114.996, 125.48, 136.072, 146.771, 157.564, 168.465, 179.446, 190.522, 201.665, 212.888, 224.192, 235.577, 247.015, 258.534, 270.107, 281.747, 293.454, 305.202, 317.03, 328.898, 340.821, 352.81, 364.84, 376.91, 389.047, 401.225, 413.443, 425.715, 438.04, 450.393, 462.799, 475.232, 487.719, 500.246, 512.813, 525.421, 538.056, 550.731, 563.446, 576.201, 588.997, 601.82, 614.67, 627.56, 640.49, 653.448, 666.432, 679.456, 692.508, 705.599, 718.704, 731.85, 745.036, 758.235, 771.461, 784.727, 798.02, 811.341, 824.688, 838.061, 851.449, 864.877, 865.236402052861], alphaGrid=[1.03e-23, 2.34e-23, 4.57e-23, 6.94e-23, 8.81e-23, 1.1e-22, 1.04e-21, 1.26e-21, 9.55e-22, 1.42e-22, 2.49e-22, 1.05e-21, 5.96e-23, 6.62e-23, 8.29e-23, 1.2e-22, 6.49e-23, 1.71e-23, 2.24e-23, 7.98e-24, 1.58e-23, 9.08e-23, 1.05e-23, 1.17e-23, 1.33e-23, 1.52e-23, 1.74e-23, 2.02e-23, 2.35e-23, 2.79e-23, 3.42e-23, 4.52e-23, 6.89e-23, 1.09e-22, 1.09e-22, 7.92e-23, 6.62e-23, 6.44e-23, 6.71e-23, 7.2e-23, 7.82e-23, 8.55e-23, 9.37e-23, 1.03e-22, 1.13e-22, 1.23e-22, 1.35e-22, 1.47e-22, 1.61e-22, 1.75e-22, 1.9e-22, 2.07e-22, 2.24e-22, 2.42e-22, 2.62e-22, 2.83e-22, 3.04e-22, 3.28e-22, 3.53e-22, 3.78e-22, 4.05e-22, 4.35e-22, 4.66e-22, 4.96e-22, 5.28e-22, 5.65e-22, 6.03e-22, 6.41e-22, 6.79e-22, 7.18e-22, 7.62e-22, 8.07e-22, 8.41e-22, 8.41e-22]),
		ExplicitContinuum(j=60, i=38, wavelengthGrid=[0.608, 4.714, 6.908, 8.654, 10.159, 11.508, 12.743, 13.89, 14.969, 15.99, 16.962, 17.892, 18.787, 19.649, 20.483, 21.291, 22.076, 22.839, 23.584, 24.31, 25.02, 25.714, 26.395, 27.061, 27.716, 28.358, 28.989, 29.61, 30.221, 30.822, 31.414, 31.998, 32.573, 33.141, 33.701, 34.254, 34.8, 35.339, 35.873, 36.4, 36.92, 37.436, 37.946, 38.451, 38.951, 39.445, 39.935, 40.42, 40.901, 41.377, 41.849, 42.317, 42.781, 43.242, 43.698, 44.15, 44.599, 45.045, 45.487, 45.925, 46.361, 46.794, 47.223, 47.65, 48.073, 48.493, 48.911, 49.326, 49.738, 50.147, 50.554, 50.84904325542001], alphaGrid=[1.82e-23, 2.15e-23, 1.53e-23, 2.49e-23, 3.48e-23, 4.45e-23, 5.51e-23, 6.52e-23, 7.47e-23, 8.45e-23, 9.77e-23, 1.11e-22, 1.23e-22, 1.35e-22, 1.47e-22, 1.59e-22, 1.7e-22, 1.7e-22, 1.7e-22, 1.83e-22, 1.92e-22, 2.01e-22, 2.1e-22, 2.19e-22, 2.27e-22, 2.36e-22, 2.44e-22, 2.52e-22, 2.66e-22, 2.81e-22, 2.76e-22, 2.89e-22, 2.93e-22, 2.9e-22, 3.06e-22, 3.31e-22, 3.69e-22, 3.49e-22, 3.73e-22, 3.47e-22, 3.31e-22, 3.1e-22, 3.59e-22, 4.38e-22, 4.42e-22, 4.38e-22, 4.34e-22, 4.31e-22, 4.09e-22, 3.94e-22, 3.83e-22, 4.02e-22, 5.89e-22, 3.06e-22, 5.58e-22, 4.28e-22, 4.03e-22, 3.81e-22, 3.6e-22, 2.72e-22, 1.32e-21, 5.19e-22, 5.1e-22, 5.04e-22, 4.98e-22, 4.92e-22, 4.86e-22, 4.8e-22, 4.74e-22, 4.69e-22, 4.63e-22, 4.63e-22]),
		ExplicitContinuum(j=60, i=39, wavelengthGrid=[0.608, 4.714, 6.908, 8.654, 10.159, 11.508, 12.743, 13.89, 14.969, 15.99, 16.962, 17.892, 18.787, 19.649, 20.483, 21.291, 22.076, 22.839, 23.584, 24.31, 25.02, 25.714, 26.395, 27.061, 27.716, 28.358, 28.989, 29.61, 30.221, 30.822, 31.414, 31.998, 32.573, 33.141, 33.701, 34.254, 34.8, 35.339, 35.873, 36.4, 36.92, 37.436, 37.946, 38.451, 38.951, 39.445, 39.935, 40.42, 40.901, 41.377, 41.849, 42.317, 42.781, 43.242, 43.698, 44.15, 44.599, 45.045, 45.487, 45.925, 46.361, 46.794, 47.223, 47.65, 48.073, 48.493, 48.911, 49.326, 49.738, 50.147, 50.554, 50.865446580258535], alphaGrid=[1.82e-23, 2.15e-23, 1.53e-23, 2.49e-23, 3.48e-23, 4.45e-23, 5.51e-23, 6.52e-23, 7.47e-23, 8.45e-23, 9.77e-23, 1.11e-22, 1.23e-22, 1.35e-22, 1.47e-22, 1.59e-22, 1.7e-22, 1.7e-22, 1.7e-22, 1.83e-22, 1.92e-22, 2.01e-22, 2.1e-22, 2.19e-22, 2.27e-22, 2.36e-22, 2.44e-22, 2.52e-22, 2.66e-22, 2.81e-22, 2.76e-22, 2.89e-22, 2.93e-22, 2.9e-22, 3.06e-22, 3.31e-22, 3.69e-22, 3.49e-22, 3.73e-22, 3.47e-22, 3.31e-22, 3.1e-22, 3.59e-22, 4.38e-22, 4.42e-22, 4.38e-22, 4.34e-22, 4.31e-22, 4.09e-22, 3.94e-22, 3.83e-22, 4.02e-22, 5.89e-22, 3.06e-22, 5.58e-22, 4.28e-22, 4.03e-22, 3.81e-22, 3.6e-22, 2.72e-22, 1.32e-21, 5.19e-22, 5.1e-22, 5.04e-22, 4.98e-22, 4.92e-22, 4.86e-22, 4.8e-22, 4.74e-22, 4.69e-22, 4.63e-22, 4.63e-22]),
		ExplicitContinuum(j=60, i=44, wavelengthGrid=[5.865, 7.659, 9.165, 10.495, 11.702, 12.817, 13.859, 14.842, 15.775, 16.667, 17.521, 18.344, 19.138, 19.907, 20.652, 21.377, 22.082, 22.77, 23.442, 24.098, 24.741, 25.37, 25.988, 26.593, 27.188, 27.773, 28.349, 28.914, 29.471, 30.02, 30.561, 31.094, 31.621, 32.14, 32.653, 33.159, 33.659, 34.153, 34.642, 35.125, 35.603, 36.076, 36.544, 37.007, 37.466, 37.921, 38.371, 38.816, 39.258, 39.696, 40.13, 40.56, 40.986, 41.41, 41.829, 42.246, 42.659, 43.069, 43.475, 43.879, 44.28, 44.678, 45.073, 45.465, 45.855, 46.242, 46.626, 47.008, 47.388, 47.765, 48.14, 48.512, 48.882, 49.25, 49.616, 65.07991677111667], alphaGrid=[3.37e-24, 5.89e-24, 1.01e-23, 1.52e-23, 2.1e-23, 2.76e-23, 3.49e-23, 4.29e-23, 5.15e-23, 6.08e-23, 7.06e-23, 8.1e-23, 9.2e-23, 1.04e-22, 1.16e-22, 1.28e-22, 1.41e-22, 1.55e-22, 1.69e-22, 1.84e-22, 1.99e-22, 2.14e-22, 2.3e-22, 2.47e-22, 2.61e-22, 2.74e-22, 2.87e-22, 3e-22, 3.13e-22, 3.25e-22, 3.37e-22, 3.49e-22, 3.61e-22, 3.73e-22, 3.85e-22, 3.96e-22, 4.07e-22, 4.19e-22, 4.5e-22, 4.6e-22, 4.69e-22, 5.25e-22, 4.75e-22, 5.58e-22, 5.5e-22, 5.32e-22, 5.15e-22, 5.98e-22, 6.26e-22, 6.28e-22, 6.3e-22, 6.32e-22, 6.34e-22, 6.36e-22, 6.38e-22, 6.4e-22, 6.42e-22, 6.43e-22, 6.45e-22, 8.39e-22, 8.54e-22, 8.59e-22, 8.67e-22, 8.77e-22, 8.86e-22, 8.95e-22, 9.05e-22, 9.14e-22, 9.23e-22, 9.32e-22, 9.41e-22, 9.49e-22, 9.58e-22, 9.67e-22, 9.74e-22, 9.74e-22]),
		ExplicitContinuum(j=60, i=45, wavelengthGrid=[5.865, 7.659, 9.165, 10.495, 11.702, 12.817, 13.859, 14.842, 15.775, 16.667, 17.521, 18.344, 19.138, 19.907, 20.652, 21.377, 22.082, 22.77, 23.442, 24.098, 24.741, 25.37, 25.988, 26.593, 27.188, 27.773, 28.349, 28.914, 29.471, 30.02, 30.561, 31.094, 31.621, 32.14, 32.653, 33.159, 33.659, 34.153, 34.642, 35.125, 35.603, 36.076, 36.544, 37.007, 37.466, 37.921, 38.371, 38.816, 39.258, 39.696, 40.13, 40.56, 40.986, 41.41, 41.829, 42.246, 42.659, 43.069, 43.475, 43.879, 44.28, 44.678, 45.073, 45.465, 45.855, 46.242, 46.626, 47.008, 47.388, 47.765, 48.14, 48.512, 48.882, 49.25, 49.616, 65.08923597564865], alphaGrid=[3.37e-24, 5.89e-24, 1.01e-23, 1.52e-23, 2.1e-23, 2.76e-23, 3.49e-23, 4.29e-23, 5.15e-23, 6.08e-23, 7.06e-23, 8.1e-23, 9.2e-23, 1.04e-22, 1.16e-22, 1.28e-22, 1.41e-22, 1.55e-22, 1.69e-22, 1.84e-22, 1.99e-22, 2.14e-22, 2.3e-22, 2.47e-22, 2.61e-22, 2.74e-22, 2.87e-22, 3e-22, 3.13e-22, 3.25e-22, 3.37e-22, 3.49e-22, 3.61e-22, 3.73e-22, 3.85e-22, 3.96e-22, 4.07e-22, 4.19e-22, 4.5e-22, 4.6e-22, 4.69e-22, 5.25e-22, 4.75e-22, 5.58e-22, 5.5e-22, 5.32e-22, 5.15e-22, 5.98e-22, 6.26e-22, 6.28e-22, 6.3e-22, 6.32e-22, 6.34e-22, 6.36e-22, 6.38e-22, 6.4e-22, 6.42e-22, 6.43e-22, 6.45e-22, 8.39e-22, 8.54e-22, 8.59e-22, 8.67e-22, 8.77e-22, 8.86e-22, 8.95e-22, 9.05e-22, 9.14e-22, 9.23e-22, 9.32e-22, 9.41e-22, 9.49e-22, 9.58e-22, 9.67e-22, 9.74e-22, 9.74e-22]),
		ExplicitContinuum(j=60, i=46, wavelengthGrid=[5.865, 7.659, 9.165, 10.495, 11.702, 12.817, 13.859, 14.842, 15.775, 16.667, 17.521, 18.344, 19.138, 19.907, 20.652, 21.377, 22.082, 22.77, 23.442, 24.098, 24.741, 25.37, 25.988, 26.593, 27.188, 27.773, 28.349, 28.914, 29.471, 30.02, 30.561, 31.094, 31.621, 32.14, 32.653, 33.159, 33.659, 34.153, 34.642, 35.125, 35.603, 36.076, 36.544, 37.007, 37.466, 37.921, 38.371, 38.816, 39.258, 39.696, 40.13, 40.56, 40.986, 41.41, 41.829, 42.246, 42.659, 43.069, 43.475, 43.879, 44.28, 44.678, 45.073, 45.465, 45.855, 46.242, 46.626, 47.008, 47.388, 47.765, 48.14, 48.512, 48.882, 49.25, 49.616, 65.10122778702164], alphaGrid=[3.37e-24, 5.89e-24, 1.01e-23, 1.52e-23, 2.1e-23, 2.76e-23, 3.49e-23, 4.29e-23, 5.15e-23, 6.08e-23, 7.06e-23, 8.1e-23, 9.2e-23, 1.04e-22, 1.16e-22, 1.28e-22, 1.41e-22, 1.55e-22, 1.69e-22, 1.84e-22, 1.99e-22, 2.14e-22, 2.3e-22, 2.47e-22, 2.61e-22, 2.74e-22, 2.87e-22, 3e-22, 3.13e-22, 3.25e-22, 3.37e-22, 3.49e-22, 3.61e-22, 3.73e-22, 3.85e-22, 3.96e-22, 4.07e-22, 4.19e-22, 4.5e-22, 4.6e-22, 4.69e-22, 5.25e-22, 4.75e-22, 5.58e-22, 5.5e-22, 5.32e-22, 5.15e-22, 5.98e-22, 6.26e-22, 6.28e-22, 6.3e-22, 6.32e-22, 6.34e-22, 6.36e-22, 6.38e-22, 6.4e-22, 6.42e-22, 6.43e-22, 6.45e-22, 8.39e-22, 8.54e-22, 8.59e-22, 8.67e-22, 8.77e-22, 8.86e-22, 8.95e-22, 9.05e-22, 9.14e-22, 9.23e-22, 9.32e-22, 9.41e-22, 9.49e-22, 9.58e-22, 9.67e-22, 9.74e-22, 9.74e-22]),
		ExplicitContinuum(j=60, i=47, wavelengthGrid=[4.313, 7.759, 10.461, 12.803, 14.917, 16.868, 18.694, 20.422, 22.069, 23.646, 25.164, 26.631, 28.052, 29.432, 30.775, 32.085, 33.364, 34.614, 35.84, 37.042, 38.22, 39.378, 40.516, 41.637, 42.739, 43.826, 44.896, 45.953, 46.994, 48.024, 49.04, 50.044, 51.036, 52.017, 52.987, 53.948, 54.898, 55.838, 56.771, 57.693, 58.607, 59.513, 60.411, 61.301, 62.184, 63.059, 63.928, 64.79, 65.645, 66.494, 67.335, 68.172, 69.002, 69.826, 70.645, 71.458, 72.266, 73.069, 73.866, 74.658, 75.446, 76.229, 77.007, 77.78, 78.549, 79.315, 80.075, 80.831, 81.584, 82.14872543705872], alphaGrid=[5.16e-24, 1.37e-23, 2.84e-23, 4.57e-23, 6.5e-23, 8.59e-23, 1.08e-22, 1.31e-22, 1.56e-22, 1.81e-22, 2.06e-22, 2.32e-22, 2.59e-22, 2.87e-22, 3.16e-22, 3.45e-22, 3.73e-22, 4.01e-22, 4.28e-22, 4.55e-22, 4.94e-22, 5.3e-22, 5.61e-22, 5.09e-22, 6.92e-22, 6.44e-22, 6.15e-22, 6.23e-22, 7.26e-22, 4.9e-22, 1.08e-21, 7.91e-22, 1.45e-21, 8.45e-22, 6.64e-22, 8.28e-22, 7.2e-22, 7.73e-22, 8.54e-22, 1.64e-21, 2.76e-21, 8.71e-22, 3.45e-22, 3.84e-22, 4.75e-22, 1.7e-22, 9.44e-23, 8.84e-23, 8.03e-23, 1.88e-22, 5.53e-23, 3.74e-23, 2.99e-22, 1.25e-21, 9.96e-23, 6.1e-23, 5.1e-23, 1.53e-22, 4.41e-22, 1.04e-22, 6.71e-23, 5.66e-23, 4.74e-23, 3.82e-23, 2.68e-23, 1.61e-23, 4.82e-21, 1.42e-21, 9.35e-23, 9.35e-23]),
		ExplicitContinuum(j=60, i=48, wavelengthGrid=[4.313, 7.759, 10.461, 12.803, 14.917, 16.868, 18.694, 20.422, 22.069, 23.646, 25.164, 26.631, 28.052, 29.432, 30.775, 32.085, 33.364, 34.614, 35.84, 37.042, 38.22, 39.378, 40.516, 41.637, 42.739, 43.826, 44.896, 45.953, 46.994, 48.024, 49.04, 50.044, 51.036, 52.017, 52.987, 53.948, 54.898, 55.838, 56.771, 57.693, 58.607, 59.513, 60.411, 61.301, 62.184, 63.059, 63.928, 64.79, 65.645, 66.494, 67.335, 68.172, 69.002, 69.826, 70.645, 71.458, 72.266, 73.069, 73.866, 74.658, 75.446, 76.229, 77.007, 77.78, 78.549, 79.315, 80.075, 80.831, 81.584, 82.15042607236329], alphaGrid=[5.16e-24, 1.37e-23, 2.84e-23, 4.57e-23, 6.5e-23, 8.59e-23, 1.08e-22, 1.31e-22, 1.56e-22, 1.81e-22, 2.06e-22, 2.32e-22, 2.59e-22, 2.87e-22, 3.16e-22, 3.45e-22, 3.73e-22, 4.01e-22, 4.28e-22, 4.55e-22, 4.94e-22, 5.3e-22, 5.61e-22, 5.09e-22, 6.92e-22, 6.44e-22, 6.15e-22, 6.23e-22, 7.26e-22, 4.9e-22, 1.08e-21, 7.91e-22, 1.45e-21, 8.45e-22, 6.64e-22, 8.28e-22, 7.2e-22, 7.73e-22, 8.54e-22, 1.64e-21, 2.76e-21, 8.71e-22, 3.45e-22, 3.84e-22, 4.75e-22, 1.7e-22, 9.44e-23, 8.84e-23, 8.03e-23, 1.88e-22, 5.53e-23, 3.74e-23, 2.99e-22, 1.25e-21, 9.96e-23, 6.1e-23, 5.1e-23, 1.53e-22, 4.41e-22, 1.04e-22, 6.71e-23, 5.66e-23, 4.74e-23, 3.82e-23, 2.68e-23, 1.61e-23, 4.82e-21, 1.42e-21, 9.35e-23, 9.35e-23]),
		ExplicitContinuum(j=60, i=49, wavelengthGrid=[4.647, 8.499, 11.606, 14.34, 16.834, 19.156, 21.343, 23.424, 25.415, 27.333, 29.184, 30.979, 32.723, 34.423, 36.081, 37.701, 39.288, 40.843, 42.37, 43.869, 45.342, 46.793, 48.221, 49.63, 51.018, 52.386, 53.738, 55.073, 56.391, 57.695, 58.983, 60.259, 61.521, 62.769, 64.006, 65.231, 66.444, 67.647, 68.839, 70.02, 71.191, 72.353, 73.506, 74.651, 75.786, 76.913, 78.032, 79.143, 80.244, 81.341, 82.428, 83.51, 84.583, 85.65, 86.711, 87.766, 88.813, 89.855, 90.891, 91.921, 92.944, 93.963, 94.976, 95.984, 96.986, 97.983, 98.975, 99.83348373913213], alphaGrid=[5.15e-24, 1.41e-23, 3.04e-23, 5.05e-23, 7.34e-23, 9.85e-23, 1.25e-22, 1.54e-22, 1.83e-22, 2.14e-22, 2.45e-22, 2.77e-22, 3.1e-22, 3.43e-22, 3.89e-22, 4.23e-22, 4.5e-22, 4.92e-22, 4.95e-22, 5.18e-22, 6.41e-22, 6.98e-22, 6.92e-22, 7.07e-22, 7.35e-22, 8.58e-22, 6.25e-22, 9.28e-22, 7.7e-22, 1.47e-21, 6.59e-22, 7.16e-22, 1.23e-21, 7.63e-22, 8.07e-22, 1.49e-21, 2.76e-21, 8.61e-22, 2.54e-22, 2.57e-22, 1.46e-22, 1.45e-22, 2.65e-22, 3.53e-23, 4.77e-24, 3.18e-23, 5.24e-22, 3.75e-24, 3.09e-22, 3.77e-22, 1.02e-20, 1.13e-21, 9.73e-23, 1.1e-23, 2.8e-23, 1.41e-21, 1.54e-21, 2.46e-22, 1.17e-22, 7.31e-23, 5.32e-23, 4.44e-23, 5.84e-23, 7.99e-21, 1.54e-24, 2.89e-24, 2.5e-24, 2.5e-24]),
		ExplicitContinuum(j=60, i=50, wavelengthGrid=[4.864, 9.018, 12.443, 15.493, 18.299, 20.929, 23.421, 25.803, 28.092, 30.302, 32.443, 34.524, 36.552, 38.533, 40.47, 42.366, 44.227, 46.054, 47.85, 49.617, 51.356, 53.072, 54.761, 56.43, 58.078, 59.704, 61.311, 62.901, 64.473, 66.028, 67.568, 69.092, 70.603, 72.098, 73.581, 75.052, 76.507, 77.954, 79.386, 80.808, 82.22, 83.62, 85.012, 86.392, 87.765, 89.127, 90.48, 91.823, 93.159, 94.486, 95.806, 97.118, 98.421, 99.717, 101.007, 102.288, 103.563, 104.831, 106.092, 107.347, 108.596, 109.837, 111.074, 112.305, 113.529, 114.747, 115.96, 116.22992343098083], alphaGrid=[6.73e-24, 1.88e-23, 4.08e-23, 6.82e-23, 9.99e-23, 1.36e-22, 1.75e-22, 2.17e-22, 2.62e-22, 3.1e-22, 3.62e-22, 4.24e-22, 4.89e-22, 5.42e-22, 6.12e-22, 6.61e-22, 6.79e-22, 7.26e-22, 8.45e-22, 9.21e-22, 7.49e-22, 1.45e-21, 1.03e-21, 1.14e-21, 1.97e-22, 2.05e-21, 6.53e-22, 5.96e-21, 1.44e-22, 2.19e-22, 7.16e-22, 4.03e-22, 6.21e-22, 3.95e-21, 1.06e-20, 1.33e-21, 1.5e-23, 2.45e-23, 6.99e-24, 2.85e-23, 6.58e-24, 1.17e-23, 7.66e-24, 6.34e-24, 2.25e-23, 2.41e-23, 6.32e-23, 1.67e-22, 4.13e-21, 5.26e-22, 6.06e-23, 2.25e-23, 1.14e-23, 4.65e-24, 5.36e-24, 6.16e-24, 4.75e-24, 4.07e-24, 3.79e-24, 3.76e-24, 4.41e-24, 1.09e-22, 1.34e-21, 3.07e-25, 7.39e-25, 9.44e-25, 1.03e-24, 1.03e-24]),
		ExplicitContinuum(j=60, i=51, wavelengthGrid=[4.864, 9.018, 12.443, 15.493, 18.299, 20.929, 23.421, 25.803, 28.092, 30.302, 32.443, 34.524, 36.552, 38.533, 40.47, 42.366, 44.227, 46.054, 47.85, 49.617, 51.356, 53.072, 54.761, 56.43, 58.078, 59.704, 61.311, 62.901, 64.473, 66.028, 67.568, 69.092, 70.603, 72.098, 73.581, 75.052, 76.507, 77.954, 79.386, 80.808, 82.22, 83.62, 85.012, 86.392, 87.765, 89.127, 90.48, 91.823, 93.159, 94.486, 95.806, 97.118, 98.421, 99.717, 101.007, 102.288, 103.563, 104.831, 106.092, 107.347, 108.596, 109.837, 111.074, 112.305, 113.529, 114.747, 115.96, 116.2858657297809], alphaGrid=[6.73e-24, 1.88e-23, 4.08e-23, 6.82e-23, 9.99e-23, 1.36e-22, 1.75e-22, 2.17e-22, 2.62e-22, 3.1e-22, 3.62e-22, 4.24e-22, 4.89e-22, 5.42e-22, 6.12e-22, 6.61e-22, 6.79e-22, 7.26e-22, 8.45e-22, 9.21e-22, 7.49e-22, 1.45e-21, 1.03e-21, 1.14e-21, 1.97e-22, 2.05e-21, 6.53e-22, 5.96e-21, 1.44e-22, 2.19e-22, 7.16e-22, 4.03e-22, 6.21e-22, 3.95e-21, 1.06e-20, 1.33e-21, 1.5e-23, 2.45e-23, 6.99e-24, 2.85e-23, 6.58e-24, 1.17e-23, 7.66e-24, 6.34e-24, 2.25e-23, 2.41e-23, 6.32e-23, 1.67e-22, 4.13e-21, 5.26e-22, 6.06e-23, 2.25e-23, 1.14e-23, 4.65e-24, 5.36e-24, 6.16e-24, 4.75e-24, 4.07e-24, 3.79e-24, 3.76e-24, 4.41e-24, 1.09e-22, 1.34e-21, 3.07e-25, 7.39e-25, 9.44e-25, 1.03e-24, 1.03e-24]),
		ExplicitContinuum(j=60, i=52, wavelengthGrid=[7.171, 10.977, 14.294, 17.315, 20.132, 22.794, 25.333, 27.77, 30.121, 32.4, 34.613, 36.769, 38.874, 40.933, 42.951, 44.929, 46.873, 48.782, 50.662, 52.514, 54.338, 56.139, 57.914, 59.669, 61.402, 63.115, 64.809, 66.485, 68.142, 69.784, 71.411, 73.021, 74.618, 76.201, 77.768, 79.325, 80.868, 82.398, 83.919, 85.427, 86.925, 88.411, 89.888, 91.354, 92.811, 94.257, 95.696, 97.125, 98.546, 99.959, 101.363, 102.759, 104.148, 105.527, 106.9, 108.267, 109.625, 110.977, 112.323, 113.662, 114.993, 116.318, 117.637, 118.951, 120.259, 121.561, 122.855, 124.146, 124.80828822886602], alphaGrid=[8.21e-25, 1.98e-24, 4.35e-24, 7.72e-24, 1.21e-23, 1.76e-23, 2.41e-23, 3.18e-23, 4.06e-23, 5.05e-23, 5.85e-23, 6.41e-23, 7.26e-23, 8.09e-23, 8.73e-23, 8.68e-23, 9.44e-23, 1.14e-22, 1.27e-22, 1.18e-22, 1.23e-22, 1.29e-22, 1.51e-22, 1.65e-22, 1.42e-22, 2.35e-22, 1.96e-22, 1.11e-22, 1.44e-22, 1.69e-22, 1.35e-22, 1.65e-22, 4.74e-22, 1.13e-22, 1.19e-22, 3.47e-23, 5.09e-23, 3.65e-23, 6.31e-23, 4.04e-23, 2.47e-23, 1.91e-23, 2e-23, 8.5e-23, 8.73e-24, 1.83e-22, 3.74e-22, 2.64e-20, 8.04e-21, 1.12e-21, 5.85e-22, 3.97e-22, 2.57e-22, 1.44e-22, 2.89e-22, 2.72e-22, 2.54e-22, 2.36e-22, 2.18e-22, 1.99e-22, 1.8e-22, 1.04e-21, 2.47e-22, 2.17e-22, 2.13e-22, 2.1e-22, 2.07e-22, 2.04e-22, 2.04e-22]),
		ExplicitContinuum(j=60, i=53, wavelengthGrid=[5.537, 10.094, 14.034, 17.64, 21.013, 24.22, 27.29, 30.253, 33.123, 35.914, 38.635, 41.294, 43.897, 46.452, 48.962, 51.429, 53.858, 56.254, 58.615, 60.945, 63.245, 65.521, 67.77, 69.994, 72.196, 74.374, 76.535, 78.674, 80.793, 82.896, 84.981, 87.049, 89.102, 91.138, 93.16, 95.169, 97.164, 99.144, 101.111, 103.067, 105.01, 106.941, 108.86, 110.769, 112.668, 114.556, 116.435, 118.303, 120.161, 122.009, 123.849, 125.68, 127.501, 129.315, 131.121, 132.918, 134.707, 136.489, 138.264, 140.029, 141.789, 143.541, 145.287, 147.025, 148.755, 150.481, 152.199, 153.913, 153.99739350171646], alphaGrid=[3.26e-25, 1.14e-24, 2.96e-24, 5.58e-24, 8.87e-24, 1.28e-23, 1.72e-23, 2.21e-23, 2.75e-23, 3.31e-23, 3.86e-23, 4.56e-23, 5.28e-23, 5.98e-23, 6.67e-23, 7.28e-23, 8.24e-23, 8.64e-23, 9.57e-23, 1.25e-22, 1.08e-22, 1.19e-22, 1.27e-22, 1.35e-22, 1.6e-22, 2.09e-22, 3.18e-22, 2.08e-22, 2.1e-22, 2.13e-22, 2.35e-22, 2.65e-22, 3.27e-22, 3.71e-22, 7.46e-22, 3.08e-21, 1.46e-21, 1.33e-20, 1.35e-22, 1.01e-21, 2.87e-22, 2.76e-22, 2.71e-22, 2.67e-22, 2.68e-22, 3.8e-22, 2.37e-22, 9.89e-22, 4.06e-22, 4.07e-22, 4.1e-22, 4.12e-22, 4.14e-22, 4.16e-22, 4.18e-22, 4.21e-22, 4.23e-22, 4.25e-22, 4.27e-22, 4.29e-22, 4.32e-22, 4.34e-22, 4.36e-22, 4.38e-22, 4.4e-22, 4.42e-22, 4.44e-22, 4.47e-22, 4.47e-22]),
		ExplicitContinuum(j=60, i=54, wavelengthGrid=[5.537, 10.094, 14.034, 17.64, 21.013, 24.22, 27.29, 30.253, 33.123, 35.914, 38.635, 41.294, 43.897, 46.452, 48.962, 51.429, 53.858, 56.254, 58.615, 60.945, 63.245, 65.521, 67.77, 69.994, 72.196, 74.374, 76.535, 78.674, 80.793, 82.896, 84.981, 87.049, 89.102, 91.138, 93.16, 95.169, 97.164, 99.144, 101.111, 103.067, 105.01, 106.941, 108.86, 110.769, 112.668, 114.556, 116.435, 118.303, 120.161, 122.009, 123.849, 125.68, 127.501, 129.315, 131.121, 132.918, 134.707, 136.489, 138.264, 140.029, 141.789, 143.541, 145.287, 147.025, 148.755, 150.481, 152.199, 153.913, 154.02384048773558], alphaGrid=[3.26e-25, 1.14e-24, 2.96e-24, 5.58e-24, 8.87e-24, 1.28e-23, 1.72e-23, 2.21e-23, 2.75e-23, 3.31e-23, 3.86e-23, 4.56e-23, 5.28e-23, 5.98e-23, 6.67e-23, 7.28e-23, 8.24e-23, 8.64e-23, 9.57e-23, 1.25e-22, 1.08e-22, 1.19e-22, 1.27e-22, 1.35e-22, 1.6e-22, 2.09e-22, 3.18e-22, 2.08e-22, 2.1e-22, 2.13e-22, 2.35e-22, 2.65e-22, 3.27e-22, 3.71e-22, 7.46e-22, 3.08e-21, 1.46e-21, 1.33e-20, 1.35e-22, 1.01e-21, 2.87e-22, 2.76e-22, 2.71e-22, 2.67e-22, 2.68e-22, 3.8e-22, 2.37e-22, 9.89e-22, 4.06e-22, 4.07e-22, 4.1e-22, 4.12e-22, 4.14e-22, 4.16e-22, 4.18e-22, 4.21e-22, 4.23e-22, 4.25e-22, 4.27e-22, 4.29e-22, 4.32e-22, 4.34e-22, 4.36e-22, 4.38e-22, 4.4e-22, 4.42e-22, 4.44e-22, 4.47e-22, 4.47e-22]),
		ExplicitContinuum(j=60, i=55, wavelengthGrid=[5.581, 9.01, 11.842, 14.351, 16.643, 18.779, 20.793, 22.708, 24.541, 26.303, 28.005, 29.653, 31.254, 32.813, 34.334, 35.819, 37.272, 38.695, 40.093, 41.463, 42.81, 44.135, 45.441, 46.725, 47.991, 49.239, 50.473, 51.689, 52.891, 54.077, 55.251, 56.41, 57.558, 58.694, 59.818, 60.932, 62.033, 63.126, 64.208, 65.281, 66.344, 67.398, 68.443, 69.48, 70.509, 71.53, 72.544, 73.55, 74.548, 75.54, 76.524, 77.502, 78.474, 79.439, 80.398, 81.35, 82.298, 83.239, 84.175, 85.105, 86.029, 86.949, 87.863, 88.773, 89.677, 90.576, 91.472, 92.362, 93.248, 94.128, 95.006, 95.879, 96.746, 97.611, 98.471, 183.0381008083804], alphaGrid=[4.46e-24, 1.3e-23, 3.07e-23, 5.46e-23, 8.39e-23, 1.18e-22, 1.55e-22, 1.96e-22, 2.39e-22, 2.85e-22, 3.33e-22, 3.83e-22, 4.34e-22, 4.86e-22, 5.4e-22, 5.96e-22, 6.54e-22, 7.14e-22, 7.72e-22, 8.29e-22, 8.9e-22, 9.52e-22, 1.01e-21, 1.07e-21, 1.13e-21, 1.19e-21, 1.25e-21, 1.31e-21, 1.6e-21, 1.5e-21, 3.23e-21, 9e-23, 4.13e-21, 1.2e-22, 2.43e-23, 1.17e-20, 9.43e-23, 1.97e-23, 1.73e-23, 8.8e-22, 8.47e-24, 1.02e-23, 2.9e-23, 1.52e-22, 3.27e-20, 7.55e-22, 1.21e-22, 5.94e-23, 3.66e-23, 2.72e-23, 2.18e-23, 1.75e-23, 1.59e-23, 1.43e-23, 1.32e-23, 1.35e-23, 1.38e-23, 1.42e-23, 1.61e-23, 2.07e-23, 2.98e-23, 6.37e-23, 1.6e-21, 1.69e-21, 2.72e-23, 5.57e-24, 1.66e-24, 5.33e-25, 1.57e-25, 3.26e-26, 2.06e-27, 8.53e-27, 2.78e-26, 4.93e-26, 6.65e-26, 6.65e-26]),
		ExplicitContinuum(j=60, i=56, wavelengthGrid=[5.605, 10.673, 15.338, 19.765, 24.026, 28.156, 32.187, 36.129, 39.998, 43.802, 47.55, 51.25, 54.899, 58.512, 62.084, 65.619, 69.125, 72.599, 76.042, 79.46, 82.853, 86.22, 89.568, 92.891, 96.195, 99.478, 102.745, 105.991, 109.222, 112.435, 115.633, 118.816, 121.985, 125.139, 128.278, 131.407, 134.52, 137.619, 140.711, 143.788, 146.854, 149.909, 152.953, 155.986, 159.012, 162.026, 165.03, 168.023, 171.008, 173.986, 176.953, 179.913, 182.861, 185.806, 188.74, 191.667, 194.583, 197.495, 200.399, 203.297, 206.183, 209.066, 211.941, 214.809, 216.4551171439942], alphaGrid=[4.94e-24, 2.1e-23, 6.11e-23, 1.22e-22, 2.01e-22, 2.94e-22, 3.99e-22, 5.14e-22, 6.41e-22, 7.71e-22, 8.99e-22, 1.03e-21, 1.12e-21, 1e-21, 1.65e-21, 9.94e-22, 1.78e-21, 4.29e-21, 1.29e-21, 4.6e-22, 4.81e-22, 1.18e-21, 1.39e-21, 7.17e-22, 3.34e-22, 2.89e-22, 2.61e-22, 2.23e-22, 1.65e-23, 2.01e-23, 5.76e-25, 3.91e-24, 1.01e-22, 4.11e-24, 6.33e-23, 3.19e-25, 2.9e-25, 5.94e-25, 1.55e-24, 3.41e-24, 1.83e-24, 6.98e-24, 2.28e-22, 1.8e-24, 9.6e-26, 4.67e-27, 3.81e-26, 8.7e-26, 1.36e-25, 1.85e-25, 2.34e-25, 2.82e-25, 3.32e-25, 3.88e-25, 4.46e-25, 5.04e-25, 5.61e-25, 6.18e-25, 6.75e-25, 7.32e-25, 8.09e-25, 9.11e-25, 1.02e-24, 1.12e-24, 1.12e-24]),
		ExplicitContinuum(j=60, i=57, wavelengthGrid=[5.605, 10.673, 15.338, 19.765, 24.026, 28.156, 32.187, 36.129, 39.998, 43.802, 47.55, 51.25, 54.899, 58.512, 62.084, 65.619, 69.125, 72.599, 76.042, 79.46, 82.853, 86.22, 89.568, 92.891, 96.195, 99.478, 102.745, 105.991, 109.222, 112.435, 115.633, 118.816, 121.985, 125.139, 128.278, 131.407, 134.52, 137.619, 140.711, 143.788, 146.854, 149.909, 152.953, 155.986, 159.012, 162.026, 165.03, 168.023, 171.008, 173.986, 176.953, 179.913, 182.861, 185.806, 188.74, 191.667, 194.583, 197.495, 200.399, 203.297, 206.183, 209.066, 211.941, 214.809, 216.47906158231805], alphaGrid=[4.94e-24, 2.1e-23, 6.11e-23, 1.22e-22, 2.01e-22, 2.94e-22, 3.99e-22, 5.14e-22, 6.41e-22, 7.71e-22, 8.99e-22, 1.03e-21, 1.12e-21, 1e-21, 1.65e-21, 9.94e-22, 1.78e-21, 4.29e-21, 1.29e-21, 4.6e-22, 4.81e-22, 1.18e-21, 1.39e-21, 7.17e-22, 3.34e-22, 2.89e-22, 2.61e-22, 2.23e-22, 1.65e-23, 2.01e-23, 5.76e-25, 3.91e-24, 1.01e-22, 4.11e-24, 6.33e-23, 3.19e-25, 2.9e-25, 5.94e-25, 1.55e-24, 3.41e-24, 1.83e-24, 6.98e-24, 2.28e-22, 1.8e-24, 9.6e-26, 4.67e-27, 3.81e-26, 8.7e-26, 1.36e-25, 1.85e-25, 2.34e-25, 2.82e-25, 3.32e-25, 3.88e-25, 4.46e-25, 5.04e-25, 5.61e-25, 6.18e-25, 6.75e-25, 7.32e-25, 8.09e-25, 9.11e-25, 1.02e-24, 1.12e-24, 1.12e-24]),
		ExplicitContinuum(j=60, i=58, wavelengthGrid=[8.714, 13.731, 18.868, 24.1, 29.4, 34.767, 40.18, 45.641, 51.143, 56.685, 62.253, 67.863, 73.492, 79.155, 84.845, 90.555, 96.285, 102.043, 107.82, 113.611, 119.422, 125.253, 131.105, 136.97, 142.849, 148.747, 154.653, 160.578, 166.517, 172.47, 178.429, 184.409, 190.395, 196.395, 202.408, 208.434, 214.468, 220.515, 226.568, 232.635, 238.709, 244.789, 250.883, 256.991, 263.105, 269.226, 275.354, 281.495, 287.643, 293.797, 299.958, 306.133, 312.315, 318.496, 324.691, 330.893, 337.101, 343.323, 349.545, 355.774, 358.0250820915705], alphaGrid=[4.84e-24, 1.29e-23, 3.3e-23, 6.83e-23, 1.23e-22, 2.04e-22, 3.1e-22, 4.03e-22, 4.8e-22, 5.58e-22, 9.09e-22, 5.87e-22, 4.86e-22, 1.09e-21, 6.23e-22, 1.06e-21, 1.81e-22, 1.93e-21, 2.82e-21, 1.33e-21, 5.49e-22, 4.06e-22, 3.23e-22, 3.93e-23, 2.69e-23, 2.47e-23, 4.21e-22, 7.26e-24, 2.06e-23, 1.15e-22, 2.09e-23, 2.05e-23, 1.8e-23, 2.87e-23, 6.56e-23, 5.62e-23, 1.62e-22, 5.55e-23, 5.1e-23, 5.25e-23, 5.63e-23, 6.01e-23, 6.38e-23, 6.76e-23, 7.14e-23, 7.59e-23, 8.22e-23, 8.86e-23, 9.5e-23, 1.01e-22, 1.08e-22, 1.16e-22, 1.26e-22, 1.37e-22, 1.48e-22, 1.58e-22, 1.69e-22, 1.8e-22, 1.93e-22, 2.14e-22, 2.14e-22]),
		ExplicitContinuum(j=60, i=59, wavelengthGrid=[8.714, 13.731, 18.868, 24.1, 29.4, 34.767, 40.18, 45.641, 51.143, 56.685, 62.253, 67.863, 73.492, 79.155, 84.845, 90.555, 96.285, 102.043, 107.82, 113.611, 119.422, 125.253, 131.105, 136.97, 142.849, 148.747, 154.653, 160.578, 166.517, 172.47, 178.429, 184.409, 190.395, 196.395, 202.408, 208.434, 214.468, 220.515, 226.568, 232.635, 238.709, 244.789, 250.883, 256.991, 263.105, 269.226, 275.354, 281.495, 287.643, 293.797, 299.958, 306.133, 312.315, 318.496, 324.691, 330.893, 337.101, 343.323, 349.545, 355.774, 358.265841422797], alphaGrid=[4.84e-24, 1.29e-23, 3.3e-23, 6.83e-23, 1.23e-22, 2.04e-22, 3.1e-22, 4.03e-22, 4.8e-22, 5.58e-22, 9.09e-22, 5.87e-22, 4.86e-22, 1.09e-21, 6.23e-22, 1.06e-21, 1.81e-22, 1.93e-21, 2.82e-21, 1.33e-21, 5.49e-22, 4.06e-22, 3.23e-22, 3.93e-23, 2.69e-23, 2.47e-23, 4.21e-22, 7.26e-24, 2.06e-23, 1.15e-22, 2.09e-23, 2.05e-23, 1.8e-23, 2.87e-23, 6.56e-23, 5.62e-23, 1.62e-22, 5.55e-23, 5.1e-23, 5.25e-23, 5.63e-23, 6.01e-23, 6.38e-23, 6.76e-23, 7.14e-23, 7.59e-23, 8.22e-23, 8.86e-23, 9.5e-23, 1.01e-22, 1.08e-22, 1.16e-22, 1.26e-22, 1.37e-22, 1.48e-22, 1.58e-22, 1.69e-22, 1.8e-22, 1.93e-22, 2.14e-22, 2.14e-22]),
		ExplicitContinuum(j=80, i=60, wavelengthGrid=[0.912, 2.869, 4.021, 4.936, 5.721, 6.422, 7.06, 7.652, 8.206, 8.73, 9.226, 9.701, 10.156, 10.594, 11.016, 11.425, 11.821, 12.206, 12.581, 12.946, 13.302, 13.65, 13.991, 14.324, 14.65, 14.971, 15.285, 15.594, 15.898, 16.197, 16.49, 16.78, 17.065, 17.346, 17.622, 17.896, 18.165, 18.432, 18.694, 18.954, 19.21, 19.464, 19.715, 19.963, 20.208, 20.451, 20.691, 20.928, 21.164, 21.397, 21.628, 21.857, 22.083, 22.308, 22.531, 22.752, 22.971, 23.188, 23.403, 23.617, 23.829, 24.039, 24.248, 24.455, 24.661, 24.865, 25.068, 25.269, 25.468, 25.667, 25.864, 25.89120679572512], alphaGrid=[7.85e-24, 3.23e-23, 2.94e-24, 5.05e-24, 7.87e-24, 1.11e-23, 1.48e-23, 1.81e-23, 2.14e-23, 2.45e-23, 2.75e-23, 3.03e-23, 3.31e-23, 3.59e-23, 3.86e-23, 4.14e-23, 4.43e-23, 4.71e-23, 4.98e-23, 5.25e-23, 5.51e-23, 5.77e-23, 6.02e-23, 6.37e-23, 6.55e-23, 6.82e-23, 7.18e-23, 7.26e-23, 7.24e-23, 7.81e-23, 8.56e-23, 8.72e-23, 8.39e-23, 8.61e-23, 8.78e-23, 8.84e-23, 8.21e-23, 1.07e-22, 1.05e-22, 1.05e-22, 1.07e-22, 1.09e-22, 1.11e-22, 1.13e-22, 1.15e-22, 1.16e-22, 1.18e-22, 1.2e-22, 1.22e-22, 1.23e-22, 1.25e-22, 1.27e-22, 1.29e-22, 1.3e-22, 1.34e-22, 1.5e-22, 1.27e-22, 1.48e-22, 1.19e-22, 1.65e-22, 1.13e-22, 1.32e-22, 1.83e-22, 1.62e-22, 8.9e-23, 1.49e-22, 1.43e-22, 1.34e-22, 8.9e-23, 3.19e-22, 1.8e-22, 1.8e-22]),
		ExplicitContinuum(j=80, i=61, wavelengthGrid=[2.472, 3.932, 5.04, 5.976, 6.805, 7.559, 8.255, 8.907, 9.521, 10.105, 10.662, 11.197, 11.711, 12.207, 12.688, 13.154, 13.607, 14.048, 14.477, 14.897, 15.307, 15.709, 16.102, 16.487, 16.865, 17.237, 17.602, 17.961, 18.314, 18.661, 19.004, 19.341, 19.674, 20.002, 20.326, 20.646, 20.961, 21.273, 21.581, 21.886, 22.187, 22.485, 22.779, 23.071, 23.359, 23.645, 23.928, 24.208, 24.486, 24.761, 25.033, 25.303, 25.571, 25.836, 26.1, 26.361, 26.62, 26.877, 27.132, 27.385, 27.636, 27.885, 28.133, 28.378, 28.622, 28.865, 29.105, 29.344, 29.582, 29.818, 29.952275182910014], alphaGrid=[6.79e-25, 1.7e-24, 3.59e-24, 5.99e-24, 8.85e-24, 1.21e-23, 1.53e-23, 1.84e-23, 2.14e-23, 2.43e-23, 2.73e-23, 3.03e-23, 3.36e-23, 3.71e-23, 4.05e-23, 4.39e-23, 4.74e-23, 5.09e-23, 5.43e-23, 5.76e-23, 6.08e-23, 6.41e-23, 6.82e-23, 7.12e-23, 7.47e-23, 7.75e-23, 8.21e-23, 8.81e-23, 9.03e-23, 9.25e-23, 9.69e-23, 9.92e-23, 9.82e-23, 1.16e-22, 1.17e-22, 1.21e-22, 1.24e-22, 1.27e-22, 1.3e-22, 1.34e-22, 1.38e-22, 1.42e-22, 1.46e-22, 1.5e-22, 1.55e-22, 1.59e-22, 1.63e-22, 1.67e-22, 1.71e-22, 1.75e-22, 1.79e-22, 1.83e-22, 1.84e-22, 1.49e-22, 1.52e-22, 1.48e-22, 1.67e-22, 1.51e-22, 1.91e-22, 1.69e-22, 1.65e-22, 1.6e-22, 7.68e-22, 2e-22, 1.93e-22, 1.93e-22, 1.93e-22, 1.94e-22, 1.92e-22, 1.96e-22, 1.96e-22]),
		ExplicitContinuum(j=80, i=62, wavelengthGrid=[2.472, 3.932, 5.04, 5.976, 6.805, 7.559, 8.255, 8.907, 9.521, 10.105, 10.662, 11.197, 11.711, 12.207, 12.688, 13.154, 13.607, 14.048, 14.477, 14.897, 15.307, 15.709, 16.102, 16.487, 16.865, 17.237, 17.602, 17.961, 18.314, 18.661, 19.004, 19.341, 19.674, 20.002, 20.326, 20.646, 20.961, 21.273, 21.581, 21.886, 22.187, 22.485, 22.779, 23.071, 23.359, 23.645, 23.928, 24.208, 24.486, 24.761, 25.033, 25.303, 25.571, 25.836, 26.1, 26.361, 26.62, 26.877, 27.132, 27.385, 27.636, 27.885, 28.133, 28.378, 28.622, 28.865, 29.105, 29.344, 29.582, 29.818, 29.954400655517315], alphaGrid=[6.79e-25, 1.7e-24, 3.59e-24, 5.99e-24, 8.85e-24, 1.21e-23, 1.53e-23, 1.84e-23, 2.14e-23, 2.43e-23, 2.73e-23, 3.03e-23, 3.36e-23, 3.71e-23, 4.05e-23, 4.39e-23, 4.74e-23, 5.09e-23, 5.43e-23, 5.76e-23, 6.08e-23, 6.41e-23, 6.82e-23, 7.12e-23, 7.47e-23, 7.75e-23, 8.21e-23, 8.81e-23, 9.03e-23, 9.25e-23, 9.69e-23, 9.92e-23, 9.82e-23, 1.16e-22, 1.17e-22, 1.21e-22, 1.24e-22, 1.27e-22, 1.3e-22, 1.34e-22, 1.38e-22, 1.42e-22, 1.46e-22, 1.5e-22, 1.55e-22, 1.59e-22, 1.63e-22, 1.67e-22, 1.71e-22, 1.75e-22, 1.79e-22, 1.83e-22, 1.84e-22, 1.49e-22, 1.52e-22, 1.48e-22, 1.67e-22, 1.51e-22, 1.91e-22, 1.69e-22, 1.65e-22, 1.6e-22, 7.68e-22, 2e-22, 1.93e-22, 1.93e-22, 1.93e-22, 1.94e-22, 1.92e-22, 1.96e-22, 1.96e-22]),
		ExplicitContinuum(j=80, i=63, wavelengthGrid=[2.472, 3.932, 5.04, 5.976, 6.805, 7.559, 8.255, 8.907, 9.521, 10.105, 10.662, 11.197, 11.711, 12.207, 12.688, 13.154, 13.607, 14.048, 14.477, 14.897, 15.307, 15.709, 16.102, 16.487, 16.865, 17.237, 17.602, 17.961, 18.314, 18.661, 19.004, 19.341, 19.674, 20.002, 20.326, 20.646, 20.961, 21.273, 21.581, 21.886, 22.187, 22.485, 22.779, 23.071, 23.359, 23.645, 23.928, 24.208, 24.486, 24.761, 25.033, 25.303, 25.571, 25.836, 26.1, 26.361, 26.62, 26.877, 27.132, 27.385, 27.636, 27.885, 28.133, 28.378, 28.622, 28.865, 29.105, 29.344, 29.582, 29.818, 29.959458501242622], alphaGrid=[6.79e-25, 1.7e-24, 3.59e-24, 5.99e-24, 8.85e-24, 1.21e-23, 1.53e-23, 1.84e-23, 2.14e-23, 2.43e-23, 2.73e-23, 3.03e-23, 3.36e-23, 3.71e-23, 4.05e-23, 4.39e-23, 4.74e-23, 5.09e-23, 5.43e-23, 5.76e-23, 6.08e-23, 6.41e-23, 6.82e-23, 7.12e-23, 7.47e-23, 7.75e-23, 8.21e-23, 8.81e-23, 9.03e-23, 9.25e-23, 9.69e-23, 9.92e-23, 9.82e-23, 1.16e-22, 1.17e-22, 1.21e-22, 1.24e-22, 1.27e-22, 1.3e-22, 1.34e-22, 1.38e-22, 1.42e-22, 1.46e-22, 1.5e-22, 1.55e-22, 1.59e-22, 1.63e-22, 1.67e-22, 1.71e-22, 1.75e-22, 1.79e-22, 1.83e-22, 1.84e-22, 1.49e-22, 1.52e-22, 1.48e-22, 1.67e-22, 1.51e-22, 1.91e-22, 1.69e-22, 1.65e-22, 1.6e-22, 7.68e-22, 2e-22, 1.93e-22, 1.93e-22, 1.93e-22, 1.94e-22, 1.92e-22, 1.96e-22, 1.96e-22]),
		ExplicitContinuum(j=80, i=64, wavelengthGrid=[2.743, 4.372, 5.633, 6.709, 7.669, 8.546, 9.36, 10.125, 10.848, 11.536, 12.195, 12.829, 13.44, 14.03, 14.603, 15.159, 15.7, 16.228, 16.743, 17.247, 17.739, 18.222, 18.695, 19.16, 19.616, 20.063, 20.505, 20.938, 21.366, 21.786, 22.201, 22.611, 23.014, 23.413, 23.806, 24.195, 24.579, 24.959, 25.334, 25.705, 26.072, 26.435, 26.795, 27.151, 27.504, 27.853, 28.199, 28.542, 28.881, 29.218, 29.552, 29.883, 30.211, 30.537, 30.861, 31.181, 31.499, 31.815, 32.128, 32.439, 32.748, 33.055, 33.36, 33.662, 33.963, 34.261, 34.558, 34.853, 35.145, 35.226217165669404], alphaGrid=[8.08e-25, 2.04e-24, 4.38e-24, 7.4e-24, 1.11e-23, 1.53e-23, 1.94e-23, 2.3e-23, 2.65e-23, 3.04e-23, 3.45e-23, 3.86e-23, 4.3e-23, 4.72e-23, 5.14e-23, 5.59e-23, 6.05e-23, 6.49e-23, 6.9e-23, 7.46e-23, 7.96e-23, 8.38e-23, 9.05e-23, 9.7e-23, 1e-22, 1.02e-22, 1.07e-22, 1.01e-22, 9.74e-23, 1.82e-22, 1.46e-22, 1.43e-22, 1.46e-22, 1.49e-22, 1.54e-22, 1.58e-22, 1.62e-22, 1.67e-22, 1.71e-22, 1.76e-22, 1.8e-22, 1.86e-22, 1.91e-22, 1.97e-22, 2.02e-22, 2.07e-22, 2.13e-22, 2.18e-22, 2.23e-22, 2.28e-22, 2.05e-22, 2.67e-22, 2.99e-22, 1.3e-22, 4.48e-22, 1.41e-22, 6.52e-22, 1.5e-22, 1.46e-22, 1.59e-22, 8.29e-22, 1.88e-22, 1.7e-22, 1.68e-22, 1.68e-22, 1.68e-22, 1.69e-22, 1.98e-22, 1.15e-22, 1.15e-22]),
		ExplicitContinuum(j=80, i=65, wavelengthGrid=[3.43, 5.076, 6.411, 7.574, 8.624, 9.592, 10.496, 11.348, 12.158, 12.933, 13.676, 14.392, 15.084, 15.754, 16.406, 17.04, 17.657, 18.26, 18.85, 19.427, 19.992, 20.546, 21.091, 21.625, 22.15, 22.668, 23.176, 23.677, 24.171, 24.658, 25.139, 25.613, 26.081, 26.543, 26.999, 27.451, 27.897, 28.338, 28.775, 29.207, 29.635, 30.058, 30.477, 30.893, 31.305, 31.712, 32.116, 32.517, 32.914, 33.308, 33.698, 34.086, 34.471, 34.852, 35.231, 35.606, 35.98, 36.35, 36.717, 37.083, 37.446, 37.806, 38.164, 38.519, 38.873, 39.224, 39.573, 39.92, 40.1919868319476], alphaGrid=[8.03e-25, 1.78e-24, 3.6e-24, 5.93e-24, 8.98e-24, 1.28e-23, 1.69e-23, 2.12e-23, 2.6e-23, 3.13e-23, 3.73e-23, 4.35e-23, 5.01e-23, 5.67e-23, 6.38e-23, 7.12e-23, 7.86e-23, 8.64e-23, 9.45e-23, 1.06e-22, 1.12e-22, 1.23e-22, 1.31e-22, 1.38e-22, 1.45e-22, 1.44e-22, 1.97e-22, 1.98e-22, 2.01e-22, 2.11e-22, 2.21e-22, 2.31e-22, 2.41e-22, 2.51e-22, 2.63e-22, 2.75e-22, 2.87e-22, 2.99e-22, 3.11e-22, 3.22e-22, 3.34e-22, 3.45e-22, 3.59e-22, 3.73e-22, 3.87e-22, 4.01e-22, 4.14e-22, 4.28e-22, 4.41e-22, 2.34e-22, 1.5e-22, 2.19e-23, 2.25e-22, 3.81e-24, 3.73e-22, 3.2e-23, 1.87e-24, 8.91e-24, 7.58e-22, 4.94e-23, 2.19e-23, 9.23e-23, 1.02e-24, 1.95e-24, 4.08e-24, 9.36e-24, 2.91e-23, 7.19e-22, 7.19e-22]),
		ExplicitContinuum(j=80, i=66, wavelengthGrid=[3.43, 5.076, 6.411, 7.574, 8.624, 9.592, 10.496, 11.348, 12.158, 12.933, 13.676, 14.392, 15.084, 15.754, 16.406, 17.04, 17.657, 18.26, 18.85, 19.427, 19.992, 20.546, 21.091, 21.625, 22.15, 22.668, 23.176, 23.677, 24.171, 24.658, 25.139, 25.613, 26.081, 26.543, 26.999, 27.451, 27.897, 28.338, 28.775, 29.207, 29.635, 30.058, 30.477, 30.893, 31.305, 31.712, 32.116, 32.517, 32.914, 33.308, 33.698, 34.086, 34.471, 34.852, 35.231, 35.606, 35.98, 36.35, 36.717, 37.083, 37.446, 37.806, 38.164, 38.519, 38.873, 39.224, 39.573, 39.92, 40.19662355275977], alphaGrid=[8.03e-25, 1.78e-24, 3.6e-24, 5.93e-24, 8.98e-24, 1.28e-23, 1.69e-23, 2.12e-23, 2.6e-23, 3.13e-23, 3.73e-23, 4.35e-23, 5.01e-23, 5.67e-23, 6.38e-23, 7.12e-23, 7.86e-23, 8.64e-23, 9.45e-23, 1.06e-22, 1.12e-22, 1.23e-22, 1.31e-22, 1.38e-22, 1.45e-22, 1.44e-22, 1.97e-22, 1.98e-22, 2.01e-22, 2.11e-22, 2.21e-22, 2.31e-22, 2.41e-22, 2.51e-22, 2.63e-22, 2.75e-22, 2.87e-22, 2.99e-22, 3.11e-22, 3.22e-22, 3.34e-22, 3.45e-22, 3.59e-22, 3.73e-22, 3.87e-22, 4.01e-22, 4.14e-22, 4.28e-22, 4.41e-22, 2.34e-22, 1.5e-22, 2.19e-23, 2.25e-22, 3.81e-24, 3.73e-22, 3.2e-23, 1.87e-24, 8.91e-24, 7.58e-22, 4.94e-23, 2.19e-23, 9.23e-23, 1.02e-24, 1.95e-24, 4.08e-24, 9.36e-24, 2.91e-23, 7.19e-22, 7.19e-22]),
		ExplicitContinuum(j=80, i=67, wavelengthGrid=[3.43, 5.076, 6.411, 7.574, 8.624, 9.592, 10.496, 11.348, 12.158, 12.933, 13.676, 14.392, 15.084, 15.754, 16.406, 17.04, 17.657, 18.26, 18.85, 19.427, 19.992, 20.546, 21.091, 21.625, 22.15, 22.668, 23.176, 23.677, 24.171, 24.658, 25.139, 25.613, 26.081, 26.543, 26.999, 27.451, 27.897, 28.338, 28.775, 29.207, 29.635, 30.058, 30.477, 30.893, 31.305, 31.712, 32.116, 32.517, 32.914, 33.308, 33.698, 34.086, 34.471, 34.852, 35.231, 35.606, 35.98, 36.35, 36.717, 37.083, 37.446, 37.806, 38.164, 38.519, 38.873, 39.224, 39.573, 39.92, 40.204317699278654], alphaGrid=[8.03e-25, 1.78e-24, 3.6e-24, 5.93e-24, 8.98e-24, 1.28e-23, 1.69e-23, 2.12e-23, 2.6e-23, 3.13e-23, 3.73e-23, 4.35e-23, 5.01e-23, 5.67e-23, 6.38e-23, 7.12e-23, 7.86e-23, 8.64e-23, 9.45e-23, 1.06e-22, 1.12e-22, 1.23e-22, 1.31e-22, 1.38e-22, 1.45e-22, 1.44e-22, 1.97e-22, 1.98e-22, 2.01e-22, 2.11e-22, 2.21e-22, 2.31e-22, 2.41e-22, 2.51e-22, 2.63e-22, 2.75e-22, 2.87e-22, 2.99e-22, 3.11e-22, 3.22e-22, 3.34e-22, 3.45e-22, 3.59e-22, 3.73e-22, 3.87e-22, 4.01e-22, 4.14e-22, 4.28e-22, 4.41e-22, 2.34e-22, 1.5e-22, 2.19e-23, 2.25e-22, 3.81e-24, 3.73e-22, 3.2e-23, 1.87e-24, 8.91e-24, 7.58e-22, 4.94e-23, 2.19e-23, 9.23e-23, 1.02e-24, 1.95e-24, 4.08e-24, 9.36e-24, 2.91e-23, 7.19e-22, 7.19e-22]),
		ExplicitContinuum(j=80, i=68, wavelengthGrid=[3.453, 5.149, 6.524, 7.723, 8.807, 9.808, 10.742, 11.624, 12.462, 13.264, 14.034, 14.776, 15.493, 16.189, 16.864, 17.522, 18.163, 18.789, 19.401, 20.001, 20.588, 21.164, 21.729, 22.285, 22.832, 23.369, 23.899, 24.42, 24.934, 25.441, 25.941, 26.435, 26.922, 27.403, 27.879, 28.349, 28.814, 29.274, 29.729, 30.179, 30.625, 31.066, 31.503, 31.936, 32.365, 32.79, 33.212, 33.63, 34.045, 34.456, 34.863, 35.267, 35.669, 36.067, 36.462, 36.855, 37.244, 37.63, 38.014, 38.396, 38.775, 39.151, 39.525, 39.896, 40.266, 40.633, 40.997, 41.359, 41.60505928171762], alphaGrid=[8.51e-25, 1.92e-24, 3.9e-24, 6.48e-24, 9.84e-24, 1.39e-23, 1.82e-23, 2.28e-23, 2.79e-23, 3.36e-23, 3.97e-23, 4.63e-23, 5.31e-23, 5.99e-23, 6.76e-23, 7.52e-23, 8.27e-23, 9.14e-23, 1e-22, 1.08e-22, 1.19e-22, 1.3e-22, 1.34e-22, 1.37e-22, 1.16e-22, 2.13e-22, 1.94e-22, 1.97e-22, 2.05e-22, 2.13e-22, 2.21e-22, 2.32e-22, 2.42e-22, 2.52e-22, 2.62e-22, 2.71e-22, 2.81e-22, 2.91e-22, 3.03e-22, 3.14e-22, 3.25e-22, 3.36e-22, 3.47e-22, 3.58e-22, 3.69e-22, 3.8e-22, 3.9e-22, 4.01e-22, 9.03e-22, 2.79e-22, 4.13e-22, 6.14e-22, 5.74e-23, 6.07e-22, 5.39e-22, 6.63e-23, 1.93e-23, 4.75e-22, 1.86e-21, 1.11e-22, 1.63e-22, 2.08e-23, 8.1e-24, 2.18e-23, 7.37e-23, 2.7e-22, 1.64e-21, 3.64e-21, 3.64e-21]),
		ExplicitContinuum(j=80, i=69, wavelengthGrid=[3.57, 5.534, 7.138, 8.547, 9.828, 11.014, 12.126, 13.18, 14.185, 15.149, 16.076, 16.972, 17.84, 18.684, 19.504, 20.305, 21.087, 21.851, 22.599, 23.334, 24.054, 24.761, 25.456, 26.14, 26.813, 27.475, 28.129, 28.773, 29.409, 30.036, 30.656, 31.268, 31.873, 32.471, 33.062, 33.648, 34.226, 34.8, 35.367, 35.929, 36.486, 37.037, 37.584, 38.125, 38.662, 39.195, 39.723, 40.248, 40.767, 41.283, 41.795, 42.303, 42.809, 43.309, 43.807, 44.301, 44.792, 45.279, 45.764, 46.245, 46.723, 47.198, 47.671, 48.141, 48.607, 49.072, 49.08899802944001], alphaGrid=[1.03e-24, 2.51e-24, 5.38e-24, 9.27e-24, 1.41e-23, 1.96e-23, 2.57e-23, 3.25e-23, 4e-23, 4.78e-23, 5.66e-23, 6.53e-23, 7.47e-23, 8.44e-23, 9.52e-23, 1.06e-22, 1.17e-22, 1.33e-22, 1.32e-22, 1.4e-22, 1.32e-22, 2.74e-22, 2.18e-22, 2.12e-22, 2.21e-22, 2.29e-22, 2.36e-22, 2.48e-22, 2.6e-22, 2.73e-22, 2.86e-22, 2.99e-22, 3.11e-22, 3.24e-22, 3.36e-22, 3.49e-22, 3.63e-22, 3.78e-22, 3.93e-22, 4.07e-22, 4.22e-22, 4.36e-22, 4.5e-22, 4.64e-22, 4.78e-22, 4.02e-22, 4.23e-22, 5.86e-22, 1.04e-22, 9.86e-22, 2.29e-23, 1.64e-21, 2.03e-22, 2.28e-23, 3.74e-23, 3.02e-21, 5.53e-22, 3.94e-23, 4.5e-22, 4.34e-23, 1.1e-24, 1.06e-23, 3.45e-23, 9.1e-23, 3.5e-22, 9.33e-21, 9.33e-21]),
		ExplicitContinuum(j=80, i=70, wavelengthGrid=[2.992, 5.583, 7.674, 9.517, 11.199, 12.766, 14.245, 15.652, 17.002, 18.3, 19.555, 20.772, 21.955, 23.109, 24.235, 25.336, 26.414, 27.472, 28.509, 29.53, 30.533, 31.52, 32.492, 33.451, 34.396, 35.33, 36.251, 37.161, 38.059, 38.948, 39.828, 40.698, 41.559, 42.412, 43.256, 44.092, 44.921, 45.742, 46.556, 47.364, 48.164, 48.959, 49.746, 50.529, 51.304, 52.076, 52.84, 53.6, 54.355, 55.104, 55.849, 56.588, 57.323, 58.054, 58.781, 59.502, 60.22, 60.933, 61.643, 62.348, 63.049, 63.747, 64.442, 65.133, 65.819, 66.503, 67.183, 67.55911628730449], alphaGrid=[1.32e-24, 4.46e-24, 1.15e-23, 2.01e-23, 2.79e-23, 3.63e-23, 4.44e-23, 5.24e-23, 6.12e-23, 6.98e-23, 7.85e-23, 8.7e-23, 9.36e-23, 9.98e-23, 1.28e-22, 6.05e-23, 3.72e-22, 4.58e-23, 3.57e-23, 3.76e-23, 3.04e-23, 2.67e-23, 2.11e-23, 1.56e-21, 2.1e-22, 9.61e-23, 8.07e-23, 7.51e-23, 7.35e-23, 7.31e-23, 7.28e-23, 7.31e-23, 7.44e-23, 7.57e-23, 7.7e-23, 7.83e-23, 7.96e-23, 8.08e-23, 8.21e-23, 8.33e-23, 8.46e-23, 6.94e-23, 8.7e-23, 8.88e-23, 8.73e-23, 9.35e-23, 9.34e-23, 7.4e-23, 1.17e-22, 1e-22, 9.83e-23, 9.27e-23, 7.44e-23, 1.3e-22, 1.13e-22, 1.06e-22, 1.22e-22, 1.13e-22, 1.11e-22, 1.1e-22, 1.09e-22, 1.06e-22, 1.04e-22, 9.84e-23, 7.1e-23, 1.77e-22, 1.51e-22, 1.51e-22]),
		ExplicitContinuum(j=80, i=71, wavelengthGrid=[2.957, 5.657, 7.849, 9.786, 11.561, 13.218, 14.785, 16.279, 17.713, 19.094, 20.433, 21.731, 22.995, 24.228, 25.433, 26.612, 27.767, 28.901, 30.016, 31.111, 32.189, 33.251, 34.298, 35.329, 36.348, 37.353, 38.346, 39.327, 40.298, 41.257, 42.206, 43.147, 44.078, 44.999, 45.912, 46.817, 47.715, 48.603, 49.485, 50.36, 51.227, 52.089, 52.943, 53.792, 54.634, 55.47, 56.301, 57.126, 57.946, 58.76, 59.57, 60.373, 61.173, 61.968, 62.757, 63.542, 64.324, 65.099, 65.872, 66.641, 67.405, 68.165, 68.921, 69.674, 70.423, 71.168, 71.909, 71.91075667993049], alphaGrid=[1.24e-24, 4.39e-24, 1.16e-23, 2.03e-23, 2.84e-23, 3.65e-23, 4.41e-23, 5.2e-23, 6e-23, 6.76e-23, 7.49e-23, 8.2e-23, 8.6e-23, 8.9e-23, 1.12e-22, 2.81e-23, 1.83e-22, 2.64e-23, 3.61e-23, 5.3e-23, 1.51e-22, 1.11e-21, 5.34e-23, 3.32e-23, 3.32e-23, 3.53e-23, 3.77e-23, 4.01e-23, 4.25e-23, 4.48e-23, 4.71e-23, 4.94e-23, 5.17e-23, 5.39e-23, 5.62e-23, 5.84e-23, 6.06e-23, 6.27e-23, 6.49e-23, 6.7e-23, 5.98e-23, 6.49e-23, 7.94e-23, 7.57e-23, 6.83e-23, 8.43e-23, 1.1e-22, 5.47e-23, 7.07e-23, 9.72e-23, 1.03e-22, 1.49e-22, 5.64e-23, 6.16e-23, 3.21e-23, 1.11e-22, 1.12e-22, 1.12e-22, 1.15e-22, 1.17e-22, 1.24e-22, 1.39e-22, 2.42e-22, 2.1e-22, 5.98e-23, 7.45e-23, 7.87e-23, 7.87e-23]),
		ExplicitContinuum(j=80, i=72, wavelengthGrid=[3.181, 5.957, 8.255, 10.307, 12.2, 13.974, 15.659, 17.27, 18.821, 20.319, 21.771, 23.185, 24.563, 25.909, 27.226, 28.517, 29.783, 31.028, 32.251, 33.456, 34.641, 35.812, 36.966, 38.103, 39.228, 40.339, 41.438, 42.524, 43.598, 44.663, 45.715, 46.758, 47.792, 48.815, 49.829, 50.836, 51.833, 52.824, 53.806, 54.78, 55.747, 56.708, 57.662, 58.609, 59.549, 60.483, 61.411, 62.334, 63.251, 64.162, 65.068, 65.968, 66.863, 67.753, 68.639, 69.52, 70.395, 71.267, 72.134, 72.996, 73.855, 74.708, 75.558, 76.405, 77.246, 78.085, 78.55445721760873], alphaGrid=[1.16e-24, 3.99e-24, 1.05e-23, 2e-23, 2.95e-23, 3.84e-23, 4.72e-23, 5.66e-23, 6.57e-23, 7.42e-23, 8.25e-23, 7.77e-23, 1.11e-22, 6.59e-23, 6.56e-23, 1.17e-22, 6.88e-23, 5.85e-23, 3.93e-22, 4.53e-23, 1.37e-21, 2.06e-22, 1.24e-22, 2.34e-22, 1.12e-22, 1.09e-22, 1.08e-22, 1.11e-22, 1.14e-22, 1.17e-22, 1.2e-22, 1.23e-22, 1.28e-22, 1.32e-22, 1.37e-22, 1.41e-22, 1.46e-22, 1.5e-22, 1.54e-22, 1.57e-22, 1.58e-22, 1.62e-22, 1.68e-22, 1.7e-22, 1.8e-22, 1.77e-22, 1.86e-22, 1.94e-22, 2e-22, 2.04e-22, 1.99e-22, 2.15e-22, 2.22e-22, 2.28e-22, 2.33e-22, 2.39e-22, 2.44e-22, 2.5e-22, 2.54e-22, 2.56e-22, 2.58e-22, 2.6e-22, 2.64e-22, 2.37e-22, 2.78e-22, 2.75e-22, 2.75e-22]),
		ExplicitContinuum(j=80, i=73, wavelengthGrid=[3.111, 5.912, 8.227, 10.292, 12.195, 13.982, 15.676, 17.297, 18.857, 20.365, 21.827, 23.248, 24.636, 25.99, 27.315, 28.615, 29.89, 31.142, 32.373, 33.586, 34.78, 35.957, 37.119, 38.265, 39.398, 40.516, 41.623, 42.716, 43.799, 44.87, 45.93, 46.98, 48.021, 49.052, 50.074, 51.088, 52.093, 53.09, 54.08, 55.061, 56.036, 57.003, 57.963, 58.918, 59.865, 60.806, 61.742, 62.671, 63.594, 64.512, 65.425, 66.332, 67.235, 68.132, 69.024, 69.911, 70.794, 71.672, 72.545, 73.415, 74.28, 75.14, 75.997, 76.85, 77.698, 78.543, 79.03516151040753], alphaGrid=[1.28e-24, 4.53e-24, 1.2e-23, 2.04e-23, 2.9e-23, 3.78e-23, 4.65e-23, 5.61e-23, 6.57e-23, 7.57e-23, 8.56e-23, 8.47e-23, 1.13e-22, 2.83e-23, 1.25e-22, 3.53e-23, 1.03e-22, 3.74e-23, 6.26e-23, 8.93e-22, 6.86e-23, 5.51e-23, 5.62e-23, 5.98e-23, 6.37e-23, 6.75e-23, 7.18e-23, 7.67e-23, 8.15e-23, 8.62e-23, 9.09e-23, 9.57e-23, 1.01e-22, 1.06e-22, 1.12e-22, 1.17e-22, 1.22e-22, 1.27e-22, 1.32e-22, 1.44e-22, 1.42e-22, 1.5e-22, 1.53e-22, 1.61e-22, 1.6e-22, 1.79e-22, 1.72e-22, 1.77e-22, 1.82e-22, 1.88e-22, 2.1e-22, 2.15e-22, 1.93e-22, 2.1e-22, 2.17e-22, 2.23e-22, 2.3e-22, 2.36e-22, 2.43e-22, 2.49e-22, 2.55e-22, 2.61e-22, 2.62e-22, 2.78e-22, 2.92e-22, 2.94e-22, 2.94e-22]),
		ExplicitContinuum(j=80, i=74, wavelengthGrid=[3.111, 5.912, 8.227, 10.292, 12.195, 13.982, 15.676, 17.297, 18.857, 20.365, 21.827, 23.248, 24.636, 25.99, 27.315, 28.615, 29.89, 31.142, 32.373, 33.586, 34.78, 35.957, 37.119, 38.265, 39.398, 40.516, 41.623, 42.716, 43.799, 44.87, 45.93, 46.98, 48.021, 49.052, 50.074, 51.088, 52.093, 53.09, 54.08, 55.061, 56.036, 57.003, 57.963, 58.918, 59.865, 60.806, 61.742, 62.671, 63.594, 64.512, 65.425, 66.332, 67.235, 68.132, 69.024, 69.911, 70.794, 71.672, 72.545, 73.415, 74.28, 75.14, 75.997, 76.85, 77.698, 78.543, 79.03870346681303], alphaGrid=[1.28e-24, 4.53e-24, 1.2e-23, 2.04e-23, 2.9e-23, 3.78e-23, 4.65e-23, 5.61e-23, 6.57e-23, 7.57e-23, 8.56e-23, 8.47e-23, 1.13e-22, 2.83e-23, 1.25e-22, 3.53e-23, 1.03e-22, 3.74e-23, 6.26e-23, 8.93e-22, 6.86e-23, 5.51e-23, 5.62e-23, 5.98e-23, 6.37e-23, 6.75e-23, 7.18e-23, 7.67e-23, 8.15e-23, 8.62e-23, 9.09e-23, 9.57e-23, 1.01e-22, 1.06e-22, 1.12e-22, 1.17e-22, 1.22e-22, 1.27e-22, 1.32e-22, 1.44e-22, 1.42e-22, 1.5e-22, 1.53e-22, 1.61e-22, 1.6e-22, 1.79e-22, 1.72e-22, 1.77e-22, 1.82e-22, 1.88e-22, 2.1e-22, 2.15e-22, 1.93e-22, 2.1e-22, 2.17e-22, 2.23e-22, 2.3e-22, 2.36e-22, 2.43e-22, 2.49e-22, 2.55e-22, 2.61e-22, 2.62e-22, 2.78e-22, 2.92e-22, 2.94e-22, 2.94e-22]),
		ExplicitContinuum(j=80, i=75, wavelengthGrid=[3.111, 5.912, 8.227, 10.292, 12.195, 13.982, 15.676, 17.297, 18.857, 20.365, 21.827, 23.248, 24.636, 25.99, 27.315, 28.615, 29.89, 31.142, 32.373, 33.586, 34.78, 35.957, 37.119, 38.265, 39.398, 40.516, 41.623, 42.716, 43.799, 44.87, 45.93, 46.98, 48.021, 49.052, 50.074, 51.088, 52.093, 53.09, 54.08, 55.061, 56.036, 57.003, 57.963, 58.918, 59.865, 60.806, 61.742, 62.671, 63.594, 64.512, 65.425, 66.332, 67.235, 68.132, 69.024, 69.911, 70.794, 71.672, 72.545, 73.415, 74.28, 75.14, 75.997, 76.85, 77.698, 78.543, 79.04687554023603], alphaGrid=[1.28e-24, 4.53e-24, 1.2e-23, 2.04e-23, 2.9e-23, 3.78e-23, 4.65e-23, 5.61e-23, 6.57e-23, 7.57e-23, 8.56e-23, 8.47e-23, 1.13e-22, 2.83e-23, 1.25e-22, 3.53e-23, 1.03e-22, 3.74e-23, 6.26e-23, 8.93e-22, 6.86e-23, 5.51e-23, 5.62e-23, 5.98e-23, 6.37e-23, 6.75e-23, 7.18e-23, 7.67e-23, 8.15e-23, 8.62e-23, 9.09e-23, 9.57e-23, 1.01e-22, 1.06e-22, 1.12e-22, 1.17e-22, 1.22e-22, 1.27e-22, 1.32e-22, 1.44e-22, 1.42e-22, 1.5e-22, 1.53e-22, 1.61e-22, 1.6e-22, 1.79e-22, 1.72e-22, 1.77e-22, 1.82e-22, 1.88e-22, 2.1e-22, 2.15e-22, 1.93e-22, 2.1e-22, 2.17e-22, 2.23e-22, 2.3e-22, 2.36e-22, 2.43e-22, 2.49e-22, 2.55e-22, 2.61e-22, 2.62e-22, 2.78e-22, 2.92e-22, 2.94e-22, 2.94e-22]),
		ExplicitContinuum(j=80, i=76, wavelengthGrid=[2.898, 5.87, 8.33, 10.535, 12.575, 14.495, 16.321, 18.072, 19.76, 21.394, 22.982, 24.528, 26.039, 27.516, 28.963, 30.385, 31.78, 33.151, 34.502, 35.833, 37.144, 38.439, 39.716, 40.979, 42.227, 43.46, 44.681, 45.888, 47.084, 48.268, 49.442, 50.603, 51.756, 52.899, 54.031, 55.156, 56.271, 57.378, 58.477, 59.568, 60.651, 61.728, 62.796, 63.858, 64.913, 65.962, 67.003, 68.041, 69.069, 70.094, 71.113, 72.126, 73.134, 74.136, 75.133, 76.124, 77.112, 78.095, 79.072, 80.044, 81.013, 81.976, 82.937, 83.892, 84.843, 85.79, 86.04320380699194], alphaGrid=[1.07e-24, 4.21e-24, 1.18e-23, 2.04e-23, 2.92e-23, 3.78e-23, 4.68e-23, 5.53e-23, 6.31e-23, 7.07e-23, 7.41e-23, 6.65e-23, 3.86e-23, 1.07e-22, 2.79e-23, 1.04e-23, 1.64e-23, 5.21e-22, 1.16e-22, 2.3e-23, 4.46e-23, 3.54e-23, 2.91e-23, 3.12e-23, 3.36e-23, 3.67e-23, 3.99e-23, 4.31e-23, 4.67e-23, 5.08e-23, 5.49e-23, 5.89e-23, 6.3e-23, 6.77e-23, 7.26e-23, 7.75e-23, 8.24e-23, 8.74e-23, 9.48e-23, 9.8e-23, 1.03e-22, 1.17e-22, 1.07e-22, 1.23e-22, 1.5e-22, 1.1e-22, 1.4e-22, 1.49e-22, 1.6e-22, 1.75e-22, 1.97e-22, 1.41e-22, 1.74e-22, 1.98e-22, 2.05e-22, 2.16e-22, 2.27e-22, 2.37e-22, 2.49e-22, 2.63e-22, 2.78e-22, 2.92e-22, 3.06e-22, 3.62e-22, 3.75e-22, 3.16e-22, 3.16e-22]),
		ExplicitContinuum(j=80, i=77, wavelengthGrid=[2.898, 5.87, 8.33, 10.535, 12.575, 14.495, 16.321, 18.072, 19.76, 21.394, 22.982, 24.528, 26.039, 27.516, 28.963, 30.385, 31.78, 33.151, 34.502, 35.833, 37.144, 38.439, 39.716, 40.979, 42.227, 43.46, 44.681, 45.888, 47.084, 48.268, 49.442, 50.603, 51.756, 52.899, 54.031, 55.156, 56.271, 57.378, 58.477, 59.568, 60.651, 61.728, 62.796, 63.858, 64.913, 65.962, 67.003, 68.041, 69.069, 70.094, 71.113, 72.126, 73.134, 74.136, 75.133, 76.124, 77.112, 78.095, 79.072, 80.044, 81.013, 81.976, 82.937, 83.892, 84.843, 85.79, 86.04401819232122], alphaGrid=[1.07e-24, 4.21e-24, 1.18e-23, 2.04e-23, 2.92e-23, 3.78e-23, 4.68e-23, 5.53e-23, 6.31e-23, 7.07e-23, 7.41e-23, 6.65e-23, 3.86e-23, 1.07e-22, 2.79e-23, 1.04e-23, 1.64e-23, 5.21e-22, 1.16e-22, 2.3e-23, 4.46e-23, 3.54e-23, 2.91e-23, 3.12e-23, 3.36e-23, 3.67e-23, 3.99e-23, 4.31e-23, 4.67e-23, 5.08e-23, 5.49e-23, 5.89e-23, 6.3e-23, 6.77e-23, 7.26e-23, 7.75e-23, 8.24e-23, 8.74e-23, 9.48e-23, 9.8e-23, 1.03e-22, 1.17e-22, 1.07e-22, 1.23e-22, 1.5e-22, 1.1e-22, 1.4e-22, 1.49e-22, 1.6e-22, 1.75e-22, 1.97e-22, 1.41e-22, 1.74e-22, 1.98e-22, 2.05e-22, 2.16e-22, 2.27e-22, 2.37e-22, 2.49e-22, 2.63e-22, 2.78e-22, 2.92e-22, 3.06e-22, 3.62e-22, 3.75e-22, 3.16e-22, 3.16e-22]),
		ExplicitContinuum(j=80, i=78, wavelengthGrid=[2.898, 5.87, 8.33, 10.535, 12.575, 14.495, 16.321, 18.072, 19.76, 21.394, 22.982, 24.528, 26.039, 27.516, 28.963, 30.385, 31.78, 33.151, 34.502, 35.833, 37.144, 38.439, 39.716, 40.979, 42.227, 43.46, 44.681, 45.888, 47.084, 48.268, 49.442, 50.603, 51.756, 52.899, 54.031, 55.156, 56.271, 57.378, 58.477, 59.568, 60.651, 61.728, 62.796, 63.858, 64.913, 65.962, 67.003, 68.041, 69.069, 70.094, 71.113, 72.126, 73.134, 74.136, 75.133, 76.124, 77.112, 78.095, 79.072, 80.044, 81.013, 81.976, 82.937, 83.892, 84.843, 85.79, 86.04609864665501], alphaGrid=[1.07e-24, 4.21e-24, 1.18e-23, 2.04e-23, 2.92e-23, 3.78e-23, 4.68e-23, 5.53e-23, 6.31e-23, 7.07e-23, 7.41e-23, 6.65e-23, 3.86e-23, 1.07e-22, 2.79e-23, 1.04e-23, 1.64e-23, 5.21e-22, 1.16e-22, 2.3e-23, 4.46e-23, 3.54e-23, 2.91e-23, 3.12e-23, 3.36e-23, 3.67e-23, 3.99e-23, 4.31e-23, 4.67e-23, 5.08e-23, 5.49e-23, 5.89e-23, 6.3e-23, 6.77e-23, 7.26e-23, 7.75e-23, 8.24e-23, 8.74e-23, 9.48e-23, 9.8e-23, 1.03e-22, 1.17e-22, 1.07e-22, 1.23e-22, 1.5e-22, 1.1e-22, 1.4e-22, 1.49e-22, 1.6e-22, 1.75e-22, 1.97e-22, 1.41e-22, 1.74e-22, 1.98e-22, 2.05e-22, 2.16e-22, 2.27e-22, 2.37e-22, 2.49e-22, 2.63e-22, 2.78e-22, 2.92e-22, 3.06e-22, 3.62e-22, 3.75e-22, 3.16e-22, 3.16e-22]),
		ExplicitContinuum(j=80, i=79, wavelengthGrid=[3.035, 6.052, 8.59, 10.88, 13.007, 15.016, 16.932, 18.774, 20.554, 22.28, 23.959, 25.597, 27.199, 28.768, 30.305, 31.816, 33.302, 34.765, 36.205, 37.625, 39.028, 40.41, 41.778, 43.128, 44.465, 45.787, 47.095, 48.391, 49.674, 50.946, 52.206, 53.455, 54.695, 55.924, 57.144, 58.354, 59.555, 60.749, 61.933, 63.109, 64.278, 65.439, 66.592, 67.74, 68.878, 70.013, 71.139, 72.259, 73.374, 74.481, 75.582, 76.679, 77.77, 78.856, 79.936, 81.011, 82.081, 83.145, 84.205, 85.26, 86.311, 87.358, 88.399, 89.435, 90.468, 91.11729060476688], alphaGrid=[1.15e-24, 4.42e-24, 1.23e-23, 2.11e-23, 3.03e-23, 3.93e-23, 4.86e-23, 5.75e-23, 6.57e-23, 7.36e-23, 6.67e-23, 7.19e-23, 3.19e-23, 1.01e-22, 1.06e-23, 1.06e-22, 3.33e-22, 1.34e-22, 8.12e-23, 3.76e-23, 2.6e-23, 2.65e-23, 2.83e-23, 3.02e-23, 3.27e-23, 3.55e-23, 3.83e-23, 4.12e-23, 4.48e-23, 4.84e-23, 5.19e-23, 5.54e-23, 5.94e-23, 6.37e-23, 6.79e-23, 7.21e-23, 7.62e-23, 5.99e-23, 8.07e-23, 8.67e-23, 1.34e-22, 5.13e-23, 1.01e-22, 1.71e-22, 5.42e-23, 9.98e-23, 1.25e-22, 1.63e-22, 3.13e-22, 6.32e-23, 7.64e-23, 1.08e-22, 1.42e-22, 1.62e-22, 1.81e-22, 2e-22, 2.27e-22, 2.56e-22, 2.97e-22, 3.57e-22, 4.63e-22, 6.18e-22, 2.09e-22, 2.43e-23, 7.66e-23, 7.66e-23]),
		ExplicitContinuum(j=88, i=80, wavelengthGrid=[0.912, 2.822, 3.812, 4.568, 5.201, 5.755, 6.254, 6.711, 7.134, 7.53, 7.903, 8.257, 8.594, 8.917, 9.226, 9.524, 9.812, 10.09, 10.36, 10.621, 10.876, 11.123, 11.365, 11.601, 11.831, 12.056, 12.277, 12.493, 12.705, 12.912, 13.116, 13.317, 13.514, 13.708, 13.898, 14.086, 14.27, 14.452, 14.632, 14.809, 14.983, 15.155, 15.325, 15.493, 15.659, 15.823, 15.984, 16.144, 16.302, 16.459, 16.613, 16.766, 16.918, 17.068, 17.216, 17.363, 17.508, 17.652, 17.795, 17.937, 18.077, 18.216, 18.353, 18.49, 18.625, 18.759, 18.893, 19.025, 19.156, 19.224899536202177], alphaGrid=[8.03e-24, 3.39e-23, 5.23e-24, 3.92e-24, 5.22e-24, 6.5e-24, 7.71e-24, 8.95e-24, 1.01e-23, 1.12e-23, 1.24e-23, 1.35e-23, 1.46e-23, 1.57e-23, 1.66e-23, 1.77e-23, 1.89e-23, 2.02e-23, 2.14e-23, 2.25e-23, 2.36e-23, 2.46e-23, 2.57e-23, 2.67e-23, 2.77e-23, 2.87e-23, 2.97e-23, 3.07e-23, 3.17e-23, 3.27e-23, 3.37e-23, 3.46e-23, 3.56e-23, 3.65e-23, 3.75e-23, 3.84e-23, 3.93e-23, 4.02e-23, 4.11e-23, 4.2e-23, 4.29e-23, 4.38e-23, 4.47e-23, 4.56e-23, 4.64e-23, 4.73e-23, 4.81e-23, 4.9e-23, 4.98e-23, 5.06e-23, 5.15e-23, 5.23e-23, 5.31e-23, 5.39e-23, 5.47e-23, 5.55e-23, 5.63e-23, 5.71e-23, 5.79e-23, 5.87e-23, 5.95e-23, 6.02e-23, 6.1e-23, 6.17e-23, 6.25e-23, 6.33e-23, 6.4e-23, 6.47e-23, 6.55e-23, 6.55e-23]),
		ExplicitContinuum(j=88, i=81, wavelengthGrid=[2.593, 3.852, 4.767, 5.519, 6.173, 6.758, 7.291, 7.785, 8.247, 8.682, 9.093, 9.486, 9.861, 10.221, 10.568, 10.902, 11.226, 11.539, 11.844, 12.14, 12.428, 12.709, 12.983, 13.252, 13.514, 13.771, 14.022, 14.269, 14.512, 14.749, 14.983, 15.213, 15.439, 15.661, 15.88, 16.095, 16.308, 16.517, 16.724, 16.928, 17.129, 17.328, 17.524, 17.717, 17.909, 18.098, 18.285, 18.47, 18.653, 18.834, 19.013, 19.19, 19.366, 19.539, 19.711, 19.882, 20.05, 20.218, 20.383, 20.547, 20.71, 20.872, 21.032, 21.191, 21.348, 21.504, 21.659, 21.813, 21.945476835874377], alphaGrid=[1.35e-25, 3.39e-25, 7.16e-25, 1.18e-24, 1.73e-24, 2.34e-24, 3.01e-24, 3.74e-24, 4.51e-24, 5.33e-24, 6.19e-24, 7.1e-24, 8.04e-24, 9.01e-24, 1e-23, 1.11e-23, 1.21e-23, 1.32e-23, 1.44e-23, 1.55e-23, 1.67e-23, 1.79e-23, 1.91e-23, 2.04e-23, 2.16e-23, 2.29e-23, 2.42e-23, 2.56e-23, 2.69e-23, 2.83e-23, 2.97e-23, 3.11e-23, 3.25e-23, 3.4e-23, 3.54e-23, 3.69e-23, 3.84e-23, 3.99e-23, 4.15e-23, 4.3e-23, 4.46e-23, 4.61e-23, 4.77e-23, 4.93e-23, 5.09e-23, 5.26e-23, 5.42e-23, 5.58e-23, 5.75e-23, 5.92e-23, 6.09e-23, 6.26e-23, 6.43e-23, 6.6e-23, 6.78e-23, 6.95e-23, 7.13e-23, 7.31e-23, 7.49e-23, 7.66e-23, 7.84e-23, 8.03e-23, 8.21e-23, 8.39e-23, 8.57e-23, 8.76e-23, 8.95e-23, 9.14e-23, 9.14e-23]),
		ExplicitContinuum(j=88, i=82, wavelengthGrid=[2.593, 3.852, 4.767, 5.519, 6.173, 6.758, 7.291, 7.785, 8.247, 8.682, 9.093, 9.486, 9.861, 10.221, 10.568, 10.902, 11.226, 11.539, 11.844, 12.14, 12.428, 12.709, 12.983, 13.252, 13.514, 13.771, 14.022, 14.269, 14.512, 14.749, 14.983, 15.213, 15.439, 15.661, 15.88, 16.095, 16.308, 16.517, 16.724, 16.928, 17.129, 17.328, 17.524, 17.717, 17.909, 18.098, 18.285, 18.47, 18.653, 18.834, 19.013, 19.19, 19.366, 19.539, 19.711, 19.882, 20.05, 20.218, 20.383, 20.547, 20.71, 20.872, 21.032, 21.191, 21.348, 21.504, 21.659, 21.813, 21.95066493667623], alphaGrid=[1.35e-25, 3.39e-25, 7.16e-25, 1.18e-24, 1.73e-24, 2.34e-24, 3.01e-24, 3.74e-24, 4.51e-24, 5.33e-24, 6.19e-24, 7.1e-24, 8.04e-24, 9.01e-24, 1e-23, 1.11e-23, 1.21e-23, 1.32e-23, 1.44e-23, 1.55e-23, 1.67e-23, 1.79e-23, 1.91e-23, 2.04e-23, 2.16e-23, 2.29e-23, 2.42e-23, 2.56e-23, 2.69e-23, 2.83e-23, 2.97e-23, 3.11e-23, 3.25e-23, 3.4e-23, 3.54e-23, 3.69e-23, 3.84e-23, 3.99e-23, 4.15e-23, 4.3e-23, 4.46e-23, 4.61e-23, 4.77e-23, 4.93e-23, 5.09e-23, 5.26e-23, 5.42e-23, 5.58e-23, 5.75e-23, 5.92e-23, 6.09e-23, 6.26e-23, 6.43e-23, 6.6e-23, 6.78e-23, 6.95e-23, 7.13e-23, 7.31e-23, 7.49e-23, 7.66e-23, 7.84e-23, 8.03e-23, 8.21e-23, 8.39e-23, 8.57e-23, 8.76e-23, 8.95e-23, 9.14e-23, 9.14e-23]),
		ExplicitContinuum(j=88, i=83, wavelengthGrid=[1.837, 5.029, 7.054, 8.693, 10.117, 11.396, 12.57, 13.662, 14.689, 15.662, 16.588, 17.476, 18.329, 19.151, 19.946, 20.717, 21.466, 22.194, 22.904, 23.596, 24.273, 24.935, 25.584, 26.22, 26.844, 27.456, 28.058, 28.649, 29.232, 29.804, 30.369, 30.925, 31.473, 32.014, 32.548, 33.074, 33.594, 34.108, 34.616, 35.117, 35.614, 36.104, 36.59, 37.071, 37.546, 38.017, 38.483, 38.945, 39.402, 39.855, 40.305, 40.75, 41.192, 41.629, 42.064, 42.494, 42.921, 43.344, 43.765, 44.183, 44.597, 45.008, 45.416, 45.821, 46.01726019997306], alphaGrid=[3.14e-25, 1.19e-24, 2.63e-24, 4.17e-24, 5.8e-24, 7.45e-24, 9.14e-24, 1.08e-23, 1.26e-23, 1.43e-23, 1.61e-23, 1.78e-23, 1.96e-23, 2.13e-23, 2.31e-23, 2.49e-23, 2.66e-23, 2.84e-23, 3.02e-23, 3.19e-23, 3.37e-23, 3.54e-23, 3.72e-23, 3.89e-23, 4.07e-23, 4.24e-23, 4.42e-23, 4.59e-23, 4.76e-23, 4.94e-23, 5.11e-23, 5.28e-23, 5.45e-23, 5.62e-23, 5.8e-23, 5.96e-23, 6.13e-23, 6.31e-23, 6.47e-23, 6.64e-23, 6.81e-23, 6.98e-23, 7.15e-23, 7.31e-23, 7.48e-23, 7.65e-23, 7.81e-23, 7.98e-23, 8.14e-23, 8.31e-23, 8.47e-23, 8.64e-23, 8.8e-23, 8.96e-23, 9.12e-23, 9.29e-23, 9.45e-23, 9.61e-23, 9.77e-23, 9.93e-23, 1.01e-22, 1.03e-22, 1.04e-22, 1.06e-22, 1.06e-22]),
		ExplicitContinuum(j=88, i=84, wavelengthGrid=[4.439, 6.793, 8.641, 10.226, 11.644, 12.94, 14.145, 15.276, 16.346, 17.366, 18.342, 19.28, 20.185, 21.06, 21.908, 22.732, 23.533, 24.315, 25.077, 25.823, 26.553, 27.267, 27.968, 28.655, 29.331, 29.994, 30.646, 31.289, 31.921, 32.544, 33.158, 33.764, 34.362, 34.951, 35.533, 36.108, 36.676, 37.238, 37.792, 38.341, 38.884, 39.422, 39.954, 40.48, 41.001, 41.518, 42.03, 42.536, 43.039, 43.537, 44.031, 44.52, 45.005, 45.486, 45.964, 46.438, 46.908, 47.374, 47.838, 48.297, 48.754, 49.207, 49.658, 49.97284850208759], alphaGrid=[2.72e-25, 6.86e-25, 1.47e-24, 2.46e-24, 3.63e-24, 4.96e-24, 6.42e-24, 8.01e-24, 9.71e-24, 1.15e-23, 1.34e-23, 1.54e-23, 1.74e-23, 1.96e-23, 2.18e-23, 2.4e-23, 2.64e-23, 2.88e-23, 3.12e-23, 3.37e-23, 3.63e-23, 3.89e-23, 4.15e-23, 4.42e-23, 4.69e-23, 4.97e-23, 5.25e-23, 5.53e-23, 5.82e-23, 6.11e-23, 6.41e-23, 6.7e-23, 7.01e-23, 7.31e-23, 7.62e-23, 7.92e-23, 8.24e-23, 8.55e-23, 8.87e-23, 9.19e-23, 9.51e-23, 9.83e-23, 1.02e-22, 1.05e-22, 1.08e-22, 1.11e-22, 1.15e-22, 1.18e-22, 1.22e-22, 1.25e-22, 1.28e-22, 1.32e-22, 1.35e-22, 1.39e-22, 1.42e-22, 1.46e-22, 1.49e-22, 1.53e-22, 1.56e-22, 1.6e-22, 1.63e-22, 1.67e-22, 1.71e-22, 1.71e-22]),
		ExplicitContinuum(j=88, i=85, wavelengthGrid=[4.439, 6.793, 8.641, 10.226, 11.644, 12.94, 14.145, 15.276, 16.346, 17.366, 18.342, 19.28, 20.185, 21.06, 21.908, 22.732, 23.533, 24.315, 25.077, 25.823, 26.553, 27.267, 27.968, 28.655, 29.331, 29.994, 30.646, 31.289, 31.921, 32.544, 33.158, 33.764, 34.362, 34.951, 35.533, 36.108, 36.676, 37.238, 37.792, 38.341, 38.884, 39.422, 39.954, 40.48, 41.001, 41.518, 42.03, 42.536, 43.039, 43.537, 44.031, 44.52, 45.005, 45.486, 45.964, 46.438, 46.908, 47.374, 47.838, 48.297, 48.754, 49.207, 49.658, 49.980741170908345], alphaGrid=[2.72e-25, 6.86e-25, 1.47e-24, 2.46e-24, 3.63e-24, 4.96e-24, 6.42e-24, 8.01e-24, 9.71e-24, 1.15e-23, 1.34e-23, 1.54e-23, 1.74e-23, 1.96e-23, 2.18e-23, 2.4e-23, 2.64e-23, 2.88e-23, 3.12e-23, 3.37e-23, 3.63e-23, 3.89e-23, 4.15e-23, 4.42e-23, 4.69e-23, 4.97e-23, 5.25e-23, 5.53e-23, 5.82e-23, 6.11e-23, 6.41e-23, 6.7e-23, 7.01e-23, 7.31e-23, 7.62e-23, 7.92e-23, 8.24e-23, 8.55e-23, 8.87e-23, 9.19e-23, 9.51e-23, 9.83e-23, 1.02e-22, 1.05e-22, 1.08e-22, 1.11e-22, 1.15e-22, 1.18e-22, 1.22e-22, 1.25e-22, 1.28e-22, 1.32e-22, 1.35e-22, 1.39e-22, 1.42e-22, 1.46e-22, 1.49e-22, 1.53e-22, 1.56e-22, 1.6e-22, 1.63e-22, 1.67e-22, 1.71e-22, 1.71e-22]),
		ExplicitContinuum(j=88, i=86, wavelengthGrid=[8.47, 10.089, 11.532, 12.851, 14.076, 15.225, 16.313, 17.348, 18.339, 19.292, 20.211, 21.098, 21.96, 22.796, 23.61, 24.403, 25.178, 25.935, 26.676, 27.402, 28.113, 28.812, 29.498, 30.172, 30.835, 31.487, 32.13, 32.763, 33.387, 34.002, 34.609, 35.208, 35.8, 36.384, 36.962, 37.533, 38.097, 38.655, 39.207, 39.753, 40.295, 40.83, 41.36, 41.885, 42.405, 42.921, 43.432, 43.938, 44.44, 44.939, 45.432, 45.922, 46.408, 46.89, 47.369, 47.843, 48.314, 48.783, 49.247, 49.708, 50.167, 50.621, 51.073, 51.20879250870671], alphaGrid=[1.37e-25, 2.3e-25, 4.02e-25, 6.3e-25, 9.14e-25, 1.25e-24, 1.65e-24, 2.11e-24, 2.63e-24, 3.21e-24, 3.84e-24, 4.54e-24, 5.29e-24, 6.11e-24, 6.98e-24, 7.91e-24, 8.9e-24, 9.95e-24, 1.11e-23, 1.22e-23, 1.34e-23, 1.47e-23, 1.61e-23, 1.75e-23, 1.89e-23, 2.04e-23, 2.2e-23, 2.36e-23, 2.53e-23, 2.7e-23, 2.88e-23, 3.06e-23, 3.25e-23, 3.45e-23, 3.65e-23, 3.85e-23, 4.06e-23, 4.28e-23, 4.5e-23, 4.73e-23, 4.96e-23, 5.2e-23, 5.44e-23, 5.69e-23, 5.94e-23, 6.2e-23, 6.46e-23, 6.73e-23, 7e-23, 7.28e-23, 7.56e-23, 7.85e-23, 8.14e-23, 8.44e-23, 8.74e-23, 9.05e-23, 9.36e-23, 9.67e-23, 1e-22, 1.03e-22, 1.07e-22, 1.1e-22, 1.13e-22, 1.13e-22]),
		ExplicitContinuum(j=88, i=87, wavelengthGrid=[8.47, 10.089, 11.532, 12.851, 14.076, 15.225, 16.313, 17.348, 18.339, 19.292, 20.211, 21.098, 21.96, 22.796, 23.61, 24.403, 25.178, 25.935, 26.676, 27.402, 28.113, 28.812, 29.498, 30.172, 30.835, 31.487, 32.13, 32.763, 33.387, 34.002, 34.609, 35.208, 35.8, 36.384, 36.962, 37.533, 38.097, 38.655, 39.207, 39.753, 40.295, 40.83, 41.36, 41.885, 42.405, 42.921, 43.432, 43.938, 44.44, 44.939, 45.432, 45.922, 46.408, 46.89, 47.369, 47.843, 48.314, 48.783, 49.247, 49.708, 50.167, 50.621, 51.073, 51.211546114217704], alphaGrid=[1.37e-25, 2.3e-25, 4.02e-25, 6.3e-25, 9.14e-25, 1.25e-24, 1.65e-24, 2.11e-24, 2.63e-24, 3.21e-24, 3.84e-24, 4.54e-24, 5.29e-24, 6.11e-24, 6.98e-24, 7.91e-24, 8.9e-24, 9.95e-24, 1.11e-23, 1.22e-23, 1.34e-23, 1.47e-23, 1.61e-23, 1.75e-23, 1.89e-23, 2.04e-23, 2.2e-23, 2.36e-23, 2.53e-23, 2.7e-23, 2.88e-23, 3.06e-23, 3.25e-23, 3.45e-23, 3.65e-23, 3.85e-23, 4.06e-23, 4.28e-23, 4.5e-23, 4.73e-23, 4.96e-23, 5.2e-23, 5.44e-23, 5.69e-23, 5.94e-23, 6.2e-23, 6.46e-23, 6.73e-23, 7e-23, 7.28e-23, 7.56e-23, 7.85e-23, 8.14e-23, 8.44e-23, 8.74e-23, 9.05e-23, 9.36e-23, 9.67e-23, 1e-22, 1.03e-22, 1.07e-22, 1.1e-22, 1.13e-22, 1.13e-22]),
		ExplicitContinuum(j=105, i=88, wavelengthGrid=[0.228, 0.579, 0.752, 0.88, 0.986, 1.077, 1.158, 1.231, 1.299, 1.362, 1.42, 1.476, 1.529, 1.579, 1.626, 1.672, 1.716, 1.759, 1.8, 1.84, 1.878, 1.916, 1.952, 1.987, 2.022, 2.056, 2.088, 2.121, 2.152, 2.183, 2.213, 2.242, 2.272, 2.3, 2.328, 2.355, 2.382, 2.409, 2.435, 2.461, 2.486, 2.511, 2.536, 2.56, 2.584, 2.608, 2.631, 2.654, 2.677, 2.699, 2.722, 2.744, 2.765, 2.787, 2.808, 2.829, 2.85, 2.87, 2.89, 2.911, 2.93, 2.95, 2.97, 2.989, 3.008, 3.027, 3.046, 3.065, 3.083, 3.101, 3.12, 3.138, 3.155, 3.1622671593716283], alphaGrid=[1.02e-25, 4.18e-25, 9.57e-25, 1.56e-24, 2.19e-24, 2.84e-24, 3.51e-24, 4.18e-24, 4.87e-24, 5.56e-24, 6.25e-24, 6.95e-24, 7.65e-24, 8.35e-24, 9.06e-24, 9.76e-24, 1.05e-23, 1.12e-23, 1.19e-23, 1.26e-23, 1.33e-23, 1.4e-23, 1.47e-23, 1.54e-23, 1.61e-23, 1.68e-23, 1.75e-23, 1.82e-23, 1.89e-23, 1.96e-23, 2.03e-23, 2.1e-23, 2.17e-23, 2.24e-23, 2.31e-23, 2.37e-23, 2.44e-23, 2.51e-23, 2.58e-23, 2.65e-23, 2.72e-23, 2.79e-23, 2.86e-23, 2.92e-23, 2.99e-23, 3.06e-23, 3.13e-23, 3.19e-23, 3.26e-23, 3.32e-23, 3.39e-23, 3.46e-23, 3.53e-23, 3.6e-23, 3.66e-23, 3.73e-23, 3.8e-23, 3.86e-23, 3.93e-23, 4e-23, 4.06e-23, 4.13e-23, 4.19e-23, 4.25e-23, 4.32e-23, 4.38e-23, 4.45e-23, 4.52e-23, 4.58e-23, 4.65e-23, 4.71e-23, 4.77e-23, 4.84e-23, 4.84e-23]),
		ExplicitContinuum(j=105, i=89, wavelengthGrid=[0.774, 1.632, 2.198, 2.656, 3.052, 3.407, 3.732, 4.033, 4.316, 4.583, 4.836, 5.079, 5.311, 5.535, 5.751, 5.96, 6.163, 6.36, 6.551, 6.738, 6.92, 7.098, 7.272, 7.443, 7.61, 7.774, 7.935, 8.093, 8.248, 8.401, 8.551, 8.699, 8.845, 8.989, 9.13, 9.27, 9.408, 9.544, 9.679, 9.811, 9.943, 10.072, 10.201, 10.327, 10.453, 10.577, 10.699, 10.821, 10.941, 11.061, 11.179, 11.296, 11.411, 11.526, 11.64, 11.753, 11.865, 11.976, 12.086, 12.195, 12.303, 12.411, 12.517, 12.623, 12.728, 12.833, 12.936, 13.039, 13.141, 13.242, 13.315115397158582], alphaGrid=[1.21e-25, 4.13e-25, 9.17e-25, 1.49e-24, 2.11e-24, 2.75e-24, 3.43e-24, 4.12e-24, 4.82e-24, 5.54e-24, 6.27e-24, 7e-24, 7.75e-24, 8.5e-24, 9.26e-24, 1.01e-23, 1.08e-23, 1.15e-23, 1.23e-23, 1.31e-23, 1.38e-23, 1.46e-23, 1.54e-23, 1.61e-23, 1.69e-23, 1.77e-23, 1.85e-23, 1.93e-23, 2.01e-23, 2.09e-23, 2.16e-23, 2.24e-23, 2.32e-23, 2.4e-23, 2.48e-23, 2.55e-23, 2.63e-23, 2.71e-23, 2.79e-23, 2.87e-23, 2.94e-23, 3.02e-23, 3.1e-23, 3.18e-23, 3.26e-23, 3.33e-23, 3.41e-23, 3.49e-23, 3.57e-23, 3.65e-23, 3.72e-23, 3.8e-23, 3.88e-23, 3.95e-23, 4.03e-23, 4.1e-23, 4.18e-23, 4.25e-23, 4.33e-23, 4.41e-23, 4.48e-23, 4.56e-23, 4.63e-23, 4.71e-23, 4.78e-23, 4.86e-23, 4.93e-23, 5.01e-23, 5.08e-23, 5.15e-23, 5.15e-23]),
		ExplicitContinuum(j=105, i=90, wavelengthGrid=[0.951, 1.775, 2.35, 2.823, 3.235, 3.606, 3.946, 4.263, 4.56, 4.842, 5.11, 5.366, 5.612, 5.85, 6.079, 6.3, 6.516, 6.725, 6.929, 7.127, 7.322, 7.511, 7.697, 7.879, 8.057, 8.232, 8.404, 8.572, 8.738, 8.902, 9.062, 9.221, 9.377, 9.53, 9.682, 9.832, 9.979, 10.125, 10.269, 10.411, 10.552, 10.691, 10.828, 10.964, 11.099, 11.232, 11.363, 11.494, 11.623, 11.751, 11.878, 12.003, 12.128, 12.251, 12.373, 12.495, 12.615, 12.734, 12.852, 12.97, 13.086, 13.202, 13.317, 13.43, 13.543, 13.656, 13.767, 13.878, 13.987, 14.097, 14.138988727862314], alphaGrid=[1.05e-25, 3.4e-25, 7.67e-25, 1.27e-24, 1.84e-24, 2.45e-24, 3.09e-24, 3.76e-24, 4.46e-24, 5.17e-24, 5.9e-24, 6.65e-24, 7.41e-24, 8.17e-24, 8.93e-24, 9.7e-24, 1.05e-23, 1.13e-23, 1.22e-23, 1.3e-23, 1.38e-23, 1.46e-23, 1.54e-23, 1.63e-23, 1.71e-23, 1.8e-23, 1.88e-23, 1.96e-23, 2.05e-23, 2.13e-23, 2.21e-23, 2.3e-23, 2.38e-23, 2.47e-23, 2.55e-23, 2.64e-23, 2.72e-23, 2.8e-23, 2.89e-23, 2.97e-23, 3.05e-23, 3.13e-23, 3.22e-23, 3.3e-23, 3.39e-23, 3.47e-23, 3.56e-23, 3.64e-23, 3.72e-23, 3.8e-23, 3.88e-23, 3.97e-23, 4.05e-23, 4.14e-23, 4.22e-23, 4.31e-23, 4.39e-23, 4.47e-23, 4.56e-23, 4.65e-23, 4.73e-23, 4.81e-23, 4.9e-23, 4.98e-23, 5.07e-23, 5.16e-23, 5.24e-23, 5.33e-23, 5.41e-23, 5.5e-23, 5.5e-23]),
		ExplicitContinuum(j=105, i=91, wavelengthGrid=[1.678, 2.268, 2.747, 3.162, 3.535, 3.876, 4.194, 4.491, 4.773, 5.04, 5.296, 5.542, 5.778, 6.007, 6.228, 6.442, 6.651, 6.854, 7.052, 7.245, 7.434, 7.619, 7.8, 7.977, 8.151, 8.322, 8.49, 8.655, 8.817, 8.977, 9.135, 9.289, 9.443, 9.593, 9.742, 9.889, 10.034, 10.177, 10.318, 10.458, 10.596, 10.733, 10.868, 11.002, 11.134, 11.265, 11.394, 11.523, 11.65, 11.776, 11.901, 12.024, 12.147, 12.268, 12.389, 12.508, 12.627, 12.744, 12.861, 12.977, 13.091, 13.205, 13.318, 13.431, 13.542, 13.653, 13.763, 13.872, 13.98, 14.088, 14.141512654905226], alphaGrid=[7.83e-26, 1.61e-25, 3.12e-25, 5.05e-25, 7.35e-25, 1e-24, 1.3e-24, 1.63e-24, 1.99e-24, 2.37e-24, 2.79e-24, 3.23e-24, 3.69e-24, 4.18e-24, 4.69e-24, 5.23e-24, 5.79e-24, 6.37e-24, 6.97e-24, 7.59e-24, 8.23e-24, 8.89e-24, 9.56e-24, 1.02e-23, 1.09e-23, 1.17e-23, 1.24e-23, 1.32e-23, 1.4e-23, 1.49e-23, 1.57e-23, 1.65e-23, 1.73e-23, 1.82e-23, 1.91e-23, 1.99e-23, 2.09e-23, 2.18e-23, 2.27e-23, 2.37e-23, 2.46e-23, 2.56e-23, 2.66e-23, 2.76e-23, 2.86e-23, 2.97e-23, 3.07e-23, 3.18e-23, 3.28e-23, 3.39e-23, 3.5e-23, 3.61e-23, 3.72e-23, 3.84e-23, 3.95e-23, 4.06e-23, 4.18e-23, 4.3e-23, 4.42e-23, 4.54e-23, 4.66e-23, 4.78e-23, 4.91e-23, 5.03e-23, 5.15e-23, 5.28e-23, 5.41e-23, 5.53e-23, 5.66e-23, 5.79e-23, 5.79e-23]),
		ExplicitContinuum(j=105, i=92, wavelengthGrid=[1.678, 2.268, 2.747, 3.162, 3.535, 3.876, 4.194, 4.491, 4.773, 5.04, 5.296, 5.542, 5.778, 6.007, 6.228, 6.442, 6.651, 6.854, 7.052, 7.245, 7.434, 7.619, 7.8, 7.977, 8.151, 8.322, 8.49, 8.655, 8.817, 8.977, 9.135, 9.289, 9.443, 9.593, 9.742, 9.889, 10.034, 10.177, 10.318, 10.458, 10.596, 10.733, 10.868, 11.002, 11.134, 11.265, 11.394, 11.523, 11.65, 11.776, 11.901, 12.024, 12.147, 12.268, 12.389, 12.508, 12.627, 12.744, 12.861, 12.977, 13.091, 13.205, 13.318, 13.431, 13.542, 13.653, 13.763, 13.872, 13.98, 14.088, 14.141762837288816], alphaGrid=[7.83e-26, 1.61e-25, 3.12e-25, 5.05e-25, 7.35e-25, 1e-24, 1.3e-24, 1.63e-24, 1.99e-24, 2.37e-24, 2.79e-24, 3.23e-24, 3.69e-24, 4.18e-24, 4.69e-24, 5.23e-24, 5.79e-24, 6.37e-24, 6.97e-24, 7.59e-24, 8.23e-24, 8.89e-24, 9.56e-24, 1.02e-23, 1.09e-23, 1.17e-23, 1.24e-23, 1.32e-23, 1.4e-23, 1.49e-23, 1.57e-23, 1.65e-23, 1.73e-23, 1.82e-23, 1.91e-23, 1.99e-23, 2.09e-23, 2.18e-23, 2.27e-23, 2.37e-23, 2.46e-23, 2.56e-23, 2.66e-23, 2.76e-23, 2.86e-23, 2.97e-23, 3.07e-23, 3.18e-23, 3.28e-23, 3.39e-23, 3.5e-23, 3.61e-23, 3.72e-23, 3.84e-23, 3.95e-23, 4.06e-23, 4.18e-23, 4.3e-23, 4.42e-23, 4.54e-23, 4.66e-23, 4.78e-23, 4.91e-23, 5.03e-23, 5.15e-23, 5.28e-23, 5.41e-23, 5.53e-23, 5.66e-23, 5.79e-23, 5.79e-23]),
		ExplicitContinuum(j=105, i=93, wavelengthGrid=[1.678, 2.268, 2.747, 3.162, 3.535, 3.876, 4.194, 4.491, 4.773, 5.04, 5.296, 5.542, 5.778, 6.007, 6.228, 6.442, 6.651, 6.854, 7.052, 7.245, 7.434, 7.619, 7.8, 7.977, 8.151, 8.322, 8.49, 8.655, 8.817, 8.977, 9.135, 9.289, 9.443, 9.593, 9.742, 9.889, 10.034, 10.177, 10.318, 10.458, 10.596, 10.733, 10.868, 11.002, 11.134, 11.265, 11.394, 11.523, 11.65, 11.776, 11.901, 12.024, 12.147, 12.268, 12.389, 12.508, 12.627, 12.744, 12.861, 12.977, 13.091, 13.205, 13.318, 13.431, 13.542, 13.653, 13.763, 13.872, 13.98, 14.088, 14.14422857716095], alphaGrid=[7.83e-26, 1.61e-25, 3.12e-25, 5.05e-25, 7.35e-25, 1e-24, 1.3e-24, 1.63e-24, 1.99e-24, 2.37e-24, 2.79e-24, 3.23e-24, 3.69e-24, 4.18e-24, 4.69e-24, 5.23e-24, 5.79e-24, 6.37e-24, 6.97e-24, 7.59e-24, 8.23e-24, 8.89e-24, 9.56e-24, 1.02e-23, 1.09e-23, 1.17e-23, 1.24e-23, 1.32e-23, 1.4e-23, 1.49e-23, 1.57e-23, 1.65e-23, 1.73e-23, 1.82e-23, 1.91e-23, 1.99e-23, 2.09e-23, 2.18e-23, 2.27e-23, 2.37e-23, 2.46e-23, 2.56e-23, 2.66e-23, 2.76e-23, 2.86e-23, 2.97e-23, 3.07e-23, 3.18e-23, 3.28e-23, 3.39e-23, 3.5e-23, 3.61e-23, 3.72e-23, 3.84e-23, 3.95e-23, 4.06e-23, 4.18e-23, 4.3e-23, 4.42e-23, 4.54e-23, 4.66e-23, 4.78e-23, 4.91e-23, 5.03e-23, 5.15e-23, 5.28e-23, 5.41e-23, 5.53e-23, 5.66e-23, 5.79e-23, 5.79e-23]),
		ExplicitContinuum(j=105, i=94, wavelengthGrid=[2.213, 2.722, 3.161, 3.553, 3.911, 4.243, 4.554, 4.848, 5.128, 5.395, 5.652, 5.899, 6.138, 6.369, 6.592, 6.81, 7.022, 7.229, 7.43, 7.628, 7.821, 8.009, 8.195, 8.376, 8.555, 8.73, 8.903, 9.072, 9.239, 9.404, 9.566, 9.726, 9.883, 10.038, 10.192, 10.343, 10.493, 10.641, 10.787, 10.931, 11.074, 11.215, 11.355, 11.493, 11.63, 11.766, 11.9, 12.033, 12.165, 12.295, 12.425, 12.553, 12.68, 12.806, 12.931, 13.055, 13.178, 13.3, 13.422, 13.542, 13.661, 13.779, 13.897, 14.013, 14.129, 14.244, 14.359, 14.472, 14.585, 14.697, 14.729337501604272], alphaGrid=[6.35e-26, 1.16e-25, 2.13e-25, 3.41e-25, 4.97e-25, 6.82e-25, 8.96e-25, 1.14e-24, 1.4e-24, 1.7e-24, 2.02e-24, 2.35e-24, 2.71e-24, 3.11e-24, 3.53e-24, 3.97e-24, 4.43e-24, 4.91e-24, 5.42e-24, 5.95e-24, 6.49e-24, 7.05e-24, 7.63e-24, 8.23e-24, 8.85e-24, 9.49e-24, 1.02e-23, 1.08e-23, 1.15e-23, 1.22e-23, 1.29e-23, 1.36e-23, 1.44e-23, 1.51e-23, 1.59e-23, 1.67e-23, 1.75e-23, 1.84e-23, 1.92e-23, 2.01e-23, 2.1e-23, 2.18e-23, 2.27e-23, 2.37e-23, 2.46e-23, 2.55e-23, 2.65e-23, 2.74e-23, 2.84e-23, 2.94e-23, 3.04e-23, 3.14e-23, 3.24e-23, 3.35e-23, 3.46e-23, 3.56e-23, 3.67e-23, 3.78e-23, 3.89e-23, 4e-23, 4.11e-23, 4.23e-23, 4.34e-23, 4.46e-23, 4.57e-23, 4.69e-23, 4.82e-23, 4.94e-23, 5.06e-23, 5.19e-23, 5.19e-23]),
		ExplicitContinuum(j=105, i=95, wavelengthGrid=[1.389, 2.715, 3.748, 4.643, 5.452, 6.201, 6.903, 7.568, 8.202, 8.811, 9.398, 9.966, 10.516, 11.052, 11.573, 12.082, 12.58, 13.067, 13.544, 14.013, 14.473, 14.925, 15.37, 15.808, 16.239, 16.664, 17.084, 17.498, 17.907, 18.31, 18.71, 19.103, 19.494, 19.879, 20.261, 20.639, 21.013, 21.384, 21.751, 22.114, 22.475, 22.832, 23.187, 23.538, 23.887, 24.232, 24.575, 24.916, 25.254, 25.59, 25.923, 26.254, 26.583, 26.909, 27.233, 27.556, 27.876, 28.194, 28.511, 28.825, 29.137, 29.448, 29.757, 30.065, 30.37, 30.674, 30.976, 30.986022233257987], alphaGrid=[1.5e-25, 4.35e-25, 9.49e-25, 1.57e-24, 2.28e-24, 3.06e-24, 3.89e-24, 4.79e-24, 5.72e-24, 6.68e-24, 7.68e-24, 8.72e-24, 9.79e-24, 1.09e-23, 1.2e-23, 1.31e-23, 1.44e-23, 1.55e-23, 1.68e-23, 1.8e-23, 1.92e-23, 2.05e-23, 2.17e-23, 2.3e-23, 2.44e-23, 2.57e-23, 2.7e-23, 2.84e-23, 2.97e-23, 3.11e-23, 3.25e-23, 3.38e-23, 3.52e-23, 3.67e-23, 3.81e-23, 3.95e-23, 4.1e-23, 4.24e-23, 4.38e-23, 4.53e-23, 4.68e-23, 4.83e-23, 4.98e-23, 5.13e-23, 5.28e-23, 5.42e-23, 5.57e-23, 5.73e-23, 5.88e-23, 6.03e-23, 6.18e-23, 6.34e-23, 6.5e-23, 6.65e-23, 6.8e-23, 6.96e-23, 7.12e-23, 7.28e-23, 7.43e-23, 7.59e-23, 7.74e-23, 7.9e-23, 8.06e-23, 8.22e-23, 8.38e-23, 8.54e-23, 8.7e-23, 8.7e-23]),
		ExplicitContinuum(j=105, i=96, wavelengthGrid=[1.544, 2.856, 3.899, 4.811, 5.638, 6.406, 7.127, 7.812, 8.467, 9.096, 9.702, 10.289, 10.859, 11.414, 11.955, 12.483, 12.999, 13.505, 14.001, 14.488, 14.966, 15.437, 15.9, 16.356, 16.805, 17.248, 17.685, 18.117, 18.543, 18.964, 19.38, 19.792, 20.199, 20.601, 21.0, 21.395, 21.785, 22.173, 22.556, 22.936, 23.313, 23.687, 24.058, 24.425, 24.79, 25.152, 25.511, 25.868, 26.222, 26.573, 26.922, 27.268, 27.613, 27.955, 28.294, 28.632, 28.968, 29.302, 29.633, 29.963, 30.29, 30.616, 30.94, 31.263, 31.583, 31.902, 32.1431619403903], alphaGrid=[1.48e-25, 4.13e-25, 9.01e-25, 1.5e-24, 2.2e-24, 2.97e-24, 3.8e-24, 4.67e-24, 5.63e-24, 6.63e-24, 7.67e-24, 8.74e-24, 9.86e-24, 1.1e-23, 1.22e-23, 1.33e-23, 1.46e-23, 1.59e-23, 1.71e-23, 1.84e-23, 1.97e-23, 2.1e-23, 2.24e-23, 2.37e-23, 2.51e-23, 2.65e-23, 2.79e-23, 2.93e-23, 3.08e-23, 3.22e-23, 3.37e-23, 3.52e-23, 3.67e-23, 3.82e-23, 3.97e-23, 4.12e-23, 4.28e-23, 4.43e-23, 4.59e-23, 4.75e-23, 4.91e-23, 5.07e-23, 5.22e-23, 5.39e-23, 5.55e-23, 5.71e-23, 5.87e-23, 6.03e-23, 6.2e-23, 6.37e-23, 6.53e-23, 6.7e-23, 6.87e-23, 7.04e-23, 7.21e-23, 7.38e-23, 7.56e-23, 7.73e-23, 7.9e-23, 8.07e-23, 8.24e-23, 8.42e-23, 8.6e-23, 8.78e-23, 8.95e-23, 9.13e-23, 9.13e-23]),
		ExplicitContinuum(j=105, i=97, wavelengthGrid=[2.82, 3.856, 4.761, 5.582, 6.344, 7.06, 7.739, 8.389, 9.013, 9.614, 10.197, 10.762, 11.312, 11.848, 12.372, 12.884, 13.386, 13.878, 14.361, 14.835, 15.302, 15.761, 16.214, 16.659, 17.099, 17.532, 17.96, 18.383, 18.8, 19.213, 19.621, 20.025, 20.424, 20.819, 21.21, 21.598, 21.982, 22.363, 22.74, 23.113, 23.484, 23.851, 24.216, 24.578, 24.936, 25.293, 25.646, 25.998, 26.346, 26.692, 27.036, 27.377, 27.717, 28.053, 28.388, 28.721, 29.052, 29.381, 29.708, 30.033, 30.356, 30.677, 30.997, 31.315, 31.631, 31.945, 32.16777051818755], alphaGrid=[1.35e-25, 2.77e-25, 5.47e-25, 9.01e-25, 1.34e-24, 1.85e-24, 2.44e-24, 3.09e-24, 3.81e-24, 4.59e-24, 5.43e-24, 6.33e-24, 7.28e-24, 8.29e-24, 9.35e-24, 1.05e-23, 1.16e-23, 1.28e-23, 1.4e-23, 1.53e-23, 1.67e-23, 1.8e-23, 1.94e-23, 2.09e-23, 2.24e-23, 2.39e-23, 2.54e-23, 2.71e-23, 2.87e-23, 3.04e-23, 3.2e-23, 3.38e-23, 3.55e-23, 3.73e-23, 3.91e-23, 4.09e-23, 4.28e-23, 4.47e-23, 4.66e-23, 4.86e-23, 5.06e-23, 5.25e-23, 5.46e-23, 5.67e-23, 5.87e-23, 6.08e-23, 6.3e-23, 6.51e-23, 6.72e-23, 6.94e-23, 7.16e-23, 7.38e-23, 7.6e-23, 7.83e-23, 8.06e-23, 8.29e-23, 8.51e-23, 8.75e-23, 8.99e-23, 9.23e-23, 9.46e-23, 9.7e-23, 9.93e-23, 1.02e-22, 1.04e-22, 1.06e-22, 1.06e-22]),
		ExplicitContinuum(j=105, i=98, wavelengthGrid=[2.82, 3.856, 4.761, 5.582, 6.344, 7.06, 7.739, 8.389, 9.013, 9.614, 10.197, 10.762, 11.312, 11.848, 12.372, 12.884, 13.386, 13.878, 14.361, 14.835, 15.302, 15.761, 16.214, 16.659, 17.099, 17.532, 17.96, 18.383, 18.8, 19.213, 19.621, 20.025, 20.424, 20.819, 21.21, 21.598, 21.982, 22.363, 22.74, 23.113, 23.484, 23.851, 24.216, 24.578, 24.936, 25.293, 25.646, 25.998, 26.346, 26.692, 27.036, 27.377, 27.717, 28.053, 28.388, 28.721, 29.052, 29.381, 29.708, 30.033, 30.356, 30.677, 30.997, 31.315, 31.631, 31.945, 32.16777051818755], alphaGrid=[1.35e-25, 2.77e-25, 5.47e-25, 9.01e-25, 1.34e-24, 1.85e-24, 2.44e-24, 3.09e-24, 3.81e-24, 4.59e-24, 5.43e-24, 6.33e-24, 7.28e-24, 8.29e-24, 9.35e-24, 1.05e-23, 1.16e-23, 1.28e-23, 1.4e-23, 1.53e-23, 1.67e-23, 1.8e-23, 1.94e-23, 2.09e-23, 2.24e-23, 2.39e-23, 2.54e-23, 2.71e-23, 2.87e-23, 3.04e-23, 3.2e-23, 3.38e-23, 3.55e-23, 3.73e-23, 3.91e-23, 4.09e-23, 4.28e-23, 4.47e-23, 4.66e-23, 4.86e-23, 5.06e-23, 5.25e-23, 5.46e-23, 5.67e-23, 5.87e-23, 6.08e-23, 6.3e-23, 6.51e-23, 6.72e-23, 6.94e-23, 7.16e-23, 7.38e-23, 7.6e-23, 7.83e-23, 8.06e-23, 8.29e-23, 8.51e-23, 8.75e-23, 8.99e-23, 9.23e-23, 9.46e-23, 9.7e-23, 9.93e-23, 1.02e-22, 1.04e-22, 1.06e-22, 1.06e-22]),
		ExplicitContinuum(j=105, i=99, wavelengthGrid=[2.82, 3.856, 4.761, 5.582, 6.344, 7.06, 7.739, 8.389, 9.013, 9.614, 10.197, 10.762, 11.312, 11.848, 12.372, 12.884, 13.386, 13.878, 14.361, 14.835, 15.302, 15.761, 16.214, 16.659, 17.099, 17.532, 17.96, 18.383, 18.8, 19.213, 19.621, 20.025, 20.424, 20.819, 21.21, 21.598, 21.982, 22.363, 22.74, 23.113, 23.484, 23.851, 24.216, 24.578, 24.936, 25.293, 25.646, 25.998, 26.346, 26.692, 27.036, 27.377, 27.717, 28.053, 28.388, 28.721, 29.052, 29.381, 29.708, 30.033, 30.356, 30.677, 30.997, 31.315, 31.631, 31.945, 32.16777051818755], alphaGrid=[1.35e-25, 2.77e-25, 5.47e-25, 9.01e-25, 1.34e-24, 1.85e-24, 2.44e-24, 3.09e-24, 3.81e-24, 4.59e-24, 5.43e-24, 6.33e-24, 7.28e-24, 8.29e-24, 9.35e-24, 1.05e-23, 1.16e-23, 1.28e-23, 1.4e-23, 1.53e-23, 1.67e-23, 1.8e-23, 1.94e-23, 2.09e-23, 2.24e-23, 2.39e-23, 2.54e-23, 2.71e-23, 2.87e-23, 3.04e-23, 3.2e-23, 3.38e-23, 3.55e-23, 3.73e-23, 3.91e-23, 4.09e-23, 4.28e-23, 4.47e-23, 4.66e-23, 4.86e-23, 5.06e-23, 5.25e-23, 5.46e-23, 5.67e-23, 5.87e-23, 6.08e-23, 6.3e-23, 6.51e-23, 6.72e-23, 6.94e-23, 7.16e-23, 7.38e-23, 7.6e-23, 7.83e-23, 8.06e-23, 8.29e-23, 8.51e-23, 8.75e-23, 8.99e-23, 9.23e-23, 9.46e-23, 9.7e-23, 9.93e-23, 1.02e-22, 1.04e-22, 1.06e-22, 1.06e-22]),
		ExplicitContinuum(j=105, i=100, wavelengthGrid=[5.414, 6.176, 6.891, 7.569, 8.218, 8.84, 9.441, 10.022, 10.586, 11.135, 11.67, 12.193, 12.704, 13.205, 13.696, 14.179, 14.652, 15.118, 15.577, 16.028, 16.473, 16.913, 17.345, 17.773, 18.195, 18.612, 19.025, 19.432, 19.836, 20.235, 20.63, 21.021, 21.408, 21.792, 22.172, 22.55, 22.923, 23.294, 23.661, 24.026, 24.388, 24.747, 25.103, 25.456, 25.807, 26.156, 26.503, 26.846, 27.188, 27.527, 27.864, 28.199, 28.533, 28.864, 29.192, 29.52, 29.845, 30.169, 30.49, 30.81, 31.128, 31.445, 31.76, 32.073, 32.384, 32.694, 32.788695504405304], alphaGrid=[8.45e-26, 1.24e-25, 1.97e-25, 2.9e-25, 4.05e-25, 5.47e-25, 7.14e-25, 9.07e-25, 1.13e-24, 1.38e-24, 1.66e-24, 1.97e-24, 2.31e-24, 2.68e-24, 3.08e-24, 3.51e-24, 3.98e-24, 4.49e-24, 5.03e-24, 5.6e-24, 6.2e-24, 6.84e-24, 7.51e-24, 8.23e-24, 8.97e-24, 9.75e-24, 1.06e-23, 1.14e-23, 1.23e-23, 1.33e-23, 1.42e-23, 1.52e-23, 1.62e-23, 1.73e-23, 1.84e-23, 1.96e-23, 2.08e-23, 2.21e-23, 2.33e-23, 2.46e-23, 2.59e-23, 2.73e-23, 2.87e-23, 3.02e-23, 3.17e-23, 3.33e-23, 3.48e-23, 3.65e-23, 3.81e-23, 3.98e-23, 4.16e-23, 4.33e-23, 4.51e-23, 4.7e-23, 4.89e-23, 5.08e-23, 5.28e-23, 5.48e-23, 5.68e-23, 5.9e-23, 6.11e-23, 6.32e-23, 6.54e-23, 6.78e-23, 7.01e-23, 7.24e-23, 7.24e-23]),
		ExplicitContinuum(j=105, i=101, wavelengthGrid=[5.414, 6.176, 6.891, 7.569, 8.218, 8.84, 9.441, 10.022, 10.586, 11.135, 11.67, 12.193, 12.704, 13.205, 13.696, 14.179, 14.652, 15.118, 15.577, 16.028, 16.473, 16.913, 17.345, 17.773, 18.195, 18.612, 19.025, 19.432, 19.836, 20.235, 20.63, 21.021, 21.408, 21.792, 22.172, 22.55, 22.923, 23.294, 23.661, 24.026, 24.388, 24.747, 25.103, 25.456, 25.807, 26.156, 26.503, 26.846, 27.188, 27.527, 27.864, 28.199, 28.533, 28.864, 29.192, 29.52, 29.845, 30.169, 30.49, 30.81, 31.128, 31.445, 31.76, 32.073, 32.384, 32.694, 32.788695504405304], alphaGrid=[8.45e-26, 1.24e-25, 1.97e-25, 2.9e-25, 4.05e-25, 5.47e-25, 7.14e-25, 9.07e-25, 1.13e-24, 1.38e-24, 1.66e-24, 1.97e-24, 2.31e-24, 2.68e-24, 3.08e-24, 3.51e-24, 3.98e-24, 4.49e-24, 5.03e-24, 5.6e-24, 6.2e-24, 6.84e-24, 7.51e-24, 8.23e-24, 8.97e-24, 9.75e-24, 1.06e-23, 1.14e-23, 1.23e-23, 1.33e-23, 1.42e-23, 1.52e-23, 1.62e-23, 1.73e-23, 1.84e-23, 1.96e-23, 2.08e-23, 2.21e-23, 2.33e-23, 2.46e-23, 2.59e-23, 2.73e-23, 2.87e-23, 3.02e-23, 3.17e-23, 3.33e-23, 3.48e-23, 3.65e-23, 3.81e-23, 3.98e-23, 4.16e-23, 4.33e-23, 4.51e-23, 4.7e-23, 4.89e-23, 5.08e-23, 5.28e-23, 5.48e-23, 5.68e-23, 5.9e-23, 6.11e-23, 6.32e-23, 6.54e-23, 6.78e-23, 7.01e-23, 7.24e-23, 7.24e-23]),
		ExplicitContinuum(j=105, i=102, wavelengthGrid=[5.414, 6.176, 6.891, 7.569, 8.218, 8.84, 9.441, 10.022, 10.586, 11.135, 11.67, 12.193, 12.704, 13.205, 13.696, 14.179, 14.652, 15.118, 15.577, 16.028, 16.473, 16.913, 17.345, 17.773, 18.195, 18.612, 19.025, 19.432, 19.836, 20.235, 20.63, 21.021, 21.408, 21.792, 22.172, 22.55, 22.923, 23.294, 23.661, 24.026, 24.388, 24.747, 25.103, 25.456, 25.807, 26.156, 26.503, 26.846, 27.188, 27.527, 27.864, 28.199, 28.533, 28.864, 29.192, 29.52, 29.845, 30.169, 30.49, 30.81, 31.128, 31.445, 31.76, 32.073, 32.384, 32.694, 32.78977063821039], alphaGrid=[8.45e-26, 1.24e-25, 1.97e-25, 2.9e-25, 4.05e-25, 5.47e-25, 7.14e-25, 9.07e-25, 1.13e-24, 1.38e-24, 1.66e-24, 1.97e-24, 2.31e-24, 2.68e-24, 3.08e-24, 3.51e-24, 3.98e-24, 4.49e-24, 5.03e-24, 5.6e-24, 6.2e-24, 6.84e-24, 7.51e-24, 8.23e-24, 8.97e-24, 9.75e-24, 1.06e-23, 1.14e-23, 1.23e-23, 1.33e-23, 1.42e-23, 1.52e-23, 1.62e-23, 1.73e-23, 1.84e-23, 1.96e-23, 2.08e-23, 2.21e-23, 2.33e-23, 2.46e-23, 2.59e-23, 2.73e-23, 2.87e-23, 3.02e-23, 3.17e-23, 3.33e-23, 3.48e-23, 3.65e-23, 3.81e-23, 3.98e-23, 4.16e-23, 4.33e-23, 4.51e-23, 4.7e-23, 4.89e-23, 5.08e-23, 5.28e-23, 5.48e-23, 5.68e-23, 5.9e-23, 6.11e-23, 6.32e-23, 6.54e-23, 6.78e-23, 7.01e-23, 7.24e-23, 7.24e-23]),
		ExplicitContinuum(j=105, i=103, wavelengthGrid=[5.498, 6.254, 6.965, 7.639, 8.284, 8.904, 9.502, 10.081, 10.644, 11.191, 11.725, 12.246, 12.756, 13.256, 13.746, 14.227, 14.7, 15.165, 15.623, 16.073, 16.518, 16.956, 17.388, 17.815, 18.237, 18.654, 19.065, 19.473, 19.875, 20.274, 20.669, 21.059, 21.446, 21.83, 22.21, 22.586, 22.96, 23.33, 23.697, 24.061, 24.422, 24.781, 25.137, 25.49, 25.841, 26.19, 26.536, 26.879, 27.221, 27.56, 27.897, 28.232, 28.564, 28.895, 29.224, 29.551, 29.876, 30.2, 30.521, 30.841, 31.159, 31.475, 31.789, 32.103, 32.414, 32.724, 32.8127954125717], alphaGrid=[8.25e-26, 1.21e-25, 1.91e-25, 2.81e-25, 3.92e-25, 5.3e-25, 6.95e-25, 8.85e-25, 1.1e-24, 1.35e-24, 1.62e-24, 1.93e-24, 2.26e-24, 2.63e-24, 3.02e-24, 3.45e-24, 3.91e-24, 4.4e-24, 4.93e-24, 5.49e-24, 6.09e-24, 6.71e-24, 7.37e-24, 8.07e-24, 8.79e-24, 9.56e-24, 1.04e-23, 1.12e-23, 1.21e-23, 1.29e-23, 1.39e-23, 1.49e-23, 1.59e-23, 1.7e-23, 1.81e-23, 1.92e-23, 2.04e-23, 2.16e-23, 2.28e-23, 2.41e-23, 2.54e-23, 2.68e-23, 2.82e-23, 2.97e-23, 3.12e-23, 3.27e-23, 3.42e-23, 3.58e-23, 3.74e-23, 3.91e-23, 4.08e-23, 4.26e-23, 4.43e-23, 4.62e-23, 4.81e-23, 5e-23, 5.2e-23, 5.4e-23, 5.6e-23, 5.81e-23, 6.02e-23, 6.24e-23, 6.46e-23, 6.69e-23, 6.92e-23, 7.14e-23, 7.14e-23]),
		ExplicitContinuum(j=105, i=104, wavelengthGrid=[3.373, 4.351, 5.225, 6.029, 6.781, 7.492, 8.169, 8.819, 9.445, 10.05, 10.636, 11.207, 11.762, 12.305, 12.835, 13.354, 13.863, 14.363, 14.854, 15.336, 15.811, 16.278, 16.739, 17.193, 17.641, 18.083, 18.519, 18.951, 19.378, 19.799, 20.216, 20.628, 21.037, 21.441, 21.841, 22.238, 22.631, 23.021, 23.407, 23.789, 24.169, 24.546, 24.919, 25.29, 25.658, 26.023, 26.386, 26.746, 27.103, 27.459, 27.811, 28.162, 28.51, 28.856, 29.2, 29.542, 29.882, 30.22, 30.555, 30.889, 31.221, 31.552, 31.88, 32.207, 32.532, 32.855, 33.01276170037391], alphaGrid=[1.32e-25, 2.5e-25, 4.69e-25, 7.6e-25, 1.12e-24, 1.55e-24, 2.04e-24, 2.6e-24, 3.22e-24, 3.91e-24, 4.66e-24, 5.45e-24, 6.3e-24, 7.21e-24, 8.16e-24, 9.17e-24, 1.02e-23, 1.13e-23, 1.25e-23, 1.36e-23, 1.49e-23, 1.62e-23, 1.74e-23, 1.88e-23, 2.02e-23, 2.16e-23, 2.31e-23, 2.46e-23, 2.61e-23, 2.77e-23, 2.93e-23, 3.1e-23, 3.26e-23, 3.43e-23, 3.61e-23, 3.79e-23, 3.97e-23, 4.15e-23, 4.33e-23, 4.52e-23, 4.71e-23, 4.91e-23, 5.1e-23, 5.31e-23, 5.51e-23, 5.71e-23, 5.92e-23, 6.13e-23, 6.34e-23, 6.55e-23, 6.78e-23, 7e-23, 7.22e-23, 7.44e-23, 7.67e-23, 7.9e-23, 8.13e-23, 8.36e-23, 8.6e-23, 8.84e-23, 9.08e-23, 9.31e-23, 9.55e-23, 9.8e-23, 1e-22, 1.03e-22, 1.03e-22]),
		ExplicitContinuum(j=114, i=105, wavelengthGrid=[0.213, 0.471, 0.606, 0.707, 0.791, 0.863, 0.928, 0.987, 1.041, 1.091, 1.138, 1.182, 1.224, 1.264, 1.303, 1.339, 1.375, 1.409, 1.441, 1.473, 1.504, 1.534, 1.563, 1.592, 1.619, 1.646, 1.673, 1.698, 1.724, 1.748, 1.773, 1.796, 1.82, 1.842, 1.865, 1.887, 1.909, 1.93, 1.951, 1.972, 1.992, 2.012, 2.032, 2.051, 2.071, 2.09, 2.108, 2.127, 2.145, 2.163, 2.181, 2.198, 2.216, 2.233, 2.25, 2.267, 2.284, 2.3, 2.316, 2.333, 2.349, 2.364, 2.38, 2.396, 2.411, 2.426, 2.441, 2.456, 2.471, 2.486, 2.5, 2.515, 2.529, 2.530408773076004], alphaGrid=[3.56e-26, 1.35e-25, 2.97e-25, 4.73e-25, 6.6e-25, 8.55e-25, 1.06e-24, 1.26e-24, 1.47e-24, 1.69e-24, 1.91e-24, 2.13e-24, 2.35e-24, 2.58e-24, 2.8e-24, 3.04e-24, 3.27e-24, 3.5e-24, 3.74e-24, 3.97e-24, 4.21e-24, 4.45e-24, 4.69e-24, 4.93e-24, 5.18e-24, 5.42e-24, 5.66e-24, 5.91e-24, 6.16e-24, 6.4e-24, 6.65e-24, 6.9e-24, 7.15e-24, 7.4e-24, 7.65e-24, 7.9e-24, 8.15e-24, 8.4e-24, 8.66e-24, 8.91e-24, 9.17e-24, 9.42e-24, 9.67e-24, 9.93e-24, 1.02e-23, 1.04e-23, 1.07e-23, 1.1e-23, 1.12e-23, 1.15e-23, 1.17e-23, 1.2e-23, 1.22e-23, 1.25e-23, 1.28e-23, 1.3e-23, 1.33e-23, 1.35e-23, 1.38e-23, 1.41e-23, 1.43e-23, 1.46e-23, 1.48e-23, 1.51e-23, 1.54e-23, 1.56e-23, 1.59e-23, 1.62e-23, 1.64e-23, 1.67e-23, 1.69e-23, 1.72e-23, 1.75e-23, 1.75e-23]),
		ExplicitContinuum(j=114, i=106, wavelengthGrid=[0.852, 1.408, 1.812, 2.147, 2.441, 2.705, 2.949, 3.175, 3.388, 3.589, 3.781, 3.964, 4.14, 4.31, 4.474, 4.632, 4.786, 4.935, 5.081, 5.222, 5.361, 5.496, 5.629, 5.758, 5.885, 6.01, 6.132, 6.252, 6.371, 6.487, 6.601, 6.714, 6.825, 6.934, 7.042, 7.148, 7.253, 7.357, 7.459, 7.56, 7.66, 7.759, 7.856, 7.953, 8.048, 8.143, 8.236, 8.329, 8.42, 8.511, 8.601, 8.69, 8.778, 8.865, 8.952, 9.038, 9.123, 9.208, 9.292, 9.375, 9.457, 9.539, 9.62, 9.701, 9.781, 9.86, 9.939, 10.017, 10.095, 10.120918509992507], alphaGrid=[1.43e-26, 4.79e-26, 1.2e-25, 2.21e-25, 3.47e-25, 4.98e-25, 6.72e-25, 8.67e-25, 1.08e-24, 1.32e-24, 1.57e-24, 1.85e-24, 2.14e-24, 2.44e-24, 2.77e-24, 3.11e-24, 3.46e-24, 3.83e-24, 4.21e-24, 4.61e-24, 5.02e-24, 5.45e-24, 5.89e-24, 6.34e-24, 6.8e-24, 7.28e-24, 7.77e-24, 8.28e-24, 8.79e-24, 9.32e-24, 9.85e-24, 1.04e-23, 1.1e-23, 1.15e-23, 1.21e-23, 1.27e-23, 1.33e-23, 1.39e-23, 1.45e-23, 1.52e-23, 1.58e-23, 1.65e-23, 1.71e-23, 1.78e-23, 1.85e-23, 1.92e-23, 1.98e-23, 2.06e-23, 2.13e-23, 2.2e-23, 2.27e-23, 2.35e-23, 2.42e-23, 2.5e-23, 2.57e-23, 2.65e-23, 2.73e-23, 2.81e-23, 2.89e-23, 2.97e-23, 3.05e-23, 3.13e-23, 3.21e-23, 3.3e-23, 3.38e-23, 3.47e-23, 3.55e-23, 3.64e-23, 3.73e-23, 3.73e-23]),
		ExplicitContinuum(j=114, i=107, wavelengthGrid=[0.852, 1.408, 1.812, 2.147, 2.441, 2.705, 2.949, 3.175, 3.388, 3.589, 3.781, 3.964, 4.14, 4.31, 4.474, 4.632, 4.786, 4.935, 5.081, 5.222, 5.361, 5.496, 5.629, 5.758, 5.885, 6.01, 6.132, 6.252, 6.371, 6.487, 6.601, 6.714, 6.825, 6.934, 7.042, 7.148, 7.253, 7.357, 7.459, 7.56, 7.66, 7.759, 7.856, 7.953, 8.048, 8.143, 8.236, 8.329, 8.42, 8.511, 8.601, 8.69, 8.778, 8.865, 8.952, 9.038, 9.123, 9.208, 9.292, 9.375, 9.457, 9.539, 9.62, 9.701, 9.781, 9.86, 9.939, 10.017, 10.095, 10.121186276916305], alphaGrid=[1.45e-25, 3.52e-25, 6.96e-25, 1.09e-24, 1.51e-24, 1.96e-24, 2.43e-24, 2.92e-24, 3.43e-24, 3.94e-24, 4.47e-24, 5.01e-24, 5.56e-24, 6.12e-24, 6.68e-24, 7.25e-24, 7.83e-24, 8.41e-24, 9e-24, 9.59e-24, 1.02e-23, 1.08e-23, 1.14e-23, 1.2e-23, 1.26e-23, 1.32e-23, 1.38e-23, 1.44e-23, 1.51e-23, 1.57e-23, 1.63e-23, 1.69e-23, 1.76e-23, 1.82e-23, 1.88e-23, 1.95e-23, 2.01e-23, 2.07e-23, 2.14e-23, 2.2e-23, 2.26e-23, 2.33e-23, 2.39e-23, 2.46e-23, 2.52e-23, 2.58e-23, 2.65e-23, 2.71e-23, 2.78e-23, 2.84e-23, 2.91e-23, 2.97e-23, 3.04e-23, 3.1e-23, 3.17e-23, 3.23e-23, 3.3e-23, 3.36e-23, 3.43e-23, 3.49e-23, 3.56e-23, 3.62e-23, 3.69e-23, 3.75e-23, 3.82e-23, 3.88e-23, 3.95e-23, 4.01e-23, 4.08e-23, 4.08e-23]),
		ExplicitContinuum(j=114, i=108, wavelengthGrid=[0.852, 1.408, 1.812, 2.147, 2.441, 2.705, 2.949, 3.175, 3.388, 3.589, 3.781, 3.964, 4.14, 4.31, 4.474, 4.632, 4.786, 4.935, 5.081, 5.222, 5.361, 5.496, 5.629, 5.758, 5.885, 6.01, 6.132, 6.252, 6.371, 6.487, 6.601, 6.714, 6.825, 6.934, 7.042, 7.148, 7.253, 7.357, 7.459, 7.56, 7.66, 7.759, 7.856, 7.953, 8.048, 8.143, 8.236, 8.329, 8.42, 8.511, 8.601, 8.69, 8.778, 8.865, 8.952, 9.038, 9.123, 9.208, 9.292, 9.375, 9.457, 9.539, 9.62, 9.701, 9.781, 9.86, 9.939, 10.017, 10.095, 10.125786109708871], alphaGrid=[1.43e-26, 4.79e-26, 1.2e-25, 2.21e-25, 3.47e-25, 4.98e-25, 6.72e-25, 8.67e-25, 1.08e-24, 1.32e-24, 1.57e-24, 1.85e-24, 2.14e-24, 2.44e-24, 2.77e-24, 3.11e-24, 3.46e-24, 3.83e-24, 4.21e-24, 4.61e-24, 5.02e-24, 5.45e-24, 5.89e-24, 6.34e-24, 6.8e-24, 7.28e-24, 7.77e-24, 8.28e-24, 8.79e-24, 9.32e-24, 9.85e-24, 1.04e-23, 1.1e-23, 1.15e-23, 1.21e-23, 1.27e-23, 1.33e-23, 1.39e-23, 1.45e-23, 1.52e-23, 1.58e-23, 1.65e-23, 1.71e-23, 1.78e-23, 1.85e-23, 1.92e-23, 1.98e-23, 2.06e-23, 2.13e-23, 2.2e-23, 2.27e-23, 2.35e-23, 2.42e-23, 2.5e-23, 2.57e-23, 2.65e-23, 2.73e-23, 2.81e-23, 2.89e-23, 2.97e-23, 3.05e-23, 3.13e-23, 3.21e-23, 3.3e-23, 3.38e-23, 3.47e-23, 3.55e-23, 3.64e-23, 3.73e-23, 3.73e-23]),
		ExplicitContinuum(j=114, i=109, wavelengthGrid=[1.918, 2.728, 3.419, 4.039, 4.61, 5.143, 5.647, 6.127, 6.586, 7.028, 7.456, 7.869, 8.271, 8.663, 9.044, 9.417, 9.781, 10.139, 10.489, 10.832, 11.17, 11.502, 11.829, 12.151, 12.468, 12.78, 13.089, 13.393, 13.694, 13.991, 14.284, 14.574, 14.861, 15.145, 15.425, 15.703, 15.978, 16.251, 16.521, 16.789, 17.054, 17.317, 17.577, 17.836, 18.092, 18.347, 18.599, 18.85, 19.098, 19.345, 19.59, 19.834, 20.075, 20.316, 20.554, 20.791, 21.027, 21.261, 21.493, 21.724, 21.954, 22.183, 22.41, 22.636, 22.77857447740226], alphaGrid=[6.64e-26, 1.52e-25, 3.2e-25, 5.48e-25, 8.33e-25, 1.17e-24, 1.56e-24, 2e-24, 2.49e-24, 3.01e-24, 3.59e-24, 4.2e-24, 4.86e-24, 5.55e-24, 6.27e-24, 7.04e-24, 7.84e-24, 8.67e-24, 9.53e-24, 1.04e-23, 1.13e-23, 1.23e-23, 1.33e-23, 1.43e-23, 1.53e-23, 1.64e-23, 1.75e-23, 1.86e-23, 1.97e-23, 2.09e-23, 2.21e-23, 2.33e-23, 2.45e-23, 2.57e-23, 2.7e-23, 2.83e-23, 2.96e-23, 3.09e-23, 3.23e-23, 3.36e-23, 3.5e-23, 3.64e-23, 3.78e-23, 3.93e-23, 4.07e-23, 4.22e-23, 4.37e-23, 4.52e-23, 4.67e-23, 4.82e-23, 4.98e-23, 5.13e-23, 5.29e-23, 5.45e-23, 5.61e-23, 5.77e-23, 5.94e-23, 6.1e-23, 6.27e-23, 6.43e-23, 6.6e-23, 6.77e-23, 6.94e-23, 7.12e-23, 7.12e-23]),
		ExplicitContinuum(j=114, i=110, wavelengthGrid=[1.918, 2.728, 3.419, 4.039, 4.61, 5.143, 5.647, 6.127, 6.586, 7.028, 7.456, 7.869, 8.271, 8.663, 9.044, 9.417, 9.781, 10.139, 10.489, 10.832, 11.17, 11.502, 11.829, 12.151, 12.468, 12.78, 13.089, 13.393, 13.694, 13.991, 14.284, 14.574, 14.861, 15.145, 15.425, 15.703, 15.978, 16.251, 16.521, 16.789, 17.054, 17.317, 17.577, 17.836, 18.092, 18.347, 18.599, 18.85, 19.098, 19.345, 19.59, 19.834, 20.075, 20.316, 20.554, 20.791, 21.027, 21.261, 21.493, 21.724, 21.954, 22.183, 22.41, 22.636, 22.778979716970042], alphaGrid=[3.09e-25, 5.74e-25, 1.01e-24, 1.51e-24, 2.08e-24, 2.69e-24, 3.35e-24, 4.05e-24, 4.78e-24, 5.55e-24, 6.35e-24, 7.17e-24, 8.02e-24, 8.9e-24, 9.79e-24, 1.07e-23, 1.16e-23, 1.26e-23, 1.36e-23, 1.46e-23, 1.56e-23, 1.66e-23, 1.77e-23, 1.87e-23, 1.98e-23, 2.09e-23, 2.2e-23, 2.31e-23, 2.42e-23, 2.53e-23, 2.65e-23, 2.76e-23, 2.88e-23, 3e-23, 3.12e-23, 3.24e-23, 3.36e-23, 3.48e-23, 3.6e-23, 3.72e-23, 3.85e-23, 3.97e-23, 4.1e-23, 4.23e-23, 4.35e-23, 4.48e-23, 4.61e-23, 4.74e-23, 4.87e-23, 5e-23, 5.13e-23, 5.26e-23, 5.4e-23, 5.53e-23, 5.67e-23, 5.8e-23, 5.94e-23, 6.07e-23, 6.21e-23, 6.35e-23, 6.48e-23, 6.62e-23, 6.76e-23, 6.9e-23, 6.9e-23]),
		ExplicitContinuum(j=114, i=111, wavelengthGrid=[1.918, 2.728, 3.419, 4.039, 4.61, 5.143, 5.647, 6.127, 6.586, 7.028, 7.456, 7.869, 8.271, 8.663, 9.044, 9.417, 9.781, 10.139, 10.489, 10.832, 11.17, 11.502, 11.829, 12.151, 12.468, 12.78, 13.089, 13.393, 13.694, 13.991, 14.284, 14.574, 14.861, 15.145, 15.425, 15.703, 15.978, 16.251, 16.521, 16.789, 17.054, 17.317, 17.577, 17.836, 18.092, 18.347, 18.599, 18.85, 19.098, 19.345, 19.59, 19.834, 20.075, 20.316, 20.554, 20.791, 21.027, 21.261, 21.493, 21.724, 21.954, 22.183, 22.41, 22.636, 22.78586684278924], alphaGrid=[4.31e-27, 1.27e-26, 3.34e-26, 6.74e-26, 1.17e-25, 1.84e-25, 2.69e-25, 3.74e-25, 4.99e-25, 6.47e-25, 8.16e-25, 1.01e-24, 1.23e-24, 1.47e-24, 1.73e-24, 2.02e-24, 2.34e-24, 2.68e-24, 3.05e-24, 3.45e-24, 3.87e-24, 4.32e-24, 4.8e-24, 5.3e-24, 5.83e-24, 6.39e-24, 6.98e-24, 7.6e-24, 8.24e-24, 8.92e-24, 9.62e-24, 1.03e-23, 1.11e-23, 1.19e-23, 1.27e-23, 1.36e-23, 1.44e-23, 1.53e-23, 1.63e-23, 1.72e-23, 1.82e-23, 1.92e-23, 2.03e-23, 2.14e-23, 2.25e-23, 2.36e-23, 2.48e-23, 2.6e-23, 2.72e-23, 2.85e-23, 2.97e-23, 3.11e-23, 3.24e-23, 3.38e-23, 3.52e-23, 3.66e-23, 3.81e-23, 3.96e-23, 4.11e-23, 4.26e-23, 4.42e-23, 4.58e-23, 4.75e-23, 4.91e-23, 4.91e-23]),
		ExplicitContinuum(j=114, i=112, wavelengthGrid=[1.918, 2.728, 3.419, 4.039, 4.61, 5.143, 5.647, 6.127, 6.586, 7.028, 7.456, 7.869, 8.271, 8.663, 9.044, 9.417, 9.781, 10.139, 10.489, 10.832, 11.17, 11.502, 11.829, 12.151, 12.468, 12.78, 13.089, 13.393, 13.694, 13.991, 14.284, 14.574, 14.861, 15.145, 15.425, 15.703, 15.978, 16.251, 16.521, 16.789, 17.054, 17.317, 17.577, 17.836, 18.092, 18.347, 18.599, 18.85, 19.098, 19.345, 19.59, 19.834, 20.075, 20.316, 20.554, 20.791, 21.027, 21.261, 21.493, 21.724, 21.954, 22.183, 22.41, 22.636, 22.78587878429731], alphaGrid=[6.64e-26, 1.52e-25, 3.2e-25, 5.48e-25, 8.33e-25, 1.17e-24, 1.56e-24, 2e-24, 2.49e-24, 3.01e-24, 3.59e-24, 4.2e-24, 4.86e-24, 5.55e-24, 6.27e-24, 7.04e-24, 7.84e-24, 8.67e-24, 9.53e-24, 1.04e-23, 1.13e-23, 1.23e-23, 1.33e-23, 1.43e-23, 1.53e-23, 1.64e-23, 1.75e-23, 1.86e-23, 1.97e-23, 2.09e-23, 2.21e-23, 2.33e-23, 2.45e-23, 2.57e-23, 2.7e-23, 2.83e-23, 2.96e-23, 3.09e-23, 3.23e-23, 3.36e-23, 3.5e-23, 3.64e-23, 3.78e-23, 3.93e-23, 4.07e-23, 4.22e-23, 4.37e-23, 4.52e-23, 4.67e-23, 4.82e-23, 4.98e-23, 5.13e-23, 5.29e-23, 5.45e-23, 5.61e-23, 5.77e-23, 5.94e-23, 6.1e-23, 6.27e-23, 6.43e-23, 6.6e-23, 6.77e-23, 6.94e-23, 7.12e-23, 7.12e-23]),
		ExplicitContinuum(j=114, i=113, wavelengthGrid=[1.918, 2.728, 3.419, 4.039, 4.61, 5.143, 5.647, 6.127, 6.586, 7.028, 7.456, 7.869, 8.271, 8.663, 9.044, 9.417, 9.781, 10.139, 10.489, 10.832, 11.17, 11.502, 11.829, 12.151, 12.468, 12.78, 13.089, 13.393, 13.694, 13.991, 14.284, 14.574, 14.861, 15.145, 15.425, 15.703, 15.978, 16.251, 16.521, 16.789, 17.054, 17.317, 17.577, 17.836, 18.092, 18.347, 18.599, 18.85, 19.098, 19.345, 19.59, 19.834, 20.075, 20.316, 20.554, 20.791, 21.027, 21.261, 21.493, 21.724, 21.954, 22.183, 22.41, 22.636, 22.78830057308133], alphaGrid=[4.31e-27, 1.27e-26, 3.34e-26, 6.74e-26, 1.17e-25, 1.84e-25, 2.69e-25, 3.74e-25, 4.99e-25, 6.47e-25, 8.16e-25, 1.01e-24, 1.23e-24, 1.47e-24, 1.73e-24, 2.02e-24, 2.34e-24, 2.68e-24, 3.05e-24, 3.45e-24, 3.87e-24, 4.32e-24, 4.8e-24, 5.3e-24, 5.83e-24, 6.39e-24, 6.98e-24, 7.6e-24, 8.24e-24, 8.92e-24, 9.62e-24, 1.03e-23, 1.11e-23, 1.19e-23, 1.27e-23, 1.36e-23, 1.44e-23, 1.53e-23, 1.63e-23, 1.72e-23, 1.82e-23, 1.92e-23, 2.03e-23, 2.14e-23, 2.25e-23, 2.36e-23, 2.48e-23, 2.6e-23, 2.72e-23, 2.85e-23, 2.97e-23, 3.11e-23, 3.24e-23, 3.38e-23, 3.52e-23, 3.66e-23, 3.81e-23, 3.96e-23, 4.11e-23, 4.26e-23, 4.42e-23, 4.58e-23, 4.75e-23, 4.91e-23, 4.91e-23]),
	],
	collisions=[
		CE(j=1, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.028e-18, 1.775e-18, 1.04e-18, 6.09e-19, 3.561e-19, 2.08e-19, 1.213e-19, 7.069e-20, 4.113e-20, 2.391e-20, 1.388e-20, 8.053e-21, 4.667e-21]),
		CE(j=2, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.349e-26, 3.144e-26, 1.85e-26, 1.088e-26, 6.395e-27, 3.754e-27, 2.2e-27, 1.288e-27, 7.527e-28, 4.393e-28, 2.561e-28, 1.491e-28, 8.67e-29]),
		CE(j=3, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.047e-27, 3.425e-27, 1.95e-27, 1.119e-27, 6.493e-28, 3.821e-28, 2.281e-28, 1.379e-28, 8.424e-29, 5.175e-29, 3.186e-29, 1.959e-29, 1.2e-29]),
		CE(j=4, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.178e-16, 5.139e-16, 4.274e-16, 3.555e-16, 2.957e-16, 2.46e-16, 2.046e-16, 1.702e-16, 1.415e-16, 1.177e-16, 9.792e-17, 8.144e-17, 6.774e-17]),
		CE(j=5, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.932e-16, 2.439e-16, 2.028e-16, 1.687e-16, 1.403e-16, 1.167e-16, 9.709e-17, 8.076e-17, 6.717e-17, 5.587e-17, 4.647e-17, 3.865e-17, 3.215e-17]),
		CE(j=6, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.104e-16, 9.184e-17, 7.639e-17, 6.354e-17, 5.285e-17, 4.396e-17, 3.656e-17, 3.041e-17, 2.529e-17, 2.104e-17, 1.75e-17, 1.456e-17, 1.211e-17]),
		CE(j=7, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.059e-14, 5.968e-15, 3.37e-15, 1.908e-15, 1.087e-15, 6.248e-16, 3.644e-16, 2.168e-16, 1.322e-16, 8.265e-17, 5.267e-17, 3.397e-17, 2.201e-17]),
		CE(j=8, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.102e-16, 9.168e-17, 7.626e-17, 6.343e-17, 5.276e-17, 4.388e-17, 3.65e-17, 3.036e-17, 2.525e-17, 2.1e-17, 1.747e-17, 1.453e-17, 1.209e-17]),
		CE(j=9, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.552e-18, 1.438e-18, 8.119e-19, 4.598e-19, 2.618e-19, 1.504e-19, 8.77e-20, 5.217e-20, 3.181e-20, 1.988e-20, 1.267e-20, 8.183e-21, 5.306e-21]),
		CE(j=10, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.977e-17, 8.298e-17, 6.902e-17, 5.741e-17, 4.775e-17, 3.972e-17, 3.304e-17, 2.748e-17, 2.286e-17, 1.901e-17, 1.581e-17, 1.315e-17, 1.094e-17]),
		CE(j=11, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.94e-15, 2.784e-15, 1.572e-15, 8.899e-16, 5.066e-16, 2.91e-16, 1.696e-16, 1.008e-16, 6.144e-17, 3.84e-17, 2.45e-17, 1.583e-17, 1.028e-17]),
		CE(j=12, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.976e-17, 8.297e-17, 6.901e-17, 5.74e-17, 4.775e-17, 3.971e-17, 3.303e-17, 2.747e-17, 2.285e-17, 1.901e-17, 1.581e-17, 1.315e-17, 1.094e-17]),
		CE(j=13, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.843e-17, 7.355e-17, 6.118e-17, 5.089e-17, 4.233e-17, 3.521e-17, 2.928e-17, 2.436e-17, 2.026e-17, 1.685e-17, 1.402e-17, 1.166e-17, 9.696e-18]),
		CE(j=14, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.666e-17, 7.208e-17, 5.996e-17, 4.987e-17, 4.148e-17, 3.45e-17, 2.87e-17, 2.387e-17, 1.985e-17, 1.651e-17, 1.374e-17, 1.142e-17, 9.502e-18]),
		CE(j=15, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.662e-17, 7.205e-17, 5.993e-17, 4.984e-17, 4.146e-17, 3.448e-17, 2.868e-17, 2.386e-17, 1.984e-17, 1.65e-17, 1.373e-17, 1.142e-17, 9.498e-18]),
		CE(j=16, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.655e-17, 7.199e-17, 5.988e-17, 4.98e-17, 4.143e-17, 3.446e-17, 2.866e-17, 2.384e-17, 1.983e-17, 1.649e-17, 1.372e-17, 1.141e-17, 9.49e-18]),
		CE(j=17, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.45e-17, 7.029e-17, 5.846e-17, 4.863e-17, 4.045e-17, 3.364e-17, 2.798e-17, 2.327e-17, 1.936e-17, 1.61e-17, 1.339e-17, 1.114e-17, 9.266e-18]),
		CE(j=18, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.33e-17, 6.928e-17, 5.763e-17, 4.793e-17, 3.987e-17, 3.316e-17, 2.758e-17, 2.294e-17, 1.908e-17, 1.587e-17, 1.32e-17, 1.098e-17, 9.133e-18]),
		CE(j=19, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.327e-17, 6.926e-17, 5.761e-17, 4.792e-17, 3.986e-17, 3.315e-17, 2.757e-17, 2.294e-17, 1.908e-17, 1.587e-17, 1.32e-17, 1.098e-17, 9.131e-18]),
		CE(j=20, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.323e-17, 6.923e-17, 5.758e-17, 4.79e-17, 3.984e-17, 3.314e-17, 2.756e-17, 2.292e-17, 1.907e-17, 1.586e-17, 1.319e-17, 1.097e-17, 9.126e-18]),
		CE(j=21, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.089e-17, 6.728e-17, 5.596e-17, 4.655e-17, 3.871e-17, 3.22e-17, 2.678e-17, 2.228e-17, 1.853e-17, 1.541e-17, 1.282e-17, 1.066e-17, 8.869e-18]),
		CE(j=22, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.839e-17, 6.52e-17, 5.424e-17, 4.511e-17, 3.752e-17, 3.121e-17, 2.596e-17, 2.159e-17, 1.796e-17, 1.494e-17, 1.242e-17, 1.033e-17, 8.596e-18]),
		CE(j=23, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.339e-15, 1.881e-15, 1.062e-15, 6.008e-16, 3.416e-16, 1.959e-16, 1.139e-16, 6.751e-17, 4.106e-17, 2.566e-17, 1.641e-17, 1.066e-17, 6.976e-18]),
		CE(j=24, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.617e-17, 6.335e-17, 5.27e-17, 4.383e-17, 3.646e-17, 3.032e-17, 2.522e-17, 2.098e-17, 1.745e-17, 1.451e-17, 1.207e-17, 1.004e-17, 8.352e-18]),
		CE(j=25, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.617e-17, 6.335e-17, 5.269e-17, 4.383e-17, 3.646e-17, 3.032e-17, 2.522e-17, 2.098e-17, 1.745e-17, 1.451e-17, 1.207e-17, 1.004e-17, 8.351e-18]),
		CE(j=26, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.222e-17, 6.007e-17, 4.996e-17, 4.156e-17, 3.457e-17, 2.875e-17, 2.391e-17, 1.989e-17, 1.654e-17, 1.376e-17, 1.145e-17, 9.52e-18, 7.918e-18]),
		CE(j=27, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.141e-17, 5.94e-17, 4.941e-17, 4.109e-17, 3.418e-17, 2.843e-17, 2.365e-17, 1.967e-17, 1.636e-17, 1.361e-17, 1.132e-17, 9.414e-18, 7.83e-18]),
		CE(j=28, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.139e-17, 5.938e-17, 4.939e-17, 4.108e-17, 3.417e-17, 2.842e-17, 2.364e-17, 1.966e-17, 1.635e-17, 1.36e-17, 1.131e-17, 9.411e-18, 7.827e-18]),
		CE(j=29, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.133e-17, 5.933e-17, 4.935e-17, 4.105e-17, 3.414e-17, 2.84e-17, 2.362e-17, 1.965e-17, 1.634e-17, 1.359e-17, 1.131e-17, 9.404e-18, 7.822e-18]),
		CE(j=30, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.619e-15, 2.602e-15, 1.469e-15, 8.309e-16, 4.724e-16, 2.708e-16, 1.573e-16, 9.319e-17, 5.664e-17, 3.539e-17, 2.265e-17, 1.474e-17, 9.66e-18]),
		CE(j=31, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.125e-17, 5.926e-17, 4.929e-17, 4.1e-17, 3.41e-17, 2.836e-17, 2.359e-17, 1.962e-17, 1.632e-17, 1.358e-17, 1.129e-17, 9.392e-18, 7.812e-18]),
		CE(j=32, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.123e-17, 5.925e-17, 4.928e-17, 4.099e-17, 3.409e-17, 2.836e-17, 2.359e-17, 1.962e-17, 1.632e-17, 1.357e-17, 1.129e-17, 9.39e-18, 7.81e-18]),
		CE(j=33, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.091e-17, 5.898e-17, 4.906e-17, 4.08e-17, 3.394e-17, 2.823e-17, 2.348e-17, 1.953e-17, 1.624e-17, 1.351e-17, 1.124e-17, 9.348e-18, 7.775e-18]),
		CE(j=34, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.355e-17, 7.636e-18, 4.309e-18, 2.438e-18, 1.386e-18, 7.944e-19, 4.614e-19, 2.734e-19, 1.661e-19, 1.038e-19, 6.645e-20, 4.324e-20, 2.835e-20]),
		CE(j=35, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.974e-17, 5.801e-17, 4.825e-17, 4.013e-17, 3.338e-17, 2.776e-17, 2.309e-17, 1.921e-17, 1.598e-17, 1.329e-17, 1.105e-17, 9.193e-18, 7.647e-18]),
		CE(j=36, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.843e-15, 1.038e-15, 5.859e-16, 3.315e-16, 1.885e-16, 1.08e-16, 6.273e-17, 3.716e-17, 2.258e-17, 1.411e-17, 9.033e-18, 5.88e-18, 3.856e-18]),
		CE(j=37, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.972e-17, 5.799e-17, 4.824e-17, 4.012e-17, 3.337e-17, 2.776e-17, 2.309e-17, 1.92e-17, 1.597e-17, 1.329e-17, 1.105e-17, 9.191e-18, 7.645e-18]),
		CE(j=40, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.456e-17, 3.706e-17, 3.083e-17, 2.564e-17, 2.133e-17, 1.774e-17, 1.476e-17, 1.227e-17, 1.021e-17, 8.491e-18, 7.063e-18, 5.874e-18, 4.886e-18]),
		CE(j=41, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.455e-17, 3.705e-17, 3.082e-17, 2.563e-17, 2.132e-17, 1.773e-17, 1.475e-17, 1.227e-17, 1.021e-17, 8.488e-18, 7.06e-18, 5.872e-18, 4.884e-18]),
		CE(j=42, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.453e-17, 3.704e-17, 3.081e-17, 2.562e-17, 2.131e-17, 1.773e-17, 1.474e-17, 1.226e-17, 1.02e-17, 8.485e-18, 7.057e-18, 5.87e-18, 4.882e-18]),
		CE(j=43, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.515e-15, 2.543e-15, 1.434e-15, 8.106e-16, 4.601e-16, 2.63e-16, 1.521e-16, 8.963e-17, 5.421e-17, 3.381e-17, 2.172e-17, 1.427e-17, 9.494e-18]),
		CE(j=2, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.172e-18, 6.883e-19, 4.042e-19, 2.372e-19, 1.391e-19, 8.143e-20, 4.761e-20, 2.78e-20, 1.621e-20, 9.443e-21, 5.493e-21, 3.192e-21, 1.853e-21]),
		CE(j=3, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.422e-24, 8.056e-25, 4.586e-25, 2.632e-25, 1.527e-25, 8.988e-26, 5.366e-26, 3.246e-26, 1.982e-26, 1.218e-26, 7.495e-27, 4.608e-27, 2.824e-27]),
		CE(j=4, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.827e-25, 4.42e-25, 2.505e-25, 1.427e-25, 8.207e-26, 4.781e-26, 2.831e-26, 1.707e-26, 1.046e-26, 6.483e-27, 4.048e-27, 2.533e-27, 1.582e-27]),
		CE(j=5, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.934e-16, 2.441e-16, 2.03e-16, 1.689e-16, 1.405e-16, 1.168e-16, 9.717e-17, 8.082e-17, 6.722e-17, 5.592e-17, 4.651e-17, 3.868e-17, 3.218e-17]),
		CE(j=6, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.565e-15, 2.009e-15, 1.134e-15, 6.426e-16, 3.659e-16, 2.104e-16, 1.227e-16, 7.301e-17, 4.453e-17, 2.783e-17, 1.773e-17, 1.144e-17, 7.41e-18]),
		CE(j=7, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.693e-15, 1.518e-15, 8.57e-16, 4.854e-16, 2.765e-16, 1.589e-16, 9.268e-17, 5.516e-17, 3.364e-17, 2.102e-17, 1.34e-17, 8.642e-18, 5.598e-18]),
		CE(j=8, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.444e-15, 2.504e-15, 1.414e-15, 8.009e-16, 4.561e-16, 2.622e-16, 1.529e-16, 9.1e-17, 5.55e-17, 3.468e-17, 2.21e-17, 1.426e-17, 9.236e-18]),
		CE(j=9, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.257e-19, 3.526e-19, 1.991e-19, 1.128e-19, 6.42e-20, 3.689e-20, 2.151e-20, 1.279e-20, 7.801e-21, 4.875e-21, 3.108e-21, 2.007e-21, 1.301e-21]),
		CE(j=10, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.981e-17, 8.302e-17, 6.905e-17, 5.743e-17, 4.777e-17, 3.973e-17, 3.305e-17, 2.749e-17, 2.286e-17, 1.902e-17, 1.582e-17, 1.316e-17, 1.094e-17]),
		CE(j=11, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.237e-15, 6.971e-16, 3.935e-16, 2.228e-16, 1.269e-16, 7.287e-17, 4.246e-17, 2.524e-17, 1.538e-17, 9.615e-18, 6.135e-18, 3.965e-18, 2.575e-18]),
		CE(j=12, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.704e-15, 2.087e-15, 1.178e-15, 6.673e-16, 3.799e-16, 2.182e-16, 1.271e-16, 7.559e-17, 4.607e-17, 2.879e-17, 1.837e-17, 1.187e-17, 7.71e-18]),
		CE(j=13, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.847e-17, 7.358e-17, 6.12e-17, 5.091e-17, 4.234e-17, 3.522e-17, 2.929e-17, 2.437e-17, 2.027e-17, 1.686e-17, 1.402e-17, 1.166e-17, 9.7e-18]),
		CE(j=14, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.67e-17, 7.211e-17, 5.998e-17, 4.989e-17, 4.15e-17, 3.451e-17, 2.871e-17, 2.388e-17, 1.986e-17, 1.652e-17, 1.374e-17, 1.143e-17, 9.506e-18]),
		CE(j=15, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.665e-17, 7.207e-17, 5.995e-17, 4.986e-17, 4.147e-17, 3.45e-17, 2.869e-17, 2.387e-17, 1.985e-17, 1.651e-17, 1.373e-17, 1.142e-17, 9.501e-18]),
		CE(j=16, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.658e-17, 7.202e-17, 5.99e-17, 4.982e-17, 4.144e-17, 3.447e-17, 2.867e-17, 2.385e-17, 1.984e-17, 1.65e-17, 1.372e-17, 1.141e-17, 9.494e-18]),
		CE(j=17, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.454e-17, 7.031e-17, 5.849e-17, 4.865e-17, 4.046e-17, 3.365e-17, 2.799e-17, 2.328e-17, 1.937e-17, 1.611e-17, 1.34e-17, 1.114e-17, 9.269e-18]),
		CE(j=18, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.333e-17, 6.931e-17, 5.765e-17, 4.795e-17, 3.988e-17, 3.317e-17, 2.759e-17, 2.295e-17, 1.909e-17, 1.588e-17, 1.321e-17, 1.098e-17, 9.137e-18]),
		CE(j=19, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.33e-17, 6.929e-17, 5.763e-17, 4.794e-17, 3.987e-17, 3.316e-17, 2.758e-17, 2.294e-17, 1.908e-17, 1.587e-17, 1.32e-17, 1.098e-17, 9.134e-18]),
		CE(j=20, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.326e-17, 6.926e-17, 5.76e-17, 4.791e-17, 3.985e-17, 3.315e-17, 2.757e-17, 2.293e-17, 1.907e-17, 1.587e-17, 1.32e-17, 1.098e-17, 9.13e-18]),
		CE(j=21, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.092e-17, 6.73e-17, 5.598e-17, 4.656e-17, 3.873e-17, 3.221e-17, 2.679e-17, 2.229e-17, 1.854e-17, 1.542e-17, 1.282e-17, 1.067e-17, 8.872e-18]),
		CE(j=22, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.842e-17, 6.523e-17, 5.426e-17, 4.513e-17, 3.754e-17, 3.122e-17, 2.597e-17, 2.16e-17, 1.797e-17, 1.494e-17, 1.243e-17, 1.034e-17, 8.599e-18]),
		CE(j=23, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.467e-16, 4.771e-16, 2.692e-16, 1.524e-16, 8.664e-17, 4.968e-17, 2.888e-17, 1.712e-17, 1.041e-17, 6.507e-18, 4.163e-18, 2.705e-18, 1.769e-18]),
		CE(j=24, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.376e-15, 7.752e-16, 4.375e-16, 2.476e-16, 1.408e-16, 8.073e-17, 4.693e-17, 2.782e-17, 1.692e-17, 1.057e-17, 6.764e-18, 4.395e-18, 2.875e-18]),
		CE(j=25, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.127e-15, 6.351e-16, 3.584e-16, 2.028e-16, 1.153e-16, 6.614e-17, 3.844e-17, 2.279e-17, 1.386e-17, 8.662e-18, 5.541e-18, 3.601e-18, 2.355e-18]),
		CE(j=26, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.224e-17, 6.009e-17, 4.998e-17, 4.157e-17, 3.458e-17, 2.876e-17, 2.392e-17, 1.99e-17, 1.655e-17, 1.377e-17, 1.145e-17, 9.523e-18, 7.921e-18]),
		CE(j=27, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.656e-17, 2.06e-17, 1.162e-17, 6.576e-18, 3.739e-18, 2.143e-18, 1.245e-18, 7.376e-19, 4.483e-19, 2.801e-19, 1.793e-19, 1.167e-19, 7.645e-20]),
		CE(j=28, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.141e-17, 5.94e-17, 4.941e-17, 4.109e-17, 3.418e-17, 2.843e-17, 2.365e-17, 1.967e-17, 1.636e-17, 1.361e-17, 1.132e-17, 9.414e-18, 7.83e-18]),
		CE(j=29, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.136e-17, 5.935e-17, 4.937e-17, 4.106e-17, 3.416e-17, 2.841e-17, 2.363e-17, 1.965e-17, 1.635e-17, 1.36e-17, 1.131e-17, 9.407e-18, 7.824e-18]),
		CE(j=30, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.105e-15, 6.228e-16, 3.514e-16, 1.988e-16, 1.13e-16, 6.48e-17, 3.764e-17, 2.23e-17, 1.356e-17, 8.47e-18, 5.422e-18, 3.528e-18, 2.312e-18]),
		CE(j=31, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.494e-15, 1.968e-15, 1.111e-15, 6.284e-16, 3.573e-16, 2.048e-16, 1.19e-16, 7.049e-17, 4.284e-17, 2.677e-17, 1.714e-17, 1.115e-17, 7.307e-18]),
		CE(j=32, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.126e-17, 5.927e-17, 4.93e-17, 4.1e-17, 3.41e-17, 2.837e-17, 2.359e-17, 1.963e-17, 1.632e-17, 1.358e-17, 1.129e-17, 9.393e-18, 7.813e-18]),
		CE(j=33, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.093e-17, 5.9e-17, 4.907e-17, 4.082e-17, 3.395e-17, 2.824e-17, 2.349e-17, 1.954e-17, 1.625e-17, 1.352e-17, 1.124e-17, 9.351e-18, 7.778e-18]),
		CE(j=34, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.063e-17, 5.875e-17, 4.886e-17, 4.064e-17, 3.38e-17, 2.812e-17, 2.339e-17, 1.945e-17, 1.618e-17, 1.346e-17, 1.119e-17, 9.311e-18, 7.744e-18]),
		CE(j=35, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.132e-16, 4.018e-16, 2.267e-16, 1.283e-16, 7.293e-17, 4.18e-17, 2.428e-17, 1.438e-17, 8.739e-18, 5.46e-18, 3.496e-18, 2.275e-18, 1.492e-18]),
		CE(j=36, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.094e-16, 2.87e-16, 1.619e-16, 9.162e-17, 5.208e-17, 2.985e-17, 1.734e-17, 1.027e-17, 6.241e-18, 3.899e-18, 2.496e-18, 1.625e-18, 1.066e-18]),
		CE(j=37, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.548e-16, 3.689e-16, 2.082e-16, 1.178e-16, 6.696e-17, 3.837e-17, 2.229e-17, 1.32e-17, 8.023e-18, 5.013e-18, 3.209e-18, 2.089e-18, 1.37e-18]),
		CE(j=40, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.457e-17, 3.707e-17, 3.084e-17, 2.565e-17, 2.133e-17, 1.774e-17, 1.476e-17, 1.228e-17, 1.021e-17, 8.493e-18, 7.064e-18, 5.876e-18, 4.887e-18]),
		CE(j=41, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.456e-17, 3.706e-17, 3.083e-17, 2.564e-17, 2.133e-17, 1.774e-17, 1.475e-17, 1.227e-17, 1.021e-17, 8.49e-18, 7.062e-18, 5.874e-18, 4.886e-18]),
		CE(j=42, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.454e-17, 3.705e-17, 3.081e-17, 2.563e-17, 2.132e-17, 1.773e-17, 1.475e-17, 1.227e-17, 1.02e-17, 8.487e-18, 7.059e-18, 5.872e-18, 4.884e-18]),
		CE(j=43, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.545e-15, 2.56e-15, 1.444e-15, 8.16e-16, 4.631e-16, 2.647e-16, 1.531e-16, 9.022e-17, 5.457e-17, 3.403e-17, 2.187e-17, 1.437e-17, 9.558e-18]),
		CE(j=3, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.56e-24, 1.45e-24, 8.255e-25, 4.737e-25, 2.75e-25, 1.618e-25, 9.66e-26, 5.843e-26, 3.568e-26, 2.192e-26, 1.349e-26, 8.294e-27, 5.082e-27]),
		CE(j=4, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.021e-27, 2.271e-27, 1.287e-27, 7.333e-28, 4.216e-28, 2.456e-28, 1.455e-28, 8.77e-29, 5.373e-29, 3.331e-29, 2.08e-29, 1.301e-29, 8.128e-30]),
		CE(j=5, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.938e-16, 2.444e-16, 2.033e-16, 1.691e-16, 1.406e-16, 1.17e-16, 9.73e-17, 8.093e-17, 6.732e-17, 5.599e-17, 4.657e-17, 3.874e-17, 3.222e-17]),
		CE(j=6, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.105e-16, 9.195e-17, 7.648e-17, 6.361e-17, 5.291e-17, 4.401e-17, 3.661e-17, 3.045e-17, 2.532e-17, 2.106e-17, 1.752e-17, 1.457e-17, 1.212e-17]),
		CE(j=7, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.694e-15, 1.519e-15, 8.574e-16, 4.856e-16, 2.766e-16, 1.59e-16, 9.272e-17, 5.518e-17, 3.366e-17, 2.103e-17, 1.34e-17, 8.646e-18, 5.601e-18]),
		CE(j=8, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.863e-15, 4.432e-15, 2.502e-15, 1.417e-15, 8.071e-16, 4.639e-16, 2.706e-16, 1.61e-16, 9.821e-17, 6.138e-17, 3.912e-17, 2.523e-17, 1.634e-17]),
		CE(j=9, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.49e-19, 2.53e-19, 1.429e-19, 8.091e-20, 4.607e-20, 2.647e-20, 1.543e-20, 9.181e-21, 5.598e-21, 3.499e-21, 2.231e-21, 1.44e-21, 9.339e-22]),
		CE(j=10, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.153e-15, 2.34e-15, 1.321e-15, 7.481e-16, 4.259e-16, 2.446e-16, 1.425e-16, 8.475e-17, 5.165e-17, 3.228e-17, 2.06e-17, 1.331e-17, 8.645e-18]),
		CE(j=11, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.915e-17, 2.77e-17, 1.564e-17, 8.855e-18, 5.041e-18, 2.896e-18, 1.687e-18, 1.003e-18, 6.114e-19, 3.821e-19, 2.438e-19, 1.576e-19, 1.023e-19]),
		CE(j=12, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.356e-16, 4.145e-16, 2.34e-16, 1.325e-16, 7.544e-17, 4.333e-17, 2.525e-17, 1.501e-17, 9.149e-18, 5.718e-18, 3.648e-18, 2.358e-18, 1.531e-18]),
		CE(j=13, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.853e-17, 7.363e-17, 6.124e-17, 5.094e-17, 4.237e-17, 3.524e-17, 2.931e-17, 2.438e-17, 2.028e-17, 1.687e-17, 1.403e-17, 1.167e-17, 9.707e-18]),
		CE(j=14, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.675e-17, 7.216e-17, 6.002e-17, 4.992e-17, 4.152e-17, 3.454e-17, 2.873e-17, 2.389e-17, 1.987e-17, 1.653e-17, 1.375e-17, 1.144e-17, 9.512e-18]),
		CE(j=15, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.671e-17, 7.212e-17, 5.999e-17, 4.99e-17, 4.15e-17, 3.452e-17, 2.871e-17, 2.388e-17, 1.986e-17, 1.652e-17, 1.374e-17, 1.143e-17, 9.507e-18]),
		CE(j=16, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.664e-17, 7.206e-17, 5.994e-17, 4.986e-17, 4.147e-17, 3.449e-17, 2.869e-17, 2.386e-17, 1.985e-17, 1.651e-17, 1.373e-17, 1.142e-17, 9.5e-18]),
		CE(j=17, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.459e-17, 7.036e-17, 5.852e-17, 4.868e-17, 4.049e-17, 3.368e-17, 2.801e-17, 2.33e-17, 1.938e-17, 1.612e-17, 1.341e-17, 1.115e-17, 9.275e-18]),
		CE(j=18, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.338e-17, 6.935e-17, 5.769e-17, 4.798e-17, 3.991e-17, 3.319e-17, 2.761e-17, 2.297e-17, 1.91e-17, 1.589e-17, 1.322e-17, 1.099e-17, 9.143e-18]),
		CE(j=19, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.336e-17, 6.933e-17, 5.767e-17, 4.797e-17, 3.99e-17, 3.319e-17, 2.76e-17, 2.296e-17, 1.91e-17, 1.588e-17, 1.321e-17, 1.099e-17, 9.14e-18]),
		CE(j=20, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.332e-17, 6.93e-17, 5.764e-17, 4.794e-17, 3.988e-17, 3.317e-17, 2.759e-17, 2.295e-17, 1.909e-17, 1.588e-17, 1.32e-17, 1.098e-17, 9.136e-18]),
		CE(j=21, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.097e-17, 6.735e-17, 5.602e-17, 4.659e-17, 3.875e-17, 3.223e-17, 2.681e-17, 2.23e-17, 1.855e-17, 1.543e-17, 1.283e-17, 1.067e-17, 8.878e-18]),
		CE(j=22, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.847e-17, 6.527e-17, 5.429e-17, 4.516e-17, 3.756e-17, 3.124e-17, 2.598e-17, 2.161e-17, 1.798e-17, 1.495e-17, 1.244e-17, 1.034e-17, 8.604e-18]),
		CE(j=23, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.417e-16, 4.742e-16, 2.676e-16, 1.514e-16, 8.612e-17, 4.939e-17, 2.871e-17, 1.702e-17, 1.035e-17, 6.469e-18, 4.138e-18, 2.689e-18, 1.759e-18]),
		CE(j=24, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.509e-15, 1.414e-15, 7.978e-16, 4.515e-16, 2.567e-16, 1.472e-16, 8.557e-17, 5.074e-17, 3.086e-17, 1.928e-17, 1.234e-17, 8.016e-18, 5.244e-18]),
		CE(j=25, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.624e-17, 6.341e-17, 5.275e-17, 4.387e-17, 3.649e-17, 3.035e-17, 2.525e-17, 2.1e-17, 1.747e-17, 1.453e-17, 1.208e-17, 1.005e-17, 8.36e-18]),
		CE(j=26, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.228e-17, 6.012e-17, 5.001e-17, 4.16e-17, 3.46e-17, 2.878e-17, 2.394e-17, 1.991e-17, 1.656e-17, 1.377e-17, 1.146e-17, 9.529e-18, 7.926e-18]),
		CE(j=27, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.887e-18, 5.57e-18, 3.143e-18, 1.778e-18, 1.011e-18, 5.796e-19, 3.367e-19, 1.995e-19, 1.213e-19, 7.577e-20, 4.85e-20, 3.156e-20, 2.068e-20]),
		CE(j=28, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.877e-16, 1.058e-16, 5.968e-17, 3.377e-17, 1.92e-17, 1.101e-17, 6.393e-18, 3.788e-18, 2.303e-18, 1.439e-18, 9.209e-19, 5.992e-19, 3.927e-19]),
		CE(j=29, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.14e-17, 5.939e-17, 4.94e-17, 4.109e-17, 3.417e-17, 2.843e-17, 2.364e-17, 1.967e-17, 1.636e-17, 1.361e-17, 1.132e-17, 9.413e-18, 7.829e-18]),
		CE(j=30, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.051e-17, 2.282e-17, 1.288e-17, 7.287e-18, 4.143e-18, 2.375e-18, 1.379e-18, 8.173e-19, 4.968e-19, 3.104e-19, 1.987e-19, 1.293e-19, 8.473e-20]),
		CE(j=31, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.683e-16, 4.329e-16, 2.443e-16, 1.382e-16, 7.857e-17, 4.504e-17, 2.616e-17, 1.55e-17, 9.422e-18, 5.887e-18, 3.769e-18, 2.452e-18, 1.607e-18]),
		CE(j=32, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.92e-15, 2.208e-15, 1.246e-15, 7.051e-16, 4.009e-16, 2.298e-16, 1.335e-16, 7.909e-17, 4.807e-17, 3.004e-17, 1.923e-17, 1.251e-17, 8.199e-18]),
		CE(j=33, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.732e-17, 9.756e-18, 5.505e-18, 3.115e-18, 1.771e-18, 1.015e-18, 5.896e-19, 3.493e-19, 2.123e-19, 1.327e-19, 8.493e-20, 5.526e-20, 3.622e-20]),
		CE(j=34, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.067e-17, 5.878e-17, 4.889e-17, 4.067e-17, 3.382e-17, 2.813e-17, 2.34e-17, 1.946e-17, 1.619e-17, 1.347e-17, 1.12e-17, 9.316e-18, 7.749e-18]),
		CE(j=35, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.47e-15, 8.285e-16, 4.675e-16, 2.645e-16, 1.504e-16, 8.617e-17, 5.005e-17, 2.965e-17, 1.802e-17, 1.126e-17, 7.208e-18, 4.692e-18, 3.077e-18]),
		CE(j=36, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.901e-16, 2.761e-16, 1.558e-16, 8.815e-17, 5.011e-17, 2.872e-17, 1.668e-17, 9.881e-18, 6.005e-18, 3.752e-18, 2.402e-18, 1.564e-18, 1.025e-18]),
		CE(j=37, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.979e-17, 5.804e-17, 4.828e-17, 4.016e-17, 3.34e-17, 2.778e-17, 2.311e-17, 1.922e-17, 1.599e-17, 1.33e-17, 1.106e-17, 9.199e-18, 7.652e-18]),
		CE(j=40, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.459e-17, 3.709e-17, 3.085e-17, 2.566e-17, 2.134e-17, 1.775e-17, 1.477e-17, 1.228e-17, 1.022e-17, 8.497e-18, 7.068e-18, 5.878e-18, 4.89e-18]),
		CE(j=41, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.458e-17, 3.708e-17, 3.084e-17, 2.565e-17, 2.134e-17, 1.775e-17, 1.476e-17, 1.228e-17, 1.021e-17, 8.494e-18, 7.065e-18, 5.877e-18, 4.888e-18]),
		CE(j=42, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.456e-17, 3.706e-17, 3.083e-17, 2.564e-17, 2.133e-17, 1.774e-17, 1.476e-17, 1.227e-17, 1.021e-17, 8.491e-18, 7.062e-18, 5.874e-18, 4.886e-18]),
		CE(j=43, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.515e-15, 2.543e-15, 1.434e-15, 8.108e-16, 4.601e-16, 2.63e-16, 1.521e-16, 8.965e-17, 5.422e-17, 3.382e-17, 2.173e-17, 1.428e-17, 9.497e-18]),
		CE(j=4, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.13e-21, 6.398e-22, 3.642e-22, 2.09e-22, 1.213e-22, 7.147e-23, 4.278e-23, 2.597e-23, 1.594e-23, 9.846e-24, 6.098e-24, 3.772e-24, 2.325e-24]),
		CE(j=5, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.366e-16, 4.463e-16, 3.712e-16, 3.088e-16, 2.568e-16, 2.136e-16, 1.777e-16, 1.478e-16, 1.229e-16, 1.022e-16, 8.504e-17, 7.074e-17, 5.884e-17]),
		CE(j=6, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.507e-16, 1.253e-16, 1.042e-16, 8.67e-17, 7.212e-17, 5.998e-17, 4.989e-17, 4.15e-17, 3.452e-17, 2.871e-17, 2.388e-17, 1.986e-17, 1.652e-17]),
		CE(j=7, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.535e-18, 1.43e-18, 8.079e-19, 4.582e-19, 2.616e-19, 1.51e-19, 8.861e-20, 5.315e-20, 3.269e-20, 2.058e-20, 1.318e-20, 8.526e-21, 5.525e-21]),
		CE(j=8, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.161e-20, 1.219e-20, 6.887e-21, 3.906e-21, 2.23e-21, 1.287e-21, 7.553e-22, 4.531e-22, 2.786e-22, 1.754e-22, 1.124e-22, 7.268e-23, 4.71e-23]),
		CE(j=9, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.015e-14, 5.724e-15, 3.235e-15, 1.834e-15, 1.047e-15, 6.041e-16, 3.543e-16, 2.124e-16, 1.306e-16, 8.224e-17, 5.272e-17, 3.414e-17, 2.215e-17]),
		CE(j=10, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.335e-16, 1.11e-16, 9.233e-17, 7.68e-17, 6.388e-17, 5.313e-17, 4.419e-17, 3.676e-17, 3.057e-17, 2.543e-17, 2.115e-17, 1.759e-17, 1.463e-17]),
		CE(j=11, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.335e-16, 1.11e-16, 9.233e-17, 7.679e-17, 6.387e-17, 5.313e-17, 4.419e-17, 3.676e-17, 3.057e-17, 2.543e-17, 2.115e-17, 1.759e-17, 1.463e-17]),
		CE(j=12, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.334e-16, 1.11e-16, 9.232e-17, 7.679e-17, 6.387e-17, 5.313e-17, 4.419e-17, 3.675e-17, 3.057e-17, 2.543e-17, 2.115e-17, 1.759e-17, 1.463e-17]),
		CE(j=13, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.157e-16, 9.627e-17, 8.007e-17, 6.66e-17, 5.54e-17, 4.608e-17, 3.833e-17, 3.188e-17, 2.652e-17, 2.205e-17, 1.834e-17, 1.526e-17, 1.269e-17]),
		CE(j=14, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.13e-16, 9.402e-17, 7.82e-17, 6.504e-17, 5.41e-17, 4.5e-17, 3.743e-17, 3.113e-17, 2.589e-17, 2.154e-17, 1.791e-17, 1.49e-17, 1.239e-17]),
		CE(j=15, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.13e-16, 9.396e-17, 7.815e-17, 6.5e-17, 5.407e-17, 4.497e-17, 3.741e-17, 3.111e-17, 2.588e-17, 2.153e-17, 1.79e-17, 1.489e-17, 1.239e-17]),
		CE(j=16, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.129e-16, 9.387e-17, 7.808e-17, 6.494e-17, 5.402e-17, 4.493e-17, 3.737e-17, 3.108e-17, 2.585e-17, 2.15e-17, 1.789e-17, 1.488e-17, 1.237e-17]),
		CE(j=17, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.097e-16, 9.128e-17, 7.593e-17, 6.315e-17, 5.253e-17, 4.369e-17, 3.634e-17, 3.023e-17, 2.514e-17, 2.091e-17, 1.739e-17, 1.447e-17, 1.203e-17]),
		CE(j=18, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.079e-16, 8.976e-17, 7.466e-17, 6.21e-17, 5.165e-17, 4.296e-17, 3.573e-17, 2.972e-17, 2.472e-17, 2.056e-17, 1.71e-17, 1.423e-17, 1.183e-17]),
		CE(j=19, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.079e-16, 8.973e-17, 7.464e-17, 6.208e-17, 5.163e-17, 4.295e-17, 3.572e-17, 2.971e-17, 2.471e-17, 2.056e-17, 1.71e-17, 1.422e-17, 1.183e-17]),
		CE(j=20, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.078e-16, 8.968e-17, 7.459e-17, 6.204e-17, 5.161e-17, 4.292e-17, 3.57e-17, 2.97e-17, 2.47e-17, 2.054e-17, 1.709e-17, 1.421e-17, 1.182e-17]),
		CE(j=21, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.043e-16, 8.674e-17, 7.215e-17, 6.001e-17, 4.992e-17, 4.152e-17, 3.453e-17, 2.872e-17, 2.389e-17, 1.987e-17, 1.653e-17, 1.375e-17, 1.143e-17]),
		CE(j=22, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.006e-16, 8.365e-17, 6.957e-17, 5.787e-17, 4.813e-17, 4.004e-17, 3.33e-17, 2.77e-17, 2.304e-17, 1.916e-17, 1.594e-17, 1.326e-17, 1.103e-17]),
		CE(j=23, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.727e-17, 8.09e-17, 6.729e-17, 5.597e-17, 4.656e-17, 3.872e-17, 3.221e-17, 2.679e-17, 2.228e-17, 1.853e-17, 1.542e-17, 1.282e-17, 1.067e-17]),
		CE(j=24, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.727e-17, 8.09e-17, 6.729e-17, 5.597e-17, 4.655e-17, 3.872e-17, 3.221e-17, 2.679e-17, 2.228e-17, 1.853e-17, 1.542e-17, 1.282e-17, 1.066e-17]),
		CE(j=25, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.726e-17, 8.09e-17, 6.729e-17, 5.597e-17, 4.655e-17, 3.872e-17, 3.221e-17, 2.679e-17, 2.228e-17, 1.853e-17, 1.542e-17, 1.282e-17, 1.066e-17]),
		CE(j=26, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.198e-16, 4.057e-16, 2.291e-16, 1.298e-16, 7.391e-17, 4.251e-17, 2.482e-17, 1.481e-17, 9.084e-18, 5.727e-18, 3.693e-18, 2.415e-18, 1.588e-18]),
		CE(j=27, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.03e-17, 7.51e-17, 6.247e-17, 5.196e-17, 4.322e-17, 3.595e-17, 2.99e-17, 2.487e-17, 2.069e-17, 1.721e-17, 1.431e-17, 1.19e-17, 9.901e-18]),
		CE(j=28, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.42e-17, 1.927e-17, 1.088e-17, 6.164e-18, 3.511e-18, 2.019e-18, 1.179e-18, 7.035e-19, 4.313e-19, 2.719e-19, 1.754e-19, 1.147e-19, 7.544e-20]),
		CE(j=29, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.018e-17, 7.501e-17, 6.239e-17, 5.189e-17, 4.316e-17, 3.59e-17, 2.986e-17, 2.484e-17, 2.066e-17, 1.718e-17, 1.429e-17, 1.189e-17, 9.888e-18]),
		CE(j=30, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.155e-17, 2.342e-17, 1.322e-17, 7.49e-18, 4.266e-18, 2.453e-18, 1.432e-18, 8.547e-19, 5.24e-19, 3.304e-19, 2.131e-19, 1.394e-19, 9.167e-20]),
		CE(j=31, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.005e-17, 7.49e-17, 6.23e-17, 5.182e-17, 4.31e-17, 3.585e-17, 2.982e-17, 2.48e-17, 2.063e-17, 1.716e-17, 1.427e-17, 1.187e-17, 9.874e-18]),
		CE(j=32, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.23e-17, 1.82e-17, 1.028e-17, 5.822e-18, 3.316e-18, 1.907e-18, 1.113e-18, 6.643e-19, 4.073e-19, 2.568e-19, 1.656e-19, 1.084e-19, 7.126e-20]),
		CE(j=33, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.617e-15, 2.602e-15, 1.469e-15, 8.323e-16, 4.741e-16, 2.726e-16, 1.591e-16, 9.496e-17, 5.822e-17, 3.67e-17, 2.368e-17, 1.549e-17, 1.019e-17]),
		CE(j=34, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.954e-16, 2.792e-16, 1.576e-16, 8.929e-17, 5.085e-17, 2.924e-17, 1.707e-17, 1.019e-17, 6.244e-18, 3.937e-18, 2.54e-18, 1.662e-18, 1.093e-18]),
		CE(j=35, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.787e-17, 7.309e-17, 6.079e-17, 5.056e-17, 4.206e-17, 3.498e-17, 2.91e-17, 2.42e-17, 2.013e-17, 1.674e-17, 1.393e-17, 1.158e-17, 9.635e-18]),
		CE(j=36, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.785e-17, 7.307e-17, 6.078e-17, 5.055e-17, 4.205e-17, 3.497e-17, 2.909e-17, 2.42e-17, 2.013e-17, 1.674e-17, 1.392e-17, 1.158e-17, 9.633e-18]),
		CE(j=37, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.784e-17, 7.306e-17, 6.077e-17, 5.055e-17, 4.204e-17, 3.497e-17, 2.909e-17, 2.419e-17, 2.012e-17, 1.674e-17, 1.392e-17, 1.158e-17, 9.632e-18]),
		CE(j=40, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.304e-17, 4.411e-17, 3.669e-17, 3.052e-17, 2.538e-17, 2.111e-17, 1.756e-17, 1.461e-17, 1.215e-17, 1.011e-17, 8.406e-18, 6.991e-18, 5.815e-18]),
		CE(j=41, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.302e-17, 4.41e-17, 3.668e-17, 3.051e-17, 2.538e-17, 2.111e-17, 1.756e-17, 1.46e-17, 1.215e-17, 1.01e-17, 8.402e-18, 6.989e-18, 5.813e-18]),
		CE(j=42, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.299e-17, 4.408e-17, 3.666e-17, 3.049e-17, 2.536e-17, 2.11e-17, 1.755e-17, 1.46e-17, 1.214e-17, 1.01e-17, 8.399e-18, 6.986e-18, 5.81e-18]),
		CE(j=43, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.095e-17, 4.238e-17, 3.525e-17, 2.932e-17, 2.439e-17, 2.028e-17, 1.687e-17, 1.403e-17, 1.167e-17, 9.708e-18, 8.075e-18, 6.716e-18, 5.586e-18]),
		CE(j=5, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.645e-15, 1.368e-15, 1.138e-15, 9.463e-16, 7.871e-16, 6.547e-16, 5.446e-16, 4.529e-16, 3.767e-16, 3.134e-16, 2.606e-16, 2.168e-16, 1.803e-16]),
		CE(j=6, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.33e-16, 1.938e-16, 1.612e-16, 1.341e-16, 1.115e-16, 9.274e-17, 7.714e-17, 6.416e-17, 5.337e-17, 4.439e-17, 3.692e-17, 3.071e-17, 2.554e-17]),
		CE(j=7, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.508e-18, 1.416e-18, 8.011e-19, 4.555e-19, 2.612e-19, 1.518e-19, 8.987e-20, 5.45e-20, 3.389e-20, 2.152e-20, 1.385e-20, 8.974e-21, 5.807e-21]),
		CE(j=8, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.324e-16, 1.933e-16, 1.607e-16, 1.337e-16, 1.112e-16, 9.25e-17, 7.694e-17, 6.4e-17, 5.323e-17, 4.427e-17, 3.683e-17, 3.063e-17, 2.548e-17]),
		CE(j=9, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.036e-14, 5.848e-15, 3.309e-15, 1.881e-15, 1.078e-15, 6.26e-16, 3.705e-16, 2.246e-16, 1.396e-16, 8.87e-17, 5.718e-17, 3.71e-17, 2.406e-17]),
		CE(j=10, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.544e-17, 7.938e-17, 6.603e-17, 5.492e-17, 4.568e-17, 3.799e-17, 3.16e-17, 2.629e-17, 2.186e-17]),
		CE(j=11, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.542e-17, 7.937e-17, 6.602e-17, 5.491e-17, 4.567e-17, 3.799e-17, 3.16e-17, 2.628e-17, 2.186e-17]),
		CE(j=12, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.542e-17, 7.937e-17, 6.601e-17, 5.491e-17, 4.567e-17, 3.799e-17, 3.16e-17, 2.628e-17, 2.186e-17]),
		CE(j=13, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.667e-16, 1.387e-16, 1.153e-16, 9.594e-17, 7.98e-17, 6.637e-17, 5.521e-17, 4.592e-17, 3.819e-17, 3.177e-17, 2.642e-17, 2.198e-17, 1.828e-17]),
		CE(j=14, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.619e-16, 1.347e-16, 1.12e-16, 9.316e-17, 7.749e-17, 6.445e-17, 5.361e-17, 4.459e-17, 3.709e-17, 3.085e-17, 2.566e-17, 2.134e-17, 1.775e-17]),
		CE(j=15, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.618e-16, 1.346e-16, 1.119e-16, 9.309e-17, 7.743e-17, 6.44e-17, 5.357e-17, 4.456e-17, 3.706e-17, 3.083e-17, 2.564e-17, 2.133e-17, 1.774e-17]),
		CE(j=16, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.616e-16, 1.344e-16, 1.118e-16, 9.298e-17, 7.734e-17, 6.433e-17, 5.351e-17, 4.451e-17, 3.702e-17, 3.079e-17, 2.561e-17, 2.13e-17, 1.772e-17]),
		CE(j=17, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.561e-16, 1.298e-16, 1.08e-16, 8.983e-17, 7.471e-17, 6.214e-17, 5.169e-17, 4.299e-17, 3.576e-17, 2.974e-17, 2.474e-17, 2.058e-17, 1.712e-17]),
		CE(j=18, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.529e-16, 1.272e-16, 1.058e-16, 8.799e-17, 7.318e-17, 6.087e-17, 5.063e-17, 4.211e-17, 3.503e-17, 2.913e-17, 2.423e-17, 2.016e-17, 1.677e-17]),
		CE(j=19, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.528e-16, 1.271e-16, 1.057e-16, 8.795e-17, 7.315e-17, 6.085e-17, 5.061e-17, 4.209e-17, 3.501e-17, 2.912e-17, 2.422e-17, 2.015e-17, 1.676e-17]),
		CE(j=20, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.527e-16, 1.27e-16, 1.057e-16, 8.789e-17, 7.31e-17, 6.08e-17, 5.057e-17, 4.207e-17, 3.499e-17, 2.91e-17, 2.421e-17, 2.013e-17, 1.675e-17]),
		CE(j=21, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.466e-16, 1.219e-16, 1.014e-16, 8.437e-17, 7.017e-17, 5.837e-17, 4.855e-17, 4.038e-17, 3.359e-17, 2.794e-17, 2.324e-17, 1.933e-17, 1.608e-17]),
		CE(j=22, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.402e-16, 1.166e-16, 9.702e-17, 8.07e-17, 6.712e-17, 5.583e-17, 4.644e-17, 3.863e-17, 3.213e-17, 2.672e-17, 2.223e-17, 1.849e-17, 1.538e-17]),
		CE(j=23, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.347e-16, 1.12e-16, 9.317e-17, 7.75e-17, 6.446e-17, 5.361e-17, 4.459e-17, 3.709e-17, 3.085e-17, 2.566e-17, 2.134e-17, 1.775e-17, 1.477e-17]),
		CE(j=24, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.347e-16, 1.12e-16, 9.317e-17, 7.749e-17, 6.446e-17, 5.361e-17, 4.459e-17, 3.709e-17, 3.085e-17, 2.566e-17, 2.134e-17, 1.775e-17, 1.477e-17]),
		CE(j=25, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.347e-16, 1.12e-16, 9.316e-17, 7.749e-17, 6.445e-17, 5.361e-17, 4.459e-17, 3.709e-17, 3.085e-17, 2.566e-17, 2.134e-17, 1.775e-17, 1.477e-17]),
		CE(j=26, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.25e-16, 1.04e-16, 8.649e-17, 7.194e-17, 5.984e-17, 4.977e-17, 4.14e-17, 3.443e-17, 2.864e-17, 2.382e-17, 1.981e-17, 1.648e-17, 1.371e-17]),
		CE(j=27, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.231e-16, 1.024e-16, 8.516e-17, 7.084e-17, 5.892e-17, 4.901e-17, 4.076e-17, 3.39e-17, 2.82e-17, 2.346e-17, 1.951e-17, 1.623e-17, 1.35e-17]),
		CE(j=28, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.23e-16, 1.023e-16, 8.512e-17, 7.08e-17, 5.889e-17, 4.898e-17, 4.074e-17, 3.389e-17, 2.819e-17, 2.344e-17, 1.95e-17, 1.622e-17, 1.349e-17]),
		CE(j=29, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.229e-16, 1.022e-16, 8.504e-17, 7.073e-17, 5.883e-17, 4.893e-17, 4.07e-17, 3.385e-17, 2.816e-17, 2.342e-17, 1.948e-17, 1.62e-17, 1.348e-17]),
		CE(j=30, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.199e-17, 5.188e-17, 2.932e-17, 1.664e-17, 9.504e-18, 5.493e-18, 3.231e-18, 1.948e-18, 1.209e-18, 7.711e-19, 5.022e-19, 3.307e-19, 2.182e-19]),
		CE(j=31, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.227e-16, 1.021e-16, 8.489e-17, 7.061e-17, 5.873e-17, 4.885e-17, 4.063e-17, 3.38e-17, 2.811e-17, 2.338e-17, 1.945e-17, 1.618e-17, 1.345e-17]),
		CE(j=32, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.227e-16, 1.02e-16, 8.486e-17, 7.059e-17, 5.871e-17, 4.883e-17, 4.062e-17, 3.378e-17, 2.81e-17, 2.337e-17, 1.944e-17, 1.617e-17, 1.345e-17]),
		CE(j=33, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.219e-16, 1.014e-16, 8.433e-17, 7.015e-17, 5.834e-17, 4.853e-17, 4.036e-17, 3.357e-17, 2.793e-17, 2.323e-17, 1.932e-17, 1.607e-17, 1.337e-17]),
		CE(j=34, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.774e-15, 4.384e-15, 2.478e-15, 1.406e-15, 8.03e-16, 4.64e-16, 2.73e-16, 1.646e-16, 1.021e-16, 6.513e-17, 4.243e-17, 2.795e-17, 1.845e-17]),
		CE(j=35, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.191e-16, 9.909e-17, 8.242e-17, 6.856e-17, 5.702e-17, 4.743e-17, 3.945e-17, 3.281e-17, 2.729e-17, 2.27e-17, 1.888e-17, 1.571e-17, 1.306e-17]),
		CE(j=36, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.191e-16, 9.907e-17, 8.24e-17, 6.854e-17, 5.701e-17, 4.742e-17, 3.944e-17, 3.281e-17, 2.729e-17, 2.27e-17, 1.888e-17, 1.57e-17, 1.306e-17]),
		CE(j=37, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.191e-16, 9.906e-17, 8.239e-17, 6.853e-17, 5.7e-17, 4.741e-17, 3.944e-17, 3.28e-17, 2.728e-17, 2.269e-17, 1.888e-17, 1.57e-17, 1.306e-17]),
		CE(j=40, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.608e-17, 5.497e-17, 4.572e-17, 3.803e-17, 3.163e-17, 2.631e-17, 2.188e-17, 1.82e-17, 1.514e-17, 1.259e-17, 1.047e-17, 8.711e-18, 7.246e-18]),
		CE(j=41, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.606e-17, 5.494e-17, 4.57e-17, 3.801e-17, 3.162e-17, 2.63e-17, 2.187e-17, 1.819e-17, 1.513e-17, 1.259e-17, 1.047e-17, 8.708e-18, 7.243e-18]),
		CE(j=42, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.602e-17, 5.491e-17, 4.568e-17, 3.799e-17, 3.16e-17, 2.628e-17, 2.186e-17, 1.818e-17, 1.512e-17, 1.258e-17, 1.046e-17, 8.703e-18, 7.239e-18]),
		CE(j=43, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.313e-17, 5.251e-17, 4.368e-17, 3.633e-17, 3.022e-17, 2.513e-17, 2.091e-17, 1.739e-17, 1.446e-17, 1.203e-17, 1.001e-17, 8.323e-18, 6.922e-18]),
		CE(j=6, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.371e-16, 3.636e-16, 3.024e-16, 2.515e-16, 2.092e-16, 1.74e-16, 1.447e-16, 1.204e-16, 1.001e-16, 8.329e-17, 6.928e-17, 5.762e-17, 4.793e-17]),
		CE(j=7, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.366e-16, 3.631e-16, 3.02e-16, 2.512e-16, 2.09e-16, 1.738e-16, 1.446e-16, 1.202e-16, 1e-16, 8.319e-17, 6.92e-17, 5.755e-17, 4.787e-17]),
		CE(j=8, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.355e-16, 3.622e-16, 3.013e-16, 2.506e-16, 2.084e-16, 1.734e-16, 1.442e-16, 1.199e-16, 9.976e-17, 8.298e-17, 6.902e-17, 5.741e-17, 4.775e-17]),
		CE(j=9, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.951e-16, 3.286e-16, 2.734e-16, 2.274e-16, 1.891e-16, 1.573e-16, 1.308e-16, 1.088e-16, 9.052e-17, 7.529e-17, 6.262e-17, 5.209e-17, 4.332e-17]),
		CE(j=10, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.502e-16, 2.913e-16, 2.423e-16, 2.015e-16, 1.676e-16, 1.394e-16, 1.16e-16, 9.645e-17, 8.022e-17, 6.672e-17, 5.55e-17, 4.616e-17, 3.84e-17]),
		CE(j=11, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.501e-16, 2.912e-16, 2.422e-16, 2.015e-16, 1.676e-16, 1.394e-16, 1.159e-16, 9.643e-17, 8.021e-17, 6.671e-17, 5.549e-17, 4.615e-17, 3.839e-17]),
		CE(j=12, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.501e-16, 2.912e-16, 2.422e-16, 2.015e-16, 1.676e-16, 1.394e-16, 1.159e-16, 9.643e-17, 8.02e-17, 6.671e-17, 5.549e-17, 4.615e-17, 3.839e-17]),
		CE(j=13, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.74e-16, 2.279e-16, 1.896e-16, 1.577e-16, 1.312e-16, 1.091e-16, 9.074e-17, 7.547e-17, 6.278e-17, 5.222e-17, 4.343e-17, 3.612e-17, 3.005e-17]),
		CE(j=14, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.634e-16, 2.191e-16, 1.823e-16, 1.516e-16, 1.261e-16, 1.049e-16, 8.724e-17, 7.256e-17, 6.035e-17, 5.02e-17, 4.175e-17, 3.473e-17, 2.889e-17]),
		CE(j=15, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.632e-16, 2.189e-16, 1.821e-16, 1.514e-16, 1.26e-16, 1.048e-16, 8.715e-17, 7.249e-17, 6.029e-17, 5.015e-17, 4.171e-17, 3.469e-17, 2.886e-17]),
		CE(j=16, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.628e-16, 2.186e-16, 1.818e-16, 1.512e-16, 1.258e-16, 1.046e-16, 8.701e-17, 7.237e-17, 6.02e-17, 5.007e-17, 4.165e-17, 3.464e-17, 2.881e-17]),
		CE(j=17, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.51e-16, 2.087e-16, 1.736e-16, 1.444e-16, 1.201e-16, 9.991e-17, 8.31e-17, 6.912e-17, 5.749e-17, 4.782e-17, 3.977e-17, 3.308e-17, 2.752e-17]),
		CE(j=18, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.442e-16, 2.031e-16, 1.689e-16, 1.405e-16, 1.169e-16, 9.721e-17, 8.085e-17, 6.725e-17, 5.594e-17, 4.653e-17, 3.87e-17, 3.219e-17, 2.677e-17]),
		CE(j=19, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.44e-16, 2.03e-16, 1.688e-16, 1.404e-16, 1.168e-16, 9.715e-17, 8.081e-17, 6.721e-17, 5.591e-17, 4.65e-17, 3.868e-17, 3.217e-17, 2.676e-17]),
		CE(j=20, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.438e-16, 2.028e-16, 1.687e-16, 1.403e-16, 1.167e-16, 9.707e-17, 8.074e-17, 6.715e-17, 5.586e-17, 4.646e-17, 3.864e-17, 3.214e-17, 2.673e-17]),
		CE(j=21, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.31e-16, 1.922e-16, 1.598e-16, 1.33e-16, 1.106e-16, 9.198e-17, 7.651e-17, 6.364e-17, 5.293e-17, 4.402e-17, 3.662e-17, 3.046e-17, 2.533e-17]),
		CE(j=22, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.18e-16, 1.813e-16, 1.508e-16, 1.255e-16, 1.044e-16, 8.68e-17, 7.22e-17, 6.005e-17, 4.995e-17, 4.154e-17, 3.456e-17, 2.874e-17, 2.391e-17]),
		CE(j=23, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.069e-16, 1.721e-16, 1.431e-16, 1.19e-16, 9.902e-17, 8.236e-17, 6.85e-17, 5.698e-17, 4.739e-17, 3.942e-17, 3.279e-17, 2.727e-17, 2.268e-17]),
		CE(j=24, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.069e-16, 1.721e-16, 1.431e-16, 1.19e-16, 9.901e-17, 8.235e-17, 6.85e-17, 5.697e-17, 4.739e-17, 3.942e-17, 3.279e-17, 2.727e-17, 2.268e-17]),
		CE(j=25, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.069e-16, 1.721e-16, 1.431e-16, 1.19e-16, 9.901e-17, 8.235e-17, 6.85e-17, 5.697e-17, 4.739e-17, 3.942e-17, 3.278e-17, 2.727e-17, 2.268e-17]),
		CE(j=26, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.881e-16, 1.564e-16, 1.301e-16, 1.082e-16, 9.001e-17, 7.486e-17, 6.227e-17, 5.179e-17, 4.308e-17, 3.583e-17, 2.98e-17, 2.479e-17, 2.062e-17]),
		CE(j=27, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.844e-16, 1.534e-16, 1.276e-16, 1.061e-16, 8.825e-17, 7.34e-17, 6.105e-17, 5.078e-17, 4.224e-17, 3.513e-17, 2.922e-17, 2.431e-17, 2.022e-17]),
		CE(j=28, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.843e-16, 1.533e-16, 1.275e-16, 1.06e-16, 8.819e-17, 7.336e-17, 6.101e-17, 5.075e-17, 4.221e-17, 3.511e-17, 2.92e-17, 2.429e-17, 2.02e-17]),
		CE(j=29, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.84e-16, 1.531e-16, 1.273e-16, 1.059e-16, 8.808e-17, 7.326e-17, 6.094e-17, 5.068e-17, 4.216e-17, 3.506e-17, 2.917e-17, 2.426e-17, 2.018e-17]),
		CE(j=30, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.837e-16, 1.528e-16, 1.271e-16, 1.057e-16, 8.793e-17, 7.314e-17, 6.084e-17, 5.06e-17, 4.209e-17, 3.501e-17, 2.912e-17, 2.422e-17, 2.014e-17]),
		CE(j=31, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.836e-16, 1.527e-16, 1.27e-16, 1.057e-16, 8.789e-17, 7.31e-17, 6.08e-17, 5.057e-17, 4.207e-17, 3.499e-17, 2.91e-17, 2.421e-17, 2.013e-17]),
		CE(j=32, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.835e-16, 1.527e-16, 1.27e-16, 1.056e-16, 8.785e-17, 7.307e-17, 6.078e-17, 5.055e-17, 4.205e-17, 3.497e-17, 2.909e-17, 2.42e-17, 2.013e-17]),
		CE(j=33, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.821e-16, 1.515e-16, 1.26e-16, 1.048e-16, 8.716e-17, 7.249e-17, 6.03e-17, 5.015e-17, 4.172e-17, 3.47e-17, 2.886e-17, 2.4e-17, 1.997e-17]),
		CE(j=34, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.807e-16, 1.503e-16, 1.25e-16, 1.04e-16, 8.65e-17, 7.195e-17, 5.984e-17, 4.978e-17, 4.14e-17, 3.444e-17, 2.864e-17, 2.382e-17, 1.982e-17]),
		CE(j=35, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.769e-16, 1.471e-16, 1.224e-16, 1.018e-16, 8.466e-17, 7.042e-17, 5.857e-17, 4.872e-17, 4.052e-17, 3.37e-17, 2.803e-17, 2.332e-17, 1.939e-17]),
		CE(j=36, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.768e-16, 1.471e-16, 1.223e-16, 1.018e-16, 8.464e-17, 7.04e-17, 5.855e-17, 4.87e-17, 4.051e-17, 3.369e-17, 2.803e-17, 2.331e-17, 1.939e-17]),
		CE(j=37, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.768e-16, 1.471e-16, 1.223e-16, 1.017e-16, 8.462e-17, 7.039e-17, 5.854e-17, 4.87e-17, 4.05e-17, 3.369e-17, 2.802e-17, 2.331e-17, 1.939e-17]),
		CE(j=40, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.313e-15, 7.403e-16, 4.184e-16, 2.375e-16, 1.357e-16, 7.853e-17, 4.634e-17, 2.813e-17, 1.768e-17, 1.152e-17, 7.719e-18, 5.252e-18, 3.584e-18]),
		CE(j=41, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.084e-15, 1.175e-15, 6.644e-16, 3.77e-16, 2.155e-16, 1.247e-16, 7.357e-17, 4.466e-17, 2.808e-17, 1.829e-17, 1.226e-17, 8.339e-18, 5.69e-18]),
		CE(j=42, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.06e-15, 1.726e-15, 9.755e-16, 5.536e-16, 3.164e-16, 1.831e-16, 1.08e-16, 6.557e-17, 4.123e-17, 2.686e-17, 1.8e-17, 1.224e-17, 8.355e-18]),
		CE(j=43, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.192e-17, 6.814e-17, 5.668e-17, 4.714e-17, 3.921e-17, 3.261e-17, 2.713e-17, 2.256e-17, 1.877e-17, 1.561e-17, 1.298e-17, 1.08e-17, 8.982e-18]),
		CE(j=7, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.287e-11, 6.893e-11, 5.733e-11, 4.769e-11, 3.967e-11, 3.299e-11, 2.744e-11, 2.282e-11, 1.898e-11, 1.579e-11, 1.313e-11, 1.092e-11, 9.087e-12]),
		CE(j=8, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.232e-11, 1.025e-11, 8.523e-12, 7.089e-12, 5.897e-12, 4.905e-12, 4.079e-12, 3.393e-12, 2.822e-12, 2.347e-12, 1.953e-12, 1.624e-12, 1.351e-12]),
		CE(j=9, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.674e-14, 3.888e-14, 3.234e-14, 2.69e-14, 2.237e-14, 1.861e-14, 1.548e-14, 1.287e-14, 1.071e-14, 8.906e-15, 7.408e-15, 6.162e-15, 5.125e-15]),
		CE(j=10, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.173e-14, 9.757e-15, 8.115e-15, 6.75e-15, 5.614e-15, 4.67e-15, 3.884e-15, 3.231e-15, 2.687e-15, 2.235e-15, 1.859e-15, 1.546e-15, 1.286e-15]),
		CE(j=11, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.171e-14, 9.744e-15, 8.105e-15, 6.741e-15, 5.607e-15, 4.664e-15, 3.879e-15, 3.227e-15, 2.684e-15, 2.232e-15, 1.857e-15, 1.544e-15, 1.284e-15]),
		CE(j=12, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.171e-14, 9.739e-15, 8.101e-15, 6.738e-15, 5.604e-15, 4.661e-15, 3.877e-15, 3.225e-15, 2.682e-15, 2.231e-15, 1.856e-15, 1.544e-15, 1.284e-15]),
		CE(j=13, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.727e-17, 4.412e-17, 2.547e-17, 1.495e-17, 8.964e-18, 5.508e-18, 3.461e-18, 2.211e-18, 1.425e-18, 9.204e-19, 5.92e-19, 3.779e-19, 2.39e-19]),
		CE(j=14, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.046e-13, 6.19e-14, 3.787e-14, 2.427e-14, 1.646e-14, 1.176e-14, 8.651e-15, 6.218e-15, 4.374e-15, 2.94e-15, 1.977e-15, 1.296e-15, 8.229e-16]),
		CE(j=15, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.519e-15, 2.095e-15, 1.743e-15, 1.45e-15, 1.206e-15, 1.003e-15, 8.342e-16, 6.939e-16, 5.771e-16, 4.8e-16, 3.993e-16, 3.321e-16, 2.762e-16]),
		CE(j=16, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.504e-15, 2.083e-15, 1.733e-15, 1.441e-15, 1.199e-15, 9.97e-16, 8.292e-16, 6.897e-16, 5.737e-16, 4.772e-16, 3.969e-16, 3.301e-16, 2.746e-16]),
		CE(j=17, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.012e-14, 2.891e-14, 1.685e-14, 9.907e-15, 5.971e-15, 3.683e-15, 2.317e-15, 1.487e-15, 9.654e-16, 6.29e-16, 4.086e-16, 2.634e-16, 1.681e-16]),
		CE(j=18, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.921e-15, 1.598e-15, 1.329e-15, 1.105e-15, 9.195e-16, 7.648e-16, 6.361e-16, 5.291e-16, 4.401e-16, 3.661e-16, 3.045e-16, 2.533e-16, 2.106e-16]),
		CE(j=19, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.002e-14, 4.689e-14, 2.822e-14, 1.764e-14, 1.15e-14, 7.697e-15, 5.278e-15, 3.494e-15, 2.343e-15, 1.581e-15, 1.03e-15, 6.659e-16, 4.262e-16]),
		CE(j=20, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.912e-15, 1.59e-15, 1.322e-15, 1.1e-15, 9.149e-16, 7.61e-16, 6.33e-16, 5.265e-16, 4.379e-16, 3.642e-16, 3.03e-16, 2.52e-16, 2.096e-16]),
		CE(j=21, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.602e-15, 1.332e-15, 1.108e-15, 9.219e-16, 7.668e-16, 6.378e-16, 5.305e-16, 4.412e-16, 3.67e-16, 3.053e-16, 2.539e-16, 2.112e-16, 1.757e-16]),
		CE(j=22, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.342e-15, 1.116e-15, 9.284e-16, 7.722e-16, 6.423e-16, 5.342e-16, 4.444e-16, 3.696e-16, 3.074e-16, 2.557e-16, 2.127e-16, 1.769e-16, 1.471e-16]),
		CE(j=23, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.155e-15, 9.603e-16, 7.987e-16, 6.643e-16, 5.526e-16, 4.596e-16, 3.823e-16, 3.18e-16, 2.645e-16, 2.2e-16, 1.83e-16, 1.522e-16, 1.266e-16]),
		CE(j=24, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.154e-15, 9.601e-16, 7.986e-16, 6.643e-16, 5.525e-16, 4.596e-16, 3.822e-16, 3.179e-16, 2.644e-16, 2.2e-16, 1.83e-16, 1.522e-16, 1.266e-16]),
		CE(j=25, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.154e-15, 9.6e-16, 7.985e-16, 6.642e-16, 5.524e-16, 4.595e-16, 3.822e-16, 3.179e-16, 2.644e-16, 2.199e-16, 1.829e-16, 1.522e-16, 1.266e-16]),
		CE(j=26, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.964e-16, 7.456e-16, 6.201e-16, 5.158e-16, 4.29e-16, 3.568e-16, 2.968e-16, 2.469e-16, 2.053e-16, 1.708e-16, 1.421e-16, 1.182e-16, 9.828e-17]),
		CE(j=27, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.53e-16, 7.095e-16, 5.902e-16, 4.909e-16, 4.083e-16, 3.396e-16, 2.825e-16, 2.349e-16, 1.954e-16, 1.625e-16, 1.352e-16, 1.125e-16, 9.353e-17]),
		CE(j=28, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.517e-16, 7.084e-16, 5.892e-16, 4.901e-16, 4.077e-16, 3.391e-16, 2.82e-16, 2.346e-16, 1.951e-16, 1.623e-16, 1.35e-16, 1.123e-16, 9.339e-17]),
		CE(j=29, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.49e-16, 7.061e-16, 5.873e-16, 4.885e-16, 4.063e-16, 3.38e-16, 2.811e-16, 2.338e-16, 1.945e-16, 1.618e-16, 1.346e-16, 1.119e-16, 9.309e-17]),
		CE(j=30, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.455e-16, 7.033e-16, 5.849e-16, 4.865e-16, 4.047e-16, 3.366e-16, 2.8e-16, 2.329e-16, 1.937e-16, 1.611e-16, 1.34e-16, 1.115e-16, 9.271e-17]),
		CE(j=31, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.444e-16, 7.023e-16, 5.842e-16, 4.859e-16, 4.042e-16, 3.362e-16, 2.796e-16, 2.326e-16, 1.934e-16, 1.609e-16, 1.338e-16, 1.113e-16, 9.259e-17]),
		CE(j=32, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.436e-16, 7.016e-16, 5.836e-16, 4.854e-16, 4.037e-16, 3.358e-16, 2.793e-16, 2.323e-16, 1.932e-16, 1.607e-16, 1.337e-16, 1.112e-16, 9.249e-17]),
		CE(j=33, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.272e-16, 6.88e-16, 5.723e-16, 4.76e-16, 3.959e-16, 3.293e-16, 2.739e-16, 2.278e-16, 1.895e-16, 1.576e-16, 1.311e-16, 1.09e-16, 9.07e-17]),
		CE(j=34, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.12e-16, 6.754e-16, 5.618e-16, 4.672e-16, 3.886e-16, 3.233e-16, 2.689e-16, 2.236e-16, 1.86e-16, 1.547e-16, 1.287e-16, 1.07e-16, 8.903e-17]),
		CE(j=35, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.708e-16, 6.411e-16, 5.332e-16, 4.435e-16, 3.689e-16, 3.068e-16, 2.552e-16, 2.123e-16, 1.766e-16, 1.469e-16, 1.222e-16, 1.016e-16, 8.451e-17]),
		CE(j=36, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.702e-16, 6.406e-16, 5.329e-16, 4.432e-16, 3.686e-16, 3.066e-16, 2.55e-16, 2.121e-16, 1.764e-16, 1.468e-16, 1.221e-16, 1.015e-16, 8.445e-17]),
		CE(j=37, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.699e-16, 6.404e-16, 5.327e-16, 4.43e-16, 3.685e-16, 3.065e-16, 2.549e-16, 2.121e-16, 1.764e-16, 1.467e-16, 1.22e-16, 1.015e-16, 8.442e-17]),
		CE(j=40, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.935e-16, 1.609e-16, 1.338e-16, 1.113e-16, 9.26e-17, 7.702e-17, 6.406e-17, 5.328e-17, 4.432e-17, 3.686e-17, 3.066e-17, 2.55e-17, 2.121e-17]),
		CE(j=41, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.933e-16, 1.608e-16, 1.337e-16, 1.112e-16, 9.252e-17, 7.696e-17, 6.401e-17, 5.324e-17, 4.428e-17, 3.683e-17, 3.064e-17, 2.548e-17, 2.12e-17]),
		CE(j=42, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.931e-16, 1.606e-16, 1.336e-16, 1.111e-16, 9.243e-17, 7.688e-17, 6.395e-17, 5.319e-17, 4.424e-17, 3.68e-17, 3.061e-17, 2.546e-17, 2.118e-17]),
		CE(j=43, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.776e-16, 1.477e-16, 1.229e-16, 1.022e-16, 8.501e-17, 7.071e-17, 5.881e-17, 4.892e-17, 4.069e-17, 3.384e-17, 2.815e-17, 2.341e-17, 1.947e-17]),
		CE(j=8, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.364e-11, 1.966e-11, 1.635e-11, 1.36e-11, 1.131e-11, 9.411e-12, 7.828e-12, 6.511e-12, 5.416e-12, 4.505e-12, 3.747e-12, 3.116e-12, 2.592e-12]),
		CE(j=9, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.767e-14, 3.965e-14, 3.298e-14, 2.743e-14, 2.282e-14, 1.898e-14, 1.578e-14, 1.313e-14, 1.092e-14, 9.083e-15, 7.555e-15, 6.284e-15, 5.227e-15]),
		CE(j=10, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.183e-14, 9.841e-15, 8.185e-15, 6.808e-15, 5.663e-15, 4.71e-15, 3.918e-15, 3.259e-15, 2.71e-15, 2.254e-15, 1.875e-15, 1.56e-15, 1.297e-15]),
		CE(j=11, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.182e-14, 9.828e-15, 8.175e-15, 6.799e-15, 5.656e-15, 4.704e-15, 3.913e-15, 3.254e-15, 2.707e-15, 2.252e-15, 1.873e-15, 1.558e-15, 1.296e-15]),
		CE(j=12, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.181e-14, 9.823e-15, 8.171e-15, 6.796e-15, 5.653e-15, 4.702e-15, 3.911e-15, 3.253e-15, 2.706e-15, 2.25e-15, 1.872e-15, 1.557e-15, 1.295e-15]),
		CE(j=13, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.952e-16, 1.686e-16, 9.732e-17, 5.711e-17, 3.425e-17, 2.105e-17, 1.323e-17, 8.45e-18, 5.446e-18, 3.517e-18, 2.262e-18, 1.444e-18, 9.129e-19]),
		CE(j=14, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.391e-14, 3.157e-14, 1.885e-14, 1.142e-14, 7.014e-15, 4.371e-15, 2.803e-15, 1.807e-15, 1.169e-15, 7.578e-16, 4.896e-16, 3.139e-16, 1.993e-16]),
		CE(j=15, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.224e-14, 5.451e-14, 3.324e-14, 2.119e-14, 1.423e-14, 9.976e-15, 7.055e-15, 5.021e-15, 3.354e-15, 2.255e-15, 1.509e-15, 9.677e-16, 6.145e-16]),
		CE(j=16, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.513e-15, 2.09e-15, 1.738e-15, 1.446e-15, 1.203e-15, 1e-15, 8.321e-16, 6.921e-16, 5.757e-16, 4.788e-16, 3.983e-16, 3.313e-16, 2.755e-16]),
		CE(j=17, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.844e-14, 2.787e-14, 1.61e-14, 9.464e-15, 5.687e-15, 3.488e-15, 2.195e-15, 1.409e-15, 9.145e-16, 5.958e-16, 3.87e-16, 2.495e-16, 1.592e-16]),
		CE(j=18, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.663e-14, 2.657e-14, 1.529e-14, 8.937e-15, 5.337e-15, 3.272e-15, 2.059e-15, 1.323e-15, 8.608e-16, 5.623e-16, 3.663e-16, 2.369e-16, 1.516e-16]),
		CE(j=19, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.28e-14, 1.869e-14, 1.076e-14, 6.287e-15, 3.755e-15, 2.302e-15, 1.448e-15, 9.307e-16, 6.056e-16, 3.956e-16, 2.578e-16, 1.667e-16, 1.067e-16]),
		CE(j=20, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.293e-14, 3.061e-14, 1.794e-14, 1.055e-14, 6.351e-15, 3.938e-15, 2.478e-15, 1.592e-15, 1.036e-15, 6.77e-16, 4.411e-16, 2.852e-16, 1.826e-16]),
		CE(j=21, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.754e-18, 3.846e-18, 2.211e-18, 1.29e-18, 7.687e-19, 4.706e-19, 2.962e-19, 1.908e-19, 1.246e-19, 8.185e-20, 5.364e-20, 3.489e-20, 2.245e-20]),
		CE(j=22, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.103e-18, 1.196e-18, 6.869e-19, 4.001e-19, 2.38e-19, 1.455e-19, 9.158e-20, 5.91e-20, 3.877e-20, 2.56e-20, 1.687e-20, 1.104e-20, 7.148e-21]),
		CE(j=23, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.157e-15, 9.624e-16, 8.005e-16, 6.658e-16, 5.538e-16, 4.606e-16, 3.831e-16, 3.187e-16, 2.651e-16, 2.205e-16, 1.834e-16, 1.525e-16, 1.269e-16]),
		CE(j=24, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.157e-15, 9.622e-16, 8.003e-16, 6.657e-16, 5.537e-16, 4.605e-16, 3.831e-16, 3.186e-16, 2.65e-16, 2.204e-16, 1.833e-16, 1.525e-16, 1.268e-16]),
		CE(j=25, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.157e-15, 9.621e-16, 8.003e-16, 6.656e-16, 5.536e-16, 4.605e-16, 3.83e-16, 3.186e-16, 2.65e-16, 2.204e-16, 1.833e-16, 1.525e-16, 1.268e-16]),
		CE(j=26, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.98e-16, 7.469e-16, 6.213e-16, 5.168e-16, 4.298e-16, 3.575e-16, 2.974e-16, 2.473e-16, 2.057e-16, 1.711e-16, 1.423e-16, 1.184e-16, 9.847e-17]),
		CE(j=27, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.546e-16, 7.108e-16, 5.912e-16, 4.918e-16, 4.09e-16, 3.402e-16, 2.83e-16, 2.354e-16, 1.958e-16, 1.628e-16, 1.354e-16, 1.127e-16, 9.37e-17]),
		CE(j=28, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.533e-16, 7.097e-16, 5.903e-16, 4.91e-16, 4.084e-16, 3.397e-16, 2.825e-16, 2.35e-16, 1.955e-16, 1.626e-16, 1.352e-16, 1.125e-16, 9.356e-17]),
		CE(j=29, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.505e-16, 7.074e-16, 5.884e-16, 4.894e-16, 4.071e-16, 3.386e-16, 2.816e-16, 2.342e-16, 1.948e-16, 1.621e-16, 1.348e-16, 1.121e-16, 9.325e-17]),
		CE(j=30, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.47e-16, 7.045e-16, 5.86e-16, 4.874e-16, 4.054e-16, 3.372e-16, 2.805e-16, 2.333e-16, 1.94e-16, 1.614e-16, 1.342e-16, 1.117e-16, 9.287e-17]),
		CE(j=31, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.459e-16, 7.036e-16, 5.852e-16, 4.868e-16, 4.049e-16, 3.368e-16, 2.801e-16, 2.33e-16, 1.938e-16, 1.612e-16, 1.341e-16, 1.115e-16, 9.275e-17]),
		CE(j=32, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.451e-16, 7.029e-16, 5.846e-16, 4.863e-16, 4.045e-16, 3.364e-16, 2.798e-16, 2.328e-16, 1.936e-16, 1.61e-16, 1.339e-16, 1.114e-16, 9.266e-17]),
		CE(j=33, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.286e-16, 6.892e-16, 5.733e-16, 4.768e-16, 3.966e-16, 3.299e-16, 2.744e-16, 2.282e-16, 1.898e-16, 1.579e-16, 1.313e-16, 1.092e-16, 9.086e-17]),
		CE(j=34, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.134e-16, 6.766e-16, 5.627e-16, 4.681e-16, 3.893e-16, 3.238e-16, 2.693e-16, 2.24e-16, 1.863e-16, 1.55e-16, 1.289e-16, 1.072e-16, 8.919e-17]),
		CE(j=35, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.721e-16, 6.422e-16, 5.341e-16, 4.443e-16, 3.695e-16, 3.074e-16, 2.557e-16, 2.126e-16, 1.769e-16, 1.471e-16, 1.224e-16, 1.018e-16, 8.466e-17]),
		CE(j=36, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.715e-16, 6.417e-16, 5.338e-16, 4.44e-16, 3.693e-16, 3.071e-16, 2.555e-16, 2.125e-16, 1.767e-16, 1.47e-16, 1.223e-16, 1.017e-16, 8.46e-17]),
		CE(j=37, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.712e-16, 6.415e-16, 5.336e-16, 4.438e-16, 3.691e-16, 3.07e-16, 2.554e-16, 2.124e-16, 1.767e-16, 1.47e-16, 1.222e-16, 1.017e-16, 8.456e-17]),
		CE(j=40, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.936e-16, 1.61e-16, 1.339e-16, 1.114e-16, 9.267e-17, 7.708e-17, 6.411e-17, 5.332e-17, 4.435e-17, 3.689e-17, 3.068e-17, 2.552e-17, 2.123e-17]),
		CE(j=41, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.935e-16, 1.609e-16, 1.338e-16, 1.113e-16, 9.259e-17, 7.702e-17, 6.406e-17, 5.328e-17, 4.432e-17, 3.686e-17, 3.066e-17, 2.55e-17, 2.121e-17]),
		CE(j=42, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.933e-16, 1.608e-16, 1.337e-16, 1.112e-16, 9.25e-17, 7.694e-17, 6.4e-17, 5.323e-17, 4.427e-17, 3.683e-17, 3.063e-17, 2.548e-17, 2.119e-17]),
		CE(j=43, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.777e-16, 1.478e-16, 1.23e-16, 1.023e-16, 8.507e-17, 7.076e-17, 5.885e-17, 4.895e-17, 4.072e-17, 3.387e-17, 2.817e-17, 2.343e-17, 1.949e-17]),
		CE(j=9, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.973e-14, 4.136e-14, 3.44e-14, 2.862e-14, 2.38e-14, 1.98e-14, 1.647e-14, 1.37e-14, 1.139e-14, 9.476e-15, 7.882e-15, 6.556e-15, 5.453e-15]),
		CE(j=10, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.205e-14, 1.002e-14, 8.337e-15, 6.934e-15, 5.768e-15, 4.797e-15, 3.99e-15, 3.319e-15, 2.761e-15, 2.296e-15, 1.91e-15, 1.589e-15, 1.321e-15]),
		CE(j=11, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.203e-14, 1.001e-14, 8.326e-15, 6.925e-15, 5.76e-15, 4.791e-15, 3.985e-15, 3.315e-15, 2.757e-15, 2.293e-15, 1.907e-15, 1.586e-15, 1.32e-15]),
		CE(j=12, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.203e-14, 1e-14, 8.322e-15, 6.922e-15, 5.757e-15, 4.789e-15, 3.983e-15, 3.313e-15, 2.756e-15, 2.292e-15, 1.906e-15, 1.586e-15, 1.319e-15]),
		CE(j=13, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.892e-21, 1.081e-21, 6.239e-22, 3.662e-22, 2.196e-22, 1.35e-22, 8.483e-23, 5.42e-23, 3.493e-23, 2.255e-23, 1.45e-23, 9.256e-24, 5.852e-24]),
		CE(j=14, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.443e-15, 1.394e-15, 8.041e-16, 4.712e-16, 2.822e-16, 1.733e-16, 1.09e-16, 6.978e-17, 4.513e-17, 2.926e-17, 1.89e-17, 1.212e-17, 7.691e-18]),
		CE(j=15, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.738e-14, 2.133e-14, 1.23e-14, 7.208e-15, 4.317e-15, 2.651e-15, 1.667e-15, 1.067e-15, 6.903e-16, 4.476e-16, 2.892e-16, 1.854e-16, 1.177e-16]),
		CE(j=16, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.649e-14, 5.705e-14, 3.484e-14, 2.225e-14, 1.499e-14, 1.058e-14, 7.589e-15, 5.419e-15, 3.683e-15, 2.476e-15, 1.665e-15, 1.073e-15, 6.811e-16]),
		CE(j=17, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.355e-14, 2.483e-14, 1.43e-14, 8.367e-15, 5.002e-15, 3.069e-15, 1.931e-15, 1.239e-15, 8.046e-16, 5.242e-16, 3.404e-16, 2.194e-16, 1.4e-16]),
		CE(j=18, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.939e-15, 1.613e-15, 1.341e-15, 1.116e-15, 9.279e-16, 7.718e-16, 6.42e-16, 5.34e-16, 4.441e-16, 3.694e-16, 3.073e-16, 2.556e-16, 2.126e-16]),
		CE(j=19, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.808e-14, 2.17e-14, 1.249e-14, 7.3e-15, 4.36e-15, 2.673e-15, 1.682e-15, 1.081e-15, 7.034e-16, 4.595e-16, 2.994e-16, 1.935e-16, 1.238e-16]),
		CE(j=20, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.264e-14, 4.252e-14, 2.554e-14, 1.588e-14, 1.021e-14, 6.695e-15, 4.406e-15, 2.904e-15, 1.946e-15, 1.284e-15, 8.364e-16, 5.408e-16, 3.461e-16]),
		CE(j=21, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.599e-18, 1.48e-18, 8.506e-19, 4.963e-19, 2.959e-19, 1.812e-19, 1.14e-19, 7.345e-20, 4.799e-20, 3.151e-20, 2.065e-20, 1.343e-20, 8.641e-21]),
		CE(j=22, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.352e-15, 1.124e-15, 9.353e-16, 7.779e-16, 6.47e-16, 5.382e-16, 4.476e-16, 3.723e-16, 3.097e-16, 2.576e-16, 2.143e-16, 1.782e-16, 1.482e-16]),
		CE(j=23, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.162e-15, 9.668e-16, 8.041e-16, 6.688e-16, 5.563e-16, 4.627e-16, 3.849e-16, 3.201e-16, 2.663e-16, 2.215e-16, 1.842e-16, 1.532e-16, 1.274e-16]),
		CE(j=24, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.162e-15, 9.666e-16, 8.04e-16, 6.687e-16, 5.562e-16, 4.627e-16, 3.848e-16, 3.201e-16, 2.662e-16, 2.214e-16, 1.842e-16, 1.532e-16, 1.274e-16]),
		CE(j=25, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.162e-15, 9.665e-16, 8.039e-16, 6.687e-16, 5.562e-16, 4.626e-16, 3.848e-16, 3.2e-16, 2.662e-16, 2.214e-16, 1.842e-16, 1.532e-16, 1.274e-16]),
		CE(j=26, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.016e-16, 7.499e-16, 6.237e-16, 5.188e-16, 4.315e-16, 3.589e-16, 2.985e-16, 2.483e-16, 2.065e-16, 1.718e-16, 1.429e-16, 1.188e-16, 9.886e-17]),
		CE(j=27, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.578e-16, 7.135e-16, 5.935e-16, 4.936e-16, 4.106e-16, 3.415e-16, 2.841e-16, 2.363e-16, 1.965e-16, 1.635e-16, 1.36e-16, 1.131e-16, 9.406e-17]),
		CE(j=28, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.565e-16, 7.124e-16, 5.926e-16, 4.929e-16, 4.1e-16, 3.41e-16, 2.836e-16, 2.359e-16, 1.962e-16, 1.632e-16, 1.357e-16, 1.129e-16, 9.391e-17]),
		CE(j=29, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.537e-16, 7.101e-16, 5.906e-16, 4.913e-16, 4.086e-16, 3.399e-16, 2.827e-16, 2.351e-16, 1.956e-16, 1.627e-16, 1.353e-16, 1.125e-16, 9.361e-17]),
		CE(j=30, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.503e-16, 7.072e-16, 5.882e-16, 4.893e-16, 4.07e-16, 3.385e-16, 2.815e-16, 2.342e-16, 1.948e-16, 1.62e-16, 1.348e-16, 1.121e-16, 9.323e-17]),
		CE(j=31, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.491e-16, 7.063e-16, 5.875e-16, 4.886e-16, 4.064e-16, 3.38e-16, 2.812e-16, 2.339e-16, 1.945e-16, 1.618e-16, 1.346e-16, 1.119e-16, 9.31e-17]),
		CE(j=32, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.483e-16, 7.056e-16, 5.869e-16, 4.881e-16, 4.06e-16, 3.377e-16, 2.809e-16, 2.336e-16, 1.943e-16, 1.616e-16, 1.344e-16, 1.118e-16, 9.301e-17]),
		CE(j=33, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.317e-16, 6.918e-16, 5.754e-16, 4.786e-16, 3.981e-16, 3.311e-16, 2.754e-16, 2.291e-16, 1.905e-16, 1.585e-16, 1.318e-16, 1.096e-16, 9.12e-17]),
		CE(j=34, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.164e-16, 6.791e-16, 5.648e-16, 4.698e-16, 3.908e-16, 3.25e-16, 2.703e-16, 2.249e-16, 1.87e-16, 1.556e-16, 1.294e-16, 1.076e-16, 8.952e-17]),
		CE(j=35, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.748e-16, 6.445e-16, 5.361e-16, 4.459e-16, 3.709e-16, 3.085e-16, 2.566e-16, 2.134e-16, 1.775e-16, 1.476e-16, 1.228e-16, 1.021e-16, 8.496e-17]),
		CE(j=36, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.743e-16, 6.44e-16, 5.357e-16, 4.456e-16, 3.706e-16, 3.083e-16, 2.564e-16, 2.133e-16, 1.774e-16, 1.475e-16, 1.227e-16, 1.021e-16, 8.49e-17]),
		CE(j=37, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.74e-16, 6.438e-16, 5.355e-16, 4.454e-16, 3.705e-16, 3.081e-16, 2.563e-16, 2.132e-16, 1.773e-16, 1.475e-16, 1.227e-16, 1.02e-16, 8.487e-17]),
		CE(j=40, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.939e-16, 1.613e-16, 1.342e-16, 1.116e-16, 9.281e-17, 7.72e-17, 6.421e-17, 5.341e-17, 4.442e-17, 3.695e-17, 3.073e-17, 2.556e-17, 2.126e-17]),
		CE(j=41, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.938e-16, 1.612e-16, 1.34e-16, 1.115e-16, 9.274e-17, 7.714e-17, 6.416e-17, 5.337e-17, 4.439e-17, 3.692e-17, 3.071e-17, 2.554e-17, 2.125e-17]),
		CE(j=42, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.936e-16, 1.61e-16, 1.339e-16, 1.114e-16, 9.265e-17, 7.706e-17, 6.41e-17, 5.331e-17, 4.434e-17, 3.688e-17, 3.068e-17, 2.552e-17, 2.122e-17]),
		CE(j=43, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.78e-16, 1.481e-16, 1.231e-16, 1.024e-16, 8.519e-17, 7.086e-17, 5.894e-17, 4.902e-17, 4.078e-17, 3.392e-17, 2.821e-17, 2.346e-17, 1.952e-17]),
		CE(j=10, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.099e-14, 2.578e-14, 2.144e-14, 1.783e-14, 1.483e-14, 1.234e-14, 1.026e-14, 8.536e-15, 7.1e-15, 5.905e-15, 4.912e-15, 4.086e-15, 3.398e-15]),
		CE(j=11, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.092e-14, 2.572e-14, 2.139e-14, 1.779e-14, 1.48e-14, 1.231e-14, 1.024e-14, 8.516e-15, 7.083e-15, 5.892e-15, 4.901e-15, 4.076e-15, 3.39e-15]),
		CE(j=12, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.089e-14, 2.57e-14, 2.137e-14, 1.778e-14, 1.479e-14, 1.23e-14, 1.023e-14, 8.509e-15, 7.077e-15, 5.887e-15, 4.896e-15, 4.072e-15, 3.387e-15]),
		CE(j=13, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.119e-14, 5.468e-14, 3.405e-14, 2.227e-14, 1.534e-14, 1.093e-14, 7.724e-15, 5.408e-15, 3.598e-15, 2.403e-15, 1.579e-15, 1.001e-15, 6.29e-16]),
		CE(j=14, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.335e-16, 1.336e-16, 7.729e-17, 4.551e-17, 2.741e-17, 1.691e-17, 1.066e-17, 6.828e-18, 4.404e-18, 2.843e-18, 1.827e-18, 1.164e-18, 7.35e-19]),
		CE(j=15, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.486e-15, 2.899e-15, 2.412e-15, 2.006e-15, 1.668e-15, 1.388e-15, 1.154e-15, 9.601e-16, 7.986e-16, 6.642e-16, 5.525e-16, 4.595e-16, 3.822e-16]),
		CE(j=16, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.461e-15, 2.879e-15, 2.394e-15, 1.991e-15, 1.656e-15, 1.378e-15, 1.146e-15, 9.532e-16, 7.928e-16, 6.594e-16, 5.485e-16, 4.562e-16, 3.795e-16]),
		CE(j=17, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.407e-17, 3.66e-17, 2.115e-17, 1.243e-17, 7.468e-18, 4.605e-18, 2.907e-18, 1.867e-18, 1.21e-18, 7.859e-19, 5.081e-19, 3.258e-19, 2.068e-19]),
		CE(j=18, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.268e-18, 1.866e-18, 1.077e-18, 6.321e-19, 3.795e-19, 2.339e-19, 1.477e-19, 9.505e-20, 6.177e-20, 4.024e-20, 2.61e-20, 1.68e-20, 1.07e-20]),
		CE(j=19, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.688e-17, 1.534e-17, 8.857e-18, 5.199e-18, 3.121e-18, 1.923e-18, 1.215e-18, 7.817e-19, 5.08e-19, 3.309e-19, 2.147e-19, 1.382e-19, 8.799e-20]),
		CE(j=20, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.393e-19, 3.079e-19, 1.777e-19, 1.043e-19, 6.262e-20, 3.859e-20, 2.437e-20, 1.568e-20, 1.019e-20, 6.641e-21, 4.309e-21, 2.773e-21, 1.766e-21]),
		CE(j=21, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.063e-13, 6.262e-14, 3.801e-14, 2.411e-14, 1.616e-14, 1.142e-14, 8.315e-15, 5.982e-15, 4.174e-15, 2.831e-15, 1.921e-15, 1.262e-15, 8.085e-16]),
		CE(j=22, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.719e-14, 2.119e-14, 1.219e-14, 7.129e-15, 4.262e-15, 2.62e-15, 1.657e-15, 1.072e-15, 7.038e-16, 4.641e-16, 3.052e-16, 1.991e-16, 1.284e-16]),
		CE(j=23, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.405e-15, 1.169e-15, 9.723e-16, 8.087e-16, 6.727e-16, 5.595e-16, 4.654e-16, 3.871e-16, 3.22e-16, 2.678e-16, 2.227e-16, 1.853e-16, 1.541e-16]),
		CE(j=24, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.405e-15, 1.169e-15, 9.722e-16, 8.086e-16, 6.726e-16, 5.594e-16, 4.653e-16, 3.87e-16, 3.219e-16, 2.678e-16, 2.227e-16, 1.852e-16, 1.541e-16]),
		CE(j=25, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.405e-15, 1.169e-15, 9.721e-16, 8.085e-16, 6.725e-16, 5.594e-16, 4.653e-16, 3.87e-16, 3.219e-16, 2.677e-16, 2.227e-16, 1.852e-16, 1.541e-16]),
		CE(j=26, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.06e-15, 8.817e-16, 7.334e-16, 6.1e-16, 5.074e-16, 4.22e-16, 3.51e-16, 2.92e-16, 2.428e-16, 2.02e-16, 1.68e-16, 1.397e-16, 1.162e-16]),
		CE(j=27, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.004e-15, 8.348e-16, 6.944e-16, 5.776e-16, 4.804e-16, 3.996e-16, 3.323e-16, 2.764e-16, 2.299e-16, 1.912e-16, 1.591e-16, 1.323e-16, 1.101e-16]),
		CE(j=28, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.002e-15, 8.334e-16, 6.932e-16, 5.766e-16, 4.796e-16, 3.989e-16, 3.318e-16, 2.76e-16, 2.295e-16, 1.909e-16, 1.588e-16, 1.321e-16, 1.099e-16]),
		CE(j=29, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.984e-16, 8.304e-16, 6.907e-16, 5.745e-16, 4.779e-16, 3.975e-16, 3.306e-16, 2.75e-16, 2.287e-16, 1.902e-16, 1.582e-16, 1.316e-16, 1.095e-16]),
		CE(j=30, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.939e-16, 8.267e-16, 6.876e-16, 5.719e-16, 4.757e-16, 3.957e-16, 3.291e-16, 2.738e-16, 2.277e-16, 1.894e-16, 1.575e-16, 1.31e-16, 1.09e-16]),
		CE(j=31, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.925e-16, 8.255e-16, 6.866e-16, 5.711e-16, 4.75e-16, 3.951e-16, 3.286e-16, 2.734e-16, 2.274e-16, 1.891e-16, 1.573e-16, 1.308e-16, 1.088e-16]),
		CE(j=32, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.914e-16, 8.246e-16, 6.859e-16, 5.705e-16, 4.745e-16, 3.947e-16, 3.283e-16, 2.731e-16, 2.271e-16, 1.889e-16, 1.571e-16, 1.307e-16, 1.087e-16]),
		CE(j=33, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.702e-16, 8.07e-16, 6.712e-16, 5.583e-16, 4.644e-16, 3.863e-16, 3.213e-16, 2.672e-16, 2.223e-16, 1.849e-16, 1.538e-16, 1.279e-16, 1.064e-16]),
		CE(j=34, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.507e-16, 7.907e-16, 6.577e-16, 5.471e-16, 4.55e-16, 3.785e-16, 3.148e-16, 2.618e-16, 2.178e-16, 1.811e-16, 1.507e-16, 1.253e-16, 1.042e-16]),
		CE(j=35, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.979e-16, 7.468e-16, 6.212e-16, 5.167e-16, 4.297e-16, 3.574e-16, 2.973e-16, 2.473e-16, 2.057e-16, 1.711e-16, 1.423e-16, 1.184e-16, 9.845e-17]),
		CE(j=36, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.972e-16, 7.462e-16, 6.207e-16, 5.163e-16, 4.294e-16, 3.572e-16, 2.971e-16, 2.471e-16, 2.055e-16, 1.71e-16, 1.422e-16, 1.183e-16, 9.837e-17]),
		CE(j=37, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.968e-16, 7.459e-16, 6.204e-16, 5.161e-16, 4.292e-16, 3.57e-16, 2.97e-16, 2.47e-16, 2.054e-16, 1.709e-16, 1.421e-16, 1.182e-16, 9.833e-17]),
		CE(j=40, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.065e-16, 1.718e-16, 1.429e-16, 1.188e-16, 9.885e-17, 8.222e-17, 6.839e-17, 5.688e-17, 4.731e-17, 3.935e-17, 3.273e-17, 2.723e-17, 2.265e-17]),
		CE(j=41, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.064e-16, 1.716e-16, 1.428e-16, 1.187e-16, 9.877e-17, 8.215e-17, 6.833e-17, 5.684e-17, 4.727e-17, 3.932e-17, 3.271e-17, 2.72e-17, 2.263e-17]),
		CE(j=42, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.061e-16, 1.715e-16, 1.426e-16, 1.186e-16, 9.867e-17, 8.207e-17, 6.826e-17, 5.678e-17, 4.723e-17, 3.928e-17, 3.267e-17, 2.718e-17, 2.26e-17]),
		CE(j=43, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.89e-16, 1.572e-16, 1.307e-16, 1.087e-16, 9.045e-17, 7.523e-17, 6.257e-17, 5.205e-17, 4.329e-17, 3.601e-17, 2.995e-17, 2.491e-17, 2.072e-17]),
		CE(j=11, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.95e-09, 1.622e-09, 1.349e-09, 1.122e-09, 9.333e-10, 7.763e-10, 6.457e-10, 5.371e-10, 4.467e-10, 3.715e-10, 3.09e-10, 2.57e-10, 2.138e-10]),
		CE(j=12, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.141e-09, 9.494e-10, 7.897e-10, 6.568e-10, 5.463e-10, 4.544e-10, 3.78e-10, 3.144e-10, 2.615e-10, 2.175e-10, 1.809e-10, 1.505e-10, 1.252e-10]),
		CE(j=13, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.844e-15, 6.524e-15, 5.427e-15, 4.514e-15, 3.754e-15, 3.123e-15, 2.597e-15, 2.16e-15, 1.797e-15, 1.495e-15, 1.243e-15, 1.034e-15, 8.601e-16]),
		CE(j=14, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.985e-15, 4.978e-15, 4.141e-15, 3.444e-15, 2.865e-15, 2.383e-15, 1.982e-15, 1.648e-15, 1.371e-15, 1.14e-15, 9.486e-16, 7.89e-16, 6.562e-16]),
		CE(j=15, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.03e-16, 1.166e-16, 6.788e-17, 4.029e-17, 2.445e-17, 1.518e-17, 9.586e-18, 6.122e-18, 3.925e-18, 2.513e-18, 1.599e-18, 1.009e-18, 6.311e-19]),
		CE(j=16, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.442e-15, 8.281e-16, 4.822e-16, 2.861e-16, 1.737e-16, 1.078e-16, 6.809e-17, 4.349e-17, 2.789e-17, 1.786e-17, 1.137e-17, 7.175e-18, 4.488e-18]),
		CE(j=17, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.48e-15, 3.726e-15, 3.099e-15, 2.578e-15, 2.144e-15, 1.783e-15, 1.483e-15, 1.234e-15, 1.026e-15, 8.536e-16, 7.1e-16, 5.905e-16, 4.912e-16]),
		CE(j=18, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.867e-15, 3.217e-15, 2.676e-15, 2.225e-15, 1.851e-15, 1.54e-15, 1.281e-15, 1.065e-15, 8.86e-16, 7.369e-16, 6.129e-16, 5.098e-16, 4.241e-16]),
		CE(j=19, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.856e-15, 3.208e-15, 2.668e-15, 2.219e-15, 1.846e-15, 1.535e-15, 1.277e-15, 1.062e-15, 8.834e-16, 7.348e-16, 6.112e-16, 5.084e-16, 4.228e-16]),
		CE(j=20, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.281e-15, 2.452e-15, 1.423e-15, 8.408e-16, 5.087e-16, 3.156e-16, 2.001e-16, 1.287e-16, 8.339e-17, 5.4e-17, 3.478e-17, 2.22e-17, 1.403e-17]),
		CE(j=21, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.957e-15, 2.46e-15, 2.046e-15, 1.702e-15, 1.415e-15, 1.177e-15, 9.792e-16, 8.145e-16, 6.775e-16, 5.635e-16, 4.687e-16, 3.898e-16, 3.243e-16]),
		CE(j=22, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.304e-15, 1.916e-15, 1.594e-15, 1.326e-15, 1.103e-15, 9.173e-16, 7.63e-16, 6.346e-16, 5.278e-16, 4.39e-16, 3.652e-16, 3.037e-16, 2.526e-16]),
		CE(j=23, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.562e-15, 1.3e-15, 1.081e-15, 8.991e-16, 7.479e-16, 6.22e-16, 5.174e-16, 4.303e-16, 3.579e-16, 2.977e-16, 2.476e-16, 2.06e-16]),
		CE(j=24, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-15, 1.562e-15, 1.299e-15, 1.081e-15, 8.989e-16, 7.477e-16, 6.219e-16, 5.173e-16, 4.303e-16, 3.579e-16, 2.977e-16, 2.476e-16, 2.059e-16]),
		CE(j=25, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-15, 1.562e-15, 1.299e-15, 1.081e-15, 8.988e-16, 7.476e-16, 6.218e-16, 5.172e-16, 4.302e-16, 3.578e-16, 2.976e-16, 2.476e-16, 2.059e-16]),
		CE(j=26, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.35e-15, 1.123e-15, 9.341e-16, 7.769e-16, 6.462e-16, 5.375e-16, 4.471e-16, 3.719e-16, 3.093e-16, 2.573e-16, 2.14e-16, 1.78e-16, 1.48e-16]),
		CE(j=27, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.268e-15, 1.054e-15, 8.771e-16, 7.295e-16, 6.068e-16, 5.047e-16, 4.198e-16, 3.492e-16, 2.904e-16, 2.416e-16, 2.009e-16, 1.671e-16, 1.39e-16]),
		CE(j=28, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.265e-15, 1.052e-15, 8.754e-16, 7.281e-16, 6.056e-16, 5.037e-16, 4.19e-16, 3.485e-16, 2.899e-16, 2.411e-16, 2.005e-16, 1.668e-16, 1.387e-16]),
		CE(j=29, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.26e-15, 1.048e-15, 8.718e-16, 7.251e-16, 6.031e-16, 5.017e-16, 4.173e-16, 3.471e-16, 2.887e-16, 2.401e-16, 1.997e-16, 1.661e-16, 1.382e-16]),
		CE(j=30, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.254e-15, 1.043e-15, 8.673e-16, 7.214e-16, 6e-16, 4.991e-16, 4.151e-16, 3.453e-16, 2.872e-16, 2.389e-16, 1.987e-16, 1.653e-16, 1.375e-16]),
		CE(j=31, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.252e-15, 1.041e-15, 8.659e-16, 7.202e-16, 5.99e-16, 4.982e-16, 4.144e-16, 3.447e-16, 2.867e-16, 2.385e-16, 1.984e-16, 1.65e-16, 1.372e-16]),
		CE(j=32, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.25e-15, 1.04e-15, 8.648e-16, 7.193e-16, 5.983e-16, 4.976e-16, 4.139e-16, 3.443e-16, 2.864e-16, 2.382e-16, 1.981e-16, 1.648e-16, 1.371e-16]),
		CE(j=33, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.219e-15, 1.014e-15, 8.436e-16, 7.017e-16, 5.836e-16, 4.855e-16, 4.038e-16, 3.358e-16, 2.793e-16, 2.324e-16, 1.933e-16, 1.607e-16, 1.337e-16]),
		CE(j=34, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.191e-15, 9.909e-16, 8.242e-16, 6.855e-16, 5.702e-16, 4.743e-16, 3.945e-16, 3.281e-16, 2.729e-16, 2.27e-16, 1.888e-16, 1.57e-16, 1.306e-16]),
		CE(j=35, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.116e-15, 9.283e-16, 7.722e-16, 6.423e-16, 5.342e-16, 4.443e-16, 3.696e-16, 3.074e-16, 2.557e-16, 2.127e-16, 1.769e-16, 1.471e-16, 1.224e-16]),
		CE(j=36, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.115e-15, 9.275e-16, 7.715e-16, 6.417e-16, 5.337e-16, 4.439e-16, 3.693e-16, 3.071e-16, 2.555e-16, 2.125e-16, 1.767e-16, 1.47e-16, 1.223e-16]),
		CE(j=37, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.115e-15, 9.271e-16, 7.711e-16, 6.414e-16, 5.335e-16, 4.437e-16, 3.691e-16, 3.07e-16, 2.553e-16, 2.124e-16, 1.767e-16, 1.469e-16, 1.222e-16]),
		CE(j=40, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.254e-16, 1.875e-16, 1.559e-16, 1.297e-16, 1.079e-16, 8.972e-17, 7.463e-17, 6.207e-17, 5.163e-17, 4.294e-17, 3.572e-17, 2.971e-17, 2.471e-17]),
		CE(j=41, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.252e-16, 1.873e-16, 1.558e-16, 1.296e-16, 1.078e-16, 8.964e-17, 7.456e-17, 6.202e-17, 5.158e-17, 4.291e-17, 3.569e-17, 2.968e-17, 2.469e-17]),
		CE(j=42, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.249e-16, 1.871e-16, 1.556e-16, 1.294e-16, 1.077e-16, 8.955e-17, 7.448e-17, 6.195e-17, 5.153e-17, 4.286e-17, 3.565e-17, 2.965e-17, 2.466e-17]),
		CE(j=43, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.053e-16, 1.707e-16, 1.42e-16, 1.181e-16, 9.825e-17, 8.172e-17, 6.797e-17, 5.654e-17, 4.702e-17, 3.911e-17, 3.253e-17, 2.706e-17, 2.251e-17]),
		CE(j=12, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.011e-08, 8.41e-09, 6.995e-09, 5.819e-09, 4.84e-09, 4.025e-09, 3.348e-09, 2.785e-09, 2.316e-09, 1.927e-09, 1.603e-09, 1.333e-09, 1.109e-09]),
		CE(j=13, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.852e-15, 6.531e-15, 5.432e-15, 4.518e-15, 3.758e-15, 3.126e-15, 2.6e-15, 2.163e-15, 1.799e-15, 1.496e-15, 1.244e-15, 1.035e-15, 8.61e-16]),
		CE(j=14, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.176e-15, 6.753e-16, 3.933e-16, 2.334e-16, 1.417e-16, 8.793e-17, 5.554e-17, 3.546e-17, 2.274e-17, 1.455e-17, 9.258e-18, 5.842e-18, 3.653e-18]),
		CE(j=15, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.273e-16, 2.454e-16, 1.429e-16, 8.482e-17, 5.148e-17, 3.195e-17, 2.018e-17, 1.289e-17, 8.264e-18, 5.29e-18, 3.366e-18, 2.124e-18, 1.329e-18]),
		CE(j=16, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.894e-15, 4.902e-15, 4.077e-15, 3.391e-15, 2.821e-15, 2.346e-15, 1.952e-15, 1.623e-15, 1.35e-15, 1.123e-15, 9.341e-16, 7.769e-16, 6.462e-16]),
		CE(j=17, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.483e-15, 3.729e-15, 3.101e-15, 2.58e-15, 2.146e-15, 1.785e-15, 1.484e-15, 1.235e-15, 1.027e-15, 8.542e-16, 7.105e-16, 5.91e-16, 4.915e-16]),
		CE(j=18, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.442e-15, 1.399e-15, 8.116e-16, 4.797e-16, 2.902e-16, 1.801e-16, 1.142e-16, 7.344e-17, 4.756e-17, 3.079e-17, 1.982e-17, 1.265e-17, 7.995e-18]),
		CE(j=19, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.791e-15, 1.026e-15, 5.953e-16, 3.518e-16, 2.129e-16, 1.321e-16, 8.374e-17, 5.387e-17, 3.489e-17, 2.259e-17, 1.455e-17, 9.285e-18, 5.867e-18]),
		CE(j=20, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.149e-16, 6.58e-17, 3.817e-17, 2.256e-17, 1.365e-17, 8.468e-18, 5.369e-18, 3.454e-18, 2.237e-18, 1.449e-18, 9.331e-19, 5.957e-19, 3.765e-19]),
		CE(j=21, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.959e-15, 2.461e-15, 2.047e-15, 1.703e-15, 1.416e-15, 1.178e-15, 9.798e-16, 8.15e-16, 6.779e-16, 5.638e-16, 4.69e-16, 3.901e-16, 3.244e-16]),
		CE(j=22, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.305e-15, 1.917e-15, 1.595e-15, 1.327e-15, 1.103e-15, 9.177e-16, 7.633e-16, 6.349e-16, 5.281e-16, 4.393e-16, 3.654e-16, 3.039e-16, 2.528e-16]),
		CE(j=23, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.563e-15, 1.3e-15, 1.081e-15, 8.995e-16, 7.482e-16, 6.223e-16, 5.176e-16, 4.305e-16, 3.581e-16, 2.979e-16, 2.477e-16, 2.061e-16]),
		CE(j=24, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.563e-15, 1.3e-15, 1.081e-15, 8.993e-16, 7.48e-16, 6.222e-16, 5.175e-16, 4.305e-16, 3.58e-16, 2.978e-16, 2.477e-16, 2.06e-16]),
		CE(j=25, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.563e-15, 1.3e-15, 1.081e-15, 8.992e-16, 7.479e-16, 6.221e-16, 5.175e-16, 4.304e-16, 3.58e-16, 2.978e-16, 2.477e-16, 2.06e-16]),
		CE(j=26, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.351e-15, 1.123e-15, 9.344e-16, 7.772e-16, 6.465e-16, 5.377e-16, 4.472e-16, 3.72e-16, 3.094e-16, 2.574e-16, 2.141e-16, 1.781e-16, 1.481e-16]),
		CE(j=27, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.268e-15, 1.055e-15, 8.774e-16, 7.298e-16, 6.07e-16, 5.049e-16, 4.199e-16, 3.493e-16, 2.905e-16, 2.417e-16, 2.01e-16, 1.672e-16, 1.391e-16]),
		CE(j=28, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.266e-15, 1.053e-15, 8.757e-16, 7.283e-16, 6.058e-16, 5.039e-16, 4.191e-16, 3.486e-16, 2.9e-16, 2.412e-16, 2.006e-16, 1.669e-16, 1.388e-16]),
		CE(j=29, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.261e-15, 1.048e-15, 8.721e-16, 7.254e-16, 6.033e-16, 5.018e-16, 4.174e-16, 3.472e-16, 2.888e-16, 2.402e-16, 1.998e-16, 1.662e-16, 1.382e-16]),
		CE(j=30, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.254e-15, 1.043e-15, 8.676e-16, 7.216e-16, 6.002e-16, 4.993e-16, 4.153e-16, 3.454e-16, 2.873e-16, 2.39e-16, 1.988e-16, 1.653e-16, 1.375e-16]),
		CE(j=31, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.252e-15, 1.041e-15, 8.662e-16, 7.204e-16, 5.992e-16, 4.984e-16, 4.146e-16, 3.448e-16, 2.868e-16, 2.386e-16, 1.984e-16, 1.65e-16, 1.373e-16]),
		CE(j=32, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.25e-15, 1.04e-15, 8.651e-16, 7.195e-16, 5.985e-16, 4.978e-16, 4.14e-16, 3.444e-16, 2.865e-16, 2.383e-16, 1.982e-16, 1.648e-16, 1.371e-16]),
		CE(j=33, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.22e-15, 1.015e-15, 8.439e-16, 7.019e-16, 5.838e-16, 4.856e-16, 4.039e-16, 3.36e-16, 2.794e-16, 2.324e-16, 1.933e-16, 1.608e-16, 1.337e-16]),
		CE(j=34, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.192e-15, 9.912e-16, 8.245e-16, 6.858e-16, 5.704e-16, 4.744e-16, 3.946e-16, 3.282e-16, 2.73e-16, 2.271e-16, 1.889e-16, 1.571e-16, 1.307e-16]),
		CE(j=35, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.116e-15, 9.286e-16, 7.724e-16, 6.425e-16, 5.344e-16, 4.445e-16, 3.697e-16, 3.075e-16, 2.558e-16, 2.127e-16, 1.769e-16, 1.472e-16, 1.224e-16]),
		CE(j=36, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.116e-15, 9.278e-16, 7.717e-16, 6.419e-16, 5.339e-16, 4.441e-16, 3.694e-16, 3.072e-16, 2.555e-16, 2.126e-16, 1.768e-16, 1.471e-16, 1.223e-16]),
		CE(j=37, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.115e-15, 9.274e-16, 7.714e-16, 6.416e-16, 5.337e-16, 4.439e-16, 3.692e-16, 3.071e-16, 2.554e-16, 2.125e-16, 1.767e-16, 1.47e-16, 1.223e-16]),
		CE(j=40, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.254e-16, 1.875e-16, 1.559e-16, 1.297e-16, 1.079e-16, 8.973e-17, 7.464e-17, 6.208e-17, 5.164e-17, 4.295e-17, 3.572e-17, 2.971e-17, 2.471e-17]),
		CE(j=41, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.252e-16, 1.873e-16, 1.558e-16, 1.296e-16, 1.078e-16, 8.966e-17, 7.457e-17, 6.203e-17, 5.159e-17, 4.291e-17, 3.569e-17, 2.969e-17, 2.469e-17]),
		CE(j=42, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.25e-16, 1.871e-16, 1.556e-16, 1.295e-16, 1.077e-16, 8.956e-17, 7.449e-17, 6.196e-17, 5.154e-17, 4.287e-17, 3.565e-17, 2.966e-17, 2.467e-17]),
		CE(j=43, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.053e-16, 1.708e-16, 1.42e-16, 1.181e-16, 9.826e-17, 8.173e-17, 6.798e-17, 5.654e-17, 4.703e-17, 3.912e-17, 3.254e-17, 2.706e-17, 2.251e-17]),
		CE(j=13, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.855e-15, 6.534e-15, 5.434e-15, 4.52e-15, 3.76e-15, 3.127e-15, 2.601e-15, 2.163e-15, 1.799e-15, 1.497e-15, 1.245e-15, 1.036e-15, 8.613e-16]),
		CE(j=14, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.593e-16, 1.489e-16, 8.674e-17, 5.148e-17, 3.125e-17, 1.939e-17, 1.225e-17, 7.822e-18, 5.015e-18, 3.209e-18, 2.042e-18, 1.288e-18, 8.056e-19]),
		CE(j=15, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.083e-15, 6.219e-16, 3.622e-16, 2.15e-16, 1.305e-16, 8.098e-17, 5.115e-17, 3.266e-17, 2.094e-17, 1.341e-17, 8.531e-18, 5.384e-18, 3.367e-18]),
		CE(j=16, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.801e-16, 1.609e-16, 9.368e-17, 5.559e-17, 3.374e-17, 2.094e-17, 1.323e-17, 8.449e-18, 5.419e-18, 3.469e-18, 2.208e-18, 1.394e-18, 8.719e-19]),
		CE(j=17, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.484e-15, 3.73e-15, 3.102e-15, 2.58e-15, 2.146e-15, 1.785e-15, 1.485e-15, 1.235e-15, 1.027e-15, 8.544e-16, 7.107e-16, 5.911e-16, 4.917e-16]),
		CE(j=18, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.871e-15, 3.22e-15, 2.678e-15, 2.228e-15, 1.853e-15, 1.541e-15, 1.282e-15, 1.066e-15, 8.868e-16, 7.376e-16, 6.135e-16, 5.103e-16, 4.244e-16]),
		CE(j=19, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.271e-15, 1.874e-15, 1.087e-15, 6.425e-16, 3.887e-16, 2.412e-16, 1.529e-16, 9.837e-17, 6.371e-17, 4.125e-17, 2.656e-17, 1.695e-17, 1.071e-17]),
		CE(j=20, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.047e-15, 5.999e-16, 3.48e-16, 2.057e-16, 1.244e-16, 7.721e-17, 4.895e-17, 3.15e-17, 2.04e-17, 1.321e-17, 8.508e-18, 5.431e-18, 3.432e-18]),
		CE(j=21, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.96e-15, 2.462e-15, 2.048e-15, 1.703e-15, 1.417e-15, 1.178e-15, 9.8e-16, 8.151e-16, 6.78e-16, 5.639e-16, 4.691e-16, 3.902e-16, 3.245e-16]),
		CE(j=22, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.306e-15, 1.918e-15, 1.595e-15, 1.327e-15, 1.104e-15, 9.179e-16, 7.635e-16, 6.35e-16, 5.282e-16, 4.393e-16, 3.654e-16, 3.039e-16, 2.528e-16]),
		CE(j=23, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.88e-15, 1.563e-15, 1.3e-15, 1.082e-15, 8.997e-16, 7.483e-16, 6.224e-16, 5.177e-16, 4.306e-16, 3.582e-16, 2.979e-16, 2.478e-16, 2.061e-16]),
		CE(j=24, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.563e-15, 1.3e-15, 1.081e-15, 8.995e-16, 7.482e-16, 6.223e-16, 5.176e-16, 4.305e-16, 3.581e-16, 2.978e-16, 2.477e-16, 2.061e-16]),
		CE(j=25, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.879e-15, 1.563e-15, 1.3e-15, 1.081e-15, 8.994e-16, 7.481e-16, 6.222e-16, 5.175e-16, 4.305e-16, 3.58e-16, 2.978e-16, 2.477e-16, 2.06e-16]),
		CE(j=26, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.351e-15, 1.124e-15, 9.346e-16, 7.773e-16, 6.466e-16, 5.378e-16, 4.473e-16, 3.721e-16, 3.095e-16, 2.574e-16, 2.141e-16, 1.781e-16, 1.481e-16]),
		CE(j=27, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.268e-15, 1.055e-15, 8.775e-16, 7.299e-16, 6.071e-16, 5.049e-16, 4.2e-16, 3.493e-16, 2.906e-16, 2.417e-16, 2.01e-16, 1.672e-16, 1.391e-16]),
		CE(j=28, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.266e-15, 1.053e-15, 8.758e-16, 7.284e-16, 6.059e-16, 5.04e-16, 4.192e-16, 3.487e-16, 2.9e-16, 2.412e-16, 2.006e-16, 1.669e-16, 1.388e-16]),
		CE(j=29, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.261e-15, 1.049e-15, 8.722e-16, 7.255e-16, 6.034e-16, 5.019e-16, 4.175e-16, 3.472e-16, 2.888e-16, 2.402e-16, 1.998e-16, 1.662e-16, 1.382e-16]),
		CE(j=30, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.254e-15, 1.043e-15, 8.677e-16, 7.217e-16, 6.003e-16, 4.993e-16, 4.153e-16, 3.454e-16, 2.873e-16, 2.39e-16, 1.988e-16, 1.653e-16, 1.375e-16]),
		CE(j=31, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.252e-15, 1.041e-15, 8.663e-16, 7.205e-16, 5.993e-16, 4.985e-16, 4.146e-16, 3.449e-16, 2.868e-16, 2.386e-16, 1.985e-16, 1.651e-16, 1.373e-16]),
		CE(j=32, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.251e-15, 1.04e-15, 8.652e-16, 7.196e-16, 5.986e-16, 4.979e-16, 4.141e-16, 3.444e-16, 2.865e-16, 2.383e-16, 1.982e-16, 1.649e-16, 1.371e-16]),
		CE(j=33, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.22e-15, 1.015e-15, 8.44e-16, 7.02e-16, 5.839e-16, 4.857e-16, 4.04e-16, 3.36e-16, 2.795e-16, 2.325e-16, 1.934e-16, 1.608e-16, 1.338e-16]),
		CE(j=34, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.192e-15, 9.914e-16, 8.246e-16, 6.859e-16, 5.705e-16, 4.745e-16, 3.947e-16, 3.283e-16, 2.73e-16, 2.271e-16, 1.889e-16, 1.571e-16, 1.307e-16]),
		CE(j=35, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.117e-15, 9.288e-16, 7.725e-16, 6.425e-16, 5.344e-16, 4.445e-16, 3.697e-16, 3.075e-16, 2.558e-16, 2.128e-16, 1.77e-16, 1.472e-16, 1.224e-16]),
		CE(j=36, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.116e-15, 9.279e-16, 7.718e-16, 6.42e-16, 5.34e-16, 4.441e-16, 3.694e-16, 3.073e-16, 2.556e-16, 2.126e-16, 1.768e-16, 1.471e-16, 1.223e-16]),
		CE(j=37, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.115e-15, 9.275e-16, 7.715e-16, 6.417e-16, 5.337e-16, 4.439e-16, 3.692e-16, 3.071e-16, 2.555e-16, 2.125e-16, 1.767e-16, 1.47e-16, 1.223e-16]),
		CE(j=40, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.254e-16, 1.875e-16, 1.559e-16, 1.297e-16, 1.079e-16, 8.974e-17, 7.464e-17, 6.208e-17, 5.164e-17, 4.295e-17, 3.573e-17, 2.972e-17, 2.472e-17]),
		CE(j=41, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.252e-16, 1.873e-16, 1.558e-16, 1.296e-16, 1.078e-16, 8.966e-17, 7.458e-17, 6.203e-17, 5.159e-17, 4.291e-17, 3.569e-17, 2.969e-17, 2.469e-17]),
		CE(j=42, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.25e-16, 1.871e-16, 1.556e-16, 1.295e-16, 1.077e-16, 8.957e-17, 7.45e-17, 6.196e-17, 5.154e-17, 4.287e-17, 3.566e-17, 2.966e-17, 2.467e-17]),
		CE(j=43, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.053e-16, 1.708e-16, 1.42e-16, 1.181e-16, 9.826e-17, 8.173e-17, 6.798e-17, 5.654e-17, 4.703e-17, 3.912e-17, 3.254e-17, 2.706e-17, 2.251e-17]),
		CE(j=14, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.471e-13, 1.223e-13, 1.018e-13, 8.463e-14, 7.039e-14, 5.855e-14, 4.87e-14, 4.051e-14, 3.369e-14, 2.802e-14, 2.331e-14, 1.939e-14, 1.613e-14]),
		CE(j=15, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.41e-13, 1.173e-13, 9.755e-14, 8.114e-14, 6.749e-14, 5.613e-14, 4.669e-14, 3.884e-14, 3.23e-14, 2.687e-14, 2.235e-14, 1.859e-14, 1.546e-14]),
		CE(j=16, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.322e-13, 1.1e-13, 9.147e-14, 7.608e-14, 6.328e-14, 5.263e-14, 4.378e-14, 3.641e-14, 3.029e-14, 2.519e-14, 2.095e-14, 1.743e-14, 1.45e-14]),
		CE(j=17, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.722e-14, 3.096e-14, 2.575e-14, 2.142e-14, 1.782e-14, 1.482e-14, 1.233e-14, 1.025e-14, 8.527e-15, 7.093e-15, 5.9e-15, 4.907e-15, 4.081e-15]),
		CE(j=18, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.328e-14, 1.936e-14, 1.61e-14, 1.339e-14, 1.114e-14, 9.267e-15, 7.708e-15, 6.411e-15, 5.333e-15, 4.435e-15, 3.689e-15, 3.069e-15, 2.552e-15]),
		CE(j=19, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.308e-14, 1.92e-14, 1.597e-14, 1.328e-14, 1.105e-14, 9.19e-15, 7.644e-15, 6.358e-15, 5.288e-15, 4.399e-15, 3.659e-15, 3.043e-15, 2.531e-15]),
		CE(j=20, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.277e-14, 1.894e-14, 1.575e-14, 1.31e-14, 1.09e-14, 9.065e-15, 7.54e-15, 6.272e-15, 5.217e-15, 4.339e-15, 3.609e-15, 3.002e-15, 2.497e-15]),
		CE(j=21, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.173e-14, 9.753e-15, 8.112e-15, 6.747e-15, 5.612e-15, 4.668e-15, 3.883e-15, 3.229e-15, 2.686e-15, 2.234e-15, 1.858e-15, 1.546e-15, 1.286e-15]),
		CE(j=22, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.964e-15, 5.792e-15, 4.818e-15, 4.007e-15, 3.333e-15, 2.772e-15, 2.306e-15, 1.918e-15, 1.595e-15, 1.327e-15, 1.104e-15, 9.18e-16, 7.636e-16]),
		CE(j=23, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.789e-15, 3.983e-15, 3.313e-15, 2.756e-15, 2.292e-15, 1.907e-15, 1.586e-15, 1.319e-15, 1.097e-15, 9.125e-16, 7.59e-16, 6.313e-16, 5.251e-16]),
		CE(j=24, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.787e-15, 3.982e-15, 3.312e-15, 2.755e-15, 2.291e-15, 1.906e-15, 1.585e-15, 1.319e-15, 1.097e-15, 9.122e-16, 7.587e-16, 6.311e-16, 5.249e-16]),
		CE(j=25, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.786e-15, 3.981e-15, 3.311e-15, 2.754e-15, 2.291e-15, 1.905e-15, 1.585e-15, 1.318e-15, 1.096e-15, 9.12e-16, 7.586e-16, 6.31e-16, 5.248e-16]),
		CE(j=26, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.168e-13, 6.947e-14, 4.28e-14, 2.772e-14, 1.904e-14, 1.369e-14, 9.852e-15, 7.083e-15, 4.862e-15, 3.348e-15, 2.265e-15, 1.48e-15, 9.546e-16]),
		CE(j=27, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.535e-15, 2.108e-15, 1.754e-15, 1.459e-15, 1.213e-15, 1.009e-15, 8.394e-16, 6.982e-16, 5.807e-16, 4.83e-16, 4.018e-16, 3.342e-16, 2.779e-16]),
		CE(j=28, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.527e-15, 2.102e-15, 1.749e-15, 1.454e-15, 1.21e-15, 1.006e-15, 8.369e-16, 6.961e-16, 5.79e-16, 4.816e-16, 4.006e-16, 3.332e-16, 2.771e-16]),
		CE(j=29, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.512e-15, 2.089e-15, 1.738e-15, 1.445e-15, 1.202e-15, 1e-15, 8.318e-16, 6.918e-16, 5.754e-16, 4.786e-16, 3.981e-16, 3.311e-16, 2.754e-16]),
		CE(j=30, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.941e-17, 2.258e-17, 1.311e-17, 7.777e-18, 4.743e-18, 2.986e-18, 1.937e-18, 1.283e-18, 8.578e-19, 5.736e-19, 3.808e-19, 2.499e-19, 1.618e-19]),
		CE(j=31, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.382e-17, 2.511e-17, 1.458e-17, 8.645e-18, 5.272e-18, 3.32e-18, 2.153e-18, 1.426e-18, 9.537e-19, 6.378e-19, 4.235e-19, 2.779e-19, 1.8e-19]),
		CE(j=32, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.481e-15, 2.064e-15, 1.717e-15, 1.428e-15, 1.188e-15, 9.879e-16, 8.217e-16, 6.835e-16, 5.685e-16, 4.728e-16, 3.933e-16, 3.271e-16, 2.721e-16]),
		CE(j=33, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.391e-15, 1.989e-15, 1.654e-15, 1.376e-15, 1.144e-15, 9.519e-16, 7.918e-16, 6.586e-16, 5.478e-16, 4.556e-16, 3.79e-16, 3.152e-16, 2.622e-16]),
		CE(j=34, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.025e-14, 4.712e-14, 2.822e-14, 1.729e-14, 1.073e-14, 6.853e-15, 4.529e-15, 3.013e-15, 2.02e-15, 1.355e-15, 9.023e-16, 5.939e-16, 3.856e-16]),
		CE(j=35, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.099e-15, 1.746e-15, 1.452e-15, 1.208e-15, 1.004e-15, 8.355e-16, 6.949e-16, 5.78e-16, 4.808e-16, 3.999e-16, 3.326e-16, 2.766e-16, 2.301e-16]),
		CE(j=36, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.096e-15, 1.743e-15, 1.45e-15, 1.206e-15, 1.003e-15, 8.344e-16, 6.94e-16, 5.773e-16, 4.801e-16, 3.994e-16, 3.322e-16, 2.763e-16, 2.298e-16]),
		CE(j=37, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.094e-15, 1.742e-15, 1.449e-15, 1.205e-15, 1.002e-15, 8.338e-16, 6.935e-16, 5.769e-16, 4.798e-16, 3.991e-16, 3.319e-16, 2.761e-16, 2.296e-16]),
		CE(j=40, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.798e-16, 2.328e-16, 1.936e-16, 1.61e-16, 1.339e-16, 1.114e-16, 9.266e-17, 7.707e-17, 6.411e-17, 5.332e-17, 4.435e-17, 3.689e-17, 3.068e-17]),
		CE(j=41, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.796e-16, 2.325e-16, 1.934e-16, 1.609e-16, 1.338e-16, 1.113e-16, 9.257e-17, 7.7e-17, 6.404e-17, 5.327e-17, 4.431e-17, 3.685e-17, 3.065e-17]),
		CE(j=42, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.792e-16, 2.322e-16, 1.932e-16, 1.607e-16, 1.336e-16, 1.112e-16, 9.246e-17, 7.69e-17, 6.397e-17, 5.32e-17, 4.425e-17, 3.681e-17, 3.062e-17]),
		CE(j=43, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.517e-16, 2.094e-16, 1.741e-16, 1.448e-16, 1.205e-16, 1.002e-16, 8.335e-17, 6.933e-17, 5.767e-17, 4.796e-17, 3.989e-17, 3.318e-17, 2.76e-17]),
		CE(j=15, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.027e-11, 5.845e-11, 4.862e-11, 4.044e-11, 3.364e-11, 2.798e-11, 2.327e-11, 1.936e-11, 1.61e-11, 1.339e-11, 1.114e-11, 9.264e-12, 7.705e-12]),
		CE(j=16, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.434e-11, 1.193e-11, 9.921e-12, 8.252e-12, 6.863e-12, 5.709e-12, 4.748e-12, 3.949e-12, 3.285e-12, 2.732e-12, 2.273e-12, 1.89e-12, 1.572e-12]),
		CE(j=17, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.901e-14, 8.235e-14, 6.849e-14, 5.697e-14, 4.739e-14, 3.941e-14, 3.278e-14, 2.727e-14, 2.268e-14, 1.887e-14, 1.569e-14, 1.305e-14, 1.086e-14]),
		CE(j=18, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.605e-14, 3.83e-14, 3.186e-14, 2.65e-14, 2.204e-14, 1.833e-14, 1.525e-14, 1.268e-14, 1.055e-14, 8.775e-15, 7.299e-15, 6.071e-15, 5.049e-15]),
		CE(j=19, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.548e-14, 3.783e-14, 3.146e-14, 2.617e-14, 2.177e-14, 1.811e-14, 1.506e-14, 1.253e-14, 1.042e-14, 8.666e-15, 7.208e-15, 5.996e-15, 4.987e-15]),
		CE(j=20, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.456e-14, 3.706e-14, 3.083e-14, 2.564e-14, 2.133e-14, 1.774e-14, 1.476e-14, 1.227e-14, 1.021e-14, 8.491e-15, 7.063e-15, 5.874e-15, 4.886e-15]),
		CE(j=21, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.787e-14, 1.487e-14, 1.237e-14, 1.028e-14, 8.555e-15, 7.115e-15, 5.918e-15, 4.923e-15, 4.095e-15, 3.406e-15, 2.833e-15, 2.356e-15, 1.96e-15]),
		CE(j=22, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.385e-15, 7.806e-15, 6.493e-15, 5.4e-15, 4.492e-15, 3.736e-15, 3.108e-15, 2.585e-15, 2.15e-15, 1.788e-15, 1.487e-15, 1.237e-15, 1.029e-15]),
		CE(j=23, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.381e-15, 2.527e-15, 1.482e-15, 8.887e-16, 5.473e-16, 3.458e-16, 2.227e-16, 1.45e-16, 9.47e-17, 6.16e-17, 3.974e-17, 2.537e-17, 1.602e-17]),
		CE(j=24, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.456e-16, 1.416e-16, 8.306e-17, 4.982e-17, 3.068e-17, 1.938e-17, 1.248e-17, 8.13e-18, 5.308e-18, 3.453e-18, 2.228e-18, 1.422e-18, 8.981e-19]),
		CE(j=25, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.301e-15, 3.634e-15, 2.131e-15, 1.278e-15, 7.872e-16, 4.973e-16, 3.203e-16, 2.086e-16, 1.362e-16, 8.86e-17, 5.716e-17, 3.65e-17, 2.304e-17]),
		CE(j=26, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.357e-17, 2.502e-17, 1.459e-17, 8.692e-18, 5.33e-18, 3.37e-18, 2.189e-18, 1.446e-18, 9.624e-19, 6.393e-19, 4.212e-19, 2.743e-19, 1.764e-19]),
		CE(j=27, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.284e-13, 7.657e-14, 4.742e-14, 3.096e-14, 2.151e-14, 1.573e-14, 1.166e-14, 8.627e-15, 5.993e-15, 4.132e-15, 2.84e-15, 1.859e-15, 1.199e-15]),
		CE(j=28, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.956e-15, 2.459e-15, 2.045e-15, 1.701e-15, 1.415e-15, 1.177e-15, 9.788e-16, 8.141e-16, 6.772e-16, 5.632e-16, 4.685e-16, 3.897e-16, 3.241e-16]),
		CE(j=29, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.936e-15, 2.442e-15, 2.031e-15, 1.69e-15, 1.405e-15, 1.169e-15, 9.722e-16, 8.086e-16, 6.726e-16, 5.594e-16, 4.653e-16, 3.87e-16, 3.219e-16]),
		CE(j=30, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.207e-14, 1.84e-14, 1.072e-14, 6.377e-15, 3.905e-15, 2.469e-15, 1.606e-15, 1.064e-15, 7.113e-16, 4.747e-16, 3.143e-16, 2.057e-16, 1.328e-16]),
		CE(j=31, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.475e-16, 3.716e-16, 2.163e-16, 1.287e-16, 7.883e-17, 4.984e-17, 3.242e-17, 2.149e-17, 1.436e-17, 9.585e-18, 6.347e-18, 4.154e-18, 2.682e-18]),
		CE(j=32, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.897e-15, 2.41e-15, 2.004e-15, 1.667e-15, 1.387e-15, 1.153e-15, 9.593e-16, 7.979e-16, 6.637e-16, 5.52e-16, 4.592e-16, 3.819e-16, 3.177e-16]),
		CE(j=33, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.782e-15, 2.314e-15, 1.924e-15, 1.601e-15, 1.331e-15, 1.107e-15, 9.211e-16, 7.661e-16, 6.372e-16, 5.3e-16, 4.409e-16, 3.667e-16, 3.05e-16]),
		CE(j=34, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.326e-16, 2.481e-16, 1.443e-16, 8.581e-17, 5.251e-17, 3.319e-17, 2.161e-17, 1.435e-17, 9.619e-18, 6.44e-18, 4.279e-18, 2.809e-18, 1.819e-18]),
		CE(j=35, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.413e-15, 2.007e-15, 1.669e-15, 1.388e-15, 1.155e-15, 9.605e-16, 7.989e-16, 6.645e-16, 5.527e-16, 4.597e-16, 3.824e-16, 3.181e-16, 2.646e-16]),
		CE(j=36, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.154e-17, 1.808e-17, 1.051e-17, 6.24e-18, 3.814e-18, 2.41e-18, 1.571e-18, 1.046e-18, 7.036e-19, 4.731e-19, 3.157e-19, 2.081e-19, 1.353e-19]),
		CE(j=37, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.408e-15, 2.003e-15, 1.666e-15, 1.385e-15, 1.152e-15, 9.585e-16, 7.972e-16, 6.631e-16, 5.515e-16, 4.588e-16, 3.816e-16, 3.174e-16, 2.64e-16]),
		CE(j=40, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.915e-16, 2.425e-16, 2.017e-16, 1.677e-16, 1.395e-16, 1.161e-16, 9.653e-17, 8.029e-17, 6.678e-17, 5.555e-17, 4.62e-17, 3.843e-17, 3.196e-17]),
		CE(j=41, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.912e-16, 2.422e-16, 2.015e-16, 1.676e-16, 1.394e-16, 1.159e-16, 9.643e-17, 8.02e-17, 6.671e-17, 5.549e-17, 4.615e-17, 3.839e-17, 3.193e-17]),
		CE(j=42, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.908e-16, 2.419e-16, 2.012e-16, 1.674e-16, 1.392e-16, 1.158e-16, 9.631e-17, 8.011e-17, 6.663e-17, 5.542e-17, 4.61e-17, 3.834e-17, 3.189e-17]),
		CE(j=43, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.616e-16, 2.175e-16, 1.809e-16, 1.505e-16, 1.252e-16, 1.041e-16, 8.661e-17, 7.204e-17, 5.992e-17, 4.984e-17, 4.145e-17, 3.448e-17, 2.868e-17]),
		CE(j=16, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.274e-11, 2.723e-11, 2.265e-11, 1.884e-11, 1.567e-11, 1.304e-11, 1.084e-11, 9.018e-12, 7.501e-12, 6.239e-12, 5.189e-12, 4.316e-12, 3.59e-12]),
		CE(j=17, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.024e-13, 8.52e-14, 7.087e-14, 5.895e-14, 4.903e-14, 4.078e-14, 3.392e-14, 2.821e-14, 2.347e-14, 1.952e-14, 1.624e-14, 1.35e-14, 1.123e-14]),
		CE(j=18, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.705e-14, 3.914e-14, 3.255e-14, 2.708e-14, 2.252e-14, 1.873e-14, 1.558e-14, 1.296e-14, 1.078e-14, 8.966e-15, 7.458e-15, 6.203e-15, 5.159e-15]),
		CE(j=19, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.646e-14, 3.865e-14, 3.214e-14, 2.674e-14, 2.224e-14, 1.85e-14, 1.539e-14, 1.28e-14, 1.064e-14, 8.853e-15, 7.364e-15, 6.125e-15, 5.095e-15]),
		CE(j=20, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.551e-14, 3.786e-14, 3.149e-14, 2.619e-14, 2.178e-14, 1.812e-14, 1.507e-14, 1.254e-14, 1.043e-14, 8.672e-15, 7.213e-15, 6e-15, 4.99e-15]),
		CE(j=21, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.809e-14, 1.505e-14, 1.252e-14, 1.041e-14, 8.66e-15, 7.203e-15, 5.991e-15, 4.983e-15, 4.145e-15, 3.448e-15, 2.868e-15, 2.385e-15, 1.984e-15]),
		CE(j=22, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.463e-15, 7.871e-15, 6.547e-15, 5.446e-15, 4.529e-15, 3.767e-15, 3.134e-15, 2.606e-15, 2.168e-15, 1.803e-15, 1.5e-15, 1.248e-15, 1.038e-15]),
		CE(j=23, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.486e-15, 4.895e-15, 2.871e-15, 1.722e-15, 1.061e-15, 6.7e-16, 4.316e-16, 2.81e-16, 1.835e-16, 1.193e-16, 7.698e-17, 4.914e-17, 3.102e-17]),
		CE(j=24, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.415e-15, 1.393e-15, 8.169e-16, 4.9e-16, 3.018e-16, 1.907e-16, 1.228e-16, 7.998e-17, 5.221e-17, 3.396e-17, 2.191e-17, 1.399e-17, 8.829e-18]),
		CE(j=25, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.089e-15, 5.065e-15, 4.212e-15, 3.504e-15, 2.914e-15, 2.424e-15, 2.016e-15, 1.677e-15, 1.395e-15, 1.16e-15, 9.65e-16, 8.027e-16, 6.676e-16]),
		CE(j=26, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.881e-16, 1.08e-16, 6.297e-17, 3.752e-17, 2.301e-17, 1.455e-17, 9.451e-18, 6.246e-18, 4.156e-18, 2.76e-18, 1.819e-18, 1.184e-18, 7.613e-19]),
		CE(j=27, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.225e-14, 1.277e-14, 7.438e-15, 4.427e-15, 2.712e-15, 1.715e-15, 1.115e-15, 7.389e-16, 4.934e-16, 3.29e-16, 2.177e-16, 1.423e-16, 9.182e-17]),
		CE(j=28, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.221e-13, 7.277e-14, 4.501e-14, 2.932e-14, 2.028e-14, 1.47e-14, 1.069e-14, 7.767e-15, 5.344e-15, 3.686e-15, 2.505e-15, 1.638e-15, 1.057e-15]),
		CE(j=29, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.948e-15, 2.452e-15, 2.04e-15, 1.697e-15, 1.411e-15, 1.174e-15, 9.763e-16, 8.12e-16, 6.754e-16, 5.618e-16, 4.673e-16, 3.887e-16, 3.233e-16]),
		CE(j=30, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.983e-15, 4.008e-15, 2.334e-15, 1.389e-15, 8.506e-16, 5.378e-16, 3.498e-16, 2.319e-16, 1.55e-16, 1.034e-16, 6.846e-17, 4.479e-17, 2.891e-17]),
		CE(j=31, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.969e-14, 2.277e-14, 1.326e-14, 7.891e-15, 4.833e-15, 3.056e-15, 1.988e-15, 1.318e-15, 8.807e-16, 5.878e-16, 3.892e-16, 2.547e-16, 1.644e-16]),
		CE(j=32, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.22e-16, 2.996e-16, 1.744e-16, 1.038e-16, 6.357e-17, 4.019e-17, 2.614e-17, 1.733e-17, 1.158e-17, 7.732e-18, 5.12e-18, 3.351e-18, 2.163e-18]),
		CE(j=33, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.414e-15, 8.11e-16, 4.72e-16, 2.808e-16, 1.719e-16, 1.087e-16, 7.072e-17, 4.693e-17, 3.141e-17, 2.1e-17, 1.393e-17, 9.129e-18, 5.902e-18]),
		CE(j=34, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.689e-15, 2.236e-15, 1.86e-15, 1.547e-15, 1.287e-15, 1.07e-15, 8.903e-16, 7.406e-16, 6.16e-16, 5.123e-16, 4.261e-16, 3.545e-16, 2.948e-16]),
		CE(j=35, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.582e-17, 2.053e-17, 1.193e-17, 7.086e-18, 4.332e-18, 2.738e-18, 1.784e-18, 1.188e-18, 7.993e-19, 5.374e-19, 3.586e-19, 2.364e-19, 1.536e-19]),
		CE(j=36, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.222e-17, 1.847e-17, 1.073e-17, 6.374e-18, 3.896e-18, 2.463e-18, 1.605e-18, 1.069e-18, 7.19e-19, 4.834e-19, 3.226e-19, 2.126e-19, 1.382e-19]),
		CE(j=37, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.417e-15, 2.01e-15, 1.672e-15, 1.391e-15, 1.157e-15, 9.62e-16, 8.002e-16, 6.656e-16, 5.536e-16, 4.605e-16, 3.83e-16, 3.186e-16, 2.65e-16]),
		CE(j=40, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.918e-16, 2.427e-16, 2.019e-16, 1.679e-16, 1.397e-16, 1.162e-16, 9.663e-17, 8.037e-17, 6.685e-17, 5.56e-17, 4.625e-17, 3.847e-17, 3.2e-17]),
		CE(j=41, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.915e-16, 2.425e-16, 2.017e-16, 1.677e-16, 1.395e-16, 1.161e-16, 9.653e-17, 8.029e-17, 6.678e-17, 5.555e-17, 4.62e-17, 3.843e-17, 3.196e-17]),
		CE(j=42, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.912e-16, 2.422e-16, 2.014e-16, 1.675e-16, 1.394e-16, 1.159e-16, 9.641e-17, 8.019e-17, 6.67e-17, 5.548e-17, 4.614e-17, 3.838e-17, 3.192e-17]),
		CE(j=43, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.618e-16, 2.178e-16, 1.811e-16, 1.507e-16, 1.253e-16, 1.042e-16, 8.669e-17, 7.211e-17, 5.998e-17, 4.989e-17, 4.149e-17, 3.451e-17, 2.871e-17]),
		CE(j=17, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.082e-13, 9.003e-14, 7.489e-14, 6.229e-14, 5.181e-14, 4.309e-14, 3.584e-14, 2.981e-14, 2.48e-14, 2.063e-14, 1.716e-14, 1.427e-14, 1.187e-14]),
		CE(j=18, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.871e-14, 4.051e-14, 3.37e-14, 2.803e-14, 2.331e-14, 1.939e-14, 1.613e-14, 1.341e-14, 1.116e-14, 9.281e-15, 7.719e-15, 6.421e-15, 5.34e-15]),
		CE(j=19, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.808e-14, 3.999e-14, 3.326e-14, 2.767e-14, 2.301e-14, 1.914e-14, 1.592e-14, 1.324e-14, 1.101e-14, 9.162e-15, 7.62e-15, 6.338e-15, 5.272e-15]),
		CE(j=20, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.708e-14, 3.916e-14, 3.257e-14, 2.709e-14, 2.253e-14, 1.874e-14, 1.559e-14, 1.297e-14, 1.078e-14, 8.971e-15, 7.461e-15, 6.206e-15, 5.162e-15]),
		CE(j=21, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.845e-14, 1.534e-14, 1.276e-14, 1.062e-14, 8.83e-15, 7.344e-15, 6.109e-15, 5.081e-15, 4.226e-15, 3.515e-15, 2.924e-15, 2.432e-15, 2.023e-15]),
		CE(j=22, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.589e-15, 7.976e-15, 6.634e-15, 5.518e-15, 4.59e-15, 3.817e-15, 3.175e-15, 2.641e-15, 2.197e-15, 1.827e-15, 1.52e-15, 1.264e-15, 1.051e-15]),
		CE(j=23, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.155e-15, 5.119e-15, 4.258e-15, 3.542e-15, 2.946e-15, 2.45e-15, 2.038e-15, 1.695e-15, 1.41e-15, 1.173e-15, 9.755e-16, 8.114e-16, 6.749e-16]),
		CE(j=24, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.079e-14, 6.223e-15, 3.65e-15, 2.19e-15, 1.349e-15, 8.523e-16, 5.49e-16, 3.574e-16, 2.333e-16, 1.517e-16, 9.786e-17, 6.246e-17, 3.942e-17]),
		CE(j=25, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.151e-15, 5.116e-15, 4.255e-15, 3.54e-15, 2.944e-15, 2.449e-15, 2.037e-15, 1.694e-15, 1.409e-15, 1.172e-15, 9.749e-16, 8.109e-16, 6.744e-16]),
		CE(j=26, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.335e-15, 2.774e-15, 2.307e-15, 1.919e-15, 1.596e-15, 1.328e-15, 1.104e-15, 9.184e-16, 7.639e-16, 6.354e-16, 5.285e-16, 4.396e-16, 3.656e-16]),
		CE(j=27, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.631e-17, 9.364e-18, 5.454e-18, 3.247e-18, 1.989e-18, 1.258e-18, 8.183e-19, 5.422e-19, 3.62e-19, 2.414e-19, 1.597e-19, 1.044e-19, 6.734e-20]),
		CE(j=28, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.718e-15, 5.578e-15, 3.249e-15, 1.934e-15, 1.185e-15, 7.494e-16, 4.874e-16, 3.23e-16, 2.157e-16, 1.438e-16, 9.516e-17, 6.222e-17, 4.014e-17]),
		CE(j=29, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.224e-13, 7.298e-14, 4.514e-14, 2.94e-14, 2.035e-14, 1.475e-14, 1.073e-14, 7.808e-15, 5.373e-15, 3.707e-15, 2.52e-15, 1.648e-15, 1.063e-15]),
		CE(j=30, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.942e-15, 2.447e-15, 2.036e-15, 1.693e-15, 1.408e-15, 1.171e-15, 9.743e-16, 8.104e-16, 6.741e-16, 5.607e-16, 4.663e-16, 3.879e-16, 3.226e-16]),
		CE(j=31, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.301e-15, 4.764e-15, 2.774e-15, 1.651e-15, 1.011e-15, 6.397e-16, 4.161e-16, 2.759e-16, 1.843e-16, 1.23e-16, 8.145e-17, 5.329e-17, 3.44e-17]),
		CE(j=32, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.534e-14, 3.176e-14, 1.849e-14, 1.101e-14, 6.742e-15, 4.264e-15, 2.774e-15, 1.839e-15, 1.229e-15, 8.202e-16, 5.431e-16, 3.554e-16, 2.294e-16]),
		CE(j=33, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.811e-15, 2.338e-15, 1.945e-15, 1.617e-15, 1.345e-15, 1.119e-15, 9.307e-16, 7.741e-16, 6.439e-16, 5.356e-16, 4.455e-16, 3.705e-16, 3.082e-16]),
		CE(j=34, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.706e-15, 2.25e-15, 1.872e-15, 1.557e-15, 1.295e-15, 1.077e-15, 8.959e-16, 7.452e-16, 6.198e-16, 5.155e-16, 4.288e-16, 3.567e-16, 2.967e-16]),
		CE(j=35, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.37e-17, 4.225e-17, 2.456e-17, 1.459e-17, 8.919e-18, 5.638e-18, 3.675e-18, 2.447e-18, 1.646e-18, 1.107e-18, 7.384e-19, 4.866e-19, 3.162e-19]),
		CE(j=36, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.433e-15, 2.023e-15, 1.683e-15, 1.4e-15, 1.164e-15, 9.684e-16, 8.055e-16, 6.7e-16, 5.573e-16, 4.635e-16, 3.855e-16, 3.207e-16, 2.667e-16]),
		CE(j=37, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.431e-15, 2.022e-15, 1.682e-15, 1.399e-15, 1.163e-15, 9.677e-16, 8.049e-16, 6.695e-16, 5.568e-16, 4.632e-16, 3.852e-16, 3.204e-16, 2.665e-16]),
		CE(j=40, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.923e-16, 2.431e-16, 2.022e-16, 1.682e-16, 1.399e-16, 1.164e-16, 9.679e-17, 8.05e-17, 6.696e-17, 5.57e-17, 4.633e-17, 3.853e-17, 3.205e-17]),
		CE(j=41, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.92e-16, 2.429e-16, 2.02e-16, 1.68e-16, 1.398e-16, 1.162e-16, 9.669e-17, 8.042e-17, 6.689e-17, 5.564e-17, 4.628e-17, 3.849e-17, 3.202e-17]),
		CE(j=42, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.916e-16, 2.426e-16, 2.018e-16, 1.678e-16, 1.396e-16, 1.161e-16, 9.657e-17, 8.032e-17, 6.681e-17, 5.557e-17, 4.622e-17, 3.845e-17, 3.198e-17]),
		CE(j=43, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.622e-16, 2.181e-16, 1.814e-16, 1.509e-16, 1.255e-16, 1.044e-16, 8.683e-17, 7.222e-17, 6.007e-17, 4.996e-17, 4.156e-17, 3.457e-17, 2.875e-17]),
		CE(j=18, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.493e-13, 2.074e-13, 1.725e-13, 1.435e-13, 1.193e-13, 9.925e-14, 8.255e-14, 6.866e-14, 5.711e-14, 4.75e-14, 3.951e-14, 3.286e-14, 2.734e-14]),
		CE(j=19, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.41e-13, 2.005e-13, 1.667e-13, 1.387e-13, 1.154e-13, 9.594e-14, 7.98e-14, 6.638e-14, 5.521e-14, 4.592e-14, 3.82e-14, 3.177e-14, 2.643e-14]),
		CE(j=20, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.282e-13, 1.898e-13, 1.579e-13, 1.313e-13, 1.092e-13, 9.085e-14, 7.557e-14, 6.286e-14, 5.228e-14, 4.349e-14, 3.617e-14, 3.008e-14, 2.502e-14]),
		CE(j=21, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.792e-14, 3.154e-14, 2.624e-14, 2.182e-14, 1.815e-14, 1.51e-14, 1.256e-14, 1.045e-14, 8.688e-15, 7.226e-15, 6.011e-15, 4.999e-15, 4.158e-15]),
		CE(j=22, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.508e-14, 1.254e-14, 1.043e-14, 8.679e-15, 7.219e-15, 6.004e-15, 4.994e-15, 4.154e-15, 3.455e-15, 2.874e-15, 2.39e-15, 1.988e-15, 1.654e-15]),
		CE(j=23, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.365e-15, 1.948e-15, 1.149e-15, 6.93e-16, 4.29e-16, 2.717e-16, 1.749e-16, 1.135e-16, 7.365e-17, 4.757e-17, 3.046e-17, 1.931e-17, 1.211e-17]),
		CE(j=24, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.267e-15, 4.787e-15, 2.822e-15, 1.703e-15, 1.054e-15, 6.675e-16, 4.296e-16, 2.787e-16, 1.809e-16, 1.169e-16, 7.485e-17, 4.744e-17, 2.976e-17]),
		CE(j=25, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.024e-16, 5.225e-16, 3.08e-16, 1.858e-16, 1.15e-16, 7.286e-17, 4.69e-17, 3.043e-17, 1.975e-17, 1.276e-17, 8.17e-18, 5.179e-18, 3.249e-18]),
		CE(j=26, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.181e-15, 3.478e-15, 2.893e-15, 2.406e-15, 2.001e-15, 1.665e-15, 1.385e-15, 1.152e-15, 9.579e-16, 7.967e-16, 6.627e-16, 5.512e-16, 4.585e-16]),
		CE(j=27, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.1e-16, 6.331e-17, 3.7e-17, 2.213e-17, 1.364e-17, 8.665e-18, 5.651e-18, 3.746e-18, 2.497e-18, 1.66e-18, 1.093e-18, 7.118e-19, 4.572e-19]),
		CE(j=28, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.69e-15, 3.069e-15, 2.553e-15, 2.123e-15, 1.766e-15, 1.469e-15, 1.222e-15, 1.016e-15, 8.453e-16, 7.031e-16, 5.848e-16, 4.864e-16, 4.046e-16]),
		CE(j=29, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.662e-15, 3.046e-15, 2.533e-15, 2.107e-15, 1.753e-15, 1.458e-15, 1.212e-15, 1.008e-15, 8.388e-16, 6.977e-16, 5.803e-16, 4.827e-16, 4.015e-16]),
		CE(j=30, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.085e-16, 6.24e-17, 3.646e-17, 2.181e-17, 1.343e-17, 8.535e-18, 5.568e-18, 3.693e-18, 2.463e-18, 1.639e-18, 1.08e-18, 7.039e-19, 4.525e-19]),
		CE(j=31, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.615e-15, 3.007e-15, 2.501e-15, 2.08e-15, 1.73e-15, 1.439e-15, 1.197e-15, 9.956e-16, 8.281e-16, 6.888e-16, 5.729e-16, 4.765e-16, 3.964e-16]),
		CE(j=32, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.606e-15, 3e-15, 2.495e-15, 2.075e-15, 1.726e-15, 1.436e-15, 1.194e-15, 9.933e-16, 8.262e-16, 6.872e-16, 5.716e-16, 4.754e-16, 3.954e-16]),
		CE(j=33, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.443e-15, 2.864e-15, 2.382e-15, 1.981e-15, 1.648e-15, 1.371e-15, 1.14e-15, 9.484e-16, 7.888e-16, 6.561e-16, 5.457e-16, 4.539e-16, 3.776e-16]),
		CE(j=34, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.937e-17, 4.562e-17, 2.664e-17, 1.591e-17, 9.793e-18, 6.223e-18, 4.065e-18, 2.703e-18, 1.809e-18, 1.208e-18, 7.994e-19, 5.226e-19, 3.37e-19]),
		CE(j=35, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.639e-14, 5.116e-14, 3.113e-14, 1.931e-14, 1.231e-14, 7.951e-15, 5.307e-15, 3.582e-15, 2.407e-15, 1.615e-15, 1.074e-15, 7.054e-16, 4.568e-16]),
		CE(j=36, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.941e-14, 3.412e-14, 1.99e-14, 1.187e-14, 7.298e-15, 4.637e-15, 3.034e-15, 2.023e-15, 1.36e-15, 9.125e-16, 6.069e-16, 3.986e-16, 2.582e-16]),
		CE(j=37, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.916e-14, 1.1e-14, 6.416e-15, 3.828e-15, 2.353e-15, 1.495e-15, 9.781e-16, 6.524e-16, 4.386e-16, 2.942e-16, 1.957e-16, 1.286e-16, 8.325e-17]),
		CE(j=40, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.074e-16, 2.557e-16, 2.127e-16, 1.769e-16, 1.471e-16, 1.224e-16, 1.018e-16, 8.467e-17, 7.043e-17, 5.858e-17, 4.872e-17, 4.053e-17, 3.371e-17]),
		CE(j=41, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.071e-16, 2.554e-16, 2.125e-16, 1.767e-16, 1.47e-16, 1.223e-16, 1.017e-16, 8.458e-17, 7.035e-17, 5.852e-17, 4.867e-17, 4.048e-17, 3.367e-17]),
		CE(j=42, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.067e-16, 2.551e-16, 2.122e-16, 1.765e-16, 1.468e-16, 1.221e-16, 1.016e-16, 8.447e-17, 7.026e-17, 5.844e-17, 4.861e-17, 4.043e-17, 3.363e-17]),
		CE(j=43, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.749e-16, 2.287e-16, 1.902e-16, 1.582e-16, 1.316e-16, 1.094e-16, 9.103e-17, 7.571e-17, 6.298e-17, 5.238e-17, 4.357e-17, 3.624e-17, 3.014e-17]),
		CE(j=19, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.73e-10, 1.439e-10, 1.197e-10, 9.954e-11, 8.279e-11, 6.886e-11, 5.728e-11, 4.764e-11, 3.963e-11, 3.296e-11, 2.742e-11, 2.28e-11, 1.897e-11]),
		CE(j=20, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.358e-11, 2.793e-11, 2.323e-11, 1.933e-11, 1.607e-11, 1.337e-11, 1.112e-11, 9.25e-12, 7.694e-12, 6.399e-12, 5.323e-12, 4.427e-12, 3.682e-12]),
		CE(j=21, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.358e-14, 6.12e-14, 5.091e-14, 4.234e-14, 3.522e-14, 2.929e-14, 2.437e-14, 2.027e-14, 1.686e-14, 1.402e-14, 1.166e-14, 9.7e-15, 8.068e-15]),
		CE(j=22, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.141e-14, 1.781e-14, 1.481e-14, 1.232e-14, 1.025e-14, 8.524e-15, 7.09e-15, 5.897e-15, 4.905e-15, 4.08e-15, 3.394e-15, 2.823e-15, 2.348e-15]),
		CE(j=23, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.643e-14, 4.069e-14, 2.562e-14, 1.649e-14, 1.058e-14, 6.872e-15, 4.544e-15, 2.953e-15, 1.908e-15, 1.226e-15, 7.813e-16, 4.928e-16, 3.078e-16]),
		CE(j=24, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.099e-14, 9.138e-15, 7.601e-15, 6.322e-15, 5.258e-15, 4.374e-15, 3.638e-15, 3.026e-15, 2.517e-15, 2.093e-15, 1.741e-15, 1.448e-15, 1.205e-15]),
		CE(j=25, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.098e-14, 9.135e-15, 7.598e-15, 6.32e-15, 5.256e-15, 4.372e-15, 3.637e-15, 3.025e-15, 2.516e-15, 2.093e-15, 1.741e-15, 1.448e-15, 1.204e-15]),
		CE(j=26, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.879e-15, 4.058e-15, 3.375e-15, 2.807e-15, 2.335e-15, 1.942e-15, 1.615e-15, 1.344e-15, 1.118e-15, 9.296e-16, 7.732e-16, 6.431e-16, 5.349e-16]),
		CE(j=27, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.273e-15, 3.554e-15, 2.956e-15, 2.459e-15, 2.045e-15, 1.701e-15, 1.415e-15, 1.177e-15, 9.79e-16, 8.143e-16, 6.773e-16, 5.633e-16, 4.686e-16]),
		CE(j=28, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.256e-15, 3.54e-15, 2.944e-15, 2.449e-15, 2.037e-15, 1.694e-15, 1.409e-15, 1.172e-15, 9.75e-16, 8.11e-16, 6.745e-16, 5.611e-16, 4.667e-16]),
		CE(j=29, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.22e-15, 3.51e-15, 2.92e-15, 2.429e-15, 2.02e-15, 1.68e-15, 1.398e-15, 1.162e-15, 9.669e-16, 8.042e-16, 6.689e-16, 5.564e-16, 4.628e-16]),
		CE(j=30, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.304e-13, 7.871e-14, 4.958e-14, 3.307e-14, 2.349e-14, 1.742e-14, 1.288e-14, 9.48e-15, 6.512e-15, 4.476e-15, 3.038e-15, 1.973e-15, 1.265e-15]),
		CE(j=31, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.162e-15, 3.462e-15, 2.879e-15, 2.395e-15, 1.992e-15, 1.657e-15, 1.378e-15, 1.146e-15, 9.534e-16, 7.93e-16, 6.596e-16, 5.486e-16, 4.563e-16]),
		CE(j=32, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.151e-15, 3.453e-15, 2.872e-15, 2.389e-15, 1.987e-15, 1.653e-15, 1.375e-15, 1.143e-15, 9.51e-16, 7.91e-16, 6.579e-16, 5.472e-16, 4.552e-16]),
		CE(j=33, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.948e-15, 3.284e-15, 2.731e-15, 2.272e-15, 1.89e-15, 1.572e-15, 1.307e-15, 1.087e-15, 9.044e-16, 7.522e-16, 6.257e-16, 5.204e-16, 4.329e-16]),
		CE(j=34, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.428e-16, 1.398e-16, 8.178e-17, 4.901e-17, 3.027e-17, 1.929e-17, 1.262e-17, 8.394e-18, 5.611e-18, 3.739e-18, 2.468e-18, 1.609e-18, 1.035e-18]),
		CE(j=35, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.319e-15, 2.76e-15, 2.296e-15, 1.91e-15, 1.588e-15, 1.321e-15, 1.099e-15, 9.141e-16, 7.603e-16, 6.324e-16, 5.26e-16, 4.375e-16, 3.639e-16]),
		CE(j=36, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.446e-14, 5.009e-14, 3.041e-14, 1.893e-14, 1.195e-14, 7.745e-15, 5.18e-15, 3.471e-15, 2.331e-15, 1.561e-15, 1.036e-15, 6.788e-16, 4.385e-16]),
		CE(j=37, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.31e-15, 2.753e-15, 2.29e-15, 1.905e-15, 1.584e-15, 1.318e-15, 1.096e-15, 9.117e-16, 7.583e-16, 6.307e-16, 5.246e-16, 4.364e-16, 3.629e-16]),
		CE(j=40, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.172e-16, 2.639e-16, 2.195e-16, 1.826e-16, 1.518e-16, 1.263e-16, 1.051e-16, 8.738e-17, 7.268e-17, 6.045e-17, 5.028e-17, 4.182e-17, 3.479e-17]),
		CE(j=41, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.169e-16, 2.636e-16, 2.192e-16, 1.824e-16, 1.517e-16, 1.262e-16, 1.049e-16, 8.728e-17, 7.26e-17, 6.039e-17, 5.023e-17, 4.178e-17, 3.475e-17]),
		CE(j=42, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.165e-16, 2.632e-16, 2.19e-16, 1.821e-16, 1.515e-16, 1.26e-16, 1.048e-16, 8.717e-17, 7.251e-17, 6.031e-17, 5.016e-17, 4.172e-17, 3.47e-17]),
		CE(j=43, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.514e-17, 3.691e-17, 2.104e-17, 1.212e-17, 7.105e-18, 4.286e-18, 2.69e-18, 1.769e-18, 1.215e-18, 8.599e-19, 6.152e-19, 4.383e-19, 3.079e-19]),
		CE(j=20, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.436e-11, 6.185e-11, 5.144e-11, 4.279e-11, 3.559e-11, 2.96e-11, 2.462e-11, 2.048e-11, 1.703e-11, 1.417e-11, 1.178e-11, 9.802e-12, 8.153e-12]),
		CE(j=21, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.482e-14, 6.223e-14, 5.176e-14, 4.305e-14, 3.581e-14, 2.978e-14, 2.477e-14, 2.061e-14, 1.714e-14, 1.426e-14, 1.186e-14, 9.863e-15, 8.203e-15]),
		CE(j=22, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.158e-14, 1.795e-14, 1.493e-14, 1.242e-14, 1.033e-14, 8.592e-15, 7.147e-15, 5.945e-15, 4.944e-15, 4.113e-15, 3.421e-15, 2.845e-15, 2.367e-15]),
		CE(j=23, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.217e-14, 1.287e-14, 7.615e-15, 4.612e-15, 2.863e-15, 1.815e-15, 1.166e-15, 7.543e-16, 4.874e-16, 3.132e-16, 1.995e-16, 1.258e-16, 7.859e-17]),
		CE(j=24, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.51e-14, 2.038e-14, 1.206e-14, 7.303e-15, 4.534e-15, 2.874e-15, 1.847e-15, 1.194e-15, 7.719e-16, 4.96e-16, 3.16e-16, 1.993e-16, 1.244e-16]),
		CE(j=25, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.899e-14, 1.683e-14, 9.959e-15, 6.032e-15, 3.744e-15, 2.374e-15, 1.526e-15, 9.865e-16, 6.375e-16, 4.097e-16, 2.61e-16, 1.646e-16, 1.028e-16]),
		CE(j=26, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.895e-15, 4.071e-15, 3.386e-15, 2.817e-15, 2.343e-15, 1.949e-15, 1.621e-15, 1.348e-15, 1.121e-15, 9.327e-16, 7.758e-16, 6.453e-16, 5.367e-16]),
		CE(j=27, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.467e-15, 3.15e-15, 1.846e-15, 1.108e-15, 6.849e-16, 4.365e-16, 2.851e-16, 1.889e-16, 1.257e-16, 8.334e-17, 5.475e-17, 3.553e-17, 2.276e-17]),
		CE(j=28, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.269e-15, 3.551e-15, 2.953e-15, 2.457e-15, 2.043e-15, 1.7e-15, 1.414e-15, 1.176e-15, 9.78e-16, 8.134e-16, 6.766e-16, 5.628e-16, 4.681e-16]),
		CE(j=29, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.233e-15, 3.521e-15, 2.929e-15, 2.436e-15, 2.026e-15, 1.685e-15, 1.402e-15, 1.166e-15, 9.698e-16, 8.066e-16, 6.709e-16, 5.58e-16, 4.642e-16]),
		CE(j=30, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.848e-14, 4.013e-14, 2.364e-14, 1.429e-14, 8.927e-15, 5.689e-15, 3.717e-15, 2.464e-15, 1.641e-15, 1.089e-15, 7.162e-16, 4.652e-16, 2.982e-16]),
		CE(j=31, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.192e-13, 7.179e-14, 4.508e-14, 2.991e-14, 2.097e-14, 1.52e-14, 1.101e-14, 7.726e-15, 5.311e-15, 3.653e-15, 2.425e-15, 1.576e-15, 1.01e-15]),
		CE(j=32, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.164e-15, 3.463e-15, 2.881e-15, 2.396e-15, 1.993e-15, 1.658e-15, 1.379e-15, 1.147e-15, 9.538e-16, 7.934e-16, 6.599e-16, 5.489e-16, 4.565e-16]),
		CE(j=33, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.959e-15, 3.293e-15, 2.739e-15, 2.278e-15, 1.895e-15, 1.576e-15, 1.311e-15, 1.09e-15, 9.07e-16, 7.544e-16, 6.275e-16, 5.219e-16, 4.341e-16]),
		CE(j=34, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.501e-16, 2.015e-16, 1.179e-16, 7.068e-17, 4.366e-17, 2.783e-17, 1.821e-17, 1.211e-17, 8.094e-18, 5.392e-18, 3.56e-18, 2.321e-18, 1.493e-18]),
		CE(j=35, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.59e-14, 2.065e-14, 1.207e-14, 7.222e-15, 4.456e-15, 2.841e-15, 1.862e-15, 1.243e-15, 8.345e-16, 5.589e-16, 3.708e-16, 2.429e-16, 1.569e-16]),
		CE(j=36, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.107e-14, 1.787e-14, 1.045e-14, 6.25e-15, 3.856e-15, 2.458e-15, 1.612e-15, 1.075e-15, 7.223e-16, 4.837e-16, 3.21e-16, 2.103e-16, 1.359e-16]),
		CE(j=37, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.691e-14, 2.123e-14, 1.241e-14, 7.425e-15, 4.581e-15, 2.92e-15, 1.914e-15, 1.278e-15, 8.581e-16, 5.747e-16, 3.814e-16, 2.499e-16, 1.614e-16]),
		CE(j=40, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.175e-16, 2.64e-16, 2.196e-16, 1.827e-16, 1.519e-16, 1.264e-16, 1.051e-16, 8.743e-17, 7.272e-17, 6.049e-17, 5.031e-17, 4.185e-17, 3.481e-17]),
		CE(j=41, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.171e-16, 2.638e-16, 2.194e-16, 1.825e-16, 1.518e-16, 1.262e-16, 1.05e-16, 8.734e-17, 7.265e-17, 6.042e-17, 5.026e-17, 4.18e-17, 3.477e-17]),
		CE(j=42, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.167e-16, 2.634e-16, 2.191e-16, 1.822e-16, 1.516e-16, 1.261e-16, 1.049e-16, 8.723e-17, 7.255e-17, 6.035e-17, 5.019e-17, 4.175e-17, 3.473e-17]),
		CE(j=43, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.48e-17, 3.671e-17, 2.093e-17, 1.205e-17, 7.067e-18, 4.263e-18, 2.676e-18, 1.76e-18, 1.209e-18, 8.553e-19, 6.119e-19, 4.359e-19, 3.062e-19]),
		CE(j=21, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.693e-14, 6.399e-14, 5.322e-14, 4.427e-14, 3.682e-14, 3.063e-14, 2.547e-14, 2.119e-14, 1.762e-14, 1.466e-14, 1.219e-14, 1.014e-14, 8.435e-15]),
		CE(j=22, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.187e-14, 1.819e-14, 1.513e-14, 1.259e-14, 1.047e-14, 8.707e-15, 7.242e-15, 6.024e-15, 5.01e-15, 4.167e-15, 3.466e-15, 2.883e-15, 2.398e-15]),
		CE(j=23, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.133e-14, 1.239e-14, 7.329e-15, 4.439e-15, 2.756e-15, 1.747e-15, 1.123e-15, 7.259e-16, 4.69e-16, 3.013e-16, 1.919e-16, 1.21e-16, 7.557e-17]),
		CE(j=24, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.691e-14, 3.427e-14, 2.113e-14, 1.3e-14, 8.215e-15, 5.32e-15, 3.419e-15, 2.211e-15, 1.428e-15, 9.178e-16, 5.845e-16, 3.686e-16, 2.302e-16]),
		CE(j=25, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.114e-14, 9.265e-15, 7.707e-15, 6.41e-15, 5.332e-15, 4.435e-15, 3.689e-15, 3.068e-15, 2.552e-15, 2.123e-15, 1.765e-15, 1.468e-15, 1.221e-15]),
		CE(j=26, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.922e-15, 4.094e-15, 3.405e-15, 2.832e-15, 2.356e-15, 1.959e-15, 1.63e-15, 1.356e-15, 1.127e-15, 9.378e-16, 7.8e-16, 6.488e-16, 5.396e-16]),
		CE(j=27, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.896e-16, 3.974e-16, 2.329e-16, 1.398e-16, 8.643e-17, 5.509e-17, 3.598e-17, 2.384e-17, 1.586e-17, 1.052e-17, 6.908e-18, 4.483e-18, 2.871e-18]),
		CE(j=28, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.054e-14, 6.075e-15, 3.56e-15, 2.137e-15, 1.321e-15, 8.42e-16, 5.5e-16, 3.645e-16, 2.426e-16, 1.608e-16, 1.057e-16, 6.857e-17, 4.392e-17]),
		CE(j=29, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.254e-15, 3.539e-15, 2.943e-15, 2.448e-15, 2.036e-15, 1.694e-15, 1.409e-15, 1.172e-15, 9.746e-16, 8.107e-16, 6.743e-16, 5.608e-16, 4.665e-16]),
		CE(j=30, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.484e-15, 1.431e-15, 8.386e-16, 5.032e-16, 3.111e-16, 1.983e-16, 1.295e-16, 8.589e-17, 5.72e-17, 3.795e-17, 2.495e-17, 1.621e-17, 1.039e-17]),
		CE(j=31, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.11e-14, 2.368e-14, 1.387e-14, 8.324e-15, 5.146e-15, 3.28e-15, 2.143e-15, 1.421e-15, 9.465e-16, 6.281e-16, 4.13e-16, 2.682e-16, 1.719e-16]),
		CE(j=32, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.215e-13, 7.322e-14, 4.602e-14, 3.057e-14, 2.15e-14, 1.57e-14, 1.138e-14, 8.066e-15, 5.544e-15, 3.813e-15, 2.543e-15, 1.652e-15, 1.059e-15]),
		CE(j=33, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.864e-16, 4.529e-16, 2.652e-16, 1.59e-16, 9.827e-17, 6.264e-17, 4.096e-17, 2.72e-17, 1.815e-17, 1.207e-17, 7.953e-18, 5.176e-18, 3.323e-18]),
		CE(j=34, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.713e-17, 1.562e-17, 9.143e-18, 5.48e-18, 3.385e-18, 2.158e-18, 1.412e-18, 9.39e-19, 6.276e-19, 4.181e-19, 2.76e-19, 1.799e-19, 1.157e-19]),
		CE(j=35, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.727e-14, 4.532e-14, 2.712e-14, 1.635e-14, 1.02e-14, 6.584e-15, 4.316e-15, 2.88e-15, 1.934e-15, 1.295e-15, 8.593e-16, 5.629e-16, 3.636e-16]),
		CE(j=36, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.676e-14, 1.539e-14, 8.996e-15, 5.384e-15, 3.322e-15, 2.118e-15, 1.389e-15, 9.267e-16, 6.224e-16, 4.168e-16, 2.765e-16, 1.812e-16, 1.17e-16]),
		CE(j=37, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.333e-15, 2.772e-15, 2.306e-15, 1.918e-15, 1.595e-15, 1.327e-15, 1.104e-15, 9.18e-16, 7.636e-16, 6.351e-16, 5.283e-16, 4.394e-16, 3.655e-16]),
		CE(j=40, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.178e-16, 2.643e-16, 2.199e-16, 1.829e-16, 1.521e-16, 1.265e-16, 1.052e-16, 8.753e-17, 7.28e-17, 6.055e-17, 5.037e-17, 4.189e-17, 3.485e-17]),
		CE(j=41, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.175e-16, 2.64e-16, 2.196e-16, 1.827e-16, 1.519e-16, 1.264e-16, 1.051e-16, 8.743e-17, 7.272e-17, 6.049e-17, 5.031e-17, 4.185e-17, 3.481e-17]),
		CE(j=42, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.17e-16, 2.637e-16, 2.193e-16, 1.824e-16, 1.517e-16, 1.262e-16, 1.05e-16, 8.732e-17, 7.263e-17, 6.041e-17, 5.025e-17, 4.179e-17, 3.476e-17]),
		CE(j=43, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.488e-17, 3.676e-17, 2.095e-17, 1.207e-17, 7.076e-18, 4.269e-18, 2.679e-18, 1.762e-18, 1.21e-18, 8.564e-19, 6.127e-19, 4.364e-19, 3.066e-19]),
		CE(j=22, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.416e-14, 5.336e-14, 4.438e-14, 3.692e-14, 3.071e-14, 2.554e-14, 2.124e-14, 1.767e-14, 1.47e-14, 1.222e-14, 1.017e-14, 8.457e-15, 7.034e-15]),
		CE(j=23, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.114e-14, 1.759e-14, 1.463e-14, 1.217e-14, 1.012e-14, 8.417e-15, 7.001e-15, 5.823e-15, 4.844e-15, 4.029e-15, 3.351e-15, 2.787e-15, 2.318e-15]),
		CE(j=24, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.113e-14, 1.757e-14, 1.462e-14, 1.216e-14, 1.011e-14, 8.41e-15, 6.995e-15, 5.818e-15, 4.84e-15, 4.025e-15, 3.348e-15, 2.785e-15, 2.316e-15]),
		CE(j=25, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.111e-14, 1.756e-14, 1.461e-14, 1.215e-14, 1.011e-14, 8.406e-15, 6.991e-15, 5.815e-15, 4.837e-15, 4.023e-15, 3.346e-15, 2.783e-15, 2.315e-15]),
		CE(j=26, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.085e-14, 4.262e-14, 2.608e-14, 1.624e-14, 1.028e-14, 6.712e-15, 4.412e-15, 2.904e-15, 1.913e-15, 1.253e-15, 8.123e-16, 5.206e-16, 3.296e-16]),
		CE(j=27, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.303e-16, 7.54e-17, 4.444e-17, 2.687e-17, 1.674e-17, 1.072e-17, 7.013e-18, 4.637e-18, 3.071e-18, 2.023e-18, 1.319e-18, 8.501e-19, 5.408e-19]),
		CE(j=28, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.75e-15, 1.591e-15, 9.377e-16, 5.669e-16, 3.531e-16, 2.262e-16, 1.48e-16, 9.785e-17, 6.482e-17, 4.271e-17, 2.786e-17, 1.795e-17, 1.142e-17]),
		CE(j=29, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.92e-15, 4.924e-15, 4.095e-15, 3.406e-15, 2.833e-15, 2.357e-15, 1.96e-15, 1.63e-15, 1.356e-15, 1.128e-15, 9.382e-16, 7.804e-16, 6.491e-16]),
		CE(j=30, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.968e-15, 5.766e-15, 3.398e-15, 2.054e-15, 1.279e-15, 8.194e-16, 5.362e-16, 3.549e-16, 2.353e-16, 1.551e-16, 1.013e-16, 6.531e-17, 4.159e-17]),
		CE(j=31, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.819e-15, 4.84e-15, 4.026e-15, 3.349e-15, 2.785e-15, 2.317e-15, 1.927e-15, 1.603e-15, 1.333e-15, 1.109e-15, 9.223e-16, 7.671e-16, 6.381e-16]),
		CE(j=32, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.043e-16, 5.231e-16, 3.082e-16, 1.863e-16, 1.16e-16, 7.432e-17, 4.865e-17, 3.22e-17, 2.135e-17, 1.408e-17, 9.197e-18, 5.932e-18, 3.778e-18]),
		CE(j=33, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.493e-13, 9.127e-14, 5.861e-14, 4.01e-14, 2.932e-14, 2.247e-14, 1.734e-14, 1.296e-14, 9.179e-15, 6.287e-15, 4.287e-15, 2.804e-15, 1.789e-15]),
		CE(j=34, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.895e-15, 4.562e-15, 2.685e-15, 1.621e-15, 1.009e-15, 6.466e-16, 4.242e-16, 2.817e-16, 1.876e-16, 1.243e-16, 8.152e-17, 5.28e-17, 3.374e-17]),
		CE(j=35, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.431e-15, 3.686e-15, 3.066e-15, 2.55e-15, 2.121e-15, 1.764e-15, 1.467e-15, 1.22e-15, 1.015e-15, 8.444e-16, 7.023e-16, 5.842e-16, 4.859e-16]),
		CE(j=36, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.423e-15, 3.678e-15, 3.06e-15, 2.545e-15, 2.117e-15, 1.761e-15, 1.464e-15, 1.218e-15, 1.013e-15, 8.427e-16, 7.009e-16, 5.83e-16, 4.849e-16]),
		CE(j=37, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.418e-15, 3.674e-15, 3.056e-15, 2.542e-15, 2.114e-15, 1.759e-15, 1.463e-15, 1.217e-15, 1.012e-15, 8.418e-16, 7.002e-16, 5.824e-16, 4.844e-16]),
		CE(j=40, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.392e-16, 2.822e-16, 2.347e-16, 1.952e-16, 1.624e-16, 1.35e-16, 1.123e-16, 9.343e-17, 7.771e-17, 6.464e-17, 5.376e-17, 4.472e-17, 3.72e-17]),
		CE(j=41, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.388e-16, 2.818e-16, 2.344e-16, 1.95e-16, 1.622e-16, 1.349e-16, 1.122e-16, 9.333e-17, 7.763e-17, 6.457e-17, 5.37e-17, 4.467e-17, 3.715e-17]),
		CE(j=42, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.384e-16, 2.815e-16, 2.341e-16, 1.947e-16, 1.62e-16, 1.347e-16, 1.121e-16, 9.32e-17, 7.752e-17, 6.448e-17, 5.363e-17, 4.461e-17, 3.71e-17]),
		CE(j=43, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.014e-16, 2.507e-16, 2.085e-16, 1.734e-16, 1.442e-16, 1.2e-16, 9.979e-17, 8.301e-17, 6.904e-17, 5.743e-17, 4.776e-17, 3.973e-17, 3.305e-17]),
		CE(j=23, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.167e-14, 5.961e-14, 4.958e-14, 4.124e-14, 3.43e-14, 2.853e-14, 2.373e-14, 1.974e-14, 1.642e-14, 1.366e-14, 1.136e-14, 9.448e-15, 7.859e-15]),
		CE(j=24, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.155e-14, 5.951e-14, 4.95e-14, 4.117e-14, 3.425e-14, 2.848e-14, 2.369e-14, 1.971e-14, 1.639e-14, 1.363e-14, 1.134e-14, 9.432e-15, 7.845e-15]),
		CE(j=25, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.147e-14, 5.945e-14, 4.944e-14, 4.113e-14, 3.421e-14, 2.845e-14, 2.367e-14, 1.968e-14, 1.637e-14, 1.362e-14, 1.133e-14, 9.422e-15, 7.836e-15]),
		CE(j=26, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.2e-14, 9.977e-15, 8.299e-15, 6.902e-15, 5.741e-15, 4.775e-15, 3.972e-15, 3.304e-15, 2.748e-15, 2.286e-15, 1.901e-15, 1.581e-15, 1.315e-15]),
		CE(j=27, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.622e-15, 8.004e-15, 6.657e-15, 5.537e-15, 4.606e-15, 3.831e-15, 3.186e-15, 2.65e-15, 2.204e-15, 1.834e-15, 1.525e-15, 1.268e-15, 1.055e-15]),
		CE(j=28, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.56e-15, 7.951e-15, 6.614e-15, 5.501e-15, 4.576e-15, 3.806e-15, 3.166e-15, 2.633e-15, 2.19e-15, 1.822e-15, 1.515e-15, 1.26e-15, 1.048e-15]),
		CE(j=29, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.431e-15, 7.844e-15, 6.525e-15, 5.427e-15, 4.514e-15, 3.754e-15, 3.123e-15, 2.597e-15, 2.16e-15, 1.797e-15, 1.495e-15, 1.243e-15, 1.034e-15]),
		CE(j=30, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.846e-14, 3.416e-14, 2.043e-14, 1.248e-14, 7.836e-15, 5.041e-15, 3.296e-15, 2.17e-15, 1.427e-15, 9.314e-16, 6.017e-16, 3.842e-16, 2.424e-16]),
		CE(j=31, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.221e-15, 7.669e-15, 6.379e-15, 5.306e-15, 4.413e-15, 3.671e-15, 3.053e-15, 2.54e-15, 2.112e-15, 1.757e-15, 1.461e-15, 1.216e-15, 1.011e-15]),
		CE(j=32, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.183e-15, 7.638e-15, 6.353e-15, 5.284e-15, 4.395e-15, 3.656e-15, 3.041e-15, 2.529e-15, 2.104e-15, 1.75e-15, 1.455e-15, 1.211e-15, 1.007e-15]),
		CE(j=33, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.478e-15, 7.052e-15, 5.865e-15, 4.879e-15, 4.058e-15, 3.375e-15, 2.807e-15, 2.335e-15, 1.942e-15, 1.615e-15, 1.344e-15, 1.118e-15, 9.296e-16]),
		CE(j=34, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.31e-13, 8.106e-14, 5.286e-14, 3.664e-14, 2.675e-14, 1.99e-14, 1.462e-14, 1.023e-14, 6.996e-15, 4.777e-15, 3.129e-15, 2.008e-15, 1.273e-15]),
		CE(j=35, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.498e-15, 5.405e-15, 4.495e-15, 3.739e-15, 3.11e-15, 2.587e-15, 2.152e-15, 1.79e-15, 1.489e-15, 1.238e-15, 1.03e-15, 8.566e-16, 7.125e-16]),
		CE(j=36, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.512e-16, 2.037e-16, 1.206e-16, 7.331e-17, 4.598e-17, 2.968e-17, 1.956e-17, 1.302e-17, 8.667e-18, 5.733e-18, 3.751e-18, 2.423e-18, 1.544e-18]),
		CE(j=37, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.473e-15, 5.384e-15, 4.478e-15, 3.725e-15, 3.098e-15, 2.577e-15, 2.143e-15, 1.783e-15, 1.483e-15, 1.233e-15, 1.026e-15, 8.533e-16, 7.097e-16]),
		CE(j=40, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.66e-16, 3.044e-16, 2.532e-16, 2.106e-16, 1.752e-16, 1.457e-16, 1.212e-16, 1.008e-16, 8.384e-17, 6.973e-17, 5.8e-17, 4.824e-17, 4.013e-17]),
		CE(j=41, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.655e-16, 3.04e-16, 2.529e-16, 2.103e-16, 1.75e-16, 1.455e-16, 1.21e-16, 1.007e-16, 8.374e-17, 6.965e-17, 5.793e-17, 4.819e-17, 4.008e-17]),
		CE(j=42, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.65e-16, 3.036e-16, 2.525e-16, 2.1e-16, 1.747e-16, 1.453e-16, 1.209e-16, 1.005e-16, 8.362e-17, 6.955e-17, 5.785e-17, 4.812e-17, 4.002e-17]),
		CE(j=43, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.234e-16, 2.69e-16, 2.237e-16, 1.861e-16, 1.548e-16, 1.288e-16, 1.071e-16, 8.907e-17, 7.409e-17, 6.162e-17, 5.126e-17, 4.263e-17, 3.546e-17]),
		CE(j=24, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.637e-09, 6.352e-09, 5.284e-09, 4.395e-09, 3.655e-09, 3.04e-09, 2.529e-09, 2.103e-09, 1.75e-09, 1.455e-09, 1.21e-09, 1.007e-09, 8.374e-10]),
		CE(j=25, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.28e-09, 2.728e-09, 2.269e-09, 1.887e-09, 1.57e-09, 1.306e-09, 1.086e-09, 9.034e-10, 7.514e-10, 6.25e-10, 5.198e-10, 4.324e-10, 3.596e-10]),
		CE(j=26, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.442e-14, 2.031e-14, 1.69e-14, 1.405e-14, 1.169e-14, 9.723e-15, 8.087e-15, 6.726e-15, 5.595e-15, 4.654e-15, 3.871e-15, 3.219e-15, 2.678e-15]),
		CE(j=27, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.763e-14, 1.466e-14, 1.22e-14, 1.015e-14, 8.439e-15, 7.019e-15, 5.838e-15, 4.856e-15, 4.039e-15, 3.359e-15, 2.794e-15, 2.324e-15, 1.933e-15]),
		CE(j=28, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.747e-14, 1.453e-14, 1.208e-14, 1.005e-14, 8.36e-15, 6.954e-15, 5.784e-15, 4.811e-15, 4.001e-15, 3.328e-15, 2.768e-15, 2.303e-15, 1.915e-15]),
		CE(j=29, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.713e-14, 1.425e-14, 1.185e-14, 9.858e-15, 8.199e-15, 6.82e-15, 5.672e-15, 4.718e-15, 3.924e-15, 3.264e-15, 2.715e-15, 2.258e-15, 1.878e-15]),
		CE(j=30, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.672e-14, 1.391e-14, 1.157e-14, 9.621e-15, 8.003e-15, 6.656e-15, 5.537e-15, 4.605e-15, 3.83e-15, 3.186e-15, 2.65e-15, 2.204e-15, 1.833e-15]),
		CE(j=31, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.659e-14, 1.38e-14, 1.148e-14, 9.547e-15, 7.941e-15, 6.605e-15, 5.494e-15, 4.569e-15, 3.801e-15, 3.161e-15, 2.629e-15, 2.187e-15, 1.819e-15]),
		CE(j=32, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.649e-14, 1.372e-14, 1.141e-14, 9.491e-15, 7.894e-15, 6.566e-15, 5.462e-15, 4.543e-15, 3.779e-15, 3.143e-15, 2.614e-15, 2.174e-15, 1.809e-15]),
		CE(j=33, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.475e-14, 1.226e-14, 1.02e-14, 8.485e-15, 7.058e-15, 5.87e-15, 4.883e-15, 4.061e-15, 3.378e-15, 2.81e-15, 2.337e-15, 1.944e-15, 1.617e-15]),
		CE(j=34, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.334e-14, 1.109e-14, 9.227e-15, 7.675e-15, 6.384e-15, 5.31e-15, 4.416e-15, 3.673e-15, 3.055e-15, 2.541e-15, 2.114e-15, 1.758e-15, 1.462e-15]),
		CE(j=35, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.029e-14, 8.562e-15, 7.122e-15, 5.924e-15, 4.927e-15, 4.098e-15, 3.409e-15, 2.835e-15, 2.358e-15, 1.962e-15, 1.632e-15, 1.357e-15, 1.129e-15]),
		CE(j=36, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.026e-14, 8.534e-15, 7.099e-15, 5.904e-15, 4.911e-15, 4.085e-15, 3.398e-15, 2.826e-15, 2.351e-15, 1.955e-15, 1.626e-15, 1.353e-15, 1.125e-15]),
		CE(j=37, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.024e-14, 8.519e-15, 7.086e-15, 5.894e-15, 4.902e-15, 4.077e-15, 3.391e-15, 2.821e-15, 2.346e-15, 1.952e-15, 1.623e-15, 1.35e-15, 1.123e-15]),
		CE(j=40, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.942e-16, 3.278e-16, 2.727e-16, 2.268e-16, 1.887e-16, 1.569e-16, 1.305e-16, 1.086e-16, 9.03e-17, 7.51e-17, 6.247e-17, 5.196e-17, 4.322e-17]),
		CE(j=41, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.937e-16, 3.274e-16, 2.724e-16, 2.265e-16, 1.884e-16, 1.567e-16, 1.304e-16, 1.084e-16, 9.018e-17, 7.501e-17, 6.239e-17, 5.19e-17, 4.317e-17]),
		CE(j=42, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.931e-16, 3.27e-16, 2.72e-16, 2.262e-16, 1.881e-16, 1.565e-16, 1.302e-16, 1.083e-16, 9.005e-17, 7.49e-17, 6.23e-17, 5.182e-17, 4.31e-17]),
		CE(j=43, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.465e-16, 2.882e-16, 2.397e-16, 1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.542e-17, 7.937e-17, 6.602e-17, 5.491e-17, 4.567e-17, 3.799e-17]),
		CE(j=25, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.559e-08, 1.297e-08, 1.079e-08, 8.973e-09, 7.463e-09, 6.208e-09, 5.163e-09, 4.295e-09, 3.572e-09, 2.971e-09, 2.471e-09, 2.056e-09, 1.71e-09]),
		CE(j=26, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.444e-14, 2.033e-14, 1.691e-14, 1.407e-14, 1.17e-14, 9.731e-15, 8.094e-15, 6.732e-15, 5.6e-15, 4.658e-15, 3.874e-15, 3.222e-15, 2.68e-15]),
		CE(j=27, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.764e-14, 1.468e-14, 1.221e-14, 1.015e-14, 8.445e-15, 7.024e-15, 5.842e-15, 4.859e-15, 4.042e-15, 3.362e-15, 2.796e-15, 2.326e-15, 1.935e-15]),
		CE(j=28, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.748e-14, 1.454e-14, 1.209e-14, 1.006e-14, 8.366e-15, 6.959e-15, 5.788e-15, 4.814e-15, 4.004e-15, 3.331e-15, 2.77e-15, 2.304e-15, 1.917e-15]),
		CE(j=29, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.714e-14, 1.426e-14, 1.186e-14, 9.865e-15, 8.205e-15, 6.825e-15, 5.677e-15, 4.722e-15, 3.927e-15, 3.267e-15, 2.717e-15, 2.26e-15, 1.88e-15]),
		CE(j=30, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.673e-14, 1.392e-14, 1.158e-14, 9.628e-15, 8.009e-15, 6.661e-15, 5.541e-15, 4.608e-15, 3.833e-15, 3.188e-15, 2.652e-15, 2.206e-15, 1.835e-15]),
		CE(j=31, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.66e-14, 1.381e-14, 1.149e-14, 9.554e-15, 7.946e-15, 6.609e-15, 5.498e-15, 4.573e-15, 3.803e-15, 3.163e-15, 2.631e-15, 2.189e-15, 1.82e-15]),
		CE(j=32, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.651e-14, 1.373e-14, 1.142e-14, 9.498e-15, 7.9e-15, 6.571e-15, 5.466e-15, 4.546e-15, 3.781e-15, 3.145e-15, 2.616e-15, 2.176e-15, 1.81e-15]),
		CE(j=33, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.476e-14, 1.227e-14, 1.021e-14, 8.491e-15, 7.062e-15, 5.874e-15, 4.886e-15, 4.064e-15, 3.38e-15, 2.812e-15, 2.339e-15, 1.945e-15, 1.618e-15]),
		CE(j=34, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.335e-14, 1.11e-14, 9.233e-15, 7.68e-15, 6.388e-15, 5.313e-15, 4.419e-15, 3.676e-15, 3.057e-15, 2.543e-15, 2.115e-15, 1.759e-15, 1.463e-15]),
		CE(j=35, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.03e-14, 8.567e-15, 7.126e-15, 5.927e-15, 4.93e-15, 4.1e-15, 3.411e-15, 2.837e-15, 2.36e-15, 1.963e-15, 1.632e-15, 1.358e-15, 1.129e-15]),
		CE(j=36, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.027e-14, 8.539e-15, 7.102e-15, 5.907e-15, 4.914e-15, 4.087e-15, 3.399e-15, 2.827e-15, 2.352e-15, 1.956e-15, 1.627e-15, 1.353e-15, 1.126e-15]),
		CE(j=37, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.025e-14, 8.523e-15, 7.089e-15, 5.897e-15, 4.905e-15, 4.08e-15, 3.393e-15, 2.822e-15, 2.348e-15, 1.953e-15, 1.624e-15, 1.351e-15, 1.124e-15]),
		CE(j=40, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.942e-16, 3.279e-16, 2.727e-16, 2.268e-16, 1.887e-16, 1.569e-16, 1.305e-16, 1.086e-16, 9.03e-17, 7.511e-17, 6.247e-17, 5.196e-17, 4.322e-17]),
		CE(j=41, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.937e-16, 3.275e-16, 2.724e-16, 2.266e-16, 1.884e-16, 1.567e-16, 1.304e-16, 1.084e-16, 9.019e-17, 7.502e-17, 6.24e-17, 5.19e-17, 4.317e-17]),
		CE(j=42, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.931e-16, 3.27e-16, 2.72e-16, 2.262e-16, 1.882e-16, 1.565e-16, 1.302e-16, 1.083e-16, 9.006e-17, 7.491e-17, 6.231e-17, 5.182e-17, 4.311e-17]),
		CE(j=43, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.465e-16, 2.882e-16, 2.397e-16, 1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.543e-17, 7.938e-17, 6.602e-17, 5.492e-17, 4.568e-17, 3.799e-17]),
		CE(j=26, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.446e-14, 2.034e-14, 1.692e-14, 1.407e-14, 1.171e-14, 9.737e-15, 8.099e-15, 6.736e-15, 5.603e-15, 4.66e-15, 3.876e-15, 3.224e-15, 2.682e-15]),
		CE(j=27, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.765e-14, 1.468e-14, 1.221e-14, 1.016e-14, 8.449e-15, 7.027e-15, 5.845e-15, 4.862e-15, 4.044e-15, 3.364e-15, 2.798e-15, 2.327e-15, 1.936e-15]),
		CE(j=28, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.749e-14, 1.455e-14, 1.21e-14, 1.006e-14, 8.37e-15, 6.962e-15, 5.791e-15, 4.817e-15, 4.006e-15, 3.332e-15, 2.772e-15, 2.305e-15, 1.917e-15]),
		CE(j=29, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.715e-14, 1.427e-14, 1.187e-14, 9.87e-15, 8.209e-15, 6.828e-15, 5.679e-15, 4.724e-15, 3.929e-15, 3.268e-15, 2.718e-15, 2.261e-15, 1.881e-15]),
		CE(j=30, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.674e-14, 1.392e-14, 1.158e-14, 9.633e-15, 8.012e-15, 6.664e-15, 5.543e-15, 4.611e-15, 3.835e-15, 3.19e-15, 2.653e-15, 2.207e-15, 1.836e-15]),
		CE(j=31, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.661e-14, 1.382e-14, 1.149e-14, 9.558e-15, 7.95e-15, 6.613e-15, 5.5e-15, 4.575e-15, 3.805e-15, 3.165e-15, 2.633e-15, 2.19e-15, 1.821e-15]),
		CE(j=32, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.651e-14, 1.374e-14, 1.142e-14, 9.502e-15, 7.904e-15, 6.574e-15, 5.468e-15, 4.548e-15, 3.783e-15, 3.147e-15, 2.617e-15, 2.177e-15, 1.811e-15]),
		CE(j=33, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.476e-14, 1.228e-14, 1.021e-14, 8.494e-15, 7.065e-15, 5.877e-15, 4.888e-15, 4.066e-15, 3.382e-15, 2.813e-15, 2.34e-15, 1.946e-15, 1.619e-15]),
		CE(j=34, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.335e-14, 1.11e-14, 9.237e-15, 7.683e-15, 6.39e-15, 5.315e-15, 4.421e-15, 3.677e-15, 3.059e-15, 2.544e-15, 2.116e-15, 1.76e-15, 1.464e-15]),
		CE(j=35, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.03e-14, 8.57e-15, 7.128e-15, 5.929e-15, 4.931e-15, 4.102e-15, 3.412e-15, 2.838e-15, 2.36e-15, 1.963e-15, 1.633e-15, 1.358e-15, 1.13e-15]),
		CE(j=36, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.027e-14, 8.542e-15, 7.105e-15, 5.91e-15, 4.915e-15, 4.088e-15, 3.401e-15, 2.828e-15, 2.353e-15, 1.957e-15, 1.628e-15, 1.354e-15, 1.126e-15]),
		CE(j=37, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.025e-14, 8.526e-15, 7.092e-15, 5.899e-15, 4.906e-15, 4.081e-15, 3.394e-15, 2.823e-15, 2.348e-15, 1.953e-15, 1.625e-15, 1.351e-15, 1.124e-15]),
		CE(j=40, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.942e-16, 3.279e-16, 2.727e-16, 2.268e-16, 1.887e-16, 1.569e-16, 1.305e-16, 1.086e-16, 9.031e-17, 7.511e-17, 6.248e-17, 5.197e-17, 4.322e-17]),
		CE(j=41, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.937e-16, 3.275e-16, 2.724e-16, 2.266e-16, 1.884e-16, 1.567e-16, 1.304e-16, 1.084e-16, 9.02e-17, 7.502e-17, 6.24e-17, 5.19e-17, 4.317e-17]),
		CE(j=42, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.931e-16, 3.27e-16, 2.72e-16, 2.262e-16, 1.882e-16, 1.565e-16, 1.302e-16, 1.083e-16, 9.006e-17, 7.491e-17, 6.231e-17, 5.183e-17, 4.311e-17]),
		CE(j=43, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.465e-16, 2.882e-16, 2.397e-16, 1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.544e-17, 7.938e-17, 6.603e-17, 5.492e-17, 4.568e-17, 3.799e-17]),
		CE(j=27, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.255e-13, 2.707e-13, 2.252e-13, 1.873e-13, 1.558e-13, 1.296e-13, 1.078e-13, 8.964e-14, 7.456e-14, 6.202e-14, 5.158e-14, 4.291e-14, 3.569e-14]),
		CE(j=28, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.089e-13, 2.569e-13, 2.137e-13, 1.777e-13, 1.478e-13, 1.23e-13, 1.023e-13, 8.507e-14, 7.076e-14, 5.885e-14, 4.895e-14, 4.072e-14, 3.387e-14]),
		CE(j=29, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.782e-13, 2.314e-13, 1.925e-13, 1.601e-13, 1.331e-13, 1.107e-13, 9.212e-14, 7.662e-14, 6.373e-14, 5.301e-14, 4.409e-14, 3.667e-14, 3.05e-14]),
		CE(j=30, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.458e-13, 2.045e-13, 1.701e-13, 1.415e-13, 1.177e-13, 9.786e-14, 8.14e-14, 6.771e-14, 5.631e-14, 4.684e-14, 3.896e-14, 3.241e-14, 2.695e-14]),
		CE(j=31, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.366e-13, 1.968e-13, 1.637e-13, 1.361e-13, 1.132e-13, 9.419e-14, 7.834e-14, 6.516e-14, 5.42e-14, 4.508e-14, 3.75e-14, 3.119e-14, 2.594e-14]),
		CE(j=32, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.3e-13, 1.913e-13, 1.591e-13, 1.324e-13, 1.101e-13, 9.157e-14, 7.617e-14, 6.335e-14, 5.269e-14, 4.383e-14, 3.646e-14, 3.032e-14, 2.522e-14]),
		CE(j=33, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.423e-13, 1.183e-13, 9.842e-14, 8.187e-14, 6.809e-14, 5.664e-14, 4.711e-14, 3.918e-14, 3.259e-14, 2.711e-14, 2.255e-14, 1.875e-14, 1.56e-14]),
		CE(j=34, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.948e-14, 8.275e-14, 6.883e-14, 5.725e-14, 4.762e-14, 3.96e-14, 3.294e-14, 2.74e-14, 2.279e-14, 1.896e-14, 1.577e-14, 1.311e-14, 1.091e-14]),
		CE(j=35, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.758e-14, 3.957e-14, 3.292e-14, 2.738e-14, 2.277e-14, 1.894e-14, 1.575e-14, 1.31e-14, 1.09e-14, 9.066e-15, 7.541e-15, 6.272e-15, 5.217e-15]),
		CE(j=36, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.719e-14, 3.925e-14, 3.265e-14, 2.716e-14, 2.259e-14, 1.879e-14, 1.563e-14, 1.3e-14, 1.081e-14, 8.992e-15, 7.48e-15, 6.221e-15, 5.175e-15]),
		CE(j=37, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.698e-14, 3.908e-14, 3.25e-14, 2.704e-14, 2.249e-14, 1.87e-14, 1.556e-14, 1.294e-14, 1.076e-14, 8.952e-15, 7.446e-15, 6.193e-15, 5.151e-15]),
		CE(j=40, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.582e-16, 3.811e-16, 3.17e-16, 2.637e-16, 2.193e-16, 1.824e-16, 1.517e-16, 1.262e-16, 1.05e-16, 8.731e-17, 7.262e-17, 6.041e-17, 5.024e-17]),
		CE(j=41, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.576e-16, 3.806e-16, 3.166e-16, 2.633e-16, 2.19e-16, 1.822e-16, 1.515e-16, 1.26e-16, 1.048e-16, 8.72e-17, 7.253e-17, 6.033e-17, 5.018e-17]),
		CE(j=42, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.569e-16, 3.8e-16, 3.161e-16, 2.629e-16, 2.187e-16, 1.819e-16, 1.513e-16, 1.258e-16, 1.047e-16, 8.706e-17, 7.241e-17, 6.023e-17, 5.01e-17]),
		CE(j=43, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.981e-16, 3.312e-16, 2.754e-16, 2.291e-16, 1.906e-16, 1.585e-16, 1.318e-16, 1.097e-16, 9.121e-17, 7.586e-17, 6.31e-17, 5.249e-17, 4.366e-17]),
		CE(j=28, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.076e-10, 8.946e-11, 7.441e-11, 6.189e-11, 5.148e-11, 4.282e-11, 3.562e-11, 2.962e-11, 2.464e-11, 2.049e-11, 1.705e-11, 1.418e-11, 1.179e-11]),
		CE(j=29, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.613e-11, 1.341e-11, 1.116e-11, 9.279e-12, 7.718e-12, 6.419e-12, 5.339e-12, 4.441e-12, 3.694e-12, 3.073e-12, 2.556e-12, 2.126e-12, 1.768e-12]),
		CE(j=30, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.705e-12, 4.745e-12, 3.947e-12, 3.283e-12, 2.731e-12, 2.271e-12, 1.889e-12, 1.571e-12, 1.307e-12, 1.087e-12, 9.042e-13, 7.521e-13, 6.255e-13]),
		CE(j=31, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.513e-12, 3.753e-12, 3.122e-12, 2.597e-12, 2.16e-12, 1.797e-12, 1.494e-12, 1.243e-12, 1.034e-12, 8.599e-13, 7.152e-13, 5.949e-13, 4.948e-13]),
		CE(j=32, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.858e-12, 3.209e-12, 2.669e-12, 2.22e-12, 1.846e-12, 1.536e-12, 1.277e-12, 1.063e-12, 8.838e-13, 7.351e-13, 6.114e-13, 5.085e-13, 4.23e-13]),
		CE(j=33, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.951e-13, 5.781e-13, 4.809e-13, 4e-13, 3.327e-13, 2.767e-13, 2.302e-13, 1.914e-13, 1.592e-13, 1.324e-13, 1.102e-13, 9.163e-14, 7.621e-14]),
		CE(j=34, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.123e-13, 2.597e-13, 2.16e-13, 1.797e-13, 1.495e-13, 1.243e-13, 1.034e-13, 8.601e-14, 7.154e-14, 5.95e-14, 4.949e-14, 4.117e-14, 3.424e-14]),
		CE(j=35, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.058e-14, 7.534e-14, 6.267e-14, 5.212e-14, 4.336e-14, 3.606e-14, 2.999e-14, 2.495e-14, 2.075e-14, 1.726e-14, 1.436e-14, 1.194e-14, 9.932e-15]),
		CE(j=36, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.951e-14, 7.445e-14, 6.192e-14, 5.151e-14, 4.284e-14, 3.563e-14, 2.964e-14, 2.465e-14, 2.05e-14, 1.706e-14, 1.419e-14, 1.18e-14, 9.814e-15]),
		CE(j=37, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.892e-14, 7.396e-14, 6.152e-14, 5.117e-14, 4.256e-14, 3.54e-14, 2.944e-14, 2.449e-14, 2.037e-14, 1.694e-14, 1.409e-14, 1.172e-14, 9.75e-15]),
		CE(j=40, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.741e-16, 3.943e-16, 3.28e-16, 2.728e-16, 2.269e-16, 1.887e-16, 1.57e-16, 1.306e-16, 1.086e-16, 9.034e-17, 7.514e-17, 6.25e-17, 5.199e-17]),
		CE(j=41, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.735e-16, 3.938e-16, 3.276e-16, 2.724e-16, 2.266e-16, 1.885e-16, 1.568e-16, 1.304e-16, 1.085e-16, 9.022e-17, 7.504e-17, 6.241e-17, 5.191e-17]),
		CE(j=42, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.727e-16, 3.932e-16, 3.27e-16, 2.72e-16, 2.262e-16, 1.882e-16, 1.565e-16, 1.302e-16, 1.083e-16, 9.007e-17, 7.492e-17, 6.231e-17, 5.183e-17]),
		CE(j=43, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.108e-16, 3.417e-16, 2.842e-16, 2.364e-16, 1.966e-16, 1.635e-16, 1.36e-16, 1.131e-16, 9.411e-17, 7.828e-17, 6.511e-17, 5.415e-17, 4.504e-17]),
		CE(j=29, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.107e-11, 2.584e-11, 2.149e-11, 1.788e-11, 1.487e-11, 1.237e-11, 1.029e-11, 8.557e-12, 7.117e-12, 5.92e-12, 4.924e-12, 4.095e-12, 3.406e-12]),
		CE(j=30, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.867e-12, 6.544e-12, 5.443e-12, 4.527e-12, 3.766e-12, 3.132e-12, 2.605e-12, 2.167e-12, 1.802e-12, 1.499e-12, 1.247e-12, 1.037e-12, 8.626e-13]),
		CE(j=31, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.946e-12, 4.946e-12, 4.114e-12, 3.422e-12, 2.846e-12, 2.367e-12, 1.969e-12, 1.638e-12, 1.362e-12, 1.133e-12, 9.424e-13, 7.839e-13, 6.52e-13]),
		CE(j=32, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.95e-12, 4.117e-12, 3.425e-12, 2.849e-12, 2.369e-12, 1.971e-12, 1.639e-12, 1.363e-12, 1.134e-12, 9.433e-13, 7.846e-13, 6.526e-13, 5.428e-13]),
		CE(j=33, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.573e-13, 6.299e-13, 5.239e-13, 4.358e-13, 3.625e-13, 3.015e-13, 2.508e-13, 2.086e-13, 1.735e-13, 1.443e-13, 1.2e-13, 9.983e-14, 8.303e-14]),
		CE(j=34, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.292e-13, 2.738e-13, 2.277e-13, 1.894e-13, 1.576e-13, 1.311e-13, 1.09e-13, 9.067e-14, 7.541e-14, 6.273e-14, 5.217e-14, 4.34e-14, 3.609e-14]),
		CE(j=35, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.288e-14, 7.725e-14, 6.426e-14, 5.345e-14, 4.445e-14, 3.698e-14, 3.075e-14, 2.558e-14, 2.128e-14, 1.77e-14, 1.472e-14, 1.224e-14, 1.018e-14]),
		CE(j=36, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.176e-14, 7.632e-14, 6.348e-14, 5.28e-14, 4.392e-14, 3.653e-14, 3.038e-14, 2.527e-14, 2.102e-14, 1.748e-14, 1.454e-14, 1.21e-14, 1.006e-14]),
		CE(j=37, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.115e-14, 7.582e-14, 6.306e-14, 5.245e-14, 4.363e-14, 3.629e-14, 3.018e-14, 2.51e-14, 2.088e-14, 1.737e-14, 1.445e-14, 1.202e-14, 9.994e-15]),
		CE(j=40, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.746e-16, 3.948e-16, 3.284e-16, 2.731e-16, 2.272e-16, 1.89e-16, 1.572e-16, 1.307e-16, 1.087e-16, 9.044e-17, 7.522e-17, 6.257e-17, 5.204e-17]),
		CE(j=41, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.74e-16, 3.942e-16, 3.279e-16, 2.727e-16, 2.269e-16, 1.887e-16, 1.569e-16, 1.305e-16, 1.086e-16, 9.031e-17, 7.512e-17, 6.248e-17, 5.197e-17]),
		CE(j=42, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.732e-16, 3.936e-16, 3.274e-16, 2.723e-16, 2.265e-16, 1.884e-16, 1.567e-16, 1.303e-16, 1.084e-16, 9.017e-17, 7.5e-17, 6.238e-17, 5.189e-17]),
		CE(j=43, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.112e-16, 3.42e-16, 2.845e-16, 2.366e-16, 1.968e-16, 1.637e-16, 1.362e-16, 1.133e-16, 9.42e-17, 7.836e-17, 6.517e-17, 5.421e-17, 4.509e-17]),
		CE(j=30, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.093e-11, 1.741e-11, 1.448e-11, 1.205e-11, 1.002e-11, 8.334e-12, 6.932e-12, 5.766e-12, 4.796e-12, 3.989e-12, 3.318e-12, 2.76e-12, 2.295e-12]),
		CE(j=31, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.305e-11, 1.086e-11, 9.03e-12, 7.511e-12, 6.247e-12, 5.196e-12, 4.322e-12, 3.595e-12, 2.99e-12, 2.487e-12, 2.069e-12, 1.721e-12, 1.431e-12]),
		CE(j=32, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.827e-12, 8.174e-12, 6.799e-12, 5.655e-12, 4.703e-12, 3.912e-12, 3.254e-12, 2.707e-12, 2.251e-12, 1.872e-12, 1.557e-12, 1.295e-12, 1.078e-12]),
		CE(j=33, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.204e-13, 7.655e-13, 6.367e-13, 5.296e-13, 4.405e-13, 3.664e-13, 3.048e-13, 2.535e-13, 2.108e-13, 1.754e-13, 1.459e-13, 1.213e-13, 1.009e-13]),
		CE(j=34, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.697e-13, 3.075e-13, 2.558e-13, 2.127e-13, 1.769e-13, 1.472e-13, 1.224e-13, 1.018e-13, 8.469e-14, 7.045e-14, 5.859e-14, 4.874e-14, 4.054e-14]),
		CE(j=35, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.8e-14, 8.151e-14, 6.78e-14, 5.639e-14, 4.69e-14, 3.901e-14, 3.245e-14, 2.699e-14, 2.245e-14, 1.867e-14, 1.553e-14, 1.292e-14, 1.075e-14]),
		CE(j=36, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.678e-14, 8.05e-14, 6.695e-14, 5.569e-14, 4.632e-14, 3.853e-14, 3.205e-14, 2.666e-14, 2.217e-14, 1.844e-14, 1.534e-14, 1.276e-14, 1.061e-14]),
		CE(j=37, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.612e-14, 7.995e-14, 6.65e-14, 5.531e-14, 4.6e-14, 3.826e-14, 3.183e-14, 2.647e-14, 2.202e-14, 1.831e-14, 1.523e-14, 1.267e-14, 1.054e-14]),
		CE(j=40, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.757e-16, 3.957e-16, 3.291e-16, 2.737e-16, 2.277e-16, 1.894e-16, 1.575e-16, 1.31e-16, 1.09e-16, 9.065e-17, 7.54e-17, 6.271e-17, 5.216e-17]),
		CE(j=41, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.751e-16, 3.951e-16, 3.287e-16, 2.734e-16, 2.274e-16, 1.891e-16, 1.573e-16, 1.308e-16, 1.088e-16, 9.052e-17, 7.529e-17, 6.263e-17, 5.209e-17]),
		CE(j=42, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.743e-16, 3.945e-16, 3.281e-16, 2.729e-16, 2.27e-16, 1.888e-16, 1.57e-16, 1.306e-16, 1.087e-16, 9.037e-17, 7.517e-17, 6.252e-17, 5.2e-17]),
		CE(j=43, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.121e-16, 3.428e-16, 2.851e-16, 2.371e-16, 1.972e-16, 1.641e-16, 1.365e-16, 1.135e-16, 9.44e-17, 7.852e-17, 6.531e-17, 5.432e-17, 4.518e-17]),
		CE(j=31, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.385e-10, 1.152e-10, 9.585e-11, 7.973e-11, 6.631e-11, 5.516e-11, 4.588e-11, 3.816e-11, 3.174e-11, 2.64e-11, 2.196e-11, 1.826e-11, 1.519e-11]),
		CE(j=32, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.406e-11, 4.496e-11, 3.74e-11, 3.111e-11, 2.587e-11, 2.152e-11, 1.79e-11, 1.489e-11, 1.238e-11, 1.03e-11, 8.567e-12, 7.126e-12, 5.927e-12]),
		CE(j=33, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.223e-12, 1.017e-12, 8.462e-13, 7.038e-13, 5.854e-13, 4.869e-13, 4.05e-13, 3.369e-13, 2.802e-13, 2.331e-13, 1.938e-13, 1.612e-13, 1.341e-13]),
		CE(j=34, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.336e-13, 3.606e-13, 2.999e-13, 2.495e-13, 2.075e-13, 1.726e-13, 1.436e-13, 1.194e-13, 9.932e-14, 8.261e-14, 6.871e-14, 5.715e-14, 4.754e-14]),
		CE(j=35, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.051e-13, 8.746e-14, 7.274e-14, 6.051e-14, 5.033e-14, 4.186e-14, 3.482e-14, 2.896e-14, 2.409e-14, 2.004e-14, 1.666e-14, 1.386e-14, 1.153e-14]),
		CE(j=36, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.038e-13, 8.632e-14, 7.18e-14, 5.972e-14, 4.967e-14, 4.132e-14, 3.437e-14, 2.858e-14, 2.378e-14, 1.978e-14, 1.645e-14, 1.368e-14, 1.138e-14]),
		CE(j=37, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.03e-13, 8.571e-14, 7.129e-14, 5.93e-14, 4.932e-14, 4.102e-14, 3.412e-14, 2.838e-14, 2.361e-14, 1.963e-14, 1.633e-14, 1.358e-14, 1.13e-14]),
		CE(j=40, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.771e-16, 3.968e-16, 3.301e-16, 2.745e-16, 2.284e-16, 1.899e-16, 1.58e-16, 1.314e-16, 1.093e-16, 9.091e-17, 7.561e-17, 6.289e-17, 5.231e-17]),
		CE(j=41, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.764e-16, 3.963e-16, 3.296e-16, 2.742e-16, 2.28e-16, 1.897e-16, 1.578e-16, 1.312e-16, 1.091e-16, 9.078e-17, 7.551e-17, 6.281e-17, 5.224e-17]),
		CE(j=42, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.757e-16, 3.956e-16, 3.291e-16, 2.737e-16, 2.277e-16, 1.894e-16, 1.575e-16, 1.31e-16, 1.09e-16, 9.063e-17, 7.539e-17, 6.27e-17, 5.215e-17]),
		CE(j=43, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.132e-16, 3.437e-16, 2.858e-16, 2.378e-16, 1.978e-16, 1.645e-16, 1.368e-16, 1.138e-16, 9.465e-17, 7.873e-17, 6.548e-17, 5.447e-17, 4.53e-17]),
		CE(j=32, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.241e-10, 1.864e-10, 1.55e-10, 1.29e-10, 1.073e-10, 8.922e-11, 7.421e-11, 6.173e-11, 5.134e-11, 4.27e-11, 3.552e-11, 2.954e-11, 2.457e-11]),
		CE(j=33, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.357e-12, 1.129e-12, 9.387e-13, 7.808e-13, 6.494e-13, 5.402e-13, 4.493e-13, 3.737e-13, 3.108e-13, 2.585e-13, 2.15e-13, 1.789e-13, 1.488e-13]),
		CE(j=34, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.581e-13, 3.811e-13, 3.17e-13, 2.636e-13, 2.193e-13, 1.824e-13, 1.517e-13, 1.262e-13, 1.05e-13, 8.73e-14, 7.261e-14, 6.039e-14, 5.023e-14]),
		CE(j=35, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.076e-13, 8.954e-14, 7.447e-14, 6.195e-14, 5.152e-14, 4.286e-14, 3.565e-14, 2.965e-14, 2.466e-14, 2.051e-14, 1.706e-14, 1.419e-14, 1.18e-14]),
		CE(j=36, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.062e-13, 8.836e-14, 7.35e-14, 6.113e-14, 5.085e-14, 4.229e-14, 3.518e-14, 2.926e-14, 2.434e-14, 2.024e-14, 1.684e-14, 1.4e-14, 1.165e-14]),
		CE(j=37, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.055e-13, 8.772e-14, 7.296e-14, 6.069e-14, 5.048e-14, 4.199e-14, 3.492e-14, 2.905e-14, 2.416e-14, 2.01e-14, 1.672e-14, 1.39e-14, 1.156e-14]),
		CE(j=40, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.775e-16, 3.972e-16, 3.304e-16, 2.748e-16, 2.286e-16, 1.901e-16, 1.581e-16, 1.315e-16, 1.094e-16, 9.099e-17, 7.569e-17, 6.295e-17, 5.236e-17]),
		CE(j=41, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.769e-16, 3.967e-16, 3.299e-16, 2.744e-16, 2.283e-16, 1.899e-16, 1.579e-16, 1.313e-16, 1.092e-16, 9.087e-17, 7.558e-17, 6.287e-17, 5.229e-17]),
		CE(j=42, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.761e-16, 3.96e-16, 3.294e-16, 2.74e-16, 2.279e-16, 1.895e-16, 1.577e-16, 1.311e-16, 1.091e-16, 9.072e-17, 7.546e-17, 6.276e-17, 5.22e-17]),
		CE(j=43, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.135e-16, 3.44e-16, 2.861e-16, 2.38e-16, 1.979e-16, 1.646e-16, 1.369e-16, 1.139e-16, 9.474e-17, 7.88e-17, 6.554e-17, 5.451e-17, 4.534e-17]),
		CE(j=33, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.473e-12, 1.225e-12, 1.019e-12, 8.478e-13, 7.052e-13, 5.865e-13, 4.878e-13, 4.058e-13, 3.375e-13, 2.807e-13, 2.335e-13, 1.942e-13, 1.615e-13]),
		CE(j=34, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.781e-13, 3.977e-13, 3.308e-13, 2.751e-13, 2.288e-13, 1.903e-13, 1.583e-13, 1.317e-13, 1.095e-13, 9.11e-14, 7.577e-14, 6.303e-14, 5.242e-14]),
		CE(j=35, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.096e-13, 9.115e-14, 7.582e-14, 6.306e-14, 5.245e-14, 4.363e-14, 3.629e-14, 3.018e-14, 2.511e-14, 2.088e-14, 1.737e-14, 1.445e-14, 1.202e-14]),
		CE(j=36, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.081e-13, 8.994e-14, 7.481e-14, 6.223e-14, 5.176e-14, 4.305e-14, 3.581e-14, 2.978e-14, 2.477e-14, 2.06e-14, 1.714e-14, 1.426e-14, 1.186e-14]),
		CE(j=37, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.073e-13, 8.929e-14, 7.426e-14, 6.177e-14, 5.138e-14, 4.273e-14, 3.555e-14, 2.957e-14, 2.459e-14, 2.045e-14, 1.701e-14, 1.415e-14, 1.177e-14]),
		CE(j=40, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.779e-16, 3.975e-16, 3.306e-16, 2.75e-16, 2.287e-16, 1.902e-16, 1.582e-16, 1.316e-16, 1.095e-16, 9.106e-17, 7.574e-17, 6.3e-17, 5.24e-17]),
		CE(j=41, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.772e-16, 3.969e-16, 3.302e-16, 2.746e-16, 2.284e-16, 1.9e-16, 1.58e-16, 1.314e-16, 1.093e-16, 9.093e-17, 7.563e-17, 6.291e-17, 5.233e-17]),
		CE(j=42, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.764e-16, 3.963e-16, 3.296e-16, 2.742e-16, 2.28e-16, 1.897e-16, 1.578e-16, 1.312e-16, 1.091e-16, 9.078e-17, 7.551e-17, 6.281e-17, 5.224e-17]),
		CE(j=43, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.138e-16, 3.442e-16, 2.863e-16, 2.381e-16, 1.981e-16, 1.647e-16, 1.37e-16, 1.14e-16, 9.48e-17, 7.885e-17, 6.558e-17, 5.455e-17, 4.537e-17]),
		CE(j=34, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.595e-12, 1.326e-12, 1.103e-12, 9.176e-13, 7.632e-13, 6.348e-13, 5.28e-13, 4.392e-13, 3.653e-13, 3.038e-13, 2.527e-13, 2.102e-13, 1.748e-13]),
		CE(j=35, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.639e-13, 1.363e-13, 1.134e-13, 9.429e-14, 7.843e-14, 6.524e-14, 5.426e-14, 4.513e-14, 3.754e-14, 3.122e-14, 2.597e-14, 2.16e-14, 1.797e-14]),
		CE(j=36, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.611e-13, 1.34e-13, 1.115e-13, 9.271e-14, 7.711e-14, 6.414e-14, 5.335e-14, 4.437e-14, 3.691e-14, 3.07e-14, 2.553e-14, 2.124e-14, 1.767e-14]),
		CE(j=37, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.596e-13, 1.328e-13, 1.104e-13, 9.185e-14, 7.64e-14, 6.354e-14, 5.285e-14, 4.396e-14, 3.657e-14, 3.041e-14, 2.53e-14, 2.104e-14, 1.75e-14]),
		CE(j=40, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.847e-16, 4.031e-16, 3.353e-16, 2.789e-16, 2.32e-16, 1.93e-16, 1.605e-16, 1.335e-16, 1.11e-16, 9.235e-17, 7.682e-17, 6.389e-17, 5.314e-17]),
		CE(j=41, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.84e-16, 4.026e-16, 3.349e-16, 2.785e-16, 2.317e-16, 1.927e-16, 1.603e-16, 1.333e-16, 1.109e-16, 9.223e-17, 7.671e-17, 6.381e-17, 5.307e-17]),
		CE(j=42, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.832e-16, 4.019e-16, 3.343e-16, 2.781e-16, 2.313e-16, 1.924e-16, 1.6e-16, 1.331e-16, 1.107e-16, 9.207e-17, 7.658e-17, 6.37e-17, 5.298e-17]),
		CE(j=43, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.192e-16, 3.487e-16, 2.9e-16, 2.412e-16, 2.006e-16, 1.669e-16, 1.388e-16, 1.155e-16, 9.603e-17, 7.988e-17, 6.644e-17, 5.526e-17, 4.597e-17]),
		CE(j=35, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.706e-13, 2.251e-13, 1.872e-13, 1.557e-13, 1.295e-13, 1.077e-13, 8.96e-14, 7.453e-14, 6.199e-14, 5.156e-14, 4.289e-14, 3.567e-14, 2.967e-14]),
		CE(j=36, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.645e-13, 2.2e-13, 1.83e-13, 1.522e-13, 1.266e-13, 1.053e-13, 8.758e-14, 7.285e-14, 6.059e-14, 5.04e-14, 4.192e-14, 3.487e-14, 2.9e-14]),
		CE(j=37, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.612e-13, 2.173e-13, 1.807e-13, 1.503e-13, 1.25e-13, 1.04e-13, 8.649e-14, 7.194e-14, 5.984e-14, 4.977e-14, 4.14e-14, 3.443e-14, 2.864e-14]),
		CE(j=40, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.913e-16, 4.087e-16, 3.399e-16, 2.827e-16, 2.352e-16, 1.956e-16, 1.627e-16, 1.353e-16, 1.126e-16, 9.362e-17, 7.787e-17, 6.477e-17, 5.387e-17]),
		CE(j=41, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.906e-16, 4.081e-16, 3.394e-16, 2.823e-16, 2.348e-16, 1.953e-16, 1.625e-16, 1.351e-16, 1.124e-16, 9.349e-17, 7.776e-17, 6.468e-17, 5.38e-17]),
		CE(j=42, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.898e-16, 4.074e-16, 3.389e-16, 2.819e-16, 2.344e-16, 1.95e-16, 1.622e-16, 1.349e-16, 1.122e-16, 9.333e-17, 7.763e-17, 6.457e-17, 5.371e-17]),
		CE(j=43, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.245e-16, 3.531e-16, 2.937e-16, 2.443e-16, 2.032e-16, 1.69e-16, 1.406e-16, 1.169e-16, 9.724e-17, 8.088e-17, 6.727e-17, 5.596e-17, 4.654e-17]),
		CE(j=36, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.661e-10, 3.045e-10, 2.533e-10, 2.107e-10, 1.752e-10, 1.457e-10, 1.212e-10, 1.008e-10, 8.386e-11, 6.976e-11, 5.802e-11, 4.826e-11, 4.014e-11]),
		CE(j=37, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.749e-10, 1.455e-10, 1.21e-10, 1.006e-10, 8.37e-11, 6.962e-11, 5.791e-11, 4.816e-11, 4.006e-11, 3.332e-11, 2.772e-11, 2.305e-11, 1.917e-11]),
		CE(j=40, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.112e-16, 4.252e-16, 3.537e-16, 2.942e-16, 2.447e-16, 2.035e-16, 1.693e-16, 1.408e-16, 1.171e-16, 9.741e-17, 8.102e-17, 6.739e-17, 5.605e-17]),
		CE(j=41, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.105e-16, 4.246e-16, 3.532e-16, 2.938e-16, 2.443e-16, 2.032e-16, 1.69e-16, 1.406e-16, 1.169e-16, 9.727e-17, 8.091e-17, 6.73e-17, 5.597e-17]),
		CE(j=42, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.096e-16, 4.239e-16, 3.526e-16, 2.933e-16, 2.439e-16, 2.029e-16, 1.687e-16, 1.404e-16, 1.167e-16, 9.711e-17, 8.077e-17, 6.718e-17, 5.588e-17]),
		CE(j=43, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.402e-16, 3.661e-16, 3.045e-16, 2.533e-16, 2.107e-16, 1.752e-16, 1.458e-16, 1.212e-16, 1.008e-16, 8.388e-17, 6.976e-17, 5.803e-17, 4.827e-17]),
		CE(j=37, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.924e-10, 8.254e-10, 6.866e-10, 5.711e-10, 4.75e-10, 3.951e-10, 3.286e-10, 2.733e-10, 2.273e-10, 1.891e-10, 1.573e-10, 1.308e-10, 1.088e-10]),
		CE(j=40, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.115e-16, 4.255e-16, 3.539e-16, 2.943e-16, 2.448e-16, 2.036e-16, 1.694e-16, 1.409e-16, 1.172e-16, 9.747e-17, 8.107e-17, 6.743e-17, 5.609e-17]),
		CE(j=41, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.108e-16, 4.248e-16, 3.534e-16, 2.939e-16, 2.445e-16, 2.033e-16, 1.691e-16, 1.407e-16, 1.17e-16, 9.733e-17, 8.095e-17, 6.733e-17, 5.601e-17]),
		CE(j=42, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.099e-16, 4.241e-16, 3.528e-16, 2.934e-16, 2.441e-16, 2.03e-16, 1.688e-16, 1.404e-16, 1.168e-16, 9.716e-17, 8.081e-17, 6.722e-17, 5.591e-17]),
		CE(j=43, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.404e-16, 3.663e-16, 3.047e-16, 2.534e-16, 2.108e-16, 1.753e-16, 1.458e-16, 1.213e-16, 1.009e-16, 8.392e-17, 6.98e-17, 5.806e-17, 4.829e-17]),
		CE(j=40, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.117e-16, 4.256e-16, 3.54e-16, 2.944e-16, 2.449e-16, 2.037e-16, 1.694e-16, 1.409e-16, 1.172e-16, 9.75e-17, 8.109e-17, 6.745e-17, 5.61e-17]),
		CE(j=41, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.109e-16, 4.25e-16, 3.535e-16, 2.94e-16, 2.445e-16, 2.034e-16, 1.692e-16, 1.407e-16, 1.17e-16, 9.736e-17, 8.098e-17, 6.735e-17, 5.602e-17]),
		CE(j=42, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.101e-16, 4.242e-16, 3.529e-16, 2.935e-16, 2.441e-16, 2.031e-16, 1.689e-16, 1.405e-16, 1.168e-16, 9.719e-17, 8.084e-17, 6.724e-17, 5.593e-17]),
		CE(j=43, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.405e-16, 3.664e-16, 3.048e-16, 2.535e-16, 2.109e-16, 1.754e-16, 1.459e-16, 1.213e-16, 1.009e-16, 8.394e-17, 6.982e-17, 5.807e-17, 4.83e-17]),
		Omega(j=39, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05, 1.717e-05]),
		Omega(j=44, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07, 6.65e-07]),
		Omega(j=45, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08, 4.106e-08]),
		Omega(j=46, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482, 1.482]),
		Omega(j=47, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514, 0.8514]),
		Omega(j=48, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096, 1.096]),
		Omega(j=49, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502, 0.8502]),
		Omega(j=50, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858, 1.858]),
		Omega(j=51, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286, 0.9286]),
		Omega(j=52, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223, 0.0223]),
		Omega(j=53, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843, 0.4843]),
		Omega(j=54, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842, 0.4842]),
		Omega(j=55, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492, 0.4492]),
		Omega(j=56, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424]),
		Omega(j=57, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424]),
		Omega(j=58, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781, 0.3781]),
		Omega(j=59, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378, 0.378]),
		Omega(j=44, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07, 7.912e-07]),
		Omega(j=45, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07, 1.264e-07]),
		Omega(j=46, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06, 1.56e-06]),
		Omega(j=47, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975, 1.975]),
		Omega(j=48, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183, 0.2183]),
		Omega(j=49, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696, 1.696]),
		Omega(j=50, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411, 0.9411]),
		Omega(j=51, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665, 4.665]),
		Omega(j=52, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718, 0.06718]),
		Omega(j=53, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969]),
		Omega(j=54, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969, 0.969]),
		Omega(j=55, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987, 0.8987]),
		Omega(j=56, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483]),
		Omega(j=57, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483, 0.8483]),
		Omega(j=58, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564, 0.7564]),
		Omega(j=59, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563, 0.7563]),
		CE(j=41, i=40, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.303e-11, 6.075e-11, 5.053e-11, 4.203e-11, 3.496e-11, 2.908e-11, 2.418e-11, 2.012e-11, 1.673e-11, 1.392e-11, 1.158e-11, 9.628e-12, 8.008e-12]),
		CE(j=42, i=40, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.945e-11, 1.618e-11, 1.346e-11, 1.119e-11, 9.309e-12, 7.743e-12, 6.44e-12, 5.357e-12, 4.455e-12, 3.706e-12, 3.082e-12, 2.564e-12, 2.133e-12]),
		CE(j=43, i=40, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.757e-14, 2.293e-14, 1.907e-14, 1.587e-14, 1.32e-14, 1.098e-14, 9.13e-15, 7.594e-15, 6.316e-15, 5.254e-15, 4.37e-15, 3.635e-15, 3.023e-15]),
		CE(j=42, i=41, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.391e-11, 4.484e-11, 3.73e-11, 3.102e-11, 2.58e-11, 2.146e-11, 1.785e-11, 1.485e-11, 1.235e-11, 1.027e-11, 8.544e-12, 7.107e-12, 5.911e-12]),
		CE(j=43, i=41, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.8e-14, 2.329e-14, 1.937e-14, 1.611e-14, 1.34e-14, 1.115e-14, 9.272e-15, 7.712e-15, 6.415e-15, 5.336e-15, 4.438e-15, 3.691e-15, 3.07e-15]),
		CE(j=43, i=42, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.853e-14, 2.373e-14, 1.974e-14, 1.642e-14, 1.366e-14, 1.136e-14, 9.447e-15, 7.858e-15, 6.536e-15, 5.436e-15, 4.522e-15, 3.761e-15, 3.128e-15]),
		Omega(j=45, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0, 2900.0]),
		Omega(j=46, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0, 1268.0]),
		Omega(j=47, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998]),
		Omega(j=48, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998, 1.998]),
		Omega(j=49, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193, 1.193]),
		Omega(j=50, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434, 0.9434]),
		Omega(j=51, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428, 0.9428]),
		Omega(j=52, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675, 0.8675]),
		Omega(j=53, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719, 0.719]),
		Omega(j=54, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189, 0.7189]),
		Omega(j=55, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134, 1.134]),
		Omega(j=56, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936]),
		Omega(j=57, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936, 0.5936]),
		Omega(j=58, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074, 0.5074]),
		Omega(j=59, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073, 0.5073]),
		Omega(j=46, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0, 4508.0]),
		Omega(j=47, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999]),
		Omega(j=48, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999, 3.999]),
		Omega(j=49, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386, 2.386]),
		Omega(j=50, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887, 1.887]),
		Omega(j=51, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886, 1.886]),
		Omega(j=52, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736, 1.736]),
		Omega(j=53, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438]),
		Omega(j=54, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438, 1.438]),
		Omega(j=55, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267, 2.267]),
		Omega(j=56, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188, 1.188]),
		Omega(j=57, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187, 1.187]),
		Omega(j=58, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015]),
		Omega(j=59, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015, 1.015]),
		Omega(j=47, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004, 6.004]),
		Omega(j=48, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003, 6.003]),
		Omega(j=49, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581, 3.581]),
		Omega(j=50, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832, 2.832]),
		Omega(j=51, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831]),
		Omega(j=52, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604, 2.604]),
		Omega(j=53, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158]),
		Omega(j=54, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158, 2.158]),
		Omega(j=55, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413, 3.413]),
		Omega(j=56, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782]),
		Omega(j=57, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782, 1.782]),
		Omega(j=58, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523]),
		Omega(j=59, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523, 1.523]),
		Omega(j=48, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0, 75940.0]),
		Omega(j=49, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875, 8.875]),
		Omega(j=50, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362, 5.362]),
		Omega(j=51, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355, 5.355]),
		Omega(j=52, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6, 4.6]),
		Omega(j=53, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37, 3.37]),
		Omega(j=54, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369, 3.369]),
		Omega(j=55, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852, 2.852]),
		Omega(j=56, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137, 3.137]),
		Omega(j=57, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263, 0.2263]),
		Omega(j=58, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04, 2.04]),
		Omega(j=59, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611, 3.611]),
		Omega(j=49, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917, 5.917]),
		Omega(j=50, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575, 3.575]),
		Omega(j=51, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571, 3.571]),
		Omega(j=52, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067, 3.067]),
		Omega(j=53, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247, 2.247]),
		Omega(j=54, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246, 2.246]),
		Omega(j=55, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902, 1.902]),
		Omega(j=56, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225, 0.225]),
		Omega(j=57, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01, 2.01]),
		Omega(j=58, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032, 2.032]),
		Omega(j=59, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137, 0.4137]),
		Omega(j=50, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515, 4.515]),
		Omega(j=51, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501, 4.501]),
		Omega(j=52, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183, 3.183]),
		Omega(j=53, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654, 0.7654]),
		Omega(j=54, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573, 1.573]),
		Omega(j=55, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401]),
		Omega(j=56, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182]),
		Omega(j=57, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182, 1.182]),
		Omega(j=58, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411, 0.2411]),
		Omega(j=59, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714, 0.5714]),
		Omega(j=51, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0, 1541.0]),
		Omega(j=52, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79, 10.79]),
		Omega(j=53, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436, 0.005436]),
		Omega(j=54, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683, 0.001683]),
		Omega(j=55, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07, 9.202e-07]),
		Omega(j=56, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601, 1.601]),
		Omega(j=57, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627, 1.627]),
		Omega(j=58, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614, 1.614]),
		Omega(j=59, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973, 0.6973]),
		Omega(j=52, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73, 21.73]),
		Omega(j=53, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294, 0.002294]),
		Omega(j=54, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172, 0.01172]),
		Omega(j=55, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06, 4.764e-06]),
		Omega(j=56, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927, 2.927]),
		Omega(j=57, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215, 0.3215]),
		Omega(j=58, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644, 0.7644]),
		Omega(j=59, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875, 3.875]),
		Omega(j=53, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829, 9.829]),
		Omega(j=54, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61, 19.61]),
		Omega(j=55, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503, 2.503]),
		Omega(j=56, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88]),
		Omega(j=57, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88]),
		Omega(j=58, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222]),
		Omega(j=59, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222, 1.222]),
		Omega(j=54, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0, 5721.0]),
		Omega(j=55, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192, 6.192]),
		Omega(j=56, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405, 3.405]),
		Omega(j=57, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404, 3.404]),
		Omega(j=58, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724, 1.724]),
		Omega(j=59, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723, 1.723]),
		Omega(j=55, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4, 12.4]),
		Omega(j=56, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813, 6.813]),
		Omega(j=57, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811, 6.811]),
		Omega(j=58, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449, 3.449]),
		Omega(j=59, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447, 3.447]),
		Omega(j=56, i=55, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13, 15.13]),
		Omega(j=57, i=55, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12, 15.12]),
		Omega(j=58, i=55, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778, 4.778]),
		Omega(j=59, i=55, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775, 4.775]),
		Omega(j=57, i=56, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0, 37450.0]),
		Omega(j=58, i=56, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48, 10.48]),
		Omega(j=59, i=56, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47, 10.47]),
		Omega(j=58, i=57, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986, 6.986]),
		Omega(j=59, i=57, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979, 6.979]),
		Omega(j=59, i=58, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0, 3399.0]),
		Omega(j=61, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091, 0.6091]),
		Omega(j=62, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06, 1.037e-06]),
		Omega(j=63, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11, 8.642e-11]),
		Omega(j=64, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367, 2.367]),
		Omega(j=65, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321, 0.2321]),
		Omega(j=66, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232]),
		Omega(j=67, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232, 0.232]),
		Omega(j=68, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187, 0.2187]),
		Omega(j=69, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748, 0.1748]),
		Omega(j=70, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339, 0.1339]),
		Omega(j=71, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129, 0.129]),
		Omega(j=72, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967, 0.2967]),
		Omega(j=73, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228]),
		Omega(j=74, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05, 4.242e-05]),
		Omega(j=75, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228, 0.1228]),
		Omega(j=76, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181]),
		Omega(j=77, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181]),
		Omega(j=78, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181, 0.1181]),
		Omega(j=79, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154, 0.1154]),
		Omega(j=62, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0, 1346.0]),
		Omega(j=63, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5, 398.5]),
		Omega(j=64, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381, 0.6381]),
		Omega(j=65, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375, 0.375]),
		Omega(j=66, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027]),
		Omega(j=67, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747, 0.3747]),
		Omega(j=68, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411, 0.3411]),
		Omega(j=69, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451, 0.2451]),
		Omega(j=70, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916, 0.0916]),
		Omega(j=71, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637, 0.1637]),
		Omega(j=72, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544, 0.1544]),
		Omega(j=73, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538]),
		Omega(j=74, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538]),
		Omega(j=75, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538, 0.1538]),
		Omega(j=76, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217, 0.8217]),
		Omega(j=77, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466, 0.1466]),
		Omega(j=78, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465, 0.1465]),
		Omega(j=79, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423, 0.1423]),
		Omega(j=63, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05, 3.272e-05]),
		Omega(j=64, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915, 1.915]),
		Omega(j=65, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027, 1.027]),
		Omega(j=66, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702, 0.7702]),
		Omega(j=67, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284]),
		Omega(j=68, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05, 1.452e-05]),
		Omega(j=69, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353, 0.7353]),
		Omega(j=70, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275, 0.275]),
		Omega(j=71, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913, 0.4913]),
		Omega(j=72, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633, 0.4633]),
		Omega(j=73, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616, 0.4616]),
		Omega(j=74, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615]),
		Omega(j=75, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615, 0.4615]),
		Omega(j=76, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165, 0.6165]),
		Omega(j=77, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849, 1.849]),
		Omega(j=78, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397, 0.4397]),
		Omega(j=79, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427, 0.427]),
		Omega(j=64, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196, 3.196]),
		Omega(j=65, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877, 1.877]),
		Omega(j=66, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284, 1.284]),
		Omega(j=67, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851, 3.851]),
		Omega(j=68, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05, 9.289e-05]),
		Omega(j=69, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226, 1.226]),
		Omega(j=70, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459, 0.459]),
		Omega(j=71, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819, 0.819]),
		Omega(j=72, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724, 0.7724]),
		Omega(j=73, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695]),
		Omega(j=74, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695, 0.7695]),
		Omega(j=75, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694, 0.7694]),
		Omega(j=76, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112, 0.04112]),
		Omega(j=77, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168, 0.6168]),
		Omega(j=78, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455, 3.455]),
		Omega(j=79, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119, 0.7119]),
		Omega(j=65, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728, 2.728]),
		Omega(j=66, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726, 2.726]),
		Omega(j=67, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722, 2.722]),
		Omega(j=68, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03, 4.03]),
		Omega(j=69, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948, 1.948]),
		Omega(j=70, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043, 0.7043]),
		Omega(j=71, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345, 0.1345]),
		Omega(j=72, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111, 0.6111]),
		Omega(j=73, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081]),
		Omega(j=74, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081, 0.6081]),
		Omega(j=75, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608, 0.608]),
		Omega(j=76, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707]),
		Omega(j=77, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707]),
		Omega(j=78, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707, 0.5707]),
		Omega(j=79, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831, 2.831]),
		Omega(j=66, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0, 1111.0]),
		Omega(j=67, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0]),
		Omega(j=68, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774, 3.774]),
		Omega(j=69, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073, 0.7073]),
		Omega(j=70, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165, 0.3165]),
		Omega(j=71, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906, 0.2906]),
		Omega(j=72, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625, 0.2625]),
		Omega(j=73, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608]),
		Omega(j=74, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496, 0.0005496]),
		Omega(j=75, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608, 0.2608]),
		Omega(j=76, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406]),
		Omega(j=77, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406]),
		Omega(j=78, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406, 0.2406]),
		Omega(j=79, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294]),
		Omega(j=67, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0, 2010.0]),
		Omega(j=68, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36, 11.36]),
		Omega(j=69, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123, 2.123]),
		Omega(j=70, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497, 0.9497]),
		Omega(j=71, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721, 0.8721]),
		Omega(j=72, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877, 0.7877]),
		Omega(j=73, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451, 0.0005451]),
		Omega(j=74, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108, 0.0004108]),
		Omega(j=75, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945, 0.0006945]),
		Omega(j=76, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219]),
		Omega(j=77, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219, 0.7219]),
		Omega(j=78, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218, 0.7218]),
		Omega(j=79, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883, 0.6883]),
		Omega(j=68, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04, 19.04]),
		Omega(j=69, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543, 3.543]),
		Omega(j=70, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584, 1.584]),
		Omega(j=71, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454, 1.454]),
		Omega(j=72, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313, 1.313]),
		Omega(j=73, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305, 1.305]),
		Omega(j=74, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802, 0.0006802]),
		Omega(j=75, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076, 0.002076]),
		Omega(j=76, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204]),
		Omega(j=77, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204]),
		Omega(j=78, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204, 1.204]),
		Omega(j=79, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148, 1.148]),
		Omega(j=69, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352, 4.352]),
		Omega(j=70, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727, 1.727]),
		Omega(j=71, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574, 1.574]),
		Omega(j=72, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563, 0.3563]),
		Omega(j=73, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401]),
		Omega(j=74, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05, 6.094e-05]),
		Omega(j=75, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401, 1.401]),
		Omega(j=76, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285]),
		Omega(j=77, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285]),
		Omega(j=78, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285, 1.285]),
		Omega(j=79, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221, 1.221]),
		Omega(j=70, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727, 0.5727]),
		Omega(j=71, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934, 0.4934]),
		Omega(j=72, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069]),
		Omega(j=73, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132, 0.4132]),
		Omega(j=74, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05, 1.009e-05]),
		Omega(j=75, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131, 0.4131]),
		Omega(j=76, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646]),
		Omega(j=77, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646, 0.3646]),
		Omega(j=78, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645, 0.3645]),
		Omega(j=79, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395, 0.3395]),
		Omega(j=71, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68, 10.68]),
		Omega(j=72, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619, 4.619]),
		Omega(j=73, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463, 3.463]),
		Omega(j=74, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39, 10.39]),
		Omega(j=75, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32, 17.32]),
		Omega(j=76, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009]),
		Omega(j=77, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009]),
		Omega(j=78, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009, 3.009]),
		Omega(j=79, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5]),
		Omega(j=72, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966, 8.966]),
		Omega(j=73, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545, 2.545]),
		Omega(j=74, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399, 0.001399]),
		Omega(j=75, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541, 2.541]),
		Omega(j=76, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396]),
		Omega(j=77, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396]),
		Omega(j=78, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396, 1.396]),
		Omega(j=79, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088, 1.088]),
		Omega(j=73, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6, 123.6]),
		Omega(j=74, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7, 122.7]),
		Omega(j=75, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7, 120.7]),
		Omega(j=76, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636]),
		Omega(j=77, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636, 8.636]),
		Omega(j=78, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633, 8.633]),
		Omega(j=79, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91, 18.91]),
		Omega(j=74, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0, 5625.0]),
		Omega(j=75, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0, 1701.0]),
		Omega(j=76, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757, 5.757]),
		Omega(j=77, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095, 3.095]),
		Omega(j=78, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094, 3.094]),
		Omega(j=79, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901, 1.901]),
		Omega(j=75, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0, 7316.0]),
		Omega(j=76, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316, 4.316]),
		Omega(j=77, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95, 12.95]),
		Omega(j=78, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287, 9.287]),
		Omega(j=79, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705, 5.705]),
		Omega(j=76, i=75, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878, 0.2878]),
		Omega(j=77, i=75, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317, 4.317]),
		Omega(j=78, i=75, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19, 24.19]),
		Omega(j=79, i=75, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516, 9.516]),
		Omega(j=77, i=76, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0, 86990.0]),
		Omega(j=78, i=76, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0, 24470.0]),
		Omega(j=79, i=76, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78, 14.78]),
		Omega(j=78, i=77, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0, 56750.0]),
		Omega(j=79, i=77, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65, 24.65]),
		Omega(j=79, i=78, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52, 34.52]),
		Omega(j=81, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379, 0.9379]),
		Omega(j=82, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88, 1.88]),
		Omega(j=83, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106, 0.2106]),
		Omega(j=84, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327, 0.1327]),
		Omega(j=85, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665, 0.2665]),
		Omega(j=86, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964]),
		Omega(j=87, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964, 0.1964]),
		Omega(j=82, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3, 592.3]),
		Omega(j=83, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101, 0.101]),
		Omega(j=84, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496]),
		Omega(j=85, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496, 0.2496]),
		Omega(j=86, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603, 1.603]),
		Omega(j=87, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245, 0.245]),
		Omega(j=83, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015, 0.2015]),
		Omega(j=84, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994]),
		Omega(j=85, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994, 0.4994]),
		Omega(j=86, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321, 0.321]),
		Omega(j=87, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879, 2.879]),
		Omega(j=84, i=83, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709, 3.709]),
		Omega(j=85, i=83, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702, 3.702]),
		Omega(j=86, i=83, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896, 2.896]),
		Omega(j=87, i=83, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894, 2.894]),
		Omega(j=85, i=84, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0, 2019.0]),
		Omega(j=86, i=84, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21, 13.21]),
		Omega(j=87, i=84, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18, 13.18]),
		Omega(j=86, i=85, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59, 26.59]),
		Omega(j=87, i=85, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53, 26.53]),
		Omega(j=87, i=86, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0, 12150.0]),
		Omega(j=89, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12, 4.97e-12]),
		Omega(j=90, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08, 1.065e-08]),
		Omega(j=91, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06, 2.811e-06]),
		Omega(j=92, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299, 0.01299]),
		Omega(j=93, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09, 4.28e-09]),
		Omega(j=94, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306, 0.08306]),
		Omega(j=95, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123, 0.01123]),
		Omega(j=96, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119]),
		Omega(j=97, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119]),
		Omega(j=98, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119]),
		Omega(j=99, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119, 0.01119]),
		Omega(j=100, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116]),
		Omega(j=101, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116]),
		Omega(j=102, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116]),
		Omega(j=103, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116, 0.01116]),
		Omega(j=104, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564, 0.01564]),
		Omega(j=90, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187, 2.187]),
		Omega(j=91, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824, 0.9824]),
		Omega(j=92, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272, 0.3272]),
		Omega(j=93, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639, 1.639]),
		Omega(j=94, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327, 1.327]),
		Omega(j=95, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234, 0.2234]),
		Omega(j=96, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175, 0.2175]),
		Omega(j=97, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294, 0.2294]),
		Omega(j=98, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641, 0.07641]),
		Omega(j=99, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817, 0.3817]),
		Omega(j=100, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145]),
		Omega(j=101, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145]),
		Omega(j=102, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145, 0.2145]),
		Omega(j=103, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144, 0.2144]),
		Omega(j=104, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135, 0.2135]),
		Omega(j=91, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7, 252.7]),
		Omega(j=92, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9, 229.9]),
		Omega(j=93, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7, 121.7]),
		Omega(j=94, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038, 1.038]),
		Omega(j=95, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295, 0.08295]),
		Omega(j=96, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051, 0.08051]),
		Omega(j=97, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047]),
		Omega(j=98, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047]),
		Omega(j=99, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047, 0.08047]),
		Omega(j=100, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929]),
		Omega(j=101, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929]),
		Omega(j=102, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929, 0.07929]),
		Omega(j=103, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924, 0.07924]),
		Omega(j=104, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773, 0.2773]),
		Omega(j=92, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0, 7649.0]),
		Omega(j=93, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7, 704.7]),
		Omega(j=94, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391, 3.391]),
		Omega(j=95, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126, 0.01126]),
		Omega(j=96, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416, 0.2416]),
		Omega(j=97, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415]),
		Omega(j=98, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415]),
		Omega(j=99, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415, 0.2415]),
		Omega(j=100, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924, 0.3924]),
		Omega(j=101, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172, 1.172]),
		Omega(j=102, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379, 0.2379]),
		Omega(j=103, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378, 0.2378]),
		Omega(j=104, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367, 0.2367]),
		Omega(j=93, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7, 258.7]),
		Omega(j=94, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131, 1.131]),
		Omega(j=95, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125, 0.00125]),
		Omega(j=96, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054, 0.08054]),
		Omega(j=97, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049]),
		Omega(j=98, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049]),
		Omega(j=99, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049, 0.08049]),
		Omega(j=100, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198, 0.5198]),
		Omega(j=101, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932, 0.07932]),
		Omega(j=102, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931, 0.07931]),
		Omega(j=103, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927, 0.07927]),
		Omega(j=104, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891, 0.07891]),
		Omega(j=94, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679, 5.679]),
		Omega(j=95, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135, 0.03135]),
		Omega(j=96, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028, 0.4028]),
		Omega(j=97, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026]),
		Omega(j=98, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026]),
		Omega(j=99, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026, 0.4026]),
		Omega(j=100, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656, 0.02656]),
		Omega(j=101, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896, 0.3896]),
		Omega(j=102, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188, 2.188]),
		Omega(j=103, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965, 0.3965]),
		Omega(j=104, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947, 0.3947]),
		Omega(j=95, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686, 0.2686]),
		Omega(j=96, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533, 0.03533]),
		Omega(j=97, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26]),
		Omega(j=98, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26]),
		Omega(j=99, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26, 0.26]),
		Omega(j=100, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559]),
		Omega(j=101, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559]),
		Omega(j=102, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559, 0.2559]),
		Omega(j=103, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807, 1.807]),
		Omega(j=104, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545, 0.2545]),
		Omega(j=96, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236, 8.236]),
		Omega(j=97, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071]),
		Omega(j=98, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071]),
		Omega(j=99, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071, 8.071]),
		Omega(j=100, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393]),
		Omega(j=101, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393, 5.393]),
		Omega(j=102, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39, 5.39]),
		Omega(j=103, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326, 5.326]),
		Omega(j=104, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83, 4.83]),
		Omega(j=97, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0]),
		Omega(j=98, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0]),
		Omega(j=99, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0, 134.0]),
		Omega(j=100, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208]),
		Omega(j=101, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208, 5.208]),
		Omega(j=102, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199, 5.199]),
		Omega(j=103, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024, 5.024]),
		Omega(j=104, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892, 3.892]),
		Omega(j=100, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209, 2.209]),
		Omega(j=101, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611, 6.611]),
		Omega(j=102, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23, 16.23]),
		Omega(j=103, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66, 15.66]),
		Omega(j=104, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03, 12.03]),
		Omega(j=100, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934, 2.934]),
		Omega(j=101, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418, 5.418]),
		Omega(j=102, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409, 5.409]),
		Omega(j=103, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219, 5.219]),
		Omega(j=104, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009, 4.009]),
		Omega(j=100, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467, 0.1467]),
		Omega(j=101, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201, 2.201]),
		Omega(j=102, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27, 12.27]),
		Omega(j=103, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1, 26.1]),
		Omega(j=104, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04, 20.04]),
		Omega(j=102, i=100, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0, 9569.0]),
		Omega(j=103, i=100, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2, 427.2]),
		Omega(j=104, i=100, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23, 46.23]),
		Omega(j=102, i=101, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0, 15950.0]),
		Omega(j=103, i=101, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0, 712.0]),
		Omega(j=104, i=101, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04, 77.04]),
		Omega(j=103, i=102, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0, 1043.0]),
		Omega(j=104, i=102, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4, 108.4]),
		Omega(j=104, i=103, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39, 86.39]),
		Omega(j=106, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983, 0.02983]),
		Omega(j=107, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08, 1.409e-08]),
		Omega(j=108, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974, 0.05974]),
		Omega(j=109, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781, 0.004781]),
		Omega(j=110, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816]),
		Omega(j=111, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816]),
		Omega(j=112, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958, 0.00958]),
		Omega(j=113, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816, 0.01816]),
		Omega(j=107, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0, 2440.0]),
		Omega(j=108, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3, 134.3]),
		Omega(j=109, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162]),
		Omega(j=110, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579, 0.01579]),
		Omega(j=111, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082, 0.8082]),
		Omega(j=112, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162]),
		Omega(j=113, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161, 0.1161]),
		Omega(j=108, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1, 142.1]),
		Omega(j=109, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682, 0.1682]),
		Omega(j=110, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162]),
		Omega(j=111, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162]),
		Omega(j=112, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337, 0.337]),
		Omega(j=113, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162, 0.1162]),
		Omega(j=109, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326, 0.2326]),
		Omega(j=110, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161, 0.03161]),
		Omega(j=111, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618, 0.1618]),
		Omega(j=112, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325, 0.2325]),
		Omega(j=113, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456, 1.456]),
		Omega(j=110, i=109, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0, 8168.0]),
		Omega(j=111, i=109, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0, 454.0]),
		Omega(j=112, i=109, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3, 453.3]),
		Omega(j=113, i=109, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5, 340.5]),
		Omega(j=111, i=110, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8, 480.8]),
		Omega(j=112, i=110, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9, 479.9]),
		Omega(j=113, i=110, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3, 355.3]),
		Omega(j=112, i=111, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0, 554700.0]),
		Omega(j=113, i=111, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0, 2722.0]),
		Omega(j=113, i=112, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0, 2736.0]),
		CI(j=38, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17, 7.023e-17]),
		CI(j=39, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16]),
		CI(j=38, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17, 7.024e-17]),
		CI(j=39, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16]),
		CI(j=38, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17, 7.026e-17]),
		CI(j=39, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16, 1.399e-16]),
		CI(j=38, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17, 5.505e-17]),
		CI(j=39, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16, 1.102e-16]),
		CI(j=38, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17, 7.445e-17]),
		CI(j=39, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16, 1.486e-16]),
		CI(j=38, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16, 1.229e-16]),
		CI(j=39, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16, 2.451e-16]),
		CI(j=38, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18, 5.76e-18]),
		CI(j=39, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17]),
		CI(j=38, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18, 5.764e-18]),
		CI(j=39, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17, 1.15e-17]),
		CI(j=38, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18, 5.772e-18]),
		CI(j=39, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17, 1.152e-17]),
		CI(j=38, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17, 2.245e-17]),
		CI(j=39, i=9, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17, 4.473e-17]),
		CI(j=38, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17]),
		CI(j=39, i=10, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17]),
		CI(j=38, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17]),
		CI(j=39, i=11, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17]),
		CI(j=38, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17, 1.822e-17]),
		CI(j=39, i=12, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17, 3.631e-17]),
		CI(j=38, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17, 8.192e-17]),
		CI(j=39, i=13, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16, 1.634e-16]),
		CI(j=38, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17, 4.482e-17]),
		CI(j=39, i=14, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17, 8.947e-17]),
		CI(j=38, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17, 4.487e-17]),
		CI(j=39, i=15, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17, 8.956e-17]),
		CI(j=38, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17, 4.494e-17]),
		CI(j=39, i=16, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17, 8.971e-17]),
		CI(j=38, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17, 4.342e-17]),
		CI(j=39, i=17, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17, 8.667e-17]),
		CI(j=38, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17, 6.088e-17]),
		CI(j=39, i=18, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16]),
		CI(j=38, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17, 6.092e-17]),
		CI(j=39, i=19, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16, 1.214e-16]),
		CI(j=38, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17, 6.098e-17]),
		CI(j=39, i=20, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16, 1.216e-16]),
		CI(j=38, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17, 9.941e-17]),
		CI(j=39, i=21, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16, 1.987e-16]),
		CI(j=38, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16, 1.279e-16]),
		CI(j=39, i=22, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16, 2.549e-16]),
		CI(j=38, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16]),
		CI(j=39, i=23, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16]),
		CI(j=38, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16]),
		CI(j=39, i=24, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16]),
		CI(j=38, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16, 1.544e-16]),
		CI(j=39, i=25, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16, 3.068e-16]),
		CI(j=38, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16, 8.528e-16]),
		CI(j=39, i=26, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15, 1.763e-15]),
		CI(j=38, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16, 7.436e-16]),
		CI(j=39, i=27, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15, 1.58e-15]),
		CI(j=38, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16, 7.472e-16]),
		CI(j=39, i=28, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15, 1.582e-15]),
		CI(j=38, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16, 7.552e-16]),
		CI(j=39, i=29, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15, 1.595e-15]),
		CI(j=38, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16, 6.4e-16]),
		CI(j=39, i=30, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15, 1.395e-15]),
		CI(j=38, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16, 6.433e-16]),
		CI(j=39, i=31, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15, 1.397e-15]),
		CI(j=38, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16, 6.456e-16]),
		CI(j=39, i=32, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15, 1.381e-15]),
		CI(j=38, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16, 6.479e-16]),
		CI(j=39, i=33, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15, 1.413e-15]),
		CI(j=38, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16, 4.956e-16]),
		CI(j=39, i=34, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15, 1.108e-15]),
		CI(j=38, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16, 3.633e-16]),
		CI(j=39, i=35, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16, 7.812e-16]),
		CI(j=38, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16, 3.645e-16]),
		CI(j=39, i=36, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16, 7.836e-16]),
		CI(j=38, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16, 3.655e-16]),
		CI(j=39, i=37, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16, 7.839e-16]),
		CI(j=60, i=38, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17, 5.04e-17]),
		CI(j=60, i=39, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17, 5.041e-17]),
		CI(j=60, i=44, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16]),
		CI(j=60, i=45, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16]),
		CI(j=60, i=46, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16, 1.366e-16]),
		CI(j=60, i=47, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17, 1.343e-17]),
		CI(j=60, i=48, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17, 1.342e-17]),
		CI(j=60, i=49, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19, 4.195e-19]),
		CI(j=60, i=50, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19, 2.604e-19]),
		CI(j=60, i=51, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19, 2.606e-19]),
		CI(j=60, i=52, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17, 5.432e-17]),
		CI(j=60, i=53, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16]),
		CI(j=60, i=54, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16, 1.483e-16]),
		CI(j=60, i=55, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20, 2.623e-20]),
		CI(j=60, i=56, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19, 5.503e-19]),
		CI(j=60, i=57, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19, 5.551e-19]),
		CI(j=60, i=58, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16, 1.713e-16]),
		CI(j=60, i=59, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16, 1.721e-16]),
		CI(j=80, i=60, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17, 1.481e-17]),
		CI(j=80, i=61, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17]),
		CI(j=80, i=62, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17]),
		CI(j=80, i=63, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17, 1.878e-17]),
		CI(j=80, i=64, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17, 3.233e-17]),
		CI(j=80, i=65, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16, 1.961e-16]),
		CI(j=80, i=66, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16, 1.988e-16]),
		CI(j=80, i=67, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16, 2.014e-16]),
		CI(j=80, i=68, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16, 2.353e-16]),
		CI(j=80, i=69, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15, 1.426e-15]),
		CI(j=80, i=70, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17, 3.144e-17]),
		CI(j=80, i=71, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17, 1.829e-17]),
		CI(j=80, i=72, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17, 7.337e-17]),
		CI(j=80, i=73, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17, 7.535e-17]),
		CI(j=80, i=74, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17]),
		CI(j=80, i=75, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17, 7.536e-17]),
		CI(j=80, i=76, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17, 7.341e-17]),
		CI(j=80, i=77, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17]),
		CI(j=80, i=78, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17, 7.342e-17]),
		CI(j=80, i=79, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17, 3.122e-17]),
		CI(j=88, i=80, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18, 4.095e-18]),
		CI(j=88, i=81, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18, 6.596e-18]),
		CI(j=88, i=82, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18, 6.605e-18]),
		CI(j=88, i=83, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17, 1.576e-17]),
		CI(j=88, i=84, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17, 2.794e-17]),
		CI(j=88, i=85, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17, 2.795e-17]),
		CI(j=88, i=86, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17]),
		CI(j=88, i=87, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17, 1.887e-17]),
		CI(j=105, i=88, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19, 4.967e-19]),
		CI(j=105, i=89, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18, 2.238e-18]),
		CI(j=105, i=90, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18, 2.527e-18]),
		CI(j=105, i=91, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18]),
		CI(j=105, i=92, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18, 2.674e-18]),
		CI(j=105, i=93, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18, 2.679e-18]),
		CI(j=105, i=94, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18, 2.485e-18]),
		CI(j=105, i=95, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18, 8.713e-18]),
		CI(j=105, i=96, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18, 9.62e-18]),
		CI(j=105, i=97, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17]),
		CI(j=105, i=98, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17]),
		CI(j=105, i=99, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17, 1.123e-17]),
		CI(j=105, i=100, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18]),
		CI(j=105, i=101, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18, 7.746e-18]),
		CI(j=105, i=102, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18, 7.747e-18]),
		CI(j=105, i=103, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18, 7.646e-18]),
		CI(j=105, i=104, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17, 1.11e-17]),
		CI(j=114, i=105, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19, 1.431e-19]),
		CI(j=114, i=106, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18]),
		CI(j=114, i=107, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18, 1.341e-18]),
		CI(j=114, i=108, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18, 1.23e-18]),
		CI(j=114, i=109, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18, 5.323e-18]),
		CI(j=114, i=110, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18, 5.146e-18]),
		CI(j=114, i=111, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18, 3.704e-18]),
		CI(j=114, i=112, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18, 5.324e-18]),
		CI(j=114, i=113, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18, 3.705e-18]),
])

CI_fine_atom = lambda: \
AtomicModel(element=Element(Z=6),
	levels=[
		AtomicLevel(E=     0.000, g=1, label="C I 2S2 2P2  3PE 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=    16.400, g=3, label="C I 2S2 2P2  3PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=    43.400, g=5, label="C I 2S2 2P2  3PE 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 10192.630, g=5, label="C I 2S2 2P2  1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 21648.010, g=1, label="C I 2S2 2P2  1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 33735.200, g=5, label="C I 2S  2P3  5SO 2", stage=0, J=Fraction(2, 1), L=0, S=Fraction(2, 1)),
		AtomicLevel(E= 60333.430, g=1, label="C I 2S2 2P3S 3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 60352.630, g=3, label="C I 2S2 2P3S 3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 60393.140, g=5, label="C I 2S2 2P3S 3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 61981.820, g=3, label="C I 2S2 2P3S 1PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 64086.920, g=7, label="C I 2S  2P3  3DO 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 64089.850, g=3, label="C I 2S  2P3  3DO 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 64090.950, g=5, label="C I 2S  2P3  3DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 68856.330, g=3, label="C I 2S2 2P3P 1PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 69689.480, g=3, label="C I 2S2 2P3P 3DE 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 69710.660, g=5, label="C I 2S2 2P3P 3DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 69744.030, g=7, label="C I 2S2 2P3P 3DE 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 70743.950, g=3, label="C I 2S2 2P3P 3SE 1", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E= 71352.510, g=1, label="C I 2S2 2P3P 3PE 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 71364.900, g=3, label="C I 2S2 2P3P 3PE 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 71385.380, g=5, label="C I 2S2 2P3P 3PE 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 72610.720, g=5, label="C I 2S2 2P3P 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 73975.910, g=1, label="C I 2S2 2P3P 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 75253.970, g=3, label="C I 2S  2P3  3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 75255.270, g=5, label="C I 2S  2P3  3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 75256.120, g=1, label="C I 2S  2P3  3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 77680.500, g=5, label="C I 2S2 2P3D 1DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 90862.710, g=6, label="C II 2S2 2P 2PO  1", stage=1, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
	],
	lines=[
		VoigtLine(j=3, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=3, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=3, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=1, f=5.370e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=2, f=1.585e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=20, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=24, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=23, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=23, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=25, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=24, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=23, i=0, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=26, i=1, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=26, i=2, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=21, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=24, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=23, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=26, i=3, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=4, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=4, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=4, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=4, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=23, i=4, f=0.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=50, Nlambda=10), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
	],
	continua=[
		ExplicitContinuum(j=27, i=0, wavelengthGrid=[8.071, 10.167, 12.263, 14.359, 16.455, 18.55, 20.646, 22.742, 24.838, 26.934, 29.03, 31.126, 33.222, 35.317, 37.413, 39.509, 41.605, 43.701, 45.797, 47.893, 49.989, 52.085, 54.18, 56.276, 58.372, 60.468, 62.564, 64.66, 66.756, 68.852, 70.948, 73.043, 75.139, 77.235, 79.331, 81.427, 83.523, 85.619, 87.715, 89.81, 91.906, 94.002, 96.098, 98.194, 100.29, 102.386, 104.482, 106.578, 108.673, 110.769], alphaGrid=[4.401e-24, 8.739e-24, 1.531e-23, 2.455e-23, 3.69e-23, 5.282e-23, 7.273e-23, 9.708e-23, 1.263e-22, 1.609e-22, 2.012e-22, 2.477e-22, 3.008e-22, 3.61e-22, 4.35e-22, 5e-22, 5.524e-22, 5.985e-22, 6.228e-22, 7.265e-22, 7.409e-22, 7.74e-22, 8.2e-22, 8.544e-22, 9.046e-22, 9.768e-22, 1.006e-21, 1.039e-21, 1.086e-21, 1.133e-21, 1.178e-21, 1.23e-21, 1.276e-21, 1.322e-21, 1.386e-21, 1.426e-21, 1.418e-21, 1.423e-21, 1.484e-21, 1.576e-21, 1.643e-21, 1.67e-21, 1.676e-21, 1.684e-21, 1.698e-21, 1.715e-21, 1.731e-21, 1.744e-21, 1.751e-21, 1.755e-21]),
	],
	collisions=[
])

C_I_V_atom = lambda: \
AtomicModel(element=Element(Z=6),
	levels=[
		AtomicLevel(E=     0.000, g=9, label="C I 2S2 2P2 3PE 4", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 10172.700, g=5, label="C I 2S2 2P2 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 21628.080, g=1, label="C I 2S2 2P2 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 90832.200, g=6, label="C II 2S2 2P 2PO 1/2", stage=1, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 90895.620, g=4, label="C II 2S2 2P 2PO 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=133835.500, g=2, label="C II 2S 2P2 4PE 1/2", stage=1, J=Fraction(1, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=133857.500, g=4, label="C II 2S 2P2 4PE 3/2", stage=1, J=Fraction(3, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=133885.800, g=6, label="C II 2S 2P2 4PE 5/2", stage=1, J=Fraction(5, 2), L=1, S=Fraction(3, 2)),
		AtomicLevel(E=165762.300, g=6, label="C II 2S 2P2 2DE 5/2", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=165764.820, g=4, label="C II 2S 2P2 2DE 3/2", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=236381.470, g=4, label="C II 2S2 3D 2DE 3/2", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=287492.726, g=1, label="C III 2S2 1SE 0    3", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E=339859.921, g=1, label="C III 2S2P 3PO 0", stage=2, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=339883.621, g=3, label="C III 2S2P 3PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=339940.027, g=5, label="C III 2S2P 3PO 2", stage=2, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=389845.046, g=3, label="C III 2S2P 1PO 1", stage=2, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E=424918.851, g=1, label="C III 2P2 3PE 0    3", stage=2, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=424947.492, g=3, label="C III 2P2 3PE 1    3", stage=2, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=424995.117, g=5, label="C III 2P2 3PE 2    3", stage=2, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E=525706.429, g=3, label="C III 2S3S 3SE 1", stage=2, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E=673724.241, g=2, label="C IV 1S2 2S 2SE 1/2", stage=3, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=738315.343, g=4, label="C IV 1S2 2P 2PO 3/2", stage=3, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=993805.929, g=4, label="C IV 1S2 3P 2PO 3/2", stage=3, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=1193882.971, g=2, label="C V 1S 2SE 1/2", stage=4, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
	],
	lines=[
		VoigtLine(j=4, i=3, f=1.707e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.87e-06)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=3, f=4.483e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=231)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=3, f=2.769e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=10.4)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=3, f=1.287e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.71e+08)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=3, f=3.170e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.17e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=4, f=2.663e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=231)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=4, f=4.256e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=10.4)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=7, i=4, f=5.256e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=43.2)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=4, f=1.281e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.71e+08)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=4, f=1.159e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.89e+08)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=4, f=3.187e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.17e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=11, f=1.594e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=97.3)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=11, f=1.344e-11, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.00493)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=11, f=7.169e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.67e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=11, f=3.832e-13, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=11, f=7.667e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=11, f=1.294e-21, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.78e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=13, i=12, f=1.917e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=97.3)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=12, f=1.591e-16, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=0.00493)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=12, f=2.716e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.67e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=12, f=2.748e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=12, f=7.022e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=12, f=5.457e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.78e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=13, f=1.900e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=97.3)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=13, f=7.206e-13, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.67e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=13, f=9.156e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=13, f=6.868e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=13, f=1.145e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=13, f=5.461e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.78e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=14, f=6.934e-13, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.67e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=14, f=1.380e-12, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.32e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=14, f=6.862e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=14, f=2.060e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.33e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=14, f=5.471e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.78e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=15, f=1.161e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=15, f=1.494e-08, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=15, f=1.382e-06, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=15, f=1.008e-07, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.45e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=16, f=2.330e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=16, f=1.312e-16, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=16, f=1.092e-14, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.1e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=17, f=1.602e-09, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=17, f=3.790e-15, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.1e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=19, i=18, f=4.669e-15, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=5.1e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=21, i=20, f=1.904e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.65e+08)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=22, i=20, f=1.337e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=10, Nlambda=30), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.57e+09)], elastic=[VdwUnsold(vals=[0.0, 0.0]), MultiplicativeStarkBroadening(coeff=0)])),
	],
	continua=[
		ExplicitContinuum(j=3, i=0, wavelengthGrid=[49.0, 59.7, 65.1, 70.1, 75.3, 77.7, 78.0, 79.8, 80.4, 81.4, 84.2, 86.0, 86.9, 88.1, 91.1, 101.3, 110.0, 110.09311675815404], alphaGrid=[7.05e-22, 9.63e-22, 1.08e-21, 1.26e-21, 1.48e-21, 1.32e-21, 1.65e-21, 1.34e-21, 1.75e-21, 1.48e-21, 1.39e-21, 1.19e-21, 1.82e-21, 1.69e-21, 1.63e-21, 1.67e-21, 1.72e-21, 1.72e-21]),
		ExplicitContinuum(j=3, i=1, wavelengthGrid=[50.6, 57.0, 65.1, 70.1, 75.9, 82.8, 89.3, 89.5, 91.1, 93.0, 100.0, 104.4, 107.0, 113.9, 117.1, 121.0, 121.5, 122.0, 123.89, 123.97795671929529], alphaGrid=[6.4e-22, 7.66e-22, 9.66e-22, 1.07e-21, 1.09e-21, 1.55e-21, 3.3e-21, 6.91e-21, 5.18e-21, 2.26e-21, 3.5e-21, 4.5e-21, 2.5e-21, 1.08e-21, 9.66e-22, 1.02e-21, 1.02e-21, 1.02e-21, 1.05e-21, 1.05e-21]),
		ExplicitContinuum(j=3, i=2, wavelengthGrid=[57.0, 70.1, 82.8, 91.1, 95.9, 99.7, 101.3, 104.0, 113.9, 121.0, 122.0, 130.2, 144.32, 144.50006733703137], alphaGrid=[7.58e-22, 1.02e-21, 1.43e-21, 2.16e-21, 3.95e-21, 1.39e-20, 3.02e-21, 3.57e-22, 8.44e-22, 1.04e-21, 1.04e-21, 1.27e-21, 1.43e-21, 1.43e-21]),
		ExplicitContinuum(j=4, i=0, wavelengthGrid=[49.0, 59.7, 65.1, 70.1, 75.3, 77.7, 78.0, 79.8, 80.4, 81.4, 84.2, 86.0, 86.9, 88.1, 91.1, 101.3, 110.0, 110.01630221566231], alphaGrid=[7.05e-22, 9.63e-22, 1.08e-21, 1.26e-21, 1.48e-21, 1.32e-21, 1.65e-21, 1.34e-21, 1.75e-21, 1.48e-21, 1.39e-21, 1.19e-21, 1.82e-21, 1.69e-21, 1.63e-21, 1.67e-21, 1.72e-21, 1.72e-21]),
		ExplicitContinuum(j=4, i=1, wavelengthGrid=[50.6, 57.0, 65.1, 70.1, 75.9, 82.8, 89.3, 89.5, 91.1, 93.0, 100.0, 104.4, 107.0, 113.9, 117.1, 121.0, 121.5, 122.0, 123.89], alphaGrid=[6.4e-22, 7.66e-22, 9.66e-22, 1.07e-21, 1.09e-21, 1.55e-21, 3.3e-21, 6.91e-21, 5.18e-21, 2.26e-21, 3.5e-21, 4.5e-21, 2.5e-21, 1.08e-21, 9.66e-22, 1.02e-21, 1.02e-21, 1.02e-21, 1.05e-21]),
		ExplicitContinuum(j=4, i=2, wavelengthGrid=[57.0, 70.1, 82.8, 91.1, 95.9, 99.7, 101.3, 104.0, 113.9, 121.0, 122.0, 130.2, 144.32, 144.36776591170985], alphaGrid=[7.58e-22, 1.02e-21, 1.43e-21, 2.16e-21, 3.95e-21, 1.39e-20, 3.02e-21, 3.57e-22, 8.44e-22, 1.04e-21, 1.04e-21, 1.27e-21, 1.43e-21, 1.43e-21]),
	],
	collisions=[
		Omega(j=1, i=0, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]),
		Omega(j=2, i=1, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]),
		Omega(j=2, i=0, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0]),
		Omega(j=4, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.64, 1.77, 1.98, 2.19, 2.27, 2.27, 2.23, 2.2, 2.17, 2.16, 2.15, 2.15, 2.14, 2.14, 2.14, 2.14, 2.14]),
		Omega(j=5, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.256, 0.247, 0.242, 0.244, 0.246, 0.244, 0.237, 0.231, 0.226, 0.222, 0.221, 0.22, 0.219, 0.219, 0.218, 0.218, 0.218]),
		Omega(j=6, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.383, 0.367, 0.357, 0.366, 0.371, 0.364, 0.354, 0.348, 0.343, 0.341, 0.339, 0.339, 0.338, 0.338, 0.338, 0.338, 0.338]),
		Omega(j=7, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.24, 0.232, 0.228, 0.238, 0.245, 0.242, 0.237, 0.233, 0.23, 0.229, 0.228, 0.227, 0.227, 0.227, 0.227, 0.227, 0.227]),
		Omega(j=9, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.29, 1.31, 1.34, 1.41, 1.53, 1.66, 1.81, 2.01, 2.3, 2.72, 3.26, 3.9, 4.63, 5.41, 6.24, 7.08, 7.93]),
		Omega(j=8, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.514, 0.513, 0.526, 0.548, 0.56, 0.553, 0.536, 0.52, 0.51, 0.503, 0.499, 0.497, 0.496, 0.495, 0.494, 0.494, 0.494]),
		Omega(j=5, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.181, 0.175, 0.174, 0.179, 0.183, 0.183, 0.178, 0.173, 0.169, 0.167, 0.166, 0.165, 0.164, 0.164, 0.164, 0.164, 0.164]),
		Omega(j=6, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.5, 0.48, 0.467, 0.483, 0.493, 0.484, 0.472, 0.462, 0.457, 0.453, 0.451, 0.45, 0.449, 0.449, 0.449, 0.449, 0.449]),
		Omega(j=7, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.08, 1.04, 1.01, 1.03, 1.05, 1.03, 1.01, 0.989, 0.978, 0.972, 0.968, 0.966, 0.964, 0.964, 0.963, 0.963, 0.963]),
		Omega(j=9, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.875, 0.884, 0.901, 0.936, 0.979, 0.994, 0.967, 0.931, 0.92, 0.954, 1.03, 1.14, 1.28, 1.43, 1.59, 1.76, 1.93]),
		Omega(j=8, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.73, 2.77, 2.84, 2.98, 3.19, 3.43, 3.69, 4.02, 4.51, 5.23, 6.17, 7.32, 8.62, 10.0, 11.5, 13.0, 14.5]),
		Omega(j=6, i=5, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.61, 0.622, 0.701, 0.866, 1.05, 1.2, 1.3, 1.36, 1.39, 1.41, 1.42, 1.43, 1.43, 1.44, 1.44, 1.44, 1.44]),
		Omega(j=7, i=5, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.671, 0.694, 0.765, 0.88, 0.965, 0.997, 1.0, 0.994, 0.989, 0.985, 0.982, 0.981, 0.98, 0.98, 0.979, 0.979, 0.979]),
		Omega(j=9, i=5, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.428, 0.438, 0.453, 0.476, 0.504, 0.526, 0.54, 0.548, 0.553, 0.556, 0.558, 0.559, 0.559, 0.56, 0.56, 0.56, 0.56]),
		Omega(j=8, i=5, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.238, 0.247, 0.26, 0.277, 0.297, 0.313, 0.323, 0.329, 0.333, 0.335, 0.336, 0.337, 0.338, 0.338, 0.338, 0.338, 0.338]),
		Omega(j=7, i=6, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.52, 1.56, 1.74, 2.06, 2.37, 2.58, 2.69, 2.75, 2.78, 2.8, 2.81, 2.82, 2.82, 2.83, 2.83, 2.83, 2.83]),
		Omega(j=9, i=6, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.661, 0.679, 0.704, 0.743, 0.789, 0.824, 0.845, 0.858, 0.865, 0.87, 0.872, 0.874, 0.875, 0.875, 0.875, 0.876, 0.876]),
		Omega(j=8, i=6, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.669, 0.691, 0.721, 0.765, 0.815, 0.855, 0.881, 0.897, 0.907, 0.912, 0.916, 0.917, 0.919, 0.919, 0.919, 0.92, 0.92]),
		Omega(j=9, i=7, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.508, 0.527, 0.554, 0.59, 0.631, 0.664, 0.686, 0.7, 0.708, 0.713, 0.716, 0.717, 0.718, 0.719, 0.719, 0.719, 0.719]),
		Omega(j=8, i=7, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.49, 1.53, 1.59, 1.67, 1.77, 1.85, 1.91, 1.94, 1.96, 1.97, 1.98, 1.98, 1.99, 1.99, 1.99, 1.99, 1.99]),
		Omega(j=12, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.118, 0.117, 0.117, 0.117, 0.116, 0.113, 0.106, 0.0936, 0.0767, 0.0608, 0.049, 0.0412, 0.0363, 0.0334, 0.0317, 0.0307, 0.0302]),
		Omega(j=13, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.366, 0.364, 0.361, 0.356, 0.348, 0.337, 0.319, 0.282, 0.23, 0.182, 0.146, 0.123, 0.109, 0.1, 0.0953, 0.0925, 0.0909]),
		Omega(j=14, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.589, 0.587, 0.585, 0.581, 0.575, 0.565, 0.534, 0.469, 0.383, 0.302, 0.243, 0.204, 0.181, 0.167, 0.159, 0.155, 0.152]),
		Omega(j=15, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[3.83, 3.86, 3.9, 3.98, 4.1, 4.28, 4.54, 4.91, 5.47, 6.35, 7.6, 9.21, 11.1, 13.2, 15.4, 17.7, 20.0]),
		Omega(j=16, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.00203, 0.002, 0.00195, 0.00186, 0.00174, 0.00161, 0.00149, 0.00138, 0.00125, 0.00108, 0.000925, 0.000815, 0.000747, 0.000706, 0.000682, 0.000669, 0.000661]),
		Omega(j=17, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.00608, 0.00599, 0.00583, 0.00559, 0.00523, 0.00483, 0.00446, 0.00414, 0.00374, 0.00323, 0.00276, 0.00244, 0.00223, 0.00211, 0.00204, 0.002, 0.00197]),
		Omega(j=18, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.0102, 0.01, 0.00973, 0.00932, 0.00872, 0.00804, 0.00743, 0.0069, 0.00624, 0.00538, 0.0046, 0.00406, 0.00372, 0.00352, 0.0034, 0.00333, 0.00329]),
		Omega(j=19, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.317, 0.306, 0.288, 0.26, 0.22, 0.175, 0.13, 0.093, 0.0667, 0.0488, 0.0345, 0.0229, 0.0143, 0.00862, 0.00505, 0.0029, 0.00165]),
		Omega(j=13, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.82, 0.85, 0.896, 0.957, 1.02, 1.09, 1.11, 0.999, 0.794, 0.616, 0.494, 0.419, 0.375, 0.349, 0.335, 0.327, 0.322]),
		Omega(j=14, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.445, 0.492, 0.569, 0.688, 0.858, 1.04, 1.11, 1.02, 0.841, 0.671, 0.548, 0.47, 0.424, 0.397, 0.381, 0.372, 0.367]),
		Omega(j=15, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.447, 0.442, 0.433, 0.418, 0.393, 0.355, 0.303, 0.242, 0.186, 0.148, 0.125, 0.112, 0.105, 0.1, 0.0979, 0.0964, 0.0956]),
		Omega(j=16, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.0482, 0.0479, 0.0473, 0.0464, 0.0451, 0.0436, 0.0419, 0.0399, 0.0365, 0.032, 0.028, 0.0253, 0.0236, 0.0225, 0.022, 0.0216, 0.0214]),
		Omega(j=17, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.79, 1.81, 1.83, 1.86, 1.93, 2.03, 2.19, 2.42, 2.73, 3.17, 3.73, 4.41, 5.18, 6.02, 6.91, 7.82, 8.75]),
		Omega(j=18, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.109, 0.108, 0.106, 0.102, 0.0971, 0.091, 0.0846, 0.0775, 0.0685, 0.0586, 0.0504, 0.0449, 0.0414, 0.0394, 0.0382, 0.0376, 0.0372]),
		Omega(j=19, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.561, 0.531, 0.483, 0.411, 0.321, 0.238, 0.176, 0.127, 0.102, 0.102, 0.118, 0.143, 0.176, 0.215, 0.257, 0.302, 0.348]),
		Omega(j=14, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.02, 2.15, 2.37, 2.7, 3.17, 3.67, 3.83, 3.5, 2.87, 2.26, 1.82, 1.54, 1.38, 1.28, 1.22, 1.19, 1.17]),
		Omega(j=15, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.34, 1.32, 1.29, 1.25, 1.18, 1.07, 0.91, 0.718, 0.559, 0.45, 0.38, 0.337, 0.312, 0.297, 0.289, 0.284, 0.282]),
		Omega(j=16, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.78, 1.8, 1.82, 1.86, 1.93, 2.04, 2.19, 2.41, 2.73, 3.17, 3.73, 4.41, 5.18, 6.03, 6.91, 7.82, 8.75]),
		Omega(j=17, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.55, 1.56, 1.57, 1.6, 1.65, 1.72, 1.83, 1.99, 2.21, 2.52, 2.92, 3.43, 4.0, 4.63, 5.29, 5.97, 6.67]),
		Omega(j=18, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.48, 2.49, 2.52, 2.56, 2.63, 2.75, 2.93, 3.19, 3.57, 4.1, 4.78, 5.62, 6.59, 7.64, 8.75, 9.89, 11.1]),
		Omega(j=19, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.65, 1.58, 1.47, 1.29, 1.02, 0.689, 0.456, 0.407, 0.345, 0.266, 0.361, 0.665, 1.1, 1.62, 2.19, 2.8, 3.43]),
		Omega(j=15, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.24, 2.21, 2.16, 2.08, 1.96, 1.78, 1.52, 1.2, 0.932, 0.75, 0.633, 0.562, 0.52, 0.496, 0.482, 0.474, 0.469]),
		Omega(j=16, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.109, 0.108, 0.106, 0.102, 0.0971, 0.091, 0.0847, 0.0775, 0.0685, 0.0586, 0.0505, 0.0451, 0.0417, 0.0397, 0.0385, 0.0378, 0.0375]),
		Omega(j=17, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.48, 2.5, 2.52, 2.57, 2.64, 2.75, 2.93, 3.2, 3.58, 4.1, 4.78, 5.62, 6.59, 7.64, 8.74, 9.89, 11.0]),
		Omega(j=18, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[7.13, 7.19, 7.28, 7.43, 7.65, 8.0, 8.59, 9.44, 10.6, 12.1, 14.2, 16.7, 19.6, 22.7, 26.1, 29.5, 33.0]),
		Omega(j=19, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.81, 2.66, 2.41, 2.05, 1.6, 1.19, 0.879, 0.635, 0.508, 0.509, 0.589, 0.718, 0.883, 1.08, 1.29, 1.51, 1.75]),
		Omega(j=16, i=15, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.213, 0.207, 0.197, 0.182, 0.16, 0.138, 0.117, 0.0981, 0.0796, 0.0626, 0.0499, 0.0417, 0.0366, 0.0337, 0.032, 0.031, 0.0304]),
		Omega(j=17, i=15, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.639, 0.621, 0.591, 0.545, 0.481, 0.413, 0.351, 0.294, 0.239, 0.188, 0.15, 0.125, 0.11, 0.101, 0.0959, 0.093, 0.0913]),
		Omega(j=18, i=15, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.07, 1.04, 0.985, 0.907, 0.802, 0.688, 0.584, 0.49, 0.398, 0.313, 0.25, 0.208, 0.183, 0.168, 0.16, 0.155, 0.152]),
		Omega(j=19, i=15, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.6, 1.52, 1.4, 1.21, 0.978, 0.73, 0.516, 0.352, 0.232, 0.152, 0.101, 0.0709, 0.0531, 0.0429, 0.0371, 0.0338, 0.0319]),
		Omega(j=17, i=16, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.917, 0.906, 0.888, 0.857, 0.808, 0.751, 0.715, 0.656, 0.554, 0.456, 0.387, 0.344, 0.318, 0.303, 0.294, 0.289, 0.287]),
		Omega(j=18, i=16, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.538, 0.531, 0.52, 0.501, 0.476, 0.449, 0.425, 0.402, 0.378, 0.357, 0.34, 0.329, 0.322, 0.318, 0.316, 0.315, 0.314]),
		Omega(j=19, i=16, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.0814, 0.0802, 0.078, 0.0743, 0.0674, 0.0554, 0.0406, 0.0278, 0.0183, 0.0118, 0.00752, 0.00491, 0.00335, 0.00245, 0.00193, 0.00164, 0.00147]),
		Omega(j=18, i=17, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[2.34, 2.31, 2.26, 2.18, 2.07, 1.95, 1.84, 1.72, 1.55, 1.37, 1.23, 1.14, 1.08, 1.05, 1.03, 1.02, 1.02]),
		Omega(j=19, i=17, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.244, 0.24, 0.234, 0.223, 0.202, 0.166, 0.122, 0.0835, 0.055, 0.0353, 0.0226, 0.0147, 0.0101, 0.00735, 0.00579, 0.00491, 0.00441]),
		Omega(j=19, i=18, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.407, 0.401, 0.39, 0.371, 0.337, 0.277, 0.203, 0.139, 0.0917, 0.0588, 0.0376, 0.0245, 0.0167, 0.0122, 0.00965, 0.00818, 0.00734]),
		Omega(j=21, i=20, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[5.88, 5.89, 5.9, 5.93, 5.98, 6.08, 6.24, 6.53, 6.99, 7.65, 8.47, 9.46, 10.6, 11.9, 13.2, 14.6, 16.0]),
		Omega(j=22, i=20, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[0.178, 0.179, 0.179, 0.18, 0.183, 0.187, 0.193, 0.205, 0.225, 0.259, 0.314, 0.393, 0.495, 0.62, 0.77, 0.94, 1.13]),
		CI(j=3, i=1, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16, 1.32e-16]),
		CI(j=3, i=2, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16, 1.79e-16]),
		CI(j=11, i=3, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=4, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=5, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=6, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=7, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=8, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=9, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=11, i=10, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=11, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=12, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=13, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=14, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=15, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=16, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=17, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=18, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=20, i=19, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
		CI(j=23, i=20, temperature=[1995.3, 3548.1, 6309.6, 11220.2, 19952.6, 35481.4, 63095.8, 112202.0, 199526.0, 354814.0, 630958.0, 1122020.0, 1995260.0, 3548140.0, 6309580.0, 11220200.0, 19952600.0], rates=[1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17, 1e-17]),
])

Ca_atom = lambda: \
AtomicModel(element=Element(Z=20),
	levels=[
		AtomicLevel(E=     0.000, g=1, label="CA I 3P6 4S2 1SE", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 15263.055, g=9, label="CA I 3P6 4S4P 3PO", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 20356.629, g=15, label="CA I 3P6 4S3D 3DE", stage=0, J=Fraction(7, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 21849.607, g=5, label="CA I 3P6 4S3D 1DE", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 23652.373, g=3, label="CA I 3P6 4S4P 1PO", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 31539.533, g=3, label="CA I 3P6 4S5S 3SE", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E= 33317.281, g=1, label="CA I 3P6 4S5S 1SE", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 49304.820, g=2, label="CA II 3P6 4S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E= 62991.496, g=10, label="CA II 3P6 3D 2DE", stage=1, J=Fraction(9, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 74644.953, g=6, label="CA II 3P6 4P 2PO", stage=1, J=Fraction(5, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=101471.820, g=2, label="CA II 3P6 5S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=106155.625, g=10, label="CA II 3P6 4D 2DE", stage=1, J=Fraction(9, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=145052.844, g=1, label="CA III 3P6 1SE", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
	],
	lines=[
		VoigtLine(j=4, i=0, f=1.890e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=150, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.35e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=6, i=4, f=1.400e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.62e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=4, i=3, f=1.310e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.35e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=5, i=1, f=1.467e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.78e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=2, i=1, f=2.244e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.33e+06)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=7, f=9.950e-01, type=LineType.PRD, quadrature=LinearCoreExpWings(qCore=10, qWing=450, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=9, f=1.883e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.71e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=8, f=5.100e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=11, i=9, f=8.650e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1, qWing=30, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.44e+08)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
	],
	continua=[
		ExplicitContinuum(j=7, i=0, wavelengthGrid=[18.538, 22.393, 26.249, 30.104, 33.959, 37.814, 41.669, 45.524, 49.379, 53.234, 57.089, 60.944, 64.799, 68.654, 72.509, 76.364, 80.22, 84.075, 87.93, 91.785, 95.64, 99.495, 103.35, 107.205, 111.06, 114.915, 118.77, 122.625, 126.48, 130.335, 134.191, 138.046, 141.901, 145.756, 149.611, 153.466, 157.321, 161.176, 165.031, 168.886, 172.741, 176.596, 180.451, 184.306, 188.162, 192.017, 195.872, 199.727, 203.582, 207.437], alphaGrid=[1.143e-24, 2e-24, 3.237e-24, 4.914e-24, 7.025e-24, 9.415e-24, 1.023e-23, 1.12e-23, 1.204e-23, 1.285e-23, 1.376e-23, 1.522e-23, 1.71e-23, 1.917e-23, 2.12e-23, 2.364e-23, 2.65e-23, 3.084e-23, 3.504e-23, 4.022e-23, 4.594e-23, 5.17e-23, 5.793e-23, 6.524e-23, 7.169e-23, 8.216e-23, 9.291e-23, 1.036e-22, 1.165e-22, 1.266e-22, 1.337e-22, 1.479e-22, 1.744e-22, 2.035e-22, 2.22e-22, 2.288e-22, 2.331e-22, 2.489e-22, 2.797e-22, 3.248e-22, 3.763e-22, 4.296e-22, 4.823e-22, 5.346e-22, 5.867e-22, 6.376e-22, 6.843e-22, 7.23e-22, 7.507e-22, 7.654e-22]),
		ExplicitContinuum(j=7, i=1, wavelengthGrid=[31.658, 37.207, 42.756, 48.304, 53.853, 59.402, 64.95, 70.499, 76.048, 81.596, 87.145, 92.694, 98.242, 103.791, 109.339, 114.888, 120.437, 125.985, 131.534, 137.083, 142.631, 148.18, 153.729, 159.277, 164.826, 170.375, 175.923, 181.472, 187.021, 192.569, 198.118, 203.666, 209.215, 214.764, 220.312, 225.861, 231.41, 236.958, 242.507, 248.056, 253.604, 259.153, 264.702, 270.25, 275.799, 281.347, 286.896, 292.445, 297.993, 303.542], alphaGrid=[4.752e-24, 7.641e-24, 1.086e-23, 1.459e-23, 1.91e-23, 2.464e-23, 3.164e-23, 4.066e-23, 5.178e-23, 6.567e-23, 8.254e-23, 1.021e-22, 1.226e-22, 1.472e-22, 1.738e-22, 2.054e-22, 2.39e-22, 2.792e-22, 3.186e-22, 3.632e-22, 4.109e-22, 4.561e-22, 5.065e-22, 5.583e-22, 6.024e-22, 6.285e-22, 6.737e-22, 7.773e-22, 8.669e-22, 9.106e-22, 1.009e-21, 1.206e-21, 1.394e-21, 1.448e-21, 1.369e-21, 1.249e-21, 1.173e-21, 1.169e-21, 1.219e-21, 1.296e-21, 1.38e-21, 1.454e-21, 1.504e-21, 1.516e-21, 1.485e-21, 1.408e-21, 1.31e-21, 1.211e-21, 1.133e-21, 1.091e-21]),
		ExplicitContinuum(j=7, i=3, wavelengthGrid=[21.475, 28.78, 36.084, 43.389, 50.693, 57.998, 65.302, 72.607, 79.911, 87.215, 94.52, 101.824, 109.129, 116.433, 123.738, 131.042, 138.347, 145.651, 152.956, 160.26, 167.565, 174.869, 182.174, 189.478, 196.783, 204.087, 211.392, 218.696, 226.001, 233.305, 240.609, 247.914, 255.218, 262.523, 269.827, 277.132, 284.436, 291.741, 299.045, 306.35, 313.654, 320.959, 328.263, 335.568, 342.872, 350.177, 357.481, 364.786, 372.09, 379.394], alphaGrid=[1.016e-23, 2.438e-23, 4.832e-23, 7.798e-23, 9.865e-23, 1.24e-22, 1.504e-22, 1.787e-22, 2.145e-22, 2.576e-22, 2.986e-22, 3.47e-22, 3.988e-22, 4.596e-22, 5.26e-22, 5.975e-22, 6.684e-22, 7.387e-22, 8.096e-22, 8.87e-22, 9.716e-22, 1.055e-21, 1.151e-21, 1.258e-21, 1.367e-21, 1.486e-21, 1.629e-21, 1.79e-21, 1.942e-21, 2.058e-21, 2.129e-21, 2.167e-21, 2.189e-21, 2.212e-21, 2.244e-21, 2.289e-21, 2.345e-21, 2.412e-21, 2.489e-21, 2.575e-21, 2.667e-21, 2.763e-21, 2.86e-21, 2.956e-21, 3.044e-21, 3.122e-21, 3.191e-21, 3.241e-21, 3.276e-21, 3.301e-21]),
		ExplicitContinuum(j=7, i=4, wavelengthGrid=[26.318, 34.092, 41.866, 49.64, 57.414, 65.188, 72.962, 80.737, 88.511, 96.285, 104.059, 111.833, 119.607, 127.381, 135.155, 142.929, 150.703, 158.477, 166.251, 174.025, 181.8, 189.574, 197.348, 205.122, 212.896, 220.67, 228.444, 236.218, 243.992, 251.766, 259.54, 267.314, 275.088, 282.863, 290.637, 298.411, 306.185, 313.959, 321.733, 329.507, 337.281, 345.055, 352.829, 360.603, 368.377, 376.151, 383.926, 391.7, 399.474, 407.248], alphaGrid=[5.422e-24, 1.16e-23, 2.091e-23, 2.796e-23, 3.474e-23, 4.191e-23, 5.015e-23, 6.211e-23, 7.615e-23, 9.551e-23, 1.163e-22, 1.421e-22, 1.703e-22, 2.058e-22, 2.436e-22, 2.821e-22, 3.356e-22, 3.836e-22, 4.474e-22, 5.013e-22, 5.819e-22, 6.37e-22, 6.875e-22, 7.99e-22, 9.698e-22, 1.174e-21, 1.401e-21, 1.641e-21, 1.881e-21, 2.096e-21, 2.245e-21, 2.296e-21, 2.277e-21, 2.258e-21, 2.337e-21, 2.602e-21, 3.078e-21, 3.694e-21, 4.351e-21, 4.932e-21, 5.333e-21, 5.494e-21, 5.411e-21, 5.121e-21, 4.69e-21, 4.184e-21, 3.679e-21, 3.263e-21, 2.95e-21, 2.739e-21]),
		ExplicitContinuum(j=7, i=2, wavelengthGrid=[19.392, 26.324, 33.256, 40.188, 47.12, 54.052, 60.983, 67.915, 74.847, 81.779, 88.711, 95.643, 102.575, 109.507, 116.439, 123.371, 130.303, 137.235, 144.167, 151.098, 158.03, 164.962, 171.894, 178.826, 185.758, 192.69, 199.622, 206.554, 213.486, 220.418, 227.35, 234.281, 241.213, 248.145, 255.077, 262.009, 268.941, 275.873, 282.805, 289.737, 296.669, 303.601, 310.533, 317.464, 324.396, 331.328, 338.26, 345.192, 352.124, 359.056], alphaGrid=[9.095e-24, 2.275e-23, 4.635e-23, 8.212e-23, 1.07e-22, 1.336e-22, 1.612e-22, 1.91e-22, 2.236e-22, 2.593e-22, 2.979e-22, 3.384e-22, 3.794e-22, 4.284e-22, 4.764e-22, 5.372e-22, 5.95e-22, 6.586e-22, 7.182e-22, 7.915e-22, 8.553e-22, 9.286e-22, 1.053e-21, 1.196e-21, 1.298e-21, 1.359e-21, 1.422e-21, 1.514e-21, 1.617e-21, 1.698e-21, 1.734e-21, 1.722e-21, 1.686e-21, 1.649e-21, 1.632e-21, 1.645e-21, 1.689e-21, 1.756e-21, 1.839e-21, 1.928e-21, 2.015e-21, 2.095e-21, 2.164e-21, 2.224e-21, 2.272e-21, 2.308e-21, 2.336e-21, 2.356e-21, 2.368e-21, 2.377e-21]),
		ExplicitContinuum(j=7, i=5, wavelengthGrid=[42.152, 53.535, 64.919, 76.303, 87.686, 99.07, 110.454, 121.838, 133.221, 144.605, 155.989, 167.372, 178.756, 190.14, 201.524, 212.907, 224.291, 235.675, 247.059, 258.442, 269.826, 281.21, 292.594, 303.977, 315.361, 326.745, 338.128, 349.512, 360.896, 372.28, 383.663, 395.047, 406.431, 417.815, 429.198, 440.582, 451.966, 463.349, 474.733, 486.117, 497.501, 508.884, 520.268, 531.652, 543.036, 554.419, 565.803, 577.187, 588.57, 599.954], alphaGrid=[1.351e-24, 1.678e-24, 2.162e-24, 2.974e-24, 3.677e-24, 5.126e-24, 5.841e-24, 7.93e-24, 1.02e-23, 1.068e-23, 1.791e-23, 2.863e-23, 3.916e-23, 4.803e-23, 5.555e-23, 9.278e-23, 1.363e-22, 1.348e-22, 2.166e-22, 2.239e-22, 4.353e-22, 6.467e-22, 7.994e-22, 1.17e-21, 1.278e-21, 2.222e-21, 6.364e-21, 1.357e-20, 2.009e-20, 2.234e-20, 1.964e-20, 1.395e-20, 8.128e-21, 3.867e-21, 1.7e-21, 9.412e-22, 1.01e-21, 1.215e-21, 1.313e-21, 1.245e-21, 1.058e-21, 8.333e-22, 6.23e-22, 4.473e-22, 3.096e-22, 2.037e-22, 1.216e-22, 5.995e-23, 2.134e-23, 8.84e-24]),
		ExplicitContinuum(j=7, i=6, wavelengthGrid=[70.588, 82.854, 95.119, 107.384, 119.649, 131.915, 144.18, 156.445, 168.71, 180.976, 193.241, 205.506, 217.771, 230.037, 242.302, 254.567, 266.832, 279.098, 291.363, 303.628, 315.893, 328.159, 340.424, 352.689, 364.954, 377.22, 389.485, 401.75, 414.015, 426.281, 438.546, 450.811, 463.077, 475.342, 487.607, 499.872, 512.138, 524.403, 536.668, 548.933, 561.199, 573.464, 585.729, 597.994, 610.26, 622.525, 634.79, 647.055, 659.321, 671.586], alphaGrid=[1.648e-24, 2.055e-24, 3.019e-24, 4.577e-24, 8.38e-24, 1.442e-23, 2.439e-23, 3.82e-23, 5.755e-23, 8.12e-23, 1.138e-22, 1.576e-22, 2.165e-22, 2.866e-22, 3.641e-22, 4.777e-22, 6.662e-22, 7.928e-22, 7.721e-22, 1.692e-21, 2.232e-21, 1.84e-21, 2.258e-21, 3.694e-21, 6.509e-21, 1.499e-20, 2.629e-20, 2.838e-20, 1.931e-20, 8.693e-21, 2.912e-21, 1.244e-21, 8.558e-22, 7.153e-22, 7.294e-22, 8.083e-22, 7.949e-22, 6.599e-22, 4.843e-22, 3.451e-22, 2.5e-22, 1.882e-22, 1.562e-22, 1.699e-22, 2.37e-22, 3.632e-22, 5.174e-22, 6.685e-22, 7.866e-22, 8.499e-22]),
		ExplicitContinuum(j=12, i=7, wavelengthGrid=[25.0, 29.181, 33.362, 37.543, 41.724, 45.905, 50.087, 54.268, 58.449, 62.63, 66.811, 70.992, 75.173, 79.354, 83.535, 87.716, 91.898, 96.079, 100.26, 104.441], alphaGrid=[5.295e-25, 8.431e-25, 1.262e-24, 1.801e-24, 2.476e-24, 3.302e-24, 4.296e-24, 5.473e-24, 6.848e-24, 8.439e-24, 1.026e-23, 1.233e-23, 1.466e-23, 1.727e-23, 2.017e-23, 2.34e-23, 2.694e-23, 3.083e-23, 3.51e-23, 3.892e-23]),
		ExplicitContinuum(j=12, i=8, wavelengthGrid=[30.0, 34.835, 39.669, 44.504, 49.339, 54.174, 59.008, 63.843, 68.678, 73.513, 78.347, 83.182, 88.017, 92.852, 97.686, 102.521, 107.356, 112.19, 117.025, 121.86, 121.86005036134674], alphaGrid=[9.663e-24, 1.527e-23, 2.276e-23, 3.243e-23, 4.46e-23, 8.201e-23, 1.428e-22, 1.955e-22, 2.443e-22, 2.92e-22, 3.402e-22, 3.89e-22, 4.38e-22, 4.865e-22, 5.34e-22, 5.809e-22, 6.275e-22, 6.743e-22, 7.217e-22, 7.696e-22, 7.696e-22]),
		ExplicitContinuum(j=12, i=9, wavelengthGrid=[35.0, 40.633, 46.266, 51.899, 57.533, 63.166, 68.799, 74.432, 80.065, 85.698, 91.331, 96.964, 102.598, 108.231, 113.864, 119.497, 125.13, 130.763, 136.396, 142.03], alphaGrid=[4.254e-24, 6.678e-24, 9.887e-24, 1.4e-23, 1.913e-23, 2.199e-23, 2.524e-23, 3.106e-23, 3.944e-23, 5.059e-23, 6.469e-23, 8.186e-23, 1.021e-22, 1.254e-22, 1.518e-22, 1.814e-22, 2.142e-22, 2.505e-22, 2.907e-22, 3.348e-22]),
		HydrogenicContinuum(j=12, i=10, NlambdaGen=15, alpha0=1.463e-23, minWavelength=50),
		HydrogenicContinuum(j=12, i=11, NlambdaGen=15, alpha0=2.173e-22, minWavelength=60),
	],
	collisions=[
		CE(j=1, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.263e-15, 1.958e-15, 1.399e-15, 9.79e-16, 4.895e-16, 3.263e-16]),
		CE(j=2, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.447e-15, 1.468e-15, 1.049e-15, 7.341e-16, 3.67e-16, 2.447e-16]),
		CE(j=3, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.28e-15, 1.368e-15, 9.77e-16, 6.839e-16, 3.42e-16, 2.28e-16]),
		CE(j=4, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.041e-14, 3.159e-14, 2.351e-14, 1.746e-14, 1.035e-14, 7.943e-15]),
		CE(j=5, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.579e-15, 9.476e-16, 6.768e-16, 4.738e-16, 2.369e-16, 1.579e-16]),
		CE(j=6, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.495e-15, 8.97e-16, 6.407e-16, 4.485e-16, 2.243e-16, 1.495e-16]),
		CE(j=2, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.795e-14, 3.293e-14, 2.631e-14, 2.115e-14, 1.443e-14, 1.162e-14]),
		CE(j=3, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.562e-15, 4.537e-15, 3.241e-15, 2.269e-15, 1.134e-15, 7.562e-16]),
		CE(j=4, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.937e-15, 3.562e-15, 2.545e-15, 1.781e-15, 8.906e-16, 5.937e-16]),
		CE(j=5, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.403e-14, 8.582e-15, 6.247e-15, 4.493e-15, 2.431e-15, 1.73e-15]),
		CE(j=6, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.759e-15, 1.655e-15, 1.182e-15, 8.277e-16, 4.138e-16, 2.759e-16]),
		CE(j=3, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.336e-14, 2.002e-14, 1.43e-14, 1.001e-14, 5.004e-15, 3.336e-15]),
		CE(j=4, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.511e-14, 9.068e-15, 6.477e-15, 4.534e-15, 2.267e-15, 1.511e-15]),
		CE(j=5, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.454e-15, 2.672e-15, 1.909e-15, 1.336e-15, 6.681e-16, 4.454e-16]),
		CE(j=6, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.843e-15, 2.306e-15, 1.647e-15, 1.153e-15, 5.765e-16, 3.843e-16]),
		CE(j=4, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[3.005e-17, 1.897e-17, 1.411e-17, 1.036e-17, 5.753e-18, 4.099e-18]),
		CE(j=5, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.14e-15, 3.084e-15, 2.203e-15, 1.542e-15, 7.711e-16, 5.14e-16]),
		CE(j=6, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.344e-15, 2.606e-15, 1.862e-15, 1.303e-15, 6.515e-16, 4.344e-16]),
		CE(j=5, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[6.315e-15, 3.789e-15, 2.707e-15, 1.895e-15, 9.473e-16, 6.315e-16]),
		CE(j=6, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.311e-14, 1.431e-14, 1.052e-14, 7.669e-15, 4.278e-15, 3.099e-15]),
		CE(j=6, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.802e-14, 1.681e-14, 1.201e-14, 8.406e-15, 4.203e-15, 2.802e-15]),
		Omega(j=8, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.297, 1.835, 2.307, 2.94, 4.71, 6.206]),
		Omega(j=9, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.583, 6.487, 8.155, 10.39, 16.65, 21.94]),
		Omega(j=10, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.1369, 0.1938, 0.2436, 0.3105, 0.4975, 0.6555]),
		Omega(j=11, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.1185, 0.1678, 0.2109, 0.2688, 0.4306, 0.5673]),
		Omega(j=9, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.332, 6.131, 7.707, 9.822, 15.74, 20.73]),
		Omega(j=10, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.142, 1.616, 2.031, 2.589, 4.148, 5.464]),
		Omega(j=11, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[0.9413, 1.332, 1.675, 2.134, 3.42, 4.505]),
		Omega(j=10, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.365, 3.347, 4.207, 5.362, 8.59, 11.32]),
		Omega(j=11, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[8.289, 11.73, 14.75, 18.8, 30.11, 39.67]),
		Omega(j=11, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.855, 11.12, 13.98, 17.81, 28.54, 37.6]),
		CI(j=7, i=0, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.622e-16, 1.622e-16, 1.622e-16, 1.622e-16, 1.622e-16, 1.622e-16]),
		CI(j=7, i=1, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.345e-16, 4.345e-16, 4.345e-16, 4.345e-16, 4.345e-16, 4.345e-16]),
		CI(j=7, i=2, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[9.11e-16, 9.11e-16, 9.11e-16, 9.11e-16, 9.11e-16, 9.11e-16]),
		CI(j=7, i=3, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.359e-15, 1.359e-15, 1.359e-15, 1.359e-15, 1.359e-15, 1.359e-15]),
		CI(j=7, i=4, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[4.825e-16, 4.825e-16, 4.825e-16, 4.825e-16, 4.825e-16, 4.825e-16]),
		CI(j=7, i=5, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[5.151e-18, 5.151e-18, 5.151e-18, 5.151e-18, 5.151e-18, 5.151e-18]),
		CI(j=7, i=6, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[8.942e-17, 8.942e-17, 8.942e-17, 8.942e-17, 8.942e-17, 8.942e-17]),
		CI(j=12, i=7, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[8.758e-18, 8.758e-18, 8.758e-18, 8.758e-18, 8.758e-18, 8.758e-18]),
		CI(j=12, i=8, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[2.021e-16, 2.021e-16, 2.021e-16, 2.021e-16, 2.021e-16, 2.021e-16]),
		CI(j=12, i=9, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.025e-16, 1.025e-16, 1.025e-16, 1.025e-16, 1.025e-16, 1.025e-16]),
		CI(j=12, i=10, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[7.233e-18, 7.233e-18, 7.233e-18, 7.233e-18, 7.233e-18, 7.233e-18]),
		CI(j=12, i=11, temperature=[3000.0, 5000.0, 7000.0, 10000.0, 20000.0, 30000.0], rates=[1.204e-16, 1.204e-16, 1.204e-16, 1.204e-16, 1.204e-16, 1.204e-16]),
])

CaIII_45_atom = lambda: \
AtomicModel(element=Element(Z=20),
	levels=[
		AtomicLevel(E=     0.000, g=1, label="CA I 3P6 4S2 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 15157.901, g=1, label="CA I 3P6 4S4P 3PO 0", stage=0, J=Fraction(0, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 15210.063, g=3, label="CA I 3P6 4S4P 3PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 15315.943, g=5, label="CA I 3P6 4S4P 3PO 2", stage=0, J=Fraction(2, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 20335.359, g=3, label="CA I 3P6 4S3D 3DE 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 20349.260, g=5, label="CA I 3P6 4S3D 3DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 20371.000, g=7, label="CA I 3P6 4S3D 3DE 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 21849.635, g=5, label="CA I 3P6 4S3D 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 23652.305, g=3, label="CA I 3P6 4S4P 1PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 31539.494, g=3, label="CA I 3P6 4S5S 3SE 1", stage=0, J=Fraction(1, 1), L=0, S=Fraction(1, 1)),
		AtomicLevel(E= 33317.266, g=1, label="CA I 3P6 4S5S 1SE 0", stage=0, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
		AtomicLevel(E= 35831.203, g=21, label="CA I 3P6 4P3D 3FO", stage=0, J=Fraction(10, 1), L=3, S=Fraction(1, 1)),
		AtomicLevel(E= 35835.414, g=5, label="CA I 3P6 4P3D 1DO 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 36565.281, g=9, label="CA I 3P6 4S5P 3PO", stage=0, J=Fraction(4, 1), L=1, S=Fraction(1, 1)),
		AtomicLevel(E= 36731.613, g=3, label="CA I 3P6 4S5P 1PO 1", stage=0, J=Fraction(1, 1), L=1, S=Fraction(0, 1)),
		AtomicLevel(E= 37298.285, g=5, label="CA I 3P6 4S4D 1DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(0, 1)),
		AtomicLevel(E= 37748.195, g=3, label="CA I 3P6 4S4D 3DE 1", stage=0, J=Fraction(1, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 37751.867, g=5, label="CA I 3P6 4S4D 3DE 2", stage=0, J=Fraction(2, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 37757.449, g=7, label="CA I 3P6 4S4D 3DE 3", stage=0, J=Fraction(3, 1), L=2, S=Fraction(1, 1)),
		AtomicLevel(E= 49305.949, g=2, label="Ca II 3P6 4S 2SE 1", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E= 62956.139, g=4, label="CA II 3P6 3D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 63016.829, g=6, label="CA II 3P6 3D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E= 74497.459, g=2, label="CA II 3P6 4P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E= 74720.349, g=4, label="CA II 3P6 4P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=101472.879, g=2, label="CA II 3P6 5S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=106145.199, g=4, label="CA II 3P6 4D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=106164.409, g=6, label="CA II 3P6 4D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=109838.969, g=2, label="CA II 3P6 5P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=109917.229, g=4, label="CA II 3P6 5P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=117362.859, g=8, label="CA II 3P6 4F 2FO 7", stage=1, J=Fraction(7, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=117362.859, g=6, label="CA II 3P6 4F 2FO 5", stage=1, J=Fraction(5, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=119983.569, g=2, label="CA II 3P6 6S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=122028.179, g=4, label="CA II 3P6 5D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=122036.879, g=6, label="CA II 3P6 5D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=123790.869, g=2, label="CA II 3P6 6P 2PO 1", stage=1, J=Fraction(1, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=123827.699, g=4, label="CA II 3P6 6P 2PO 3", stage=1, J=Fraction(3, 2), L=1, S=Fraction(1, 2)),
		AtomicLevel(E=127340.339, g=6, label="CA II 3P6 5F 2FO 5", stage=1, J=Fraction(5, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=127340.339, g=8, label="CA II 3P6 5F 2FO 7", stage=1, J=Fraction(7, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=128754.229, g=2, label="CA II 3P6 7S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=129827.479, g=4, label="CA II 3P6 6D 2DE 3", stage=1, J=Fraction(3, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=129832.109, g=6, label="CA II 3P6 6D 2DE 5", stage=1, J=Fraction(5, 2), L=2, S=Fraction(1, 2)),
		AtomicLevel(E=132764.029, g=6, label="CA II 3P6 6F 2FO 5", stage=1, J=Fraction(5, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=132764.029, g=8, label="CA II 3P6 6F 2FO 7", stage=1, J=Fraction(7, 2), L=3, S=Fraction(1, 2)),
		AtomicLevel(E=133606.839, g=2, label="CA II 3P6 8S 2SE", stage=1, J=Fraction(1, 2), L=0, S=Fraction(1, 2)),
		AtomicLevel(E=145091.419, g=1, label="CA III 3P6 1SE", stage=2, J=Fraction(0, 1), L=0, S=Fraction(0, 1)),
	],
	lines=[
		VoigtLine(j=2, i=0, f=5.130e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=1.5, qWing=5, Nlambda=15), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2640)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=8, i=0, f=1.750e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=5, qWing=1000, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.18e+08)], elastic=[VdwBarklem(vals=[1.0, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=9, i=1, f=1.290e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=20, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.62e+07)], elastic=[VdwUnsold(vals=[2.92, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=2, f=1.300e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=20, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.62e+07)], elastic=[VdwUnsold(vals=[2.22, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=9, i=3, f=1.210e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=20, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.62e+07)], elastic=[VdwUnsold(vals=[2.44, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=1, f=4.121e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.49e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=2, f=3.118e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=2, f=1.054e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.49e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=18, i=3, f=3.573e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.57e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=17, i=3, f=6.181e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2.5, qWing=40, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.42e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=16, i=3, f=4.376e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=30, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=8.49e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=10, i=8, f=1.303e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.44e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=12, i=7, f=3.229e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=4.21e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=0, f=8.913e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2, qWing=30, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.45e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=7, f=4.909e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=2.5, qWing=40, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.45e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=14, i=10, f=8.204e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.45e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=15, i=8, f=3.943e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=3, qWing=50, Nlambda=20), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.94e+07)], elastic=[VdwUnsold(vals=[1.0, 1.0]), MultiplicativeStarkBroadening(coeff=0)])),
		VoigtLine(j=22, i=19, f=3.412e-01, type=LineType.PRD, quadrature=LinearCoreExpWings(qCore=30, qWing=1300, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.51e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=19, f=6.807e-01, type=LineType.PRD, quadrature=LinearCoreExpWings(qCore=30, qWing=1300, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=22, i=20, f=5.956e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=50, qWing=120, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.51e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=20, f=1.219e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=40, qWing=80, Nlambda=100), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=23, i=21, f=7.242e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=50, qWing=120, Nlambda=200), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=20, f=6.800e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.5e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=20, f=1.400e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.5e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=20, f=1.850e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.61e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=34, i=20, f=2.800e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.4e+06)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=20, f=5.700e-05, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.44e+06)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=20, f=8.630e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.7e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=41, i=20, f=4.660e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.08e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=21, f=8.200e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.5e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=29, i=21, f=1.760e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.6e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=30, i=21, f=8.780e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.61e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=35, i=21, f=3.500e-04, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.44e+06)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=36, i=21, f=4.090e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.7e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=37, i=21, f=8.160e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.69e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=41, i=21, f=2.200e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.08e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=42, i=21, f=4.400e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.07e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=22, f=1.800e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=22, f=9.300e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.68e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=22, f=2.200e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=22, f=1.100e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=38, i=22, f=7.890e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.91e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=39, i=22, f=4.040e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=22, f=3.900e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.97e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=24, i=23, f=1.800e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=25, i=23, f=8.800e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.68e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=26, i=23, f=8.200e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.6e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=23, f=2.300e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=23, f=1.100e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=23, f=9.700e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=38, i=23, f=7.910e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.91e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=39, i=23, f=3.500e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=40, i=23, f=3.600e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.16e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=23, f=3.870e-03, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.97e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=27, i=24, f=4.900e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.5e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=28, i=24, f=9.700e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=2.5e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=27, f=2.800e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=27, f=1.000e+00, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=38, i=27, f=3.300e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.91e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=39, i=27, f=1.500e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=27, f=1.100e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.97e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=31, i=28, f=2.800e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.5e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=32, i=28, f=1.000e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.59e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=33, i=28, f=9.300e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=1.58e+08)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=38, i=28, f=3.200e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=6.91e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=39, i=28, f=1.500e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.21e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=40, i=28, f=1.300e-01, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=7.16e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
		VoigtLine(j=43, i=28, f=1.100e-02, type=LineType.CRD, quadrature=LinearCoreExpWings(qCore=4, qWing=60, Nlambda=40), broadening=LineBroadening(natural=[RadiativeBroadening(gamma=3.97e+07)], elastic=[VdwUnsold(vals=[1.5, 1.0]), QuadraticStarkBroadening(coeff=1)])),
	],
	continua=[
		ExplicitContinuum(j=19, i=0, wavelengthGrid=[18.538, 22.393, 26.249, 30.104, 33.959, 37.814, 41.669, 45.524, 49.379, 53.234, 57.089, 60.944, 64.799, 68.654, 72.509, 76.364, 80.22, 84.075, 87.93, 91.785, 95.64, 99.495, 103.35, 107.205, 111.06, 114.915, 118.77, 122.625, 126.48, 130.335, 134.191, 138.046, 141.901, 145.756, 149.611, 153.466, 157.321, 161.176, 165.031, 168.886, 172.741, 176.596, 180.451, 184.306, 188.162, 192.017, 195.872, 199.727, 203.582, 207.437], alphaGrid=[1.143e-24, 2e-24, 3.237e-24, 4.914e-24, 7.025e-24, 9.415e-24, 1.023e-23, 1.12e-23, 1.204e-23, 1.285e-23, 1.376e-23, 1.522e-23, 1.71e-23, 1.917e-23, 2.12e-23, 2.364e-23, 2.65e-23, 3.084e-23, 3.504e-23, 4.022e-23, 4.594e-23, 5.17e-23, 5.793e-23, 6.524e-23, 7.169e-23, 8.216e-23, 9.291e-23, 1.036e-22, 1.165e-22, 1.266e-22, 1.337e-22, 1.479e-22, 1.744e-22, 2.035e-22, 2.22e-22, 2.288e-22, 2.331e-22, 2.489e-22, 2.797e-22, 3.248e-22, 3.763e-22, 4.296e-22, 4.823e-22, 5.346e-22, 5.867e-22, 6.376e-22, 6.843e-22, 7.23e-22, 7.507e-22, 7.654e-22]),
		ExplicitContinuum(j=19, i=1, wavelengthGrid=[31.658, 37.207, 42.756, 48.304, 53.853, 59.402, 64.95, 70.499, 76.048, 81.596, 87.145, 92.694, 98.242, 103.791, 109.339, 114.888, 120.437, 125.985, 131.534, 137.083, 142.631, 148.18, 153.729, 159.277, 164.826, 170.375, 175.923, 181.472, 187.021, 192.569, 198.118, 203.666, 209.215, 214.764, 220.312, 225.861, 231.41, 236.958, 242.507, 248.056, 253.604, 259.153, 264.702, 270.25, 275.799, 281.347, 286.896, 292.445, 297.993, 303.542], alphaGrid=[4.752e-24, 7.641e-24, 1.086e-23, 1.459e-23, 1.91e-23, 2.464e-23, 3.164e-23, 4.066e-23, 5.178e-23, 6.567e-23, 8.254e-23, 1.021e-22, 1.226e-22, 1.472e-22, 1.738e-22, 2.054e-22, 2.39e-22, 2.792e-22, 3.186e-22, 3.632e-22, 4.109e-22, 4.561e-22, 5.065e-22, 5.583e-22, 6.024e-22, 6.285e-22, 6.737e-22, 7.773e-22, 8.669e-22, 9.106e-22, 1.009e-21, 1.206e-21, 1.394e-21, 1.448e-21, 1.369e-21, 1.249e-21, 1.173e-21, 1.169e-21, 1.219e-21, 1.296e-21, 1.38e-21, 1.454e-21, 1.504e-21, 1.516e-21, 1.485e-21, 1.408e-21, 1.31e-21, 1.211e-21, 1.133e-21, 1.091e-21]),
		ExplicitContinuum(j=19, i=2, wavelengthGrid=[31.658, 37.207, 42.756, 48.304, 53.853, 59.402, 64.95, 70.499, 76.048, 81.596, 87.145, 92.694, 98.242, 103.791, 109.339, 114.888, 120.437, 125.985, 131.534, 137.083, 142.631, 148.18, 153.729, 159.277, 164.826, 170.375, 175.923, 181.472, 187.021, 192.569, 198.118, 203.666, 209.215, 214.764, 220.312, 225.861, 231.41, 236.958, 242.507, 248.056, 253.604, 259.153, 264.702, 270.25, 275.799, 281.347, 286.896, 292.445, 297.993, 303.542], alphaGrid=[4.752e-24, 7.641e-24, 1.086e-23, 1.459e-23, 1.91e-23, 2.464e-23, 3.164e-23, 4.066e-23, 5.178e-23, 6.567e-23, 8.254e-23, 1.021e-22, 1.226e-22, 1.472e-22, 1.738e-22, 2.054e-22, 2.39e-22, 2.792e-22, 3.186e-22, 3.632e-22, 4.109e-22, 4.561e-22, 5.065e-22, 5.583e-22, 6.024e-22, 6.285e-22, 6.737e-22, 7.773e-22, 8.669e-22, 9.106e-22, 1.009e-21, 1.206e-21, 1.394e-21, 1.448e-21, 1.369e-21, 1.249e-21, 1.173e-21, 1.169e-21, 1.219e-21, 1.296e-21, 1.38e-21, 1.454e-21, 1.504e-21, 1.516e-21, 1.485e-21, 1.408e-21, 1.31e-21, 1.211e-21, 1.133e-21, 1.091e-21]),
		ExplicitContinuum(j=19, i=3, wavelengthGrid=[31.658, 37.207, 42.756, 48.304, 53.853, 59.402, 64.95, 70.499, 76.048, 81.596, 87.145, 92.694, 98.242, 103.791, 109.339, 114.888, 120.437, 125.985, 131.534, 137.083, 142.631, 148.18, 153.729, 159.277, 164.826, 170.375, 175.923, 181.472, 187.021, 192.569, 198.118, 203.666, 209.215, 214.764, 220.312, 225.861, 231.41, 236.958, 242.507, 248.056, 253.604, 259.153, 264.702, 270.25, 275.799, 281.347, 286.896, 292.445, 297.993, 303.542], alphaGrid=[4.752e-24, 7.641e-24, 1.086e-23, 1.459e-23, 1.91e-23, 2.464e-23, 3.164e-23, 4.066e-23, 5.178e-23, 6.567e-23, 8.254e-23, 1.021e-22, 1.226e-22, 1.472e-22, 1.738e-22, 2.054e-22, 2.39e-22, 2.792e-22, 3.186e-22, 3.632e-22, 4.109e-22, 4.561e-22, 5.065e-22, 5.583e-22, 6.024e-22, 6.285e-22, 6.737e-22, 7.773e-22, 8.669e-22, 9.106e-22, 1.009e-21, 1.206e-21, 1.394e-21, 1.448e-21, 1.369e-21, 1.249e-21, 1.173e-21, 1.169e-21, 1.219e-21, 1.296e-21, 1.38e-21, 1.454e-21, 1.504e-21, 1.516e-21, 1.485e-21, 1.408e-21, 1.31e-21, 1.211e-21, 1.133e-21, 1.091e-21]),
		ExplicitContinuum(j=19, i=4, wavelengthGrid=[19.392, 26.324, 33.256, 40.188, 47.12, 54.052, 60.983, 67.915, 74.847, 81.779, 88.711, 95.643, 102.575, 109.507, 116.439, 123.371, 130.303, 137.235, 144.167, 151.098, 158.03, 164.962, 171.894, 178.826, 185.758, 192.69, 199.622, 206.554, 213.486, 220.418, 227.35, 234.281, 241.213, 248.145, 255.077, 262.009, 268.941, 275.873, 282.805, 289.737, 296.669, 303.601, 310.533, 317.464, 324.396, 331.328, 338.26, 345.192, 352.124, 359.056], alphaGrid=[9.095e-24, 2.275e-23, 4.635e-23, 8.212e-23, 1.07e-22, 1.336e-22, 1.612e-22, 1.91e-22, 2.236e-22, 2.593e-22, 2.979e-22, 3.384e-22, 3.794e-22, 4.284e-22, 4.764e-22, 5.372e-22, 5.95e-22, 6.586e-22, 7.182e-22, 7.915e-22, 8.553e-22, 9.286e-22, 1.053e-21, 1.196e-21, 1.298e-21, 1.359e-21, 1.422e-21, 1.514e-21, 1.617e-21, 1.698e-21, 1.734e-21, 1.722e-21, 1.686e-21, 1.649e-21, 1.632e-21, 1.645e-21, 1.689e-21, 1.756e-21, 1.839e-21, 1.928e-21, 2.015e-21, 2.095e-21, 2.164e-21, 2.224e-21, 2.272e-21, 2.308e-21, 2.336e-21, 2.356e-21, 2.368e-21, 2.377e-21]),
		ExplicitContinuum(j=19, i=5, wavelengthGrid=[19.392, 26.324, 33.256, 40.188, 47.12, 54.052, 60.983, 67.915, 74.847, 81.779, 88.711, 95.643, 102.575, 109.507, 116.439, 123.371, 130.303, 137.235, 144.167, 151.098, 158.03, 164.962, 171.894, 178.826, 185.758, 192.69, 199.622, 206.554, 213.486, 220.418, 227.35, 234.281, 241.213, 248.145, 255.077, 262.009, 268.941, 275.873, 282.805, 289.737, 296.669, 303.601, 310.533, 317.464, 324.396, 331.328, 338.26, 345.192, 352.124, 359.056], alphaGrid=[9.095e-24, 2.275e-23, 4.635e-23, 8.212e-23, 1.07e-22, 1.336e-22, 1.612e-22, 1.91e-22, 2.236e-22, 2.593e-22, 2.979e-22, 3.384e-22, 3.794e-22, 4.284e-22, 4.764e-22, 5.372e-22, 5.95e-22, 6.586e-22, 7.182e-22, 7.915e-22, 8.553e-22, 9.286e-22, 1.053e-21, 1.196e-21, 1.298e-21, 1.359e-21, 1.422e-21, 1.514e-21, 1.617e-21, 1.698e-21, 1.734e-21, 1.722e-21, 1.686e-21, 1.649e-21, 1.632e-21, 1.645e-21, 1.689e-21, 1.756e-21, 1.839e-21, 1.928e-21, 2.015e-21, 2.095e-21, 2.164e-21, 2.224e-21, 2.272e-21, 2.308e-21, 2.336e-21, 2.356e-21, 2.368e-21, 2.377e-21]),
		ExplicitContinuum(j=19, i=6, wavelengthGrid=[19.392, 26.324, 33.256, 40.188, 47.12, 54.052, 60.983, 67.915, 74.847, 81.779, 88.711, 95.643, 102.575, 109.507, 116.439, 123.371, 130.303, 137.235, 144.167, 151.098, 158.03, 164.962, 171.894, 178.826, 185.758, 192.69, 199.622, 206.554, 213.486, 220.418, 227.35, 234.281, 241.213, 248.145, 255.077, 262.009, 268.941, 275.873, 282.805, 289.737, 296.669, 303.601, 310.533, 317.464, 324.396, 331.328, 338.26, 345.192, 352.124, 359.056], alphaGrid=[9.095e-24, 2.275e-23, 4.635e-23, 8.212e-23, 1.07e-22, 1.336e-22, 1.612e-22, 1.91e-22, 2.236e-22, 2.593e-22, 2.979e-22, 3.384e-22, 3.794e-22, 4.284e-22, 4.764e-22, 5.372e-22, 5.95e-22, 6.586e-22, 7.182e-22, 7.915e-22, 8.553e-22, 9.286e-22, 1.053e-21, 1.196e-21, 1.298e-21, 1.359e-21, 1.422e-21, 1.514e-21, 1.617e-21, 1.698e-21, 1.734e-21, 1.722e-21, 1.686e-21, 1.649e-21, 1.632e-21, 1.645e-21, 1.689e-21, 1.756e-21, 1.839e-21, 1.928e-21, 2.015e-21, 2.095e-21, 2.164e-21, 2.224e-21, 2.272e-21, 2.308e-21, 2.336e-21, 2.356e-21, 2.368e-21, 2.377e-21]),
		ExplicitContinuum(j=19, i=7, wavelengthGrid=[21.475, 28.78, 36.084, 43.389, 50.693, 57.998, 65.302, 72.607, 79.911, 87.215, 94.52, 101.824, 109.129, 116.433, 123.738, 131.042, 138.347, 145.651, 152.956, 160.26, 167.565, 174.869, 182.174, 189.478, 196.783, 204.087, 211.392, 218.696, 226.001, 233.305, 240.609, 247.914, 255.218, 262.523, 269.827, 277.132, 284.436, 291.741, 299.045, 306.35, 313.654, 320.959, 328.263, 335.568, 342.872, 350.177, 357.481, 364.786, 372.09, 379.394], alphaGrid=[1.016e-23, 2.438e-23, 4.832e-23, 7.798e-23, 9.865e-23, 1.24e-22, 1.504e-22, 1.787e-22, 2.145e-22, 2.576e-22, 2.986e-22, 3.47e-22, 3.988e-22, 4.596e-22, 5.26e-22, 5.975e-22, 6.684e-22, 7.387e-22, 8.096e-22, 8.87e-22, 9.716e-22, 1.055e-21, 1.151e-21, 1.258e-21, 1.367e-21, 1.486e-21, 1.629e-21, 1.79e-21, 1.942e-21, 2.058e-21, 2.129e-21, 2.167e-21, 2.189e-21, 2.212e-21, 2.244e-21, 2.289e-21, 2.345e-21, 2.412e-21, 2.489e-21, 2.575e-21, 2.667e-21, 2.763e-21, 2.86e-21, 2.956e-21, 3.044e-21, 3.122e-21, 3.191e-21, 3.241e-21, 3.276e-21, 3.301e-21]),
		ExplicitContinuum(j=19, i=8, wavelengthGrid=[26.318, 34.092, 41.866, 49.64, 57.414, 65.188, 72.962, 80.737, 88.511, 96.285, 104.059, 111.833, 119.607, 127.381, 135.155, 142.929, 150.703, 158.477, 166.251, 174.025, 181.8, 189.574, 197.348, 205.122, 212.896, 220.67, 228.444, 236.218, 243.992, 251.766, 259.54, 267.314, 275.088, 282.863, 290.637, 298.411, 306.185, 313.959, 321.733, 329.507, 337.281, 345.055, 352.829, 360.603, 368.377, 376.151, 383.926, 391.7, 399.474, 407.248], alphaGrid=[5.422e-24, 1.16e-23, 2.091e-23, 2.796e-23, 3.474e-23, 4.191e-23, 5.015e-23, 6.211e-23, 7.615e-23, 9.551e-23, 1.163e-22, 1.421e-22, 1.703e-22, 2.058e-22, 2.436e-22, 2.821e-22, 3.356e-22, 3.836e-22, 4.474e-22, 5.013e-22, 5.819e-22, 6.37e-22, 6.875e-22, 7.99e-22, 9.698e-22, 1.174e-21, 1.401e-21, 1.641e-21, 1.881e-21, 2.096e-21, 2.245e-21, 2.296e-21, 2.277e-21, 2.258e-21, 2.337e-21, 2.602e-21, 3.078e-21, 3.694e-21, 4.351e-21, 4.932e-21, 5.333e-21, 5.494e-21, 5.411e-21, 5.121e-21, 4.69e-21, 4.184e-21, 3.679e-21, 3.263e-21, 2.95e-21, 2.739e-21]),
		ExplicitContinuum(j=19, i=9, wavelengthGrid=[42.152, 53.535, 64.919, 76.303, 87.686, 99.07, 110.454, 121.838, 133.221, 144.605, 155.989, 167.372, 178.756, 190.14, 201.524, 212.907, 224.291, 235.675, 247.059, 258.442, 269.826, 281.21, 292.594, 303.977, 315.361, 326.745, 338.128, 349.512, 360.896, 372.28, 383.663, 395.047, 406.431, 417.815, 429.198, 440.582, 451.966, 463.349, 474.733, 486.117, 497.501, 508.884, 520.268, 531.652, 543.036, 554.419, 565.803, 577.187, 588.57, 599.954], alphaGrid=[1.351e-24, 1.678e-24, 2.162e-24, 2.974e-24, 3.677e-24, 5.126e-24, 5.841e-24, 7.93e-24, 1.02e-23, 1.068e-23, 1.791e-23, 2.863e-23, 3.916e-23, 4.803e-23, 5.555e-23, 9.278e-23, 1.363e-22, 1.348e-22, 2.166e-22, 2.239e-22, 4.353e-22, 6.467e-22, 7.994e-22, 1.17e-21, 1.278e-21, 2.222e-21, 6.364e-21, 1.357e-20, 2.009e-20, 2.234e-20, 1.964e-20, 1.395e-20, 8.128e-21, 3.867e-21, 1.7e-21, 9.412e-22, 1.01e-21, 1.215e-21, 1.313e-21, 1.245e-21, 1.058e-21, 8.333e-22, 6.23e-22, 4.473e-22, 3.096e-22, 2.037e-22, 1.216e-22, 5.995e-23, 2.134e-23, 8.84e-24]),
		ExplicitContinuum(j=19, i=10, wavelengthGrid=[70.588, 82.854, 95.119, 107.384, 119.649, 131.915, 144.18, 156.445, 168.71, 180.976, 193.241, 205.506, 217.771, 230.037, 242.302, 254.567, 266.832, 279.098, 291.363, 303.628, 315.893, 328.159, 340.424, 352.689, 364.954, 377.22, 389.485, 401.75, 414.015, 426.281, 438.546, 450.811, 463.077, 475.342, 487.607, 499.872, 512.138, 524.403, 536.668, 548.933, 561.199, 573.464, 585.729, 597.994, 610.26, 622.525, 634.79, 647.055, 659.321, 671.586], alphaGrid=[1.648e-24, 2.055e-24, 3.019e-24, 4.577e-24, 8.38e-24, 1.442e-23, 2.439e-23, 3.82e-23, 5.755e-23, 8.12e-23, 1.138e-22, 1.576e-22, 2.165e-22, 2.866e-22, 3.641e-22, 4.777e-22, 6.662e-22, 7.928e-22, 7.721e-22, 1.692e-21, 2.232e-21, 1.84e-21, 2.258e-21, 3.694e-21, 6.509e-21, 1.499e-20, 2.629e-20, 2.838e-20, 1.931e-20, 8.693e-21, 2.912e-21, 1.244e-21, 8.558e-22, 7.153e-22, 7.294e-22, 8.083e-22, 7.949e-22, 6.599e-22, 4.843e-22, 3.451e-22, 2.5e-22, 1.882e-22, 1.562e-22, 1.699e-22, 2.37e-22, 3.632e-22, 5.174e-22, 6.685e-22, 7.866e-22, 8.499e-22]),
		HydrogenicContinuum(j=19, i=11, NlambdaGen=20, alpha0=2.539e-22, minWavelength=250),
		HydrogenicContinuum(j=19, i=12, NlambdaGen=20, alpha0=1.692e-20, minWavelength=250),
		HydrogenicContinuum(j=19, i=13, NlambdaGen=20, alpha0=1.645e-21, minWavelength=260),
		HydrogenicContinuum(j=19, i=14, NlambdaGen=20, alpha0=4.218e-21, minWavelength=265),
		HydrogenicContinuum(j=19, i=15, NlambdaGen=20, alpha0=1.105e-21, minWavelength=280),
		HydrogenicContinuum(j=19, i=16, NlambdaGen=20, alpha0=1.018e-21, minWavelength=280),
		HydrogenicContinuum(j=19, i=17, NlambdaGen=20, alpha0=1.018e-21, minWavelength=280),
		HydrogenicContinuum(j=19, i=18, NlambdaGen=20, alpha0=1.018e-21, minWavelength=280),
		HydrogenicContinuum(j=44, i=19, NlambdaGen=20, alpha0=3.892e-23, minWavelength=22),
		ExplicitContinuum(j=44, i=20, wavelengthGrid=[36.5, 42.0, 48.3, 53.6, 54.5, 55.5, 56.4, 57.4, 58.4, 59.5, 60.6, 61.8, 63.0, 64.2, 65.5, 66.8, 68.2, 69.7, 71.2, 72.8, 74.5, 76.2, 78.1, 80.0, 82.0, 84.1, 86.3, 88.7, 91.2, 93.8, 96.6, 99.6, 102.7, 106.0, 109.6, 113.4, 117.5, 121.9, 126.7, 131.8], alphaGrid=[1.645e-23, 2.503e-23, 3.81e-23, 5.295e-23, 6.255e-23, 7.431e-23, 8.655e-23, 9.888e-23, 1.112e-22, 1.235e-22, 1.36e-22, 1.484e-22, 1.608e-22, 1.734e-22, 1.862e-22, 1.991e-22, 2.123e-22, 2.258e-22, 2.397e-22, 2.542e-22, 2.691e-22, 2.849e-22, 3.014e-22, 3.187e-22, 3.37e-22, 3.563e-22, 3.767e-22, 3.981e-22, 4.208e-22, 4.445e-22, 4.695e-22, 4.956e-22, 5.23e-22, 5.517e-22, 5.821e-22, 6.143e-22, 6.487e-22, 6.858e-22, 7.26e-22, 7.696e-22]),
		ExplicitContinuum(j=44, i=21, wavelengthGrid=[36.5, 42.0, 48.3, 53.6, 54.5, 55.5, 56.4, 57.4, 58.4, 59.5, 60.6, 61.8, 63.0, 64.2, 65.5, 66.8, 68.2, 69.7, 71.2, 72.8, 74.5, 76.2, 78.1, 80.0, 82.0, 84.1, 86.3, 88.7, 91.2, 93.8, 96.6, 99.6, 102.7, 106.0, 109.6, 113.4, 117.5, 121.9, 126.7, 131.8], alphaGrid=[1.645e-23, 2.503e-23, 3.81e-23, 5.295e-23, 6.255e-23, 7.431e-23, 8.655e-23, 9.888e-23, 1.112e-22, 1.235e-22, 1.36e-22, 1.484e-22, 1.608e-22, 1.734e-22, 1.862e-22, 1.991e-22, 2.123e-22, 2.258e-22, 2.397e-22, 2.542e-22, 2.691e-22, 2.849e-22, 3.014e-22, 3.187e-22, 3.37e-22, 3.563e-22, 3.767e-22, 3.981e-22, 4.208e-22, 4.445e-22, 4.695e-22, 4.956e-22, 5.23e-22, 5.517e-22, 5.821e-22, 6.143e-22, 6.487e-22, 6.858e-22, 7.26e-22, 7.696e-22]),
		ExplicitContinuum(j=44, i=22, wavelengthGrid=[37.4, 41.3, 45.6, 50.4, 55.7, 60.5, 61.4, 62.2, 63.1, 63.9, 64.9, 65.8, 66.8, 67.7, 68.8, 69.8, 70.9, 72.0, 73.2, 74.4, 75.6, 76.9, 78.2, 79.6, 81.0, 82.5, 84.0, 85.6, 87.2, 88.9, 90.7, 92.5, 94.4, 96.4, 98.5, 100.7, 103.0, 105.3, 107.8, 110.4, 113.2, 116.1, 119.1, 122.3, 125.7, 129.2, 133.0, 137.0, 141.3, 145.8], alphaGrid=[5.077e-24, 6.854e-24, 9.252e-24, 1.249e-23, 1.686e-23, 2.143e-23, 2.146e-23, 2.157e-23, 2.175e-23, 2.201e-23, 2.234e-23, 2.275e-23, 2.326e-23, 2.386e-23, 2.456e-23, 2.536e-23, 2.628e-23, 2.732e-23, 2.849e-23, 2.98e-23, 3.127e-23, 3.29e-23, 3.472e-23, 3.676e-23, 3.902e-23, 4.155e-23, 4.434e-23, 4.745e-23, 5.09e-23, 5.474e-23, 5.9e-23, 6.373e-23, 6.897e-23, 7.479e-23, 8.124e-23, 8.839e-23, 9.63e-23, 1.051e-22, 1.148e-22, 1.256e-22, 1.376e-22, 1.509e-22, 1.657e-22, 1.822e-22, 2.006e-22, 2.214e-22, 2.446e-22, 2.71e-22, 3.008e-22, 3.348e-22]),
		ExplicitContinuum(j=44, i=23, wavelengthGrid=[37.4, 41.3, 45.6, 50.4, 55.7, 60.5, 61.4, 62.2, 63.1, 63.9, 64.9, 65.8, 66.8, 67.7, 68.8, 69.8, 70.9, 72.0, 73.2, 74.4, 75.6, 76.9, 78.2, 79.6, 81.0, 82.5, 84.0, 85.6, 87.2, 88.9, 90.7, 92.5, 94.4, 96.4, 98.5, 100.7, 103.0, 105.3, 107.8, 110.4, 113.2, 116.1, 119.1, 122.3, 125.7, 129.2, 133.0, 137.0, 141.3, 145.8], alphaGrid=[5.077e-24, 6.854e-24, 9.252e-24, 1.249e-23, 1.686e-23, 2.143e-23, 2.146e-23, 2.157e-23, 2.175e-23, 2.201e-23, 2.234e-23, 2.275e-23, 2.326e-23, 2.386e-23, 2.456e-23, 2.536e-23, 2.628e-23, 2.732e-23, 2.849e-23, 2.98e-23, 3.127e-23, 3.29e-23, 3.472e-23, 3.676e-23, 3.902e-23, 4.155e-23, 4.434e-23, 4.745e-23, 5.09e-23, 5.474e-23, 5.9e-23, 6.373e-23, 6.897e-23, 7.479e-23, 8.124e-23, 8.839e-23, 9.63e-23, 1.051e-22, 1.148e-22, 1.256e-22, 1.376e-22, 1.509e-22, 1.657e-22, 1.822e-22, 2.006e-22, 2.214e-22, 2.446e-22, 2.71e-22, 3.008e-22, 3.348e-22]),
		HydrogenicContinuum(j=44, i=24, NlambdaGen=20, alpha0=1.463e-23, minWavelength=48),
		HydrogenicContinuum(j=44, i=25, NlambdaGen=20, alpha0=2.173e-22, minWavelength=54),
		HydrogenicContinuum(j=44, i=26, NlambdaGen=20, alpha0=2.173e-22, minWavelength=54),
		HydrogenicContinuum(j=44, i=27, NlambdaGen=20, alpha0=6.389e-22, minWavelength=54),
		HydrogenicContinuum(j=44, i=28, NlambdaGen=20, alpha0=6.389e-22, minWavelength=54),
		ExplicitContinuum(j=44, i=29, wavelengthGrid=[63.9, 65.0, 66.1, 67.3, 68.5, 69.7, 71.1, 72.4, 73.8, 75.3, 76.8, 78.4, 80.0, 81.8, 83.6, 85.4, 87.4, 89.5, 91.6, 93.9, 96.3, 98.8, 101.4, 104.2, 107.1, 110.3, 113.5, 117.0, 120.8, 124.7, 129.0, 133.5, 138.4, 143.6, 149.3, 155.4, 162.0, 169.2, 177.1, 185.8, 195.3, 205.8, 217.6, 230.9, 245.8, 262.9, 282.4, 305.1, 331.8, 363.6], alphaGrid=[5.098e-25, 5.478e-25, 5.886e-25, 6.327e-25, 6.803e-25, 7.319e-25, 7.879e-25, 8.489e-25, 9.157e-25, 9.888e-25, 1.069e-24, 1.158e-24, 1.258e-24, 1.367e-24, 1.49e-24, 1.627e-24, 1.783e-24, 1.958e-24, 2.157e-24, 2.382e-24, 2.639e-24, 2.934e-24, 3.27e-24, 3.657e-24, 4.103e-24, 4.617e-24, 5.214e-24, 5.909e-24, 6.72e-24, 7.672e-24, 8.794e-24, 1.012e-23, 1.171e-23, 1.361e-23, 1.589e-23, 1.868e-23, 2.209e-23, 2.63e-23, 3.155e-23, 3.816e-23, 4.656e-23, 5.738e-23, 7.145e-23, 9.005e-23, 1.15e-22, 1.489e-22, 1.962e-22, 2.632e-22, 3.61e-22, 5.076e-22]),
		ExplicitContinuum(j=44, i=30, wavelengthGrid=[63.9, 65.0, 66.1, 67.3, 68.5, 69.7, 71.1, 72.4, 73.8, 75.3, 76.8, 78.4, 80.0, 81.8, 83.6, 85.4, 87.4, 89.5, 91.6, 93.9, 96.3, 98.8, 101.4, 104.2, 107.1, 110.3, 113.5, 117.0, 120.8, 124.7, 129.0, 133.5, 138.4, 143.6, 149.3, 155.4, 162.0, 169.2, 177.1, 185.8, 195.3, 205.8, 217.6, 230.9, 245.8, 262.9, 282.4, 305.1, 331.8, 363.6], alphaGrid=[5.098e-25, 5.478e-25, 5.886e-25, 6.327e-25, 6.803e-25, 7.319e-25, 7.879e-25, 8.489e-25, 9.157e-25, 9.888e-25, 1.069e-24, 1.158e-24, 1.258e-24, 1.367e-24, 1.49e-24, 1.627e-24, 1.783e-24, 1.958e-24, 2.157e-24, 2.382e-24, 2.639e-24, 2.934e-24, 3.27e-24, 3.657e-24, 4.103e-24, 4.617e-24, 5.214e-24, 5.909e-24, 6.72e-24, 7.672e-24, 8.794e-24, 1.012e-23, 1.171e-23, 1.361e-23, 1.589e-23, 1.868e-23, 2.209e-23, 2.63e-23, 3.155e-23, 3.816e-23, 4.656e-23, 5.738e-23, 7.145e-23, 9.005e-23, 1.15e-22, 1.489e-22, 1.962e-22, 2.632e-22, 3.61e-22, 5.076e-22]),
		HydrogenicContinuum(j=44, i=31, NlambdaGen=20, alpha0=1.25e-23, minWavelength=80),
		HydrogenicContinuum(j=44, i=32, NlambdaGen=20, alpha0=6.821e-23, minWavelength=90),
		HydrogenicContinuum(j=44, i=33, NlambdaGen=20, alpha0=6.821e-23, minWavelength=90),
		HydrogenicContinuum(j=44, i=34, NlambdaGen=20, alpha0=9.891e-22, minWavelength=57),
		HydrogenicContinuum(j=44, i=35, NlambdaGen=20, alpha0=9.891e-22, minWavelength=57),
		HydrogenicContinuum(j=44, i=36, NlambdaGen=20, alpha0=1.087e-21, minWavelength=57),
		HydrogenicContinuum(j=44, i=37, NlambdaGen=20, alpha0=1.087e-21, minWavelength=57),
		HydrogenicContinuum(j=44, i=38, NlambdaGen=20, alpha0=1.078e-23, minWavelength=130),
		HydrogenicContinuum(j=44, i=39, NlambdaGen=20, alpha0=1.173e-23, minWavelength=130),
		HydrogenicContinuum(j=44, i=40, NlambdaGen=20, alpha0=1.173e-23, minWavelength=130),
		ExplicitContinuum(j=44, i=41, wavelengthGrid=[67.2, 68.9, 70.6, 72.4, 74.2, 76.2, 78.3, 80.5, 82.9, 85.4, 88.0, 90.8, 93.8, 97.0, 100.4, 104.1, 108.0, 112.3, 116.9, 121.9, 127.4, 133.3, 139.9, 147.1, 155.1, 164.1, 174.1, 185.4, 198.4, 213.1, 230.4, 250.6, 274.9, 304.2, 340.7, 387.0, 447.9, 531.5, 653.4, 817.7], alphaGrid=[3.227e-25, 3.44e-25, 3.688e-25, 3.988e-25, 4.354e-25, 4.802e-25, 5.35e-25, 6.016e-25, 6.819e-25, 7.778e-25, 8.912e-25, 1.024e-24, 1.18e-24, 1.36e-24, 1.568e-24, 1.808e-24, 2.087e-24, 2.413e-24, 2.796e-24, 3.253e-24, 3.806e-24, 4.484e-24, 5.326e-24, 6.389e-24, 7.748e-24, 9.507e-24, 1.181e-23, 1.488e-23, 1.899e-23, 2.461e-23, 3.244e-23, 4.355e-23, 5.972e-23, 8.401e-23, 1.218e-22, 1.836e-22, 2.901e-22, 4.878e-22, 8.924e-22, 1.671e-21]),
		ExplicitContinuum(j=44, i=42, wavelengthGrid=[67.2, 68.9, 70.6, 72.4, 74.2, 76.2, 78.3, 80.5, 82.9, 85.4, 88.0, 90.8, 93.8, 97.0, 100.4, 104.1, 108.0, 112.3, 116.9, 121.9, 127.4, 133.3, 139.9, 147.1, 155.1, 164.1, 174.1, 185.4, 198.4, 213.1, 230.4, 250.6, 274.9, 304.2, 340.7, 387.0, 447.9, 531.5, 653.4, 817.7], alphaGrid=[3.227e-25, 3.44e-25, 3.688e-25, 3.988e-25, 4.354e-25, 4.802e-25, 5.35e-25, 6.016e-25, 6.819e-25, 7.778e-25, 8.912e-25, 1.024e-24, 1.18e-24, 1.36e-24, 1.568e-24, 1.808e-24, 2.087e-24, 2.413e-24, 2.796e-24, 3.253e-24, 3.806e-24, 4.484e-24, 5.326e-24, 6.389e-24, 7.748e-24, 9.507e-24, 1.181e-23, 1.488e-23, 1.899e-23, 2.461e-23, 3.244e-23, 4.355e-23, 5.972e-23, 8.401e-23, 1.218e-22, 1.836e-22, 2.901e-22, 4.878e-22, 8.924e-22, 1.671e-21]),
		HydrogenicContinuum(j=44, i=43, NlambdaGen=20, alpha0=9.064e-24, minWavelength=180),
	],
	collisions=[
		CE(j=1, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.124e-15, 9.351e-16, 7.778e-16, 6.47e-16, 5.381e-16, 4.476e-16, 3.723e-16, 3.097e-16, 2.576e-16, 2.142e-16, 1.782e-16, 1.482e-16, 1.233e-16]),
		CE(j=2, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.88e-17, 1.065e-17, 6.074e-18, 3.497e-18, 2.043e-18, 1.217e-18, 7.409e-19, 4.606e-19, 2.908e-19, 1.853e-19, 1.184e-19, 7.543e-20, 4.776e-20]),
		CE(j=3, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.105e-15, 9.19e-16, 7.644e-16, 6.358e-16, 5.288e-16, 4.399e-16, 3.659e-16, 3.043e-16, 2.531e-16, 2.105e-16, 1.751e-16, 1.457e-16, 1.211e-16]),
		CE(j=4, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.863e-16, 5.708e-16, 4.748e-16, 3.949e-16, 3.285e-16, 2.732e-16, 2.272e-16, 1.89e-16, 1.572e-16, 1.308e-16, 1.088e-16, 9.047e-17, 7.525e-17]),
		CE(j=5, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.855e-16, 5.702e-16, 4.742e-16, 3.945e-16, 3.281e-16, 2.729e-16, 2.27e-16, 1.888e-16, 1.57e-16, 1.306e-16, 1.086e-16, 9.036e-17, 7.516e-17]),
		CE(j=6, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.843e-16, 5.691e-16, 4.734e-16, 3.937e-16, 3.275e-16, 2.724e-16, 2.266e-16, 1.885e-16, 1.568e-16, 1.304e-16, 1.084e-16, 9.02e-17, 7.503e-17]),
		CE(j=7, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.083e-16, 5.059e-16, 4.208e-16, 3.5e-16, 2.911e-16, 2.422e-16, 2.014e-16, 1.675e-16, 1.393e-16, 1.159e-16, 9.64e-17, 8.018e-17, 6.669e-17]),
		CE(j=8, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.115e-13, 6.41e-14, 3.746e-14, 2.247e-14, 1.402e-14, 9.234e-15, 6.46e-15, 4.757e-15, 3.578e-15, 2.607e-15, 1.846e-15, 1.244e-15, 8.377e-16]),
		CE(j=9, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.283e-16, 2.731e-16, 2.271e-16, 1.889e-16, 1.571e-16, 1.307e-16, 1.087e-16, 9.042e-17, 7.521e-17, 6.256e-17, 5.203e-17, 4.328e-17, 3.6e-17]),
		CE(j=10, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.994e-16, 2.49e-16, 2.071e-16, 1.723e-16, 1.433e-16, 1.192e-16, 9.914e-17, 8.247e-17, 6.859e-17, 5.705e-17, 4.745e-17, 3.947e-17, 3.283e-17]),
		CE(j=11, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.65e-16, 2.204e-16, 1.833e-16, 1.525e-16, 1.268e-16, 1.055e-16, 8.774e-17, 7.298e-17, 6.07e-17, 5.049e-17, 4.199e-17, 3.493e-17, 2.905e-17]),
		CE(j=12, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.649e-16, 2.203e-16, 1.833e-16, 1.524e-16, 1.268e-16, 1.055e-16, 8.772e-17, 7.296e-17, 6.069e-17, 5.048e-17, 4.199e-17, 3.492e-17, 2.905e-17]),
		CE(j=13, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.561e-16, 2.13e-16, 1.772e-16, 1.474e-16, 1.226e-16, 1.02e-16, 8.48e-17, 7.053e-17, 5.867e-17, 4.88e-17, 4.059e-17, 3.376e-17, 2.808e-17]),
		CE(j=14, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.819e-17, 4.417e-17, 2.505e-17, 1.429e-17, 8.245e-18, 4.839e-18, 2.91e-18, 1.804e-18, 1.152e-18, 7.534e-19, 4.996e-19, 3.325e-19, 2.203e-19]),
		CE(j=15, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.477e-16, 2.06e-16, 1.714e-16, 1.425e-16, 1.186e-16, 9.861e-17, 8.202e-17, 6.822e-17, 5.674e-17, 4.72e-17, 3.926e-17, 3.265e-17, 2.716e-17]),
		CE(j=16, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.428e-16, 2.019e-16, 1.679e-16, 1.397e-16, 1.162e-16, 9.664e-17, 8.038e-17, 6.686e-17, 5.561e-17, 4.626e-17, 3.847e-17, 3.2e-17, 2.662e-17]),
		CE(j=17, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.427e-16, 2.019e-16, 1.679e-16, 1.397e-16, 1.162e-16, 9.663e-17, 8.037e-17, 6.685e-17, 5.56e-17, 4.625e-17, 3.847e-17, 3.2e-17, 2.661e-17]),
		CE(j=18, i=0, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.427e-16, 2.018e-16, 1.679e-16, 1.396e-16, 1.161e-16, 9.66e-17, 8.035e-17, 6.683e-17, 5.559e-17, 4.624e-17, 3.846e-17, 3.199e-17, 2.661e-17]),
		CE(j=2, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.546e-11, 1.286e-11, 1.07e-11, 8.896e-12, 7.399e-12, 6.155e-12, 5.119e-12, 4.258e-12, 3.542e-12, 2.946e-12, 2.45e-12, 2.038e-12, 1.695e-12]),
		CE(j=3, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.401e-12, 1.997e-12, 1.661e-12, 1.382e-12, 1.149e-12, 9.559e-13, 7.951e-13, 6.613e-13, 5.501e-13, 4.575e-13, 3.806e-13, 3.165e-13, 2.633e-13]),
		CE(j=4, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.833e-15, 5.684e-15, 4.728e-15, 3.932e-15, 3.271e-15, 2.72e-15, 2.263e-15, 1.882e-15, 1.565e-15, 1.302e-15, 1.083e-15, 9.008e-16, 7.493e-16]),
		CE(j=5, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.803e-15, 5.658e-15, 4.706e-15, 3.915e-15, 3.256e-15, 2.708e-15, 2.253e-15, 1.874e-15, 1.558e-15, 1.296e-15, 1.078e-15, 8.968e-16, 7.459e-16]),
		CE(j=6, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.755e-15, 5.619e-15, 4.673e-15, 3.887e-15, 3.233e-15, 2.689e-15, 2.237e-15, 1.861e-15, 1.548e-15, 1.287e-15, 1.071e-15, 8.905e-16, 7.407e-16]),
		CE(j=7, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.441e-15, 3.694e-15, 3.072e-15, 2.555e-15, 2.125e-15, 1.768e-15, 1.47e-15, 1.223e-15, 1.017e-15, 8.462e-16, 7.038e-16, 5.854e-16, 4.869e-16]),
		CE(j=8, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.974e-15, 2.474e-15, 2.058e-15, 1.712e-15, 1.424e-15, 1.184e-15, 9.849e-16, 8.192e-16, 6.814e-16, 5.668e-16, 4.714e-16, 3.921e-16, 3.261e-16]),
		CE(j=9, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.855e-14, 1.621e-14, 9.274e-15, 5.372e-15, 3.17e-15, 1.919e-15, 1.196e-15, 7.652e-16, 4.992e-16, 3.289e-16, 2.168e-16, 1.422e-16, 9.229e-17]),
		CE(j=10, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.3e-16, 6.903e-16, 5.742e-16, 4.776e-16, 3.973e-16, 3.304e-16, 2.748e-16, 2.286e-16, 1.901e-16, 1.581e-16, 1.315e-16, 1.094e-16, 9.101e-17]),
		CE(j=11, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.675e-16, 5.552e-16, 4.618e-16, 3.841e-16, 3.195e-16, 2.657e-16, 2.21e-16, 1.839e-16, 1.529e-16, 1.272e-16, 1.058e-16, 8.8e-17, 7.319e-17]),
		CE(j=12, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.673e-16, 5.55e-16, 4.617e-16, 3.84e-16, 3.194e-16, 2.657e-16, 2.21e-16, 1.838e-16, 1.529e-16, 1.272e-16, 1.058e-16, 8.797e-17, 7.317e-17]),
		CE(j=13, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.295e-16, 5.236e-16, 4.355e-16, 3.622e-16, 3.013e-16, 2.506e-16, 2.085e-16, 1.734e-16, 1.442e-16, 1.2e-16, 9.977e-17, 8.299e-17, 6.903e-17]),
		CE(j=14, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.214e-16, 5.168e-16, 4.299e-16, 3.576e-16, 2.974e-16, 2.474e-16, 2.058e-16, 1.711e-16, 1.424e-16, 1.184e-16, 9.848e-17, 8.191e-17, 6.813e-17]),
		CE(j=15, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.949e-16, 4.948e-16, 4.116e-16, 3.423e-16, 2.847e-16, 2.368e-16, 1.97e-16, 1.638e-16, 1.363e-16, 1.134e-16, 9.429e-17, 7.842e-17, 6.523e-17]),
		CE(j=16, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.207e-14, 2.952e-14, 1.684e-14, 9.712e-15, 5.699e-15, 3.43e-15, 2.13e-15, 1.367e-15, 9.007e-16, 6.028e-16, 4.052e-16, 2.712e-16, 1.797e-16]),
		CE(j=17, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.75e-16, 4.782e-16, 3.978e-16, 3.309e-16, 2.752e-16, 2.289e-16, 1.904e-16, 1.584e-16, 1.317e-16, 1.096e-16, 9.113e-17, 7.58e-17, 6.304e-17]),
		CE(j=18, i=1, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.747e-16, 4.78e-16, 3.976e-16, 3.307e-16, 2.751e-16, 2.288e-16, 1.903e-16, 1.583e-16, 1.317e-16, 1.095e-16, 9.109e-17, 7.576e-17, 6.302e-17]),
		CE(j=3, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.706e-12, 3.914e-12, 3.256e-12, 2.708e-12, 2.253e-12, 1.874e-12, 1.558e-12, 1.296e-12, 1.078e-12, 8.967e-13, 7.459e-13, 6.204e-13, 5.16e-13]),
		CE(j=4, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.951e-15, 5.781e-15, 4.809e-15, 4e-15, 3.327e-15, 2.767e-15, 2.302e-15, 1.914e-15, 1.592e-15, 1.324e-15, 1.102e-15, 9.163e-16, 7.621e-16]),
		CE(j=5, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.919e-15, 5.755e-15, 4.787e-15, 3.982e-15, 3.312e-15, 2.755e-15, 2.291e-15, 1.906e-15, 1.585e-15, 1.318e-15, 1.097e-15, 9.121e-16, 7.587e-16]),
		CE(j=6, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.87e-15, 5.714e-15, 4.753e-15, 3.953e-15, 3.288e-15, 2.735e-15, 2.275e-15, 1.892e-15, 1.574e-15, 1.309e-15, 1.089e-15, 9.057e-16, 7.533e-16]),
		CE(j=7, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.499e-15, 3.742e-15, 3.113e-15, 2.589e-15, 2.154e-15, 1.791e-15, 1.49e-15, 1.239e-15, 1.031e-15, 8.574e-16, 7.131e-16, 5.931e-16, 4.934e-16]),
		CE(j=8, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.005e-15, 2.5e-15, 2.079e-15, 1.729e-15, 1.438e-15, 1.196e-15, 9.952e-16, 8.278e-16, 6.885e-16, 5.727e-16, 4.763e-16, 3.962e-16, 3.295e-16]),
		CE(j=9, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.887e-14, 1.639e-14, 9.38e-15, 5.433e-15, 3.207e-15, 1.942e-15, 1.21e-15, 7.744e-16, 5.052e-16, 3.328e-16, 2.194e-16, 1.439e-16, 9.338e-17]),
		CE(j=10, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.34e-16, 6.937e-16, 5.77e-16, 4.799e-16, 3.992e-16, 3.32e-16, 2.762e-16, 2.297e-16, 1.911e-16, 1.589e-16, 1.322e-16, 1.099e-16, 9.145e-17]),
		CE(j=11, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.704e-16, 5.576e-16, 4.638e-16, 3.858e-16, 3.209e-16, 2.669e-16, 2.22e-16, 1.846e-16, 1.536e-16, 1.277e-16, 1.062e-16, 8.837e-17, 7.35e-17]),
		CE(j=12, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.701e-16, 5.574e-16, 4.636e-16, 3.856e-16, 3.207e-16, 2.668e-16, 2.219e-16, 1.846e-16, 1.535e-16, 1.277e-16, 1.062e-16, 8.834e-17, 7.348e-17]),
		CE(j=13, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.321e-16, 5.258e-16, 4.373e-16, 3.637e-16, 3.025e-16, 2.516e-16, 2.093e-16, 1.741e-16, 1.448e-16, 1.204e-16, 1.002e-16, 8.333e-17, 6.931e-17]),
		CE(j=14, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.239e-16, 5.189e-16, 4.316e-16, 3.59e-16, 2.986e-16, 2.484e-16, 2.066e-16, 1.718e-16, 1.429e-16, 1.189e-16, 9.888e-17, 8.225e-17, 6.841e-17]),
		CE(j=15, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.973e-16, 4.968e-16, 4.132e-16, 3.437e-16, 2.859e-16, 2.378e-16, 1.978e-16, 1.645e-16, 1.368e-16, 1.138e-16, 9.466e-17, 7.873e-17, 6.549e-17]),
		CE(j=16, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.334e-14, 7.565e-15, 4.316e-15, 2.489e-15, 1.461e-15, 8.792e-16, 5.462e-16, 3.505e-16, 2.31e-16, 1.546e-16, 1.039e-16, 6.956e-17, 4.609e-17]),
		CE(j=17, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.946e-14, 2.237e-14, 1.276e-14, 7.362e-15, 4.32e-15, 2.6e-15, 1.615e-15, 1.037e-15, 6.831e-16, 4.572e-16, 3.074e-16, 2.057e-16, 1.363e-16]),
		CE(j=18, i=2, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.77e-16, 4.799e-16, 3.992e-16, 3.32e-16, 2.762e-16, 2.297e-16, 1.911e-16, 1.589e-16, 1.322e-16, 1.099e-16, 9.144e-17, 7.606e-17, 6.326e-17]),
		CE(j=4, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.199e-15, 5.988e-15, 4.98e-15, 4.142e-15, 3.446e-15, 2.866e-15, 2.384e-15, 1.983e-15, 1.649e-15, 1.372e-15, 1.141e-15, 9.49e-16, 7.893e-16]),
		CE(j=5, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.165e-15, 5.96e-15, 4.957e-15, 4.123e-15, 3.43e-15, 2.853e-15, 2.373e-15, 1.974e-15, 1.641e-15, 1.365e-15, 1.136e-15, 9.446e-16, 7.857e-16]),
		CE(j=6, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.114e-15, 5.917e-15, 4.921e-15, 4.094e-15, 3.405e-15, 2.832e-15, 2.356e-15, 1.959e-15, 1.63e-15, 1.355e-15, 1.127e-15, 9.378e-16, 7.8e-16]),
		CE(j=7, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.623e-15, 3.845e-15, 3.198e-15, 2.66e-15, 2.213e-15, 1.84e-15, 1.531e-15, 1.273e-15, 1.059e-15, 8.808e-16, 7.326e-16, 6.094e-16, 5.069e-16]),
		CE(j=8, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.07e-15, 2.553e-15, 2.124e-15, 1.767e-15, 1.469e-15, 1.222e-15, 1.017e-15, 8.455e-16, 7.033e-16, 5.849e-16, 4.865e-16, 4.047e-16, 3.366e-16]),
		CE(j=9, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.707e-14, 1.537e-14, 8.795e-15, 5.095e-15, 3.008e-15, 1.822e-15, 1.136e-15, 7.269e-16, 4.743e-16, 3.125e-16, 2.06e-16, 1.35e-16, 8.764e-17]),
		CE(j=10, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.423e-16, 7.006e-16, 5.827e-16, 4.847e-16, 4.031e-16, 3.353e-16, 2.789e-16, 2.32e-16, 1.929e-16, 1.605e-16, 1.335e-16, 1.11e-16, 9.235e-17]),
		CE(j=11, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.762e-16, 5.624e-16, 4.678e-16, 3.891e-16, 3.236e-16, 2.692e-16, 2.239e-16, 1.862e-16, 1.549e-16, 1.288e-16, 1.072e-16, 8.914e-17, 7.414e-17]),
		CE(j=12, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.76e-16, 5.622e-16, 4.676e-16, 3.89e-16, 3.235e-16, 2.691e-16, 2.238e-16, 1.862e-16, 1.549e-16, 1.288e-16, 1.071e-16, 8.911e-17, 7.412e-17]),
		CE(j=13, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.374e-16, 5.302e-16, 4.41e-16, 3.668e-16, 3.051e-16, 2.538e-16, 2.111e-16, 1.756e-16, 1.46e-16, 1.215e-16, 1.01e-16, 8.403e-17, 6.989e-17]),
		CE(j=14, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.291e-16, 5.233e-16, 4.352e-16, 3.62e-16, 3.011e-16, 2.505e-16, 2.083e-16, 1.733e-16, 1.441e-16, 1.199e-16, 9.971e-17, 8.293e-17, 6.898e-17]),
		CE(j=15, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.021e-16, 5.008e-16, 4.166e-16, 3.465e-16, 2.882e-16, 2.397e-16, 1.994e-16, 1.658e-16, 1.379e-16, 1.147e-16, 9.543e-17, 7.937e-17, 6.602e-17]),
		CE(j=16, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.563e-16, 3.154e-16, 1.799e-16, 1.038e-16, 6.092e-17, 3.668e-17, 2.279e-17, 1.463e-17, 9.644e-18, 6.456e-18, 4.34e-18, 2.905e-18, 1.924e-18]),
		CE(j=17, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[7.855e-15, 4.453e-15, 2.541e-15, 1.466e-15, 8.603e-16, 5.179e-16, 3.218e-16, 2.066e-16, 1.362e-16, 9.116e-17, 6.128e-17, 4.102e-17, 2.717e-17]),
		CE(j=18, i=3, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.539e-14, 2.573e-14, 1.468e-14, 8.468e-15, 4.971e-15, 2.993e-15, 1.86e-15, 1.194e-15, 7.868e-16, 5.267e-16, 3.541e-16, 2.37e-16, 1.57e-16]),
		CE(j=5, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.426e-10, 1.186e-10, 9.864e-11, 8.204e-11, 6.824e-11, 5.676e-11, 4.721e-11, 3.927e-11, 3.266e-11, 2.717e-11, 2.26e-11, 1.879e-11, 1.563e-11]),
		CE(j=6, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.931e-11, 2.438e-11, 2.028e-11, 1.687e-11, 1.403e-11, 1.167e-11, 9.707e-12, 8.074e-12, 6.716e-12, 5.586e-12, 4.646e-12, 3.864e-12, 3.214e-12]),
		CE(j=7, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.39e-14, 4.483e-14, 3.729e-14, 3.102e-14, 2.58e-14, 2.146e-14, 1.785e-14, 1.485e-14, 1.235e-14, 1.027e-14, 8.543e-15, 7.106e-15, 5.91e-15]),
		CE(j=8, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.444e-14, 1.201e-14, 9.989e-15, 8.308e-15, 6.911e-15, 5.748e-15, 4.781e-15, 3.977e-15, 3.308e-15, 2.751e-15, 2.288e-15, 1.903e-15, 1.583e-15]),
		CE(j=9, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.868e-15, 1.554e-15, 1.292e-15, 1.075e-15, 8.941e-16, 7.437e-16, 6.186e-16, 5.145e-16, 4.28e-16, 3.56e-16, 2.961e-16, 2.463e-16, 2.048e-16]),
		CE(j=10, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.459e-15, 1.213e-15, 1.009e-15, 8.394e-16, 6.981e-16, 5.807e-16, 4.83e-16, 4.017e-16, 3.342e-16, 2.779e-16, 2.312e-16, 1.923e-16, 1.599e-16]),
		CE(j=11, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.083e-15, 9.011e-16, 7.495e-16, 6.234e-16, 5.186e-16, 4.313e-16, 3.588e-16, 2.984e-16, 2.482e-16, 2.064e-16, 1.717e-16, 1.428e-16, 1.188e-16]),
		CE(j=12, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.083e-15, 9.007e-16, 7.492e-16, 6.232e-16, 5.183e-16, 4.311e-16, 3.586e-16, 2.983e-16, 2.481e-16, 2.063e-16, 1.716e-16, 1.428e-16, 1.187e-16]),
		CE(j=13, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.002e-15, 8.337e-16, 6.935e-16, 5.768e-16, 4.798e-16, 3.99e-16, 3.319e-16, 2.761e-16, 2.296e-16, 1.91e-16, 1.589e-16, 1.321e-16, 1.099e-16]),
		CE(j=14, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.853e-16, 8.196e-16, 6.817e-16, 5.67e-16, 4.716e-16, 3.923e-16, 3.263e-16, 2.714e-16, 2.257e-16, 1.878e-16, 1.562e-16, 1.299e-16, 1.08e-16]),
		CE(j=15, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.307e-16, 7.741e-16, 6.439e-16, 5.355e-16, 4.454e-16, 3.705e-16, 3.082e-16, 2.563e-16, 2.132e-16, 1.773e-16, 1.475e-16, 1.227e-16, 1.02e-16]),
		CE(j=16, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.906e-16, 7.408e-16, 6.162e-16, 5.125e-16, 4.263e-16, 3.546e-16, 2.949e-16, 2.453e-16, 2.04e-16, 1.697e-16, 1.412e-16, 1.174e-16, 9.765e-17]),
		CE(j=17, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.903e-16, 7.405e-16, 6.159e-16, 5.123e-16, 4.261e-16, 3.544e-16, 2.948e-16, 2.452e-16, 2.04e-16, 1.696e-16, 1.411e-16, 1.174e-16, 9.762e-17]),
		CE(j=18, i=4, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.898e-16, 7.401e-16, 6.156e-16, 5.12e-16, 4.259e-16, 3.542e-16, 2.946e-16, 2.451e-16, 2.038e-16, 1.696e-16, 1.41e-16, 1.173e-16, 9.757e-17]),
		CE(j=6, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.726e-11, 5.594e-11, 4.653e-11, 3.87e-11, 3.219e-11, 2.678e-11, 2.227e-11, 1.853e-11, 1.541e-11, 1.282e-11, 1.066e-11, 8.867e-12, 7.375e-12]),
		CE(j=7, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.474e-14, 4.553e-14, 3.787e-14, 3.15e-14, 2.62e-14, 2.179e-14, 1.813e-14, 1.508e-14, 1.254e-14, 1.043e-14, 8.676e-15, 7.217e-15, 6.003e-15]),
		CE(j=8, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.454e-14, 1.209e-14, 1.006e-14, 8.367e-15, 6.96e-15, 5.789e-15, 4.815e-15, 4.005e-15, 3.331e-15, 2.771e-15, 2.305e-15, 1.917e-15, 1.594e-15]),
		CE(j=9, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.872e-15, 1.557e-15, 1.295e-15, 1.077e-15, 8.96e-16, 7.453e-16, 6.199e-16, 5.156e-16, 4.288e-16, 3.567e-16, 2.967e-16, 2.468e-16, 2.053e-16]),
		CE(j=10, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.461e-15, 1.215e-15, 1.011e-15, 8.409e-16, 6.994e-16, 5.817e-16, 4.839e-16, 4.025e-16, 3.348e-16, 2.784e-16, 2.316e-16, 1.926e-16, 1.602e-16]),
		CE(j=11, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.085e-15, 9.025e-16, 7.507e-16, 6.244e-16, 5.193e-16, 4.32e-16, 3.593e-16, 2.988e-16, 2.486e-16, 2.068e-16, 1.72e-16, 1.43e-16, 1.19e-16]),
		CE(j=12, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.085e-15, 9.021e-16, 7.503e-16, 6.241e-16, 5.191e-16, 4.318e-16, 3.591e-16, 2.987e-16, 2.485e-16, 2.067e-16, 1.719e-16, 1.43e-16, 1.189e-16]),
		CE(j=13, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.004e-15, 8.349e-16, 6.945e-16, 5.776e-16, 4.804e-16, 3.996e-16, 3.324e-16, 2.765e-16, 2.3e-16, 1.913e-16, 1.591e-16, 1.323e-16, 1.101e-16]),
		CE(j=14, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.867e-16, 8.207e-16, 6.827e-16, 5.678e-16, 4.723e-16, 3.928e-16, 3.267e-16, 2.718e-16, 2.26e-16, 1.88e-16, 1.564e-16, 1.301e-16, 1.082e-16]),
		CE(j=15, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.319e-16, 7.752e-16, 6.447e-16, 5.363e-16, 4.461e-16, 3.71e-16, 3.086e-16, 2.567e-16, 2.135e-16, 1.776e-16, 1.477e-16, 1.229e-16, 1.022e-16]),
		CE(j=16, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.918e-16, 7.418e-16, 6.17e-16, 5.132e-16, 4.269e-16, 3.55e-16, 2.953e-16, 2.456e-16, 2.043e-16, 1.699e-16, 1.413e-16, 1.176e-16, 9.779e-17]),
		CE(j=17, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.915e-16, 7.415e-16, 6.168e-16, 5.13e-16, 4.267e-16, 3.549e-16, 2.952e-16, 2.455e-16, 2.042e-16, 1.699e-16, 1.413e-16, 1.175e-16, 9.775e-17]),
		CE(j=18, i=5, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.91e-16, 7.411e-16, 6.164e-16, 5.127e-16, 4.265e-16, 3.547e-16, 2.95e-16, 2.454e-16, 2.041e-16, 1.698e-16, 1.412e-16, 1.175e-16, 9.77e-17]),
		CE(j=7, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[5.61e-14, 4.666e-14, 3.881e-14, 3.228e-14, 2.685e-14, 2.234e-14, 1.858e-14, 1.545e-14, 1.285e-14, 1.069e-14, 8.892e-15, 7.396e-15, 6.152e-15]),
		CE(j=8, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.47e-14, 1.223e-14, 1.017e-14, 8.461e-15, 7.037e-15, 5.853e-15, 4.869e-15, 4.049e-15, 3.368e-15, 2.802e-15, 2.33e-15, 1.938e-15, 1.612e-15]),
		CE(j=9, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.878e-15, 1.562e-15, 1.299e-15, 1.081e-15, 8.989e-16, 7.477e-16, 6.219e-16, 5.173e-16, 4.303e-16, 3.579e-16, 2.977e-16, 2.476e-16, 2.059e-16]),
		CE(j=10, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.465e-15, 1.219e-15, 1.014e-15, 8.432e-16, 7.014e-16, 5.834e-16, 4.852e-16, 4.036e-16, 3.357e-16, 2.792e-16, 2.322e-16, 1.932e-16, 1.607e-16]),
		CE(j=11, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.088e-15, 9.046e-16, 7.524e-16, 6.259e-16, 5.206e-16, 4.33e-16, 3.601e-16, 2.996e-16, 2.492e-16, 2.072e-16, 1.724e-16, 1.434e-16, 1.193e-16]),
		CE(j=12, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.087e-15, 9.042e-16, 7.521e-16, 6.256e-16, 5.203e-16, 4.328e-16, 3.6e-16, 2.994e-16, 2.49e-16, 2.071e-16, 1.723e-16, 1.433e-16, 1.192e-16]),
		CE(j=13, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.006e-15, 8.368e-16, 6.96e-16, 5.789e-16, 4.815e-16, 4.005e-16, 3.331e-16, 2.771e-16, 2.305e-16, 1.917e-16, 1.595e-16, 1.326e-16, 1.103e-16]),
		CE(j=14, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.889e-16, 8.226e-16, 6.842e-16, 5.691e-16, 4.733e-16, 3.937e-16, 3.275e-16, 2.724e-16, 2.266e-16, 1.884e-16, 1.567e-16, 1.304e-16, 1.084e-16]),
		CE(j=15, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.34e-16, 7.768e-16, 6.461e-16, 5.374e-16, 4.47e-16, 3.718e-16, 3.093e-16, 2.572e-16, 2.14e-16, 1.78e-16, 1.48e-16, 1.231e-16, 1.024e-16]),
		CE(j=16, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.937e-16, 7.433e-16, 6.183e-16, 5.143e-16, 4.277e-16, 3.558e-16, 2.959e-16, 2.461e-16, 2.047e-16, 1.703e-16, 1.416e-16, 1.178e-16, 9.799e-17]),
		CE(j=17, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.934e-16, 7.431e-16, 6.181e-16, 5.141e-16, 4.276e-16, 3.557e-16, 2.958e-16, 2.461e-16, 2.047e-16, 1.702e-16, 1.416e-16, 1.178e-16, 9.796e-17]),
		CE(j=18, i=6, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[8.929e-16, 7.427e-16, 6.177e-16, 5.138e-16, 4.274e-16, 3.555e-16, 2.957e-16, 2.459e-16, 2.046e-16, 1.701e-16, 1.415e-16, 1.177e-16, 9.79e-17]),
		CE(j=8, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.022e-14, 3.345e-14, 2.782e-14, 2.314e-14, 1.925e-14, 1.601e-14, 1.332e-14, 1.108e-14, 9.213e-15, 7.663e-15, 6.374e-15, 5.302e-15, 4.41e-15]),
		CE(j=9, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[2.384e-15, 1.983e-15, 1.649e-15, 1.372e-15, 1.141e-15, 9.492e-16, 7.895e-16, 6.567e-16, 5.462e-16, 4.543e-16, 3.779e-16, 3.143e-16, 2.614e-16]),
		CE(j=10, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.797e-15, 1.494e-15, 1.243e-15, 1.034e-15, 8.599e-16, 7.152e-16, 5.949e-16, 4.948e-16, 4.116e-16, 3.423e-16, 2.847e-16, 2.368e-16, 1.97e-16]),
		CE(j=11, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.288e-15, 1.071e-15, 8.909e-16, 7.41e-16, 6.163e-16, 5.126e-16, 4.264e-16, 3.547e-16, 2.95e-16, 2.454e-16, 2.041e-16, 1.698e-16, 1.412e-16]),
		CE(j=12, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[6.809e-14, 3.917e-14, 2.278e-14, 1.336e-14, 8.035e-15, 4.975e-15, 3.162e-15, 2.064e-15, 1.371e-15, 9.169e-16, 6.115e-16, 4.043e-16, 2.64e-16]),
		CE(j=13, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.182e-15, 9.828e-16, 8.175e-16, 6.8e-16, 5.656e-16, 4.704e-16, 3.913e-16, 3.255e-16, 2.707e-16, 2.252e-16, 1.873e-16, 1.558e-16, 1.296e-16]),
		CE(j=14, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[9.63e-15, 5.482e-15, 3.149e-15, 1.837e-15, 1.097e-15, 6.743e-16, 4.284e-16, 2.801e-16, 1.866e-16, 1.252e-16, 8.388e-17, 5.569e-17, 3.652e-17]),
		CE(j=15, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.089e-15, 9.058e-16, 7.534e-16, 6.266e-16, 5.212e-16, 4.335e-16, 3.606e-16, 2.999e-16, 2.495e-16, 2.075e-16, 1.726e-16, 1.436e-16, 1.194e-16]),
		CE(j=16, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.038e-15, 8.631e-16, 7.179e-16, 5.971e-16, 4.967e-16, 4.131e-16, 3.436e-16, 2.858e-16, 2.377e-16, 1.977e-16, 1.645e-16, 1.368e-16, 1.138e-16]),
		CE(j=17, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.037e-15, 8.628e-16, 7.176e-16, 5.969e-16, 4.965e-16, 4.13e-16, 3.435e-16, 2.857e-16, 2.376e-16, 1.977e-16, 1.644e-16, 1.367e-16, 1.137e-16]),
		CE(j=18, i=7, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[1.037e-15, 8.623e-16, 7.172e-16, 5.966e-16, 4.962e-16, 4.127e-16, 3.433e-16, 2.855e-16, 2.375e-16, 1.975e-16, 1.643e-16, 1.367e-16, 1.137e-16]),
		CE(j=9, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[3.369e-15, 2.802e-15, 2.331e-15, 1.939e-15, 1.613e-15, 1.341e-15, 1.116e-15, 9.28e-16, 7.718e-16, 6.42e-16, 5.34e-16, 4.441e-16, 3.694e-16]),
		CE(j=10, i=8, temperature=[1264.9, 2249.4, 4000.0, 7113.1, 12649.1, 22493.6, 40000.0, 71131.1, 126491.0, 224936.0, 400000.0, 711312.0, 1264910.0], rates=[4.957e-14, 2.834e-14, 1.639e-14, 9.654e-15, 5.829e-15, 3.622e-15, 2.312e-15, 1.506e-15, 9.911e-16, 6.533e-16, 4.285e-16, 2.