### Make figures for observed summary statistics
library(ggplot2)
dir.create("./figs", showWarnings = FALSE, recursive = TRUE)

d1 <- read.table("observed_Magnolia5pops.txt", header =TRUE)
d2 <- read.table("observed_fis_Magnolia5pops.txt", header =TRUE)
d <- cbind(d1, d2)

gd <- matrix(NA, nrow = 34, ncol = 4)
gd <- as.data.frame(gd)
names(gd) <- c("Sumstat", "Pop", "Mean", "SD")
sumstat <- c("Number of alleles", "Heterozygosity", "Allele size range", "FIS",
             "FST")
gd$Sumstat <- rep(sumstat, times = c(6, 6, 6, 5, 11))
gd$Sumstat <- factor(gd$Sumstat, levels = sumstat)

gd$Pop <- c(rep(c("Pop1", "Pop2", "Pop3", "Pop4", "Pop5", "All"), times = 3),
            c("Pop1", "Pop2", "Pop3", "Pop4", "Pop5"),
            c("2-1", "3-1", "3-2", "4-1", "4-2", "4-3",
              "5-1", "5-2", "5-3", "5-4", "All"))
gd$Pop <- factor(gd$Pop, levels = c("Pop1", "Pop2", "Pop3", "Pop4", "Pop5", 
                                    "2-1", "3-1", "3-2", "4-1", "4-2", "4-3",
                                    "5-1", "5-2", "5-3", "5-4", "All"))

gd$Mean <- unlist(c(d[grep("K_", names(d))], d["tot_K"],
                    d[grep("H_", names(d))], d["tot_H"],
                    d[grep("R_", names(d))], d["tot_R"],
                    d[grep("FIS_", names(d))],
                    d[grep("FST_", names(d))], d["FST"]
                    ))

gd$SD <- unlist(c(d[grep("Ksd_", names(d))], NA,
                  d[grep("Hsd_", names(d))], NA,
                  d[grep("Rsd_", names(d))], NA,
                  d[grep("FISsd_", names(d))],
                  rep(NA, 11)
                  ))

g <- ggplot(data = gd) +
    geom_point(mapping = aes(x = Pop, y = Mean)) +
    geom_segment(mapping = aes(x = Pop, xend = Pop, y = Mean-SD, yend = Mean+SD)) +
    facet_wrap(~ Sumstat, nrow = 2, scales = "free") +
    #ylim(0, NA) +
    theme_bw() +
    theme(axis.title.x = element_blank(),
          axis.title.y = element_blank(),
          axis.text.x = element_text(angle = 45, hjust = 1, vjust = 1))

ggsave(file = "./figs/sumstats5pops210322.pdf", width = 7, height = 4)
