### Summarize ABC parameter estimation
library(abc)
library(coda)
dir.create("./output", showWarnings = FALSE, recursive = TRUE)

#############################################################
### ABC-RF (migration patterns)
#############################################################
n.tree <- 1000

div.pattern <- c("SVOM", "SLOM", "MOM", "DOM", "GOM")
model <- c("NMM", "SSM", "IM")
run.date <- c("211011", "211011", "220127", "220127", "211011")
infile <- paste("../model_comp/output/summary_model_comp_5pops_", div.pattern,
                "_", run.date, ".txt", sep = "")
out.header <- c("DivPattern", "BestModel", "PP", "ErrorRate",
                "VotesNMM", "VotesSSM", "VotesIM")
out <- matrix(NA, nrow = length(div.pattern), ncol = length(out.header))
out <- as.data.frame(out)
names(out) <- out.header
out$DivPattern <- div.pattern

for (i in 1:length(div.pattern)) {
    d <- readLines(con = infile[i], warn = FALSE)

    temp <- d[grep("selected model", d) + 1]
    temp <- as.numeric(unlist(strsplit(temp, " +")))
    out$BestModel[i] <- model[temp[2]]
    out$PP[i] <- temp[6]
    out[i, c("VotesNMM", "VotesSSM", "VotesIM")] <- temp[3:5]/n.tree

    temp <- d[grep("Out-of-bag", d)]
    temp <- unlist(strsplit(temp, "Out-of-bag prior error rate: "))[2]
    temp <- unlist(strsplit(temp, "%"))[1]
    out$ErrorRate[i] <- as.numeric(temp)/100
}

write.table(out, file = "./output/summary_abcrf_mig220127.csv",
            quote = FALSE, sep = ",", row.names = FALSE)

#############################################################
### ABC-RF (divergence patterns)
#############################################################
## Set 1: Five model comparison
## Set 2: Four model comparison (MOM)
## Set 3: Four model comparison (DOM)

n.tree <- 1000

model <- c("SVOM_SSM", "SLOM_SSM", "MOM_NMM", "DOM_NMM", "GOM_NMM")
infile <- c(
    "../model_comp/output/summary_model_comp_5pops_5best_models_220127.txt",
    "../model_comp/output/summary_model_comp_5pops_4best_models_MOM_220127.txt",
    "../model_comp/output/summary_model_comp_5pops_4best_models_DOM_220127.txt")

out.header <- c("BestModel", "PP", "ErrorRate",
                "VotesSVOM_SSM", "VotesSLOM_SSM", "VotesMOM_NMM",
                "VotesDOM_NMM", "VotesGOM_NMM")
out <- matrix(NA, nrow = 3, ncol = length(out.header))
out <- as.data.frame(out)
names(out) <- out.header


## Set 1
d <- readLines(con = infile[1], warn = FALSE)
temp1 <- d[grep("selected model", d) + 1]
temp2 <- d[grep("selected model", d) + 3]
temp1 <- c(as.numeric(unlist(strsplit(temp1, " +")))[-1],
           as.numeric(unlist(strsplit(temp2, " +")))[-1])

temp <- d[grep("Out-of-bag", d)]
temp <- unlist(strsplit(temp, "Out-of-bag prior error rate: "))[2]
temp <- unlist(strsplit(temp, "%"))[1]
temp1 <- c(temp1, as.numeric(temp)/100)

## Set 2
d <- readLines(con = infile[2], warn = FALSE)
temp2 <- d[grep("selected model", d) + 1]
temp2 <- as.numeric(unlist(strsplit(temp2, " +")))[-1]
temp2[1] <- temp2[1] + 1
temp2 <- c(temp2[1:4], NA, temp2[5:6])

temp <- d[grep("Out-of-bag", d)]
temp <- unlist(strsplit(temp, "Out-of-bag prior error rate: "))[2]
temp <- unlist(strsplit(temp, "%"))[1]
temp2 <- c(temp2, as.numeric(temp)/100)
           
## Set 3
d <- readLines(con = infile[3], warn = FALSE)
temp3 <- d[grep("selected model", d) + 1]
temp3 <- as.numeric(unlist(strsplit(temp3, " +")))[-1]
temp3[1] <- temp3[1] + 1
temp3 <- c(temp3[1:3], NA, temp3[4:6])

temp <- d[grep("Out-of-bag", d)]
temp <- unlist(strsplit(temp, "Out-of-bag prior error rate: "))[2]
temp <- unlist(strsplit(temp, "%"))[1]
temp3 <- c(temp3, as.numeric(temp)/100)

## Overall
temp <- rbind(temp1, temp2, temp3)

out$BestModel <- model[temp[, 1]]
out$PP <- temp[, 7]
out[, c("VotesSVOM_SSM", "VotesSLOM_SSM", "VotesMOM_NMM",
        "VotesDOM_NMM", "VotesGOM_NMM")] <- temp[, 2:6]/n.tree
out$ErrorRate <- temp[, 8]

write.table(out, file = "./output/summary_abcrf_div220127.csv",
            quote = FALSE, sep = ",", row.names = FALSE)

#############################################################
### ABC-RF (conf mat of divergence patterns)
#############################################################
n.sim.each.model <- 10000
n.compared.model <- c(5, 4, 4)
outfile <- c("./output/summary_abcrf_div_conf_mat_5m_220127.csv",
             "./output/summary_abcrf_div_conf_mat_4m_MOM_220127.csv",
             "./output/summary_abcrf_div_conf_mat_4m_DOM_220127.csv")

for (i in 1:length(n.compared.model)) {
    d <- readLines(con = infile[i], warn = FALSE)
    out <- matrix(NA, nrow = n.compared.model[i], ncol = n.compared.model[i])
    
    for (j in 1:n.compared.model[i]) {
        temp <- d[grep("Confusion matrix", d) + 1 + j]
        temp <- as.numeric(unlist(strsplit(temp, " +")))
        out[j, ] <- temp[2:(length(temp)-1)] # Remove header and tail
    }

    out <- out/n.sim.each.model
    write.table(out, file = outfile[i], quote = FALSE, sep = ",",
                row.names = FALSE, col.names = FALSE)
}

#############################################################
### ABC parameter estimation of GOM_nmm
#############################################################
infile <- "../GOM_nmm/param_est/posterior_GOM_nmm.RData"
    
## Function for calculation of mode and HPD
calc.mode.hpd <- function(x, pow10 = FALSE) {
    temp <- density(x)
    m <- temp$x[temp$y == max(temp$y)]
    phd <- HPDinterval(as.mcmc(x))
    if(pow10) {
        return(10^c(m, phd))
    }
    else {
        return(c(m, phd))
    }
}

## Paramter sets
parameter.GOM.nmm <- c("NCUR1", "NCUR2", "NCUR3", "NCUR4", "NCUR5", 
                       "TDIV1", "TDIV2", "TDIV3", "TDIV4",
                       "MUT_SHAPE", "P_MEAN")
np.GOM.nmm <- length(parameter.GOM.nmm)
LOG10GOM.nmm <- c(TRUE, TRUE, TRUE, TRUE, TRUE,
                  TRUE, TRUE, TRUE, TRUE,
                  FALSE, FALSE)

## Make output style
out.header <- c("Parameter", "Mode", "Lower", "Upper")
out <- matrix(NA, nrow = np.GOM.nmm, ncol = length(out.header))
out <- as.data.frame(out)
names(out) <- out.header
out$Parameter <- parameter.GOM.nmm

## Calc mode and HPD
load(infile)
posterior <- as.data.frame(res$adj.values)

for (i in 1:np.GOM.nmm) {
    parameter <- paste(parameter.GOM.nmm[i],
                       c("Mode", "Lower", "Upper"),
                       sep = "_")
    if(LOG10GOM.nmm[i]) {
        parameter.name <- paste("LOG10", parameter.GOM.nmm[i], sep = "")
    }
    else {
        parameter.name <- parameter.GOM.nmm[i]
    }
    out[i, 2:4] <- calc.mode.hpd(posterior[, parameter.name],
                                 LOG10GOM.nmm[i])
}

write.table(out, "./output/summary_abc_param5pops220127.csv",
            sep = ",", quote = FALSE, row.names = FALSE)



