### Draw posteior distribution of TDIVs
library(abc)
library(ggplot2)

dir.create("./figs", showWarnings = FALSE, recursive = TRUE)

load(file = "../GOM_nmm/param_est/posterior_GOM_nmm.RData")

posterior <- data.frame(res$adj.values)
prior <- read.table(file = "../GOM_nmm/param_est/prior.txt", header = TRUE)

d <- data.frame(
    Parameter = c(rep(c("TDIV1", "TDIV2", "TDIV3", "TDIV4"),
                      each = nrow(prior)),
                  rep(c("TDIV1", "TDIV2", "TDIV3", "TDIV4"),
                      each = nrow(posterior))),
    Distribution = rep(c("Prior", "Posterior"),
                       times = c(nrow(prior)*4, nrow(posterior)*4)),
    Value = c(prior$LOG10TDIV1,
              prior$LOG10TDIV2,
              prior$LOG10TDIV3,
              prior$LOG10TDIV4,
              posterior$LOG10TDIV1,
              posterior$LOG10TDIV2,
              posterior$LOG10TDIV3,
              posterior$LOG10TDIV4)
)

d$Value <- (10^d$Value)*50 # Assuming 50 years per generation
d$ParamDist <- paste(d$Parameter,d$Distribution, sep = "")

parameter.label <- c("TDIV1" = expression(italic(T)[DIV1]),
                     "TDIV2" = expression(italic(T)[DIV2]),
                     "TDIV3" = expression(italic(T)[DIV3]),
                     "TDIV4" = expression(italic(T)[DIV4]))

g <- ggplot(data = d, mapping = aes(x = Value, group = ParamDist,
                                    color = Parameter, linetype = Distribution)) +
    geom_line(stat = "density", alpha = 0.75) +
    scale_x_log10() +
    labs(x = "Divergence time (years ago)",
         y = "Density") +
    scale_color_discrete(labels = parameter.label) +
    theme_bw()
ggsave(file = "./figs/TDIV5pops211012.pdf", width = 5.5, height = 4)





