### Draw density plots of current effective population sizes
library(ggplot2)
library(abc)
library(coda)

dir.create("./figs", showWarnings = FALSE, recursive = TRUE)

pop <- 1:5
n.pop <- length(pop)
pop.name <- c("SV", "SL", "M", "D", "G")
pop.colors <- c("cadetblue3", "dodgerblue3", "gold", "chocolate1", "firebrick2")

load(file = "../GOM_nmm/param_est/posterior_GOM_nmm.RData")

posterior <- data.frame(res$adj.values)
#prior <- read.table(file = "../GOM_nmm/param_est/prior.txt", header = TRUE)

gd <- data.frame(Population = c(rep(pop.name, each = nrow(posterior)),
                         rep("Prior", nrow(prior))),
                 Distribution = rep(c("Posterior", "Prior"),
                                    times = c(5*nrow(posterior), nrow(prior))),
                 Value = c(10^posterior$LOG10NCUR1,
                           10^posterior$LOG10NCUR2,
                           10^posterior$LOG10NCUR3,
                           10^posterior$LOG10NCUR4,
                           10^posterior$LOG10NCUR5,
                           10^prior$LOG10NCUR1))
gd$Population <- factor(gd$Population, levels = c(pop.name, "Prior"))

g <- ggplot(data = gd, mapping = aes(x = Value, group = Population,
                                     color = Population,
                                     linetype = Distribution)) +
    geom_line(stat = "density", alpha = 0.75) +
    scale_color_manual(values = c(pop.colors, "black")) +
    scale_x_log10() +
    labs(x = "Current effective population size", y = "Density") +
    theme_bw()

ggsave(file = "./figs/NCUR_each_pop211012.pdf", width = 5.5, height = 4)


