### 5 pops
### Model comparison using abcrf
### Compare 3 models in MOM (nmm, ssm and im)

library(abcrf)
n.sim <- 10^4
n.tree <- 1*10^3
dir.create("./output", showWarnings = FALSE, recursive = TRUE)
outfile <- "./output/summary_model_comp_5pops_MOM_220127.txt"

## Summary statistics of observed data
ss.data <- read.table(file = "/Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/observed_Magnolia5pops.txt", header = TRUE)

## Summary statistics of simulated data
ss.model.MOM.nmm<- read.table(file = "/Users/ichiro/works/works21/emily/analysis/abc/5pops/MOM_nmm/sumstat.txt", header = TRUE)
ss.model.MOM.ssm<- read.table(file = "/Users/ichiro/works/works21/emily/analysis/abc/5pops/MOM_ssm/sumstat.txt", header = TRUE)
ss.model.MOM.im<- read.table(file = "/Users/ichiro/works/works21/emily/analysis/abc/5pops/MOM_im/sumstat.txt", header = TRUE)

## Prepare input data
modindex <- factor(rep(1:3, each = n.sim))
sumsta <- rbind(ss.model.MOM.nmm, ss.model.MOM.ssm, ss.model.MOM.im)
sumsta <- sumsta[, grep("Rsd_", names(sumsta), value = TRUE, invert = TRUE)]
data.rf <- data.frame(modindex, sumsta)

## abcrf
model.rf <- abcrf(modindex ~ ., data = data.rf, lda = TRUE,
                  ntree = n.tree, paral = TRUE)
out.rf <- predict(model.rf, obs = ss.data, training = data.rf,
                  ntree = n.tree, paral = TRUE)
sink(outfile)
print(model.rf)
cat("\n")
print(out.rf)
sink()

if(0) {
## Check the locations of observed data and simulated data
plot(model.rf, obs = ss.data, training = data.rf)
    
## Confirm number of trees
err.abcrf(model.rf, training = data.rf, paral = TRUE)
}

