# Running SVOM_ssm, SV origin with stepping stone model
# Fix mean mu for nSSR at 1*10^-4

n.total.sim <- 1*10^4 # Total number of sims (> 10^2)
n.sim.per.batch <- 100 # Number of sims per batch
n.batch <- n.total.sim/n.sim.per.batch # Number of batches
n.locus.nSSR <- 15 # Number of nSSR loci
outfile <- "sumstat.txt"

fsc <- "/Users/ichiro/works/programs/fsc26_mac64/fsc26" # Path for fastsimcoal2
#fsc <- "/Users/ichiro/works/programs/fsc27_mac64/fsc2702" # Path for fastsimcoal2
tpl <- "model_SVOM_ssm.tpl" # Path for tpl file
arlsumstat <- "/Users/ichiro/works/programs/arlsumstat_macosx/arlsumstatmac_64bit" # Path for arlsumstat
arl_run <- "/Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/arl_run.ars" # Path for arl_run.ars of nSSR
ssdefs <- "/Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/ssdefs.txt" # Path for ssdefs.txt

## Make priors (when in log scale, 5 digits are enough)
LOG10NCUR1 <- round(runif(n.total.sim, 1, 5), 5)
LOG10NCUR2 <- round(runif(n.total.sim, 1, 5), 5)
LOG10NCUR3 <- round(runif(n.total.sim, 1, 5), 5)
LOG10NCUR4 <- round(runif(n.total.sim, 1, 5), 5)
LOG10NCUR5 <- round(runif(n.total.sim, 1, 5), 5)

LOG10MIG <- round(runif(n.total.sim, -3, -1), 5)

## TDIV1 < TDIV2 < TDIV3 < TDIV4
## Upper limit of all TDIVs is 5 mya (10^5 gens ago assuming 50 y per gen)
t.mat <- matrix(0, nrow = n.total.sim, ncol = 4)

for (i in 1:n.total.sim) {
    t.mat[i, ] <- sort(runif(4, 2, 5))
}

LOG10TDIV1 <- t.mat[, 1]
LOG10TDIV2 <- t.mat[, 2]
LOG10TDIV3 <- t.mat[, 3]
LOG10TDIV4 <- t.mat[, 4]

rm(t.mat)

# Shape parameter of gamma distribution related to variance of mu
MUT_SHAPE <- round(runif(n.total.sim, 0.5, 5), 3) 

# P parameter of GSM
P_MEAN <- round(runif(n.total.sim, 0, 1), 3)

prior.out <- data.frame(LOG10NCUR1, LOG10NCUR2, LOG10NCUR3,
                        LOG10NCUR4, LOG10NCUR5, LOG10MIG,
                        LOG10TDIV1, LOG10TDIV2, LOG10TDIV3, LOG10TDIV4,
                        MUT_SHAPE, P_MEAN)
write.table(prior.out, "prior.txt", quote = FALSE, sep = " ", row.names = FALSE)
rm(prior.out)

## Convert priors for fastsimcoal2 with -f option
NCUR1_N <- 2*10^LOG10NCUR1
NCUR2_N <- 2*10^LOG10NCUR2
NCUR3_N <- 2*10^LOG10NCUR3
NCUR4_N <- 2*10^LOG10NCUR4
NCUR5_N <- 2*10^LOG10NCUR5

MIG <- 10^LOG10MIG

TDIV1 <- 10^LOG10TDIV1
TDIV2 <- 10^LOG10TDIV2
TDIV3 <- 10^LOG10TDIV3
TDIV4 <- 10^LOG10TDIV4

# prepare variance of mu for nSSR
MUT_MEAN <- 1*10^-4
shape <- MUT_SHAPE
rate <- shape/MUT_MEAN

# prepare variance of P (Excoffier et al. 2005)
a <- 0.5+199*P_MEAN
b <- a*(1-P_MEAN)/P_MEAN

for(i in 1:n.locus.nSSR) {
    if(nchar(i) == 1) {
        assign(paste("P", "0", i, sep = ""), rbeta(n.total.sim, a, b))
        assign(paste("MUT", "0", i, sep = ""),
               rgamma(n.total.sim, shape, rate))
    }
    if(nchar(i) == 2) {
        assign(paste("P", i, sep = ""), rbeta(n.total.sim, a, b))
        assign(paste("MUT", i, sep = ""),
               rgamma(n.total.sim, shape, rate))
    }
}

prior <- data.frame(NCUR1_N, NCUR2_N, NCUR3_N, NCUR4_N, NCUR5_N,
                    MIG,
                    TDIV1, TDIV2, TDIV3, TDIV4,
                    MUT01, MUT02, MUT03, MUT04, MUT05,
                    MUT06, MUT07, MUT08, MUT09, MUT10,
                    MUT11, MUT12, MUT13, MUT14, MUT15,
                    P01, P02, P03, P04, P05, P06, P07, P08,
                    P09, P10, P11, P12, P13, P14, P15)

## Simulation of genotypes and calculation for sumstas
# Copy files for simulation of nSSR
system(paste("cp", arl_run, "."))
system(paste("cp", ssdefs, "."))

# Simulate only one time for making header for outfile of nSSR
sim.dir <- unlist(strsplit(tpl, ".tpl"))
arp.file <- paste("./", sim.dir, "/", sim.dir, "_1_1.arp", sep = "")
write.table(prior[1, ], "temp_prior.txt",
            quote = FALSE, sep = " ", row.names = FALSE)
system(paste(fsc, "-t", tpl, "-n 1 -f temp_prior.txt", "-g"))
system(paste(arlsumstat, arp.file, outfile, 0, 2))

# Simulate per batch
# Make arpfile name list
arp.file <- paste("./", sim.dir, "/", sim.dir, "_",
                  1:n.sim.per.batch, "_1.arp", sep = "")

for(i in 1:n.batch) {
    ## Get location of data in ith batch
    data.location <- ((i-1)*n.sim.per.batch+1):(i*n.sim.per.batch) 

    ## Simulate nSSR data and calculate sumstats
    # Copy files for simulation of nSSR
    system(paste("cp", arl_run, "."))
    system(paste("cp", ssdefs, "."))
    
    write.table(prior[data.location, ], "temp_prior.txt",
                quote = FALSE, sep = " ", row.names = FALSE)
    system(paste(fsc, "-t", tpl, "-n 1 -f temp_prior.txt", "-g"))
    for(j in 1:n.sim.per.batch) {
        system(paste(arlsumstat, arp.file[j], outfile, 1, 0))
    }
    # Cleaning
    system(paste("rm -rf", sim.dir))
    system("rm temp_prior.txt")
    system("rm *seed.txt")
    system("rm arl_run.ars")
    system("rm ssdefs.txt")
}

system("rm -f arl_pro.txt")
print("Simulations have been completed!")


