### Make data for predictive simulation
### GOM_nmm
library(abc)
load(file = "posterior_GOM_nmm.RData")
dir.create("./posterior_pred", showWarnings = FALSE, recursive = TRUE)
outfile <- "./posterior_pred/posterior_GOM_nmm.txt"
n.pred.sim <- 1000
n.locus.nSSR <- 15

posterior <- as.data.frame(res$adj.values)

LOG10NCUR1 <- posterior$LOG10NCUR1
LOG10NCUR2 <- posterior$LOG10NCUR2
LOG10NCUR3 <- posterior$LOG10NCUR3
LOG10NCUR4 <- posterior$LOG10NCUR4
LOG10NCUR5 <- posterior$LOG10NCUR5

LOG10TDIV1 <- posterior$LOG10TDIV1
LOG10TDIV2 <- posterior$LOG10TDIV2
LOG10TDIV3 <- posterior$LOG10TDIV3
LOG10TDIV4 <- posterior$LOG10TDIV4

MUT_SHAPE <- posterior$MUT_SHAPE
P_MEAN <- posterior$P_MEAN

## Prepare posteriors for FSC
NCUR1_N <- 2*10^LOG10NCUR1
NCUR2_N <- 2*10^LOG10NCUR2
NCUR3_N <- 2*10^LOG10NCUR3
NCUR4_N <- 2*10^LOG10NCUR4
NCUR5_N <- 2*10^LOG10NCUR5
TDIV1 <- 10^LOG10TDIV1
TDIV2 <- 10^LOG10TDIV2
TDIV3 <- 10^LOG10TDIV3
TDIV4 <- 10^LOG10TDIV4
MUT_MEAN <- 1*10^-4
shape <- MUT_SHAPE
rate <- shape/MUT_MEAN

a <- 0.5+199*P_MEAN
b <- a*(1-P_MEAN)/P_MEAN

for(i in 1:n.locus.nSSR) {
    if(nchar(i) == 1) {
        assign(paste("P", "0", i, sep = ""), rbeta(n.pred.sim, a, b))
        assign(paste("MUT", "0", i, sep = ""),
               rgamma(n.pred.sim, shape, rate))
    }
    if(nchar(i) == 2) {
        assign(paste("P", i, sep = ""), rbeta(n.pred.sim, a, b))
        assign(paste("MUT", i, sep = ""),
               rgamma(n.pred.sim, shape, rate))
    }
}

out <- data.frame(NCUR1_N, NCUR2_N, NCUR3_N, NCUR4_N, NCUR5_N,
                  TDIV1, TDIV2, TDIV3, TDIV4,
                  MUT01, MUT02, MUT03, MUT04, MUT05,
                  MUT06, MUT07, MUT08, MUT01, MUT10,
                  MUT11, MUT12, MUT13, MUT14, MUT15,
                  P01, P02, P03, P04, P05, P06, P07, P08,
                  P09, P10, P11, P12, P13, P14, P15)

## Draw n.pred.sim posteriors randomely
t.mat <- matrix(NA, nrow = nrow(posterior), ncol = 4)
t.mat[, 1] <- LOG10TDIV1
t.mat[, 2] <- LOG10TDIV2
t.mat[, 3] <- LOG10TDIV3
t.mat[, 4] <- LOG10TDIV4

use.posterior <- sapply(1:nrow(t.mat), function(i) {
    t.mat[i, 1] < t.mat[i, 2] &
        t.mat[i, 2] < t.mat[i, 3] &
        t.mat[i, 3] < t.mat[i, 4]
})

out <- out[use.posterior, ]
out <- out[sample(1:nrow(out), size = n.pred.sim, replace = TRUE), ]

## Output
write.table(out, file = outfile, quote = FALSE, sep = " ", row.names = FALSE)


