### GOM
library(abc)
n.param <- 11
prior <- read.table(file = "prior.txt", header = TRUE)
ss <- read.table(file = "sumstat.txt", header = TRUE)
ss.data <- read.table(file = "/Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/observed_Magnolia5pops.txt", header = TRUE)
outfile.pdf <- "posterior_GOM_nmm.pdf"
outfile.RData <- "posterior_GOM_nmm.RData"

use.ss <- grep("Rsd_", names(ss), value = TRUE, invert = TRUE)
ss <- ss[, use.ss]
ss.data <- ss.data[, use.ss]

## Ranges for priors
bounds <- matrix(c(1, 5, # LOG10NCUR1
                   1, 5, # LOG10NCUR2
                   1, 5, # LOG10NCUR3
                   1, 5, # LOG10NCUR4
                   1, 5, # LOG10NCUR5
                   2, 5, # LOG10TDIV1
                   2, 5, # LOG10TDIV2
                   2, 5, # LOG10TDIV3
                   2, 5, # LOG10TDIV4
                   0.5, 5, # MUT_SHAPE
                   0, 1), # P_MEAN
                 nrow = n.param, ncol = 2, byrow = TRUE)

## ABC
res <- abc(target = ss.data, param = prior, sumstat = ss,
           tol = 0.0005,
           method = "neuralnet", numnet = 20,
           transf = "logit", logit.bounds = bounds)
pdf(file = outfile.pdf)
plot(res, prior, ask = FALSE)
dev.off()

## Output posteriors for drawing figures
save(res, file = outfile.RData)


