#!/bin/bash
# Conduct posterior predictive simulation

tplfile="model_GOM_nmm.tpl"
infile="posterior_GOM_nmm.txt"
outfile="sumstat_GOM_nmm.txt"

cp ../../${tplfile} ./

## Simulate nSSR data using fastsimcoal2
fsc="/Users/ichiro/works/programs/fsc26_mac64/fsc26"
$fsc -t $tplfile -n 1 -f ${infile} -g

## Calculate sumstas using arlsumstat
tempdir=${tplfile##*/}
tempdir=${tempdir%.*}
cd ${tempdir}
cp /Users/ichiro/works/programs/arlsumstat_macosx/arlsumstatmac_64bit arlsumstat
cp /Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/arl_run.ars .
cp /Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/ssdefs.txt .

counter=1;
for arpfile in *.arp
do
    echo "Processing file $arpfile"
    if [ $counter -eq 1 ]; then
        # Calculate sumstas, reset oufile and add header
        ./arlsumstat ./$arpfile $outfile 0 1
    else
        # Calculate sumstats and add it to the outfile
        ./arlsumstat ./$arpfile $outfile 1 0
    fi
    let counter=counter+1
done

## Remove waste files
mv ${outfile} ../
cd ../
rm -rf $tempdir
rm seed.txt
#rm ../*.par
rm *.tpl

