### Make figure of posterior predictive simulation
library(ggplot2)
library(reshape)

simfile <- "sumstat_GOM_nmm.txt"
obsfile <- "/Users/ichiro/works/works21/emily/analysis/abc/observed/5pops/observed_Magnolia5pops.txt"
outfile <- "posterior_pred_GOM_nmm.pdf"

## Read simulated data
d.sim <- read.table(file = simfile, header = TRUE)

## Read observed data
d.obs <- read.table(file = obsfile, header = TRUE)

use.ss <- grep("Rsd_", names(d.sim), value = TRUE, invert = TRUE)
hist.data <- melt(d.sim[, use.ss])
vline.data <- melt(d.obs[, use.ss])

## Set labels for facet
levels(hist.data$variable)[levels(hist.data$variable) == "K_1"] <- "Average A1"
levels(hist.data$variable)[levels(hist.data$variable) == "K_2"] <- "Average A2"
levels(hist.data$variable)[levels(hist.data$variable) == "K_3"] <- "Average A3"
levels(hist.data$variable)[levels(hist.data$variable) == "K_4"] <- "Average A4"
levels(hist.data$variable)[levels(hist.data$variable) == "K_5"] <- "Average A5"
levels(hist.data$variable)[levels(hist.data$variable) == "Ksd_1"] <- "SD of A1"
levels(hist.data$variable)[levels(hist.data$variable) == "Ksd_2"] <- "SD of A2"
levels(hist.data$variable)[levels(hist.data$variable) == "Ksd_3"] <- "SD of A3"
levels(hist.data$variable)[levels(hist.data$variable) == "Ksd_4"] <- "SD of A4"
levels(hist.data$variable)[levels(hist.data$variable) == "Ksd_5"] <- "SD of A5"
levels(hist.data$variable)[levels(hist.data$variable) == "tot_K"] <- "Overall A"
levels(hist.data$variable)[levels(hist.data$variable) == "H_1"] <- "Average H1"
levels(hist.data$variable)[levels(hist.data$variable) == "H_2"] <- "Average H2"
levels(hist.data$variable)[levels(hist.data$variable) == "H_3"] <- "Average H3"
levels(hist.data$variable)[levels(hist.data$variable) == "H_4"] <- "Average H4"
levels(hist.data$variable)[levels(hist.data$variable) == "H_5"] <- "Average H5"
levels(hist.data$variable)[levels(hist.data$variable) == "Hsd_1"] <- "SD of H1"
levels(hist.data$variable)[levels(hist.data$variable) == "Hsd_2"] <- "SD of H2"
levels(hist.data$variable)[levels(hist.data$variable) == "Hsd_3"] <- "SD of H3"
levels(hist.data$variable)[levels(hist.data$variable) == "Hsd_4"] <- "SD of H4"
levels(hist.data$variable)[levels(hist.data$variable) == "Hsd_5"] <- "SD of H5"
levels(hist.data$variable)[levels(hist.data$variable) == "tot_H"] <- "Overall H"
levels(hist.data$variable)[levels(hist.data$variable) == "R_1"] <- "Average R1"
levels(hist.data$variable)[levels(hist.data$variable) == "R_2"] <- "Average R2"
levels(hist.data$variable)[levels(hist.data$variable) == "R_3"] <- "Average R3"
levels(hist.data$variable)[levels(hist.data$variable) == "R_4"] <- "Average R4"
levels(hist.data$variable)[levels(hist.data$variable) == "R_5"] <- "Average R5"
levels(hist.data$variable)[levels(hist.data$variable) == "tot_R"] <- "Overall R"
levels(hist.data$variable)[levels(hist.data$variable) == "FST"] <- "Overall FST"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_2_1"] <- "FST 2 vs 1"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_3_1"] <- "FST 3 vs 1"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_3_2"] <- "FST 3 vs 2"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_4_1"] <- "FST 4 vs 1"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_4_2"] <- "FST 4 vs 2"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_4_3"] <- "FST 4 vs 3"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_5_1"] <- "FST 5 vs 1"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_5_2"] <- "FST 5 vs 2"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_5_3"] <- "FST 5 vs 3"
levels(hist.data$variable)[levels(hist.data$variable) == "FST_5_4"] <- "FST 5 vs 4"


levels(vline.data$variable)[levels(vline.data$variable) == "K_1"] <- "Average A1"
levels(vline.data$variable)[levels(vline.data$variable) == "K_2"] <- "Average A2"
levels(vline.data$variable)[levels(vline.data$variable) == "K_3"] <- "Average A3"
levels(vline.data$variable)[levels(vline.data$variable) == "K_4"] <- "Average A4"
levels(vline.data$variable)[levels(vline.data$variable) == "K_5"] <- "Average A5"
levels(vline.data$variable)[levels(vline.data$variable) == "Ksd_1"] <- "SD of A1"
levels(vline.data$variable)[levels(vline.data$variable) == "Ksd_2"] <- "SD of A2"
levels(vline.data$variable)[levels(vline.data$variable) == "Ksd_3"] <- "SD of A3"
levels(vline.data$variable)[levels(vline.data$variable) == "Ksd_4"] <- "SD of A4"
levels(vline.data$variable)[levels(vline.data$variable) == "Ksd_5"] <- "SD of A5"
levels(vline.data$variable)[levels(vline.data$variable) == "tot_K"] <- "Overall A"
levels(vline.data$variable)[levels(vline.data$variable) == "H_1"] <- "Average H1"
levels(vline.data$variable)[levels(vline.data$variable) == "H_2"] <- "Average H2"
levels(vline.data$variable)[levels(vline.data$variable) == "H_3"] <- "Average H3"
levels(vline.data$variable)[levels(vline.data$variable) == "H_4"] <- "Average H4"
levels(vline.data$variable)[levels(vline.data$variable) == "H_5"] <- "Average H5"
levels(vline.data$variable)[levels(vline.data$variable) == "Hsd_1"] <- "SD of H1"
levels(vline.data$variable)[levels(vline.data$variable) == "Hsd_2"] <- "SD of H2"
levels(vline.data$variable)[levels(vline.data$variable) == "Hsd_3"] <- "SD of H3"
levels(vline.data$variable)[levels(vline.data$variable) == "Hsd_4"] <- "SD of H4"
levels(vline.data$variable)[levels(vline.data$variable) == "Hsd_5"] <- "SD of H5"
levels(vline.data$variable)[levels(vline.data$variable) == "tot_H"] <- "Overall H"
levels(vline.data$variable)[levels(vline.data$variable) == "R_1"] <- "Average R1"
levels(vline.data$variable)[levels(vline.data$variable) == "R_2"] <- "Average R2"
levels(vline.data$variable)[levels(vline.data$variable) == "R_3"] <- "Average R3"
levels(vline.data$variable)[levels(vline.data$variable) == "R_4"] <- "Average R4"
levels(vline.data$variable)[levels(vline.data$variable) == "R_5"] <- "Average R5"
levels(vline.data$variable)[levels(vline.data$variable) == "tot_R"] <- "Overall R"
levels(vline.data$variable)[levels(vline.data$variable) == "FST"] <- "Overall FST"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_2_1"] <- "FST 2 vs 1"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_3_1"] <- "FST 3 vs 1"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_3_2"] <- "FST 3 vs 2"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_4_1"] <- "FST 4 vs 1"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_4_2"] <- "FST 4 vs 2"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_4_3"] <- "FST 4 vs 3"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_5_1"] <- "FST 5 vs 1"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_5_2"] <- "FST 5 vs 2"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_5_3"] <- "FST 5 vs 3"
levels(vline.data$variable)[levels(vline.data$variable) == "FST_5_4"] <- "FST 5 vs 4"

g <- ggplot(data = hist.data, aes(x = value)) +
    theme_bw() +
    xlab("Parameter") +
    ylab("Count") +
    geom_histogram(alpha = 0.6) +
    facet_wrap(~ variable, ncol = 11, scales = "free") +
    geom_vline(aes(xintercept = value), data = vline.data)

ggsave(file = outfile, width = 15, height = 5)

