% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmt_transformer.R
\name{tmt_transformer}
\alias{tmt_transformer}
\title{Run Pairwise Protein Quantification on each level of TMT Maxquant output}
\usage{
tmt_transformer(
  protein_groups,
  des,
  output_folder,
  imputeStDev = 0.3,
  imputePosition = 1.8
)
}
\arguments{
\item{output_folder}{An output folder to store produced files.}

\item{imputePosition}{The Position parameter for MNAR Imputation}

\item{mq_folder}{A maxquant txt output folder.}

\item{imputStDev}{The Standard Deviation parameter for MNAR Imputation}
}
\value{
A string describing the type of experiment
}
\description{
Run Pairwise Protein Quantification on each level of TMT Maxquant output
}
\examples{
\dontrun{
tmp =  tmt_transformer(mq_folder = upload_folder,
 output_folder = output_folder,
 imputeStDev=0.3,
 imputePosition=1.8)
# get each of the produced quantification files.
prot = tmp[[1]]
prot_int = tmp[[2]]
pept = tmp[[3]]
pept_int = tmp[[4]]
mod_pept = tmp[[5]]
mod_pept_int = tmp[[6]]
expdes = tmp[[7]]
evidence = tmp[[8]]
msms = tmp[[9]]
}
}
