import pandas as pd
import matplotlib.pyplot as plt
from scipy import interpolate
import numpy as np
import os
from mpl_toolkits import mplot3d

plt.rcParams.update({'font.size': 14})
plt.close("all")

def getData(fname):
  tab=pd.read_csv(fname, header=None, sep = ';')
  t=tab.values[:,0]
  val=tab.values[:,1]
  return t, val


def LodeToOmega(lode):
    omega = np.zeros(len(lode))
    for i in range(len(lode)):
        L = lode[i]
        theta = np.pi/6 + np.arctan(L/np.sqrt(3))
        omega[i] = np.cos(3*theta)
    return omega
    
def getFractureStrainThin(folder, t0, W0):
    dispNode3 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical3" in each]
    dispNode5 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical5" in each]
    dispNode4 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical4" in each]

    disp3 = None;
    for dispFile in dispNode3:
        if "comp1" in dispFile:
            disp3 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
    disp5 = None;
    for dispFile in dispNode5:
        if "comp1" in dispFile:
            disp5 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
    disp4 = None;
    for dispFile in dispNode4:
        if "comp0" in dispFile:
            disp4 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
#    print(disp5.values[:,1],  disp3.values[:,1], disp4.values[:,1])
    t = t0 - disp5.values[:,1] + disp3.values[:,1]
    W = W0 - 2*disp4.values[:,1]
    e1 = np.log(t0/t)
    e2 = np.log(W0/W)
    eps = (2/np.sqrt(3))*np.sqrt(e1**2+ e2**2+e1*e2)
    
    return eps

def getFractureStrainAxisym(folder, R0):
    dispNode2 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical2" in each]
    disp2 = None;
    for dispFile in dispNode2:
        if "comp0" in dispFile:
            disp2 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
    R = R0 + disp2.values[:,1]
    e1 = 2*np.log(R0/R)
    return e1

def getFractureStrainGR(folder, t0):
    dispNode2 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical2" in each]
    dispNode3 = [each for each in os.listdir(folder) if "NodalDisplacementPhysical3" in each]
    disp2 = None;
    for dispFile in dispNode2:
        if "comp0" in dispFile:
            disp2 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
    disp3 = None;
    for dispFile in dispNode3:
        if "comp0" in dispFile:
            disp3 = pd.read_csv(os.path.join(folder,dispFile), header=None, sep=";")
            break
    t = t0 + disp2.values[:,1]-disp3.values[:,1]
#    print(disp2, disp3)
#    print(t)
    e1 = 2*np.log(t0/t)/np.sqrt(3)
    return e1

def getStateEvolution(srcDir, name, physical):
        """
        Args:
                srcDir contains all files
                physical number of IpXXX.csv

        """
        folder=srcDir+name
        t,eps=getData(folder+'/IP'+str(physical)+'val_PLASTICSTRAIN.csv')
        t,lode=getData(folder+'/IP'+str(physical)+'val_LODE_PARAMETER.csv')
        t,triax=getData(folder+'/IP'+str(physical)+'val_STRESS_TRIAXIALITY.csv')


        data = pd.DataFrame()
        data["eps"] = eps
        data["triax"] = triax
        data["lode"] = lode
        data["omega"] = LodeToOmega(lode)
        if name=='1L':
          data["macroStrain"]=getFractureStrainThin(folder,0.95,6)
        elif name=='2PL':
          data["macroStrain"]=getFractureStrainThin(folder,0.95,4)
        elif name=='2NS4':
          data["macroStrain"]=getFractureStrainThin(folder,0.95,4)
        elif name=='2NS2':
          data["macroStrain"]=getFractureStrainThin(folder,0.95,4)
        elif name=='2NS1':
          data["macroStrain"]=getFractureStrainThin(folder,0.95,4)
        elif name=='4SR':
          data["macroStrain"]=getFractureStrainAxisym(folder,3.)
        elif name=='5NR4':
          data["macroStrain"]=getFractureStrainAxisym(folder,2.5)
        elif name=='7GR1':
          data["macroStrain"]=getFractureStrainGR(folder,2)
        elif name=='7GR3':
          data["macroStrain"]=getFractureStrainGR(folder,2)
        elif name=='7GR6':
          data["macroStrain"]=getFractureStrainGR(folder,2)
          
        data.to_csv(os.path.join('./',name+'.csv'),index=False)

        return data



data1L=getStateEvolution('../simulationsData/','1L',1)
data2PL=getStateEvolution('../simulationsData/','2PL',1)
data2NS4=getStateEvolution('../simulationsData/','2NS4',1)
data2NS2=getStateEvolution('../simulationsData/','2NS2',1)
data2NS1=getStateEvolution('../simulationsData/','2NS1',1)
data3SHEAR=getStateEvolution('../simulationsData/','3SHEAR',17) #12, 15 or 17
data4SR=getStateEvolution('../simulationsData/','4SR',1)
data5NR4=getStateEvolution('../simulationsData/','5NR4',1)
data7GR6=getStateEvolution('../simulationsData/','7GR6',1)
data7GR3=getStateEvolution('../simulationsData/','7GR3',1)
data7GR1=getStateEvolution('../simulationsData/','7GR1',1)

fractureData = []

#step at fracture
bound1L=214
bound2PL=99
bound2NS4=95
bound2NS2=89
bound2NS1=83
bound3SHEAR=45
bound4SR=1177
bound5NR4=313
bound7GR6=690
bound7GR3=627
bound7GR1=590

fractureData.append(["1L"]+data1L.values[bound1L].tolist())
fractureData.append(["2PL"]+data2PL.values[bound2PL].tolist())
fractureData.append(["2NS4"]+data2NS4.values[bound2NS4].tolist())
fractureData.append(["2NS2"]+data2NS2.values[bound2NS2].tolist())
fractureData.append(["2NS1"]+data2NS1.values[bound2NS1].tolist())
fractureData.append(["4SR"]+data4SR.values[bound4SR].tolist())
fractureData.append(["5NR4"]+data5NR4.values[bound5NR4].tolist())
fractureData.append(["7GR6"]+data7GR6.values[bound7GR6].tolist())
fractureData.append(["7GR3"]+data7GR3.values[bound7GR3].tolist())
fractureData.append(["7GR1"]+data7GR1.values[bound7GR1].tolist())

p= pd.DataFrame(fractureData, columns=["TestName"]+data1L.columns.to_list())
p.to_csv("fractureData.csv",index=False)

