import json
import matplotlib.pyplot as plt
import numpy as np
import os

plt.rcParams.update({'font.size': 14})
plt.close('all')



dataFile = open('../experimentalCurves/fractureStrain.json', 'r') 
data = json.load(dataFile)

plt.figure()


shapeFactor=data["Shape factor"]

ThinTest= ["1L","2PL","2NS4","2NS2","2NS1"]
markerStyle=["rx","ro","r+","r>","rv"]
meanValueThin = []
for test in ThinTest:
	fracStrainTest=data[test]
	meanValueThin.append(np.mean(fracStrainTest))
	plt.plot([shapeFactor[test]]*len(fracStrainTest),fracStrainTest, markerStyle[ThinTest.index(test)],label=test,markersize=8)

axisTest=["4SR","5NR4"]
markerStyle=["g+","go"]
meanValueAxis=[]
for test in axisTest:
	fracStrainTest=data[test]
	meanValueAxis.append(np.mean(fracStrainTest))
	plt.plot([shapeFactor[test]]*len(fracStrainTest),fracStrainTest, markerStyle[axisTest.index(test)],label=test,markersize=8)
	
groovedTest=["7GR6","7GR3","7GR1"]
markerStyle=["bd","bo","b*"]
meanValueGrooved=[]
for test in groovedTest:
	fracStrainTest=data[test]
	meanValueGrooved.append(np.mean(fracStrainTest))
	plt.plot([shapeFactor[test]]*len(fracStrainTest),fracStrainTest, markerStyle[groovedTest.index(test)],label=test,markersize=8)

# Add empty dummy legend items
plt.plot(np.zeros(1), np.zeros(1), color='w', alpha=0, label=' ')
plt.plot([shapeFactor[c] for c in ThinTest],meanValueThin,"r-",label="Plate specimens")
plt.plot([shapeFactor[c] for c in axisTest],meanValueAxis,"g--",label="Cylindrical specimens")
plt.plot([shapeFactor[c] for c in groovedTest],meanValueGrooved,"b:",label="Plane strain specimens",linewidth=2)

# Add empty dummy legend items
plt.plot(np.zeros(1), np.zeros(1), color='w', alpha=0, label=' ')

plt.ylim([0.2,1.4])
plt.xlabel("Shape factor")
plt.ylabel("Fracture strain")
plt.legend(ncol=3,loc="lower center",fontsize=12)


plt.savefig("expFractureStrain.eps")
os.system("epstopdf expFractureStrain.eps")

plt.show()
