import pandas as pd
import matplotlib.pyplot as plt
import os

def getXYData(xfull, yfull, N):
     return xfull, yfull

plt.rcParams.update({'font.size': 14})
plt.close('all')


plt.figure()

ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_V_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-',label='Experiment, 1L')
ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_V_03.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')
ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')

ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_VI_03.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')
ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')
ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_VII_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')
ex = pd.read_csv('../experimentalCurves/exp-1L/exp_1L_VII_03.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')


"""
exMean = pd.read_csv('../experimentalCurves/exp-2PL/exp_2PLMean.csv')
xv, yv = getXYData(exMean['EngStrain'].values,exMean['EngStress'].values,30)
plt.plot(xv, yv,'g--',label='Experiment, 2PL')

"""
ex = pd.read_csv('../experimentalCurves/exp-2PL/exp_2PL_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--',label='Experiment, 2PL')
ex = pd.read_csv('../experimentalCurves/exp-2PL/exp_2PL_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')
ex = pd.read_csv('../experimentalCurves/exp-2PL/exp_2PL_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')


"""
exMean = pd.read_csv('../experimentalCurves/exp-3SHEAR/exp_3SHEARMean.csv')
xv, yv = getXYData(exMean['EngStrain'].values,exMean['EngStress'].values,20)
plt.plot(xv, yv,'b.',label='Experiment, 3SHEAR')
"""
ex = pd.read_csv('../experimentalCurves/exp-3SHEAR/exp_3SHEAR_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:',label='Experiment, 3SHEAR')
ex = pd.read_csv('../experimentalCurves/exp-3SHEAR/exp_3SHEAR_VI_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:')

plt.xlabel('Engineering strain')
plt.ylabel('Engineering stress (MPa)')
plt.legend(loc='center',fontsize=12, bbox_to_anchor=(0.65,0.25),)
plt.savefig('expEngineeringCurves1L2PL.eps',bbox_inches="tight")
os.system('epstopdf expEngineeringCurves1L2PL.eps')

plt.figure()

"""

exMean = pd.read_csv('../experimentalCurves/exp-2NS1/exp_2NS1_VII_01.csv')
xv, yv = getXYData(exMean['EngStrain'].values,exMean['EngStress'].values,20)
plt.plot(xv, yv,'r-',label='Experiment, 2NS1')
"""
ex = pd.read_csv('../experimentalCurves/exp-2NS1/exp_2NS1_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-',label='Experiment, 2NS1')
ex = pd.read_csv('../experimentalCurves/exp-2NS1/exp_2NS1_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')

"""

exMean = pd.read_csv('../experimentalCurves/exp-2NS2/exp_2N2Mean.csv')
xv, yv = getXYData(exMean['EngStrain'].values,exMean['EngStress'].values,20)
plt.plot(xv, yv,'g--',label='Experiment, 2NS2')
"""
ex = pd.read_csv('../experimentalCurves/exp-2NS2/exp_2NS2_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--',label='Experiment, 2NS2')
ex = pd.read_csv('../experimentalCurves/exp-2NS2/exp_2NS2_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')

"""
exMean = pd.read_csv('../experimentalCurves/exp-2NS4/exp_2N4Mean.csv')
xv, yv = getXYData(exMean['EngStrain'].values,exMean['EngStress'].values,20)
plt.plot(xv, yv,'b:',label='Experiment, 2NS4')
"""
ex = pd.read_csv('../experimentalCurves/exp-2NS4/exp_2NS4_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:',label='Experiment, 2NS4')
ex = pd.read_csv('../experimentalCurves/exp-2NS4/exp_2NS4_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:')
ex = pd.read_csv('../experimentalCurves/exp-2NS4/exp_2NS4_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:')

plt.xlabel('Engineering strain')
plt.ylabel('Engineering stress (MPa)')
plt.legend(fontsize=12)
plt.savefig('expEngineeringCurves2NS.eps',bbox_inches="tight")
os.system('epstopdf expEngineeringCurves2NS.eps')

plt.figure()

ex = pd.read_csv('../experimentalCurves/exp-4SR/exp_4SR_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-',label='Experiment, 4SR')
ex = pd.read_csv('../experimentalCurves/exp-4SR/exp_4SR_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')

ex = pd.read_csv('../experimentalCurves/exp-5NR4/exp_5NR4_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--',label='Experiment, 5RN4')
ex = pd.read_csv('../experimentalCurves/exp-5NR4/exp_5NR4_VI_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')
ex = pd.read_csv('../experimentalCurves/exp-5NR4/exp_5NR4_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')


plt.xlabel('Engineering strain')
plt.ylabel('Engineering stress (MPa)')
plt.legend(fontsize=12)
plt.savefig('expEngineeringCurvesBar.eps',bbox_inches="tight")
os.system('epstopdf expEngineeringCurvesBar.eps')


plt.figure()

ex = pd.read_csv('../experimentalCurves/exp-7GR1/exp_7G1_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-',label='Experiment, 7GR1')
ex = pd.read_csv('../experimentalCurves/exp-7GR1/exp_7G1_V_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'r-')

ex = pd.read_csv('../experimentalCurves/exp-7GR3/exp_7G3_VI_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--',label='Experiment, 7GR3')
ex = pd.read_csv('../experimentalCurves/exp-7GR3/exp_7G3_VI_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'g--')

ex = pd.read_csv('../experimentalCurves/exp-7GR6/exp_7G6_V_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:',label='Experiment, 7GR6')
ex = pd.read_csv('../experimentalCurves/exp-7GR6/exp_7G6_VII_01.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:')
ex = pd.read_csv('../experimentalCurves/exp-7GR6/exp_7G6_VII_02.csv')
plt.plot(ex['EngStrain'].values, ex['EngStress'].values,'b:')

plt.legend(fontsize=12)
plt.xlabel('Engineering strain')
plt.ylabel('Engineering stress (MPa)')

plt.savefig('expEngineeringCurves7GR.eps',bbox_inches="tight")
os.system('epstopdf expEngineeringCurves7GR.eps')

plt.show()
