import pandas as pd
import matplotlib.pyplot as plt
from scipy import interpolate
import numpy as np
import os
from mpl_toolkits import mplot3d
from matplotlib import cm
import json,sys
from scipy.optimize import minimize
from scipy.optimize import differential_evolution
from mpl_toolkits.mplot3d import Axes3D, art3d
from matplotlib.patches import Circle

sys.path.append('..')
from generateData import *

plt.rcParams.update({'font.size': 12})
plt.close("all")


def OmegaToL(omega):
    theta = (np.arccos(omega))/3
    return np.sqrt(3)*np.tan(theta-np.pi/6)

def LodeToOmega(L):
    theta = np.pi/6 + np.arctan(L/np.sqrt(3))
    return np.cos(3*theta)

def func(T, L, a, b, c, d):
    return a*np.exp(b*T) + c*(1-(np.abs(L))**d)

def error(X):
    a = X[0]
    b = X[1]
    c = X[2]
    d = X[3]

    error = 0
    for i in range(len(T)):
        res = func(T[i], L[i], a, b, c, d)
        error += (1/f[i] - res)**2
    return error


plt.close("all")

dataFile = open('../experimentalCurves/fractureStrain.json', 'r')
pExp =json.load(dataFile)
print(pExp)
simDataFile = pd.read_csv("fractureData.csv")
p=simDataFile.set_index('TestName').transpose()
print(p)



#T=[]
#L =[]
#f = []
#for test in p.columns[1:].tolist():
#    for vv in pExp[test]:
#        f.append(float(vv))
#        T.append(float(p[test][1]))
#        L.append(OmegaToL(float(p[test][2])))

T = p.values[1][:]
print('T=',T)
omega = np.array(p.values[3][:],dtype=float)
L = OmegaToL(omega)
print('L=',L)
f = p.values[4][:]
print('f=',f)


#res = minimize(error, x0=[0.1, 3, 4.24, 1.4])
bounds = [(-5, 5) for i in range(4)]
print(bounds)
res = differential_evolution(error, bounds, seed=1)
print(res)
print(list(res.x))
var = list(res.x)

#x = np.linspace(np.min(T), np.max(T), 30)
#y = np.linspace(np.min(L), np.max(L), 30)
M=130
x = np.linspace(0,2, M)
y = np.linspace(-1, 0, M)

X, Y = np.meshgrid(x, y)
YY = LodeToOmega(Y)
Z = np.zeros((M,M))
for i in range(M):
    for j in range(M):
        Z[i,j] = 1/func(X[i,j], Y[i,j],*var)




fig = plt.figure()
ax = plt.axes(projection='3d')

norm = plt.Normalize(Z.min(), Z.max())
colors = cm.jet(norm(Z))
m = cm.ScalarMappable(cmap=cm.jet)
m.set_array(Z)
plt.colorbar(m) #, location = 'left')

surf = ax.plot_surface(X, YY, Z, facecolors=colors, shade=False, antialiased=True, rstride=1, cstride=1, edgecolor='none')
#surf.set_facecolor((0,0,0,0))


plt.xlim([0, 2])
plt.ylim([0, 1])



plt.xlabel(r"$\eta$")
plt.ylabel(r"$\omega$")
ax.set_zlabel(r"Fracture strain")

plt.savefig("fractureSurface.eps")
os.system("epstopdf fractureSurface.eps")


fig, ax = plt.subplots()

markers=["o","d","v","s","P","D","<","X",">","*"]
i  = 0
for test in p.columns[:].tolist():
    T=[]
    omega = []
    T.append(float(p[test][1]))
    omega.append(float(p[test][3]))
    print(test, T, omega)
    ax.plot(T,omega,f"{markers[i]}", label=f"{test}", markersize=8)
    i = i+1
cp = plt.contour(X, YY, Z, linestyles='solid', cmap=cm.jet, norm = norm, levels=np.linspace(0.5,2,16))
plt.clabel(cp, inline=True, fontsize=12)

plt.xlabel(r"$\eta$")
plt.ylabel(r"$\omega$")

plt.xlim([0, 2])
plt.ylim([0, 1.1])

plt.legend(loc="lower right")

plt.savefig("fractureSurfaceLevelSet.eps")
os.system("epstopdf fractureSurfaceLevelSet.eps")
plt.show()

