import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import os,sys
from os import listdir
from os.path import isfile, join
from scipy.interpolate import *
import json

sys.path.append('..')
from generateData import *


plt.rcParams.update({'font.size': 14})
plt.close('all')


#fracture
dataFile = open('../experimentalCurves/fractureStrain.json', 'r') 
data = json.load(dataFile)
simDataFile = pd.read_csv("fractureData.csv")

numDataFile=simDataFile.set_index('TestName').transpose()
print(numDataFile)

plt.figure()

shapeFactor=data["Shape factor"]
ThinTest= ["1L","2PL","2NS4","2NS2","2NS1"]
meanValueThin = []
stdValueThin = []
for test in ThinTest:
	fracStrainTest=data[test]
	meanValueThin.append(np.mean(fracStrainTest))
	stdValueThin.append(np.std(fracStrainTest))

axisTest=["4SR","5NR4"]
meanValueAxis=[]
stdValueAxis=[]
for test in axisTest:
	fracStrainTest=data[test]
	meanValueAxis.append(np.mean(fracStrainTest))
	stdValueAxis.append(np.std(fracStrainTest))
	
groovedTest=["7GR6","7GR3","7GR1"]
meanValueGrooved=[]
stdValueGrooved=[]
for test in groovedTest:
	fracStrainTest=data[test]
	meanValueGrooved.append(np.mean(fracStrainTest))
	stdValueGrooved.append(np.std(fracStrainTest))




plt.errorbar([shapeFactor[c] for c in ThinTest],meanValueThin,stdValueThin,marker="o",ls="--",label="Exp., Plate")
yFEThin = numDataFile[ThinTest].values

plt.plot([shapeFactor[c] for c in ThinTest],yFEThin[4,:],'ro-',label="Sim., Plate")

plt.errorbar([shapeFactor[c] for c in groovedTest],meanValueGrooved,stdValueGrooved, marker="s",ls="--",label="Exp., Plane strain")
yFEGrooved = numDataFile[groovedTest].values
plt.plot([shapeFactor[c] for c in groovedTest],yFEGrooved[4,:],'ks-',label="Sim., Plane strain")

plt.errorbar([shapeFactor[c] for c in axisTest],meanValueAxis,stdValueAxis,marker="v",ls="--",label="Exp., Cylindrical")  
yFEBar = numDataFile[axisTest].values
plt.plot([shapeFactor[c] for c in axisTest],yFEBar[4,:],'mv-',label="Sim., Cylindrical")

plt.ylim([0.3,1.4])
plt.xlabel("Shape factor")
plt.ylabel("Fracture strain")
plt.legend(ncol=2,loc="lower center",fontsize=12)

plt.savefig("FractureStrain.eps")
os.system("epstopdf FractureStrain.eps")

plt.figure()
plt.errorbar(yFEThin[1,:],meanValueThin,stdValueThin,marker="o",ls="--",label="Exp., Plate")
plt.plot(yFEThin[1,:],yFEThin[4,:],'ro-',label="Sim., Plate")

plt.errorbar(yFEGrooved[1,:],meanValueGrooved,stdValueGrooved,marker="s",ls="--",label="Exp., Plane strain")
plt.plot(yFEGrooved[1,:],yFEGrooved[4,:],'ks-',label="Sim., Plane strain")

plt.errorbar(yFEBar[1,:],meanValueAxis,stdValueAxis,marker="v",ls="--",label="Exp., Cylindrical")
plt.plot(yFEBar[1,:],yFEBar[4,:],'mv-',label="Sim., Cylindrical")

plt.ylim([0.3,1.4])
plt.xlabel("Stress triaxiality")
plt.ylabel("Fracture strain")
plt.legend(ncol=2,loc="lower center",fontsize=12)

plt.savefig("TriaxFractureStrain.eps")
os.system("epstopdf TriaxFractureStrain.eps")


plt.figure()
plt.errorbar(yFEThin[3,:],meanValueThin,stdValueThin,marker="o",ls="--",label="Exp., Plate")
plt.plot(yFEThin[3,:],yFEThin[4,:],'ro-',label="Sim., Plate")

plt.errorbar(yFEGrooved[3,:],meanValueGrooved,stdValueGrooved,marker="s",ls="--",label="Exp., Plane strain")
plt.plot(yFEGrooved[3,:],yFEGrooved[4,:],'ks-',label="Sim., Plane strain")

plt.errorbar(yFEBar[3,:],meanValueAxis,stdValueAxis,marker="v",ls="--",label="Exp., Cylindrical")
plt.plot(yFEBar[3,:],yFEBar[4,:],'mv-',label="Sim., Cylindrical")

plt.ylim([0.3,1.4])
plt.xlabel("Lode variable")
plt.ylabel("Fracture strain")
plt.legend(ncol=2,loc="lower center",fontsize=12)

plt.savefig("LodeFractureStrain.eps")
os.system("epstopdf LodeFractureStrain.eps")


plt.show()
