import pandas as pd
import matplotlib.pyplot as plt
from scipy import interpolate
import numpy as np
import os,sys
from mpl_toolkits import mplot3d

plt.rcParams.update({'font.size': 14})
plt.close("all")

sys.path.append('..')
from generateData import *


plt.figure()

data = pd.read_csv("1L.csv")
plt.plot(data["eps"].values[0:bound1L],data["triax"].values[0:bound1L],"r-", label = "1L" )

data = pd.read_csv("2PL.csv")
plt.plot(data["eps"].values[0:bound2PL],data["triax"].values[0:bound2PL],"r--", label = "2PL" )
#
data = pd.read_csv("2NS4.csv")
plt.plot(data["eps"].values[0:bound2NS4],data["triax"].values[0:bound2NS4],"r:", label = "2NS4" )


#
data = pd.read_csv("2NS2.csv")
plt.plot(data["eps"].values[0:bound2NS2],data["triax"].values[0:bound2NS2],"r-.", label = "2NS2" )


data = pd.read_csv("2NS1.csv")
plt.plot(data["eps"].values[0:bound2NS1],data["triax"].values[0:bound2NS1], "r.-",label = "2NS1" )

data = pd.read_csv("3SHEAR.csv")
plt.plot(data["eps"].values[0:bound3SHEAR],data["triax"].values[0:bound3SHEAR],"g-" ,label = "3SHEAR" )
#
data = pd.read_csv("4SR.csv")
plt.plot(data["eps"].values[0:bound4SR],data["triax"].values[0:bound4SR],"b-" ,label = "4SR" )


data = pd.read_csv("5NR4.csv")
plt.plot(data["eps"].values[0:bound5NR4],data["triax"].values[0:bound5NR4],"b--" ,label = "5NR4" )


data = pd.read_csv("7GR6.csv")
plt.plot(data["eps"].values[0:bound7GR6],data["triax"].values[0:bound7GR6], "k-",label = "7GR6" )


data = pd.read_csv("7GR3.csv")
plt.plot(data["eps"].values[0:bound7GR3],data["triax"].values[0:bound7GR3], "k--",label = "7GR3" )


data = pd.read_csv("7GR1.csv")
plt.plot(data["eps"].values[0:bound7GR1],data["triax"].values[0:bound7GR1], "k:",label = "7GR1" )

plt.legend(ncol=1,loc = "center right")

plt.xlabel('Equivalent plastic strain')
plt.ylabel('Stress triaxiality')
plt.xlim([-0.1,2])
plt.ylim([0,1.6])
plt.savefig('triaxAll.eps',bbox_inches="tight")
os.system('epstopdf triaxAll.eps')


plt.figure()


data = pd.read_csv("1L.csv")
plt.plot(data["eps"].values[0:bound1L],data["omega"].values[0:bound1L],"r-", label = "1L" )

data = pd.read_csv("2PL.csv")
plt.plot(data["eps"].values[0:bound2PL],data["omega"].values[0:bound2PL],"r--", label = "2PL" )
#
#
data = pd.read_csv("2NS4.csv")
plt.plot(data["eps"].values[0:bound2NS4],data["omega"].values[0:bound2NS4],"r:", label = "2NS4" )
#
#
data = pd.read_csv("2NS2.csv")
plt.plot(data["eps"].values[0:bound2NS2],data["omega"].values[0:bound2NS2],"r-.", label = "2NS2" )
#
data = pd.read_csv("2NS1.csv")
plt.plot(data["eps"].values[0:bound2NS1],data["omega"].values[0:bound2NS1], "r.-",label = "2NS1" )

data = pd.read_csv("3SHEAR.csv")
plt.plot(data["eps"].values[0:bound3SHEAR],data["omega"].values[0:bound3SHEAR],"g-" ,label = "3SHEAR" )
#
data = pd.read_csv("4SR.csv")
plt.plot(data["eps"].values[0:bound4SR],data["omega"].values[0:bound4SR],"b-" ,label = "4SR" )

data = pd.read_csv("5NR4.csv")
plt.plot(data["eps"].values[0:bound5NR4],data["omega"].values[0:bound5NR4],"b--" ,label = "5NR4" )
#
data = pd.read_csv("7GR6.csv")
plt.plot(data["eps"].values[0:bound7GR6],data["omega"].values[0:bound7GR6], "k-",label = "7GR6" )

data = pd.read_csv("7GR3.csv")
plt.plot(data["eps"].values[0:bound7GR3],data["omega"].values[0:bound7GR3], "k--",label = "7GR3" )

data = pd.read_csv("7GR1.csv")
plt.plot(data["eps"].values[0:bound7GR1],data["omega"].values[0:bound7GR1], "k:",label = "7GR1" )


plt.xlabel('Equivalent plastic strain')
plt.ylabel('Lode variable')
plt.xlim([-0.1,2])
plt.legend(loc = "center right")
plt.savefig('lodeAll.eps',bbox_inches="tight")
os.system('epstopdf lodeAll.eps')

plt.figure()

data = pd.read_csv("1L.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"r-", label = "1L" )

data = pd.read_csv("2PL.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"r--", label = "2PL" )


data = pd.read_csv("2NS4.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"r-.", label = "2NS4" )

data = pd.read_csv("2NS2.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"r:", label = "2NS2" )

data = pd.read_csv("2NS1.csv")
plt.plot(data["eps"].values,data["macroStrain"].values, "rx-",label = "2NS1" )

data = pd.read_csv("4SR.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"g--" ,label = "4SR" )

data = pd.read_csv("5NR4.csv")
plt.plot(data["eps"].values,data["macroStrain"].values,"m--" ,label = "5NR4" )
print(data["macroStrain"].values[-1])

data = pd.read_csv("7GR6.csv")
plt.plot(data["eps"].values,data["macroStrain"].values, "b-",label = "7GR6" )


data = pd.read_csv("7GR3.csv")
plt.plot(data["eps"].values,data["macroStrain"].values, "b--",label = "7GR3" )


data = pd.read_csv("7GR1.csv")
plt.plot(data["eps"].values,data["macroStrain"].values, "b--",label = "7GR1" )

plt.plot([0,1.5],[0,1.5], "k-",label = "Equal line" )


plt.legend(ncol=3, bbox_to_anchor=(0.11,1),loc = "upper left")

plt.ylabel('MacroStrain')
plt.savefig('macroStrain.eps',bbox_inches="tight")
os.system('epstopdf macroStrain.eps')



plt.figure()

data = pd.read_csv("1L.csv")
plt.plot(data["eps"].values,data["triax"].values,"rx-", label = "1L" )


data = pd.read_csv("2PL.csv")
plt.plot(data["eps"].values,data["triax"].values,"rx--", label = "2PL" )


data = pd.read_csv("2NS4.csv")
plt.plot(data["eps"].values,data["triax"].values,"rv-.", label = "2NS4" )

data = pd.read_csv("2NS2.csv")
plt.plot(data["eps"].values,data["triax"].values,"rv:", label = "2NS2" )

data = pd.read_csv("2NS1.csv")
plt.plot(data["eps"].values,data["triax"].values, "rx-",label = "2NS1" )

plt.show()
