import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import os
from os import listdir
from os.path import isfile, join
from scipy.interpolate import *
import json

plt.rcParams.update({'font.size': 14})
plt.close('all')

def getAverageResponse(srcDir, prefix, N):
	"""
	Args:
		srcDir contains all files
		prefix a string in filename to load
		N number of sampling point
	Returns:
		average strain and stress
	"""
	onlyfiles = [f for f in listdir(srcDir) if isfile(join(srcDir, f)) and prefix == f[:len(prefix)]]
	if len(onlyfiles) ==0:
		print(f"three is no data in {srcDir} with prefix {prefix}")
		return None, None
	data = pd.read_csv(join(srcDir, onlyfiles[0]))	
	xdata = data['EngStrain'].values
	ydata = data['EngStress'].values
	XX = xdata[np.logical_not(np.isnan(ydata))]
	YY = ydata[np.logical_not(np.isnan(ydata))]
	fct = interp1d(XX, YY)
	epsData = np.linspace(XX[0],XX[-1],N)
	sigData = fct(epsData)
	numTest = 1
	for f in onlyfiles[1:]:
		numTest = numTest+1
		data = pd.read_csv(join(srcDir, f))	
		xdata = data['EngStrain'].values
		ydata = data['EngStress'].values
		XX = xdata[np.logical_not(np.isnan(ydata))]
		YY = ydata[np.logical_not(np.isnan(ydata))]
		fct = interp1d(XX, YY, bounds_error=False)
		sigData += fct(epsData)
	sigData *=(1./numTest)
	return epsData, sigData


def getPorosityEvolution(srcDir, physical):
	"""
	Args:
		srcDir contains all files
		physical number of numverXXX.csv
	Returns:
		distance, plastic strain, porosity
	"""
	numver=pd.read_csv(srcDir+'/numver'+str(physical)+'.csv', header=None, sep = ';')
	tab=numver.values
	z=[]
	ind=[]
	epl=[]
	por=[]
	for line in range(len(tab)):
	  z.append(-1.*tab[line][3])
	  ind.append(int(tab[line][0]))
	indsorted = [x for _,x in sorted(zip(z,ind))]
	zsorted = [x for _,x in sorted(zip(z,z))]
	#print(indsorted,zsorted)
	for line in range(len(zsorted)):
	  eplloc=pd.read_csv(srcDir+'/IP'+str(indsorted[line])+'val_PLASTICSTRAIN.csv', header=None, sep = ';')
	  porloc=pd.read_csv(srcDir+'/IP'+str(indsorted[line])+'val_LOCAL_POROSITY.csv', header=None, sep = ';')
	  epl.append((eplloc.values)[-1][1])
	  por.append((porloc.values)[-1][1])
	return zsorted,epl,por

zsorted,epl,por=getPorosityEvolution('../simulationsData/2PL',11)

### porosity in 2PL
plt.figure()
ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_V_1.csv')
plt.plot(ex['distance'].values, ex['porosity'].values,'r.',label=r'$1^{st}$ specimen')
ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_VI_1.csv')
plt.plot(ex['distance'].values, ex['porosity'].values,'g+',label=r'$2^{nd}$ specimen')
ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_VII_1.csv')
plt.plot(ex['distance'].values, ex['porosity'].values,'bx',label='$3^{rd}$ specimen')

#fe = pd.read_csv('../simulationsData/porosity_2PL.csv')
plt.plot(zsorted, por,'k-',label="GTN-Th-Sh, 2PL")

plt.legend()
plt.xlabel('Distance from the crack surface (mm)', fontsize=14)
plt.ylabel(r'Porosity $f_\mathrm{V}$', fontsize=14)
plt.savefig('comparison_porosity_vs_d.eps', bbox_inches='tight')
os.system('epstopdf comparison_porosity_vs_d.eps')

plt.show()



