import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import os


plt.rcParams.update({'font.size': 14})
plt.close('all')


plt.figure()
ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_V_1.csv')
x1 = ex['distance'].values
y1 = ex['porosity'].values
plt.plot(x1,y1,'r.',label=r'$1^{st}$ specimen')

ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_VI_1.csv')
x2 = ex['distance'].values
y2 = ex['porosity'].values
plt.plot(x2,y2,'g+',label=r'$2^{nd}$ specimen')

ex = pd.read_csv('../experimentalCurves/exp-2PL/porosity_2PL_VII_1.csv')
x3 = ex['distance'].values
y3 = ex['porosity'].values
plt.plot(x3,y3,'bx',label='$3^{rd}$ specimen')

x = x1
y = (y1+y2+y3)/3
plt.plot(x,y,'k-', linewidth=1.5,label='Average')


plt.legend()
plt.xlabel('Distance from the crack surface (mm)', fontsize=14)
plt.ylabel(r'Porosity $f_\mathrm{V}$', fontsize=14)
plt.savefig('porosity_vs_d.eps', bbox_inches='tight')
os.system('epstopdf porosity_vs_d.eps')

plt.show()
