function [trackingRadiusPx, pixelSize] = tracking_radius_conversion(trackingRadiusPx, pixelSize)

%Small ui where user can convert the tracking radius in pixels to microns

if nargin == 0
    trackingRadiusPx = 0;
    pixelSize = 1;
end


figure('Units','normalized',...
    'Position',[0.1 0.5 .2 .2],...
    'MenuBar','None',...
    'Name','Track radius conversion',...
    'NumberTitle','off',...
    'WindowKeyPressFcn',@KeyPressFcnCB,...
    'CloseRequestFcn',@CancelCB);

editHeight = .12;
editWidth = .15;

textPixelsize = uicontrol(...
    'Units','normalized',...
    'Position', [.05  .8  .7 .1],...
    'Style','text',...
    'FontSize',10,...
    'String','Pixelsize in microns per px:',...
    'HorizontalAlignment','Left');

editPixelSize = uicontrol(...
    'Units','normalized',...
    'Position', [.7  .8  editWidth editHeight],...
    'FontSize',9,...
    'Style','Edit',...
    'String', pixelSize);


textTrackingRadiusPx = uicontrol(...
    'Units','normalized',...
    'Position', [.05  .55  .4 .1],...
    'Style','text',...
    'FontSize',10,...
    'String','Trackin radius (px)',...
    'HorizontalAlignment','Left');

editTrackingRadiusPx = uicontrol(...
    'Units','normalized',...
    'Position', [.1  .4  editWidth editHeight],...
    'FontSize',9,...
    'Style','Edit',...
    'String', trackingRadiusPx,...
    'Callback',@ConvertToMuCB);

textTrackingRadiusMu = uicontrol(...
    'Units','normalized',...
    'Position', [.6  .55  .4 .1],...
    'Style','text',...
    'FontSize',10,...
    'String','Tracking radius (µm)',...
    'HorizontalAlignment','Left');

editTrackingRadiusMu = uicontrol(...
    'Units','normalized',...
    'Position', [.7  .4  editWidth editHeight],...
    'FontSize',9,...
    'Style','Edit',...
    'String', '',...
    'Callback',@ConvertToPxCB);

btnPixToMu = uicontrol('String','>>',...
    'Units','normalized',...
    'Position',[.45 0.5 .1 .1],...
    'Callback',@ConvertToMuCB);

btnMuToPx = uicontrol('String','<<',...
    'Units','normalized',...
    'Position',[.45 0.35 .1 .1],...
    'Callback',@ConvertToPxCB);

btnUseInTrackIt = uicontrol('String','Use for tracking',...
    'Units','normalized',...
    'Position',[.15 0.05 .3 .15],...
    'Callback',@UseInTrackItCB);


btnCancel = uicontrol('String','Cancel',...
    'Units','normalized',...
    'Position',[.55 0.05 .3 .15],...
    'Callback',@CancelCB);

%Convert tracking radius passed to the function from TrackIt into microns
ConvertToMuCB()

%Wait for user to close figure
uiwait()

    function ConvertToMuCB(~,~) 
        %Convert from pixels to microns
        editTrackingRadiusMu.String = round(str2double(editTrackingRadiusPx.String) / str2double(editPixelSize.String),2);
    end

    function ConvertToPxCB(~,~)
        %Convert from microns to pixels
        editTrackingRadiusPx.String = round(str2double(editTrackingRadiusMu.String) * str2double(editPixelSize.String),2);
    end

    function UseInTrackItCB(~,~)
        %Close figure and pass values to TrackIt
        trackingRadiusPx = editTrackingRadiusPx.String;
        pixelSize = editPixelSize.String;
        delete(gcf)
    end

    function CancelCB(~,~)
        %User closed figure so delete figure and pass empty values to TrackIt
        trackingRadiusPx = [];
        pixelSize = [];
        delete(gcf)
    end

    function KeyPressFcnCB(~,event)
        %Close figure if esc is pressed
        if strcmp(event.Key, 'escape')            
            trackingRadiusPx = [];
            pixelSize = [];
            delete(gcf)
        end
    end

end