function plotSettings = set_scalebar(ui, scalebarHandle, scalebarTextHandle, plotSettings)

%Small ui where the user can change the scalebar settings of the plot in
%the TrackIt GUI

S = CreatePlotPropertiesUI();
read_curPlot()

position = [plotSettings.sbPos(1), plotSettings.sbPos(2), plotSettings.sbDim(1), plotSettings.sbDim(2)];
ROIHandle = drawrectangle(ui.axes1,'Position', position);
addlistener(ROIHandle,'MovingROI',@SbMovedCB);

uiwait(S.f);

    function S = CreatePlotPropertiesUI()
        
        textPosHor = .05;
        textHeight = .07;
        textWidth = .5;
        editWidth = .15;
        editPosHor = 0.6;
        editHeight = textHeight;
        vertDist = 0.15;
        buttonWidth = .3;
        
        S.f = figure('Units','normalized',...
            'Position',[0.1 0.2 .2 .3],...
            'MenuBar','None',...
            'Name','Scalebar settings',...
            'NumberTitle','off',...
            'WindowKeyPressFcn',@KeyPressFcnCB,...
            'CloseRequestFcn',@CloseRequestCB);
                        
        textsbPos = uicontrol('String','Scalebar position: hor(x), vert(y)',...
            'Style','Text',...
            'Units','normalized',...
            'HorizontalAlignment','Left',...
            'Position',[textPosHor  1-vertDist textWidth  textHeight]); 
        
        S.editsbPosX = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbPosX',...
            'Callback',@EditCB,...
            'Position',[editPosHor 1-vertDist editWidth editHeight]); 
        
        S.editsbPosY = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbPosY',...
            'Callback',@EditCB,...
            'Position',[editPosHor+.2 1-vertDist editWidth editHeight]); 
                
        textsbDim = uicontrol('String','Scalebar dimensions: hor(x), vert(y)',...
            'Style','Text',...
            'Units','normalized',...
            'HorizontalAlignment','Left',...
            'Position',[textPosHor  1-vertDist*2  textWidth  textHeight]); 
        
        S.editsbDimX = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbDimX',...
            'Callback',@EditCB,...
            'Position',[editPosHor 1-vertDist*2 editWidth editHeight]);
        
        
        S.editsbDimY = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbDimY',...
            'Callback',@EditCB,...
            'Position',[editPosHor+.2 1-vertDist*2 editWidth editHeight]);
        
        
        textSbTextPos = uicontrol('String','Scalebar text position:  hor(x), vert(y)',...
            'Style','Text',...
            'Units','normalized',...
            'HorizontalAlignment','Left',...
            'Position',[textPosHor  1-vertDist*3 textWidth  textHeight]);
        
        S.editSbTextPosX = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbTextPosX',...
            'Callback',@EditCB,...
            'Position',[editPosHor 1-vertDist*3 editWidth editHeight]);  
        
        
        S.editSbTextPosY = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbTextPosY',...
            'Callback',@EditCB,...
            'Position',[editPosHor+.2 1-vertDist*3 editWidth editHeight]);  
        
        textSbText = uicontrol('String','Scalebar text: ',...
            'Style','Text',...
            'Units','normalized',...
            'HorizontalAlignment','Left',...
            'Position',[textPosHor  1-vertDist*4 textWidth  textHeight]); 
        
        S.editSbText = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbText',...
            'Callback',@EditCB,...
            'Position',[editPosHor 1-vertDist*4 editWidth editHeight]);
        
        textSbTextSize = uicontrol('String','Scalebar font size: ',...
            'Style','Text',...
            'Units','normalized',...
            'HorizontalAlignment','Left',...
            'Position',[textPosHor  1-vertDist*5  textWidth  textHeight]);
        
        S.editSbTextSize = uicontrol('String','',...
            'Style','Edit',...
            'Units','normalized',...
            'Tag','sbFontSize',...
            'Callback',@EditCB,...
            'Position',[editPosHor 1-vertDist*5 editWidth editHeight]);
        
        drawSbButton = uicontrol('String','Draw scalebar',...
            'Units','normalized',...
            'Position',[.02 0.02 buttonWidth textHeight*1.5],...
            'Callback',@DrawSbCB);
                  
        autoSetTextButton = uicontrol('String','Autoset text position',...
            'Units','normalized',...
            'Position',[.35 0.02 buttonWidth textHeight*1.5],...
            'Callback',@AutoSetTextPosCB);
        
        okButton = uicontrol('String','OK',...
            'Units','normalized',...
            'Position',[.68 0.02 buttonWidth textHeight*1.5],...
            'Callback',@OkCB);
        
        
    end

    function read_curPlot()
        S.editsbPosX.String = num2str(plotSettings.sbPos(1));
        S.editsbPosY.String = num2str(plotSettings.sbPos(2));
        S.editsbDimX.String = num2str(plotSettings.sbDim(1));
        S.editsbDimY.String = num2str(plotSettings.sbDim(2));
        S.editSbTextPosX.String = num2str(plotSettings.sbTextPos(1));
        S.editSbTextPosY.String = num2str(plotSettings.sbTextPos(2));
        S.editSbTextSize.String = plotSettings.sbTextSize;
        S.editSbText.String = plotSettings.sbTextString;
    end

    function CloseRequestCB(~,~)
        delete(ROIHandle)
        plotSettings = [];
        delete(gcf)
    end

    function KeyPressFcnCB(~,event)
        if strcmp(event.Key, 'escape')
            delete(ROIHandle)
            CloseRequestCB()
        end
    end

    function EditCB(~,~)
        
        plotSettings.sbPos = [str2double(S.editsbPosX.String), str2double(S.editsbPosY.String)];
        plotSettings.sbDim = [str2double(S.editsbDimX.String), str2double(S.editsbDimY.String)];
        plotSettings.sbTextPos = [str2double(S.editSbTextPosX.String), str2double(S.editSbTextPosY.String)];
        plotSettings.sbTextString = S.editSbText.String;
        plotSettings.sbTextSize = str2double(S.editSbTextSize.String);       
        ROIHandle.Position = [plotSettings.sbPos, plotSettings.sbDim];
        PlotScalebar()
    end

    function SbMovedCB(~,evt)
        distance = evt.CurrentPosition - evt.PreviousPosition;
        
        plotSettings.sbPos = evt.CurrentPosition(1:2);
        plotSettings.sbDim = evt.CurrentPosition(3:4);
        
        plotSettings.sbTextPos = plotSettings.sbTextPos + distance(1:2);
        
        read_curPlot()
        PlotScalebar()
    end


    function DrawSbCB(~,~)
        delete(ROIHandle)
        ROIHandle = drawrectangle(ui.axes1);
        addlistener(ROIHandle,'MovingROI',@SbMovedCB); 
        
        plotSettings.sbPos = ROIHandle.Position(1:2);
        plotSettings.sbDim = ROIHandle.Position(3:4);

        read_curPlot()
        PlotScalebar()
        
        figure(S.f)
    end

    function PlotScalebar()
        xPos = plotSettings.sbPos(1);
        yPos = plotSettings.sbPos(2);
        xDim = plotSettings.sbDim(1);
        yDim = plotSettings.sbDim(2);
        
        set(scalebarHandle,'xdata',[xPos, xPos, xPos+xDim, xPos+xDim, xPos],...
            'ydata',[yPos, yPos+yDim, yPos+yDim, yPos, yPos]);

        scalebarTextHandle.String = plotSettings.sbTextString;
        scalebarTextHandle.Position = [xPos, yPos+yDim+1];
        scalebarTextHandle.FontSize = plotSettings.sbTextSize;
        scalebarTextHandle.Position = plotSettings.sbTextPos;
        
    end

    function AutoSetTextPosCB(~,~)
        
        xPos = plotSettings.sbPos(1);
        yPos = plotSettings.sbPos(2);
        xDim = plotSettings.sbDim(1);
        yDim = plotSettings.sbDim(2);
        
        plotSettings.sbTextPos(1) = xPos + xDim/4;
        plotSettings.sbTextPos(2) = yPos+yDim;
        
        read_curPlot()
        PlotScalebar()
    end

    function OkCB(~,~)
        
        delete(ROIHandle)
        delete(gcf)
    end

 
end
